/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class HelperDT {
    private static String strDateYYYYMMDD = "yyyyMMdd";
    private static String strDateYYYYMM = "yyyyMM";
    private static String strDateYYYY = "yyyy";
    private static String strDateMMYYYY = "MM.yyyy";
    private static String strDateDDMMYYYY = "dd.MM.yyyy";
    private static String strDateDDMMYY = "dd.MM.yy";
    private static String strTimeHHMMSS = "HH:mm:ss";
    private static String strTimeHHMM = "HH:mm";
    private static SimpleDateFormat sdf = new SimpleDateFormat();

    private HelperDT() {
    }

    public static final String getDDMMYY(Date dat) {
        return HelperDT.getDDMMYY(dat, Locale.getDefault());
    }

    public static final String getDDMMYY(Date date, Locale loc) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(HelperDT.getLocalizedPattern(loc)[7]);
            return sdf.format(dat);
        }
    }

    public static final String getDDMMYYYY(Date dat) {
        return HelperDT.getDDMMYYYY(dat, Locale.getDefault());
    }

    public static final String getDDMMYYYY(Date date, Locale loc) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(HelperDT.getLocalizedPattern(loc)[6]);
            return sdf.format(dat);
        }
    }

    public static final String getHHMM(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strTimeHHMM);
            return sdf.format(dat);
        }
    }

    public static final String getHHMMSS(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strTimeHHMMSS);
            return sdf.format(dat);
        }
    }

    public static String[] getLocalizedPattern(Locale loc) {
        String[] s = null;
        try {
            ResourceBundle resource = ResourceBundle.getBundle("java.text.resources.LocaleElements", loc);
            s = resource.getStringArray("DateTimePatterns");
        }
        catch (Throwable throwable) {}
        if (s == null || s.length < 8) {
            s = new String[]{"H.mm' Uhr 'z", "HH:mm:ss z", "HH:mm:ss", "HH:mm", "EEEE, d. MMMM yyyy", "d. MMMM yyyy", "dd.MM.yyyy", "dd.MM.yy"};
        }
        return s;
    }

    public static final String getMMYYYY(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strDateMMYYYY);
            return sdf.format(dat);
        }
    }

    public static final String getRuntimeDHMS(long lngMS) {
        long lngTime = lngMS / 1000L;
        int intS = (int)(lngTime % 60L);
        int intM = (int)((lngTime /= 60L) % 60L);
        int intH = (int)((lngTime /= 60L) % 24L);
        int intD = (int)(lngTime /= 24L);
        return intD + "d " + intH + "h " + intM + "m " + intS + "s";
    }

    public static final String getYYYY(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strDateYYYY);
            return sdf.format(dat);
        }
    }

    public static final String getYYYYMM(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strDateYYYYMM);
            return sdf.format(dat);
        }
    }

    public static final String getYYYYMMDD(Date date) {
        Date dat;
        if (date == null) {
            dat = new Date();
        }
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            sdf.applyPattern(strDateYYYYMMDD);
            return sdf.format(dat);
        }
    }
}

