/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xbill.DNS.Name;
import org.xbill.DNS.TypeMap;

class NameSet {
    private Hashtable data = new Hashtable();
    private Name origin = Name.root;
    private boolean isCache;

    protected NameSet(boolean isCache) {
        this.isCache = isCache;
    }

    protected void addSet(Name name, short type, Object set) {
        TypeMap nameInfo = this.findName(name);
        if (nameInfo == null) {
            nameInfo = new TypeMap();
            this.data.put(name, nameInfo);
        }
        TypeMap typeMap = nameInfo;
        synchronized (typeMap) {
            nameInfo.put(type, set);
        }
    }

    protected void clear() {
        this.data = new Hashtable();
    }

    protected Object findExactSet(Name name, short type) {
        TypeMap nameInfo = this.findName(name);
        if (nameInfo == null) {
            return null;
        }
        return nameInfo.get(type);
    }

    protected TypeMap findName(Name name) {
        return (TypeMap)this.data.get(name);
    }

    protected Object findSets(Name name, short type) {
        int olabels;
        Object bestns = null;
        if (!name.subdomain(this.origin)) {
            return null;
        }
        byte labels = name.labels();
        int tlabels = olabels = this.origin.labels();
        while (tlabels <= labels) {
            Name tname = tlabels == olabels ? this.origin : (tlabels == labels ? name : new Name(name, labels - tlabels));
            TypeMap nameInfo = this.findName(tname);
            if (nameInfo != null) {
                Object o;
                if (tlabels == labels && type == 255) {
                    return nameInfo.getAll();
                }
                if ((tlabels > olabels || this.isCache) && (o = nameInfo.get((short)2)) != null) {
                    if (this.isCache) {
                        bestns = o;
                    } else {
                        return o;
                    }
                }
                if (tlabels == labels && (o = nameInfo.get(type)) != null) {
                    return o;
                }
                o = nameInfo.get((short)5);
                if (o != null) {
                    if (labels == tlabels) {
                        return o;
                    }
                    return null;
                }
                if (tlabels < labels && (o = nameInfo.get((short)39)) != null) {
                    return o;
                }
                if (tlabels == labels && this.isCache && (o = nameInfo.get((short)0)) != null) {
                    return o;
                }
                if (tlabels == labels) {
                    return nameInfo;
                }
            }
            ++tlabels;
        }
        if (bestns == null) {
            return null;
        }
        return bestns;
    }

    Enumeration names() {
        return this.data.keys();
    }

    protected void removeName(Name name) {
        this.data.remove(name);
    }

    protected void removeSet(Name name, short type, Object set) {
        TypeMap nameInfo = this.findName(name);
        if (nameInfo == null) {
            return;
        }
        Object o = nameInfo.get(type);
        if (o != set && type != 5) {
            type = (short)5;
            o = nameInfo.get(type);
        }
        if (o == set) {
            TypeMap typeMap = nameInfo;
            synchronized (typeMap) {
                nameInfo.remove(type);
            }
            if (nameInfo.isEmpty()) {
                this.data.remove(name);
            }
        }
    }

    protected void setOrigin(Name origin) {
        this.origin = origin;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            TypeMap nameInfo = (TypeMap)e.nextElement();
            Object[] elements = nameInfo.getAll();
            if (elements == null) continue;
            int i = 0;
            while (i < elements.length) {
                sb.append(elements[i]);
                ++i;
            }
        }
        return sb.toString();
    }
}

