/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class RPRecord
extends Record {
    private Name mailbox;
    private Name textDomain;

    private RPRecord() {
    }

    RPRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)17, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.mailbox = new Name(in);
        this.textDomain = new Name(in);
    }

    public RPRecord(Name _name, short _dclass, int _ttl, Name _mailbox, Name _textDomain) {
        super(_name, (short)17, _dclass, _ttl);
        this.mailbox = _mailbox;
        this.textDomain = _textDomain;
    }

    RPRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)17, _dclass, _ttl);
        this.mailbox = new Name(st.nextToken(), origin);
        this.textDomain = new Name(st.nextToken(), origin);
    }

    public Name getMailbox() {
        return this.mailbox;
    }

    public Name getTextDomain() {
        return this.textDomain;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.mailbox != null && this.textDomain != null) {
            sb.append(this.mailbox);
            sb.append(" ");
            sb.append(this.textDomain);
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.mailbox == null || this.textDomain == null) {
            return;
        }
        this.mailbox.toWire(out, null);
        this.textDomain.toWire(out, null);
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.mailbox == null || this.textDomain == null) {
            return;
        }
        this.mailbox.toWireCanonical(out);
        this.textDomain.toWireCanonical(out);
    }
}

