/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class SIGRecord
extends Record {
    private short covered;
    private byte alg;
    private byte labels;
    private int origttl;
    private Date expire;
    private Date timeSigned;
    private short footprint;
    private Name signer;
    private byte[] signature;

    private SIGRecord() {
    }

    public SIGRecord(Name _name, short _dclass, int _ttl, int _covered, int _alg, int _origttl, Date _expire, Date _timeSigned, int _footprint, Name _signer, byte[] _signature) {
        super(_name, (short)24, _dclass, _ttl);
        this.covered = (short)_covered;
        this.alg = (byte)_alg;
        this.labels = this.name.labels();
        this.origttl = _origttl;
        this.expire = _expire;
        this.timeSigned = _timeSigned;
        this.footprint = (short)_footprint;
        this.signer = _signer;
        this.signature = _signature;
    }

    SIGRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)24, _dclass, _ttl);
        if (in == null) {
            return;
        }
        int start = in.getPos();
        this.covered = in.readShort();
        this.alg = in.readByte();
        this.labels = in.readByte();
        this.origttl = in.readInt();
        this.expire = new Date(1000L * (long)in.readInt());
        this.timeSigned = new Date(1000L * (long)in.readInt());
        this.footprint = in.readShort();
        this.signer = new Name(in);
        this.signature = new byte[length - (in.getPos() - start)];
        in.read(this.signature);
    }

    SIGRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)24, _dclass, _ttl);
        this.covered = Type.value(st.nextToken());
        this.alg = Byte.parseByte(st.nextToken());
        this.labels = Options.check("2065sig") ? this.name.labels() : Byte.parseByte(st.nextToken());
        this.origttl = TTL.parseTTL(st.nextToken());
        this.expire = SIGRecord.parseDate(st.nextToken());
        this.timeSigned = SIGRecord.parseDate(st.nextToken());
        this.footprint = (short)Integer.parseInt(st.nextToken());
        this.signer = new Name(st.nextToken(), origin);
        if (st.hasMoreTokens()) {
            this.signature = base64.fromString(st.remainingTokens());
        }
    }

    static String formatDate(Date d) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        StringBuffer sb = new StringBuffer();
        DecimalFormat w4 = new DecimalFormat();
        ((NumberFormat)w4).setMinimumIntegerDigits(4);
        ((NumberFormat)w4).setGroupingUsed(false);
        DecimalFormat w2 = new DecimalFormat();
        ((NumberFormat)w2).setMinimumIntegerDigits(2);
        c.setTime(d);
        sb.append(w4.format(c.get(1)));
        sb.append(w2.format(c.get(2) + 1));
        sb.append(w2.format(c.get(5)));
        sb.append(w2.format(c.get(11)));
        sb.append(w2.format(c.get(12)));
        sb.append(w2.format(c.get(13)));
        return sb.toString();
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public Date getExpire() {
        return this.expire;
    }

    public short getFootprint() {
        return this.footprint;
    }

    public byte getLabels() {
        return this.labels;
    }

    public int getOrigTTL() {
        return this.origttl;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public Name getSigner() {
        return this.signer;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public short getTypeCovered() {
        return this.covered;
    }

    static Date parseDate(String s) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        int year = Integer.parseInt(s.substring(0, 4));
        int month = Integer.parseInt(s.substring(4, 6)) - 1;
        int date = Integer.parseInt(s.substring(6, 8));
        int hour = Integer.parseInt(s.substring(8, 10));
        int minute = Integer.parseInt(s.substring(10, 12));
        int second = Integer.parseInt(s.substring(12, 14));
        c.set(year, month, date, hour, minute, second);
        return c.getTime();
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.signature != null) {
            sb.append(Type.string(this.covered));
            sb.append(" ");
            sb.append(this.alg);
            sb.append(" ");
            if (!Options.check("2065sig")) {
                sb.append(this.labels);
                sb.append(" ");
            }
            sb.append(this.origttl);
            sb.append(" (\n\t");
            sb.append(SIGRecord.formatDate(this.expire));
            sb.append(" ");
            sb.append(SIGRecord.formatDate(this.timeSigned));
            sb.append(" ");
            sb.append(this.footprint & 0xFFFF);
            sb.append(" ");
            sb.append(this.signer);
            sb.append("\n");
            sb.append(base64.formatString(this.signature, 64, "\t", true));
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.signature == null) {
            return;
        }
        out.writeShort(this.covered);
        out.writeByte(this.alg);
        out.writeByte(this.labels);
        out.writeInt(this.origttl);
        out.writeInt((int)(this.expire.getTime() / 1000L));
        out.writeInt((int)(this.timeSigned.getTime() / 1000L));
        out.writeShort(this.footprint);
        this.signer.toWire(out, null);
        out.write(this.signature);
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.signature == null) {
            return;
        }
        out.writeShort(this.covered);
        out.writeByte(this.alg);
        out.writeByte(this.labels);
        out.writeInt(this.origttl);
        out.writeInt((int)(this.expire.getTime() / 1000L));
        out.writeInt((int)(this.timeSigned.getTime() / 1000L));
        out.writeShort(this.footprint);
        this.signer.toWireCanonical(out);
        out.write(this.signature);
    }
}

