/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Vector;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.RRset;

public class SetResponse {
    static final byte UNKNOWN = 0;
    static final byte NXDOMAIN = 1;
    static final byte NXRRSET = 2;
    static final byte DELEGATION = 3;
    static final byte CNAME = 4;
    static final byte DNAME = 5;
    static final byte SUCCESSFUL = 6;
    private byte type;
    private Object data;

    private SetResponse() {
    }

    SetResponse(byte _type) {
        this(_type, null);
    }

    SetResponse(byte _type, Object _data) {
        this.type = _type;
        this.data = _data;
    }

    void addCNAME(CNAMERecord cname) {
        this.data = cname;
    }

    void addDNAME(DNAMERecord dname) {
        this.data = dname;
    }

    void addNS(RRset nsset) {
        this.data = nsset;
    }

    void addRRset(RRset rrset) {
        if (this.data == null) {
            this.data = new Vector();
        }
        Vector v = (Vector)this.data;
        v.addElement(rrset);
    }

    public RRset[] answers() {
        if (this.type != 6) {
            return null;
        }
        Vector v = (Vector)this.data;
        RRset[] rrsets = new RRset[v.size()];
        int i = 0;
        while (i < rrsets.length) {
            rrsets[i] = (RRset)v.elementAt(i);
            ++i;
        }
        return rrsets;
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)this.data;
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)this.data;
    }

    public RRset getNS() {
        return (RRset)this.data;
    }

    public boolean isCNAME() {
        return this.type == 4;
    }

    public boolean isDelegation() {
        return this.type == 3;
    }

    public boolean isDNAME() {
        return this.type == 5;
    }

    public boolean isNXDOMAIN() {
        return this.type == 1;
    }

    public boolean isNXRRSET() {
        return this.type == 2;
    }

    public boolean isSuccessful() {
        return this.type == 6;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    void set(byte _type, Object _data) {
        this.type = _type;
        this.data = _data;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "NXDOMAIN";
            }
            case 2: {
                return "NXRRSET";
            }
            case 3: {
                return "delegation: " + this.data;
            }
            case 4: {
                return "CNAME: " + this.data;
            }
            case 5: {
                return "DNAME: " + this.data;
            }
            case 6: {
                return "successful";
            }
        }
        return null;
    }
}

