/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Type {
    private static StringValueTable types = new StringValueTable();
    public static final short A = 1;
    public static final short NS = 2;
    public static final short MD = 3;
    public static final short MF = 4;
    public static final short CNAME = 5;
    public static final short SOA = 6;
    public static final short MB = 7;
    public static final short MG = 8;
    public static final short MR = 9;
    public static final short NULL = 10;
    public static final short WKS = 11;
    public static final short PTR = 12;
    public static final short HINFO = 13;
    public static final short MINFO = 14;
    public static final short MX = 15;
    public static final short TXT = 16;
    public static final short RP = 17;
    public static final short AFSDB = 18;
    public static final short X25 = 19;
    public static final short ISDN = 20;
    public static final short RT = 21;
    public static final short NSAP = 22;
    public static final short NSAP_PTR = 23;
    public static final short SIG = 24;
    public static final short KEY = 25;
    public static final short PX = 26;
    public static final short GPOS = 27;
    public static final short AAAA = 28;
    public static final short LOC = 29;
    public static final short NXT = 30;
    public static final short EID = 31;
    public static final short NIMLOC = 32;
    public static final short SRV = 33;
    public static final short ATMA = 34;
    public static final short NAPTR = 35;
    public static final short KX = 36;
    public static final short CERT = 37;
    public static final short A6 = 38;
    public static final short DNAME = 39;
    public static final short OPT = 41;
    public static final short DS = 43;
    public static final short TKEY = 249;
    public static final short TSIG = 250;
    public static final short IXFR = 251;
    public static final short AXFR = 252;
    public static final short MAILB = 253;
    public static final short MAILA = 254;
    public static final short ANY = 255;

    static {
        types.put2(1, "A");
        types.put2(2, "NS");
        types.put2(3, "MD");
        types.put2(4, "MF");
        types.put2(5, "CNAME");
        types.put2(6, "SOA");
        types.put2(7, "MB");
        types.put2(8, "MG");
        types.put2(9, "MR");
        types.put2(10, "NULL");
        types.put2(11, "WKS");
        types.put2(12, "PTR");
        types.put2(13, "HINFO");
        types.put2(14, "MINFO");
        types.put2(15, "MX");
        types.put2(16, "TXT");
        types.put2(17, "RP");
        types.put2(18, "AFSDB");
        types.put2(19, "X25");
        types.put2(20, "ISDN");
        types.put2(21, "RT");
        types.put2(22, "NSAP");
        types.put2(23, "NSAP_PTR");
        types.put2(24, "SIG");
        types.put2(25, "KEY");
        types.put2(26, "PX");
        types.put2(27, "GPOS");
        types.put2(28, "AAAA");
        types.put2(29, "LOC");
        types.put2(30, "NXT");
        types.put2(31, "EID");
        types.put2(32, "NIMLOC");
        types.put2(33, "SRV");
        types.put2(34, "ATMA");
        types.put2(35, "NAPTR");
        types.put2(36, "KX");
        types.put2(37, "CERT");
        types.put2(38, "A6");
        types.put2(39, "DNAME");
        types.put2(41, "OPT");
        types.put2(43, "DS");
        types.put2(249, "TKEY");
        types.put2(250, "TSIG");
        types.put2(251, "IXFR");
        types.put2(252, "AXFR");
        types.put2(253, "MAILB");
        types.put2(254, "MAILA");
        types.put2(255, "ANY");
    }

    private Type() {
    }

    public static boolean isRR(int type) {
        switch (type) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    public static String string(int i) {
        String s = types.getString(i);
        return s != null ? s : "TYPE" + i;
    }

    public static short value(String s) {
        short i = (short)types.getValue(s.toUpperCase());
        if (i >= 0) {
            return i;
        }
        try {
            if (s.toUpperCase().startsWith("TYPE")) {
                return Short.parseShort(s.substring(4));
            }
            return Short.parseShort(s);
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

