/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.awt;

import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LogContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import net.zerotoaster.mta.admin.awt.ConfigHelp;
import net.zerotoaster.mta.admin.awt.ConfigMenue;
import net.zerotoaster.mta.admin.awt.MessageBox;
import net.zerotoaster.mta.admin.awt.PrivilegeChanged;
import net.zerotoaster.mta.admin.awt.StartSubFrameEvent;
import net.zerotoaster.mta.admin.awt.StateChanger;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.event.MTAEventListener;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.storage.RemoteStorageManager_Client;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.util.Helper;

public class ConfigFrame
extends Frame
implements Constants,
MTAEventListener {
    private static final String LOCAL_CONFIG_FILE = "zt_config.ini";
    private static final long serialVersionUID = 3777719903803293709L;
    protected static Properties prpConfig = null;
    protected static final Font MENUFONT = new Font("dialog", 1, 12);
    protected static LogContext logContext = null;
    protected static RemoteStorageManager_Client smManager = null;
    protected static Hashtable hshSlaves = new Hashtable();
    protected static ConfigHelp frmHelp = null;
    protected static int intRM_Privilege = -1;
    protected static String strRM_UserName = "";
    protected StateChanger stchng = null;
    private String strSavedTitle = null;

    protected void colorComponents(Component c) {
        Color colLightGray = new Color(245, 245, 245);
        SystemColor colBack = SystemColor.control;
        if (c instanceof Container) {
            c.setBackground(colBack);
            c.setForeground(Color.black);
            Container cnt = (Container)c;
            int i = 0;
            while (i < cnt.getComponentCount()) {
                this.colorComponents(cnt.getComponent(i));
                ++i;
            }
            return;
        }
        if (c instanceof TextComponent) {
            c.setBackground(colLightGray);
            c.setForeground(Color.black);
            return;
        }
        if (c instanceof List) {
            c.setBackground(colLightGray);
            c.setForeground(Color.black);
            return;
        }
        if (c instanceof Component) {
            c.setBackground(colBack);
            c.setForeground(Color.black);
            return;
        }
    }

    protected void colorComponents_disable(Component c) {
        Color clb = Color.lightGray;
        Color clf = Color.gray;
        if (c instanceof Container) {
            c.setBackground(clb);
            c.setForeground(clf);
            Container cnt = (Container)c;
            int i = 0;
            while (i < cnt.getComponentCount()) {
                this.colorComponents_disable(cnt.getComponent(i));
                ++i;
            }
        }
        if (c instanceof TextComponent) {
            c.setBackground(clb);
            c.setForeground(clf);
            return;
        }
        if (c instanceof List) {
            c.setBackground(clb);
            c.setForeground(clf);
            return;
        }
        if (c instanceof Component) {
            c.setBackground(clb);
            c.setForeground(clf);
            return;
        }
    }

    private void config_load() {
        block4: {
            prpConfig = new Properties();
            File flConfig = new File(LOCAL_CONFIG_FILE);
            FileInputStream fis = null;
            if (!flConfig.exists()) break block4;
            try {
                try {
                    fis = new FileInputStream(flConfig);
                    prpConfig.load(fis);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                Helper.close(fis);
                throw throwable;
            }
            Object var3_6 = null;
            Helper.close(fis);
        }
    }

    private void config_save() {
        new File(LOCAL_CONFIG_FILE);
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(LOCAL_CONFIG_FILE);
                prpConfig.save(fos, "");
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            Helper.close(fos);
            throw throwable;
        }
        Object var2_5 = null;
        Helper.close(fos);
    }

    public void dispose() {
        this.setVisible(false);
        if (this.stchng != null) {
            this.stchng.dispose();
            this.stchng = null;
        }
        super.dispose();
        if (this instanceof ConfigMenue) {
            Enumeration e = hshSlaves.elements();
            while (e.hasMoreElements()) {
                ((ConfigFrame)e.nextElement()).dispose();
            }
            this.config_save();
            System.exit(0);
        }
    }

    protected void handleException(Throwable thr) {
        if (thr instanceof InitializationException || thr instanceof StorageException) {
            MessageBox.OK(this, "Error !", "An error has occurred.\nSee error log");
        } else {
            logContext.write("! An internal error occured", thr);
            MessageBox.OK(this, "Error !", String.valueOf(thr.toString()) + "\n\nSee error log");
        }
    }

    protected void init() {
        MTAEventQueue.addListener(this);
        this.stchng = new StateChanger(this.getTitle());
        if (prpConfig == null) {
            this.config_load();
        }
    }

    public void licenceCheck() {
        try {
            String s = smManager.licenceCheck();
            if (s != null && s.length() > 0) {
                MessageBox.OK(this, "LicenceManager", s);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof StartSubFrameEvent) {
            MTAEventQueue.consume();
            ((StartSubFrameEvent)e).getConfigFrame().setVisible(true);
        }
        boolean cfr_ignored_0 = e instanceof PrivilegeChanged;
    }

    public void setTitle(String strNewTitle) {
        this.strSavedTitle = strNewTitle;
        super.setTitle(strNewTitle);
    }

    public void setVisible(boolean b) {
        if (!b) {
            this.windowPos_save(this);
        }
        if (b && this.isVisible()) {
            this.toFront();
            return;
        }
        if (b) {
            this.windowPos_load(this);
        }
        super.setVisible(b);
        if (b) {
            try {
                URL u = this.getClass().getResource("/toaster.ico");
                if (u != null) {
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(u));
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void windowPos_load(Window win) {
        boolean blnHadFound = false;
        String strKey = win.getName();
        if (((Hashtable)prpConfig).containsKey(String.valueOf(strKey) + "-x")) {
            int x = Integer.parseInt(prpConfig.getProperty(String.valueOf(strKey) + "-x"));
            int y = Integer.parseInt(prpConfig.getProperty(String.valueOf(strKey) + "-y"));
            int w = Integer.parseInt(prpConfig.getProperty(String.valueOf(strKey) + "-w"));
            int h = Integer.parseInt(prpConfig.getProperty(String.valueOf(strKey) + "-h"));
            ((Component)win).setBounds(x, y, w, h);
            blnHadFound = true;
        }
        if (!blnHadFound) {
            win.pack();
            int i = this.getLocation().x;
            int j = this.getLocation().y;
            int k = this.getSize().width;
            int l = this.getSize().height;
            int i1 = win.getSize().width;
            int j1 = win.getSize().height;
            ((Component)win).setLocation(i + k / 2 - i1 / 2, j + l / 2 - j1 / 2);
            win.pack();
        }
        this.colorComponents(win);
    }

    protected void windowPos_save(Window win) {
        String strKey = win.getName();
        Rectangle r = win.getBounds();
        if (r.x == 0 && r.y == 0) {
            return;
        }
        ((Hashtable)prpConfig).put(String.valueOf(strKey) + "-x", String.valueOf(r.x));
        ((Hashtable)prpConfig).put(String.valueOf(strKey) + "-y", String.valueOf(r.y));
        ((Hashtable)prpConfig).put(String.valueOf(strKey) + "-w", String.valueOf(r.width));
        ((Hashtable)prpConfig).put(String.valueOf(strKey) + "-h", String.valueOf(r.height));
    }
}

