/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.io;

import de.zwanzigeins.util.LockObject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.util.Helper;

public class LineServerSocket {
    private ServerSocket ssok = null;
    private boolean blnDisposed = false;
    private LockObject objLock = new LockObject();

    public LineServerSocket(int port) throws IOException {
        this.ssok = new ServerSocket(port);
    }

    public LineServerSocket(int port, int backlog) throws IOException {
        this.ssok = new ServerSocket(port, backlog);
    }

    public LineServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.ssok = new ServerSocket(port, backlog, bindAddr);
    }

    public LineSocket accept() throws IOException {
        Socket s;
        block4: {
            if (this.blnDisposed) {
                return null;
            }
            s = null;
            try {
                s = this.ssok.accept();
            }
            catch (IOException iOException) {
                if (!this.blnDisposed) break block4;
                return null;
            }
        }
        if (this.blnDisposed) {
            Helper.close(s);
            this.objLock.lo_notify();
            return null;
        }
        return new LineSocket(s);
    }

    public void close() throws IOException {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        String strAddress = this.getInetAddress().getHostAddress();
        if (strAddress.equals("0.0.0.0")) {
            try {
                strAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                strAddress = "127.0.0.1";
            }
        }
        try {
            new Socket(strAddress, this.getLocalPort());
        }
        catch (Throwable throwable) {}
        this.objLock.lo_wait(2000L);
        this.objLock.dispose();
        this.objLock = null;
        Helper.close(this.ssok);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public InetAddress getInetAddress() {
        return this.ssok.getInetAddress();
    }

    public int getLocalPort() {
        return this.ssok.getLocalPort();
    }

    public String toString() {
        return "LineServerSocket[addr=" + this.getInetAddress() + ", localport=" + this.getLocalPort() + "]";
    }
}

