/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import de.zwanzigeins.util.VectorObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.mailfilters.BayesianFilterConfig;
import net.zerotoaster.mta.mailfilters.BayesianFilterRecord;
import net.zerotoaster.mta.mailfilters.BayesianRBLRecord;
import net.zerotoaster.mta.mailfilters.MailFilter;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.RBLCheck;

public class BayesianFilter
extends MailFilter {
    public static final String STOP_CHARS = " <>.,;:!=()?!\r\n\t\"\u00a0";
    private BayesianFilterConfig bfc = null;
    private String strUserToUse = null;
    private Hashtable hshRecords = new Hashtable();
    private VectorObject vecRecords = new VectorObject();
    private Hashtable hshWordsFound = new Hashtable();
    private int intMailAction = 0;
    private boolean blnSubjectFound = false;
    private double dblA = 0.0;
    private double dblB = 0.0;
    private RBLCheck rbl = null;
    private Vector vecRBL = null;
    private Vector vecRBLResults = null;

    private void analyze(String string, boolean blnInBody) throws Throwable {
        String strLine = string.toLowerCase();
        StringTokenizer strt = new StringTokenizer(strLine, STOP_CHARS);
        String strWord = null;
        while (strt.hasMoreTokens()) {
            strWord = strt.nextToken();
            BayesianFilterRecord bsfr = (BayesianFilterRecord)this.hshRecords.get(strWord);
            if (bsfr == null || !bsfr.getTestBody() && blnInBody || !bsfr.getTestHeader() && !blnInBody) continue;
            double dblProb = (double)bsfr.getProbability() / 100.0;
            this.dblA *= dblProb;
            this.dblB *= 1.0 - dblProb;
            Integer ii = (Integer)this.hshWordsFound.get(strWord);
            if (ii == null) {
                ii = new Integer(0);
            }
            ii = new Integer(ii + 1);
            this.hshWordsFound.put(strWord, ii);
        }
        int i = 0;
        while (i < this.vecRecords.size()) {
            BayesianFilterRecord bsfr = (BayesianFilterRecord)this.vecRecords.elementAt(i);
            if (bsfr != null && (bsfr.getTestBody() || !blnInBody) && (bsfr.getTestHeader() || blnInBody) && strLine.indexOf(strWord = bsfr.getWord()) != -1) {
                double dblProb = (double)bsfr.getProbability() / 100.0;
                this.dblA *= dblProb;
                this.dblB *= 1.0 - dblProb;
                Integer ii = (Integer)this.hshWordsFound.get(strWord);
                if (ii == null) {
                    ii = new Integer(0);
                }
                ii = new Integer(ii + 1);
                this.hshWordsFound.put(strWord, ii);
            }
            ++i;
        }
    }

    public void analyzeBody(String strLine) throws Throwable {
        this.analyze(strLine, true);
    }

    public void analyzeHeader(String strLine) throws Throwable {
        if (strLine.toLowerCase().startsWith("subject:")) {
            this.analyze(strLine, true);
        } else {
            this.analyze(strLine, false);
        }
    }

    public void analyzePost() {
        if (this.mhr.getExternalMail()) {
            this.vecRBLResults.addElement("-- not checked, transit mail --");
            return;
        }
        String strDomain = HelperExtract.splitUserName_getDomain((String)this.mhr.getEnvelopeFrom_Redirected());
        if (this.smManager.domainRead(strDomain) != null) {
            this.vecRBLResults.addElement("-- not checked, sender is local --");
            return;
        }
        this.rblCheck();
        this.intMailAction = 0;
        int intProb = this.getProbability();
        int i = 0;
        while (i < 2) {
            int intProbCmp = 0;
            int intPropAct = 0;
            switch (i) {
                case 0: {
                    intProbCmp = this.bfc.getProbability_1();
                    intPropAct = this.bfc.getAction_1();
                    break;
                }
                case 1: {
                    intProbCmp = this.bfc.getProbability_2();
                    intPropAct = this.bfc.getAction_2();
                }
            }
            if (intProb > intProbCmp) {
                this.intMailAction = intPropAct;
                switch (this.intMailAction) {
                    case 1: {
                        this.doDelete();
                        this.log("# Bayesian filter deleted " + this.mhr.toString());
                        break;
                    }
                    case 0: {
                        String strOld = this.mhr.getEnvelopeTo_Redirected()[0];
                        this.mhr.recipientReset();
                        this.mhr.addEnvelopeTo_Redirected(this.bfc.getEMail());
                        this.log("# Bayesian filter moved " + strOld + " -> " + this.mhr.getEnvelopeTo_Redirected()[0]);
                        break;
                    }
                    case 2: {
                        this.log("# Bayesian filter marked " + this.mhr.toString());
                    }
                }
                break;
            }
            ++i;
        }
        BayesianFilterRecord fr = new BayesianFilterRecord();
        long lngTime = TimeFactory.getTime();
        Enumeration e = this.hshWordsFound.keys();
        while (e.hasMoreElements()) {
            String strWord = (String)e.nextElement();
            try {
                String strRecord = this.smManager.keyDataRead("BAYESIAN_FILTER_RECORD", this.strUserToUse, strWord);
                fr.recordImport(strRecord);
                fr.setTimesUsed(fr.getTimesUsed() + 1L);
                fr.setLastUsed(lngTime);
                this.smManager.keyDataWrite("BAYESIAN_FILTER_RECORD", this.strUserToUse, strWord, fr.recordExport());
            }
            catch (Throwable throwable) {}
        }
    }

    public void dispose() {
        if (this.rbl != null) {
            this.rbl.dispose();
        }
        if (this.hshRecords != null) {
            this.hshRecords.clear();
        }
        if (this.hshWordsFound != null) {
            this.hshWordsFound.clear();
        }
        if (this.vecRBL != null) {
            this.vecRBL.removeAllElements();
        }
        if (this.vecRBLResults != null) {
            this.vecRBLResults.removeAllElements();
        }
        if (this.vecRecords != null) {
            this.vecRecords.removeAllElements();
        }
    }

    public int getProbability() {
        double dblProb = this.dblA / (this.dblA + this.dblB);
        return (int)Math.round(dblProb * 100.0);
    }

    public Vector getProbabilityList() {
        Vector<String> v = new Vector<String>(this.hshWordsFound.size());
        Enumeration e = this.hshWordsFound.keys();
        while (e.hasMoreElements()) {
            String strWord = (String)e.nextElement();
            BayesianFilterRecord bfr = (BayesianFilterRecord)this.hshRecords.get(strWord);
            if (bfr == null) {
                int i = 0;
                while (i < this.vecRecords.size()) {
                    if (((BayesianFilterRecord)this.vecRecords.elementAt(i)).getWord().equals(strWord)) {
                        bfr = (BayesianFilterRecord)this.vecRecords.elementAt(i);
                    }
                    ++i;
                }
            }
            if (bfr == null) continue;
            String strProb = String.valueOf(bfr.getProbability());
            strProb = Helper.rset(strProb, 3, ' ');
            String strCount = String.valueOf((Integer)this.hshWordsFound.get(strWord));
            strCount = Helper.rset(strCount, 3, ' ');
            v.addElement(String.valueOf(strProb) + "% " + strCount + " " + strWord);
        }
        Helper.sortVector(v);
        int n = v.size() - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            Object temp = v.elementAt(j);
            v.setElementAt((String)v.elementAt(n - j), j);
            v.setElementAt((String)temp, n - j);
            --j;
        }
        return v;
    }

    public void init(MailHeaderRecord mhr, LogContext log, StorageManager sm, Configuration cnf) {
        String strRecord;
        super.init(mhr, log, sm, cnf);
        this.hshRecords = new Hashtable();
        this.hshWordsFound = new Hashtable();
        this.filterDisable();
        this.strUserToUse = mhr.getEnvelopeTo_Redirected()[0];
        int i = 0;
        while (i < 5) {
            this.bfc = this.readBFC(this.strUserToUse);
            if (this.bfc == null) {
                return;
            }
            if (this.bfc.getWordListSource().length() == 0) break;
            this.strUserToUse = this.bfc.getWordListSource();
            ++i;
        }
        this.log("D Using Bayesian Filter from " + this.strUserToUse);
        Vector v = this.smManager.keyDataReadAll("BAYESIAN_FILTER_RECORD", this.strUserToUse);
        if (v.size() == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < v.size()) {
            strRecord = this.smManager.keyDataRead("BAYESIAN_FILTER_RECORD", this.strUserToUse, (String)v.elementAt(i2));
            BayesianFilterRecord fr = new BayesianFilterRecord();
            try {
                fr.recordImport(strRecord);
            }
            catch (Throwable t) {
                this.log("? Corrupted bayesian filter record", t);
                return;
            }
            String s = fr.getWord();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1);
                s = s.substring(0, s.length() - 1);
                fr.setWord(s);
                this.vecRecords.addElement((Object)fr);
            } else {
                this.hshRecords.put(fr.getWord(), fr);
            }
            ++i2;
        }
        this.rbl = new RBLCheck(log, cnf);
        v = this.smManager.keyDataReadAll("BAYESIAN_RBL_RECORD", this.strUserToUse);
        this.vecRBL = new Vector(v.size());
        i2 = 0;
        while (i2 < v.size()) {
            strRecord = this.smManager.keyDataRead("BAYESIAN_RBL_RECORD", this.strUserToUse, (String)v.elementAt(i2));
            BayesianRBLRecord rr = new BayesianRBLRecord();
            try {
                rr.recordImport(strRecord);
            }
            catch (Throwable t) {
                this.log("? Corrupted bayesian RBL record", t);
                return;
            }
            this.vecRBL.addElement(rr);
            ++i2;
        }
        this.vecRBLResults = new Vector();
        this.filterEnable();
        this.dblA = 1.0;
        this.dblB = 1.0;
    }

    public String processBody(String strLine) {
        return strLine;
    }

    public String processHeader(String string) {
        String strLine;
        if (!this.blnSubjectFound && this.intMailAction == 2 && string.toLowerCase().startsWith("subject:")) {
            strLine = string.substring("subject:".length()).trim();
            strLine = "Subject: " + this.bfc.getMarker() + " " + this.getProbability() + "% " + strLine;
            this.blnSubjectFound = true;
        }
        return strLine;
    }

    public String processNewHeaders(String strLine) throws Throwable {
        StringBuffer strb = new StringBuffer(strLine);
        if (this.intMailAction == 2 && !this.blnSubjectFound) {
            strb.append("\r\n");
            strb.append("Subject: ");
            strb.append(this.bfc.getMarker());
            strb.append(" ");
            strb.append(this.getProbability());
            strb.append("%");
        }
        strb.append("\r\n");
        strb.append("X-Bayesian-Filter: Spam Probability ");
        strb.append(this.getProbability());
        strb.append("%");
        Vector v = this.getProbabilityList();
        int i = 0;
        while (i < v.size()) {
            strb.append("\r\n");
            strb.append("X-Bayesian-Filter: Word ");
            strb.append((String)v.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.vecRBLResults.size()) {
            strb.append("\r\n");
            strb.append("X-Bayesian-Filter: RBL ");
            strb.append((String)this.vecRBLResults.elementAt(i));
            ++i;
        }
        return strb.toString();
    }

    public String processPost(String strLine) {
        return strLine;
    }

    private void rblCheck() {
        String strRoutedIP = this.mhr.getRoutedIP();
        this.vecRBLResults.addElement("Checking IP " + strRoutedIP);
        if (strRoutedIP.length() == 0) {
            this.vecRBLResults.addElement("-- not checked, no routed ip found --");
            return;
        }
        int i = 0;
        while (i < this.vecRBL.size()) {
            BayesianRBLRecord rr = (BayesianRBLRecord)this.vecRBL.elementAt(i);
            if (this.rbl.check(strRoutedIP, rr.getServer(), rr.getResponse())) {
                double dblProb = (double)rr.getProbability() / 100.0;
                this.dblA *= dblProb;
                this.dblB *= 1.0 - dblProb;
                this.vecRBLResults.addElement(rr.getProbability() + "% " + this.rbl.getMessage());
            } else {
                this.vecRBLResults.addElement("passed " + rr.getServer());
            }
            ++i;
        }
    }

    private BayesianFilterConfig readBFC(String strUser) {
        BayesianFilterConfig bfc = new BayesianFilterConfig();
        String strRecord = this.smManager.keyDataRead("BAYESIAN_FILTER_CONFIG", strUser, "config");
        if (strRecord == null) {
            return null;
        }
        try {
            bfc.recordImport(strRecord);
        }
        catch (Throwable t) {
            this.log("? Corrupted config record", t);
            return null;
        }
        return bfc;
    }
}

