/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import de.zwanzigeins.util.LogContext;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.mailfilters.MailFilter;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StorageManager;

public class MailFilterChain
implements Constants {
    private Vector vecFilters = new Vector();
    private LogContext logContext = null;
    private StorageManager smManager = null;
    private MailHeaderRecord mhr = null;
    private Configuration cnf = null;
    private boolean blnInBody = false;
    private boolean blnDelete = false;
    private boolean blnAbort = false;
    private boolean blnHeaderBodyJump = false;
    private boolean blnEOF = false;
    private int STATE_NONE = 0;
    private int STATE_ANALYZE = 1;
    private int STATE_PROCESS = 2;
    private int intCurrentState = this.STATE_NONE;

    public MailFilterChain(MailHeaderRecord mhr, LogContext log, StorageManager sm, Configuration cnf) {
        this.mhr = mhr;
        this.logContext = log;
        this.smManager = sm;
        this.cnf = cnf;
    }

    public void analyze(String string) {
        String strLine = this.preProcess(this.STATE_ANALYZE, string);
        int i = 0;
        while (i < this.vecFilters.size()) {
            MailFilter mf = (MailFilter)this.vecFilters.elementAt(i);
            this.blnDelete |= mf.canDelete();
            this.blnAbort |= mf.canAbort();
            if (this.blnAbort) break;
            if (mf.canFilter()) {
                try {
                    if (this.blnEOF) {
                        mf.analyzePost();
                    } else if (!this.blnInBody) {
                        mf.analyzeHeader(strLine);
                    } else {
                        mf.analyzeBody(strLine);
                    }
                }
                catch (Throwable t) {
                    this.logContext.write("? MailFilter analyze " + mf.toString(), t);
                    mf.filterDisable();
                }
            }
            ++i;
        }
        this.postProcess(strLine);
    }

    public boolean canAbort() {
        return this.blnAbort;
    }

    public boolean canDelete() {
        return this.blnDelete;
    }

    public void dispose() {
        if (this.vecFilters != null) {
            int i = 0;
            while (i < this.vecFilters.size()) {
                MailFilter mf = (MailFilter)this.vecFilters.elementAt(i);
                mf.dispose();
                ++i;
            }
            this.vecFilters.removeAllElements();
        }
    }

    private String postProcess(String string) {
        String strLine;
        int intPtr = 0;
        while (intPtr < string.length() && (string.charAt(intPtr) == '\r' || string.charAt(intPtr) == '\n')) {
            ++intPtr;
        }
        if (intPtr != 0) {
            strLine = string.substring(intPtr);
        }
        if (this.blnHeaderBodyJump) {
            if (strLine.length() != 0 && !strLine.endsWith("\r\n")) {
                strLine = String.valueOf(strLine) + "\r\n";
            }
            this.blnHeaderBodyJump = false;
        }
        if (this.blnEOF) {
            strLine = String.valueOf(strLine) + ".";
        }
        if (strLine.length() == 0 && !this.blnInBody && !this.blnHeaderBodyJump) {
            return null;
        }
        return strLine;
    }

    private String preProcess(int intNewState, String string) {
        String strLine;
        if (this.intCurrentState != intNewState) {
            this.intCurrentState = intNewState;
            this.blnInBody = false;
            this.blnDelete = false;
            this.blnAbort = false;
            this.blnHeaderBodyJump = false;
            this.blnEOF = false;
        }
        if (!this.blnInBody && string.length() == 0) {
            this.blnInBody = true;
            this.blnHeaderBodyJump = true;
        }
        if (string.length() == 1 && string.charAt(0) == '.') {
            this.blnEOF = true;
            strLine = "";
        }
        return strLine;
    }

    public String process(String string) {
        String strLine = this.preProcess(this.STATE_PROCESS, string);
        int i = 0;
        while (i < this.vecFilters.size()) {
            MailFilter mf = (MailFilter)this.vecFilters.elementAt(i);
            if (mf.canFilter()) {
                try {
                    strLine = this.blnEOF ? mf.processPost(strLine) : (this.blnHeaderBodyJump ? mf.processNewHeaders(strLine) : (!this.blnInBody ? mf.processHeader(strLine) : mf.processBody(strLine)));
                }
                catch (Throwable t) {
                    this.logContext.write("? MailFilter process " + mf.toString(), t);
                    mf.filterDisable();
                }
            }
            ++i;
        }
        return this.postProcess(strLine);
    }

    public void registerFilter(MailFilter mf) {
        mf.init(this.mhr, this.logContext, this.smManager, this.cnf);
        this.vecFilters.addElement(mf);
    }
}

