/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters.avscan;

import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import java.io.File;

public abstract class AVScanExec {
    protected LogContext logContext = null;
    protected String strExecute = null;
    protected Integer intExecWait = null;

    public AVScanExec(LogContext logContext, String strExecute, Integer intExecWait) {
        this.logContext = logContext;
        this.strExecute = strExecute;
        this.intExecWait = intExecWait;
    }

    protected void execScanner(File flScan, File flReport) {
        flReport.delete();
        this.strExecute = String.valueOf(this.strExecute) + " " + flScan.getPath() + " " + flReport.getPath();
        Process p = null;
        LockObject objLock = new LockObject();
        try {
            this.logContext.write("D AV: Starting " + this.strExecute);
            p = Runtime.getRuntime().exec(this.strExecute);
            boolean blnProcessActive = true;
            int intRuntime = 0;
            int i = 0;
            while (i < this.intExecWait * 2) {
                objLock.lo_wait(500L);
                intRuntime += 500;
                try {
                    p.exitValue();
                    blnProcessActive = false;
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    ++i;
                }
            }
            if (blnProcessActive) {
                this.logContext.write("D AV: Killing process " + this.strExecute);
                p.destroy();
                this.logContext.write("D AV: Killed successfully " + this.strExecute);
            }
            this.logContext.write("D AV: Finished " + this.strExecute + " after " + intRuntime / 1000 + " seconds");
        }
        catch (Throwable t) {
            this.logContext.write(t);
        }
        objLock.dispose();
        objLock = null;
    }

    protected File getReportFile(File flScan) {
        return new File(flScan.getParent(), "report");
    }

    public abstract String getScannerName();

    public abstract String scan(File var1);
}

