/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.util;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperValidate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.io.LineServerSocket;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.HostIP;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class Helper
implements Constants {
    private static final int CASEDIFF = 32;
    private static final Object objLock = new Object();

    private Helper() {
    }

    public static final String buildID(int intNb, int intMaxNb) {
        int fillChar = 48;
        String strLeft = String.valueOf(intNb);
        String strRight = String.valueOf(intMaxNb);
        int length = strRight.length();
        int copyLen = strLeft.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)strLeft.charAt(i);
            ++i;
        }
        return "[" + new String(buffer) + "/" + strRight + "]";
    }

    public static final boolean checkString(String string, String string2) {
        String s = string.toLowerCase();
        String templ = string2.toLowerCase();
        int wildPos = templ.indexOf(42);
        if (wildPos == -1) {
            return s.equals(templ);
        }
        int templLen = templ.length();
        int strLen = s.length();
        int templIndex = 0;
        int strIndex = 0;
        boolean wildCard = false;
        while (templIndex < templLen) {
            if (templ.charAt(templIndex) == '*') {
                wildCard = true;
                ++templIndex;
                continue;
            }
            int nextWild = templ.indexOf(42, templIndex);
            if (nextWild == -1) {
                nextWild = templLen;
            }
            String templPart = templ.substring(templIndex, nextWild);
            templIndex = nextWild;
            if (wildCard) {
                int pos = s.indexOf(templPart);
                if (pos == -1) {
                    return false;
                }
                strIndex = pos + templPart.length();
            } else {
                if (!s.regionMatches(false, 0, templPart, 0, templPart.length())) {
                    return false;
                }
                strIndex += templPart.length();
            }
            wildCard = false;
        }
        return wildCard ? true : strIndex == strLen;
    }

    public static final boolean close(Object o) {
        if (o == null) {
            return true;
        }
        try {
            if (o instanceof RandomAccessFile) {
                ((RandomAccessFile)o).close();
                return true;
            }
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return true;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return true;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return true;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return true;
            }
            if (o instanceof LineSocket) {
                ((LineSocket)o).close();
                return true;
            }
            if (o instanceof LineServerSocket) {
                ((LineServerSocket)o).close();
                return true;
            }
            if (o instanceof ServerSocket) {
                ((ServerSocket)o).close();
                return true;
            }
            if (o instanceof Socket) {
                ((Socket)o).close();
                return true;
            }
            if (o instanceof Connection) {
                ((Connection)o).close();
                return true;
            }
            if (o instanceof Statement) {
                ((Statement)o).close();
                return true;
            }
            if (o instanceof PreparedStatement) {
                ((PreparedStatement)o).close();
                return true;
            }
            if (o instanceof ResultSet) {
                ((ResultSet)o).close();
                return true;
            }
            Helper.writeLog("Unknown close object: " + o);
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static final void flush(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof OutputStream) {
                ((OutputStream)o).flush();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).flush();
                return;
            }
            if (o instanceof LineSocket) {
                ((LineSocket)o).flush();
                return;
            }
            Helper.writeLog("Unknown flush object: " + o);
        }
        catch (Throwable throwable) {}
    }

    public static final String formatDate(long lngTime) {
        if (lngTime <= 0L) {
            return "";
        }
        DateFormat df = DateFormat.getDateInstance();
        return df.format(new Date(lngTime));
    }

    public static final String formatDateTime(long lngTime) {
        if (lngTime <= 0L) {
            return "";
        }
        DateFormat df = DateFormat.getDateTimeInstance();
        return df.format(new Date(lngTime));
    }

    public static final String formatMemoryString(long lngSize) {
        double result = lngSize;
        String tail = " Bt";
        if (lngSize > 0x10000000000L) {
            result = (double)lngSize / 1.099511627776E12;
            tail = " TB";
        } else if (lngSize > 0x40000000L) {
            result = (double)lngSize / 1.073741824E9;
            tail = " GB";
        } else if (lngSize >= 0x100000L) {
            result = (double)lngSize / 1048576.0;
            tail = " MB";
        } else if (lngSize >= 1024L) {
            result = (double)lngSize / 1024.0;
            tail = " KB";
        }
        if (!tail.equals(" Bt")) {
            String ret = String.valueOf(result = (double)Math.round(result * 100.0) / 100.0);
            int point = ret.indexOf(46);
            if (point == -1) {
                ret = String.valueOf(ret) + ".00";
            } else {
                int diff = ret.length() - point;
                if (diff < 3) {
                    ret = String.valueOf(ret) + "0";
                } else if (diff > 3) {
                    ret = ret.substring(0, point + 2);
                }
            }
            return result + tail;
        }
        return lngSize + tail;
    }

    public static final String formatTime(long lngTime) {
        if (lngTime <= 0L) {
            return "";
        }
        DateFormat df = DateFormat.getTimeInstance();
        return df.format(new Date(lngTime));
    }

    public static final String getArg(String str) {
        int pp = str.indexOf(" ");
        if (pp == -1) {
            return null;
        }
        return str.substring(pp + 1).trim();
    }

    public static final String getCmd(String str) {
        int pp = str.indexOf(" ");
        if (pp == -1) {
            return str.trim();
        }
        return str.substring(0, pp).trim();
    }

    public static final HostIP[] getMXHosts(String string, boolean blnFastQuery) throws Throwable {
        String strDomain;
        if (string.startsWith("[") && string.endsWith("]")) {
            strDomain = string.substring(1);
            strDomain = strDomain.substring(0, strDomain.length() - 1);
            HostIP hip = new HostIP();
            hip.strHost = strDomain;
            hip.strIP = strDomain;
            return new HostIP[]{hip};
        }
        Record[] records = null;
        int i = 0;
        while (i < 5) {
            records = dns.getRecords((String)strDomain, (short)15);
            if (records == null) {
                records = dns.getRecords((String)strDomain, (short)1);
            }
            if (records != null || blnFastQuery) break;
            Thread.sleep(750L);
            ++i;
        }
        if (records == null) {
            return null;
        }
        if (records[0] instanceof MXRecord && records.length > 0) {
            boolean blnNotSorted;
            do {
                blnNotSorted = false;
                int j = 0;
                while (j < records.length - 1) {
                    MXRecord mxrecord = (MXRecord)records[j];
                    MXRecord mxrecord2 = (MXRecord)records[j + 1];
                    if (mxrecord.getPriority() > mxrecord2.getPriority()) {
                        records[j] = mxrecord2;
                        records[j + 1] = mxrecord;
                        blnNotSorted = true;
                    }
                    ++j;
                }
            } while (blnNotSorted);
        }
        String[] strMX_Hosts = new String[records.length];
        int i2 = 0;
        while (i2 < records.length) {
            String strTmp = records[i2] instanceof MXRecord ? ((MXRecord)records[i2]).getTarget().toString() : ((ARecord)records[i2]).getName().toString();
            if (strTmp.endsWith(".")) {
                strTmp = strTmp.substring(0, strTmp.length() - 1);
            }
            strMX_Hosts[i2] = strTmp;
            ++i2;
        }
        Vector<HostIP> v = new Vector<HostIP>(strMX_Hosts.length);
        int i3 = 0;
        while (i3 < strMX_Hosts.length) {
            if (HelperValidate.isIP((String)strMX_Hosts[i3])) {
                HostIP hip = new HostIP();
                hip.strHost = strMX_Hosts[i3];
                hip.strIP = strMX_Hosts[i3];
                v.addElement(hip);
            }
            if ((records = dns.getRecords((String)strMX_Hosts[i3], (short)1)) != null) {
                int a = 0;
                while (a < records.length) {
                    ARecord ar = (ARecord)records[a];
                    HostIP hip = new HostIP();
                    hip.strHost = strMX_Hosts[i3];
                    hip.strIP = ar.rdataToString();
                    if (hip.strIP.length() > 0) {
                        v.addElement(hip);
                    }
                    ++a;
                }
            }
            ++i3;
        }
        Object[] hip = new HostIP[v.size()];
        v.copyInto(hip);
        return hip;
    }

    public static final String getSMTPUser(String str) {
        if (str == null) {
            return "<null>";
        }
        int intStart = str.lastIndexOf(60) + 1;
        int intEnd = str.indexOf(62, intStart);
        if (intEnd == -1) {
            intEnd = str.length();
        }
        if (intStart == intEnd) {
            return "";
        }
        return str.substring(intStart, intEnd);
    }

    public static final byte[] hmac_md5(String strSecretKey, String strData) {
        int intBlockSize = 64;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        byte[] secret = strSecretKey.getBytes();
        if (secret.length > intBlockSize) {
            secret = md.digest(secret);
        }
        byte[] buf = new byte[intBlockSize];
        int i = 0;
        while (i < secret.length) {
            buf[i] = (byte)(secret[i] ^ 0x36);
            ++i;
        }
        i = secret.length;
        while (i < intBlockSize) {
            buf[i] = 54;
            ++i;
        }
        md.update(buf);
        md.update(strData.getBytes());
        byte[] digest = md.digest();
        int i2 = 0;
        while (i2 < secret.length) {
            buf[i2] = (byte)(secret[i2] ^ 0x5C);
            ++i2;
        }
        i2 = secret.length;
        while (i2 < intBlockSize) {
            buf[i2] = 92;
            ++i2;
        }
        md.update(buf);
        md.update(digest);
        return md.digest();
    }

    public static final String limit(String str, int intLength) {
        return str.length() > intLength ? str.substring(0, intLength) : str;
    }

    public static String lset(long value, int length, char filler) {
        return Helper.lset(Long.toString(value), length, filler);
    }

    public static String lset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < copyLen) {
            buffer[i] = (byte)copyStr.charAt(i);
            ++i;
        }
        i = copyLen++;
        while (i < length) {
            buffer[i] = fillChar;
            ++i;
        }
        return new String(buffer);
    }

    public static void main(String[] args) throws Throwable {
        ((Hashtable)System.getProperties()).put("dns.server", "daisy.harddiskcafe.de");
        HostIP[] ii = Helper.getMXHosts("softal.de", false);
        int i = 0;
        while (i < ii.length) {
            System.out.println(ii[i]);
            ++i;
        }
    }

    public static final String platformPath(String string) {
        if (string == null) {
            return null;
        }
        String strPath = string.replace('\\', File.separatorChar);
        strPath = strPath.replace('/', File.separatorChar);
        return strPath;
    }

    public static final Vector processGroup(String strUser) {
        Vector vecResult = new Vector();
        Helper.processGroup0(strUser, vecResult, new File("c:\\mptn\\etc\\groups.tcp"));
        Helper.processGroup0(strUser, vecResult, new File("groupcopy.ini"));
        return vecResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final void processGroup0(String strUser, Vector v, File fl) {
        if (strUser.length() == 0) {
            return;
        }
        if (!fl.exists()) {
            return;
        }
        if (fl.length() == 0L) {
            return;
        }
        BufferedReader br = null;
        String strMatch = null;
        try {
            try {
                String s;
                br = new BufferedReader(new FileReader(fl));
                while ((s = br.readLine()) != null) {
                    void var6_5;
                    if (var6_5.indexOf("=") == -1 || !var6_5.startsWith(strUser)) continue;
                    strMatch = var6_5;
                    break;
                }
            }
            catch (IOException iOException) {
                Object var5_7 = null;
                Helper.close(br);
                return;
            }
        }
        catch (Throwable s) {
            Object var5_8 = null;
            Helper.close(br);
            throw s;
        }
        Object var5_9 = null;
        Helper.close(br);
        if (strMatch == null) {
            return;
        }
        strMatch = strMatch.substring(strMatch.indexOf("=") + 1).trim();
        StringTokenizer strt = new StringTokenizer(strMatch, ",");
        while (strt.hasMoreTokens()) {
            String strRecipient = strt.nextToken().trim();
            if (strRecipient.length() == 0 || v.indexOf(strRecipient) != -1) continue;
            v.addElement(strRecipient);
        }
    }

    public static final String redirectUser(String string, StorageManager smManager) {
        String strUser;
        if (string == null || string.length() == 0 || string.indexOf("@") == -1) {
            return "";
        }
        String strDomPart = HelperExtract.splitUserName_getDomain((String)string);
        String strUsrPart = HelperExtract.splitUserName_getUser((String)string);
        DomainRecord dom = null;
        UserRecord usr = null;
        usr = smManager.userRead(string);
        if (usr == null) {
            int i = 0;
            while (i < 5) {
                dom = smManager.domainRead(strDomPart);
                if (dom == null || dom.getDomainAlias().length() == 0) break;
                strDomPart = dom.getDomainAlias();
                ++i;
            }
            strUser = String.valueOf(strUsrPart) + "@" + strDomPart;
        }
        boolean blnUserFound = false;
        int i = 0;
        while (i < 5) {
            usr = smManager.userRead(strUser);
            boolean bl = blnUserFound = blnUserFound || usr != null;
            if (usr == null || usr.getRedirect().length() == 0) break;
            strUser = usr.getRedirect();
            ++i;
        }
        return strUser;
    }

    public static final boolean rollback(Connection con) {
        if (con == null) {
            return true;
        }
        try {
            con.rollback();
            return true;
        }
        catch (Throwable t) {
            Helper.writeLog(t);
            return false;
        }
    }

    public static String rset(long value, int length, char filler) {
        return Helper.rset(Long.toString(value), length, filler);
    }

    public static String rset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)copyStr.charAt(i);
            ++i;
        }
        return new String(buffer);
    }

    public static final void sortVector(Vector v) {
        boolean blnHasError = false;
        do {
            blnHasError = false;
            int i = 0;
            while (i < v.size() - 1) {
                String s2;
                String s1 = (String)v.elementAt(i);
                if (s1.compareTo(s2 = (String)v.elementAt(i + 1)) > 0) {
                    v.setElementAt(s2, i);
                    v.setElementAt(s1, i + 1);
                    blnHasError = true;
                }
                ++i;
            }
        } while (blnHasError);
    }

    public static final String splitListName_getCommand(String s) {
        int pp = s.indexOf("-");
        if (pp == -1) {
            return null;
        }
        return HelperExtract.splitUserName_getUser((String)s.substring(pp + 1));
    }

    public static final String splitListName_getList(String s) {
        int pp = s.indexOf("-");
        if (pp == -1) {
            return s;
        }
        String strTmp = s.substring(pp + 1);
        return String.valueOf(s.substring(0, pp)) + "@" + HelperExtract.splitUserName_getDomain((String)strTmp);
    }

    public static final String validateFileName(String string) {
        String strName = string.trim();
        if (strName.length() == 0) {
            return null;
        }
        boolean blnValid = true;
        int i = 0;
        while (i < strName.length() && blnValid) {
            char ch = strName.charAt(i);
            if (ch < ' ') {
                blnValid = false;
            }
            if (ch > 'z') {
                blnValid = false;
            }
            ++i;
        }
        return blnValid ? strName : null;
    }

    public static final void writeLog(String strMsg) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter("err.dmp", true));
                pw.println(strMsg);
                pw.flush();
                pw.close();
            }
            catch (Throwable t2) {
                System.err.println("writeLog: " + t2);
            }
        }
    }

    public static final void writeLog(Throwable t) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter("err.dmp", true));
                t.printStackTrace(pw);
                pw.flush();
                pw.close();
            }
            catch (Throwable t2) {
                System.err.println("writeLog: " + t2);
            }
        }
    }
}

