/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.util;

import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import net.zerotoaster.mta.util.Helper;

public class Sendmail {
    private Sendmail() {
    }

    private static final File createQueueFile(String strDir) {
        new File(strDir).mkdirs();
        int intRetries = 5;
        File flExport = null;
        LockObject loWait = new LockObject();
        while (--intRetries > 0) {
            flExport = new File(strDir, String.valueOf(TimeFactory.createUID()) + ".sml");
            if (!flExport.exists()) break;
            loWait.lo_wait((long)(Math.random() * 250.0 + 50.0));
        }
        loWait.dispose();
        if (intRetries == 0) {
            System.out.println("Cannot create queue file due to name collission");
            return null;
        }
        return flExport;
    }

    public static void main(String[] args) throws Throwable {
        System.out.println("Sendmail ZeroToaster::MTA 2.80");
        if (args.length == 1 && (args[0].equals("-h") || args[0].equals("-?"))) {
            System.out.println("Usage:");
            System.out.println("-impDIR -t -fNAME recipient1 recipient2");
            System.out.println("-impDIR: Zerotoaster import directory (eg -impD:\\ZEROTOASTER\\IMPORT\\");
            System.out.println("-t read messsage for sender and recipients (from, to, cc, bcc)");
            System.out.println("-fNAME sets the 'envelope from' user to 'NAME'");
            System.out.println("recipient1 recipient2: the recipients of this message");
            System.out.println("The message itself is read from STDIN, so 'SENDMAIL < mail.txt' will read from a file");
            return;
        }
        Sendmail.sendmail(args);
    }

    private static final void sendmail(String[] args) {
        boolean blnARG_ReadFromFile = false;
        new Vector();
        String strARG_ImpDir = "";
        String strARG_Sender = "";
        StringBuffer strbARG_Receivers = new StringBuffer();
        int i = -1;
        while (++i < args.length) {
            if (args[i].startsWith("-imp")) {
                strARG_ImpDir = args[i].substring(4).trim();
                if (strARG_ImpDir.length() != 0 || ++i >= args.length) continue;
                strARG_ImpDir = args[i];
                continue;
            }
            if (args[i].startsWith("-t")) {
                blnARG_ReadFromFile = true;
                continue;
            }
            if (args[i].startsWith("-f") || args[i].startsWith("-r")) {
                strARG_Sender = args[i].substring(2).trim();
                if (strARG_Sender.length() != 0 || ++i >= args.length) continue;
                strARG_Sender = args[i];
                continue;
            }
            if (args[i].startsWith("-")) continue;
            strbARG_Receivers.append(args[i]);
            strbARG_Receivers.append(" ");
        }
        if (strARG_ImpDir.length() == 0) {
            System.out.println("Missing -imp");
            return;
        }
        File flExport = Sendmail.createQueueFile(strARG_ImpDir);
        if (flExport == null) {
            return;
        }
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(flExport));
                br = new BufferedReader(new InputStreamReader(System.in));
                if (blnARG_ReadFromFile) {
                    pw.println("SND-ReadHeader: 1");
                }
                if (strbARG_Receivers.length() > 0) {
                    pw.println("SND-Recipients: " + strbARG_Receivers.toString().trim());
                }
                if (strARG_Sender.length() > 0) {
                    pw.println("SND-Sender: " + strARG_Sender);
                }
                String strBuffer = "";
                while ((strBuffer = br.readLine()) != null) {
                    pw.println(strBuffer);
                }
            }
            catch (IOException e) {
                System.out.println("Error writing queuefile / reading STDIN: " + e.getMessage());
                Object var9_12 = null;
                Helper.close(pw);
                Helper.close(br);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            Helper.close(pw);
            Helper.close(br);
            throw throwable;
        }
        Object var9_14 = null;
        Helper.close(pw);
        Helper.close(br);
        if (flExport.length() == 0L) {
            flExport.delete();
            return;
        }
        System.out.println("Stored " + flExport.getPath());
    }
}

