/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.util;

import de.zwanzigeins.util.LogContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.util.Helper;

public class UserAlias {
    private Hashtable hshAlias = null;
    private LogContext logContext = null;
    private Vector vecFilesRead = null;
    private Vector vecResolved = null;
    private int intDepth = 0;
    private static final int MAX_DEPTH = 5;

    public UserAlias(String[] strMasterAliase) {
        this(strMasterAliase, null);
    }

    public UserAlias(String[] strMasterAliase, LogContext log) {
        this.logContext = log;
        this.hshAlias = new Hashtable();
        this.vecFilesRead = new Vector();
        this.readAliases(strMasterAliase);
    }

    private void addAlias(String strAlias, String strResolved) {
        String strArg = (String)this.hshAlias.get(strAlias);
        if (strArg == null) {
            this.hshAlias.put(strAlias, strResolved);
            return;
        }
        this.hshAlias.put(strAlias, String.valueOf(strArg) + ", " + strResolved);
    }

    private void addInclude_1(String strFile) {
        File fl = new File(strFile);
        if (!fl.exists()) {
            return;
        }
        String strFilePath = fl.getAbsolutePath();
        if (this.vecFilesRead.indexOf(strFilePath) != -1) {
            if (this.logContext != null) {
                this.logContext.write("! double include of " + strFilePath + " ignored");
            }
            return;
        }
        this.vecFilesRead.addElement(strFilePath);
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(fl));
                String strBuffer = null;
                Vector<String> v = new Vector<String>();
                while ((strBuffer = br.readLine()) != null) {
                    if ((strBuffer = strBuffer.trim()).length() < 2 || strBuffer.startsWith("#")) continue;
                    v.addElement(strBuffer);
                }
                Object[] s = new String[v.size()];
                v.copyInto(s);
                this.readAliases((String[])s);
            }
            catch (IOException e) {
                if (this.logContext != null) {
                    this.logContext.write("? alias:addInclude " + e.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            Helper.close(br);
            throw throwable;
        }
        Object var5_11 = null;
        Helper.close(br);
    }

    private void addInclude_2(String strAlias, String strFile) {
        File fl = new File(strFile);
        if (!fl.exists()) {
            return;
        }
        String strFilePath = fl.getAbsolutePath();
        if (this.vecFilesRead.indexOf(strFilePath) != -1) {
            if (this.logContext != null) {
                this.logContext.write("! double include of " + strFilePath + " ignored");
            }
            return;
        }
        this.vecFilesRead.addElement(strFilePath);
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(fl));
                String strBuffer = null;
                while ((strBuffer = br.readLine()) != null) {
                    if ((strBuffer = strBuffer.trim()).length() < 2 || strBuffer.startsWith("#")) continue;
                    this.addAlias(strAlias, strBuffer);
                }
            }
            catch (IOException e) {
                if (this.logContext != null) {
                    this.logContext.write("? alias:addInclude " + e.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Helper.close(br);
            throw throwable;
        }
        Object var6_10 = null;
        Helper.close(br);
    }

    private String getLeft(String string) {
        int pp = string.indexOf(":", 1);
        if (pp == -1) {
            return null;
        }
        String s = string.substring(0, pp).trim();
        if (s.length() == 0) {
            return null;
        }
        return s.toLowerCase();
    }

    private String getRight(String string) {
        int pp = string.indexOf(":");
        if (pp == -1) {
            return null;
        }
        String s = string.substring(pp + 1).trim();
        if (s.length() == 0) {
            return null;
        }
        return s.toLowerCase();
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("test1: :include:n:\\alias.txt");
        v.addElement("postmaster: hohmann@harddiskcafe.de");
        v.addElement("news:       postmaster");
        v.addElement("newsadmin:  postmaster");
        v.addElement("newsadm:    postmaster");
        v.addElement("webmaster:  postmaster, bernd.hohmann@zwanzigeins.de");
        v.addElement("mail:\t\tpostmaster");
        v.addElement("root:       postmaster");
        Object[] s = new String[v.size()];
        v.copyInto(s);
        UserAlias ua = new UserAlias((String[])s);
        String strResolve = "hohmann@harddiskcafe.de";
        String[] res = ua.resolve(strResolve);
        int i = 0;
        while (i < res.length) {
            System.out.println(i + " " + strResolve + " " + res[i]);
            ++i;
        }
        System.out.println("**end**");
    }

    private void readAliases(String[] strAliase) {
        int i = 0;
        while (i < strAliase.length) {
            String strLeft = this.getLeft(strAliase[i]);
            String strRight = this.getRight(strAliase[i]);
            if (strLeft != null && strRight != null) {
                if (strLeft.toLowerCase().startsWith(":include")) {
                    strRight = strRight.substring(8).trim();
                    this.addInclude_1(strRight);
                } else if (strRight.toLowerCase().startsWith(":include:")) {
                    strRight = strRight.substring(9).trim();
                    this.addInclude_2(strLeft, strRight);
                } else if (!strRight.startsWith(":")) {
                    this.addAlias(strLeft, strRight);
                }
            }
            ++i;
        }
    }

    public String[] resolve(String strName) {
        this.vecResolved = new Vector();
        this.resolve0(strName.toLowerCase());
        Object[] strResolved = new String[this.vecResolved.size()];
        this.vecResolved.copyInto(strResolved);
        return strResolved;
    }

    private void resolve0(String strName) {
        if (this.intDepth > 5) {
            if (this.logContext != null) {
                this.logContext.write("? Alias: over-recursion ignored");
            }
            return;
        }
        ++this.intDepth;
        String strData = (String)this.hshAlias.get(strName);
        if (strData == null) {
            this.vecResolved.addElement(strName);
            --this.intDepth;
            return;
        }
        StringTokenizer strt = new StringTokenizer(strData, ",");
        while (strt.hasMoreTokens()) {
            this.resolve0(strt.nextToken().trim());
        }
        --this.intDepth;
    }
}

