/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class SampleUsage {
    private final void printImageTags(int n, Metadata metadata) {
        System.out.println();
        System.out.println("*** APPROACH " + n + " ***");
        System.out.println();
        Iterator iterator = metadata.getDirectoryIterator();
        while (iterator.hasNext()) {
            Object object;
            Directory directory = (Directory)iterator.next();
            Iterator iterator2 = directory.getTagIterator();
            while (iterator2.hasNext()) {
                object = (Tag)iterator2.next();
                System.out.println(object);
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
    }

    public static void main(String[] stringArray) {
        new SampleUsage("src/com/drew/metadata/test/withIptcExifGps.jpg");
    }

    public SampleUsage(String string) {
        Metadata metadata;
        Object object;
        Object object2;
        Object object3;
        File file = new File(string);
        try {
            object3 = JpegMetadataReader.readMetadata(file);
            this.printImageTags(1, (Metadata)object3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("error 1a");
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 1b");
        }
        try {
            object3 = new Metadata();
            new ExifReader(file).extract((Metadata)object3);
            new IptcReader(file).extract((Metadata)object3);
            this.printImageTags(2, (Metadata)object3);
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 2a");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("error 2b");
        }
        try {
            object3 = new JpegSegmentReader(file);
            object2 = ((JpegSegmentReader)object3).readSegment((byte)-31);
            object = ((JpegSegmentReader)object3).readSegment((byte)-19);
            metadata = new Metadata();
            new ExifReader((byte[])object2).extract(metadata);
            new IptcReader((byte[])object).extract(metadata);
            this.printImageTags(3, metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 3a");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("error 3b");
        }
        try {
            object3 = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream(file));
            object2 = object3.decodeAsBufferedImage();
            object = object3.getJPEGDecodeParam();
            metadata = JpegMetadataReader.readMetadata((JPEGDecodeParam)object);
            this.printImageTags(4, metadata);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("error 4a");
        }
        catch (IOException iOException) {
            System.err.println("error 4b");
        }
    }
}

