/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.gui.Alerts;

public class GUIUtilities
implements IFConstants {
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("Error setting native LAF: " + exception);
        }
    }

    public static void stylizeAsLabel(JTextArea jTextArea) {
        jTextArea.setFont(new Font("SansSerif", 0, 10));
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setHighlighter(null);
        jTextArea.setBorder(new JLabel().getBorder());
    }

    public static void setCellEditable(JTable jTable, boolean bl) {
        JTextField jTextField = new JTextField();
        jTextField.setFont(jTable.getFont());
        jTextField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (bl) {
            jTextField.setEditable(true);
        } else {
            jTextField.setEditable(false);
        }
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        int n = 0;
        while (n < jTable.getColumnCount()) {
            jTable.getColumnModel().getColumn(n).setCellEditor(defaultCellEditor);
            ++n;
        }
    }

    public static void setFrameSize(JFrame jFrame, Dimension dimension) {
        GUIUtilities.setFrameSize(jFrame, dimension.width, dimension.height);
    }

    public static void setFrameSize(JFrame jFrame, int n, int n2) {
        int n3 = n2;
        int n4 = n;
        n3 = IFConstants.isMac ? (n3 += 22) : (n3 += 47);
        jFrame.setSize(new Dimension(n4, n3));
    }

    public static void setDialogSize(JDialog jDialog, int n, int n2) {
        int n3 = n2 + 22;
        int n4 = n;
        jDialog.setSize(new Dimension(n4, n3));
    }

    public static boolean markMisspelledWords(JTextComponent jTextComponent) {
        return GUIUtilities.invokeSpellCheckMethod(jTextComponent, "markMisspelledWords");
    }

    public static boolean checkSpelling(JTextComponent jTextComponent) {
        return GUIUtilities.invokeSpellCheckMethod(jTextComponent, "checkSpelling");
    }

    private static final boolean invokeSpellCheckMethod(JTextComponent jTextComponent, String string) {
        try {
            Class<?> clazz = Class.forName("com.apple.spell.ui.JTextComponentDriver");
            Object obj = clazz.newInstance();
            Class[] classArray = new Class[1];
            Class clazz2 = class$javax$swing$text$JTextComponent;
            if (clazz2 == null) {
                clazz2 = class$javax$swing$text$JTextComponent = GUIUtilities.class$("[Ljavax.swing.text.JTextComponent;", false);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod(string, classArray);
            method.invoke(obj, jTextComponent);
            return true;
        }
        catch (Throwable throwable) {
            if (IFConstants.isMacOSX) {
                Alerts.showError("Spell Check Not Installed", "The spell-checker could not be located.  You should have\nreceived a file called \"JavaSpellingFramework.pkg\" with\nthis program.  Please install that package and then try\nthis again.");
            } else {
                Alerts.showError("Spell Check Not Available", "Sorry, spell check is only available on Apple's Mac OSX\noperating system.");
            }
            return false;
        }
    }

    public static JComboBox getYearComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = Calendar.getInstance().get(1);
        int n2 = 1998;
        while (n2 < n + 2) {
            jComboBox.addItem("" + n2);
            ++n2;
        }
        jComboBox.setSelectedIndex(n - 1998);
        return jComboBox;
    }

    public static JComboBox getMonthComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("January");
        jComboBox.addItem("February");
        jComboBox.addItem("March");
        jComboBox.addItem("April");
        jComboBox.addItem("May");
        jComboBox.addItem("June");
        jComboBox.addItem("July");
        jComboBox.addItem("August");
        jComboBox.addItem("September");
        jComboBox.addItem("October");
        jComboBox.addItem("November");
        jComboBox.addItem("December");
        int n = Calendar.getInstance().get(2);
        jComboBox.setSelectedIndex(n);
        return jComboBox;
    }

    public static JComboBox getDayComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 1;
        while (n < 32) {
            jComboBox.addItem("" + n);
            ++n;
        }
        n = Calendar.getInstance().get(5);
        jComboBox.setSelectedIndex(n - 1);
        return jComboBox;
    }

    public static String formatDecimal(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("00000000.00");
        StringBuffer stringBuffer = new StringBuffer();
        decimalFormat.format(d, stringBuffer, new FieldPosition(1));
        String string = stringBuffer.toString();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != '0') {
                n = n2;
                break;
            }
            ++n2;
        }
        String string2 = stringBuffer.toString().substring(n);
        if (string2.startsWith(".")) {
            string2 = "0" + string2;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

