/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import org.instituteofthefuture.gui.Alerts;
import org.instituteofthefuture.io.FileUtilities;

public class HtmlViewerFrame
extends JFrame {
    public static boolean DEBUG = false;
    private String fileName;

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    private final void load(File file) {
        try {
            this.fileName = file.getName();
            this.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            this.output(exception.toString());
            exception.printStackTrace();
            Alerts.showError("Error", exception.toString());
        }
    }

    private final void load(InputStream inputStream) {
        try {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            jTextPane.read(inputStream, (Object)new HTMLDocument());
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.fileName), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            jScrollPane.setOpaque(false);
            this.setTitle("Viewing " + this.fileName);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jScrollPane, "Center");
            this.setBounds(20, 20, 500, 400);
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.output(exception.toString());
            exception.printStackTrace();
            Alerts.showError("Error", exception.toString());
        }
    }

    private final void output(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        HtmlViewerFrame htmlViewerFrame = new HtmlViewerFrame("iotf/example.html", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HtmlViewerFrame(String string, boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            block6: {
                try {
                    if (bl) {
                        this.fileName = string;
                        this.load(FileUtilities.getInputStreamFromResource(string));
                        break block6;
                    }
                    this.load(new File(string));
                }
                catch (Exception exception) {
                    this.output(exception.toString());
                    exception.printStackTrace();
                    Alerts.showError("Error", exception.toString());
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ HtmlViewerFrame this$0;

            public final void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    this.this$0.close();
                }
            }
            {
                this.this$0 = htmlViewerFrame;
            }
        });
    }
}

