/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.File;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jexifviewer.JFileDataComparator;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.files.JPathHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JPathTreeNode.java,v 1.4 2010/04/02 12:12:13 reiner Exp $")
public final class JPathTreeNode
extends DefaultMutableTreeNode {
    private String m_name;
    private boolean m_bInAdding = false;
    private boolean m_bIsLeaf = false;
    private boolean m_bDummy = false;
    private boolean m_bCustom = false;

    public String toString() {
        if (this.m_bCustom) {
            StringBuffer stringBuffer = new StringBuffer();
            if (File.separatorChar == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(File.separatorChar);
            String[] stringArray = this.m_name.split(stringBuffer.toString());
            return stringArray != null && stringArray.length != 0 ? stringArray[stringArray.length - 1] : this.m_name;
        }
        return this.m_name;
    }

    public JPathTreeNode(String string, boolean bl, boolean bl2) {
        this.m_name = string;
        this.m_bIsLeaf = bl;
        this.m_bDummy = bl2;
        this.m_bCustom = false;
    }

    public JPathTreeNode(String string, boolean bl, boolean bl2, boolean bl3) {
        this.m_name = string;
        this.m_bIsLeaf = bl;
        this.m_bDummy = bl2;
        this.m_bCustom = bl3;
    }

    public boolean isLeaf() {
        return this.m_bIsLeaf;
    }

    public boolean isCustom() {
        return this.m_bCustom;
    }

    public boolean isDummy() {
        return this.m_bDummy;
    }

    public String getName() {
        return this.m_name;
    }

    public void addChilds(TreePath treePath) {
        Object[] objectArray;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!((JPathTreeNode)this.getChildAt(i)).isDummy()) continue;
            this.remove(i);
            break;
        }
        if ((objectArray = treePath.getPath()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object fileArray : objectArray) {
                JPathTreeNode jPathTreeNode = (JPathTreeNode)fileArray;
                if (jPathTreeNode.isDummy()) continue;
                JPathHelper.addSeparator(stringBuilder);
                stringBuilder.append(jPathTreeNode.getName());
            }
            File file = new File(stringBuilder.toString());
            final File[] fileArray = file.listFiles();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.m_mainFrame.m_progBar.setString(null);
                }
            });
            if (fileArray != null) {
                Arrays.sort(fileArray, new JFileDataComparator());
                int n2 = 0;
                for (File file2 : fileArray) {
                    final int n3 = n2++;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Main.m_mainFrame.m_progBar.setValue(n3 * 1000 / fileArray.length);
                        }
                    });
                    if (!file2.isDirectory() || file2.isHidden() || !file2.canRead()) continue;
                    this.add(new JPathTreeNode(file2.getName(), !JPathTreeNode.hasChilds(file2), false));
                }
            }
        }
    }

    public static boolean hasChilds(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory() || file2.isHidden() || !file2.canRead()) continue;
                return true;
            }
        }
        return false;
    }
}

