/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.FileSorter;
import java.io.File;

public class DefaultFileSorter
implements FileSorter {
    public void sort(File[] a) {
        File[] aux = (File[])a.clone();
        this.mergeSort(aux, a, 0, a.length);
    }

    private void mergeSort(File[] src, File[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && this.compareFiles(dest[j - 1], dest[j]) > 0) {
                    this.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = (low + high) / 2;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compareFiles(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            dest[i] = q >= high || p < mid && this.compareFiles(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private int compareFiles(File f1, File f2) {
        String s2;
        if (f1 == null && f2 == null) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        String s1 = f1.getName().toLowerCase();
        int result = s1.compareTo(s2 = f2.getName().toLowerCase());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public void sort(FileNode[] a) {
        FileNode[] aux = (FileNode[])a.clone();
        this.mergeSort(aux, a, 0, a.length);
    }

    private void mergeSort(FileNode[] src, FileNode[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && this.compareFileNodes(dest[j - 1], dest[j]) > 0) {
                    this.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = (low + high) / 2;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compareFileNodes(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            dest[i] = q >= high || p < mid && this.compareFileNodes(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private int compareFileNodes(FileNode f1, FileNode f2) {
        String s2;
        if (f1 == null && f2 == null) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        String s1 = f1.getName().toLowerCase();
        int result = s1.compareTo(s2 = f2.getName().toLowerCase());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    private void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

