/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.FileView;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;

public class DefaultFileView
extends FileView {
    protected FileSystemModel model;
    private Hashtable icons = new Hashtable(5);
    private Hashtable fileDescriptions = new Hashtable(5);
    private Hashtable typeDescriptions = new Hashtable(5);
    String genericFileDescription = LocalizedStringTable.getString("DefaultFileView.genericFileDescription");
    String genericFolderDescription = LocalizedStringTable.getString("DefaultFileView.genericFolderDescription");
    String floppyDriveDescription = LocalizedStringTable.getString("DefaultFileView.floppyDriveDescription");
    String hardDriveDescription = LocalizedStringTable.getString("DefaultFileView.hardDriveDescription");
    String computerDescription = LocalizedStringTable.getString("DefaultFileView.computerDescription");
    protected Icon directoryIcon = null;
    protected Icon openDirectoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;

    public void setModel(FileSystemModel model) {
        this.model = model;
    }

    public void setGenericFileDescription(String description) {
        if (description != null) {
            this.genericFileDescription = description;
        }
    }

    public void setGenericFolderDescription(String description) {
        if (description != null) {
            this.genericFolderDescription = description;
        }
    }

    public void setFloppyDriveDescription(String description) {
        if (description != null) {
            this.floppyDriveDescription = description;
        }
    }

    public void setHardDriveDescription(String description) {
        if (description != null) {
            this.hardDriveDescription = description;
        }
    }

    public void setComputerDescription(String description) {
        if (description != null) {
            this.computerDescription = description;
        }
    }

    public void setDefaultFileIcon(Icon icon) {
        if (icon != null) {
            this.fileIcon = icon;
        }
    }

    public void setDefaultDirectoryIcon(Icon icon) {
        if (icon != null) {
            this.directoryIcon = icon;
        }
    }

    public void setDefaultOpenDirectoryIcon(Icon icon) {
        if (icon != null) {
            this.openDirectoryIcon = icon;
        }
    }

    public void setDefaultFloppyDriveIcon(Icon icon) {
        if (icon != null) {
            this.floppyDriveIcon = icon;
        }
    }

    public void setDefaultHardDriveIcon(Icon icon) {
        if (icon != null) {
            this.hardDriveIcon = icon;
        }
    }

    public void setDefaultComputerIcon(Icon icon) {
        if (icon != null) {
            this.computerIcon = icon;
        }
    }

    public String getName(File f) {
        String fileName = null;
        if (f != null && (fileName = f.getName()).equals("")) {
            fileName = f.getPath();
        }
        return fileName;
    }

    public String getExtension(File f) {
        String name = this.getName(f);
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(extensionIndex + 1).toLowerCase();
        }
        return null;
    }

    public void putDescription(File f, String fileDescription) {
        String extension = this.getExtension(f);
        if (extension == null || fileDescription == null || fileDescription.equals("")) {
            return;
        }
        this.fileDescriptions.put(extension, fileDescription);
    }

    public String getDescription(File f) {
        String description = null;
        String extension = this.getExtension(f);
        if (extension != null) {
            description = (String)this.fileDescriptions.get(extension);
        }
        if (description != null) {
            return description;
        }
        if (this.model.isTraversable(f)) {
            return this.genericFolderDescription;
        }
        return this.genericFileDescription;
    }

    public void putTypeDescription(File f, String typeDescription) {
        String extension = this.getExtension(f);
        if (extension == null || typeDescription == null || typeDescription.equals("")) {
            return;
        }
        if (!this.model.isTraversable(f)) {
            this.typeDescriptions.put(extension, typeDescription);
        }
    }

    public String getTypeDescription(File f) {
        String overrideType = this.getOverrideTypeDescription(f);
        if (overrideType != null) {
            return overrideType;
        }
        String description = null;
        String extension = this.getExtension(f);
        if (extension != null) {
            description = (String)this.typeDescriptions.get(extension);
        }
        if (description != null) {
            return description.toUpperCase() + "-" + this.genericFileDescription;
        }
        if (this.model.isTraversable(f)) {
            return this.genericFolderDescription;
        }
        return this.genericFileDescription;
    }

    public void clearIcons() {
        this.icons = new Hashtable();
    }

    public void putIcon(File f, Icon icon) {
        String extension = this.getExtension(f);
        if (extension == null || icon == null) {
            return;
        }
        this.icons.put(extension, icon);
    }

    public Icon getIcon(File f) {
        Icon icon = null;
        String extension = this.getExtension(f);
        if (extension != null) {
            icon = (Icon)this.icons.get(extension);
        }
        if (icon == null) {
            icon = this.getOverrideTypeIcon(f);
        }
        return icon;
    }

    protected String getOverrideTypeDescription(File f) {
        String type = null;
        if (f != null && this.model.isTraversable(f)) {
            int dirType = this.model.getDirectoryType(f);
            switch (dirType) {
                case 1: {
                    type = this.floppyDriveDescription;
                    break;
                }
                case 2: {
                    type = this.hardDriveDescription;
                    break;
                }
                case 0: {
                    type = this.computerDescription;
                }
            }
        }
        return type;
    }

    protected Icon getOverrideTypeIcon(File f) {
        Icon icon = null;
        if (f != null && this.model.isTraversable(f)) {
            int dirType = this.model.getDirectoryType(f);
            switch (dirType) {
                case 1: {
                    icon = this.floppyDriveIcon;
                    break;
                }
                case 2: {
                    icon = this.hardDriveIcon;
                    break;
                }
                case 0: {
                    icon = this.computerIcon;
                    break;
                }
                case 3: {
                    icon = this.model.isCurrentDirectory(f) ? this.openDirectoryIcon : this.directoryIcon;
                }
            }
        } else {
            icon = this.fileIcon;
        }
        return icon;
    }
}

