/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.DefaultTableDirectoryModel;
import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.ExportComponentsFactory;
import com.hbworks.dirpane.FileFilter;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.TableDirectoryModel;
import com.hbworks.dirpane.TableDirectoryPaneSelectionModel;
import com.hbworks.dirpane.TableSelectionModel;
import com.hbworks.dirpane.plaf.TableDirectoryPaneUI;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableDirectoryPane
extends DirectoryPane {
    static final long serialVersionUID = 2321611740472322723L;
    private static final String uiClassID = "TableDirectoryPaneUI";
    public static final String VIEWCHANGED_PROPERTY = "viewChanged";
    public static final String LISTVIEW_PROPERTY = "listview";
    public static final String DETAILSVIEW_PROPERTY = "detailsview";
    public static final String AUTORESIZE_COLUMNS_PROPERTY = "autoresizeColumns";
    private Class[] defaultColumns = new Class[]{class$java$io$File == null ? (class$java$io$File = TableDirectoryPane.class$("java.io.File")) : class$java$io$File, class$java$lang$Long == null ? (class$java$lang$Long = TableDirectoryPane.class$("java.lang.Long")) : class$java$lang$Long, class$com$hbworks$dirpane$FileType == null ? (class$com$hbworks$dirpane$FileType = TableDirectoryPane.class$("com.hbworks.dirpane.FileType")) : class$com$hbworks$dirpane$FileType, class$java$util$Date == null ? (class$java$util$Date = TableDirectoryPane.class$("java.util.Date")) : class$java$util$Date};
    private String viewMode = "detailsview";
    private int autoResizeMode = 2;
    protected transient PropertyChangeListener columnWidthListener = null;
    protected transient Hashtable customRenderersByColumnClass = null;
    private transient Hashtable column_width_cache = new Hashtable();
    private int[] lastSortedColumnInfo = null;
    protected TableSelectionModel tableSelectionModel = null;
    private Action detailsViewAction = new DetailsViewAction();
    private Action listViewAction = new ListViewAction();
    protected ActionListener defaultActionListener = new DefaultActionListener();
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$hbworks$dirpane$FileType;
    static /* synthetic */ Class class$java$util$Date;

    public TableDirectoryPane() {
        this(null, null, null, null);
    }

    public TableDirectoryPane(String path) {
        this(null, null, path, null);
    }

    public TableDirectoryPane(String path, FileFilter filter) {
        this(null, null, path, filter);
    }

    public TableDirectoryPane(Class[] columnTypes, String[] columnNames) {
        this(columnTypes, columnNames, null, null);
    }

    public TableDirectoryPane(Class[] columnTypes, String[] columnNames, FileFilter filter) {
        this(columnTypes, columnNames, null, filter);
    }

    public TableDirectoryPane(Class[] columnTypes, String[] columnNames, String path) {
        this(columnTypes, columnNames, path, null);
    }

    public TableDirectoryPane(Class[] columnTypes, String[] columnNames, String path, FileFilter filter) {
        if (filter != null) {
            this.fileFilter = filter;
            this.addChoosableFileFilter(filter);
        }
        if (columnTypes == null) {
            columnTypes = this.defaultColumns;
        }
        this.setModel(this.createFileSystemModel(columnTypes, columnNames));
        this.defFileView.setModel(this.filesystemModel);
        this.setSelectionModel(this.createSelectionModel());
        this.addActionListener(this.getDefaultActionListener());
        this.setCurrentDirectory(path);
        this.setUserDirectory(this.getHomeDirectory().getPath());
        this.updateUI();
    }

    protected JTable getTableFromUI() {
        if (this.ui != null) {
            return ((TableDirectoryPaneUI)this.ui).getUITable();
        }
        return null;
    }

    public JComboBox getDirectoryComboBox() {
        return ExportComponentsFactory.createDirectoryComboBox(this);
    }

    public JToggleButton getListViewButton() {
        return ExportComponentsFactory.createListViewButton(this);
    }

    public JToggleButton getDetailsViewButton() {
        return ExportComponentsFactory.createDetailsViewButton(this);
    }

    public JTextField getFilenameField() {
        return ExportComponentsFactory.createTableFilenameField(this);
    }

    public void requestFocus() {
        JTable t = this.getTableFromUI();
        if (t != null) {
            t.requestFocus();
        }
    }

    public void setMbytesString(String mb) {
        if (this.ui != null) {
            ((TableDirectoryPaneUI)this.ui).setMbytesString(mb);
        }
    }

    public void setKbytesString(String kb) {
        if (this.ui != null) {
            ((TableDirectoryPaneUI)this.ui).setKbytesString(kb);
        }
    }

    public void setAutoResizeMode(int mode) {
        Integer oldMode = new Integer(this.autoResizeMode);
        Integer newMode = new Integer(mode);
        this.autoResizeMode = mode;
        this.firePropertyChange(AUTORESIZE_COLUMNS_PROPERTY, oldMode, newMode);
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setViewMode(String mode) {
        String newview;
        if (mode == null) {
            return;
        }
        String oldview = this.viewMode;
        this.viewMode = newview = mode;
        this.firePropertyChange(VIEWCHANGED_PROPERTY, oldview, newview);
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void addCustomRenderer(Class columnClass, TableCellRenderer renderer) {
        if (this.customRenderersByColumnClass == null) {
            this.customRenderersByColumnClass = new Hashtable();
        }
        this.customRenderersByColumnClass.put(columnClass, renderer);
    }

    public void removeCustomRenderer(Class columnClass) {
        if (columnClass == null || this.customRenderersByColumnClass == null) {
            return;
        }
        this.customRenderersByColumnClass.remove(columnClass);
    }

    public TableCellRenderer getCustomRenderer(Class columnClass) {
        if (columnClass == null || this.customRenderersByColumnClass == null) {
            return null;
        }
        Object renderer = this.customRenderersByColumnClass.get(columnClass);
        if (renderer != null) {
            return (TableCellRenderer)renderer;
        }
        return this.getCustomRenderer(columnClass.getSuperclass());
    }

    public Enumeration getKeysInCustomRenderersTable() {
        if (this.customRenderersByColumnClass == null) {
            return null;
        }
        return this.customRenderersByColumnClass.keys();
    }

    protected TableDirectoryModel createFileSystemModel(Class[] columnTypes, String[] columnNames) {
        return new DefaultTableDirectoryModel(this, columnTypes, columnNames);
    }

    protected void setModel(FileSystemModel newModel) {
        if (!(newModel instanceof TableDirectoryModel)) {
            throw new IllegalArgumentException("Wrong model type: TableDirectoryPane only accepts a TableDirectoryModel");
        }
        FileSystemModel oldModel = this.getModel();
        if (oldModel != null) {
            this.removePropertyChangeListener(oldModel);
        }
        this.filesystemModel = newModel;
        if (newModel != null) {
            this.addPropertyChangeListener(newModel);
        }
    }

    public TableColumnModel createTableColumnModel() {
        return new DefaultTableColumnModel();
    }

    public void setColumnNames(String[] newcolumnNames) {
        ((TableDirectoryModel)this.filesystemModel).replaceColumnNamesBy(newcolumnNames);
    }

    public void setColumnTypesAndNames(Class[] types, String[] names) {
        File previousCurDir = this.currentDirectory;
        this.currentDirectory = null;
        this.setModel(this.createFileSystemModel(types, names));
        this.setCurrentDirectory(previousCurDir.getPath());
        this.updateUI();
    }

    public Hashtable getColumnWidthCache() {
        return this.column_width_cache;
    }

    public void addColumnWidthListener(PropertyChangeListener l) {
        this.columnWidthListener = l;
        this.updateUI();
    }

    public void removeColumnWidthListener() {
        this.columnWidthListener = null;
        this.updateUI();
    }

    public PropertyChangeListener getColumnWidthListener() {
        return this.columnWidthListener;
    }

    public void setLastSortedColumnInfo(int[] info) {
        this.lastSortedColumnInfo = info;
    }

    public int[] getLastSortedColumnInfo() {
        return this.lastSortedColumnInfo;
    }

    protected TableSelectionModel createSelectionModel() {
        return new TableDirectoryPaneSelectionModel();
    }

    public TableSelectionModel getSelectionModel() {
        return this.tableSelectionModel;
    }

    protected void setSelectionModel(ListSelectionModel newModel) {
    }

    protected void setSelectionModel(TableSelectionModel newModel) {
        this.tableSelectionModel = newModel;
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        if (enabled) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
    }

    public void setSelectionMode(int mode) {
        this.tableSelectionModel.setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.tableSelectionModel.getSelectionMode();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (this.tableSelectionModel != null) {
            this.tableSelectionModel.addListSelectionListener(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        if (this.tableSelectionModel != null) {
            this.tableSelectionModel.removeListSelectionListener(l);
            l = null;
        }
    }

    public void scrollRowToVisible(int row) {
        Rectangle rec = null;
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null && (rec = uiTable.getCellRect(row, 0, false)) != null) {
            uiTable.scrollRectToVisible(rec);
        }
    }

    public int[] getSelectedIndices() {
        int[] indices = null;
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            TableSelectionModel lsm = (TableSelectionModel)uiTable.getSelectionModel();
            indices = lsm.getSelectedIndices();
        }
        if (indices == null) {
            indices = new int[]{};
        }
        return indices;
    }

    public int getAnchorSelectionIndex() {
        int index = -1;
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            ListSelectionModel lsm = uiTable.getSelectionModel();
            index = lsm.getAnchorSelectionIndex();
        }
        return index;
    }

    public int getLeadSelectionIndex() {
        int index = -1;
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            ListSelectionModel lsm = uiTable.getSelectionModel();
            index = lsm.getLeadSelectionIndex();
        }
        return index;
    }

    public boolean isSelectionEmpty() {
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            ListSelectionModel lsm = uiTable.getSelectionModel();
            return lsm.isSelectionEmpty();
        }
        return true;
    }

    public boolean isRowSelected(int row) {
        boolean selected = false;
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            selected = uiTable.isRowSelected(row);
        }
        return selected;
    }

    public void clearSelection() {
        JTable uiTable = this.getTableFromUI();
        if (uiTable != null) {
            uiTable.clearSelection();
        }
    }

    public Object[] getSelectedRow() {
        int index = this.getLeadSelectionIndex();
        if (index >= 0 && this.isRowSelected(index)) {
            return this.getRowAt(index);
        }
        return null;
    }

    public Vector getSelectedRows() {
        Vector<Object[]> v = new Vector<Object[]>();
        int[] indices = this.getSelectedIndices();
        int anchorIndex = this.getAnchorSelectionIndex();
        int leadIndex = this.getLeadSelectionIndex();
        Object[] anchor = null;
        Object[] lead = null;
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != anchorIndex && index != leadIndex) {
                v.addElement(this.getRowAt(index));
            } else if (index == anchorIndex) {
                anchor = this.getRowAt(index);
            } else if (index == leadIndex) {
                lead = this.getRowAt(index);
            }
            ++i;
        }
        if (anchor != null) {
            v.insertElementAt(anchor, 0);
        }
        if (lead != null) {
            v.addElement(lead);
        }
        return v;
    }

    public File getSelectedFile() {
        int index = this.getLeadSelectionIndex();
        if (index >= 0 && this.isRowSelected(index)) {
            return this.getFileAtRow(index);
        }
        return null;
    }

    public File[] getSelectedFiles() {
        Vector<File> v = new Vector<File>();
        int[] indices = this.getSelectedIndices();
        int anchorIndex = this.getAnchorSelectionIndex();
        int leadIndex = this.getLeadSelectionIndex();
        Object[] files = new File[indices.length];
        File anchor = null;
        File lead = null;
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != anchorIndex && index != leadIndex) {
                v.addElement(this.getFileAtRow(index));
            } else if (index == anchorIndex) {
                anchor = this.getFileAtRow(index);
            } else if (index == leadIndex) {
                lead = this.getFileAtRow(index);
            }
            ++i;
        }
        if (anchor != null) {
            v.insertElementAt(anchor, 0);
        }
        if (lead != null) {
            v.addElement(lead);
        }
        v.copyInto(files);
        return files;
    }

    public void createNewFolder() {
        File containingDir = this.getCurrentDirectory();
        if (this.isReadOnly(containingDir)) {
            return;
        }
        JTable t = this.getTableFromUI();
        if (t.isEditing()) {
            t.getCellEditor().cancelCellEditing();
        }
        String folderName = this.getDefaultNewFolderName();
        File newFolder = this.createFileObject(containingDir, folderName);
        int i = 2;
        while (this.doesFileExist(newFolder) && i < 100) {
            newFolder = this.createFileObject(containingDir, folderName + "(" + i + ")");
            ++i;
        }
        boolean b = this.createDirectory(containingDir, newFolder.getName());
        if (b) {
            this.startEditorOnFile(newFolder);
        }
    }

    public void startEditorOnFile(File file) {
        int editRow = this.getRowIndexOfFile(file);
        if (editRow == -1) {
            return;
        }
        this.scrollRowToVisible(editRow);
        this.getTableFromUI().editCellAt(editRow, 0);
    }

    public void setFileSystem(FileSystem newFileSystem) {
        FileSystem oldFileSystem = this.filesystemModel.getFileSystem();
        if (!newFileSystem.equals(oldFileSystem)) {
            this.blockAutoRefresher();
            this.clearAutoRefresher();
            this.filesystemModel.setFileSystem(newFileSystem);
            this.currentDirectory = null;
            this.setCurrentDirectory(this.getFileSystemRoot().getPath());
            this.firePropertyChange("fileSystemChanged", oldFileSystem, newFileSystem);
        }
    }

    public Object[] getRowAt(int index) {
        return ((TableDirectoryModel)this.filesystemModel).getRowAt(index);
    }

    public File getFileAtRow(int index) {
        return ((TableDirectoryModel)this.filesystemModel).getFileAtRow(index);
    }

    public Object getObjectAtRow(Class objecttype, int row) {
        return ((TableDirectoryModel)this.filesystemModel).getObjectAtRow(objecttype, row);
    }

    public int getRowCount() {
        return ((TableDirectoryModel)this.filesystemModel).getRowCount();
    }

    public Vector getAllRows() {
        return ((TableDirectoryModel)this.filesystemModel).getAllRows();
    }

    public int getRowIndexOfFile(File f) {
        return ((TableDirectoryModel)this.filesystemModel).getRowIndexOfFile(f);
    }

    public String[] getColumnNames() {
        return ((TableDirectoryModel)this.filesystemModel).getColumnNames();
    }

    public Object[] getColumnIdentifiers() {
        return ((TableDirectoryModel)this.filesystemModel).getColumnIdentifiers();
    }

    public Object getColumnIdentifier(int column) {
        return ((TableDirectoryModel)this.filesystemModel).getColumnIdentifier(column);
    }

    public Class getColumnClass(int column) {
        return ((TableDirectoryModel)this.filesystemModel).getColumnClass(column);
    }

    public Class[] getColumnTypes() {
        return ((TableDirectoryModel)this.filesystemModel).getColumnTypes();
    }

    public Vector getColumnTypesVector() {
        return ((TableDirectoryModel)this.filesystemModel).getColumnTypesVector();
    }

    public int getIndexOfColumnClass(Class c) {
        return ((TableDirectoryModel)this.filesystemModel).getIndexOfColumnClass(c);
    }

    public ActionListener getDefaultActionListener() {
        return this.defaultActionListener;
    }

    public void setDefaultActionListener(ActionListener l) {
        this.removeActionListener(this.defaultActionListener);
        this.defaultActionListener = l;
        this.addActionListener(this.defaultActionListener);
    }

    public void performDoubleClick() {
        File f = this.getSelectedFile();
        if (f == null) {
            return;
        }
        if (this.isTraversable(f)) {
            this.fireActionPerformed(this.getDoubleClickContainerCommand());
        } else {
            this.fireActionPerformed(this.getDoubleClickCommand());
        }
    }

    public Action getDetailsViewAction() {
        return this.detailsViewAction;
    }

    public Action getListViewAction() {
        return this.listViewAction;
    }

    public void setUI(TableDirectoryPaneUI ui) {
        if ((TableDirectoryPaneUI)this.ui != ui) {
            super.setUI(ui);
            this.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setUI((TableDirectoryPaneUI)UIManager.getUI(this));
        this.tableSelectionModel.undoClearSelection();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.validate();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.column_width_cache = new Hashtable();
        File curdir = null;
        curdir = !this.doesFileExist(this.currentDirectory) ? this.getWorkingDirectory() : this.getCurrentDirectory();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        this.setCurrentDirectory(curdir.getPath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ListViewAction
    extends AbstractAction {
        public ListViewAction() {
            super(LocalizedStringTable.getString("TableDirectoryPane.listViewAction"));
        }

        public void actionPerformed(ActionEvent e) {
            TableDirectoryPane.this.setViewMode(TableDirectoryPane.LISTVIEW_PROPERTY);
        }
    }

    protected class DetailsViewAction
    extends AbstractAction {
        public DetailsViewAction() {
            super(LocalizedStringTable.getString("TableDirectoryPane.detailsViewAction"));
        }

        public void actionPerformed(ActionEvent e) {
            TableDirectoryPane.this.setViewMode(TableDirectoryPane.DETAILSVIEW_PROPERTY);
        }
    }

    protected class DefaultActionListener
    implements ActionListener,
    Serializable {
        protected DefaultActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command != null && command.equals(TableDirectoryPane.this.getDoubleClickContainerCommand())) {
                TableDirectoryPane.this.setCurrentDirectory(TableDirectoryPane.this.getSelectedFile().getPath());
            }
        }
    }
}

