/*
 * Created on 12.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;

import de.ssfuture.tools.jfonttools.fontanalyser.CharTable;
import de.ssfuture.tools.jfonttools.fontanalyser.FontStudio;

/**
 * @author Sebastian Schleemilch
 */
public class FontAnalyser extends JFrame {
	Font font;
	JTabbedPane tabpane = new JTabbedPane(JTabbedPane.NORTH);
	
	public FontAnalyser(Font font) {
		super("Font Analyser: " + font.getName());
		this.font = font;
	
		CharTable ctable = new CharTable(font);
		tabpane.addTab("Char table", ctable);
		FontStudio studio = new FontStudio(font);
		tabpane.addTab("Font studio", studio);
		
		getContentPane().add(tabpane, "Center");
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		pack();
		setVisible(true);
	}

}
