/*
 * Created on 13.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

/**
 * @author Sebastian Schleemilch
 */
public class LicenseDialog extends JDialog {
	
	public LicenseDialog(Frame parent) {
		super(parent, "JFontTools - License", true);
		JLabel headline = new JLabel("<html><h1><center>License</center></h1></html>");
		getContentPane().add(headline, BorderLayout.NORTH);
		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		try {
			JEditorPane edit = new JEditorPane(
					LicenseDialog.class.getResource("resources/license.txt"));
			edit.setContentType("text/plain");
			edit.setEditable(false);
			edit.setFont(new Font("Arial", Font.PLAIN, 12));
			getContentPane().add(new JScrollPane(edit), BorderLayout.CENTER);
			WindowPositionTools.center_left(this);
			setVisible(true);
		} catch (IOException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this, "Could not read resources/license.rtf", 
					"Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
}
