/*
 * Created on 13.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;

/**
 * @author Sebastian Schleemilch
 */
public class WindowPositionTools {
	
	public static void center(Window frame) {
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		int x = (size.width - frame.getWidth()) /2;
		int y = (size.height - frame.getHeight()) /2;
		frame.setLocation(x, y);
	}
	
	public static void west(Window frame) {
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		int height = size.height - (size.height / 10);
		int width = size.width / 4;
		frame.setLocation(0, 0);
		frame.setSize(width, height);
	}
	
	public static void middle(Window frame) {
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		int x = size.width / 4;
		int y = size.height / 4;
		frame.setLocation(x, y);
		frame.setSize(x*2, y*2);
	}
	
	public static void center_left(Window frame) {
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		int height = size.height - (size.height / 10);
		int width = size.width / 4;
		frame.setLocation(width, 0);
		frame.setSize(width * 3, height);
	}
}
