/*
 * Decompiled with CFR 0.152.
 */
package mindbright.security;

import mindbright.security.MessageDigest;

public final class SHA1
extends MessageDigest {
    private int[] hash;
    private int[] W;
    private long count;
    private int rest;
    private byte[] buffer = new byte[64];
    static byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int F00_19(int n, int n2, int n3) {
        return ((n2 ^ n3) & n ^ n3) + 1518500249;
    }

    private static int F20_39(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + 1859775393;
    }

    private static int F40_59(int n, int n2, int n3) {
        return (n & n2 | (n | n2) & n3) + -1894007588;
    }

    private static int F60_79(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + -899497514;
    }

    private void transform(byte[] byArray, int n) {
        int n2;
        int n3 = this.hash[0];
        int n4 = this.hash[1];
        int n5 = this.hash[2];
        int n6 = this.hash[3];
        int n7 = this.hash[4];
        int n8 = 0;
        while (n8 < 16) {
            this.W[n8] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            ++n8;
        }
        n8 = 16;
        while (n8 < 80) {
            n2 = this.W[n8 - 3] ^ this.W[n8 - 8] ^ this.W[n8 - 14] ^ this.W[n8 - 16];
            this.W[n8] = SHA1.rotateLeft(n2, 1);
            ++n8;
        }
        n8 = 0;
        while (n8 < 20) {
            n2 = SHA1.rotateLeft(n3, 5) + SHA1.F00_19(n4, n5, n6) + n7 + this.W[n8];
            n7 = n6;
            n6 = n5;
            n5 = SHA1.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n2;
            ++n8;
        }
        n8 = 20;
        while (n8 < 40) {
            n2 = SHA1.rotateLeft(n3, 5) + SHA1.F20_39(n4, n5, n6) + n7 + this.W[n8];
            n7 = n6;
            n6 = n5;
            n5 = SHA1.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n2;
            ++n8;
        }
        n8 = 40;
        while (n8 < 60) {
            n2 = SHA1.rotateLeft(n3, 5) + SHA1.F40_59(n4, n5, n6) + n7 + this.W[n8];
            n7 = n6;
            n6 = n5;
            n5 = SHA1.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n2;
            ++n8;
        }
        n8 = 60;
        while (n8 < 80) {
            n2 = SHA1.rotateLeft(n3, 5) + SHA1.F60_79(n4, n5, n6) + n7 + this.W[n8];
            n7 = n6;
            n6 = n5;
            n5 = SHA1.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n2;
            ++n8;
        }
        this.hash[0] = this.hash[0] + n3;
        this.hash[1] = this.hash[1] + n4;
        this.hash[2] = this.hash[2] + n5;
        this.hash[3] = this.hash[3] + n6;
        this.hash[4] = this.hash[4] + n7;
    }

    public SHA1() {
        this.hash = new int[5];
        this.W = new int[80];
        this.reset();
    }

    private SHA1(SHA1 sHA1) {
        this.hash = new int[5];
        this.W = new int[80];
        System.arraycopy(sHA1.hash, 0, this.hash, 0, 5);
        System.arraycopy(sHA1.buffer, 0, this.buffer, 0, 64);
        this.count = sHA1.count;
        this.rest = sHA1.rest;
    }

    public Object clone() {
        return new SHA1(this);
    }

    public String getName() {
        return "SHA1";
    }

    public void reset() {
        this.hash[0] = 1732584193;
        this.hash[1] = -271733879;
        this.hash[2] = -1732584194;
        this.hash[3] = 271733878;
        this.hash[4] = -1009589776;
        this.count = 0L;
        this.rest = 0;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 64 - this.rest;
        this.count += (long)n2;
        if (this.rest > 0 && n2 >= n3) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n3);
            this.transform(this.buffer, 0);
            n += n3;
            n2 -= n3;
            this.rest = 0;
        }
        while (n2 > 63) {
            this.transform(byArray, n);
            n += 64;
            n2 -= 64;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n2);
            this.rest += n2;
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[20];
        this.digestInto(byArray, 0);
        return byArray;
    }

    public int digestInto(byte[] byArray, int n) {
        int n2 = this.rest < 56 ? 56 - this.rest : 120 - this.rest;
        this.count *= 8L;
        byte[] byArray2 = new byte[]{(byte)(this.count >> 56), (byte)(this.count >> 58), (byte)(this.count >> 40), (byte)(this.count >> 32), (byte)(this.count >> 24), (byte)(this.count >> 16), (byte)(this.count >> 8), (byte)this.count};
        this.update(padding, 0, n2);
        this.update(byArray2, 0, 8);
        int n3 = 0;
        while (n3 < 5) {
            byArray[n++] = (byte)(this.hash[n3] >>> 24 & 0xFF);
            byArray[n++] = (byte)(this.hash[n3] >>> 16 & 0xFF);
            byArray[n++] = (byte)(this.hash[n3] >>> 8 & 0xFF);
            byArray[n++] = (byte)(this.hash[n3] & 0xFF);
            ++n3;
        }
        this.reset();
        return 20;
    }

    public int blockSize() {
        return 64;
    }

    public int hashSize() {
        return 20;
    }
}

