/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Properties;

public abstract class TerminalDefProps {
    public static final String[] terminalTypes = new String[]{"xterm", "linux", "scoansi", "att6386", "sun", "aixterm", "vt220", "vt100", "ansi", "vt52", "xterm-color", "linux-lat", "", "at386", "", "", "vt320", "vt102"};
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static final int PROP_DESC = 2;
    public static final int PROP_ALLOWED = 3;
    public static Properties defaultProperties = new Properties();
    public static final String[][] defaultPropDesc = new String[][]{{"rv", "false", "reverse video", "(true/false)"}, {"aw", "true", "autowrap of line if output reaches edge of window", "(true/false)"}, {"rw", "false", "reverse autowrap when going off left edge of window", "(true/false)"}, {"im", "false", "insert mode", "(true/false)"}, {"al", "false", "do auto-linefeed", "(true/false)"}, {"sk", "true", "reposition scroll-area to bottom on keyboard input", "(true/false)"}, {"si", "true", "reposition scroll-area to bottom on output to screen", "(true/false)"}, {"lp", "false", "use PgUp, PgDn, Home, End keys locally or escape them to shell", "(true/false)"}, {"sc", "false", "put <CR><NL> instead of <CR> at end of lines when selecting", "(true/false)"}, {"vi", "true", "visible cursor", "(true/false)"}, {"ad", "false", "ASCII Line-draw-characters", "(true/false)"}, {"le", "false", "do local echo", "(true/false)"}, {"sf", "false", "scale font when resizing window", "(true/false)"}, {"vb", "false", "visual bell", "(true/false)"}, {"ct", "true", "map <ctrl>+<space> to <NUL>", "(true/false)"}, {"dc", "false", "toggle 80/132 columns", "(true/false)"}, {"da", "true", "enable 80/132 switching", "(true/false)"}, {"cs", "true", "copy on mouse-selection", "(true/false)"}, {"fn", TerminalDefProps.defaultFont(), "name of font to use in terminal", "(" + TerminalDefProps.fontList() + ")"}, {"fs", "12", "size of font to use in terminal", "(system dep.)"}, {"gm", "80x24", "geometry of terminal", "('<cols>x<rows>')"}, {"te", terminalTypes[0], "name of terminal to emulate", "(" + TerminalDefProps.listAvailableTerminalTypes() + ")"}, {"sl", "512", "number of lines to save in \"scrollback\" buffer", "(0 - 8k)"}, {"sb", "right", "scrollbar position", "(none/left/right)"}, {"bg", "white", "background color", "(<name> or '<r>,<g>,<b>')"}, {"fg", "black", "foreground color", "(<name> or '<r>,<g>,<b>')"}, {"cc", "i_blue", "cursor color", "(<name> or '<r>,<g>,<b>')"}, {"rg", "bottom", "resize gravity, fixpoint of screen when resizing", "(top/bottom)"}, {"bs", "DEL", "character to send on BACKSPACE", "('BS' or 'DEL')"}, {"de", "DEL", "character to send on DELETE", "('BS' or 'DEL')"}, {"sd", "\" \"", "delimeter characters for click-selection", "<string>"}};
    public static String[] systemFonts;

    public static String listAvailableTerminalTypes() {
        String string = " ";
        int n = 0;
        while (n < terminalTypes.length) {
            string = string + terminalTypes[n] + " ";
            ++n;
        }
        return string;
    }

    public static String fontList() {
        if (systemFonts == null) {
            systemFonts = Toolkit.getDefaultToolkit().getFontList();
        }
        String string = "";
        int n = 0;
        while (n < systemFonts.length) {
            string = string + systemFonts[n];
            if (n < systemFonts.length - 1) {
                string = string + ", ";
            }
            ++n;
        }
        return string;
    }

    public static String defaultFont() {
        if (TerminalDefProps.fontExists("monospaced")) {
            return "Monospaced";
        }
        if (TerminalDefProps.fontExists("courier")) {
            return "Courier";
        }
        if (TerminalDefProps.fontExists("dialoginput")) {
            return "DialogInput";
        }
        return systemFonts[0];
    }

    public static boolean fontExists(String string) {
        if (systemFonts == null) {
            systemFonts = Toolkit.getDefaultToolkit().getFontList();
        }
        int n = 0;
        while (n < systemFonts.length) {
            if (systemFonts[n].equalsIgnoreCase(string)) break;
            ++n;
        }
        return n != systemFonts.length;
    }

    public static boolean isProperty(String string) {
        return ((Hashtable)defaultProperties).containsKey(string);
    }

    static {
        int n = 0;
        while (n < defaultPropDesc.length) {
            ((Hashtable)defaultProperties).put(defaultPropDesc[n][0], defaultPropDesc[n][1]);
            ++n;
        }
    }
}

