/*
 * Decompiled with CFR 0.152.
 */
package mindbright.vnc;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import mindbright.application.MindVNC;
import mindbright.vnc.animatedMemoryImageSource;
import mindbright.vnc.rfbProto;

public class vncCanvas
extends Canvas {
    MindVNC v;
    rfbProto rfb;
    ColorModel cm;
    Color[] colors;
    Image rawPixelsImage;
    animatedMemoryImageSource amis;
    byte[] pixels;
    Graphics sg;
    Graphics sg2;
    Image paintImage;
    Graphics pig;
    Graphics pig2;
    boolean needToResetClip;
    boolean connected;

    public vncCanvas(MindVNC mindVNC) throws IOException {
        this.v = mindVNC;
        this.rfb = this.v.rfb;
        this.cm = new DirectColorModel(8, 7, 56, 192);
        this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
        this.colors = new Color[256];
        int n = 0;
        while (n < 256) {
            this.colors[n] = new Color(this.cm.getRGB(n));
            ++n;
        }
        this.pixels = new byte[this.rfb.framebufferWidth * this.rfb.framebufferHeight];
        this.amis = new animatedMemoryImageSource(this.rfb.framebufferWidth, this.rfb.framebufferHeight, this.cm, this.pixels);
        this.rawPixelsImage = this.createImage(this.amis);
        this.paintImage = this.v.createImage(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        this.pig = this.paintImage.getGraphics();
    }

    public Dimension preferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension minimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.paintImage, 0, 0, this);
    }

    public void processNormalProtocol() throws IOException {
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        this.sg = this.getGraphics();
        this.needToResetClip = false;
        this.connected = true;
        while (this.connected) {
            int n = this.rfb.readServerMessageType();
            switch (n) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    int n2 = 0;
                    while (n2 < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        if (this.needToResetClip) {
                            if (this.rfb.updateRectEncoding != 0) {
                                try {
                                    this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                    this.pig.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    // empty catch block
                                }
                                this.needToResetClip = false;
                            }
                        }
                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                this.drawRawRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                break;
                            }
                            case 1: {
                                this.rfb.readCopyRect();
                                this.pig.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, this.rfb.updateRectW, this.rfb.updateRectH, this.rfb.updateRectX - this.rfb.copyRectSrcX, this.rfb.updateRectY - this.rfb.copyRectSrcY);
                                if (this.v.options.copyRectFast) {
                                    this.sg.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, this.rfb.updateRectW, this.rfb.updateRectH, this.rfb.updateRectX - this.rfb.copyRectSrcX, this.rfb.updateRectY - this.rfb.copyRectSrcY);
                                    break;
                                }
                                this.sg.drawImage(this.paintImage, 0, 0, this);
                                break;
                            }
                            case 2: {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8 = this.rfb.is.readInt();
                                int n9 = this.rfb.is.read();
                                this.sg.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.sg.setColor(this.colors[n9]);
                                this.sg.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                this.pig.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.pig.setColor(this.colors[n9]);
                                this.pig.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                int n10 = 0;
                                while (n10 < n8) {
                                    n7 = this.rfb.is.read();
                                    n6 = this.rfb.is.readUnsignedShort();
                                    n5 = this.rfb.is.readUnsignedShort();
                                    n4 = this.rfb.is.readUnsignedShort();
                                    n3 = this.rfb.is.readUnsignedShort();
                                    this.sg.setColor(this.colors[n7]);
                                    this.sg.fillRect(n6, n5, n4, n3);
                                    this.pig.setColor(this.colors[n7]);
                                    this.pig.fillRect(n6, n5, n4, n3);
                                    ++n10;
                                }
                                this.sg.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                this.pig.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                break;
                            }
                            case 4: {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n11 = this.rfb.is.readInt();
                                int n9 = this.rfb.is.read();
                                this.sg.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.sg.setColor(this.colors[n9]);
                                this.sg.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                this.pig.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.pig.setColor(this.colors[n9]);
                                this.pig.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                int n10 = 0;
                                while (n10 < n11) {
                                    n7 = this.rfb.is.read();
                                    n6 = this.rfb.is.read();
                                    n5 = this.rfb.is.read();
                                    n4 = this.rfb.is.read();
                                    n3 = this.rfb.is.read();
                                    this.sg.setColor(this.colors[n7]);
                                    this.sg.fillRect(n6, n5, n4, n3);
                                    this.pig.setColor(this.colors[n7]);
                                    this.pig.fillRect(n6, n5, n4, n3);
                                    ++n10;
                                }
                                this.sg.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                this.pig.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                break;
                            }
                            case 5: {
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n10;
                                int n12 = 0;
                                int n9 = 0;
                                int n3 = this.rfb.updateRectY;
                                while (n3 < this.rfb.updateRectY + this.rfb.updateRectH) {
                                    n10 = this.rfb.updateRectX;
                                    while (n10 < this.rfb.updateRectX + this.rfb.updateRectW) {
                                        int n13 = 16;
                                        int n14 = 16;
                                        if (this.rfb.updateRectX + this.rfb.updateRectW - n10 < 16) {
                                            n13 = this.rfb.updateRectX + this.rfb.updateRectW - n10;
                                        }
                                        if (this.rfb.updateRectY + this.rfb.updateRectH - n3 < 16) {
                                            n14 = this.rfb.updateRectY + this.rfb.updateRectH - n3;
                                        }
                                        int n15 = this.rfb.is.read();
                                        if ((n15 & 1) != 0) {
                                            this.drawRawRect(n10, n3, n13, n14);
                                        } else {
                                            if (this.needToResetClip) {
                                                try {
                                                    this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                    this.pig.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                }
                                                catch (NoSuchMethodError noSuchMethodError) {
                                                    // empty catch block
                                                }
                                                this.needToResetClip = false;
                                            }
                                            if ((n15 & 2) != 0) {
                                                n12 = this.rfb.is.read();
                                            }
                                            this.sg.setColor(this.colors[n12]);
                                            this.sg.fillRect(n10, n3, n13, n14);
                                            this.pig.setColor(this.colors[n12]);
                                            this.pig.fillRect(n10, n3, n13, n14);
                                            if ((n15 & 4) != 0) {
                                                n9 = this.rfb.is.read();
                                            }
                                            if ((n15 & 8) != 0) {
                                                int n16;
                                                int n17;
                                                int n18;
                                                int n19 = this.rfb.is.read();
                                                this.sg.translate(n10, n3);
                                                this.pig.translate(n10, n3);
                                                if ((n15 & 0x10) != 0) {
                                                    n18 = 0;
                                                    while (n18 < n19) {
                                                        n9 = this.rfb.is.read();
                                                        n17 = this.rfb.is.read();
                                                        n16 = this.rfb.is.read();
                                                        n7 = n17 >> 4;
                                                        n6 = n17 & 0xF;
                                                        n5 = (n16 >> 4) + 1;
                                                        n4 = (n16 & 0xF) + 1;
                                                        this.sg.setColor(this.colors[n9]);
                                                        this.sg.fillRect(n7, n6, n5, n4);
                                                        this.pig.setColor(this.colors[n9]);
                                                        this.pig.fillRect(n7, n6, n5, n4);
                                                        ++n18;
                                                    }
                                                } else {
                                                    this.sg.setColor(this.colors[n9]);
                                                    this.pig.setColor(this.colors[n9]);
                                                    n18 = 0;
                                                    while (n18 < n19) {
                                                        n17 = this.rfb.is.read();
                                                        n16 = this.rfb.is.read();
                                                        n7 = n17 >> 4;
                                                        n6 = n17 & 0xF;
                                                        n5 = (n16 >> 4) + 1;
                                                        n4 = (n16 & 0xF) + 1;
                                                        this.sg.fillRect(n7, n6, n5, n4);
                                                        this.pig.fillRect(n7, n6, n5, n4);
                                                        ++n18;
                                                    }
                                                }
                                                this.sg.translate(-n10, -n3);
                                                this.pig.translate(-n10, -n3);
                                            }
                                        }
                                        n10 += 16;
                                    }
                                    n3 += 16;
                                }
                                break;
                            }
                            default: {
                                throw new IOException("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                            }
                        }
                        ++n2;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, true);
                    break;
                }
                case 1: {
                    throw new IOException("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    System.out.print('\u0007');
                    break;
                }
                case 3: {
                    String string = this.rfb.readServerCutText();
                    this.v.clipboard.setCutText(string);
                    break;
                }
                case -1: {
                    this.connected = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown RFB message type " + n);
                }
            }
        }
    }

    void drawRawRect(int n, int n2, int n3, int n4) throws IOException {
        if (this.v.options.drawEachPixelForRawRects) {
            int n5 = n2;
            while (n5 < n2 + n4) {
                int n6 = n;
                while (n6 < n + n3) {
                    int n7 = this.rfb.is.read();
                    this.sg.setColor(this.colors[n7]);
                    this.sg.fillRect(n6, n5, 1, 1);
                    this.pig.setColor(this.colors[n7]);
                    this.pig.fillRect(n6, n5, 1, 1);
                    ++n6;
                }
                ++n5;
            }
            return;
        }
        int n8 = n2;
        while (n8 < n2 + n4) {
            this.rfb.is.readFully(this.pixels, n8 * this.rfb.framebufferWidth + n, n3);
            ++n8;
        }
        this.amis.newPixels(n, n2, n3, n4);
        try {
            this.sg.setClip(n, n2, n3, n4);
            this.pig.setClip(n, n2, n3, n4);
            this.needToResetClip = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.sg2 = this.sg.create();
            this.sg.clipRect(n, n2, n3, n4);
            this.pig2 = this.pig.create();
            this.pig.clipRect(n, n2, n3, n4);
        }
        this.sg.drawImage(this.rawPixelsImage, 0, 0, this);
        this.pig.drawImage(this.rawPixelsImage, 0, 0, this);
        if (this.sg2 != null) {
            this.sg.dispose();
            this.sg = this.sg2;
            this.sg2 = null;
            this.pig.dispose();
            this.pig = this.pig2;
            this.pig2 = null;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.rfb != null && this.rfb.inNormalProtocol) {
            try {
                switch (event.id) {
                    case 501: 
                    case 502: 
                    case 503: 
                    case 506: {
                        if (this.v.gotFocus) {
                            this.requestFocus();
                        }
                        this.rfb.writePointerEvent(event);
                        break;
                    }
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: {
                        this.rfb.writeKeyEvent(event);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

