/*
 * Decompiled with CFR 0.152.
 */
package mindbright.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    int max = 0;
    int current = 0;
    int width = 0;
    int height = 0;
    Color barColor;
    FontMetrics fm;
    Image img;
    Graphics memG;

    public synchronized void setBarColor(Color color) {
        this.barColor = color;
    }

    public synchronized void setValue(int n) {
        this.setValue(n, false);
    }

    public synchronized void setValue(int n, boolean bl) {
        int n2 = this.current = n > this.max ? this.max : n;
        if (bl) {
            this.update(this.getGraphics());
        } else {
            this.repaint();
        }
    }

    public synchronized void setMax(int n, boolean bl) {
        this.max = n;
        if (bl) {
            this.current = 0;
        }
        this.setValue(this.current, true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public ProgressBar(int n, int n2, int n3) {
        this.max = n;
        this.width = n2;
        this.height = n3;
        this.barColor = Color.black;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        int n = this.max != 0 ? this.max : 1;
        double d = (double)this.current * 100.0 / (double)n;
        String string = (int)d + "%";
        int n2 = this.current * (this.width - 2) / n;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        if (this.img == null) {
            this.setBackground(Color.white);
            this.img = this.createImage(this.width, this.height);
            this.memG = this.img.getGraphics();
        }
        this.memG.setPaintMode();
        this.memG.setColor(Color.white);
        this.memG.fillRect(0, 0, this.width, this.height);
        this.memG.setColor(Color.black);
        this.memG.drawRect(0, 0, this.width - 1, this.height - 1);
        this.memG.drawString(string, this.width / 2 - this.fm.stringWidth(string) / 2 + 1, this.height / 2 + this.fm.getMaxAscent() + this.fm.getLeading() - this.fm.getHeight() / 2);
        this.memG.setColor(this.barColor);
        this.memG.setXORMode(Color.white);
        this.memG.fillRect(1, 1, n2, this.height - 2);
        graphics.drawImage(this.img, 0, 0, this);
    }
}

