/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.math.BigInteger;
import mindbright.security.Cipher;
import mindbright.security.KeyPair;
import mindbright.security.MessageDigest;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.ssh.SSHRSAPublicKeyString;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public abstract class SSH {
    private static ThreadGroup threadGroup;
    private static int thrdPart;
    public static boolean DEBUG;
    public static boolean DEBUGMORE;
    public static final boolean NETSCAPE_SECURITY_MODEL = true;
    public static final int SSH_VER_MAJOR = 1;
    public static final int SSH_VER_MINOR = 5;
    public static final String VER_SSHPKG = "v1.2.1SCP3";
    public static final String VER_MINDTERM = "MindTerm v1.2.1SCP3";
    public static final String VER_MINDTUNL = "MindTunnel v1.2.1SCP3";
    public static final String CVS_NAME = "$Name:  $";
    public static final String CVS_DATE = "$Date: 2001/02/08 18:42:12 $";
    public static final int DEFAULTPORT = 22;
    public static final int SESSION_KEY_LENGTH = 256;
    public static final int SERVER_KEY_LENGTH = 768;
    public static final int HOST_KEY_LENGTH = 1024;
    public static final int PROTOFLAG_SCREEN_NUMBER = 1;
    public static final int PROTOFLAG_HOST_IN_FWD_OPEN = 2;
    public static final int MSG_ANY = -1;
    public static final int MSG_NONE = 0;
    public static final int MSG_DISCONNECT = 1;
    public static final int SMSG_PUBLIC_KEY = 2;
    public static final int CMSG_SESSION_KEY = 3;
    public static final int CMSG_USER = 4;
    public static final int CMSG_AUTH_RHOSTS = 5;
    public static final int CMSG_AUTH_RSA = 6;
    public static final int SMSG_AUTH_RSA_CHALLENGE = 7;
    public static final int CMSG_AUTH_RSA_RESPONSE = 8;
    public static final int CMSG_AUTH_PASSWORD = 9;
    public static final int CMSG_REQUEST_PTY = 10;
    public static final int CMSG_WINDOW_SIZE = 11;
    public static final int CMSG_EXEC_SHELL = 12;
    public static final int CMSG_EXEC_CMD = 13;
    public static final int SMSG_SUCCESS = 14;
    public static final int SMSG_FAILURE = 15;
    public static final int CMSG_STDIN_DATA = 16;
    public static final int SMSG_STDOUT_DATA = 17;
    public static final int SMSG_STDERR_DATA = 18;
    public static final int CMSG_EOF = 19;
    public static final int SMSG_EXITSTATUS = 20;
    public static final int MSG_CHANNEL_OPEN_CONFIRMATION = 21;
    public static final int MSG_CHANNEL_OPEN_FAILURE = 22;
    public static final int MSG_CHANNEL_DATA = 23;
    public static final int MSG_CHANNEL_CLOSE = 24;
    public static final int MSG_CHANNEL_CLOSE_CONFIRMATION = 25;
    public static final int MSG_CHANNEL_INPUT_EOF = 24;
    public static final int MSG_CHANNEL_OUTPUT_CLOSED = 25;
    public static final int SMSG_X11_OPEN = 27;
    public static final int CMSG_PORT_FORWARD_REQUEST = 28;
    public static final int MSG_PORT_OPEN = 29;
    public static final int CMSG_AGENT_REQUEST_FORWARDING = 30;
    public static final int SMSG_AGENT_OPEN = 31;
    public static final int MSG_IGNORE = 32;
    public static final int CMSG_EXIT_CONFIRMATION = 33;
    public static final int CMSG_X11_REQUEST_FORWARDING = 34;
    public static final int CMSG_AUTH_RHOSTS_RSA = 35;
    public static final int MSG_DEBUG = 36;
    public static final int CMSG_REQUEST_COMPRESSION = 37;
    public static final int CMSG_MAX_PACKET_SIZE = 38;
    public static final int CMSG_AUTH_TIS = 39;
    public static final int SMSG_AUTH_TIS_CHALLENGE = 40;
    public static final int CMSG_AUTH_TIS_RESPONSE = 41;
    public static final int CMSG_AUTH_SDI = 16;
    public static final int CMSG_ACM_OK = 64;
    public static final int CMSG_ACM_ACCESS_DENIED = 65;
    public static final int CMSG_ACM_NEXT_CODE_REQUIRED = 66;
    public static final int CMSG_ACM_NEXT_CODE = 67;
    public static final int CMSG_ACM_NEW_PIN_REQUIRED = 68;
    public static final int CMSG_ACM_NEW_PIN_ACCEPTED = 69;
    public static final int CMSG_ACM_NEW_PIN_REJECTED = 70;
    public static final int CMSG_ACM_NEW_PIN = 71;
    public static final int IDX_CIPHER_CLASS = 0;
    public static final int IDX_CIPHER_NAME = 1;
    public static final String[][] cipherClasses;
    public static final int CIPHER_NONE = 0;
    public static final int CIPHER_IDEA = 1;
    public static final int CIPHER_DES = 2;
    public static final int CIPHER_3DES = 3;
    public static final int CIPHER_TSS = 4;
    public static final int CIPHER_RC4 = 5;
    public static final int CIPHER_BLOWFISH = 6;
    public static final int CIPHER_RESERVED = 7;
    public static final int CIPHER_NOTSUPPORTED = 8;
    public static final int CIPHER_DEFAULT = 3;
    public static final String[] authTypeDesc;
    public static final int AUTH_RHOSTS = 1;
    public static final int AUTH_RSA = 2;
    public static final int AUTH_PASSWORD = 3;
    public static final int AUTH_RHOSTS_RSA = 4;
    public static final int AUTH_TIS = 5;
    public static final int AUTH_KERBEROS = 6;
    public static final int PASS_KERBEROS_TGT = 7;
    public static final int AUTH_SDI = 8;
    public static final int AUTH_NOTSUPPORTED;
    public static final int AUTH_DEFAULT = 3;
    static final String[] proxyTypes;
    static final int[] defaultProxyPorts;
    public static final int PROXY_NONE = 0;
    public static final int PROXY_HTTP = 1;
    public static final int PROXY_SOCKS4 = 2;
    public static final int PROXY_SOCKS5_DNS = 3;
    public static final int PROXY_SOCKS5_IP = 4;
    public static final int PROXY_NOTSUPPORTED;
    public static final int TTY_OP_END = 0;
    public static final int TTY_OP_ISPEED = 192;
    public static final int TTY_OP_OSPEED = 193;
    public static final int MAIN_CHAN_NUM = -1;
    public static final int CONNECT_CHAN_NUM = -2;
    public static final int LISTEN_CHAN_NUM = -3;
    public static final int UNKNOWN_CHAN_NUM = -4;
    public static final String KNOWN_HOSTS_FILE = "known_hosts";
    public static final int SRV_HOSTKEY_KNOWN = 0;
    public static final int SRV_HOSTKEY_NEW = 1;
    public static final int SRV_HOSTKEY_CHANGED = 2;
    public static SecureRandom secureRandom;
    protected byte[] sessionKey;
    protected byte[] sessionId;
    protected Cipher sndCipher;
    protected Cipher rcvCipher;
    protected int cipherType;
    protected byte[] srvCookie;
    protected KeyPair srvServerKey;
    protected KeyPair srvHostKey;
    protected int protocolFlags;
    protected int supportedCiphers;
    protected int supportedAuthTypes;
    protected boolean isAnSSHClient = true;

    public static synchronized String createThreadName() {
        return "SSH-" + thrdPart++;
    }

    public static ThreadGroup getThreadGroup() {
        if (threadGroup == null) {
            try {
                PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                PrivilegeManager.enablePrivilege("UniversalThreadAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                forbiddenTargetException.printStackTrace();
            }
            threadGroup = new ThreadGroup("Mindbright SSH");
        }
        return threadGroup;
    }

    public static String getVersionId(boolean bl) {
        String string = "SSH-1.5-";
        string = string + (bl ? VER_MINDTERM : VER_MINDTUNL);
        return string;
    }

    public static String[] getProxyTypes() {
        return proxyTypes;
    }

    public static int getProxyType(String string) throws IllegalArgumentException {
        int n = 0;
        while (n < proxyTypes.length) {
            if (proxyTypes[n].equalsIgnoreCase(string)) break;
            ++n;
        }
        if (n == PROXY_NOTSUPPORTED) {
            throw new IllegalArgumentException("Proxytype " + string + " not supported");
        }
        return n;
    }

    public static String listSupportedProxyTypes() {
        String string = "";
        int n = 0;
        while (n < proxyTypes.length) {
            string = string + proxyTypes[n] + " ";
            ++n;
        }
        return string;
    }

    public static String getCipherName(int n) {
        return cipherClasses[n][1];
    }

    public static int getCipherType(String string) {
        int n = 0;
        while (n < cipherClasses.length) {
            String string2 = cipherClasses[n][0];
            String string3 = cipherClasses[n][1];
            if (string3.equalsIgnoreCase(string)) {
                if (cipherClasses[n][0] != null) break;
                n = cipherClasses.length;
                break;
            }
            ++n;
        }
        return n;
    }

    public static String getAuthName(int n) {
        return authTypeDesc[n];
    }

    public static int getAuthType(String string) throws IllegalArgumentException {
        int n = 1;
        while (n < authTypeDesc.length) {
            if (authTypeDesc[n].equalsIgnoreCase(string)) break;
            ++n;
        }
        if (n == AUTH_NOTSUPPORTED) {
            throw new IllegalArgumentException("Authtype " + string + " not supported");
        }
        return n;
    }

    static int cntListSize(String string) {
        int n;
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length() && (n = string.indexOf(44, n3)) != -1) {
            n3 = n + 1;
            ++n2;
        }
        return n2;
    }

    public static int[] getAuthTypes(String string) throws IllegalArgumentException {
        int n = SSH.cntListSize(string);
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.indexOf(44, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            String string2 = string.substring(n2, n4).trim();
            nArray[n3] = SSH.getAuthType(string2);
            n2 = n4 + 1;
            ++n3;
        }
        return nArray;
    }

    public static String listSupportedCiphers() {
        String string = "";
        int n = 0;
        while (n < cipherClasses.length) {
            if (cipherClasses[n][0] != null) {
                string = string + cipherClasses[n][1] + " ";
            }
            ++n;
        }
        return string;
    }

    public static String[] getCiphers() {
        int n = 0;
        int n2 = 0;
        while (n2 < cipherClasses.length) {
            if (cipherClasses[n2][0] != null) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < cipherClasses.length) {
            if (cipherClasses[n2][0] != null) {
                stringArray[n++] = cipherClasses[n2][1];
            }
            ++n2;
        }
        return stringArray;
    }

    public static String listSupportedAuthTypes() {
        String string = "";
        int n = 1;
        while (n < authTypeDesc.length) {
            string = string + authTypeDesc[n] + " ";
            ++n;
        }
        return string;
    }

    public static String[] getAuthTypeList() {
        String[] stringArray = new String[authTypeDesc.length];
        int n = 1;
        while (n < authTypeDesc.length) {
            stringArray[n - 1] = authTypeDesc[n];
            ++n;
        }
        stringArray[SSH.authTypeDesc.length - 1] = "custom...";
        return stringArray;
    }

    boolean isCipherSupported(int n) {
        int n2 = 1 << n;
        return (n2 & this.supportedCiphers) != 0;
    }

    boolean isAuthTypeSupported(int n) {
        int n2 = 1 << n;
        return (n2 & this.supportedAuthTypes) != 0;
    }

    boolean isProtocolFlagSet(int n) {
        int n2 = 1 << n;
        return (n2 & this.protocolFlags) != 0;
    }

    public static void initSeedGenerator() {
        if (secureRandom != null) {
            return;
        }
        secureRandom = new SecureRandom();
    }

    public static SecureRandom secureRandom() {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }

    public static void log(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void logExtra(String string) {
        if (DEBUGMORE) {
            System.out.println(string);
        }
    }

    public static void logDebug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void logIgnore(SSHPduInputStream sSHPduInputStream) {
        if (DEBUG) {
            System.out.println("MSG_IGNORE received...(len = " + sSHPduInputStream.length + ")");
        }
    }

    void generateSessionId() throws IOException {
        byte[] byArray = ((RSAPublicKey)this.srvServerKey.getPublic()).getN().toByteArray();
        byte[] byArray2 = ((RSAPublicKey)this.srvHostKey.getPublic()).getN().toByteArray();
        int n = byArray.length + byArray2.length + this.srvCookie.length;
        if (byArray[0] == 0) {
            --n;
        }
        if (byArray2[0] == 0) {
            --n;
        }
        byte[] byArray3 = new byte[n];
        if (byArray2[0] == 0) {
            System.arraycopy(byArray2, 1, byArray3, 0, byArray2.length - 1);
            n = byArray2.length - 1;
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            n = byArray2.length;
        }
        if (byArray[0] == 0) {
            System.arraycopy(byArray, 1, byArray3, n, byArray.length - 1);
            n += byArray.length - 1;
        } else {
            System.arraycopy(byArray, 0, byArray3, n, byArray.length);
            n += byArray.length;
        }
        System.arraycopy(this.srvCookie, 0, byArray3, n, this.srvCookie.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray3);
            this.sessionId = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("MD5 not implemented, can't generate session-id");
        }
    }

    protected void initClientCipher() throws IOException {
        this.initCipher(false);
    }

    protected void initServerCipher() throws IOException {
        this.initCipher(true);
    }

    protected void initCipher(boolean bl) throws IOException {
        this.sndCipher = Cipher.getInstance(cipherClasses[this.cipherType][0]);
        this.rcvCipher = Cipher.getInstance(cipherClasses[this.cipherType][0]);
        if (this.sndCipher == null) {
            throw new IOException("Cipher " + cipherClasses[this.cipherType][1] + " not found, can't use it");
        }
        if (this.cipherType == 5) {
            if (bl) {
                int n = this.sessionKey.length / 2;
                byte[] byArray = new byte[n];
                System.arraycopy(this.sessionKey, 0, byArray, 0, n);
                this.sndCipher.setKey(byArray);
                System.arraycopy(this.sessionKey, n, byArray, 0, n);
                this.rcvCipher.setKey(byArray);
            } else {
                int n = this.sessionKey.length / 2;
                byte[] byArray = new byte[n];
                System.arraycopy(this.sessionKey, 0, byArray, 0, n);
                this.rcvCipher.setKey(byArray);
                System.arraycopy(this.sessionKey, n, byArray, 0, n);
                this.sndCipher.setKey(byArray);
            }
        } else {
            this.sndCipher.setKey(this.sessionKey);
            this.rcvCipher.setKey(this.sessionKey);
        }
    }

    public static String generateKeyFiles(KeyPair keyPair, String string, String string2, String string3) throws IOException {
        SSHRSAKeyFile.createKeyFile(keyPair, string2, string, string3);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        SSHRSAPublicKeyString sSHRSAPublicKeyString = new SSHRSAPublicKeyString("", string3, rSAPublicKey.getE(), rSAPublicKey.getN());
        sSHRSAPublicKeyString.toFile(string + ".pub");
        return sSHRSAPublicKeyString.toString();
    }

    public static KeyPair generateRSAKeyPair(int n, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = new BigInteger("1");
        while (true) {
            int n2 = SecureRandom.secureLevel;
            SecureRandom.secureLevel = 2;
            bigInteger3 = new BigInteger(n / 2, 64, secureRandom);
            bigInteger2 = new BigInteger(n - n / 2, 64, secureRandom);
            SecureRandom.secureLevel = n2;
            if (bigInteger3.compareTo(bigInteger2) == 0) continue;
            if (bigInteger2.compareTo(bigInteger3) < 0) {
                bigInteger = bigInteger2;
                bigInteger2 = bigInteger3;
                bigInteger3 = bigInteger;
            }
            if ((bigInteger = bigInteger3.gcd(bigInteger2)).compareTo(bigInteger4) == 0) break;
        }
        BigInteger bigInteger5 = bigInteger3.subtract(bigInteger4);
        BigInteger bigInteger6 = bigInteger2.subtract(bigInteger4);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger5.gcd(bigInteger6);
        BigInteger bigInteger9 = bigInteger7.divide(bigInteger8);
        BigInteger bigInteger10 = bigInteger4.shiftLeft(5);
        bigInteger10 = bigInteger10.subtract(bigInteger4);
        while ((bigInteger = (bigInteger10 = bigInteger10.add(bigInteger4.add(bigInteger4))).gcd(bigInteger7)).compareTo(bigInteger4) != 0) {
        }
        BigInteger bigInteger11 = bigInteger10.modInverse(bigInteger7);
        BigInteger bigInteger12 = bigInteger3.multiply(bigInteger2);
        BigInteger bigInteger13 = bigInteger3.modInverse(bigInteger2);
        KeyPair keyPair = new KeyPair(new RSAPublicKey(bigInteger10, bigInteger12), new RSAPrivateKey(bigInteger10, bigInteger12, bigInteger11, bigInteger13, bigInteger3, bigInteger2));
        return keyPair;
    }

    static {
        thrdPart = 1;
        DEBUG = false;
        DEBUGMORE = false;
        cipherClasses = new String[][]{{"NoEncrypt", "none"}, {"IDEA", "idea"}, {"DES", "des"}, {"DES3", "3des"}, {null, "tss"}, {"RC4", "rc4"}, {"Blowfish", "blowfish"}, {null, "reserved"}};
        authTypeDesc = new String[]{"_N/A_", "rhosts", "rsa", "passwd", "rhostsrsa", "tis", "kerberos", "kerbtgt", "sdi-token"};
        AUTH_NOTSUPPORTED = authTypeDesc.length;
        proxyTypes = new String[]{"none", "http", "socks4", "socks5-proxy-dns", "socks5-local-dns"};
        defaultProxyPorts = new int[]{0, 8080, 1080, 1080, 1080};
        PROXY_NOTSUPPORTED = proxyTypes.length;
    }
}

