/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import mindbright.security.KeyPair;
import mindbright.security.MessageDigest;
import mindbright.security.RSACipher;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHProtocolPlugin;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.terminal.Terminal;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class SSHClient
extends SSH {
    protected Thread myThread;
    protected KeepAliveRunnable keepAliveRunnable;
    protected Thread keepAliveThread;
    protected InetAddress serverAddr;
    protected InetAddress serverRealAddr;
    protected InetAddress localAddr;
    protected String srvVersionStr;
    protected int srvVersionMajor;
    protected int srvVersionMinor;
    protected Vector localForwards;
    protected Vector remoteForwards;
    protected String commandLine;
    protected SSHChannelController controller;
    protected SSHConsole console;
    protected SSHAuthenticator authenticator;
    protected SSHClientUser user;
    protected SSHInteractor interactor;
    protected Socket sshSocket;
    protected BufferedInputStream sshIn;
    protected BufferedOutputStream sshOut;
    protected boolean gracefulExit;
    protected boolean isConnected;
    protected boolean isOpened;
    boolean usedOTP;
    protected int refCount;
    protected boolean havePORTFtp;
    protected int firstFTPPort;
    protected boolean activateTunnels;
    private static final int CANNOT_CHOOSE_PIN = 0;
    private static final int USER_SELECTABLE = 1;
    private static final int MUST_CHOOSE_PIN = 2;

    public SSHClient(SSHAuthenticator sSHAuthenticator, SSHClientUser sSHClientUser) {
        block2: {
            this.serverRealAddr = null;
            this.havePORTFtp = false;
            this.firstFTPPort = 0;
            this.activateTunnels = true;
            this.user = sSHClientUser;
            this.authenticator = sSHAuthenticator;
            this.interactor = sSHClientUser.getInteractor();
            this.srvVersionStr = null;
            this.refCount = 0;
            this.usedOTP = false;
            try {
                this.localAddr = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                if (this.interactor == null) break block2;
                this.interactor.alert("FATAL: Could not create local InetAddress: " + unknownHostException.getMessage());
            }
        }
        this.clearAllForwards();
    }

    public void setConsole(SSHConsole sSHConsole) {
        this.console = sSHConsole;
        if (this.controller != null) {
            this.controller.console = sSHConsole;
        }
    }

    public SSHConsole getConsole() {
        return this.console;
    }

    public InetAddress getServerAddr() {
        return this.serverAddr;
    }

    public InetAddress getServerRealAddr() {
        if (this.serverRealAddr == null) {
            return this.serverAddr;
        }
        return this.serverRealAddr;
    }

    public void setServerRealAddr(InetAddress inetAddress) {
        this.serverRealAddr = inetAddress;
    }

    public InetAddress getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String string) throws UnknownHostException {
        this.localAddr = InetAddress.getByName(string);
    }

    public String getServerVersion() {
        return this.srvVersionStr;
    }

    public void addLocalPortForward(int n, String string, int n2, String string2) throws IOException {
        this.addLocalPortForward(this.localAddr.getHostAddress(), n, string, n2, string2);
    }

    public void addLocalPortForward(String string, int n, String string2, int n2, String string3) throws IOException {
        this.delLocalPortForward(string, n);
        this.localForwards.addElement(new LocalForward(string, n, string2, n2, string3));
        if (this.isOpened) {
            try {
                this.requestLocalPortForward(string, n, string2, n2, string3);
            }
            catch (IOException iOException) {
                this.delLocalPortForward(string, n);
                throw iOException;
            }
        }
    }

    public void delLocalPortForward(String string, int n) {
        if (n == -1) {
            if (this.isOpened) {
                this.controller.killListenChannels();
            }
            this.localForwards = new Vector();
        } else {
            int n2 = 0;
            while (n2 < this.localForwards.size()) {
                LocalForward localForward = (LocalForward)this.localForwards.elementAt(n2);
                if (localForward.localPort == n && localForward.localHost.equals(string)) {
                    this.localForwards.removeElementAt(n2);
                    if (!this.isOpened) break;
                    this.controller.killListenChannel(localForward.localHost, localForward.localPort);
                    break;
                }
                ++n2;
            }
        }
    }

    public void addRemotePortForward(int n, String string, int n2, String string2) {
        this.delRemotePortForward(n);
        this.remoteForwards.addElement(new RemoteForward(n, string, n2, string2));
    }

    public void delRemotePortForward(int n) {
        if (n == -1) {
            this.remoteForwards = new Vector();
        } else {
            int n2 = 0;
            while (n2 < this.remoteForwards.size()) {
                RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(n2);
                if (remoteForward.remotePort == n) {
                    this.remoteForwards.removeElementAt(n2);
                    break;
                }
                ++n2;
            }
        }
    }

    public void delRemotePortForward(String string) {
        int n = 0;
        while (n < this.remoteForwards.size()) {
            RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(n);
            if (remoteForward.plugin.equals(string)) {
                this.remoteForwards.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public void clearAllForwards() {
        this.localForwards = new Vector();
        this.remoteForwards = new Vector();
    }

    public void startExitMonitor() {
        this.startExitMonitor(0L);
    }

    public void startExitMonitor(long l) {
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            forbiddenTargetException.printStackTrace();
        }
        new Thread(SSH.getThreadGroup(), new ExitMonitor(this, l), SSH.createThreadName()).start();
    }

    public synchronized int addRef() {
        return ++this.refCount;
    }

    public void forcedDisconnect() {
        if (this.controller != null) {
            this.controller.sendDisconnect("exit");
        } else if (this.interactor != null) {
            this.interactor.disconnected(this, false);
        }
    }

    public synchronized int delRef() {
        if (--this.refCount <= 0) {
            this.forcedDisconnect();
            this.waitForExit(2000L);
        }
        return this.refCount;
    }

    public void waitForExit(long l) {
        try {
            this.controller.waitForExit(l);
        }
        catch (InterruptedException interruptedException) {
            if (this.interactor != null) {
                this.interactor.alert("Error when shutting down SSHClient: " + interruptedException.getMessage());
            }
            this.controller.killAll();
        }
        try {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doSingleCommand(String string, boolean bl, long l) throws IOException {
        this.commandLine = string;
        this.bootSSH(false);
        if (bl) {
            this.startExitMonitor(l);
        } else {
            this.waitForExit(l);
        }
    }

    public void bootSSH(boolean bl) throws IOException {
        try {
            this.myThread = Thread.currentThread();
            if (this.interactor != null) {
                this.interactor.startNewSession(this);
            }
            String string = this.user.getSrvHost();
            if (this.interactor != null) {
                this.interactor.sessionStarted(this);
            }
            this.sshSocket = this.user.getProxyConnection();
            if (this.sshSocket == null) {
                this.serverAddr = InetAddress.getByName(string);
                if (this.user.wantPrivileged()) {
                    int n = 1023;
                    while (n > 512) {
                        try {
                            this.sshSocket = new Socket(this.serverAddr, this.user.getSrvPort(), this.localAddr, n);
                            break;
                        }
                        catch (IOException iOException) {
                            if (iOException.getMessage().toLowerCase().indexOf("use") == -1) {
                                throw iOException;
                            }
                            --n;
                        }
                    }
                    if (n == 512) {
                        throw new IOException("No available privileged ports");
                    }
                } else {
                    this.sshSocket = new Socket(this.serverAddr, this.user.getSrvPort());
                }
            } else {
                this.serverAddr = this.sshSocket.getInetAddress();
                if (this.interactor != null) {
                    this.interactor.report("Connecting through proxy at " + this.serverAddr.getHostAddress() + ":" + this.sshSocket.getPort());
                }
            }
            this.sshIn = new BufferedInputStream(this.sshSocket.getInputStream(), 8192);
            this.sshOut = new BufferedOutputStream(this.sshSocket.getOutputStream());
            this.negotiateVersion();
            this.isConnected = true;
            if (this.interactor != null) {
                this.interactor.connected(this);
            }
            String string2 = this.authenticator.getUsername(this.user);
            this.receiveServerData();
            this.initiatePlugins();
            this.cipherType = this.authenticator.getCipher(this.user);
            if (!this.isCipherSupported(this.cipherType)) {
                throw new IOException("Sorry, server does not support the '" + SSH.getCipherName(this.authenticator.getCipher(this.user)) + "' cipher.");
            }
            this.generateSessionId();
            this.generateSessionKey();
            this.initClientCipher();
            this.sendSessionKey(this.cipherType);
            this.authenticateUser(string2);
            this.controller = new SSHChannelController(this, this.sshIn, this.sshOut, this.sndCipher, this.rcvCipher, this.console, bl);
            this.initiateSession();
            if (this.console != null) {
                this.console.serverConnect(this.controller, this.sndCipher);
            }
            this.isOpened = true;
            if (this.interactor != null) {
                this.interactor.open(this);
            }
            this.setAliveInterval(this.user.getAliveInterval());
            this.controller.start();
        }
        catch (IOException iOException) {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
            this.disconnect(false);
            if (this.controller != null) {
                this.controller.killListenChannels();
            }
            this.controller = null;
            throw iOException;
        }
    }

    protected void disconnect(boolean bl) {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        this.isOpened = false;
        this.gracefulExit = bl;
        this.srvVersionStr = null;
        this.setAliveInterval(0);
        if (this.interactor != null) {
            this.interactor.disconnected(this, bl);
        }
    }

    void negotiateVersion() throws IOException {
        byte[] byArray = new byte[256];
        int n = this.sshIn.read(byArray);
        this.srvVersionStr = new String(byArray, 0, n);
        try {
            int n2 = this.srvVersionStr.indexOf(45);
            int n3 = this.srvVersionStr.indexOf(46);
            this.srvVersionMajor = Integer.parseInt(this.srvVersionStr.substring(n2 + 1, n3));
            n2 = n3;
            n3 = this.srvVersionStr.indexOf(45, n2);
            this.srvVersionMinor = n3 == -1 ? Integer.parseInt(this.srvVersionStr.substring(n2 + 1)) : Integer.parseInt(this.srvVersionStr.substring(n2 + 1, n3));
        }
        catch (Throwable throwable) {
            throw new IOException("Server version string invalid: " + this.srvVersionStr);
        }
        if (this.srvVersionMajor > 1) {
            throw new IOException("MindTerm do not support SSHv2 yet, enable SSHv1 compatibility in server");
        }
        if (this.srvVersionMajor < 1 || this.srvVersionMinor < 5) {
            throw new IOException("Server's protocol version (" + this.srvVersionMajor + "-" + this.srvVersionMinor + ") is too old, please upgrade");
        }
        this.srvVersionStr = this.srvVersionStr.trim();
        String string = SSH.getVersionId(true);
        string = string + "\n";
        byArray = string.getBytes();
        this.sshOut.write(byArray);
        this.sshOut.flush();
    }

    void receiveServerData() throws IOException {
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(2, null);
        sSHPduInputStream.readFrom(this.sshIn);
        this.srvCookie = new byte[8];
        sSHPduInputStream.read(this.srvCookie, 0, 8);
        int n = sSHPduInputStream.readInt();
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        BigInteger bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvServerKey = new KeyPair(new RSAPublicKey(bigInteger, bigInteger2), null);
        n = sSHPduInputStream.readInt();
        bigInteger = sSHPduInputStream.readBigInteger();
        bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvHostKey = new KeyPair(new RSAPublicKey(bigInteger, bigInteger2), null);
        int n2 = Math.abs(((RSAPublicKey)this.srvServerKey.getPublic()).bitLength() - ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength());
        if (n2 < 24) {
            throw new IOException("Invalid server keys, difference in sizes must be at least 24 bits");
        }
        if (!this.authenticator.verifyKnownHosts((RSAPublicKey)this.srvHostKey.getPublic())) {
            throw new IOException("Verification of known hosts failed");
        }
        this.protocolFlags = sSHPduInputStream.readInt();
        this.supportedCiphers = sSHPduInputStream.readInt();
        this.supportedAuthTypes = sSHPduInputStream.readInt();
        if ((this.supportedAuthTypes & 0x10000) != 0) {
            this.supportedAuthTypes = this.supportedAuthTypes & 0xFFFF | 0x100;
        }
    }

    void generateSessionKey() {
        SecureRandom secureRandom = SSH.secureRandom();
        this.sessionKey = new byte[32];
        secureRandom.nextBytes(this.sessionKey);
        secureRandom.startUpdater();
    }

    void sendSessionKey(int n) throws IOException {
        byte[] byArray = new byte[this.sessionKey.length + 1];
        byArray[0] = 0;
        System.arraycopy(this.sessionKey, 0, byArray, 1, this.sessionKey.length);
        int n2 = 0;
        while (n2 < this.sessionId.length) {
            int n3 = n2 + 1;
            byArray[n3] = (byte)(byArray[n3] ^ this.sessionId[n2]);
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(byArray);
        if (((RSAPublicKey)this.srvServerKey.getPublic()).bitLength() < ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength()) {
            RSACipher rSACipher = new RSACipher(this.srvServerKey);
            BigInteger bigInteger2 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvServerKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger2);
            rSACipher = new RSACipher(this.srvHostKey);
            bigInteger2 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger2);
        } else {
            RSACipher rSACipher = new RSACipher(this.srvHostKey);
            BigInteger bigInteger3 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger3);
            rSACipher = new RSACipher(this.srvServerKey);
            bigInteger3 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvServerKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger3);
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(3, null);
        sSHPduOutputStream.writeByte((byte)n);
        sSHPduOutputStream.write(this.srvCookie, 0, this.srvCookie.length);
        sSHPduOutputStream.writeBigInteger(bigInteger);
        sSHPduOutputStream.writeInt(this.protocolFlags);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new IOException("Error while sending session key!");
        }
    }

    void authenticateUser(String string) throws IOException {
        this.usedOTP = false;
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(4, this.sndCipher);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (this.isSuccess()) {
            if (this.interactor != null) {
                this.interactor.report("Authenticated directly by server, no other authentication required");
            }
            return;
        }
        int[] nArray = this.authenticator.getAuthTypes(this.user);
        int n = 0;
        while (n < nArray.length) {
            try {
                if (!this.isAuthTypeSupported(nArray[n])) {
                    throw new AuthFailException("Server does not support '" + SSH.authTypeDesc[nArray[n]] + "'");
                }
                switch (nArray[n]) {
                    case 2: {
                        this.doRSAAuth(false, string);
                        break;
                    }
                    case 3: {
                        this.doPasswdAuth(string);
                        break;
                    }
                    case 4: {
                        this.doRSAAuth(true, string);
                        break;
                    }
                    case 5: {
                        this.doTISAuth(string);
                        break;
                    }
                    case 1: {
                        this.doRhostsAuth(string);
                        break;
                    }
                    case 8: {
                        this.doSDIAuth(string);
                        this.usedOTP = true;
                        break;
                    }
                    default: {
                        throw new IOException("We do not support selected authentication type " + SSH.authTypeDesc[nArray[n]]);
                    }
                }
                return;
            }
            catch (AuthFailException authFailException) {
                if (n == nArray.length - 1) {
                    throw authFailException;
                }
                if (this.interactor != null) {
                    this.interactor.report("Authenticating with " + SSH.authTypeDesc[nArray[n]] + " failed, " + authFailException.getMessage());
                }
                ++n;
            }
        }
    }

    void doPasswdAuth(String string) throws IOException {
        String string2 = this.authenticator.getPassword(this.user);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(9, this.sndCipher);
        sSHPduOutputStream.writeString(string2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException("Permission denied");
        }
    }

    void doRhostsAuth(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(5, this.sndCipher);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException("Permission denied");
        }
    }

    void doTISAuth(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(39, this.sndCipher);
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 15) {
            throw new AuthFailException("TIS authentication server not reachable or user unknown");
        }
        if (sSHPduInputStream.type != 40) {
            throw new IOException("Protocol error, expected TIS challenge but got " + sSHPduInputStream.type);
        }
        String string2 = sSHPduInputStream.readString();
        String string3 = this.authenticator.getChallengeResponse(this.user, string2);
        sSHPduOutputStream = new SSHPduOutputStream(41, this.sndCipher);
        sSHPduOutputStream.writeString(string3);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException("Permission denied");
        }
    }

    void doRSAAuth(boolean bl, String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream;
        SSHRSAKeyFile sSHRSAKeyFile = this.authenticator.getIdentityFile(this.user);
        RSAPublicKey rSAPublicKey = sSHRSAKeyFile.getPublic();
        if (bl) {
            sSHPduOutputStream = new SSHPduOutputStream(35, this.sndCipher);
            sSHPduOutputStream.writeString(string);
            sSHPduOutputStream.writeInt(rSAPublicKey.bitLength());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getE());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        } else {
            sSHPduOutputStream = new SSHPduOutputStream(6, this.sndCipher);
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        }
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 15) {
            throw new AuthFailException("Server refused our key" + (bl ? " or rhosts" : ""));
        }
        if (sSHPduInputStream.type != 7) {
            throw new IOException("Protocol error, expected RSA-challenge but got " + sSHPduInputStream.type);
        }
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        RSAPrivateKey rSAPrivateKey = sSHRSAKeyFile.getPrivate("");
        if (rSAPrivateKey == null) {
            rSAPrivateKey = sSHRSAKeyFile.getPrivate(this.authenticator.getIdentityPassword(this.user));
        } else if (this.interactor != null) {
            this.interactor.report("Authenticated with password-less rsa-key '" + sSHRSAKeyFile.getComment() + "'");
        }
        if (rSAPrivateKey == null) {
            throw new AuthFailException("Invalid password for key-file '" + sSHRSAKeyFile.getComment() + "'");
        }
        this.rsaChallengeResponse(rSAPrivateKey, bigInteger);
    }

    void doSDIAuth(String string) throws IOException {
        String string2 = this.authenticator.getChallengeResponse(this.user, string + "'s SDI token passcode: ");
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher);
        sSHPduOutputStream.writeString(string2);
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        block0 : switch (sSHPduInputStream.type) {
            case 14: {
                this.interactor.report("SDI authentication accepted.");
                break;
            }
            case 15: {
                throw new AuthFailException("SDI authentication failed.");
            }
            case 66: {
                string2 = this.interactor.promptPassword("Next token required: ");
                sSHPduOutputStream = new SSHPduOutputStream(67, this.sndCipher);
                sSHPduOutputStream.writeString(string2);
                sSHPduOutputStream.writeTo(this.sshOut);
                if (this.isSuccess()) break;
                throw new AuthFailException("Permission denied");
            }
            case 68: {
                if (!this.interactor.askConfirmation("New PIN required, do you want to continue?", false)) {
                    throw new AuthFailException("New PIN not wanted");
                }
                String string3 = sSHPduInputStream.readString();
                String string4 = sSHPduInputStream.readString();
                int n = sSHPduInputStream.readInt();
                switch (n) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        String string5;
                        while (!(string2 = this.interactor.promptPassword("Please enter new PIN containing " + string4 + " " + string3)).equals(string5 = this.interactor.promptPassword("Please enter new PIN again"))) {
                        }
                        sSHPduOutputStream = new SSHPduOutputStream(71, this.sndCipher);
                        sSHPduOutputStream.writeString(string2);
                        sSHPduOutputStream.writeTo(this.sshOut);
                        sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
                        sSHPduInputStream.readFrom(this.sshIn);
                        if (sSHPduInputStream.type != 69) {
                            throw new AuthFailException("PIN rejected by server");
                        }
                        throw new AuthFailException("New PIN accepted, Wait for the code on your token to change");
                    }
                }
                throw new AuthFailException("Invalid response from server");
            }
            default: {
                throw new AuthFailException("Permission denied");
            }
        }
    }

    void rsaChallengeResponse(RSAPrivateKey rSAPrivateKey, BigInteger bigInteger) throws IOException {
        RSACipher rSACipher = new RSACipher(new KeyPair(null, rSAPrivateKey));
        bigInteger = rSACipher.doPrivate(bigInteger);
        bigInteger = RSACipher.stripPad(bigInteger);
        byte[] byArray = bigInteger.toByteArray();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (byArray[0] == 0) {
                messageDigest.update(byArray, 1, 32);
            } else {
                messageDigest.update(byArray, 0, 32);
            }
            messageDigest.update(this.sessionId);
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("MD5 not implemented, can't generate session-id");
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(8, this.sndCipher);
        sSHPduOutputStream.write(byArray, 0, byArray.length);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new AuthFailException("Permission denied");
        }
    }

    void initiateSession() throws IOException {
        int n;
        if (this.user.wantPTY()) {
            this.requestPTY();
        }
        if ((n = this.user.getMaxPacketSz()) > 0) {
            this.requestMaxPacketSz(n);
        }
        if (this.user.wantX11Forward()) {
            this.requestX11Forward();
        }
        if (this.activateTunnels) {
            this.initiateTunnels();
        }
        if (this.commandLine != null) {
            this.requestCommand(this.commandLine);
        } else {
            this.requestShell();
        }
    }

    void initiatePlugins() {
        SSHProtocolPlugin.initiateAll(this);
    }

    void initiateTunnels() throws IOException {
        Object object;
        int n = 0;
        while (n < this.localForwards.size()) {
            object = (LocalForward)this.localForwards.elementAt(n);
            this.requestLocalPortForward(((LocalForward)object).localHost, ((LocalForward)object).localPort, ((LocalForward)object).remoteHost, ((LocalForward)object).remotePort, ((LocalForward)object).plugin);
            ++n;
        }
        n = 0;
        while (n < this.remoteForwards.size()) {
            object = (RemoteForward)this.remoteForwards.elementAt(n);
            this.requestRemotePortForward(((RemoteForward)object).remotePort, ((RemoteForward)object).localHost, ((RemoteForward)object).localPort, ((RemoteForward)object).plugin);
            ++n;
        }
    }

    void requestCompression(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(37, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting compression level: " + n);
        }
    }

    void requestMaxPacketSz(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(38, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting max packet size: " + n);
        }
    }

    void requestX11Forward() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(34, this.sndCipher);
        sSHPduOutputStream.writeString("MIT-MAGIC-COOKIE-1");
        sSHPduOutputStream.writeString("112233445566778899aabbccddeeff00");
        sSHPduOutputStream.writeInt(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting X11 forward");
        }
    }

    void requestPTY() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(10, this.sndCipher);
        Terminal terminal = null;
        if (this.console != null) {
            terminal = this.console.getTerminal();
        }
        if (terminal != null) {
            sSHPduOutputStream.writeString(terminal.terminalType());
            sSHPduOutputStream.writeInt(terminal.rows());
            sSHPduOutputStream.writeInt(terminal.cols());
            sSHPduOutputStream.writeInt(terminal.vpixels());
            sSHPduOutputStream.writeInt(terminal.hpixels());
        } else {
            sSHPduOutputStream.writeString("");
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
        }
        sSHPduOutputStream.writeByte(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting PTY");
        }
    }

    void requestLocalPortForward(String string, int n, String string2, int n2, String string3) throws IOException {
        this.controller.newListenChannel(string, n, string2, n2, string3);
    }

    void requestRemotePortForward(int n, String string, int n2, String string2) throws IOException {
        try {
            SSHProtocolPlugin.getPlugin(string2).remoteListener(n, string, n2, this.controller);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException("Plugins not available");
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(28, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeInt(n2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess() && this.interactor != null) {
            this.interactor.report("Error requesting remote port forward: " + string2 + "/" + n + ":" + string + ":" + n2);
        }
    }

    void requestCommand(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(13, this.sndCipher);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    void requestShell() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(12, this.sndCipher);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    boolean isSuccess() throws IOException {
        boolean bl = false;
        SSHPduInputStream sSHPduInputStream = null;
        sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 14) {
            bl = true;
        } else if (sSHPduInputStream.type == 15) {
            bl = false;
        } else {
            if (sSHPduInputStream.type == 1) {
                throw new IOException("Server disconnected: " + sSHPduInputStream.readString());
            }
            throw new IOException("Protocol error: got " + sSHPduInputStream.type + " when expecting success/failure");
        }
        return bl;
    }

    void setInteractive() {
        block2: {
            try {
                this.sshSocket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                if (this.interactor == null) break block2;
                this.interactor.report("Error setting interactive mode: " + socketException.getMessage());
            }
        }
    }

    void setAliveInterval(int n) {
        if (n == 0) {
            if (this.keepAliveRunnable != null && this.keepAliveThread.isAlive()) {
                this.keepAliveThread.stop();
            }
            this.keepAliveThread = null;
            this.keepAliveRunnable = null;
        } else if (this.keepAliveRunnable != null) {
            this.keepAliveRunnable.setInterval(n);
        } else {
            this.keepAliveRunnable = new KeepAliveRunnable(n);
            try {
                PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                PrivilegeManager.enablePrivilege("UniversalThreadAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                forbiddenTargetException.printStackTrace();
            }
            this.keepAliveThread = new Thread(SSH.getThreadGroup(), this.keepAliveRunnable, SSH.createThreadName());
            this.keepAliveThread.start();
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void stdinWriteChar(char c) throws IOException {
        this.stdinWriteString(String.valueOf(c));
    }

    public void stdinWriteString(String string) throws IOException {
        this.stdinWriteString(string.getBytes(), 0, string.length());
    }

    public void stdinWriteString(byte[] byArray) throws IOException {
        this.stdinWriteString(byArray, 0, byArray.length);
    }

    public void stdinWriteString(byte[] byArray, int n, int n2) throws IOException {
        if (this.isOpened && this.controller != null) {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher);
            sSHPduOutputStream.writeInt(n2);
            sSHPduOutputStream.write(byArray, n, n2);
            this.controller.transmit(sSHPduOutputStream);
        }
    }

    void signalWindowChanged(int n, int n2, int n3, int n4) {
        block3: {
            if (this.isOpened && this.controller != null) {
                try {
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(11, this.sndCipher);
                    sSHPduOutputStream.writeInt(n);
                    sSHPduOutputStream.writeInt(n2);
                    sSHPduOutputStream.writeInt(n3);
                    sSHPduOutputStream.writeInt(n4);
                    this.controller.transmit(sSHPduOutputStream);
                }
                catch (Exception exception) {
                    if (this.interactor == null) break block3;
                    this.interactor.alert("Error when sending sigWinch: " + exception.toString());
                }
            }
        }
    }

    public static class RemoteForward {
        protected int remotePort;
        protected String localHost;
        protected int localPort;
        protected String plugin;

        public RemoteForward(int n, String string, int n2, String string2) {
            this.remotePort = n;
            this.localHost = string;
            this.localPort = n2;
            this.plugin = string2;
        }
    }

    public static class LocalForward {
        protected String localHost;
        protected int localPort;
        protected String remoteHost;
        protected int remotePort;
        protected String plugin;

        public LocalForward(String string, int n, String string2, int n2, String string3) {
            this.localHost = string;
            this.localPort = n;
            this.remoteHost = string2;
            this.remotePort = n2;
            this.plugin = string3;
        }
    }

    private class KeepAliveRunnable
    implements Runnable {
        int interval;

        public KeepAliveRunnable(int n) {
            this.interval = n;
        }

        public synchronized void setInterval(int n) {
            this.interval = n;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        int n;
                        KeepAliveRunnable keepAliveRunnable = this;
                        synchronized (keepAliveRunnable) {
                            n = this.interval;
                        }
                        Thread.sleep(1000 * n);
                        if (SSHClient.this.controller == null) continue;
                        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(36, SSHClient.this.controller.sndCipher);
                        sSHPduOutputStream.writeString("heartbeat");
                        SSHClient.this.controller.transmit(sSHPduOutputStream);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    public static class ExitMonitor
    implements Runnable {
        SSHClient client;
        long msTimeout;

        public ExitMonitor(SSHClient sSHClient, long l) {
            this.msTimeout = l;
            this.client = sSHClient;
        }

        public ExitMonitor(SSHClient sSHClient) {
            this(sSHClient, 0L);
        }

        public void run() {
            this.client.waitForExit(this.msTimeout);
            if (!this.client.gracefulExit) {
                this.client.disconnect(false);
            }
        }
    }

    public static class AuthFailException
    extends IOException {
        public AuthFailException(String string) {
            super(string);
        }
    }
}

