/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import mindbright.security.Cipher;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHClientUserAdaptor;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHInteractorAdapter;
import mindbright.ssh.SSHSCPIndicator;
import mindbright.terminal.Terminal;

public class SSHSCP
extends SSHClientUserAdaptor
implements SSHConsole {
    SSHClient client;
    SSHInteractor interactor = null;
    SSHClientUser proxyUser = null;
    SSHSCPIndicator indicator = null;
    SSHInteractor ourInteractAdapter = new SSHInteractorAdapter(){

        public void open(SSHClient sSHClient) {
            SSHSCP.this.open(sSHClient);
        }

        public void disconnected(SSHClient sSHClient, boolean bl) {
            SSHSCP.this.disconnected(sSHClient, bl);
        }

        public void alert(String string) {
            SSHSCP.this.alert(string);
        }
    };
    File cwd;
    boolean recursive;
    boolean verbose;
    String sshHost;
    PipedInputStream inTop;
    PipedOutputStream inBottom;

    public SSHSCP(String string, int n, SSHAuthenticator sSHAuthenticator, File file, boolean bl, boolean bl2) throws IOException {
        super(string, n);
        this.client = new SSHClient(sSHAuthenticator, this);
        this.inTop = new PipedInputStream();
        this.inBottom = new PipedOutputStream(this.inTop);
        this.cwd = file;
        this.recursive = bl;
        this.verbose = bl2;
        this.sshHost = string;
        this.client.setConsole(this);
        this.client.activateTunnels = false;
    }

    public void setInteractor(SSHInteractor sSHInteractor) {
        this.interactor = sSHInteractor;
    }

    public void setClientUser(SSHClientUser sSHClientUser) {
        this.proxyUser = sSHClientUser;
    }

    public void setIndicator(SSHSCPIndicator sSHSCPIndicator) {
        this.indicator = sSHSCPIndicator;
    }

    public void abort() {
        this.interactor = null;
        this.indicator = null;
        this.client.forcedDisconnect();
    }

    public void copyToRemote(String string, String string2) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (!file.exists()) {
            throw new IOException("File: " + string + " does not exist");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException("File: " + string + " is not a regular file or directory");
        }
        if (file.isDirectory() && !this.recursive) {
            throw new IOException("File: " + string + " is a directory, use recursive mode");
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        this.client.doSingleCommand("scp -B " + (file.isDirectory() ? "-d " : "") + "-t " + (this.recursive ? "-r " : "") + (this.verbose ? "-v " : "") + string2, true, 0L);
        this.readResponse("After starting remote scp");
        this.writeFileToRemote(file);
        this.client.forcedDisconnect();
    }

    public void copyToRemote(String[] stringArray, String string) throws IOException {
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (stringArray.length == 1) {
            this.copyToRemote(stringArray[0], string);
        } else {
            this.client.doSingleCommand("scp -B -d -t " + (this.recursive ? "-r " : "") + (this.verbose ? "-v " : "") + string, true, 0L);
            this.readResponse("After starting remote scp");
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(stringArray[n]);
                if (!file.isAbsolute()) {
                    file = new File(this.cwd, stringArray[n]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    this.alert("File: " + file.getName() + " is not a regular file or directory");
                } else {
                    this.writeFileToRemote(file);
                }
                ++n;
            }
            this.client.forcedDisconnect();
        }
    }

    public void copyToLocal(String string, String string2) throws IOException {
        String[] stringArray = new String[]{string};
        this.copyToLocal(stringArray, string2);
    }

    public void copyToLocal(String[] stringArray, String string) throws IOException {
        this.client.doSingleCommand("scp -B -f " + (this.recursive ? "-r " : "") + (this.verbose ? "-v " : "") + string, true, 0L);
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(".");
            if (!file.isAbsolute()) {
                file = new File(this.cwd, ".");
            }
            if (file.exists() && !file.isFile() && !file.isDirectory()) {
                throw new IOException("File: " + stringArray[n] + " is not a regular file or directory");
            }
            this.readFromRemote(file);
            ++n;
        }
        this.client.forcedDisconnect();
    }

    boolean writeDirToRemote(File file) throws IOException {
        if (!this.recursive) {
            this.writeError("File " + file.getName() + " is a directory, use recursive mode");
            return false;
        }
        this.writeString("D0755 0 " + file.getName() + "\n");
        if (this.indicator != null) {
            this.indicator.startDir(file.getAbsolutePath());
        }
        this.readResponse("After sending dirdata");
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            this.writeFileToRemote(file2);
            ++n;
        }
        this.writeString("E\n");
        if (this.indicator != null) {
            this.indicator.endDir();
        }
        return true;
    }

    void writeFileToRemote(File file) throws IOException {
        if (file.isDirectory()) {
            if (!this.writeDirToRemote(file)) {
                return;
            }
        } else if (file.isFile()) {
            this.writeString("C0644 " + file.length() + " " + file.getName() + "\n");
            if (this.indicator != null) {
                this.indicator.startFile(file.getName(), (int)file.length());
            }
            this.readResponse("After sending filedata");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.writeFully(fileInputStream, (int)file.length());
            this.writeByte(0);
            if (this.indicator != null) {
                this.indicator.endFile();
            }
        } else {
            throw new IOException("Not ordinary file: " + file.getName());
        }
        this.readResponse("After writing file");
    }

    void readFromRemote(File file) throws IOException {
        String string;
        String[] stringArray = new String[3];
        this.writeByte(0);
        block7: while (true) {
            try {
                string = this.readString();
            }
            catch (EOFException eOFException) {
                return;
            }
            if (string == null) continue;
            char c = string.charAt(0);
            switch (c) {
                case 'E': {
                    this.writeByte(0);
                    return;
                }
                case 'T': {
                    System.out.println("(T)ime not supported: " + string);
                    continue block7;
                }
                case 'C': 
                case 'D': {
                    String string2 = file.getAbsolutePath();
                    this.parseCommand(string, stringArray);
                    if (file.isDirectory()) {
                        string2 = string2 + File.separator + stringArray[2];
                    }
                    File file2 = new File(string2);
                    if (c == 'D') {
                        if (file2.exists()) {
                            if (!file2.isDirectory()) {
                                this.writeError("Invalid target " + file2.getName() + ", must be a directory");
                            }
                        } else if (!file2.mkdir()) {
                            this.writeError("Could not create directory: " + file2.getName());
                        }
                        if (this.indicator != null) {
                            this.indicator.startDir(file2.getAbsolutePath());
                        }
                        this.readFromRemote(file2);
                        if (this.indicator == null) continue block7;
                        this.indicator.endDir();
                        continue block7;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    this.writeByte(0);
                    int n = Integer.parseInt(stringArray[1]);
                    if (this.indicator != null) {
                        this.indicator.startFile(file2.getName(), n);
                    }
                    this.readFully(fileOutputStream, n);
                    this.readResponse("After reading file");
                    if (this.indicator != null) {
                        this.indicator.endFile();
                    }
                    this.writeByte(0);
                    continue block7;
                }
            }
            break;
        }
        this.writeError("Unexpected cmd: " + string);
        throw new IOException("Unexpected cmd: " + string);
    }

    void parseCommand(String string, String[] stringArray) throws IOException {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1 || n2 == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        stringArray[0] = string.substring(1, n);
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
    }

    void readResponse(String string) throws IOException {
        int n = this.readByte();
        if (n == 0) {
            return;
        }
        String string2 = this.readString();
        if (n == 2) {
            throw new IOException(string2);
        }
        this.alert(string2);
    }

    void writeError(String string) throws IOException {
        this.writeByte(1);
        this.writeString(string);
        this.alert(string);
    }

    int readByte() throws IOException {
        return this.inTop.read();
    }

    String readString() throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while ((n = this.readByte()) != 10 && n >= 0) {
            byArray[n2++] = (byte)n;
        }
        if (n == -1) {
            throw new EOFException();
        }
        if (byArray[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (byArray[0] == 2 || byArray[0] == 1) {
            String string = new String(byArray, 1, n2 - 1);
            if (byArray[0] == 2) {
                throw new IOException(string);
            }
            this.alert(string);
            return null;
        }
        return new String(byArray, 0, n2);
    }

    void readFully(FileOutputStream fileOutputStream, int n) throws IOException {
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.inTop.read(byArray, 0, n - n2 < 2048 ? n - n2 : 2048);
            if (n3 == -1) {
                this.alert("Premature EOF");
                throw new IOException("Premature EOF");
            }
            n2 += n3;
            fileOutputStream.write(byArray, 0, n3);
            if (this.indicator == null) continue;
            this.indicator.progress(n3);
        }
        fileOutputStream.close();
    }

    void writeByte(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.client.stdinWriteString(byArray);
    }

    void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.client.stdinWriteString(byArray);
    }

    void writeFully(FileInputStream fileInputStream, int n) throws IOException {
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while (n2 < n) {
            int n3 = fileInputStream.read(byArray, 0, n - n2 < 2048 ? n - n2 : 2048);
            if (n3 == -1) {
                throw new IOException("Premature EOF");
            }
            n2 += n3;
            this.client.stdinWriteString(byArray, 0, n3);
            if (this.indicator != null) {
                this.indicator.progress(n3);
            }
            Thread.yield();
        }
        fileInputStream.close();
    }

    public void stdoutWriteString(byte[] byArray) {
        try {
            this.inBottom.write(byArray);
        }
        catch (IOException iOException) {
            try {
                this.inBottom.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.alert("Error writing data to stdout-pipe");
        }
    }

    public void stderrWriteString(byte[] byArray) {
        if (this.verbose) {
            this.alert("Remote warning/error: " + new String(byArray));
        }
    }

    public Terminal getTerminal() {
        return null;
    }

    public void print(String string) {
    }

    public void println(String string) {
    }

    public void serverConnect(SSHChannelController sSHChannelController, Cipher cipher) {
    }

    public void serverDisconnect(String string) {
    }

    public boolean wantPTY() {
        return false;
    }

    public void open(SSHClient sSHClient) {
        if (this.indicator != null) {
            this.indicator.connected(this.sshHost);
        }
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        try {
            this.inBottom.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void alert(String string) {
        if (this.interactor != null) {
            this.interactor.alert(string);
        }
    }

    public Socket getProxyConnection() throws IOException {
        if (this.proxyUser != null) {
            return this.proxyUser.getProxyConnection();
        }
        return null;
    }

    public SSHInteractor getInteractor() {
        return this.ourInteractAdapter;
    }
}

