/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import mindbright.security.KeyPair;
import mindbright.security.MessageDigest;
import mindbright.security.RSACipher;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.ssh.SSHRSAPublicKeyFile;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class SSHServer
extends SSH
implements Runnable {
    static KeyPair serverKey;
    static KeyPair hostKey;
    protected InetAddress localAddr;
    static String authKeysDir;
    static String hostKeyFile;
    static int serverKeyBits;
    protected String cliVersionStr;
    protected int cliVersionMajor;
    protected int cliVersionMinor;
    protected Thread myThread;
    protected Socket sshSocket;
    protected BufferedInputStream sshIn;
    protected BufferedOutputStream sshOut;
    protected SSHChannelController controller;

    public static void setHostKeyFile(String string) {
        hostKeyFile = string;
    }

    public static void setAuthKeysDir(String string) {
        authKeysDir = string;
    }

    public static void setServerKeyBits(int n) {
        serverKeyBits = n;
    }

    public InetAddress getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String string) throws UnknownHostException {
        this.localAddr = InetAddress.getByName(string);
    }

    public SSHServer(Socket socket, int n, int n2, int n3, KeyPair keyPair, KeyPair keyPair2) throws IOException {
        this.isAnSSHClient = false;
        this.sshSocket = socket;
        this.sshIn = new BufferedInputStream(socket.getInputStream(), 8192);
        this.sshOut = new BufferedOutputStream(socket.getOutputStream());
        this.protocolFlags = n;
        this.supportedCiphers = n2;
        this.supportedAuthTypes = n3;
        this.srvServerKey = keyPair;
        this.srvHostKey = keyPair2;
    }

    protected void start() {
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            forbiddenTargetException.printStackTrace();
        }
        this.myThread = new Thread(SSH.getThreadGroup(), this);
        this.myThread.start();
    }

    public void run() {
        try {
            System.out.println("connection from " + this.sshSocket.getInetAddress().getHostAddress() + " port " + this.sshSocket.getPort());
            this.negotiateVersion();
            this.sendServerData();
            this.receiveSessionKey();
            this.authenticateUser();
            this.controller = new SSHChannelController(this, this.sshIn, this.sshOut, this.sndCipher, this.rcvCipher, null, true);
            this.receiveOptions();
            this.controller.start();
            try {
                this.controller.waitForExit();
            }
            catch (InterruptedException interruptedException) {
                SSH.log("Error when shutting down SSHClient: " + interruptedException.getMessage());
                this.controller.killAll();
            }
        }
        catch (IOException iOException) {
            SSH.log("error in MindTunnel: " + iOException);
        }
    }

    static RSAPrivateKey getPrivate(SSHRSAKeyFile sSHRSAKeyFile) {
        RSAPrivateKey rSAPrivateKey = sSHRSAKeyFile.getPrivate("");
        while (rSAPrivateKey == null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("");
            System.out.print("key-file '" + sSHRSAKeyFile.getComment() + "' password: ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string = "";
            }
            rSAPrivateKey = sSHRSAKeyFile.getPrivate(string);
        }
        return rSAPrivateKey;
    }

    public static void sshd(int n) throws IOException {
        boolean bl = true;
        ServerSocket serverSocket = null;
        SSHRSAKeyFile sSHRSAKeyFile = new SSHRSAKeyFile(hostKeyFile);
        hostKey = new KeyPair(sSHRSAKeyFile.getPublic(), SSHServer.getPrivate(sSHRSAKeyFile));
        serverSocket = new ServerSocket(n);
        int n2 = Math.abs(serverKeyBits - ((RSAPublicKey)hostKey.getPublic()).bitLength());
        if (n2 < 24) {
            throw new IOException("Invalid server keys, difference in sizes must be at least 24 bits");
        }
        System.out.print("generating server-key of length " + serverKeyBits + "...");
        serverKey = SSH.generateRSAKeyPair(serverKeyBits, SSH.secureRandom());
        System.out.println("done");
        System.out.println("starting new MindTunnel on port " + n + "...");
        while (bl) {
            Socket socket = serverSocket.accept();
            SSHServer sSHServer = new SSHServer(socket, 2, 255, 15, serverKey, hostKey);
            sSHServer.localAddr = InetAddress.getLocalHost();
            sSHServer.start();
        }
    }

    void negotiateVersion() throws IOException {
        String string = SSH.getVersionId(false);
        string = string + "\n";
        byte[] byArray = string.getBytes();
        this.sshOut.write(byArray);
        this.sshOut.flush();
        byArray = new byte[256];
        int n = this.sshIn.read(byArray);
        this.cliVersionStr = new String(byArray, 0, n);
        try {
            int n2 = this.cliVersionStr.indexOf(45);
            int n3 = this.cliVersionStr.indexOf(46);
            this.cliVersionMajor = Integer.parseInt(this.cliVersionStr.substring(n2 + 1, n3));
            n2 = n3;
            n3 = this.cliVersionStr.indexOf(45, n2);
            this.cliVersionMinor = n3 == -1 ? Integer.parseInt(this.cliVersionStr.substring(n2 + 1)) : Integer.parseInt(this.cliVersionStr.substring(n2 + 1, n3));
        }
        catch (Throwable throwable) {
            throw new IOException("Client version string invalid: " + this.cliVersionStr);
        }
        if (this.cliVersionMajor > 1) {
            throw new IOException("MindTunnel do not support SSHv2 yet, can only serve SSHv1 client");
        }
        if (this.cliVersionMajor < 1 || this.cliVersionMinor < 5) {
            throw new IOException("Client's protocol version (" + this.cliVersionMajor + "-" + this.cliVersionMinor + ") is too old, please upgrade");
        }
        this.cliVersionStr = this.cliVersionStr.trim();
    }

    void sendServerData() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(2, null);
        SecureRandom secureRandom = SSH.secureRandom();
        this.srvCookie = new byte[8];
        secureRandom.nextBytes(this.srvCookie);
        this.generateSessionId();
        sSHPduOutputStream.write(this.srvCookie);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.srvServerKey.getPublic();
        int n = rSAPublicKey.bitLength();
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeBigInteger(rSAPublicKey.getE());
        sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        rSAPublicKey = (RSAPublicKey)this.srvHostKey.getPublic();
        n = rSAPublicKey.bitLength();
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeBigInteger(rSAPublicKey.getE());
        sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        sSHPduOutputStream.writeInt(this.protocolFlags);
        sSHPduOutputStream.writeInt(this.supportedCiphers);
        sSHPduOutputStream.writeInt(this.supportedAuthTypes);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    void receiveSessionKey() throws IOException {
        RSACipher rSACipher;
        RSACipher rSACipher2;
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(3, null);
        sSHPduInputStream.readFrom(this.sshIn);
        this.cipherType = sSHPduInputStream.readByte();
        if (!this.isCipherSupported(this.cipherType)) {
            // empty if block
        }
        SSH.log("cipher: " + SSH.getCipherName(this.cipherType));
        byte[] byArray = new byte[this.srvCookie.length];
        sSHPduInputStream.read(byArray);
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        int n = sSHPduInputStream.readInt();
        if (((RSAPrivateKey)serverKey.getPrivate()).bitLength() > ((RSAPrivateKey)hostKey.getPrivate()).bitLength()) {
            rSACipher2 = new RSACipher(serverKey);
            rSACipher = new RSACipher(hostKey);
        } else {
            rSACipher = new RSACipher(serverKey);
            rSACipher2 = new RSACipher(hostKey);
        }
        bigInteger = rSACipher2.doPrivate(bigInteger);
        bigInteger = RSACipher.stripPad(bigInteger);
        bigInteger = rSACipher.doPrivate(bigInteger);
        bigInteger = RSACipher.stripPad(bigInteger);
        this.sessionKey = bigInteger.toByteArray();
        if (this.sessionKey.length > 32) {
            byte[] byArray2 = new byte[32];
            System.arraycopy(this.sessionKey, 1, byArray2, 0, 32);
            this.sessionKey = byArray2;
        }
        int n2 = 0;
        while (n2 < this.sessionId.length) {
            int n3 = n2;
            this.sessionKey[n3] = (byte)(this.sessionKey[n3] ^ this.sessionId[n2]);
            ++n2;
        }
        this.initServerCipher();
        this.sendResult(14);
    }

    void authenticateUser() throws IOException {
        boolean bl = false;
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(4, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        String string = sSHPduInputStream.readString();
        SSH.log("authenticating: " + string);
        this.sendResult(15);
        while (!bl) {
            sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
            sSHPduInputStream.readFrom(this.sshIn);
            switch (sSHPduInputStream.type) {
                case 6: {
                    if (this.doRSAAuth(string, sSHPduInputStream.readBigInteger())) {
                        SSH.log("rsa-authentication for " + string + " succeeded");
                        this.sendResult(14);
                        bl = true;
                        break;
                    }
                    SSH.log("rsa-authentication for " + string + " failed");
                    this.sendResult(15);
                    break;
                }
                case 9: {
                    SSH.log("trying passwd-auth for: " + string);
                    this.sendResult(15);
                    break;
                }
                default: {
                    this.sendResult(15);
                }
            }
        }
    }

    boolean doRSAAuth(String string, BigInteger bigInteger) throws IOException {
        boolean bl = false;
        SSHRSAPublicKeyFile sSHRSAPublicKeyFile = SSHRSAPublicKeyFile.loadFromFile(authKeysDir + string, false);
        RSAPublicKey rSAPublicKey = sSHRSAPublicKeyFile.getPublic(bigInteger, string);
        if (rSAPublicKey == null) {
            return false;
        }
        RSACipher rSACipher = new RSACipher(new KeyPair(rSAPublicKey, null));
        byte[] byArray = new byte[32];
        SSH.secureRandom().nextBytes(byArray);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        bigInteger2 = RSACipher.doPad(bigInteger2, rSAPublicKey.bitLength(), SSH.secureRandom());
        bigInteger2 = rSACipher.doPublic(bigInteger2);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(7, this.sndCipher);
        sSHPduOutputStream.writeBigInteger(bigInteger2);
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(8, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        byArray2 = new byte[16];
        sSHPduInputStream.read(byArray2, 0, 16);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray, 0, 32);
            messageDigest.update(this.sessionId);
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            System.out.println("!!! MD5 Not supported...");
            throw new IOException(exception.getMessage());
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray2[n] != byArray[n]) break;
            ++n;
        }
        if (n == byArray.length) {
            bl = true;
        }
        return bl;
    }

    void receiveOptions() throws IOException {
        boolean bl = false;
        while (!bl) {
            SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
            sSHPduInputStream.readFrom(this.sshIn);
            switch (sSHPduInputStream.type) {
                case 37: {
                    SSH.log("compression requested");
                    break;
                }
                case 38: {
                    SSH.log("mtu requested");
                    break;
                }
                case 34: {
                    SSH.log("x11-tunnel requested");
                    this.sendResult(15);
                    break;
                }
                case 10: {
                    SSH.log("pty requested");
                    this.sendResult(15);
                    break;
                }
                case 28: {
                    int n = sSHPduInputStream.readInt();
                    String string = sSHPduInputStream.readString();
                    int n2 = sSHPduInputStream.readInt();
                    SSH.log("port-fwd requested: " + n + ":" + string + ":" + n2);
                    this.controller.newListenChannel(this.localAddr.getHostAddress(), n, string, n2, "general");
                    this.sendResult(14);
                    break;
                }
                case 13: {
                    String string = sSHPduInputStream.readString();
                    SSH.log("cmd: " + string);
                    bl = true;
                    break;
                }
                case 12: {
                    SSH.log("exec-shell");
                    bl = true;
                    break;
                }
                default: {
                    SSH.log("receiveOptions got unknown msg");
                }
            }
        }
    }

    void sendResult(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(n, this.sndCipher);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    static {
        authKeysDir = "";
        hostKeyFile = "identity";
        serverKeyBits = 768;
    }
}

