/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import mindbright.ssh.SSHSocket;
import mindbright.ssh.SSHSocketFactory;
import mindbright.ssh.SSHSocketImpl;

public class SSHServerSocket {
    public static final int DEFAULT_BACKLOG = 25;
    protected SSHSocketFactory factory;
    protected SSHSocketImpl impl;

    protected SSHServerSocket(SSHSocketImpl sSHSocketImpl) {
        this.impl = sSHSocketImpl;
    }

    protected void finalize() throws IOException {
        this.impl.close();
    }

    protected void setSocketFactory(SSHSocketFactory sSHSocketFactory) {
        this.factory = sSHSocketFactory;
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    protected int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public SSHSocket accept() throws IOException {
        SSHSocketImpl sSHSocketImpl = this.factory.createSocketImpl(this.impl.client, false);
        this.impl.accept(sSHSocketImpl);
        SSHSocket sSHSocket = new SSHSocket(sSHSocketImpl);
        return sSHSocket;
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws IOException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public String toString() {
        return "ServerSocket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }
}

