/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHClientUserAdaptor;
import mindbright.ssh.SSHServerSocket;
import mindbright.ssh.SSHSocket;
import mindbright.ssh.SSHSocketImpl;

public class SSHSocketFactory
extends SSHClientUserAdaptor {
    public static final int NOLISTENPORT = -1;
    protected SSHAuthenticator authenticator;
    protected Hashtable clientCache;

    public SSHSocketFactory(String string, int n, SSHAuthenticator sSHAuthenticator) {
        super(string, n);
        this.authenticator = sSHAuthenticator;
        this.clientCache = new Hashtable();
    }

    public SSHSocketFactory(String string, SSHAuthenticator sSHAuthenticator) {
        this(string, 22, sSHAuthenticator);
    }

    protected synchronized SSHClient getClient() {
        Enumeration enumeration = this.clientCache.keys();
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return (SSHClient)enumeration.nextElement();
    }

    protected void finalize() throws IOException {
        Enumeration enumeration = this.clientCache.keys();
        while (enumeration.hasMoreElements()) {
            SSHClient sSHClient = (SSHClient)enumeration.nextElement();
            sSHClient.waitForExit(1000L);
        }
    }

    protected synchronized void addClient(SSHClient sSHClient) {
        this.clientCache.put(sSHClient, new Vector());
    }

    protected synchronized void registerPseudoUser(SSHClient sSHClient, SSHSocketImpl sSHSocketImpl) {
        Vector vector = (Vector)this.clientCache.get(sSHClient);
        vector.addElement(sSHSocketImpl);
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void closePseudoAll(SSHClient var1_1) {
        var2_2 = (Vector)this.clientCache.get(var1_1);
        if (var2_2 != null) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (SSHSocketImpl)var2_2.elementAt(0);
            try {
                var3_3.close();
            }
            catch (IOException var4_4) {
                // empty catch block
            }
            var2_2.removeElementAt(0);
lbl11:
            // 2 sources

            ** while (var2_2.size() > 0)
        }
lbl12:
        // 1 sources

        this.clientCache.remove(var1_1);
    }

    protected synchronized void closePseudoUser(SSHClient sSHClient, SSHSocketImpl sSHSocketImpl) {
        Vector vector = (Vector)this.clientCache.get(sSHClient);
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) == sSHSocketImpl) {
                vector.removeElementAt(n);
                sSHClient.delRef();
                break;
            }
            ++n;
        }
        if (vector.size() == 0) {
            this.clientCache.remove(sSHClient);
        }
    }

    protected SSHClient createSSHClient(int n) throws IOException {
        SSHClient sSHClient;
        if (n != -1 || (sSHClient = this.getClient()) == null) {
            sSHClient = new SSHClient(this.authenticator, this);
            if (n != -1) {
                sSHClient.addRemotePortForward(n, InetAddress.getLocalHost().getHostAddress(), n, "general");
            }
            sSHClient.bootSSH(false);
            sSHClient.startExitMonitor();
            this.addClient(sSHClient);
        }
        return sSHClient;
    }

    protected SSHSocketImpl createSocketImpl(SSHClient sSHClient, boolean bl) throws IOException {
        SSHSocketImpl sSHSocketImpl = new SSHSocketImpl();
        sSHSocketImpl.setFactory(this);
        try {
            sSHSocketImpl.create(sSHClient, bl);
        }
        catch (IOException iOException) {
            sSHSocketImpl.close();
            throw iOException;
        }
        this.registerPseudoUser(sSHClient, sSHSocketImpl);
        return sSHSocketImpl;
    }

    public SSHSocket createSocket(String string, int n) throws IOException {
        SSHSocketImpl sSHSocketImpl = this.createSocketImpl(this.createSSHClient(-1), false);
        SSHSocket sSHSocket = new SSHSocket(sSHSocketImpl);
        try {
            sSHSocketImpl.connect(string, n);
        }
        catch (IOException iOException) {
            sSHSocketImpl.close();
            throw iOException;
        }
        return sSHSocket;
    }

    public SSHServerSocket createServerSocket(int n, int n2) throws IOException {
        SSHSocketImpl sSHSocketImpl = this.createSocketImpl(this.createSSHClient(n), true);
        SSHServerSocket sSHServerSocket = new SSHServerSocket(sSHSocketImpl);
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + n);
        }
        sSHSocketImpl.setFactory(this);
        try {
            sSHSocketImpl.bind(InetAddress.getLocalHost(), n);
            sSHSocketImpl.listen(n2);
        }
        catch (IOException iOException) {
            sSHSocketImpl.close();
            throw iOException;
        }
        sSHServerSocket.setSocketFactory(this);
        return sSHServerSocket;
    }

    public SSHServerSocket createServerSocket(int n) throws IOException {
        return this.createServerSocket(n, 25);
    }

    public void setServer(String string, int n) {
        this.sshHost = string;
        this.sshPort = n;
    }

    public void setServer(String string) {
        this.setServer(string, 22);
    }

    public void setAuthenticator(SSHAuthenticator sSHAuthenticator) {
        this.authenticator = sSHAuthenticator;
    }

    public void open(SSHClient sSHClient) {
    }

    public void connected(SSHClient sSHClient) {
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        this.closePseudoAll(sSHClient);
    }

    public void report(String string) {
        SSH.log("Embedded SSHClient report: " + string);
    }

    public void alert(String string) {
        SSH.log("Embedded SSHClient alert: " + string);
    }
}

