/*
 * Decompiled with CFR 0.152.
 */
package mindbright.util;

public final class PrimeSieve {
    public static final byte[] bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    int[] table;

    public PrimeSieve(int n) {
        if (n < 4) {
            n = 4;
        }
        int n2 = (n - 3) / 64;
        this.table = new int[n2];
        int n3 = n2 * 32;
        int n4 = (int)Math.sqrt(n3) + 1;
        int n5 = 0;
        while (n5 < n4) {
            if ((this.table[n5 / 32] & 1 << (n5 & 0x1F)) == 0) {
                int n6 = 3 + n5 * 2;
                int n7 = n5 + n6;
                while (n7 < n3) {
                    int n8 = n7 / 32;
                    this.table[n8] = this.table[n8] | 1 << (n7 & 0x1F);
                    n7 += n6;
                }
            }
            ++n5;
        }
    }

    public int availablePrimes() {
        int n = 0;
        int n2 = 2;
        while (n < this.table.length) {
            int n3 = this.table[n];
            int n4 = 0;
            while (n3 != 0) {
                n4 += bitCounts[n3 & 0xFF];
                n3 >>>= 8;
            }
            n2 += 32 - n4;
            ++n;
        }
        return n2;
    }

    public int getNextPrime(int n) {
        int n2 = (n - 3) / 2 + 1;
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        while (n2 / 32 < this.table.length) {
            if ((this.table[n2 / 32] & 1 << (n2 & 0x1F)) == 0) {
                return n2 * 2 + 3;
            }
            ++n2;
        }
        return 0;
    }
}

