/*
*(C)* The file is part of the source distribution of MacAnova
*(C)* version 4.06 or later
*(C)*
*(C)* Copyright (c) 1997 by Gary Oehlert and Christopher Bingham
*(C)* unless indicated otherwise
*(C)*
*(C)* You may give out copies of this software;  for conditions see the
*(C)* file COPYING included with this distribution
*(C)*
*(C)* This file is distributed WITHOUT ANY WARANTEE; without even
*(C)* the implied warantee of MERCHANTABILITY or FITNESS FOR
*(C)* A PARTICULAR PURPOSE
*(C)*
*/

#ifndef GLOBALSH__
#define GLOBALSH__

 /* definitions that depend on platform or compiler */
#ifndef PLATFORMH__
#include "platform.h"
#endif /*PLATFORMH__*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#ifndef NOSTDLIBH
#ifdef MPW
#include <StdLib.h>
#else /*MPW*/
#include <stdlib.h>
#endif /*MPW*/
#endif /*NOSTDLIBH*/

#ifndef NOVALUESH
#ifdef MPW
#include <Values.h>
#else /*MPW*/
#ifdef EPX
#undef MAXFLOAT /*to avoid repetitive pre-processor warning messages*/
#endif /*EPX*/
#include <values.h>
#endif /*MPW*/
#endif /*NOVALUESH*/

#ifndef NOFLOATH
#ifdef MPW
#include <Float.h>
#else /*MPW*/
#include <float.h>
#endif /*MPW*/
#endif /*NOFLOATH*/

/* definitions of Double, Long, Char, Int, Short, Void */
#include "typedefs.h"

#if (0)
/* Some Macintosh specific definitions */
#ifdef MACINTOSH
#include "macIface.h"
#endif
#endif

/* definition of contants */
#include "globdefs.h"

/* definitions related to symbol table */
#include "Symbol.h"

/* typedefs and some constants related to linear models */
#include "glm.h"

/* mainly definition and initialization of globals */
#include "globkb.h"

/* definitions, typedefs, and macros related to keyword processing */
#include "keywords.h"

/* definitions, globals, and macros related to interrupts */
#include "handlers.h"

/* definitions, etc related to coordinate labels */
#include "labels.h"

#ifndef MAINPARSC__
#undef ERROR
#if (0)
/*
  980717 added include "mainpars.h" to Ifsetup.c, Lang.c, Symbol.c,
         main.c, solve.c, utils.c, utilstru.c, yylex.c,
		 macBatchMode.c, macInput.c, wxmain.cc and removed it here
*/
/* defines of tokens generated by yacc */
#include "mainpars.h"
#endif /*0*/
#endif /*MAINPARSC__*/

/* The following headers are not mentioned in dependencies in Makefile */

/* macros useful in debugging */
#undef NDEBUG  /* if defined, debugging macros are vacuous */
#include "dbug.h"

/* prototypes for all files that should be in common among all versions */
#include "matProto.h"

/* 
	960220  Prototypes specific to Macintosh version are in macProto.h
	now included by macIface.h
*/


#ifdef WXWIN
/*
	960725  Prototypes specific to Windows/Motif version are in wxProto.h
	now included by wxIface.h
*/
#endif /*WXWIN*/

#if defined(UNIX)
/* prototypes specific to Unix Versions */
#include "unxProto.h"
#elif defined(VMS)
/* prototypes specific to VMS Versions (probably the same as unxProto.h) */
#include "vmsProto.h"
#elif defined(BCPP) || defined(DJGPP) || defined(wx_msw)
/* prototypes specific to Dos Versions (probably same as unxProto.h) */
#include "dosProto.h"
#endif /*UNIX||BCPP||DJGPP*/

/* prototypes for functions using files, may be different for different platforms */
#include "ioProto.h"

#endif /*GLOBALSH__*/
