#include"About.h"
#include"PC2.h"
#include<string.h>

static HWND hwndFrame = NULLHANDLE;
static HWND hwndClient = NULLHANDLE;
static HDC hdc;
static HPS hps;
static HBITMAP hbm;
static PFNWP defaultProc;

static PSZ Copyright = "Copyright  Akishi Murata";
static PSZ Version = "Version 1.00";


#define ABOUTBMP_WIDTH 290
#define ABOUTBMP_HEIGHT 200
#define IDC_AboutOk 1


void closeAboutWindow()
{
  WinDestroyWindow( hwndFrame );
  GpiDeleteBitmap( hbm );
  GpiDestroyPS( hps );
  DevCloseDC( hdc );

  hwndFrame = hwndClient = NULLHANDLE;
  hbm = NULLHANDLE;
  hps = NULLHANDLE;
  hdc = NULLHANDLE;
};


static MRESULT EXPENTRY clientProc
  ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch(msg){
  case WM_PAINT:
    {
      if( hbm == NULLHANDLE ) return (MRESULT)TRUE;

      RECTL retc;
      HPS localHps;

      localHps = WinBeginPaint( hwndClient, NULLHANDLE, NULL );
//      GpiErase(localHps);

      RECTL rect;
      POINTL point;
      rect.xLeft = rect.yBottom = 0;
      rect.xRight = ABOUTBMP_WIDTH;
      rect.yTop = ABOUTBMP_HEIGHT;
      point.x = point.y = 0;
      WinDrawBitmap( localHps, hbm, &rect, &point,
		    DBM_IMAGEATTRS, DBM_IMAGEATTRS, DBM_NORMAL );
/*
      ULONG pcclr;
      WinRealizePalette( hwndClient, localHps, &pcclr );
*/
      SIZEL sizel;
      GpiQueryDefCharBox( localHps, &sizel );
      point.x = 10;
      point.y = 190 - sizel.cy;
      GpiCharStringAt( localHps, &point, strlen(Copyright), Copyright );
      point.y -= sizel.cx * 4 / 3;
      GpiCharStringAt( localHps, &point, strlen(Version), Version );

      WinEndPaint( localHps );
      
      return (MRESULT)0;

    case WM_COMMAND:
      switch( COMMANDMSG(&msg)->cmd ){
      case IDC_AboutOk:
	closeAboutWindow();
	return 0;
      }
    }
  }
  return defaultProc( hwnd, msg, mp1, mp2 );
}


void openAboutPanel( HAB hab )
{
  DEVOPENSTRUC dop =
    {NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL, NULL};
  SIZEL  sizl={0, 0};
  hdc = DevOpenDC
    ( hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE );
  hps = GpiCreatePS(hab, hdc, &sizl, GPIA_ASSOC | PU_PELS);
  hbm = GpiLoadBitmap(hps, NULLHANDLE, IDBMP_ABOUT, 
		      ABOUTBMP_WIDTH, ABOUTBMP_HEIGHT );

  // EBhENX̓o^
  /* Register window class if not registered */
  static CLASSINFO cinfo;
  static PSZ CN_About = "About";
  if( FALSE == WinQueryClassInfo
     ( hab, CN_About, &cinfo ) ){
    WinRegisterClass
      (hab,
       (PSZ)CN_About,
       NULL,
       WS_ANIMATE,
       4L );
	}

  static ULONG fcf = FCF_TITLEBAR | FCF_DLGBORDER | FCF_TASKLIST;
  hwndFrame = WinCreateStdWindow
    (HWND_DESKTOP,
     WS_ANIMATE,
     &fcf,
     CN_About,	//	NULL,
     "About Picture Clock / 2",
     NULLHANDLE,
     0,
     0,
     &hwndClient );

  defaultProc = WinSubclassWindow( hwndClient, clientProc );

  ULONG winCX =
    ABOUTBMP_WIDTH +
    WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) * 2;
  ULONG winCY =
    ABOUTBMP_HEIGHT +
    WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ) * 2 +
    WinQuerySysValue( HWND_DESKTOP, SV_CYTITLEBAR );
  ULONG winX =
    ( WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) - ABOUTBMP_WIDTH ) >> 1;
  ULONG winY =
    ( WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN ) - ABOUTBMP_HEIGHT ) >> 1;
  WinSetWindowPos
    (hwndFrame,
     HWND_TOP,
     winX, winY, winCX, winCY,
     SWP_MOVE | SWP_SHOW | SWP_SIZE | SWP_ACTIVATE );

  // Version, Ok button, etc.
/*
  WinCreateWindow
    (hwndClient,
     WC_STATIC,
     "Copyright  Akishi Murata",
     SS_TEXT | SS_AUTOSIZE | DT_LEFT | DT_TOP | WS_VISIBLE,
     10, 170, ABOUTBMP_WIDTH-20, 20,
     hwndClient,
     HWND_TOP,
     0,
     NULL,
     NULL );
*/
  WinSetFocus
    (HWND_DESKTOP,
     WinCreateWindow
       (hwndClient,
	WC_BUTTON,
	"Ok",
	BS_PUSHBUTTON|WS_VISIBLE,
	200, 10, 80, 30,
	hwndClient,
	HWND_TOP,
	IDC_AboutOk,
	NULL,
	NULL )
     );
}
