/******************************************************************/
/* Name         :Conv_Ini.cmd                                     */
/* Sprache      :REXX OS/2                                        */
/* Autor        :Thorsten Ahlers                                  */
/* Datum        :14.07.2000                                       */
/* Funktion     :Konvertiert die Ini-Datei von der TS-Uhr V1.0X   */
/*               in das format der TS-Uhr V1.02                   */
/******************************************************************/

/******************************************************************
   Funktionen laden
*******************************************************************/
call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

/******************************************************************
   Einstellungen ins neue Format  von 1.00 -> 1.01
*******************************************************************/

rc = SysIni('TS_Uhr.ini',,   /* Anzahl und Typ der alten Ein-     */
            'Desk_Clock',,   /* stellungen aus der Datei auslesen */
            'all:',,
            einstell)

if rc \= 'ERROR:' then do         /* Wenn Einstellungen vorhanden */
  index = 0                       /* konvertieren                 */
  DO einstell.0
    index = index + 1

    SysIni('TS_Uhr.ini',,
           'Einstellung',,
           einstell.index,,
           SysIni('TS_Uhr.ini',,
                  'Desk_Clock',,
                  einstell.index))
  end

  SysIni('TS_Uhr.ini',,               /* Alte Einstellung lschen */
         'Desk_Clock',,
         'DELETE:')
end

/******************************************************************
   Einstellungen ins neue Format  von 1.01 -> 1.02
*******************************************************************/

Position = SysIni('TS_Uhr.ini',,
                  'Einstellung',,
                  'VordergrundEin')

if Position \= 'ERROR:' then do   /* Wenn Einstellungen vorhanden */
  if Position > X2C('00') then do /* konvertieren                 */
    SysIni('TS_Uhr.ini',,
           'Einstellung',,
           'Position', X2C('03000000'))

    SysIni('TS_Uhr.ini',,             /* Alte Einstellung lschen */
           'Einstellung',,
           'VordergrundEin',,
           'DELETE:')
  end
end

/******************************************************************
   Programmende
*******************************************************************/
return(0)
