/****************************************************************/
/* Searches all directories for INF files, and constructs       */
/* program objects for them.                                    */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   15 December 2000                      */
/*                                                              */
/****************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs

/* Create a desktop folder to hold the results. */

CALL SysCreateObject 'WPFolder',,
        'INF files',,
        '<WP_DESKTOP>',,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=FLOWED,INVISIBLE,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<AllINF_folder>',,
        'Update'

/* Scan all readable drives. */

Drives = SysDriveMap('C', 'USED')
do while Drives \= ''
    parse var Drives ThisDrive Drives
    if SysDriveInfo(ThisDrive) \= '' then call CheckDrive ThisDrive
end

/* All finished. */

SAY "Finished.  The results are in desktop folder 'INF files'."
Exit

/************************************************/
/* Procedure to check one drive.                */
/************************************************/

CheckDrive: PROCEDURE
    parse arg Drive
    Say 'Checking drive 'Drive
    call ScanDir Drive
    return

/************************************************/
/* Procedure to check a specified directory and */
/* its subdirectories.                          */
/************************************************/

ScanDir: PROCEDURE
    parse arg ThisDir
    call SysFileTree ThisDir'\*.inf', 'file', 'FO'
    DO j=1 to file.0
         CALL AddFile ThisDir, file.j
    END
    call SysFileTree ThisDir'\*.*', 'file', 'DO'
    DO j=1 to file.0
         CALL ScanDir file.j
    END
    return

/********************************************************/
/* Procedure to create a program object for viewing the */
/* INF file that is given as an argument.               */
/********************************************************/

AddFile: PROCEDURE
    parse arg Dir, FileName
    Title0 = CHARIN(FileName, 1, 619)
    CALL Stream FileName, 'C', 'CLOSE'
    IF LEFT(Title0, 3) \= 'HSP' THEN RETURN
    Title0 = RIGHT(Title0, 512)
    Title0 = STRIP(Title0, 'B', '0'X)
    j = POS('0'X, Title0)
    IF j>0 THEN Title0 = LEFT(Title0, j-1)
    Try = 1
    Title = Title0
    Setup = 'EXENAME=VIEW.EXE;STARTUPDIR='Dir';PARAMETERS='Filename
    DO until (ans=1) | (Try > 99)
        ans = SysCreateObject( 'WPProgram', Title, '<AllINF_folder>', Setup, 'F' )
        if ans = 0 then do
            Title = Title0||':'||Try
            Try = Try + 1
        END
    END
    RETURN

