#include "kcmdexec.h"
#include "kerrcoll.h"
#include "cntrladm.h"
#include "ctrlwin.h"

/******************************************************************************
 * The commandQueue queues commands generated by the user. Each EditControl
 * should have an instance of this class. Note that this is a thread, so
 * it should be started after creation.
 *
 * Initially, the queue queues commands, but does not execute them until
 * the owner calls executorReady(), to allow for initialization by the 
 * owner.
 *
 * This class deletes itself on exit, but the user should call the close method
 * for this to happen.
 *
 * The EditControl should implement the KCommandExecutor class.
 */

/*
 * The ShellExecutor is needed in order to exit a window, since this
 * cannot be done within the executor (which is an EditControl) itself,
 * but has to be done from the outside.
 * The ShellExecutor will just call ControllerWindow::processExitList() after
 * each run.
 */

class ShellExecutor : public KCommandExecutor
{
  KCommandExecutor *executor, *originalExecutor;
public:
  ShellExecutor( KCommandExecutor *executor ) { this->executor = originalExecutor = executor; }
  TSyntax *eval( char *name, TVariableList *vars, TEval *eval, int index )
  {
    TSyntax *result = executor->eval( name, vars, eval, index );
    ControlAdmin::processExitList();
    return result;
  }
  virtual void setRunning( BOOL isRunning ) 
  { 
		if( executor == originalExecutor ) return;
  	this->isRunning = isRunning;
    executor->setRunning( isRunning );
  }
  void setStartExecRunning( BOOL isRunning ) ;
	virtual void switchExecutor( KCommandExecutor *newExecutor );
  ~ShellExecutor();
};

class CommandQueue : public Thread // Kills itself on exit
{
#define MAXCOMMANDSINQUEUE  10
  char *command[MAXCOMMANDSINQUEUE];
  int commands, atPos, macroSize, recordingStarted;
  ShellExecutor *executor;
  EventSemaphore newCmdSem, idleSem;
  MutexSemaphore editCmdRingSem;
  BOOL terminate, record, ready, frameClose;
  char *macroCode;
  TModule *macroModule;
  int lastCommandStart;
  TEval *eval;
	EditControl *editControl;
public:
  CommandQueue( KCommandExecutor *executor, EditControl *editControl ) : commands(0), atPos(0),
    terminate(FALSE), Thread( TRUE ), record( FALSE ), macroCode( NULL ),
    macroModule( NULL ), eval(NULL), ready(FALSE), frameClose(FALSE)
  {
    this->executor = new ShellExecutor( executor );
		this->editControl = editControl;
  }

  void addCommand( char *command );
  void terminateCommand();

  void run();

  void startRecord() { record = TRUE; recordingStarted = FALSE; }
  void endRecord();
  BOOL isRecording() { return record; }
  char *getMacroCode() { if( record ) endRecord(); return macroCode; }
  void executorReady()
  {
    ready = TRUE;
    if( commands > 0 )
      newCmdSem.post();
  }

  void close()
  {
    terminate = TRUE;
    terminateCommand(); // Close running commands
    newCmdSem.post();
  }

	void closeParentFrame()
	{
		frameClose = TRUE;
		close();
	}
  virtual ~CommandQueue()
  {
  }
};
