#ifndef VS_H
#define VS_H

extern "C" {

#define VSMAXFILENAME  1024
#define VSMAXSERVERNAME  256
#define VSMAXNAME        256
#define VSMAXEVENTNAME   64
#define VSMAXEMULATION   64
#define VSMAXCURWORD     1024
#define VSMAXMESSAGE     1024
#define VSMAXMESSAGELINE 1024
#define VSMAXMENUSTRING  VSMAXMESSAGELINE
#define VSMAXNAMEINFO    1024
#define VSMAXBOOKMARKLINEDATA  1024
#define VSMAXBOOKMARKNAME 256
#define VSMAXDOCUMENTNAME 1024
#define VSMAXEXTENSION    256
#define VSMAXLEXERNAME    256
#define VSMAXMODENAME     256
#define VSMAXBEGINENDPAIRS 1024
#define VSMAXWORDCHARS    300

#define VSOI_MDI_FORM          1
#define VSOI_FORM              2
#define VSOI_TEXT_BOX          3
#define VSOI_CHECK_BOX         4
#define VSOI_COMMAND_BUTTON    5
#define VSOI_RADIO_BUTTON      6
#define VSOI_FRAME             7
#define VSOI_LABEL             8
#define VSOI_LIST_BOX          9
#define VSOI_HSCROLL_BAR       10
#define VSOI_VSCROLL_BAR       11
#define VSOI_COMBO_BOX         12
#define VSOI_HTHELP            13
#define VSOI_PICTURE_BOX       14
#define VSOI_IMAGE             15
#define VSOI_GAUGE             16
#define VSOI_SPIN              17
#define VSOI_MENU              18
#define VSOI_MENU_ITEM         19
#define VSOI_TREE_VIEW         20
#define VSOI_SSTAB             21
#define VSOI_DESKTOP           22
#define VSOI_SSTAB_CONTAINER   23
#define VSOI_EDITOR            24

#define VSSC_SIZE         0xF000
#define VSSC_MOVE         0xF010
#define VSSC_MINIMIZE     0xF020
#define VSSC_MAXIMIZE     0xF030
#define VSSC_NEXTWINDOW   0xF040
#define VSSC_PREVWINDOW   0xF050
#define VSSC_CLOSE        0xF060
#define VSSC_RESTORE      0xF120

// RefreshFlags
#define VSREFRESH_BUFTEXT    0x0001   /* Buffer refresh flag */
#define VSREFRESH_BUFNAME    0x0002   /* Buffer refresh flag */
#define VSREFRESH_MODENAME   0x0004   /* Buffer refresh flag */
#define VSREFRESH_READONLY   0x0008   /* Buffer refresh flag */
#define VSREFRESH_LINE       0x0010
#define VSREFRESH_COL        0x0020
#define VSREFRESH_INSERTMODE 0x10000
#define VSREFRESH_RECORDING  0x20000

void VSAPI vsBufRefresh(int buf_id,int flags=VSREFRESH_BUFTEXT);

#define VSSTATUSFLAG_READONLY    0x0001
#define VSSTATUSFLAG_INSERTMODE  0x0002
#define VSSTATUSFLAG_RECORDING   0x0004

#define VSNULLSEEK      0x7fffffffl


   struct VSSAVEPOS {
      char buffer[150];
   };

typedef void (VSAPI *VSPFNCALLBACK_AR_BUF_TEXT_CHANGED)(int buf_id,int wid,long StartMod,long EndMod);
typedef void (VSAPI *VSPFNCALLBACK_AR_APP_DELETE_BUFFER)(int buf_id);
typedef void (VSAPI *VSPFNCALLBACK_AR_BUF_LINES_INSERTED)(int buf_id,int AfterLineNum,int Noflines);
typedef void (VSAPI *VSPFNCALLBACK_AR_BUF_LINES_DELETED)(int buf_id,int FirstLineNum,int Noflines);
typedef void (VSAPI *VSPFNCALLBACK_AR_APP_SELECT_MODE)(int wid,const char *pszExtension);
typedef void (VSAPI *VSPFNUPDATEEDITORSTATUS)(
                  int wid,int RefreshFlags,
                  int linenum,int col,
                  const char *pModeName,int ModeNameLen,
                  int StatusFlags,
                  int reserved);



#define VSP_CANCEL              0   /* boolean*/
#define VSP_DEFAULT             1   /* boolean*/
#define VSP_ENABLED             2   /* boolean*/
#define VSP_FONTBOLD            3   /* boolean*/
#define VSP_FONTITALIC          4   /* boolean*/
#define VSP_FONTSIZE            5   /* string*/
#define VSP_FONTSTRIKETHRU      6   /* boolean*/
/* #define                       7 */
#define VSP_FONTUNDERLINE       8   /* boolean*/
#define VSP_MAXBUTTON           9   /* boolean*/
#define VSP_MINBUTTON           10  /* boolean*/
#define VSP_VISIBLE             11  /* boolean*/
#define VSP_TABSTOP             12  /* boolean*/
#define VSP_CONTROLBOX          13  /* boolean*/
/* #define                       14 */ /* boolean*/
#define VSP_STYLE               15   /* int */
#define VSP_BORDERSTYLE         16   /* int */
#define VSP_DRAWSTYLE           17   /* int */
#define VSP_SCROLLBARS          18   /* int */
   #define VSSB_NONE         0
   #define VSSB_HORIZONTAL   1
   #define VSSB_VERTICAL     2
   #define VSSB_BOTH         3

#define VSP_MULTISELECT         19   /* int */
#define VSP_INITSTYLE           20   /* int */
/* #define                       21 */
#define VSP_ALIGNMENT           22   /* int */
#define VSP_WINDOWSTATE         23   /* string. */
#define VSP_MOUSEPOINTER        24   /* int */
#define VSP_INITINFO            25   /* int */
#define VSP_VALIDATEINFO        26   /* int */
#define VSP_EVENTTAB            27   /* int */
#define VSP_NAME                28   /* string */
#define VSP_CAPTION             29   /* string */
#define VSP_FONTNAME            30   /* string. */
#define VSP_BACKCOLOR           31   /* int */
/* #define                         32 *//* int */
#define VSP_DRAWMODE            33   /* int */
#define VSP_DRAWWIDTH           34   /* int */
#define VSP_FORECOLOR           35   /* int */
#define VSP_HEIGHT              36   /* int */
#define VSP_INTERVAL            37   /* int */
#define VSP_TABINDEX            38   /* int */
#define VSP_WIDTH               39   /* int */
#define VSP_X                   40   /* int */
#define VSP_Y                   41   /* int */
#define VSP_VALUE               42   /* int */
#define VSP_INFROMLEFT          43   /* int */
#define VSP_DOWNFROMTOP         44   /* int */
#define VSP_INFROMRIGHT         45   /* int */
#define VSP_UPFROMBOTTOM        46   /* int */
#define VSP_SCALEMODE           47   /* int */
#define VSP_X1                  48   /* int */
#define VSP_Y1                  49   /* int */
#define VSP_X2                  50   /* int */
#define VSP_Y2                  51   /* int */
#define VSP_TEXT                52   /* string */
#define VSP_PICPOINTSCALE       53   /* int */
#define VSP_AFTERPICINDENTX     54   /* int */
#define VSP_PICSPACEY           55   /* int */
#define VSP_PICINDENTX          56   /* int */
#define VSP_PICTURE             57   /* int */
#define VSP_CBACTIVE            58   /* int */
#define VSP_STRETCH             59   /* boolean */
#define VSP_FONTPRINTER         60   /* boolean */
#define VSP_AUTOSIZE            61   /* boolean */
#define VSP_CBPICTURE           62   /* int */
#define VSP_CBLISTBOX           63   /* int */
#define VSP_CBTEXTBOX           64   /* int */
#define VSP_CB                  65   /* int */
#define VSP_OBJECT              66   /* string*/
#define VSP_CHILD               67   /* int */
#define VSP_NEXT                68   /* int */
#define VSP_CLIPCONTROLS        69   /* boolean */
#define VSP_WORDWRAP            70   /* boolean */
#define VSP_ADEFAULT            71   /* boolean */
#define VSP_EDIT                72   /* boolean */
#define VSP_SELECTED            73   /* boolean */
#define VSP_OBJECTMODIFY        74   /* boolean */
#define VSP_FILLSTYLE           75   /* int */
#define VSP_EVENTTAB2           76   /* int */
#define VSP_MIN                 77   /* int */
#define VSP_MAX                 78   /* int */
#define VSP_LARGECHANGE         79   /* int */
#define VSP_SMALLCHANGE         80   /* int */
#define VSP_DELAY               81   /* int */
#define VSP_CBEXTENDEDUI        82   /* boolean */
#define VSP_NOFSTATES           83   /* int */
#define VSP_ACTIVEFORM          84   /* int */
#define VSP_TEMPLATE            85   /* int */
#define VSP_COMPLETION          86   /* string */
#define VSP_MAXCLICK            87   /* int */
#define VSP_NOFSELECTED         88   /* int */
#define VSP_AUTOSELECT          89   /* boolean */
#define VSP_INCREMENT           90   /* int */
#define VSP_PREV                91   /* int */
#define VSP_COMMAND             92   /* string */
#define VSP_MESSAGE             93   /* string */
#define VSP_CATEGORIES          94   /* string */
#define VSP_CHECKED             95   /* boolean */


#define VSP_TILEID               100  /* int */
#define VSP_WINDOWFLAGS          101  /* int */
   #define VSWINDOWFLAG_HIDDEN  0x1
   #define VSWINDOWFLAG_OVERRIDE_CURLINE_RECT 0x4
   #define VSWINDOWFLAG_CURLINE_RECT 0x8
   #define VSWINDOWFLAG_OVERRIDE_CURLINE_COLOR 0x10
   #define VSWINDOWFLAG_CURLINE_COLOR 0x20
#define VSP_VSBBYTEDIVS          102  /* int */
#define VSP_WINDOWID             103  /* int */
#define VSP_LEFTEDGE             104  /* int */
#define VSP_CURSORX              105  /* int */
#define VSP_CURSORY              106  /* int */
#define VSP_LINE                 107  /* int */
#define VSP_NOFLINES             108  /* int */
#define VSP_COL                  109  /* int */
#define VSP_BUFNAME              110  /* string */
#define VSP_MODIFY               111  /* int */
#define VSP_BUFID                112  /* int */
#define VSP_MARGINS              113  /* string */
#define VSP_TABS                 114  /* string */
#define VSP_MODENAME             115  /* string */
#define VSP_BUFWIDTH             116  /* int */
#define VSP_WORDWRAPSTYLE        117  /* int */
   #define VSWWS_STRIP_SPACES  1
   #define VSWWS_WORD_WRAP     2
   #define VSWWS_JUSTIFY       4
   #define VSWWS_ONESPACE      8

#define VSP_SHOWTABS             118  /* int */
#define VSP_INDENTWITHTABS       119  /* boolean */
#define VSP_BUFFLAGS             120  /* int */
#define VSP_NEWLINE              121  /* string */
#define VSP_UNDOSTEPS            122  /* int */
#define VSP_INDEX                123  /* int */
#define VSP_BUFSIZE              124  /* int */
#define VSP_CHARHEIGHT           125  /* int */
#define VSP_CHARWIDTH            126  /* int */
#define VSP_VSBMAX               127  /* int */
#define VSP_HSBMAX               128  /* int */
#define VSP_FONTHEIGHT           129  /* int */
#define VSP_FONTWIDTH            130  /* int */
#define VSP_CLIENTHEIGHT         131  /* int */
#define VSP_CLIENTWIDTH          132  /* int */
#define VSP_OLDX                 133  /* int */
#define VSP_OLDY                 134  /* int */
#define VSP_OLDWIDTH             135  /* int */
#define VSP_OLDHEIGHT            136  /* int */
#define VSP_ONEVENT              137  /* int */
#define VSP_SELLENGTH            138  /* int */
#define VSP_SELSTART             139  /* int */
#define VSP_CURRENTX             140  /* int */
#define VSP_CURRENTY             141  /* int */
#define VSP_PARENT               142  /* int */
#define VSP_MDICHILD             143  /* int */
#define VSP_WINDENTX             144  /* int */
#define VSP_FIXEDFONT            145  /* int */
#define VSP_RELLINE              146  /* int */
#define VSP_SCROLLLEFTEDGE       147  /* int */
#define VSP_DISPLAYXLAT          148  /* string */
#define VSP_UNDOVISIBLE          149  /* int */
#define VSP_MODAL                150  /* int */
#define VSP_NOFWINDOWS           151  /* int */
#define VSP_USER                 152  /* string */
#define VSP_USER2                153  /* string */
#define VSP_NOSELECTCOLOR        154  /* boolean */
#define VSP_VIEWID               155  /* int */
#define VSP_INDENTSTYLE          156  /* int */
   #define VSINDENTSTYLE_NONE        0
   #define VSINDENTSTYLE_AUTO        1
   #define VSINDENTSTYLE_SMART       2

#define VSP_MODEEVENTTAB         157  /* int */
#define VSP_XYSCALEMODE          158  /* int */
#define VSP_XYPARENT             159  /* int */
#define VSP_BUTTONBAR            160  /* int */
#define VSP_ISBUTTONBAR          161  /* int */
#define VSP_MENUHANDLE           163  /* int */
#define VSP_FILEDATE             164  /* string */
#define VSP_REDRAW               165  /* boolean */
#define VSP_WORDCHARS            166  /* string */
#define VSP_LEXERNAME            167  /* string */
#define VSP_BUSER                168  /* string */
#define VSP_COLORFLAGS           169  /* int */
   #define VSCOLORFLAG_LANGUAGE    0x1
   #define VSCOLORFLAG_MODIFY      0x2
   #define VSCOLORFLAG_CLINE       0x4
#define VSP_HWND                 170  /* long */
#define VSP_HWNDFRAME            171  /* long */



#define VSP_BINARY              172   /* boolean */
#define VSP_SHOWEOF             173   /* boolean */
//#define I_SHOWNLCHARS         174
#define VSP_READONLYMODE       175    /* boolean */
#define VSP_HEXNIBBLE          176    /* boolean */
#define VSP_HEXMODE            177    /* boolean */
#define VSP_HEXFIELD           178    /* int */
#define VSP_HEXNOFCOLS         179    // int
#define VSP_HEXTOPPAGE         180    // int
#define VSP_NOFHIDDEN          181    // int
#define VSP_LINENUMBERSLEN     182    // int
#define VSP_READONLYSETBYUSER  183    // boolean

#define VSP_WINDENT_Y          184    // int
#define VSP_NOFSELDISPBITMAPS  185    // int
#define VSP_LINESTYLE          186    // int
#define VSP_LEVELINDENT        187    // int
#define VSP_SPACEY             188    // int
#define VSP_EXPANDPICTURE      189    // int
#define VSP_COLLAPSEPICTURE    190    // int
#define VSP_SHOWROOT           191    // int
//#define VSP_CHECKLISTBOX       192    not supported


//#define VSP_PASSWORD            198   not supported
#define VSP_READONLY            199   // boolean
#define VSP_SHOWSPECIALCHARS    200   // int
#define VSP_MOUSEACTIVATE       201   // int
#define VSP_MODIFYFLAGS         202   // int
#define VSP_OLDLINENUMBER       203   // int
#define VSP_NOFNOSAVE           204   // int
#define VSP_CAPTIONCLICK        205   // boolean
#define VSP_RLINE               206   // int
#define VSP_RNOFLINES           207   // int


// SSTab properties
#define VSP_ACTIVETAB           208   // int
#define VSP_ORIENTATION         209   // int
#define VSP_TABSPERROW          210   // int
#define VSP_MULTIROW            211   // boolean
#define VSP_NOFTABS             212   // int
#define VSP_ACTIVEORDER         213   // int
#define VSP_ACTIVECAPTION       214   // int
#define VSP_ACTIVEPICTURE       215   // int
#define VSP_ACTIVEHELP          216   // string
#define VSP_RBUFSIZE            217   // int
#define VSP_ACTIVEENABLED       218   // boolean
#define VSP_PICTUREONLY         219   // boolean
#define VSP_SOURCERECORDING     220   // boolean
#define VSP_CONSERVERESOURCE    221   // boolean
#define VSP_PADDINGX            222   // int
#define VSP_PADDINGY            223   // int
#define VSP_FIRSTACTIVETAB      224   // int
#define VSP_ALLOWSAVE           225   // boolean
#define VSP_DEBUGMODE           226   // boolean
#define VSP_SPLITID             227   // int
#define VSP_SPLITORDER          228   // int
#define VSP_CALLBACKBUFSETLINECOLOR  229 // long
#define VSP_EMBEDDEDLEXERNAME   230      // string
#define VSP_SYNTAXINDENT        231      // int
#define VSP_DOCUMENTNAME        232      // string
#define VSP_EXTENSION           233      // string
#define VSP_LANGCASESENSITIVE   234      // boolean
#define VSP_SWAPCOLORS          235      // boolean
#define VSP_TOOLBARBORDER       236      // int

#define VSP_PROTECTREADONLYMODE 237      // int
   #define VSPROTECTREADONLYMODE_OPTIONAL 0
   #define VSPROTECTREADONLYMODE_ALWAYS   1
   #define VSPROTECTREADONLYMODE_NEVER    2

/* Completion arguments */
    /* "!" indicates last argument. */
#define VSARG_MORE     "*"      /* Indicate more arguments. */
#define VSARG_WORD     "w"      /* Match what was typed. */
#define VSARG_FILE     "f:18"   /* Match one file. 18=FILE_CASE_MATCH|AUTO_DIR_MATCH*/
#define VSARG_MULTI_FILE  VSARG_FILE"*"
#define VSARG_BUFFER     "b:2"    /* Match buffer. */
#define VSARG_COMMAND    "c"
#define VSARG_PICTURE    "_pic"
#define VSARG_FORM       "_form"
#define VSARG_OBJECT     "_object"
#define VSARG_MODULE     "m"
#define VSARG_PC         "pc"     /* look for procedure or command . */
                      /* look Slick-C tag cmd,proc,form */
#define VSARG_MACROTAG   "mt:8"   /* Any find-proc item. 8=REMOVE_DUPS_MATCH */
#define VSARG_MACRO      "k"      /* Recorded macro command. */
#define VSTYPE_ARG_PCB   "pcbt"   /* list proc,command, and built-in types. */
#define VSARG_VAR        "v"      /* look for variable. Global vars not included.*/
#define VSARG_ENV        "e"      /* look for environment variables. */
#define VSARG_MENU       "_menu"
#define VSARG_HELP       "h:37" /* (TERMINATE_MATCH|ONE_ARG_MATCH|NO_SORT_MATCH) */
   /* Match tag used by push-tag command. */
#define VSARG_TAG        "tag:37" /* (REMOVE_DUPS_MATCH|NO_SORT_MATCH|TERMINATE_MATCH) */



/*
   NOTE:

   VSARG2_MARK,VSARG2_NOEXIT_SCROLL,
   VSARG2_READ_ONLY, VSARG2_ICON are now
   ignored if the command does not require an
   editor control.

       VSARG2_REQUIRES_EDITORCTL
                or
       VSARG2_REQUIRES_MDI_EDITORCTL

   This is different than versions <= 3.0
*/
#define VSARG2_NCW      0      // Ignored. Here for backward compatibility.
                               // Previously: Command allowed when there are no MDI child windows.
#define VSARG2_CMDLINE  0x4    // Command supports the command line.
                               // VSARG2_CMDLINE allows a fundamental mode
                               // key binding to be inherited by the command line
#define VSARG2_MARK     0x8    // ON_SELECT event should pass control on
                               // to this command and not deselect text first.
                               // Ignored if command does not require an editor control
#define VSARG2_QUOTE     0x40  // Indicates that this command must be quoted when
                               // called during macro recording.  Needed only if
                               // command name is an invalid identifier or
                               // keyword.
#define VSARG2_LASTKEY  0x80   // Command requires last_event value to be set
                               // when called during macro recording.
#define VSARG2_MACRO     0x100      // This is a recorded macro command. Used for completion.
#define VSARG2_HELP      0          // Ignored. Here for backward compatibility.
#define VSARG2_HELPSALL  0          // Ignored. Here for backward compatibility.
#define VSARG2_TEXT_BOX  0x800      // Command supports any text box control.
                                    // VSARG2_TEXT_BOX allows a fundamental mode
                                    // key binding to be inherited by a text box
#define VSARG2_NOEXIT_SCROLL 0x1000 // Do not exit scroll caused by using scroll bars.
                                    // Ignored if command does not require an editor control
#define VSARG2_EDITORCTL   0x2000   // Command allowed in editor control.
                                    // VSARG2_EDITORCTL allows a fundamental mode
                                    // key binding to be inherited by a non-MDI editor control
#define VSARG2_NOUNDOS     0x4000   // Do not automatically call _undo('s').
                                    // Require macro to call _undo('s') to
                                    // start a new level of undo.
// Command allowed when editor control is in strict read only mode
// Ignored if command does not require an editor control
#define VSARG2_READ_ONLY   0x10
// Command allowed when editor control window is iconized
// Ignored if command does not require an editor control
#define VSARG2_ICON        0x2


// Command requires any editor control
#define VSARG2_REQUIRES_EDITORCTL       (VSARG2_REQUIRES_MDI_EDITORCTL|EDITORCTL_ARG2)
#define VSARG2_REQUIRES_MDI_EDITORCTL   0x00010000 // Command requires mdi editor control


#define VSARG2_REQUIRES_AB_SELECTION    0x00020000 // Command requires selection in active buffer
#define VSARG2_REQUIRES_BLOCK_SELECTION 0x00040000 // Command requires block/column selection in any buffer
#define VSARG2_REQUIRES_CLIPBOARD       0x00080000 // Command requires editorctl clipboard
#define VSARG2_REQUIRES_FILEMAN_MODE    0x00100000 // Command requires active buffer to be in fileman mode
#define VSARG2_REQUIRES_TAGGING         0x00200000 // Command requires <ext>_proc_search/find-tag support
//#define VSARG2_REQUIRES_                0x00400000

#define VSARG2_REQUIRES_SELECTION       0x00800000 // Command requires a selection in any buffer
#define VSARG2_REQUIRES_MDI             0x00008000 // Command requires mdi interface may be because
                                                   // it opens a new file or uses _mdi object.

#define VSARG2_REQUIRES  (VSARG2_REQUIRES_TAGGING|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION|VSARG2_REQUIRES_BLOCK_SELECTION|VSARG2_REQUIRES_CLIPBOARD|VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_SELECTION|VSARG2_REQUIRES_MDI)

/* vsNameType flags. */

#define VSWWS_STRIP_SPACES     1
#define VSWWS_WORD_WRAP        2
#define VSWWS_JUSTIFY          4

#define VSSHOWSPECIALCHARS_NLCHARS  0x01
#define VSSHOWSPECIALCHARS_TABS     0x02
#define VSSHOWSPECIALCHARS_SPACES   0x04
#define VSSHOWSPECIALCHARS_EOF      0x08
#define VSSHOWSPECIALCHARS_ALL      0xff

#define VSBUF_RETRIEVE     0

#define VSVIEW_HIDDEN -9

// p_buf_flags
#define VSBUFFLAG_HIDDEN        0x1  /* NEXT_BUFFER won't switch to this buffer */
#define VSBUFFLAG_THROW_AWAY_CHANGES 0x2  /* Allow quit without prompting on modified buffer */
#define VSBUFFLAG_KEEP_ON_QUIT 0x4  /* Don't delete buffer on QUIT.  */
#define VSBUFFLAG_REVERT_ON_THROW_AWAY 0x10
#define VSBUFFLAG_PROMPT_REPLACE 0x20
#define VSBUFFLAG_DELETE_BUFFER_ON_CLOSE 0x40   /* Indicates whether a list box/ */

// Predefined object handles

#define VSWID_DESKTOP       1
#define VSWID_APP           2
#define VSWID_MDI           3
#define VSWID_CMDLINE       4
#define VSWID_HIDDEN        5
#define VSWID_STATUS        6

#include <slickc.h>
#define VSSELECT_INCLUSIVE     0x1
#define VSSELECT_NONINCLUSIVE  0x2
#define VSSELECT_CURSOREXTENDS 0x4
#define VSSELECT_BEGINEND      0x8
#define VSSELECT_PERSISTENT    0x10


#define VSSELECT_LINE   1
#define VSSELECT_CHAR   2
#define VSSELECT_BLOCK  4
// Only supported by vsSetSelectType
#define VSSELECT_NONINCLUSIVEBLOCK 8

#define VSOPTION_WARNING_ARRAY_SIZE    1
#define VSOPTION_WARNING_STRING_LENGTH 2
#define VSOPTION_VERTICAL_LINE_COL     3
#define VSOPTION_WEAK_ERRORS           4
#define VSOPTION_MAXIMIZE_FIRST_MDICHILD  5
#define VSOPTION_MAXTABCOL             6
#define VSOPTION_CURSOR_BLINK          7
#define VSOPTION_DISPLAY_TEMP_CURSOR   8
#define VSOPTION_LEFT_MARGIN           9
#define VSOPTION_DISPLAY_TOP_OF_FILE   10
#define VSOPTION_HORIZONTAL_SCROLL_BAR 11
#define VSOPTION_VERTICAL_SCROLL_BAR   12
#define VSOPTION_HIDE_MOUSE            13
#define VSOPTION_ALT_ACTIVATES_MENU    14
#define VSOPTION_DRAW_BOX_AROUND_CURRENT_LINE 15
#define VSOPTION_MAX_MENU_FILENAME_LEN 16
#define VSOPTION_PROTECT_READONLY_MODE 17
#define VSOPTION_PROCESS_BUFFER_CR_ERASE_LINE 18
#define VSOPTION_ENABLE_FONT_FLAGS     19
#define VSOPTION_APIFLAGS              20
#define VSOPTION_HAVECMDLINE           21
#define VSOPTION_QUIET                 22
#define VSOPTION_SHOWTOOLTIPS          23
#define VSOPTION_TOOLTIPDELAY          24
#define VSOPTION_HAVEMESSAGELINE       25
#define VSOPTION_HAVEGETMESSAGELINE    26
#define VSOPTION_MACRO_SOURCE_LEVEL    27
#define VSOPTION_VSAPI_SOURCE_LEVEL    28
#define VSOPTION_APPLY_LOCAL_STATE_FILE_CHANGES 29
#define VSOPTION_EMBEDDED              30
#define VSOPTION_DISPLAYVERSIONMESSAGE 31
#define VSOPTION_CXDRAGMIN             32
#define VSOPTION_CYDRAGMIN             33
#define VSOPTION_DRAGDELAY             34
#define VSOPTION_MDI_SHOW_WINDOW_FLAGS 35//4:26pm 4/20/1998
                                         //Dan added for to support hiding mdi
                                         //on startup
#define VSOPTION_SEARCHDEFAULTFLAGS           36
   #define VSSEARCHDEFAULTFLAG_INIT_HISTORY      0x1
   #define VSSEARCHDEFAULTFLAG_INIT_CURWORD      0x2
   #define VSSEARCHDEFAULTFLAG_INIT_SELECTION    0x4
   // INIT_SELECTION can be on with HISTORY or CURWORD
   #define VSSEARCHDEFAULTFLAGC_INIT_MASK        (0x1|0x2)

   #define VSSEARCHDEFAULTFLAG_IGNORE_CASE       0x20
   #define VSSEARCHDEFAULTFLAG_WRAP_AT_BEGIN_END 0x40
   #define VSSEARCHDEFAULTFLAG_RESTORE_CURSOR_AFTER_REPLACE 0x80
   #define VSSEARCHDEFAULTFLAG_LEAVE_SELECTED    0x100
   #define VSSEARCHDEFAULTFLAG_RE                0x200

   #define VSSEARCHDEFAULTFLAG_RE_SYNTAX_UNIX           0x000
   #define VSSEARCHDEFAULTFLAG_RE_SYNTAX_MICROEDGE      0x800
   #define VSSEARCHDEFAULTFLAG_RE_SYNTAX_BRIEF          0x1000
   #define VSSEARCHDEFAULTFLAGC_RE_SYNTAX_MASK         (0x000|0x800|0x1000)
#define VSOPTION_MAX_STACK_DUMP_LINE_LENGTH 37
#define VSOPTION_MAX_STACK_DUMP_ARGUMENT_NOFLINES 38
#define VSOPTION_NEXTWINDOWSTYLE                  39

#define VSOPTIONZ_PAST_EOF               1000

#define VSOPTIONZ_SPECIAL_CHAR_XLAT_TAB  1001
   #define VSSPECIALCHAR_EOLCH1  0
   #define VSSPECIALCHAR_EOLCH2  1
   #define VSSPECIALCHAR_TAB     2
   #define VSSPECIALCHAR_SPACE   3
   #define VSSPECIALCHAR_VIRTUALSPACE 4
   #define VSSPECIALCHAR_EOF     5

   #define VSSPECIALCHAR_MAX     20

#define VSOPTIONZ_APPLICATION_NAME       1002
/* #define VSOPTION_LINE_NUMBERS_LEN      3 */

int VSAPI vsLoadFiles(int wid,const char *pszCmdline);
int VSAPI vsGetText(int wid,int Nofbytes,long seekpos,char *pszBuf);
int VSAPI vsGetLine(int wid,char *pszBuf,int BufLen);
int VSAPI vsDeleteLine(int wid);
void VSAPI vsInsertLine(int wid,const char *pBuf,int BufLen=-1);
void VSAPI vsReplaceLine(int wid,const char *pBuf,int BufLen=-1);
void VSAPI vsMessage(const char *psz);
void VSAPI vsStickyMessage(const char *psz);
void VSAPI vsTop(int wid);
void VSAPI vsBottom(int wid);
int VSAPI vsDown(int wid,int Noflines);
int VSAPI vsUp(int wid,int Noflines);
int VSAPI vsActivateView(int view_id);
int VSAPI vsQLineLength(int wid,int IncludeNLChars);
int VSAPI vsAllocSelection(int AllocBookmark=0);
int VSAPI vsFreeSelection(int markid);

int VSAPI vsDeselect(int wid, int markid=-1);
int VSAPI vsSelectLine(int wid,int markid=-1,int SelectFlags=0);
int VSAPI vsSelectChar(int wid,int markid=-1,int SelectFlags=0);
int VSAPI vsSelectBlock(int wid,int markid=-1,int SelectFlags=0);
void VSAPI vsCopyToCursor(int wid,int markid=-1,int MustBeMinusOne=(-1));
// pszOptions--> Start an undo step/Record Macro Source/Do refresh/Async shell
// This default options are great for Menu Items and Tool bar
// buttons.  Don't use SMD options in the middle of a macro.
long VSAPI vsExecute(int wid,const char *pszCommand,const char *pszOptions="SMDA");


#define VSFONTLISTFLAG_SCREEN_FONTS  0x1
#define VSFONTLISTFLAG_PRINTER_FONTS 0x2
#define VSFONTLISTFLAG_FIXED_ONLY    0x4
#define VSFONTLISTFLAG_OUPUT_WIDTHxHEIGHT   0x8
// List font names or font sizes (pszFontName!=0)
int VSAPI vsFontList(void (VSAPI *pfnCallback)(const char *psz),int flags=VSFONTLISTFLAG_SCREEN_FONTS,const char *pszFontName=0);
int VSAPI vsFontIsScalable(int flags,const char *pszFontName,void *reserved=0);
#define VSFONTTYPE_RASTER    0x001
#define VSFONTTYPE_DEVICE    0x002
#define VSFONTTYPE_TRUETYPE  0x004   // Windows only
#define VSFONTTYPE_FIXED     0x008   // Fixed pitch font
#define VSFONTTYPE_OUTLINE   0x100
#define VSFONTTYPE_KERNING   0x200   // OS/2 only
int VSAPI vsFontQType(int flags,const char *pszFontName,void *reserved=0);
int VSAPI vsFontQDefaultCharSet(int flags,const char *pszFontName,const char *pszFontSize);

// Some new exported VSAPI calls in 4.0

int VSAPI vsQIntVar(VSPSZ pszVarName,int DefaultValue);
int VSAPI vsMDIReorder(int wid,int NextWid,int reserved=0);

int VSAPI vsQvcadd_enabled(int editorctl_wid);
int VSAPI vsQvccheckin_enabled(int editorctl_wid);
int VSAPI vsQvccheckout_enabled(int editorctl_wid);
int VSAPI vsQvcdiff_enabled(int editorctl_wid);
int VSAPI vsQvcget_enabled(int editorctl_wid);
int VSAPI vsQvchistory_enabled(int editorctl_wid);
int VSAPI vsQvclock_enabled(int editorctl_wid);
int VSAPI vsQvcmanager_enabled(int editorctl_wid);
int VSAPI vsQvcproperties_enabled(int editorctl_wid);
int VSAPI vsQvcremove_enabled(int editorctl_wid);
int VSAPI vsQvcunlock_enabled(int editorctl_wid);

#define VSTBREFRESHBY_READ_ONLY                  1
#define VSTBREFRESHBY_UNDO                       2
#define VSTBREFRESHBY_REDO                       3
#define VSTBREFRESHBY_SELECTION                  4
#define VSTBREFRESHBY_CREATEDESTROY_MDICHILD     5
#define VSTBREFRESHBY_MDICHILD_WINDOW_STATE      6
#define VSTBREFRESHBY_ADDREMOVE_BOOKMARK         7
#define VSTBREFRESHBY_STARTSTOP_MACRO_RECORDING  8

#define VSTBREFRESHBY_PROJECT                    9
#define VSTBREFRESHBY_INTERNAL_CLIPBOARDS        10
#define VSTBREFRESHBY_SWITCHBUF                  11
#define VSTBREFRESHBY_APPLICATION_GOT_FOCUS      12

// Start your own values here or just use this one
#define VSTBREFRESHBY_USER                       1000

int VSAPI vstbQRefreshBy();
void VSAPI vstbSetRefreshBy(int tbRefreshBy);

/*
   Specify the VSBMFLAG_SHOWNAME if you want the bookmark
   name displayed at the left edge of the edit window.  Note
   that the user can select not to show any bookmark names
   on the left edge.
*/
#define VSBMFLAG_SHOWNAME     0x1
/*
   VSBMFLAG_STANDARD has the following effects:
     * bookmark is diplayed in bookmark list
     * next_bookmark and prev_bookmark will traverse this bookmark.
*/
#define VSBMFLAG_STANDARD     0x2

/*
   This flag is used by the push_bookmark command.  PUSHED bookmarks
   are mainly useful for tagging where the bookmarks are very temporary.
   By convention, PUSHED bookmarks do not appear on the left edge
   or in the bookmarks dialog and are ignored by all commands excepted
   the pop_bookmark command.  Don't specify the VSBMFLAG_SHOWNAME or
   VSBMFLAG_STANDARD flags when using this flag.

   In case you were wondering, tag boookmarks are named to simplify
   save and restoring bookmarks.
*/
#define VSBMFLAG_PUSHED       0x4

void VSAPI vsBookmarkRestore(int wid,int vsbmflags=-1);
void VSAPI vsBookmarkRemove(int i,int free_markid=1);
void VSAPI vsBookmarkAdd(const char *pszBookmarkName,
                         int markid,
                         int vsbmflags=VSBMFLAG_SHOWNAME|VSBMFLAG_STANDARD,
                         int RealLineNumber=-1,
                         int col=0,
                         long BeginLineROffset=0,
                         char *pszLineData=0,
                         char *pszFilename=0,
                         char *pszDocumentName=0
                         );
int VSAPI vsBookmarkGetInfo(int i,
                            char *pszBookmarkName=0,   // VSMAXBOOKMARKNAME
                            int *pmarkid=0,
                            int *pvsbmflags=0,
                            int *pbuf_id=0,
                            int determineLineNumber=1,
                            int *pRealLineNumber=0,
                            int *pCol=0,
                            long *pBeginLineROffset=0,
                            char *pszLineData=0,   //VSMAXBOOKMARKLINEDATA
                            char *pszFilename=0,     //VSMAXFILENAME
                            char *pszDocumentName=0 //VSMAXDOCUMENTNAME
                            );
int VSAPI vsBookmarkFind(const char *pszBookmarkName,int vsbmflags=VSBMFLAG_STANDARD);
int VSAPI vsBookmarkQCount();

int vsQReadOnly(int wid);
void VSAPI vsPostCall(int index,char *pBuf,int BufLen=-1);
int VSAPI vsUndo(int wid, char option /* URSC*/);
void VSAPI vsDragDropInit();
void VSAPI vsShowCursor(int wid,int onoff);
// Some new exported VSAPI calls in 3.0

void VSAPI vsResetModifiedLineFlags(int wid,int Reserved=0);
void VSAPI vsExit(int status);
/*
   vsGetMessage returns the message corresponding the error code
   rc. Error codes are listed in rc.h.
*/
char *VSAPI vsGetMessage(int rc,char *pszMessage,int MaxMsgLen,int *pMaxMsgLen=0);
/*
   vsGetMessageLine returns what is currently being displayed
   on the message line (or message area).
*/
char *VSAPI vsGetMessageLine(char *pszMessage,int MaxMessageLen,int *pMaxMessageLen=0);
int VSAPI vsUpdatePicture(const char *pszFilename,int reserved=0);
void VSAPI vsBufCreateTempView(int buf_id,int *pTempViewId,int *pOrigViewId);
void VSAPI vsBufDeleteTempView(int TempViewId,int OrigViewId);
char * VSAPI vsBufGetDocumentName(int buf_id,char *pszDocumentName,int MaxDocumentName,int *pMaxDocumentNameLen,int defaultToBufferName=1);
char * VSAPI vsBufGetName(int buf_id,char *pszBufName,int MaxBufName,int *pMaxBufNameLen=0);
#define VSNBFLAG_FIND_HIDDEN  0x1
#define VSNBFLAG_NO_UPDATE_BUFFER_VIEW  0x2
#define VSNBFLAG_NO_REFRESH  0x4

void VSAPI vsNextBuffer(int wid,int nbflags);
void VSAPI vsPrevBuffer(int wid,int nbflags);

#define VSPRINTFLAG_LEFT_HEADER     0
#define VSPRINTFLAG_RIGHT_HEADER    1
#define VSPRINTFLAG_CENTER_HEADER   2
#define VSPRINTFLAG_LEFT_FOOTER     (0<<2)
#define VSPRINTFLAG_RIGHT_FOOTER    (1<<2)
#define VSPRINTFLAG_CENTER_FOOTER   (2<<2)
#define VSPRINTFLAG_TWO_UP          0x10  /* Two columns */
#define VSPRINTFLAG_COLOR           0x20  /* Print color i.e. red green */
#define VSPRINTFLAG_FONTATTRS       0x40  /* Print color coding i.e. bold, italics, etc.*/

struct VSPRINTCONFIG {
   char szFontName[256];
   int FontSizeX10;         // Pointer size x 10
   int FontFlags;           // VSFONTFLAG_???
   int FontCharSet;         // VSCHARSET_???
   /*
     WARNING: If you set header/footer strings below, make sure you set
     bits 0..3 of the PrintFlags to 0.

         PrintFlags=PrintFlags & ~0xF;

   */
   char szLeftHeader[256];
   char szLeftFooter[256];
   char szCenterHeader[256];
   char szCenterFooter[256];
   char szRightHeader[256];
   char szRightFooter[256];
   // tw stands for twips.  1024 twips is one inch on the printed paper
   int twLeftMargin;   // Left margin between outer edge of paper and printed text
   int twRightMargin;  // Right margin between outer edge of paper and printed text
   int twTopMargin;    // Top margin between outer edge of paper and printed text
   int twBottomMargin; // Bottom margin between outer edge of paper and printed text
   int twAfterHeader;  // This is the space in twips between the header and the first line on the page.
   int twBeforeFooter; // This is the space in twips between the last line on a page and the footer.
   int twSpaceBetween; // This text specifies the width in pixels between columns.
   int PrintFlags;     // VSPRINTFLAGS_???
   int LinenumsEvery;  // Print line numbers every NNN lines.  0 for no line numbers.
};
void VSAPI vsPrintGetConfig(VSPRINTCONFIG *pconfig,int version=0);
void VSAPI vsPrintSetConfig(const VSPRINTCONFIG *pconfig,int version=0);

struct VSEXTENSIONOPTIONS {
   char szRefersToExtension[VSMAXEXTENSION];
   char szLexerName[VSMAXLEXERNAME];
#define VSCOLORFLAG_LANGUAGE    0x1
#define VSCOLORFLAG_MODIFY      0x2
#define VSCOLORFLAG_CURRENT_LINE  0x4
   int ColorFlags;
   int LeftMargin;     // 1..
   int RightMargin;    // 1..
   int NewParagraphMargin; // 1..
   int WordWrapStyle;  // see VSWWS_??? flags
   int IndentWithTabs;  // Boolean
   int DisplayLineNumbers;  // Boolean
   int SyntaxExpansion;  // Boolean.  Ignored for fundamental extension
   // We allocated static data for this
   // which you may copy but you may not free
   char *pszTabs;  // String of tab stops
   char szModeName[VSMAXMODENAME];
   char szBeginEndPairs[VSMAXBEGINENDPAIRS];
   char szAliasFilename[VSMAXFILENAME];
   char szEventTableName[VSMAXNAME];
   char szWordChars[VSMAXWORDCHARS];
   int IndentStyle; // see VSINDENTSTYLE_???
   int SyntaxIndent;  // Number of characters to indent.   Ignored for fundamental extension
};
void VSAPI vsUpdateExistingBufferExtensionOptions(const char *pszExtension,const char *pszReserved=0,int reserved=0);
void VSAPI vsSetDefaultExtensionReferTo(const char *pszExtension,const char *pszReferTo);
void VSAPI vsSetDefaultExtensionOptions(const char *pszExtension,const VSEXTENSIONOPTIONS *pExtensionOptions,int reserved=0,int version=0);
int VSAPI vsGetDefaultExtensionOptions(const char *pszExtension,VSEXTENSIONOPTIONS *pExtensionOptions,int version=0);
void VSAPI vsDeleteExtensionOptions(const char *pszExtension);

#define VSCHARSET_ANSI  0
#define VSCHARSET_DEFAULT 1

#define VSCHARSET_SYMBOL          2
#define VSCHARSET_SHIFTJIS        128
#define VSCHARSET_HANGEUL         129
#define VSCHARSET_GB2312          134
#define VSCHARSET_CHINESEBIG5     136
#define VSCHARSET_OEM             255
//WINVER >= 0x0400)
#define VSCHARSET_JOHAB           130
#define VSCHARSET_HEBREW          177
#define VSCHARSET_ARABIC          178
#define VSCHARSET_GREEK           161
#define VSCHARSET_TURKISH         162
#define VSCHARSET_THAI            222
#define VSCHARSET_EASTEUROPE      238
#define VSCHARSET_RUSSIAN         204

#define VSCHARSET_MAC             77
#define VSCHARSET_BALTIC          186



int VSAPI vsGetDefaultFont(int field,char *pszFontName,int MaxFontName,
                           int *pFontSizex10,
                           int *pFontFlags,int *pCharSet=0);
int VSAPI vsSetDefaultFont(int field,char *pszFontName,
                           int FontSizex10,int FontFlags,int CharSet=VSCHARSET_DEFAULT);
int VSAPI vsMenuQInfo(int menu_handle,char option='C');
int VSAPI vsMenuDelete(int menu_handle,int position);
int VSAPI vsMenuDestroy(int menu_handle);
int VSAPI vsMenuFind(int menu_handle,const char *pszCommand,int *pmenu_handle,int *pposition,char by_category);
int VSAPI vsMenuGetState(int menu_handle,char *pszFindCommand,
                         int *pflags,char by_category,
                         char *pszItemText=0,
                         int MaxItemTextLen=0,
                         char *pszCommand=0,
                         int MaxCommandLen=0,
                         char *pszCategory=0,
                         int MaxCategoryLen=0,
                         char *pszHelpCommand=0,
                         int MaxHelpCommandLen=0,
                         char *pszHelpString=0,
                         int MaxHelpStringLen=0,
                         int *pMaxItemTextLen=0,
                         int *pMaxCommandLen=0,
                         int *pMaxCategoryLen=0,
                         int *pMaxHelpCommandLen=0,
                         int *pMaxHelpStringLen=0
                         );
int VSAPI vsMenuInsert(int menu_handle,int position,int flags,
                       const char *pszItemText,const char *pszCommand,
                       const char *pszCategory,
                       const char *pszHelpCommand,
                       const char *pszHelpString);
int VSAPI vsMenuLoad(int wid,int index,char menu_option);
int VSAPI vsMenuSet(int wid,int menu_handle);
int VSAPI vsMenuSetState(int menu_handle,const char *pszFindCommand,
                         int flags,char by_category,
                         const char *pszItemText=0,
                         const char *pszCommand=0,const char *pszCategory=0,
                         const char *pszHelpCommand=0,const char *pszHelpString=0);
#define VSMF_CHECKED         1
#define VSMF_UNCHECKED       2
#define VSMF_GRAYED          4
#define VSMF_ENABLED         8
#define VSMF_SUBMENU         16

#define VSVPM_LEFTBUTTON   0x0000
#define VSVPM_RIGHTBUTTON  0x0002
#define VSVPM_LEFTALIGN    0x0000
#define VSVPM_CENTERALIGN  0x0004
#define VSVPM_RIGHTALIGN   0x0008
int VSAPI vsMenuShow(int wid,int menu_handle,int vpm_flags,int x,int y);

void VSAPI vsDeleteAll(int wid);
void VSAPI vsSavePos2(int wid,int *pmarkid);
void VSAPI vsRestorePos2(int wid,int markid);
void VSAPI vsRestorePos(int wid,const VSSAVEPOS *pbuf);
void VSAPI vsSavePos(int wid,VSSAVEPOS *pbuf,int reserved=0);
int VSAPI vsCommandReplace(int wid,const char *pszFindString,const char *pszReplaceString,const char *pszOptions="");
int VSAPI vsCommandFind(int wid,const char *pszFindString,const char *pszOptions="");
int VSAPI vsCommandSave(int wid,const char *pszOutputFilename=0, const char *pszOptions=0);
void VSAPI vsCommandName(int wid,const char *pszFilename);
void VSAPI vsSelectEditMode(int wid,const char *pszExt=0,int reserved=0);
int VSAPI vsQLastIndex(char option  /* K W C P */);
void VSAPI vsSetLastIndex(char option  /* K W C P */,int index);
int VSAPI vsQPrevIndex(char option  /* C P */);
void VSAPI vsSetPrevIndex(char option  /* C P */,int index);
int VSAPI vsQLastEvent(int NewLastEvent=VS_NULL_KEY,int version=0);
int VSAPI vsMouQLastX(int wid=0,char option='D');
int VSAPI vsMouQLastY(int wid=0,char option='D');
int VSAPI vsCurWord(int wid,char *pszWord,int MaxWordLen,
              int *pPhyiscalStartCol=0,
              int option=0 /* 1 from cursor, 2- end prev word*/,
              int *pMaxWordLen=0);
int VSAPI vsMouCurWord(int wid,int x,int y,
                 int XYAreInScreenCoordinates,
                 int MaybeReturnSelectedText,
                 char *pszWord,int MaxWordLen,
                 int *pPhyiscalStartCol=0,
                 int option=0 /* 1 from cursor, 2- end prev word*/,
                 int *pMaxWordLen=0);
int VSAPI vsNameInfoArg2(int index);
int VSAPI vsCreateTempView(int *pTempViewId,int *pOrigViewId=0,const char *pszReserved=0);
void VSAPI vsDeleteTempView(int TempViewId,int doDeleteBuffer=1);
int VSAPI vsOpenTempView(const char *pszFilename,int *pTempViewId,int *pOrigViewId=0,const char *pszLoadOption=0,const char *pszReserved=0);

int VSAPI vsQDefaultEventTab();
  #define VSMB_ICONMASK         0x000000F0
  #define VSMB_MODEMASK         0x00003000

  #define VSMB_OK               0x00000000
  #define VSMB_OKCANCEL         0x00000001
  #define VSMB_ABORTRETRYIGNORE 0x00000002   /* Not supported on UNIX*/
  #define VSMB_YESNOCANCEL      0x00000003
  #define VSMB_YESNO            0x00000004
  #define VSMB_RETRYCANCEL      0x00000005   /* Not supported on UNIX*/
  #define VSMB_ICONHAND         0x00000010
  #define VSMB_ICONQUESTION     0x00000020
  #define VSMB_ICONEXCLAMATION  0x00000030
  #define VSMB_ICONINFORMATION  0x00000040
  #define VSMB_ICONSTOP         VSMB_ICONHAND
  #define VSMB_ICONNONE         VSMB_ICONMASK
  #define VSMB_DEFBUTTON1       0x00000000
  #define VSMB_DEFBUTTON2       0x00000100
  #define VSMB_DEFBUTTON3       0x00000200

  // VSMB_APPLMODAL is assumed if VSMB_SYSTEMMODAL is not given.
  #define VSMB_SYSTEMMODAL      0x00001000  /* Not supported on UNIX or OS/2 */
  #define VSMB_APPLMODAL        0x00002000  /* Windows TASKMODAL */

  #define VSIDOK     1
  #define VSIDCANCEL 2
  #define VSIDABORT  3
  #define VSIDRETRY  4
  #define VSIDIGNORE 5
  #define VSIDYES    6
  #define VSIDNO     7

int VSAPI vsMessageBox(const char *pszMessage,const char *pszTitle=0,int vsmb_flags=VSMB_OK);
int VSAPI vsQhide_all_comments_enabled(int wid);
int VSAPI vsQhide_code_block_enabled(int wid);
int VSAPI vsQTaggingSupported(int wid);

int VSAPI vsQMFNextOccurrenceEnabled(int reserved=1);
int VSAPI vsQNextOccurrenceEnabled();
int VSAPI vsQmflast_enabled();
int VSAPI vsConcurProcessQRunning();
int VSAPI vsConcurProcessQReadRunning();
int VSAPI vsConcurProcessQCol(int wid);
int VSAPI vsConcurProcessIsThisBuffer(int wid);
int VSAPI vsClipboardQNofInternal(void);
char * VSAPI vsGetProjectName(char *pszFilename,int MaxFilenameLen,int *pMaxFilenameLen=0);
char * VSAPI vsGetEmulation(char *pszResult,int MaxResult,int *pMaxResultLen=0);
void VSAPI vsguiUpdateStatusFont();

void VSAPI vsMacroStartRecording(int wid);
void VSAPI vsMacroEndRecording();
int VSAPI  vsMacroQRecording();
int VSAPI  vsMacroQRunning();
void VSAPI vsMacroSetRunning(int value);
int VSAPI  vsMacroQRecordSource();
void VSAPI vsMacroSetRecordSource(int value);
int VSAPI vsMacroQDefining();
int VSAPI vsMacroQDefined();
char *VSAPI vsMacroGetFilename(char *pszFilename,int MaxFilenameLen,int *pMaxFilenameLen=0);

void VSAPI vsResetIdle(int reserved=-1);
long VSAPI vsQIdle();

#define VSEDITORNAME_INVOCATION_NAME          1
#define VSEDITORNAME_EXE_PATH                 2
#define VSEDITORNAME_STATE_FILENAME           3
#define VSEDITORNAME_AUTORESTORE_FILENAME     4
#define VSEDITORNAME_DDE_SERVER_NAME          5
#define VSEDITORNAME_APPLICATION_NAME         6
char *VSAPI vsGetEditorName(int option,char *pszName,int MaxNameLen,int *pMaxNameLen=0);

int VSAPI vsQTextWidth(int wid,const char *pText,int TextLen);
#define VSBUFMATCH_HIDDEN  0x1
#define VSBUFMATCH_EXACT   0x2
#define VSBUFMATCH_VERBOSE   0x4  /* Used by Slick-C only */
#define VSBUFMATCH_EXACT2  0x8    /* Used by Slick-C only, same as VSBUFMATCH_EXACT */
#define VSBUFMATCH_BUFNAMEONLY 0x10
#define VSBUFMATCH_DOCUMENTNAMEONLY 0x20
struct VSBUFMATCHINFO {
   int BufID;
   int ModifyFlags;
   int ReadOnly;
   int BufFlags;
   //char szBufName[1024];
   char szBufName[512];
   char szDocumentName[512];
   char szModeName[128];
};

int VSAPI vsBufMatch(const char *pszBufName, int *pIndex=0, int BufMatchFlags=0,
                     VSBUFMATCHINFO *pBufMatchInfo=0,int Reserved=0);

int VSAPI vsColWidthGet(int wid,int i,int *pwidth);
int VSAPI vsColWidthSet(int wid,int i,int width);
int VSAPI vsColWidthClear(int wid);

#define VSTREE_ADD_BEFORE     0x1 /* Add a node before sibling in order */
#define VSTREE_ADD_AS_CHILD   0x2
//These sort flags cannot be used in combination with each other
#define VSTREE_ADD_SORTED_CS       0x4
#define VSTREE_ADD_SORTED_CI       0x8
#define VSTREE_ADD_SORTED_FILENAME 0x10

#define VSTREENODE_HIDDEN  0x1


#define VSLTF_OUTPUT_LINE_NUMBERS   0x0001   // output only line numbers
#define VSLTF_PROCS                 0x0002   // List proctree (def_proctree_flags) only
#define VSLTF_TREE_OUTPUT           0x0004   // Output to a tree control
#define VSLTF_TREE_OUTPUT_HIDDEN    0x0008   // Output to tree control hidden
#define VSLTF_LIST_OUTPUT           0x0010   // Output to list control
#define VSLTF_SKIP_OUT_OF_SCOPE     0x0020   // Skip locals that are out of scope
#define VSLTF_SET_TAG_CONTEXT       0x0040   // Set tagging context at cursor position

int VSAPI vsTreeSetUserInfo(int wid,int iHandle,VSHVAR hvar);
void VSAPI vsRecycleObjects(int onoff);
int VSAPI vsTreeAddItem(int wid,int  iRelativeIndex,const char *pszCaption,int  iFlags,
                        int  iCollapsedBMIndex,int  iExpandedBMIndex,
                        int  iState,int iNodeFlags=0);
int VSAPI vsHaveClipboard();
int VSAPI vsQUndoStatus(int wid,char undo_option='U' /* U or R*/);
int VSAPI vsHaveSelection(int wid,int reserved=0);
int VSAPI vsEndSelectCompare(int wid,int markid=-1);
int VSAPI vsBeginSelectCompare(int wid,int markid=-1);
int VSAPI vsGetSelectedText(int wid,char *pszBuf,int BufLen,int markid=-1,int flags=-1,const char *pEOLChars=0,int EOLCharsLen=-1);
int VSAPI vsQSelectedTextLength(int wid,int markid=-1,int flags=-1,const char *pEOLChars=0,int EOLCharsLen=-1);
int VSAPI vsBeginSelect(int wid,int markid=-1,int LockSelection=1);
int VSAPI vsEndSelect(int wid,int markid=-1,int LockSelection=1);
int VSAPI vsGetSelInfo(int wid,int markid,int *pfirstcol,int *plastcol=0,int *pbuf_id=0,char *pszBufName=0,int MaxBufName=0,int *pMaxBufNameLen=0);
int VSAPI vsBufEdit(const char *pszFilename,const char * pszLoadOptions="",int IgnoreNotFound=1,const char * pszLoadOptions2="",int quiet=0);

enum VSCALLBACK {
   VSCALLBACK_WIN_UPDATE_EDITOR_STATUS  // pfn is VSPFNUPDATEEDITORSTATUS
   ,VSCALLBACK_WIN_GOTFOCUS   //void (VSAPI *pfnGotFocus)(int wid);
   ,VSCALLBACK_WIN_LOSTFOCUS  //void (VSAPI *pfnLostFocus)(int wid);
   ,VSCALLBACK_WIN_CMDLINE_FUNCTIONS  // pfn is &VSCMDLINE_FUNCTIONS
   ,VSCALLBACK_WIN_MESSAGE    // void (VSAPI *pfnMessage)(int wid,const char *pszMsg,int Immediate);
   ,VSCALLBACK_WIN_GET_MESSAGE  // void (VSAPI *pfnGetMessage)(int wid,char *pszMsg,int MaxStringLen);
   ,VSCALLBACK_APP_QUERY_END_SESSION // int (VSAPI *pfnQueryEndSession)();
   ,VSCALLBACK_APP_MENU_ADD_FILE_HISTORY // void (VSAPI *pfnMenuAddFileHistory)(const char *pszFilename);
   ,VSCALLBACK_APP_MENU_ADD_PROJECT_HISTORY // void (VSAPI *pfnMenuAddProjectHistory)(const char *pszFilename);
   ,VSCALLBACK_APP_POPUP_MENU // void (VSAPI *pfnPopupMenu)(const char *pszMenuName,int menu_handle);
   ,VSCALLBACK_APP_ADD_BUFFER // void (VSAPI *pfnAddBuffer)(int buf_id,const char *pszBufName,int buf_flags);
   ,VSCALLBACK_APP_RENAME_BUFFER // void (VSAPI *pfnRenameBuffer)(int buf_id,const char *pszOldBufName,const char *pszNewBufName,int buf_flags);
   ,VSCALLBACK_BUF_QNOFDEBUGBITMAPS   // int (VSAPI *pfnQNofDebugBitmaps)(int buf_id);
   ,VSCALLBACK_BUF_QDEBUGBITMAP    // int (VSAPI *pfnQDebugBitmap)(int buf_id,int RealLineNum,int OldLineNum,int wid);
// int (VSAPI *pfnSetLineColor)(int buf_id,int wid, int linenum,int LineFlags,
//       VSCOLORINDEX *pColor,int ColorLen,char *pTempLine,int reserved);
   ,VSCALLBACK_BUF_SET_LINE_COLOR
// void (VSAPI *pfnSetLineColorDiff)(int buf_id,int linenum,VSCOLORINDEX *pColor,int ColorLen);
   ,VSCALLBACK_BUF_SET_LINE_COLOR_DIFF
// void (VSAPI *pfnSetLineColorAfterDiff)(int buf_id,int linenum,VSCOLORINDEX *pColor,int ColorLen);
   ,VSCALLBACK_BUF_SET_LINE_COLOR_DIFF_AFTER
   ,VSCALLBACK_APP_READ_ONLY_ERROR   // void (VSAPI *pfnReadOnlyError)(int KeyPressed);
   ,VSCALLBACK_APP_KEY_OR_MOUSE_EVENT_READ   // void (VSAPI *pfnKeyOrMouseEventRead)(int event);
   ,VSCALLBACK_APP_BPMQ_DEFAULT_BITMAP     // int (VSAPI *pfnQDefaultBitmap)(int wid,int RealLineNum,int OldLineNum,int reserved);
   ,VSCALLBACK_APP_MESSAGEBOX  // int (VSAPI *pfnMessageBox)(const char *pszMessage,const char *pszTitle,int vsmb_flags);
   ,VSCALLBACK_APP_DEBUG_BITMAP_CLICK // int (VSAPI *pfnDebugBitmapClick)(int wid,int flags,int NofClicks);
};
void VSAPI vsCallbackSet(int id,VSCALLBACK vscallback,void *pfn);
/*
   vsCallbackActivate forces immediate update of
   callbacks for the following:

     VSCALLBACK_WIN_CMDLINE_FUNCTIONS
     VSCALLBACK_WIN_MESSAGE
     VSCALLBACK_WIN_GET_MESSAGE

   VSE's implementation of the above editor control callbacks
   require global callback data.  vsExecute updates the
   global callback data.  However if you use vsCallIndex
   you might want to activate the callbacks.
*/
void VSAPI vsCallbackActivate(int wid);
enum VSCALLBACK_AR {
   VSCALLBACK_AR_BUF_LINES_INSERTED   // void (VSAPI *pfnInsertLine)(int buf_id,int AfterLineNum,int Noflines)
   ,VSCALLBACK_AR_BUF_LINES_DELETED   // void (VSAPI *pfnDeleteLine)(int buf_id,int FirstLinenum,int Noflines)
   ,VSCALLBACK_AR_APP_DELETE_BUFFER // void (VSAPI *pfnDeleteBuffer)(int buf_id);
   ,VSCALLBACK_AR_BUF_TEXT_CHANGE // void (VSAPI *pfnTextChange)(int buf_id,int wid, long StartMod,long EndMod);
   ,VSCALLBACK_AR_APP_SELECT_MODE // void (VSAPI *pfnSelectMode)(int buf_id,int wid,const char *pszExtension);
};

int VSAPI vsCallbackAdd(int id,
                         VSCALLBACK_AR vscallback,
                         void *pfn,
                         int reserved1=0,
                         int reserved2=0);
int VSAPI vsCallbackRemove(int id,VSCALLBACK_AR vscallback,void *pfn);


void VSAPI vsWinSetData(int wid,void *pdata);
void *VSAPI vsWinQData(int wid);

void VSAPI vsBufSetData(int buf_id,void *pdata);
void *VSAPI vsBufQData(int buf_id);
#define VSCOLORINDEX unsigned char

VSCOLORINDEX VSAPI vsAllocColor(int wid);
void VSAPI vsFreeColor(int wid,VSCOLORINDEX ColorIndex);
void VSAPI vsSetTextColor(int wid,VSCOLORINDEX *pColor,int ColorLen);
void VSAPI vsGetTextColor(int wid,VSCOLORINDEX *pColor,int ColorLen);


int VSAPI vsIsWindowValid(int wid);
int VSAPI vsLastWindowID();
void VSAPI vsMoveWindow(int wid,int x,int y,int width,int height,char state=0,int reserved=1);

#define VSCFG_SELECTION          1
#define VSCFG_WINDOW_TEXT        2
#define VSCFG_CLINE              3
#define VSCFG_SELECTED_CLINE     4
#define VSCFG_MESSAGE            5
#define VSCFG_STATUS             6
#define VSCFG_CMDLINE            7
#define VSCFG_CURSOR             8
//VSCFG_CMDLINE_SELECT   = 9
//VSCFG_LIST_BOX_SELECT  = 10
//VSCFG_LIST_BOX         = 11
//VSCFG_ERROR
#define VSCFG_MODIFIED_LINE       13
#define VSCFG_INSERTED_LINE       14
/* color not yet configurable for VSCFG_FUNCTION_HELP*/
#define VSCFG_FUNCTION_HELP       15
//G_INSERTED_LINE      =16
#define VSCFG_KEYWORD             17
#define VSCFG_LINENUM             18
#define VSCFG_NUMBER              19
#define VSCFG_STRING              20
#define VSCFG_COMMENT             21
#define VSCFG_PPKEYWORD           22
#define VSCFG_SYMBOL1             23
#define VSCFG_SYMBOL2             24
#define VSCFG_SYMBOL3             25
#define VSCFG_SYMBOL4             26
#define VSCFG_IMAGINARY_LINE      27
#define VSCFG_NOSAVE_LINE         27
#define VSCFG_FUNCTION            28
#define VSCFG_FILENAME            30
#define VSCFG_HILIGHT             31
#define VSCFG_ATTRIBUTE           32

#define  VSFONTFLAG_BOLD    0x1
#define  VSFONTFLAG_ITALIC  0x2
#define  VSFONTFLAG_STRIKE_THRU 0x4
#define  VSFONTFLAG_UNDERLINE   0x8
#define  VSFONTFLAG_PRINTER     0x200

int VSAPI vsSetDefaultColor(int cfgfield,int FGColor,int SetFGColor,
                             int BGColor=0,int SetBGColor=0,
                             int FontFlag=0,int SetFontFlag=0);
int VSAPI vsGetDefaultColor(int cfgfield,int *pFGColor,int *pBGColor,
                             int *pFontFlag);
int VSAPI vsQueryEndSession();
char *VSAPI vsGetDefaultOptionZ(int option,char *pszResult,int MaxResult,int *pMaxResultLen=0);
int VSAPI vsSetDefaultOptionZ(int option,const char *pszResult);
int VSAPI vsQDefaultOption(int option);
int VSAPI vsSetDefaultOption(int option,int value);

void VSAPI vsBufName2Caption(int wid,char *pszCaption,int MaxCaptionLen,char state,int *pMaxCaptionLen=0);
void VSAPI vsSetFocus(int wid);
void VSAPI vsSetFocus2(int wid);

// IF GUI header files have been included
#if defined(VSAPI_H) || defined(SYSAPI_H)
   #if VSUNIX
      #define VSSYSHWND void *
   #else
      #define VSSYSHWND HWND
   #endif
   // Create an mdi instance and set VSP_HWNDFRAME and VSP_HWND properties
   // Currently we only support one MDI frame.
   int VSAPI vsRegisterWindow(VSSYSHWND hwndframe,VSSYSHWND hwndclient,int oi=VSOI_FORM);
   void VSAPI vsUnregisterWindow(int wid);
   void VSAPI vsMDIRegisterStatusWindow(int mdi_wid,VSSYSHWND hwndframe,VSSYSHWND hwnd);
   int VSAPI vsMDICreate(VSSYSHWND hwndframe,VSSYSHWND hwnd,VSSYSHWND reserved);
#define  VSBDS_NONE   0
#define  VSBDS_FIXED_SINGLE  1
   int VSAPI vsCreateEditorCtl(int wid,VSSYSHWND hwndparent,int x,int y,int width,int height,
                               int BorderStyle=VSBDS_FIXED_SINGLE,
                               int visible=1,
                               int buf_id=-1,void *pdata=0,int mdi_wid=0,int reserved1=0,long reserved2=0);
   void VSAPI vsDestroyEditorCtl(int wid,long reserved=0);

   #if VSUNIX
      int VSAPI vsXDispatchXEvent(XEvent * pevent);
      void VSAPI vsXRegisterKeysToIgnore(unsigned int startKey,unsigned int endKey
                                         ,unsigned int shift
                                         ,unsigned int control, unsigned int alt);
      void VSAPI vsXRegisterX11Dispatcher(int (*xdispatcher)(XEvent * event));
      void VSAPI vsXIdleProcessing();
      void VSAPI vsKillFocus(int wid);
   #endif

#endif

#if WIN32
   void VSAPI vsDropFiles(unsigned int wparam);
#elif defined(OS2386APP)
   void VSAPI vsDropFiles(void *wparam);
#else
   #define vsDropFiles(a)
#endif
#define VSBBSIDE_LEFT    1
#define VSBBSIDE_TOP     2
#define VSBBSIDE_RIGHT   3
#define VSBBSIDE_BOTTOM  4
int VSAPI vsQButtonBar(int wid,int bbside);
void VSAPI vsMDISetActiveChild(int wid);
int VSAPI vsSetFocusToModalDialog();
void VSAPI vsGetServerName(char *pszServerName,int MaxServerNameLen,int *pMaxServerNameLen=0);


struct VSCMDLINE_FUNCTIONS {
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          Forces the command line paint messages to update
   */
   void (VSAPI *pfnCmdLineUpdateWindow)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          Sets focus to the command line.
   */
   void (VSAPI *pfnCmdLineSetFocus)(int wid,int Reserved);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       RETURN
          Returns editor control window handle.  This function
          is clearly needed when the "wid" parameter is 0.
          We also call this function when "wid" is not 0 in
          which case you should just return "wid".
   */
   int (VSAPI *pfnCmdLineQEditorCtl)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          Moves the cursor one character to the left.
   */
   void (VSAPI *pfnCmdLineLeft)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          Moves the cursor one character to the right.
   */
   void (VSAPI *pfnCmdLineRight)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          (Like Backspace) Deletes the previous character.
   */
   void (VSAPI *pfnCmdLineRubout)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       REMARKS
          (Like the Del key) Deletes the character under the
          cursor.
   */
   void (VSAPI *pfnCmdLineDeleteChar)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          StartCol  Start column of selection. 1 specifies
                    first character.  Do nothing if
                    less than 1.
          EndCol    End column of selection. 1 specifies
                    first character.  Do nothing if
                    less than 1.

       REMARKS
          Sets the cursor and the selection.
          If StartCol==EndCol, just place the cursor.
          If EndCol<StartCol then the cursor is placed
          at the left of the selection.
   */
   void (VSAPI *pfnCmdLineSetSel)(int wid,int StartCol,int EndCol);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pStartCol  Set to start column of selection or
                     cursor position if their is no selection.
                     1 specifies first character.
          pEndCol    Set to End column of selection or
                     cursor position if their is no selection.
                     1 specifies first character.
   */
   void (VSAPI *pfnCmdLineGetSel)(int wid,int *pStartCol,int *pEndCol);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pPrompt   Prompt to be displayed before command line.
          PromptLen  Number of characters in prompt.

       REMARKS
          Sets the prompt displayed before the command line.
   */
   void (VSAPI *pfnCmdLineSetPrompt)(int wid,const char *pPrompt,int PromptLen);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pBuf      New text for command line.
          BufLen    Number of characters pBuf.

       REMARKS
          Sets the text displayed on the command line.
   */
   void (VSAPI *pfnCmdLineSetText)(int wid,const char *Buf,int BufLen);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pBuf      New text for command line.
          BufLen    Number of characters pBuf.

       REMARKS
          Inserts or replaces characters as if the user typed them from
          the keyboard.  This should replace the characters if
          currently in replace mode.
   */
   void (VSAPI *pfnCmdLineKeyin)(int wid,const char *pBuf,int BufLen);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pBuf        Set to command line text
          MaxBufLen   Number of characters allocated to pBuf.
          pMaxBufLen  If not 0, this is set to the number of
                      characters required by pBuf.

       REMARKS
          Retrieves the text on the command line.
   */
   void (VSAPI *pfnCmdLineGetText)(int wid,char *pBuf,int MaxBufLen,int *pMaxBufLen);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          pBuf        Set to command line prompt
          MaxBufLen   Number of characters allocated to pBuf.
          pMaxBufLen  If not 0, this is set to the number of
                      characters required by pBuf.

       REMARKS
          Retrieves the text on the command line prompt.
   */
   void (VSAPI *pfnCmdLineGetPrompt)(int wid,char *pBuf,int MaxBufLen,int *pMaxBufLen);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.

       RETURN
          Returns the current insert/replace mode state.
   */
   int (VSAPI *pfnCmdLineQInsertState)(int wid);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          OnOff     New instert/replace mode state.

       REMARKS
          Sets the insert/replace mode state.  When in
          replace mode characters of replaced as the
          user types.
   */
   void (VSAPI *pfnCmdLineSetInsertState)(int wid,int OnOff);
   /*

       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.  This may be 0.
                    You can use this to determine the command
                    line instance, if you have different
                    command lines for each editor control.
          visible   New visible state of command line.

       REMARKS
          Determines whether command line and prompt are visible.
   */
   void (VSAPI *pfnCmdLineSetVisible)(int wid,int visible);
   void (VSAPI *pfnjunk2)();
   void (VSAPI *pfnjunk3)();
   void (VSAPI *pfnjunk4)();
   void (VSAPI *pfnjunk5)();
   void (VSAPI *pfnjunk6)();
   void (VSAPI *pfnjunk7)();
   void (VSAPI *pfnjunk8)();
   void (VSAPI *pfnjunk9)();
   void (VSAPI *pfnjunk10)();
};

/*
    This version has nothing to do with the editor version.
*/
#define VSAPIVERSION  1
struct VSINIT {
/*****************Some Required fields********************************/
   /*
       Set this field to VSAPIVERSION.
   */
   int ApiVersion;
   /*
       Windows: (HINSTANCE) Application hinstance.
       OS/2:  (HAB) Initialized presentation manager handle.
       UNIX:  This is an X Display
   */
#if VSUNIX
   Display * hinstance;
#else
   long hinstance;
#endif

   /*
         Path to Visual SlickEdit binaries directory.  This path
         REQUIRES A TRAILING BACKSLASH.
   */
   const char *pszExecutablePath;
   /*
       OEM's should place all invocation options in the
       "Environment" section of the vslick.ini file in a variable
       called VSLICK.  For now, we recommend you set argc and
       argv to 0.  You can use other API's to do things like
       open a file and go to a line.

       MicroEdge uses (argc,argv) for historical reasons.

       Invocation arguments are concatenated as follows before they are
       processed.

          %VSLICK%" "argv[0]" "argv[1]" "argv[2]"...

       Double quotes are placed around argv[i] arguments which have
       spaces.
   */
   int argc;     // Number of null terminated strings in argv
   char **argv;  // Array of null terminated strings
   /*
         REMARKS:
              Specifies a directory to store configuration files.
              OEM's must always specify a configuration directory that
              does not conflict with the configuration directory
              MicroEdge uses for Visual SlickEdit customers.
              Visual SlickEdit will attempt to create this
              directory if it does not exist.

         OEM directory layout
            <OEMproduct>\vslick\win\    Visual SlickEdit binaries
            <OEMproduct>\vslick         Global configuration directory or
                                        single user configuration directory
            <OEMproduct>\vslick\bitmaps  Editor bitmaps
            <OEMproduct>\vslick\macros   Macro pcode and macro source

         Windows,OS/2:
           Single user with one configuration.

               Set this to <OEMproduct>\vslick

           Multiple users where each has their own configurations.


               Set this to <OEMproduct>\vslick\<UserName>

               If your product can not determine a unique user
               name, then require each user to specify a user
               configuration directory. You could have the user
               set an environment variable to a directory.  If
               you do this, make sure your environment variable
               name is unique and not VSLICKCONFIG which is
               used by our stand alone product.


         UNIX:

           Multiple users with multiple configurations.

               Build a directory based on the users HOME directory
               as follows:

                "$HOME/.vslick<OEMProduct>"


    MicroEdge always sets this value to null (only MicroEdge should
    do this) and constructs this directory as follows:

         Windows,OS/2:  The value of the VSLICKCONFIG environment variable
                        is used.  If the VSLICKCONFIG environment
                        variable does not exist, the configuration is
                        stored one directory level up from the editor
                        executable and in the editor executable directory.

         UNIX: If this is 0, the value of the VSLICKCONFIG environment
               variable is used.  If the VSLICKCONFIG environment
               variable does not exist, $HOME/.vslick is used.

   */
   const char *pszConfigDir;
   /*
        Default message box title.
   */
   const char *pszApplicationName;
   /*
       Various API flags indicating additional support you want.
   */

//Indicates that you want us to auto restore MDI Edit windows.
#define VSAPIFLAG_SAVERESTORE_EDIT_WINDOWS  0x1
/*
   Indicates you want to use our toolbars.  OEMs must turn
   this off.
*/
#define VSAPIFLAG_TOOLBAR_DOCKING           0x2
/*
   Indicates you want to use the default Visual SlickEdit
   menu bar.
*/
#define VSAPIFLAG_MDI_MENUS                 0x4
/*
   Indicates that you are using our MDI interface in addition
   to the editor control.
*/
#define VSAPIFLAG_MDI_WINDOW                0x8
/*
   Indicates that the command line color is configurable.

   For now flag is reserved for MicroEdge Inc.
*/
#define VSAPIFLAG_CONFIGURABLE_CMDLINE_COLOR     0x10
/*
   Indicates that the command line font is configurable.

   For now flag is reserved for MicroEdge Inc.
*/
#define VSAPIFLAG_CONFIGURABLE_CMDLINE_FONT      0x20
/*
   Indicates that the status line color is configurable.

   For now flag is reserved for MicroEdge Inc.
*/
#define VSAPIFLAG_CONFIGURABLE_STATUS_COLOR      0x40
/*
   Indicates that the status line font is configurable.

   For now flag is reserved for MicroEdge Inc.
*/
#define VSAPIFLAG_CONFIGURABLE_STATUS_FONT       0x80
/*
   Indicates that the "Alt Menu Hotkeys" menu item
   on the Gerneral Tab should be enabled.

   Don't use this flag unless your menu bar hot keys
   exactly match Visual SlickEdit or you make a custom
   version of "guisetup.e".  Note that Visual
   SlickEdit changes the hot keys when you change
   emulations.

   We do not feel that this option is important enough
   for you to support. A user can manually unbind keys
   for which he or she wants to activate the menu bar.
   This option has NO EFFECT on our default CUA emulation.
*/
#define VSAPIFLAG_CONFIGURABLE_ALT_MENU_HOTKEYS  0x100
/*
   Indicates that the "Alt Menu Hotkeys" menu item
   on the Gerneral Tab should be enabled.

   If your MDI application has not problems support
   next_buffer when our "One File per Window" option
   is off, then you should OR in this flag.
*/
#define VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW  0x200
/*
   Indicates that the "Visual C++ Setup..." menu item
   should be displayed on the configuration menu.

   Also tells VSE to put itself on the msdev toolbar or
   menu bar and perform other tighter integration
   operations.
*/
#define VSAPIFLAG_CONFIGURABLE_VCPP_SETUP           0x400
/*
   When this is on, all open file dialogs show
   extensions.

*/
#define VSAPIFLAG_OVERRIDE_EXPLORER_HIDE_EXTENSIONS 0x800
/*
   When this is on and a VSE dialog box is running, the
   user can edit via keyboard or windows system menu "edit form".

*/
#define VSAPIFLAG_ALLOW_DIALOG_EDITING              0x1000

/*
   Allow dialog boxes to show VSE projects.
     When off
       * The extension options dialog will disable the
         "Project..." button
       * The Check In and Check Out dialog boxes will disable
         the "Open Project..." and "Edit Project..." buttons.

*/
#define VSAPIFLAG_ALLOW_DIALOG_ACCESS_TO_PROJECTS   0x2000
/*
    Allow working directory to be restored.
*/
#define VSAPIFLAG_SAVERESTORE_CWD                   0x4000

/*
    goto_bookmark is implemented such that it can
    restore bookmarks to deleted editor controls which
    have a non-null VSP_BUFNAME
*/
#define VSAPIFLAG_GOTO_BOOKMARK_RESTORES_BY_FILENAME         0x8000
/*
    goto_bookmark is implemented such that it can
    restore bookmarks to deleted editor controls which
    have a non-null VSP_DOCUMENTNAME.
*/
#define VSAPIFLAG_GOTO_BOOKMARK_RESTORES_BY_DOCUMENTNAME     0x10000

   int APIFlags;
   int APIFlags2;  // Reserved for future use.
   void *Reserved[10];

/*****************Some optional fields********************************/
   /*
        Array of pointers to environment strings where the last pointer
        in the array is null (ppEnv[lastvalid+1]==NULL).

        Windows and OS/2 C++ runtimes.  Set this to _environ variable.

        UNIX C++ runtimes.  Set this to environ variable.
   */

   char **ppEnv;
   /*
        Function to display one line message.  This function must NOT
        create a new window like a message box would.

        PARAMETERS
           wid           This parameter is always 0 which indicates
                         that this function pointer
                         came from vsinit and does not have an
                         associated editor control.  This extra
                         parameter is here so that you can use
                         the same message callback function
                         for specific editor controls.
           pszMsg        Null terminated string to display.
           Immediate     Display message now instead of invalidating
                         the message area so a paint message is
                         received later.
                         UNIX: Be sure to call XFlush to flush display
                         output or a similar function.


   */
   void (VSAPI *pfnMessage)(int wid,const char *pszMsg,int Immediate);
   /*
       Function to retrieve message currently displayed.  During
       auto restore messages get displayed.  However, we restore
       the original message when auto save is done.

       PARAMETERS
          wid            This parameter is always 0 which indicates
                         that this function pointer
                         came from vsinit and does not have an
                         associated editor control.  This extra
                         parameter is here so that you can use
                         the same message callback function
                         for specific editor controls.
          pszMsg         If this is not null this is
                         set to null terminated string
                         containing message.  This can be 0.
          MaxMsgLen      Number of bytes allocated to pszMsg.  No
                         more than this many bytes may be written.
                         pszMsg[MaxStringLen] IS NOT VALID MEMORY.
          pMaxMsgLen     If this not 0, this is set to the number of
                         characters you need to allocate to pszMsg.
   */
   void (VSAPI *pfnGetMessage)(int wid, char *pszMsg,int MaxMsgLen, int *pMaxMsgLen);
   /*
       The pfnExit callback is called to exit the editor.
       Currently only two commands call this function

           safe_exit  -- This is only called for an MDI
                         application which uses our MDI
                         API's.
           fexit      -- This command is NEVER bound to a key
                         or menu.  It is typically only used
                         by the developers of VSE to
                         force an editor exit without
                         saving anything.

       In addition to this call back you may want to
       write a replacement function for the _QueryEndSession
       function using the vsLIBExport or vsDLLExport API.
       The _QueryEndSession function gets called when the
       safe_exit command is executed.  The safe_exit command
       only gets executed for MDI applications which use our
       MDI API's.
   */
   void (VSAPI *pfnExit)(int retcode);
   /*
       This callback is called when you call vsInit.  It occurs
       after all options have been set including after macros
       have been loaded but before any macros have been executed.

       At the time of this API design we were not sure if there
       would be a need for this callback.  None of our sample
       applications use it yet.
   */
   void (VSAPI *pfnAfterOptionsSet)();
   /*
       This field indicates up to what version you will allow your
       customers to get a free upgrade.  Due to the flexability
       of the editor API, a user will likely be able to get
       a new vsapi.dll from our Web site or an OEM web site
       and get free enhancements to the editor control.

       Set this field to a version number without the decimal
       point.  For example, if you don't want your users to
       get anything free after version 3.1, set this version to
       31.  This will allow "3.1a", "3.1b" etc but not "3.2"
       editor DLL.

       UNIX: Since we don't expect to have an DLL version of
       the editor control on UNIX, you can leave this field
       0.

       Clearly this is not a full proof mechanism but it is
       better than nothing.
   */
   int FreeVSEUpgradeUpTo;
   /*
        (Defaults to off) When on, the Visual SlickEdit version
        message is displayed when the editor starts.  In the future,
        this might be changed to display a splash screen but for
        now we like the speed of the current implementation.
   */
   int DisplayVersionMessage;
   /*
       This field is reserved for MicroEdge internal use.
   */
   char *pszSerialNumber;
   /*
       If this is not 0, the editor control will not
       allow files to be saved.
   */
   int Demo;
   /*
        Properly sets focus to an editor control window.

        Visual SlickEdit macros can set focus to any editor
        control window.  This typically occurs after an editor
        command, which requires a command line, is executed.

        If you don't create dialog boxes with an editor
        control, you don't need to implement this function.

        This function is NOT called for MDI children with
        editor controls (see pfnMDIChildEditorCtlSetFocus).



       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.
   */
   void (VSAPI *pfnSetFocus)(int wid);
   /*
       This field is reserved for MicroEdge.  OEMs must specify
       0 for now.

       pszServerNamePrefix specifies server name prefix to create
       a unique server name that is used to communicate
       with other instances of Visual SlickEdit and as the DDE
       server name if the  "SupportDDE" field is non-zero.


       MicroEdge reserves "Visual SlickEdit" for this field.
   */
   const char *pszServerNamePrefix;

   /*

       This field is reserved for MicroEdge.  OEMs must specify
       0 for now.

       Windows only, ignored by other platforms.  When true, Visual
       SlickEdit will register itself as a DDE server.
   */
   int SupportDDE;

/*****************MDI fields******************************************/
/*
     OVERVIEW OF MDI INTERFACE
     While our editor control can be used to implement any
     MDI interface, we decided to include callbacks for supporting the
     very popular Windows MDI interface (We're not saying
     you must like it).  In Windows MDI, there is an MDI outerframe
     which contains child windows.


     If you have a Windows style MDI app, this MDI API will save
     you time implementing the following features:

          AutoRestore           Save and restore window/files when
                                application terminates or is invoked.
          Project AutoRestore   Save and restore window/files when
                                a project is closed or opened.
          Listing Buffers       Allows you to choose an editor window
                                or buffer and switch to that window/buffer.
          List modified         Allows you to select buffers to save.

          Multi-file search/replace
          File manager
          Slick-C dialog developement  Opens edit window and
                                       goes to source code for
                                       dialog boxes.
          Tiled windowing       Our tiled windowing works on multiple
                                mdi children.  Splitting a window creates
                                a new mdi child. While this is not
                                common in IDE's, Visual SlickEdit
                                and EMACS users especially like this.

     All the above features require that we know how to switch to another
     window or create another window.  We recommend that you use our MDI
     callbacks if you are implementing an application with multiple
     identical-looking edit windows.

*/


   /*
       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
          pszCaption        Name for newly created window.
          x,y,width,height  Position and size of new window.  When
                            x==MAXINT then, a default size and
                            position must be used.

         WindowState        Initial window state.
                            One of the following values:

             0             Use your own default for the window state.  VS
                           will maximize a new MDI child if the current
                           mdi child is already maximized.

            'I'           Iconize the window
            'M'           Maximize the window
            'N'           Normalize the window

       REMARKS
            Create a new MDI Child window. Use vsCreateEditorCtl to
            create the editor control within your MDI Child.  You may
            only create one editor control on the mdi child during
            this callback.


       RETURN:
           Return 0 if successful.  If successful, the active window must
           be the editor control.  vsCreateEditorCtl sets the active
           window to the newly created control.  If you change the active
           window during the callback, use
           vsPropSetI(0,VSP_WINDOW_ID,editorctlwid) to set the active
           window.

   */
   int (VSAPI *pfnMDICreateEditWindow)(int mdi_wid,int wid,const char *pszCaption,
                              int x,int y,
                              int width,int height,
                              char WindowState);
   /*
       Destroy the MDI Child window and all controls on it.  You must
       use the vsDestroyEditorCtl function to destroy any editor controls.

       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
   */
   void (VSAPI *pfnMDIDestroyEditWindow)(int wid);
   /*
       (Defaults to off)

       REMARKS
          Sets focus to a editor control window.

       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
   */
   void (VSAPI *pfnMDIChildEditorCtlSetFocus)(int wid);
   /*

       REMARKS:
          This optional callback function is intended for creating
          an MDI frame window at the same location and size it was
          in the last edit session.

          Under UNIX we recommend you return 1 to indicate that
          that the x,y,width, and height were ignored.  It takes
          a lot of code to support all window managers and OS's.
          The same window manager on a different UNIX is NOT
          the same unfortunately.

          You must call the vsMDICreate function to create Visual
          SlickEdit's instance data and set the owner system window
          used when creating some dialog boxes.


       RETURN
          0       If successful
          1       If successful but the mdi width or height was ignored.
          <0      Error

       PARAMETERS:
          x,y,width,height     Windows,OS/2.  Outer window position and
                               size.
                               UNIX:  Depends on OS and Window
                               manager.  These coordinates are retrieved
                               by the pfnMDIGetWindow

         WindowState      one of the following values

             0             Use your own default for the window state.  VS
                           will maximize a new MDI child if the current
                           mdi child is already maximized.

            'I'           Iconize the window
            'M'           Maximize the window
            'N'           Normalize the window


   */
   int (VSAPI *pfnMDICreate)(int x,int y,int width,int height,
                        int icon_x,int icon_y,char WindowState);
   /*
       Set focus to the next MDI window which does not have to
       be an editor window.

       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
   */
   void (VSAPI *pfnMDINextWindow)(int mdi_wid);
   /*
       Set focus to the previous MDI window which does not have to
       be an editor window.

       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
   */
   void (VSAPI *pfnMDIPrevWindow)(int mdi_wid);
   /*
      PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.

      RETURN
         Returns next editor control.  This function must not
         change focus.

   */
   int (VSAPI *pfnMDIQNextEditWindow)(int wid);
   /*
      PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.

      RETURN
         Returns previous editor control.  This function must not
         change focus.

   */
   int (VSAPI *pfnMDIQPrevEditWindow)(int wid);
   /*
        PARAMETERS
          wid            Editor control window handle returned from
                         vsCreateEditorCtl.  This is set to
                         0 if there are no MDI children with
                         editor controls. You must check for this.
          RefreshFlags   Flags indicating what has changed.
          linenum        Line number. Update only if (RefreshFlags & VSREFRESH_LINE).
                         Not valid if ~(RefreshFlags & VSREFRESH_LINE).
                         If linenum is less than 0, this means VSE
                         does not know the current line
                         number.  This happens (by default) when
                         you load a file larger than 500k than
                         has no color coding defined.
          col            Column. Update only if (RefreshFlags & VSREFRESH_COL).
          pModeName      Mode name. Update only if (RefreshFlags & VSREFRESH_OTHER).
          ModeNameLen    Number of bytes in pModeName.
          StatusFlags    See VSSTATUSFLAG_???? defines.  Update only
                         if (RefreshFlags & CorrespondingRefreshFlag)

        REMARKS
           This callback is useful for an MDI frame window which contains
           clipped MDI children.  This allows you to update the status
           information displayed in the MDI frame window.  Although
           the buffer name is not passed to this function as an
           argument, this callback should check the VSREFRESH_BUFNAME
           flag and get the buffer name via the vsBufName2Caption function.

           If you do not have clipped MDI children, use the
           vsSetCallback function to define a callback for an editor
           control window.
   */
   void (VSAPI *pfnMDIUpdateEditorStatus)(int wid,int RefreshFlags,int linenum,
                                          int col,const char *pModeName,int ModeNameLen,
                                          int StatusFlags,
                                          int reserved1);
   /*
       PARAMETERS
         mdi_wid     MDI frame window handle returned from
                     vsMDICreate.
         bbside      One of the VSBBSIDE_??? constants indicate what side
                     a toolbar is/was docked.
         change      one of the following
                     'A'   Toolbar docked
                     'D'   Docked toolbar deleted
                     'S'   Docked toolbar size changed
       Remarks
         This function should adjust the size of the client area.  This
         callback is only designed for MDI where the children are clipped
         inside.

         Currently this callback may only be used by MicroEdge.

   */
   void (VSAPI *pfnMDIToolBarChange)(int mdi_wid,int bbside,char change);
   /*
       PARAMETERS
         mdi_wid     MDI frame window handle returned from
                     vsMDICreate.
         bbside      One of the VSBBSIDE_??? constants indicate what side
                     a toolbar is/was docked.
         px,py,pwidth,pheight
                     Pointers to window position and size as if the
                     toolbar was not docked.

       Remarks
         Set *px and *py to a position relative to the mdi client area
         for creating a toolbar on this side.  These values may depend
         on whether toolbars are docked on other sides.

         Adjust *pwidth or *pheight for docking on this side. These values
         may depend on whether toolbars are docked on other sides.

         This callback is only designed for MDI where the children are clipped
         inside.

         Currently this callback may only be used by MicroEdge.

         Example pseudo code
             switch (bbside) {
             case VSBBSIDE_TOP:
                // Easy docking side.
                *px=0;*py=0;*pwidth=WidthOfClientArea;
                break;
             case VSBBSIDE_BOTTOM:
                width=*pwidth;
                height=*pheight;
                RECT mdirect;
                GetClientRect(hwndmdiframe,&mdirect);
                int x,y;

                x=WidthOfToolbarOnLeft;
                y=mdirect.bottom-BottomControlsHeight()-height;

                width=mdirect.right-x;
                if (width<0) width=0;

                *px=x;*py=y;
                *pwidth=width;*pheight=height;
                break;
             }



   */
   void (VSAPI *pfnMDIAdjustToolbarWindow)(int mdi_wid,int bbside,int *px,int *py,int *pwidth,int *pheight);
   /*
       REMARKS
          Tiles all mdi children.

       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
   */
#define VSMDITILE_VERTICAL   0x1
#define VSMDITILE_HORIZONTAL 0x2
   void (VSAPI *pfnMDITileWindows)(int mdi_wid,int TileFlags);
   /*
       REMARKS
          Cascades all mdi children.

      PARAMETERS
         mdi_wid           MDI frame window handle returned from
                           vsMDICreate.
   */
   void (VSAPI *pfnMDICascadeWindows)(int mdi_wid);
   /*
       REMARKS
          Arranges iconized mdi children.

      PARAMETERS
         mdi_wid           MDI frame window handle returned from
                           vsMDICreate.
   */
   void (VSAPI *pfnMDIArrangeIcons)(int mdi_wid);

   /*
        PARAMETERS
          mdi_wid      MDI frame window handle returned from
                       vsMDICreate.
          sc           One of VSSC_??? constants which specify system
                       menu items.  For convenience these exactly match
                       the windows SC_??? constants.

        REMARKS
          Executes a system menu command which operates on the MDI frame
          window.

          This callback is required by the following commands:

             size_mdi
             move_mdi

   */
   void (VSAPI *pfnMDISysMenuCommand)(int mdi_wid,int sc);
   /*
        PARAMETERS
          wid   Editor control window handle returned from
                vsCreateEditorCtl.
          sc    One of VSSC_??? constants which specify system menu items.  For
                convenience these exactly match the windows SC_??? constants.

        REMARKS
          Executes a system menu command which operates on the MDI Child window
          corresponding to this editor control window handle.

          This callback is required by the following commands:

             size_window
             move_window

   */
   void (VSAPI *pfnMDIChildSysMenuCommand)(int wid,int sc);


   /*
        PARAMETERS
          mdi_wid      MDI frame window handle returned from
                       vsMDICreate.
          sc           One of VSSC_??? constants which specify system menu items.  For
                       convenience these exactly match the windows SC_??? constants.
          pszCaption   New menu item caption.

        REMARKS
          Changes the specified menu item in the MDI system menu to the
          caption given.

          This callback is here so that key binding changes in the editor
          match those displayed by the Operating System in the default
          system menu captions.

          UNIX: This callback is probably too difficult to implement for shell
          windows.
   */
   void (VSAPI *pfnMDISysMenuSetCaption)(int mdi_wid,int sc,const char *pszCaption);
   /*
        PARAMETERS
          wid          Editor control window handle returned from
                       vsCreateEditorCtl.
          sc           One of VSSC_??? constants which specify system menu items.  For
                       convenience these exactly match the windows SC_??? constants.
          pszCaption   New menu item caption.

        REMARKS
          Changes the specified menu item in the MDI Child system menu
          to the caption given.

          This callback is here so that key binding changes in the editor
          match those displayed by the Operating System in the default
          system menu captions.
   */
   void (VSAPI *pfnMDIChildSysMenuSetCaption)(int wid,int sc,const char *pszCaption);

   /*
       PARAMETERS
          wid       Editor control window handle returned from
                    vsCreateEditorCtl.

       Return
          'I'   MDI Child frame which belongs to this editor control is iconized.
          'M'   MDI Child frame which belongs to this editor control is maximized.
          'N'   MDI Child frame which belongs to this editor control is normal.

       Remarks
         The following editor commands require this callback

           zoom_window     -  Toggles the state of mdi child

   */
   char (VSAPI *pfnMDIChildQWindowState)(int wid);
   /*
       PARAMETERS
          wid      Editor control window handle returned from
                   vsCreateEditorCtl.
          state    One of the following character constants

             'I'   MDI Child frame which belongs to this editor control is iconized.
             'M'   MDI Child frame which belongs to this editor control is maximized.
             'N'   MDI Child frame which belongs to this editor control is normal.

       Remarks
         The following editor commands require this callback

           zoom_window     -  Toggles the state of mdi child

   */
   void (VSAPI *pfnMDIChildSetWindowState)(int wid,char state);

   /*
       PARAMETERS
          wid     Editor control window handle returned from
                  vsCreateEditorCtl.
          px,py,pwidth,pheight   (Ouput) Pixel coordinates of MDI child frame.

       Remarks
         The following editor commands require this callback

           vsplit_window   -  Reduces the size of the current MDI child
                              to half its horizontal size and creates a new MDI child
                              to the right to fill in the other half.
           hsplit_window   -  Reduces the size of the current MDI child
                              to half its vertical size and creates a new MDI child
                              below to fill in the other half.

   */
   void (VSAPI *pfnMDIChildGetWindow)(int wid,int *px,int *py,int *pwidth,int *pheight,char state);
   /*
       PARAMETERS
          wid      Editor control window handle returned from
                   vsCreateEditorCtl.
          x,y,width,height   Pixel coordinates to place the MDI child frame.

       Remarks
         The following editor commands require this callback

           vsplit_window   -  Reduces the size of the current MDI child
                              to half its horizontal size and creates a new MDI child
                              to the right to fill in the other half.
           hsplit_window   -  Reduces the size of the current MDI child
                              to half its vertical size and creates a new MDI child
                              below to fill in the other half.

   */
   void (VSAPI *pfnMDIChildSetWindow)(int wid,int x,int y,int width,int height,char state);

   /*
       PARAMETERS
          wid          Editor control window handle returned from
                       vsCreateEditorCtl.
          px,py       (Ouput) Pixel coordinates of iconized MDI child.

       REMARKS
         The following editor commands use this callback:

           save_window_config  - Saves MDI frame coordinates in auto-restore file.
           restore             - Attempts to restore MDI frame to original
                              size and position.
           project_close   -  Saves MDI frame coordinates in project file.
           project_open    -  Attempts to restore MDI frame to original
                              size and position.

   */
   void (VSAPI *pfnMDIChildGetIconXY)(int wid,int *px,int *py);
   /*
       PARAMETERS
          wid          Editor control window handle returned from
                       vsCreateEditorCtl.
          x,y          New pixel coordinates of iconized
                       MDI child

       REMARKS
         The following editor commands use this callback:

           save_window_config  - Saves MDI frame coordinates in auto-restore file.
           restore             - Attempts to restore MDI frame to original
                                 size and position.
           project_close   -  Saves MDI frame coordinates in project file.
           project_open    -  Attempts to restore MDI frame to original
                              size and position.

   */
   void (VSAPI *pfnMDIChildSetIconXY)(int wid,int x,int y);
   /*

       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
       REMARKS
          Places MDI children with same tile id on top of the
          Z order
   */
   void (VSAPI *pfnMDIBringTilesToFront)(int mdi_wid,int TileID);
   /*
       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
       RETURN
          Returns tile id of MDI child containing the editor control
          given.
   */
   int (VSAPI *pfnMDIChildQTileID)(int wid);
   /*
       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
       REMARSK
          Sets tile id of MDI child containing the editor control
          given.
   */
   void (VSAPI *pfnMDIChildSetTileID)(int wid,int TileID);
   /*
       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
          vsp_old           One of the constants VSP_X,VSP_Y, VSP_WIDTH,
                            VSP_HEIGHT
       RETURN
          Returns the corresponding MDI child window attribute
          specified by vsp_old in pixels.

   */
   int (VSAPI *pfnMDIChildQOldWindow)(int wid,int vsp_old);
   /*
       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.
       REMARKS
          Sets the corresponding MDI child window attribute specified by
          vsp_old in pixels.
   */
   void (VSAPI *pfnMDIChildSetOldWindow)(int wid,int vsp_old,int value);

   /*
       PARAMETERS
          mdi_wid           MDI frame window handle returned from
                            vsMDICreate.
          px,py,pwidth,pheight   (Ouput) Pixel coordinates of MDI frame.
         state       Reserved for later use.


       UNIX: Under UNIX it is very difficult to implement this function
       for shell windows (non-clipped windows) because Window managers
       handle decorations differently.  The same Window manager on a
       different OS can be different.
   */
   void (VSAPI *pfnMDIGetWindow)(int mdi_wid,int *px,int *py,int *pwidth,int *pheight,char state);
   /*
       PARAMETERS
         mdi_wid     MDI frame window handle
         x,y,width,height   Pixel coordinates to place the MDI frame.
         state       Reserved for later use.

       Remarks
         The following editor commands use this callback:

           save_window_config  - Saves MDI frame coordinates in auto-restore file.
           restore             - Attempts to restore MDI frame to original
                                 size and position.
           project_close   -  Saves MDI frame coordinates in project file.
           project_open    -  Attempts to restore MDI frame to original
                              size and position.

       UNIX: Under UNIX it is very difficult to implement this function
       for shell windows (non-clipped windows) because Window managers
       handle decorations differently.  The same Window manager on a
       different OS can be different.
   */
   void (VSAPI *pfnMDISetWindow)(int mdi_wid,int x,int y,int width,int height,char state);

   /*
       PARAMETERS
         mdi_wid     MDI frame window handle returned from
                     vsMDICreate.
         px,py       On input, x and y coordinates returned from last pfnMDIGetWindow call.
                     On return, adjusted x and y coordinates to be used by
                     auto-restore.

       Remarks
         This callback is only called under UNIX.

         This callback is a work-around we had to use for getting
         our MDI frame auto-restore to work under Silicon Graphics.
         If you were able to get pfnMDISetWindow and pfnMDIGetWindow
         to work perfectly, you don't need to implement this callback.
   */
   void (VSAPI *pfnMDIGetRestoreXY)(int mdi_wid,int *px,int *py);
   /*
       PARAMETERS
         mdi_wid        MDI frame window handle returned from
                        vsMDICreate.
         px,py,pwidth,pheight   (Ouput) For clipped MDI Children, pixel
                                coordinates of MDI client area which
                                should be the largest non-maxmized MDI
                                Child Frame.
                                If you implemented non-clipped MDI Children,
                                this callback must be NULL.

       REMARKS
         Called when splitting a maximized MDI Child by the following
         commands:

           vsplit_window   -  Reduces the size of the current MDI child
                              to half its horizontal size and creates a new MDI child
                              to the right to fill in the other half.
           hsplit_window   -  Reduces the size of the current MDI child
                              to half its vertical size and creates a new MDI child
                              below to fill in the other half.

         Dockable toolbars require this callback to dock and undock.

   */
   void (VSAPI *pfnMDIClientGetWindow)(int mdi_wid,int *px,int *py,int *pwidth,int *pheight);

   /*
       PARAMETERS
          wid               Editor control window handle returned from
                            vsCreateEditorCtl.

       RETURN
          Returns true if this editor control is on the
          active mdi child.  In WIN32 terms this means
          the WM_MDIGETACTIVE returns a child window
          handle which contains this editor control.

   */
   int (VSAPI *pfnMDIEditorCtlIsOnActiveChild)(int wid);
   void *Reserved2[10];

/**********************Command Line callbacks **********************/
   /*
       IMPORTANT: This pointer must point to data that will not disappear.
       Define your command line functions in the global scope.
   */
   VSCMDLINE_FUNCTIONS *pcmdlinefuns;
   /*
       Because the command line is not part of the editor, you will
       need to have your own configuration for command line font.
       We don't think its worth it for you to support changing
       the command line font because very few users use this feature.

       This callback is reserved for MicroEdge.
   */
   void (VSAPI *pfnCmdLineSetFont)(void);

   void *Reserved3[5];
/************************Miscellaneous option callbacks*******************************************/
   /*
       The vs executable has a +/-new option which determines what
       happens when a user invokes another copy of the editor.

       This callback is currenly reserved for MicroEdge's use only.

       Returns non-zero value if command line was passed to existing
       editor instance.
   */
   int (VSAPI *pfnUseCurrentInstance)(const char *pszCmdline);

   /*
       This function is specific to MicroEdge's gui.  We need it because
       the MDI child window procedure is in the DLL.
   */
   void (VSAPI *pfnSetWasOnCmdline)(int WasOnCmdline);
   /*
       Called when vsRefresh is explicitly called to refresh all edit
       windows or when a Visual SlickEdit command terminates.

       Since this function gets called on every keypress, make sure
       your code is fast.

       Visual SlickEdit uses this callback to make sure that the focus
       is on the command line when there are no MDI children left.
   */
   void (VSAPI *pfnRefresh)(void);
   /*
       Because font selection is not portable, this function is reserved
       for MicroEdge.
   */
   void (VSAPI *pfnSetStatusFont)(void *pfont);
   /*
       Because color selection is not portable, this function is reserved
       for MicroEdge.
   */
   void (VSAPI *pfnSetStatusColor)(int fg,int bg);
   /*
       Because color selection is not portable, this function is reserved
       for MicroEdge.
   */
   void (VSAPI *pfnSetMessageColor)(int fg,int bg);
   void *Reserved4[10];
};
int VSAPI vsInit(VSINIT *pvsinit);
void VSAPI vsPrepareForTerminate();
void VSAPI vsTerminate();

long VSAPI vsMatchStart(int TaggedExpression=-1);
int VSAPI vsMatchCursorLength();
int VSAPI vsMatchLength(int TaggedExpression=-1);
void VSAPI vsFillSelection(int wid,int markid=-1,unsigned char ch=' ');
void VSAPI vsShiftSelectionRight(int wid,int markid=-1,int Reserved=1,unsigned char Reserved2=' ');
void VSAPI vsShiftSelectionLeft(int wid,int markid=-1,int Reserved=1);
void VSAPI vsSplitLine(int wid,int col=0);
int VSAPI vsJoinLine(int wid);
void VSAPI vsKeyin(int wid,const char *pBuf,int BufLen);
void VSAPI vsDeleteChar(int wid, int Reserved=0);
void VSAPI vsRubout(int wid, int Reserved=0);
int VSAPI vsSelectMatch(int wid,int markid=-1);
int VSAPI vsSearchReplace(int wid,const char *pReplaceString,int ReplaceStringLen=-1,int RepeatSearch=0);
int VSAPI vsSaveSearch(void *pvoid=0);
void VSAPI vsRestoreSearch(void *pvoid);
void VSAPI vsSetInsertState(int wid,int state,int Reserved=0);
int VSAPI vsQInsertState(int wid,int Reserved=0);
void VSAPI vsBeginLine(int wid);
void VSAPI vsEndLine(int wid);

#define VSSORT_DESCENDING   0x1
#define VSSORT_IGNORECASE   0x2
#define VSSORT_IGNORECASE_NONLOCALE  0x8
#define VSSORT_NUMBER       0x10
#define VSSORT_FILENAME     0x20

int VSAPI vsSortSelection(int wid,int markid=-1,int SortFlags=0);
void VSAPI vsDeleteSelection(int wid,int markid=-1,int Reserved=-1);
int VSAPI vsDuplicateSelection(int wid,int markid);
void VSAPI vsShowSelection(int wid,int markid);
void VSAPI vsExpandTabsC(int wid,
                   char *pszDest,
                   int *pDestLen,
                   int StartCol,
                   int ColWidth,
                   char Option);
int VSAPI vsTextColC(int wid,int col,char option='L');
int VSAPI vsSetSelectType(int wid,int markid,int type,char option='L' /* T L U S*/);
int VSAPI vsQSelectType(int wid,int markid= -1,char option='T' /* T S P I U W*/);
long VSAPI vsQROffset(int wid);
int VSAPI vsGoToROffset(int wid,long offset);
int VSAPI vsGetText2(int wid,int Nofbytes,long point,char *pszBuf,int *pNofbytesRead=0);
void VSAPI vsGoToOldLineNumber(int wid,int OldLineNum,int Reserved=1);
void VSAPI vsSetAllOldLineNumbers(int wid,int Reserved=1);
int VSAPI vsDeleteText(int wid,int DelLen,char option=0);
int VSAPI vsInsertText(int wid,const char *pBuf,int BufLen=-1,int Binary=0,unsigned char NLCh1='\r',unsigned char NLCh2='\n');

int VSAPI vsGoToPoint(int wid,long Point,long DownCount=0,int LineNum=(-1));
void VSAPI vsQPoint(int wid,long *pPoint,long *pDownCount,char Option='P');
long VSAPI vsQOffset(int wid);

int VSAPI vsSearch(int wid,const char *pSearchString,int SearchStringLen, const char *pszOptions=0,const char *pReplaceString=0,int ReplaceStringLen=0,int *pNofchanges=0);
int VSAPI vsRepeatSearch(int wid,const char *pszOptions=0,int StartCol=0);

#ifndef VSLF_COMMENT_INFO_MASK
   #define VSLFC_VSSELDISPSHIFT      5

   #define VSLF_CURLINEBITMAP  0x00000200
   #define VSLF_MODIFY         0x00000400
   #define VSLF_INSERTED_LINE  0x00000800
   #define VSLF_HIDDEN         0x00001000
   #define VSLF_MINUSBITMAP    0x00002000
   #define VSLF_PLUSBITMAP     0x00004000
   #define VSLF_NEXTLEVEL      0x00008000
   #define VSLF_LEVEL          0x001F8000
   #define VSLF_NOSAVE         0x00200000
   #define VSLF_VIMARK         0x00400000

   #define VSLF_LINEFLAGSMASK     0x007fffff
   #define vsLevelIndex(bl_flags)  (((bl_flags) & VSLF_LEVEL)>>15)
   #define vsIndex2Level(level)   ((level)<<15)


   /*
       Syntax Color Coding encoding

       The syntax color coding is encoded in the low 8 bits of the 32
       bits of line flags.

          First mlcomment can be nested between 0x1 and 0x7.  7 levels
          Second mlcomment can be nested between 0x9 and 0xF.  7 levels
          Third mlcomment can be nested between 0x11 and 0x17.  7 levels
          fourth mlcomment can be nested between 0x19 and 0x1C.  4 levels
          0x8==VSLF_IN_LINE_COMMENT is a special return value from
            SETLINECOLOR callback which indicates that the last character
            of the line is in a line comment.
          0x1d,0x1e   is used for multiline squotes and dquotes
          0x1f is not used yet.
          0xE0  Bits of LexerStateInfo are for the embedded language index.
                This allows up to 7 different embedded languages per
                language.
   */
   // Note that LF stands for Line flag.  The H is just to assist with
   // completion purposes.

   // Mask multi-line comments, strings, and embedded languages
   #define VSLF_LEXER_STATE_INFO 0xff

   // Encode embedded language lexer state
   #define vsLFHEmbeddedLanguageInfo(EmbeddedLanguageIndex)  (((EmbeddedLanguageIndex)+1)<<5)
   // Returns index of embedded language.  -1 indicates no embedded language.
   #define vsLFHEmbeddedLangaugeIndex(comment_info)  ((((int)(comment_info) &VSLF_EMBEDDED_LANGUAGE_MASK)>>5)-1)

   // Mask multi-line comments, strings
   #define VSLF_COMMENT_INFO_MASK 0x1f

   #define VSLF_EMBEDDED_LANGUAGE_MASK 0xE0
   #define VSLF_IN_LINE_COMMENT  0x8
   #define VSLF_IN_SQUOTE       0x1E
   #define VSLF_IN_DQUOTE       0x1D
   // Returns non-zero value if lexer state info indicates we are in a string.
   // You can use the expression
   //   (LexerStateInfo&~VSLF_EMBEDDED_LANGUAGE_MASK)==VSLF_IN_DQUOTE
   // to check whether you are in a multi-line double quoted string.
   // If you are not in a double quoted string, you know you must be
   // in a single quoted string.
   #define vsLFHInString(LexerStateInfo)  (((LexerStateInfo)&~VSLF_EMBEDDED_LANGUAGE_MASK) && ((LexerStateInfo)&~VSLF_EMBEDDED_LANGUAGE_MASK)>=VSLF_IN_DQUOTE)

   // Encode multi-line comment.
   #define vsLFHCommentInfo(nest_level,comment_index) (nest_level|(comment_index<<3))

   // Returns non-zero value if lexer state info indicates we are in a
   // multi-line comment.
   #define vsLFHInComment(LexerStateInfo)  (((LexerStateInfo)&~VSLF_EMBEDDED_LANGUAGE_MASK) && ((LexerStateInfo)&~VSLF_EMBEDDED_LANGUAGE_MASK)<VSLF_IN_DQUOTE)
   // Returns index of multi-line comment we are currently in.  Don't
   // use this macro unless vsLFHInComment returns non-zero value.
   #define vsLFHCommentIndex(LexerStateInfo) (((LexerStateInfo) &0x018)>>3)
   // Returns nesting level of multi-line comment we are currently in.
   // Don't use this macro unless vsLFHInComment returns non-zero value.
   #define vsLFHNestLevel(LexerStateInfo) ((LexerStateInfo) &0x7)
#endif
int VSAPI vsQLineFlags(int wid);
void VSAPI vsSetLineFlags(int wid,int Flags,int Mask=0);
void VSAPI vsRefresh(int wid=0,char Option='A');
void VSAPI vsQuitView(int wid);
void VSAPI vsDeleteBuffer(int wid);
int VSAPI vsQMaxTabCol();
void VSAPI vsExpandTabs(int wid,
                   char *pszDest,
                   int *pDestLen,
                   const char *pSource,
                   int SrcLen,
                   int StartCol,
                   int ColWidth,
                   char Option);
int VSAPI vsSaveFile(int wid,const char *pszCmdLine);


}

#endif
