/*
$VerboseHistory: alias.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:23a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:22a
 * Comment:
 * Changed to add support for editor control
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/*   See help on ALIAS command */

/*
You alias file needs to have the aliases below defined in it.

functioncomment( fname "Function Name:"
                 )
                /*
                 *Function Name:%(fname)
                 *
                 *Parameters:%\c
                 *
                 *Description:
                 *
                 *Returns:
                 *
                 */

filecomment /*******************************************************************
  *
  *    DESCRIPTION:%\c
  *
  *    AUTHOR:
  *
  *    HISTORY:
  *
  *    DATE:%\d
  *
  *******************************************************************/

 /** include files **/

 /** local definitions **/

 /* default settings */

 /** external functions **/

 /** external data **/

 /** internal functions **/

 /** public data **/

 /** private data **/

 /** public functions **/

 /** private functions **/

*/
#include "slick.sh"
//  set this variable to 'e' if you want case sensitive alias matching.
_str   def_alias_case='i';

#define ALIAS_ARG ('alias:'TERMINATE_MATCH)   /* Underscores must be dashes */

/*
    Applies To: Editor Control or any object.  When applied to Editor
                Control extension specific alias filename is returned
                in addition to other alias files.

    Remarks: Specify arg(1)!="" if you don't want the extension specific
             filename returned in addition to other alias files.

    Return:  Returns alias filename(s) separated with PATHSEP character.  Only files
             which are found are returned.

*/
_str alias_filename(...)
{
   do_ext_aliasfile= (arg(1)=='');
   filename=get_env(_SLICKALIAS)
   if (filename=='') {
      if (_config_path()!='') {
         misc_dir=strip_filename(slick_path_search(_VLX_FILE),'N');
         misc_dir=absolute(misc_dir);
         filename=_config_path():+_ALIAS_FILE:+PATHSEP;
         if (!file_eq(misc_dir,_config_path())) {
            filename=filename:+misc_dir:+_ALIAS_FILE;
         }

      } else {
         filename=_ALIAS_FILE;
      }
      //if (file_match('-p 'maybe_quote_filename(filename),1)=='') {
      //   filename=slick_path_search(_ALIAS_FILE);
      //}
   }
   buf_wid=_edit_window();
   if (buf_wid.p_view_id<0 && do_ext_aliasfile ) {
      ext=_bufnameNmode2ext(buf_wid.p_buf_name,buf_wid.p_mode_name);
      index=find_index('def-alias-'ext,MISC_TYPE)
      if ( index && name_info(index)!='' ) {
         filename=name_info(index):+PATHSEP:+filename;
      }
   }
   filenames=filename;
   pfilenames='';
   for (;;) {
      parse filenames with filename (PATHSEP) filenames;
      if (filename=='') break;
      if (!pathlen(filename)) {
         path=slick_path_search(filename);
         if (path=='') {
            filename=_config_path():+filename;
         } else {
            filename=path;
         }
      }
      if (pfilenames=='') {
         pfilenames=filename;
      } else {
         pfilenames=pfilenames:+PATHSEP:+filename;
      }
   }
   return(pfilenames);
}

// Returns 0 if successful
_command alias_cd() name_info(ALIAS_ARG','VSARG2_CMDLINE|VSARG2_EDITORCTL)
{
   p_window_id=_edit_window();
   dir_name=prompt(arg(1),'Directory');
   if (arg(1)=='') {
      if ( ! def_stay_on_cmdline) {
         if (_no_child_windows()) {
            VSWID_STATUS._set_focus();
         } else {
            cursor_data();
         }
      }
   }
   path = get_alias(dir_name,multi_line_info);
   parse multi_line_info with multi_line_flag old_view_id alias_view_id .;
   if ( multi_line_flag ) {
      message('Multi-line alias not allowed.');
      return(1);
   }

   if ( path=='' ) {
      if ( dir_name=='' ) {
         return(1);
      }
      /* Actual directory may have been specified. */
      if ( ! isdirectory(dir_name) ) {
         message nls('Alias "%s" not found',dir_name);
         return(1);
      }
      path=dir_name;
   }
   /* back_dir=getcwd() */
   /* All that work, just for this */
   status=cd(path);
   return(status);
}


_command void keyin_dir_name()  name_info(','VSARG2_MARK|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_TEXT_BOX)
{
   maybe_delete_selection();
   buf_name= _mdi._edit_window().p_buf_name;
   keyin substr(buf_name,1,pathlen(buf_name));
}
_str get_alias(name,var multi_line_info,...)
{
   replace_envvars=arg(3);
   aliasfilename=arg(4);
   status=find_alias2(name,old_view_id,alias_view_id,
                     multi_line_flag,aliasfilename,alias_linenum,false);
   multi_line_info=multi_line_flag " "old_view_id" ":+
                   alias_view_id" "alias_linenum" "aliasfilename;
   if ( status ) {
      return('');
   }
   if (multi_line_flag) {
      _delete_temp_view(alias_view_id);
      p_view_id=old_view_id;
      return('');
   }
   get_line(line);
   parse line with . alias;
   if ( replace_envvars ) {
      alias=_replace_envvars(alias);
   }
   _delete_temp_view(alias_view_id);
   p_view_id=old_view_id;
   return(alias)

}
_str _replace_envvars(_str string)
{
   result='';
   for (;;) {
      parse string with before '%' name '%' +0 string;
      if ( string:=='' ) {
         /* if there is no ending percent, loose text. */
         return(result:+before);
      }
      string=substr(string,2);
      if ( name:=='' ) {
         v='%';
      } else {
         name=env_case(name);
         v=get_env(name);
         if ( rc ) { /* Environment variable name does not exist. */
            /* Check for special name. */
            if ( name=='CWD' ) {
               v=getcwd();
            } else if ( name=='CURDRIVE' ) {
#if ! __UNIX__
               v=substr(getcwd(),1,2);
#else
               v="";
#endif
            }
         }
      }
      result=result:+before:+v;
   }
}
_str _encode_vsroot(_str paths,boolean isFilename,boolean allowDotDot=true)
{
   vsroot=get_env('VSROOT');
   //vsroot='c:\product\vslick\';
   result="";
   for (;;) {
      parse paths with path (PATHSEP) paths;
      if (path=="") break;
      if (!isFilename && last_char(path)!=FILESEP) {
         path=path:+FILESEP;
      }
      prefix='%VSROOT%';
      prefixpath=vsroot;
      for (;;) {
         //messageNwait('prefixpath='prefixpath);
         if(length(prefixpath)<=3) {
            if (result!="") {
               result=result:+PATHSEP;
            }
            result=result:+path;
            break;
         }
         if (file_eq(prefixpath,substr(path,1,length(prefixpath)))) {
            if (result!="") {
               result=result:+PATHSEP;
            }
            result=result:+prefix:+substr(path,length(prefixpath)+1);
            break;
         }
         if (!allowDotDot) {
            if (result!="") {
               result=result:+PATHSEP;
            }
            result=result:+path;
            break;
         }
         if (last_char(prefixpath)==FILESEP) {
            prefixpath=substr(prefixpath,1,length(prefixpath)-1);
         }
         prefixpath=strip_filename(prefixpath,'n');
         //messageNwait('prefixpath='prefixpath);
         prefix=prefix'..'FILESEP;
      }
   }
   return(result);
}

_command expand_space_alias()  name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   no_expansion=0;
   if (command_state()) {
      key=' ';
      index=eventtab_index(_default_keys,
                              _default_keys,event2index(key));
      if (index!=last_index()) {
         last_event(key);
         return(call_root_key(key));
      }
      keyin(' ');
      return('');
   }
   get_line(line);
   line=strip(line,'T');
   orig_word=strip(line);
   if (p_col!=text_col(line)+1 || pos('[~\od'p_word_chars']',orig_word,1,'r')) {
      keyin(' ');
      return('');
   }
   expand_alias('',1);
}
/*
    arg(1)    Option name of alias
    arg(2)    If not '', space character is inserted if alias is not found.
    arg(3)    Single alias file to look in.
*/
_command expand_alias()  name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   alias_name=arg(1);
   insert_space_if_not_found=arg(2)!='';
   aliasfilename=arg(3);
#if 0
   use_extension_specify_alias_file=0;
   for (;;) {
      if (substr(alias_name,1,1)!='-') {
         break;
      }
      parse alias_name with option alias_name;
      if (upcase(option)=='-E') {
         use_extension_specify_alias_file=1;
      }
   }
   if (use_extension_specify_alias_file && p_view_id<0) {
      aliasfilename=_get_ext_alias_filename();
   }
#endif
   if (command_state()) {
      old_col=_get_sel();
   } else {
      old_col=p_col;
   }
   old_command_state=command_state();
   if (alias_name=='') {
      init_command_op();
      if (p_col==1) {
         alias_name=cur_word(start_col,0)
         if (alias_name=="") {
            retrieve_command_results();
            return(1);  // No word at cursor
         }
         start_col=_text_colc(start_col,"I");
      } else {
         left();
         status=search('([~\od'p_word_chars"]|^)\\c","ir-");
         start_col=p_col;
         alias_name=_expand_tabsc(start_col,old_col-start_col);
         p_col=old_col;
      }
   } else {
      start_col=p_col;
   }
   /* Set variable def_from_cursor to 1 if you want to start from cursor */
   if (alias_name=="") {
      call retrieve_command_results();
      message(nls("No word at cursor"));
      return(1)
   }
   //get_line line
   //start_col=text_col(line,start_col,'i')

   status=find_alias2(alias_name,old_view_id,alias_view_id,
                     multi_line_flag,aliasfilename,alias_linenum,insert_space_if_not_found);
   if (status) {
      if (status==STRING_NOT_FOUND_RC && arg(2)!='') {
         p_col=old_col;
         keyin(" ");
      }
      retrieve_command_results();
      return(status);
   }
   if ( multi_line_flag && old_command_state) {
      _delete_temp_view(alias_view_id);
      p_view_id=old_view_id;
      retrieve_command_results();
      message('Multi-line alias not allowed on command line.');
      return(1);
   }
   status=0;
   get_line(line);parse line with . path;
   if ( path!="" ) {
      status=expand_alias2(alias_name,path,start_col,old_view_id,alias_view_id);
      if (status==COMMAND_CANCELLED_RC && arg(2)!='') {
         p_col=old_col;
         keyin(" ");
      }
   }
   p_view_id=old_view_id;
   retrieve_command_results();
   return(status);
}

static _str expand_alias2(name,first_line,start_col,destination_view_id,alias_view_id)
{
   prompt_view_id='';

   p_view_id=alias_view_id;
   get_line(line);

   /* HERE - check for a '(' in name and build the prompt strings and query */
   var_view_id=prompt_view_id='';
   parse line with true_name .;
   if ( pos('(',true_name) ) {
      build_prompts(prompt_view_id,var_view_id);
      p_view_id=destination_view_id;
      result=show('-modal _textbox_form',
        'Parameter Entry',
        TB_VIEWID_INPUT|TB_VIEWID_OUTPUT|TB_QUERY_COMPAT,   // flags
        '',                 // width ('' or 0 uses default)
        '',                 // Optional help item
        '',                 // Font (not supported yet)
        '',                 // Retrieve name
        prompt_view_id
        );
      if (result=='') {
         /* user pressed ESC or an error occurred */
         activate_view(var_view_id);
         _delete_buffer();_quit_view();
         p_view_id=destination_view_id;
         return(COMMAND_CANCELLED_RC);
      }
      prompt_view_id=result;
      p_view_id=alias_view_id;

      /* now put the cursor where the actual alias starts */
      down();
      get_line(line);

   }

   alias_col='';
   blank_col=pos(' ',line);
   if ( blank_col ) {
      alias_col=verify(line,' ','',blank_col);
      if ( ! alias_col ) {
         alias_col='';
      } else {
         alias_col=alias_col-1;
      }
   }
   if ( alias_col=='' ) {
      line='';
   } else {
      line=substr('',1,alias_col):+substr(line,alias_col+1);
   }
   alias_line=line;
   p_view_id=destination_view_id;
   get_line(line);
   if (upcase(expand_tabs(line,start_col,length(name)))==upcase(name)) {
      replace_line expand_tabs(line,1,start_col-1,'s'):+expand_tabs(line,start_col+length(name),-1,'s');
   }
   stop_info='';
   expand_alias_line(name,alias_line,1,start_col,alias_col,stop_info,prompt_view_id,var_view_id);

   for (;;) {
      p_view_id=alias_view_id;
      down();

      if ( rc ) {
         /* at bottom of alias file */
         break;
      }

      get_line(alias_line);

      if ( substr(alias_line,1,1):!=' ' ) {
         /* at end of multi-line alias */
         break;
      }

      p_view_id=destination_view_id;
      /* the alias name and starting column are useless now, so set to '' */
      expand_alias_line('',alias_line,0,start_col,alias_col,stop_info,prompt_view_id,var_view_id);

   }

   _delete_temp_view(alias_view_id);

   /* now clean up if we were expanding a parameterized alias */
   if ( prompt_view_id!='' ) {
      activate_view(prompt_view_id);
      _delete_buffer();_quit_view();
      activate_view(var_view_id);
      _delete_buffer();_quit_view();
   }

   p_view_id=destination_view_id;

   if ( stop_info!='' ) {
      /* cursor position was set by alias */
      parse stop_info with stop_point stop_line stop_col;
      goto_point(stop_point,stop_line);p_col=stop_col;
   }
   return(0);
}

static _str expand_alias_line(name,
                              alias_line,  /* Alias value line. */
                              expand_first,
                              start_col, /* Column of alias being replaced */
                              var alias_col, /* Spaces adjustment or '' */
                              var stop_info,
                              prompt_view_id, /* view containing prompt strings */
                              var_view_id)    /* view containing parameter names*/
{
   if ( ! expand_first ) {
      insert_line('');
   }
   adjust_spaces=1;
   for (;;) {
      get_line(line);            /* User text line. */
      if ( ! expand_first && adjust_spaces ) {
          line=indent_string(start_col-1);
      }
      p=next_multi_line_code(alias_line,'ALL');
      if ( p ) {
         /* HERE - check for a parameter */
         q=pos('{%\([0-9a-zA-Z_]#\)}',substr(alias_line,p),1,'r');
         if ( q==1 ) {
            code=substr(alias_line,p,pos('0'));
         } else {
            code=substr(alias_line,p,3);   /* grab the code */
            code=upcase(code);
         }

         after=substr(alias_line,p+length(code));
         before=substr(alias_line,1,p-1);
         before=_replace_envvars(before);
      } else {
         before=_replace_envvars(alias_line);
         code='';
      }
      if ( adjust_spaces ) {
         if ( alias_col=='' ) {
            alias_col=verify(before,' ');
            if ( ! alias_col ) {
               alias_col='';
            } else {
               alias_col=alias_col-1;
            }
            before=strip(before,'L');
         } else {
            spaces=substr(before,1,alias_col);
            if ( spaces!='' ) {
               before=strip(before,'L');
            } else {
               before=substr(before,alias_col+1);
            }
         }
      }
      replace_line expand_tabs(line,1,start_col-1,'s'):+
                      before:+expand_tabs(line,start_col,-1,'s');
      p_col=start_col+length(before);

      if ( code=='' ) {
         return(0);
      } else {
         if ( code=='%\B' ) {
            get_line(cur_line);
            /* IF unindent from the beginning of a line. */
            parse name_info(p_index) with . .;
            syntax_indent=p_SyntaxIndent;
            if (syntax_indent>0 &&
               expand_tabs(cur_line,1,p_col-1)=='' && p_col>syntax_indent ) {
               non_blank_col=verify(cur_line,' '\t);
               if ( ! non_blank_col ) {
                  non_blank_col=length(cur_line)+1;
               }
               replace_line indent_string(text_col(cur_line,non_blank_col,'i')-syntax_indent-1):+
                            substr(cur_line,non_blank_col);
               p_col=p_col-syntax_indent;
            } else {
               cbacktab();
            }
         } else if ( code=='%\C' ) {
            stop_info= point() " "point('L') " "p_col;
         } else if ( code=='%\I' ) {
            get_line(cur_line);
            /* IF unindent from the beginning of a line. */
            parse name_info(p_index) with . .;
            syntax_indent=p_SyntaxIndent;
            if ( syntax_indent>0 &&
               expand_tabs(cur_line,1,p_col-1)=='' ) {
               non_blank_col=verify(cur_line,' '\t)
               if ( ! non_blank_col ) {
                  non_blank_col=length(cur_line)+1;
               }
               replace_line indent_string(text_col(cur_line,non_blank_col,'i')+syntax_indent-1):+
                            substr(cur_line,non_blank_col)
               p_col=p_col+syntax_indent;
            } else {
               ctab();
            }
         } else if ( code=='%\L' ) {
            after=after;
         } else if ( code=='%\S' ) {
            after=after;
         } else if ( code=='%\N' ) {
            after=current_proc(0):+after;
         } else if ( code=='%\D' ) {
            after=_date():+after
         } else if ( code=='%\F' ) {
            after=strip_filename(p_buf_name,'p'):+after
         } else if ( code=='%\T' ) {
            after=_time():+after
         } else if ( code=='%\E' ) {
            parse _date() with month'/'day'/'year;
            if (length(month)<2) month='0'month;
            if (length(day)<2) day='0'day;
            if (length(year)>2) year=substr(year,3);
            after=month:+day:+year:+after
         } else {   /* we have a parameter */
            get_view_id(view_id);
            parse code with '%(' varble ')';
            if (var_view_id=='') {
               PreserveFocusMessageBox(nls('"%s" not found in parameter list.',varble));
            } else {
               activate_view(var_view_id);
               top();
               search('^'varble,def_alias_case'r');
               if ( ! rc ) {
                  index=p_line;
                  activate_view(prompt_view_id);
                  top();
                  down(p_noflines intdiv 2 + (index-1));
                  get_line(val);
                  after=val:+after;
               } else {
                  message(nls('"%s" not found in parameter list.',varble));
               }
            }
            activate_view(view_id);
         }

      }

      start_col=p_col;
      alias_line=after;
      name='';  /* this is here for the first line of alias,  *
                 * if there is a code in the first line, then *
                 * line remaining after code requires name='' */

      adjust_spaces=0;
   }

   /* END expand_alias_line */


}
static _str build_prompts(var prompt_view_id,var var_view_id)
{
   get_view_id view_id;

   load_files('+c +t');
   _delete_line();
   get_view_id(prompt_view_id);

   load_files('+c +t');;
   _delete_line();
   get_view_id(var_view_id);

   activate_view(view_id);
   get_line(line);
   line=substr(line,pos('(',line)+1);  /* only want what is after
                                        * the open paren of the
                                        * very first line of alias
                                        * parameter-list
                                        */

   parse line with varble '"' prompt_string '"' +0 init_value;

   init_value=substr(init_value,3);        /* init_value starts out with
                                            * the last " from the prompt-
                                            * string in position 1
                                            * This is done to preserve leading
                                            * spaces after the first space
                                            */

   if ( last_char(prompt_string)!=':' ) {
      /* must have a colon at end of prompt string for QUERY */
      prompt_string=prompt_string:+':';
   }
#if 0
   space_option=substr(prompt_string,1,1);
   if ( space_option:==' ' ) {
      /* must show leading spaces in the prompt string */
      prompt_string='-':+prompt_string;
   }
#endif
   activate_view(var_view_id);
   insert_line(strip(varble));
   activate_view(prompt_view_id);
   insert_line(prompt_string:+init_value);

   for (;;) {
      activate_view(view_id);
      down();
      get_line(line);
      parse line with varble '"' prompt_string '"' +0 init_value;

      init_value=substr(init_value,3);  /* init_value starts out with
                                         * the last " from the prompt-
                                         * string in position 1
                                         * This is done to preserve leading
                                         * spaces after the first space
                                         */
      if ( last_char(prompt_string)!=':' ) {
         /* must have a colon at end of prompt string for QUERY */
         prompt_string=prompt_string:+':';
      }
#if 0
      space_option=substr(prompt_string,1,1);
      if ( space_option:==' ' ) {
         /* must show leading spaces in the prompt string */
         prompt_string='-':+prompt_string;
      }
#endif
      /* check for end of parameter list */
      if ( varble==')' ) {
         break;
      }

      activate_view(var_view_id);
      insert_line(strip(varble));

      activate_view(prompt_view_id);
      insert_line(prompt_string:+init_value);

   }

   activate_view(view_id);
   return(0);

/* END build_prompts */


}
_str next_multi_line_code(alias)
{
   start_col=1;
   if ( arg(2)!='' ) {
      valid_chars='[BbCcDdFfTtIiLlSsNnEe]';
   } else {
      valid_chars='[]';
   }
   for (;;) {

      if ( pos('{%(\\'valid_chars'|\([0-9a-zA-Z_]#\))}',alias,start_col,'r') ) {   /* HERE */
         end_col=pos('S0')-1;
         if ( end_col<start_col ) {
            return(start_col);
         }
         //end_length=1 + length(substr(alias,start_col)) - length(substr(alias,end_col))
         end_length=1 + end_col-start_col;
         level=0;
         temp=substr(alias,start_col,end_length);

         for (;;) {
            start_envvar= pos('%',temp,1);
            if (start_envvar) {
               p=pos('%',temp,start_envvar+1);
               if ( p ) {
                  temp=substr(temp,p+1);
                  continue;
               } else {
                  // Unfortunately, when envvars are processed, won't see this code
                  level=1;
                  break;
               }
            } else {
               break;
            }
         }
         // Unfortunately, when envvars are processed, won't see this code
         if ( level ) {
            start_col=end_col+2;   /* skip '%' */
            continue;
         } else {
            return(end_col+1);     /* it is a multi-line alias! */
         }
      } else {
         return(0);
      }

   }   /* outer loop */

   /* END next_multi_line_code */


}
static _str delete_multi_line_alias()
{
   for (;;) {
      _delete_line();

      if ( rc ) {
         /* at bottom of file */
         break;
      }

      if ( get_text():!=' ' ) {
         /* at end of multi-line alias */
         break;
      }

   }
   return(0);

   /* END delete_multi_line_alias */


}
static _delete_alias(name)
{
   aliasfilename='';
   find_status= find_alias2(name,old_view_id,
            alias_view_id,multi_line_flag,aliasfilename,alias_linenum,false);

   if ( find_status && find_status!=STRING_NOT_FOUND_RC ) {
      return(find_status);
   }
   /* If the alias was not found and the delete option was specified. */
   if ( find_status) {
      PreserveFocusMessageBox(nls('Alias "%s" not found',name));
      return(STRING_NOT_FOUND_RC);
   }
   if ( multi_line_flag ) {
      delete_multi_line_alias();
   } else {
      _delete_line();
   }
   status=save('',SV_OVERWRITE)
   if ( status ) {
      activate_view(old_view_id);
      return(status);
   }
   _delete_temp_view(alias_view_id);
   activate_view(old_view_id);
   return(0);
}
_str _get_ext_alias_filename()
{
   ext=p_extension;
   index=find_index("def-alias-"ext,MISC_TYPE);
   if (!index) {
      index=insert_name("def-alias-"ext,MISC_TYPE,ext".als");
   }
   filename=name_info(index);
   if (filename=="") {
      replace_name(index,"def-alias-"ext,ext".als");
      filename=name_info(index);
   }
   path=strip_filename(filename,"N");
   if (path=="") {
      filename=_config_path():+filename;
   }
   return(filename);
}
// Return 0 if successful
_command int alias() name_info(ALIAS_ARG',')
{
   temp._makeempty();
   params=arg(1);
   extension_alias_file_only=upcase(params)=="-E";
   if (params=="" || extension_alias_file_only) {
      if (extension_alias_file_only && p_view_id<0) {
         filename=_get_ext_alias_filename();
         temp:[filename]=filename;
      } else {
         aliasfilename=get_env(_SLICKALIAS);
         if (aliasfilename=="") {
            aliasfilename=_ALIAS_FILE;
         }
         for (;;) {
            parse aliasfilename with filename (PATHSEP) aliasfilename;
            if (filename=='') break;
            path=strip_filename(filename,"N");
            if (path=="") {
               filename=_config_path():+filename;
            }
            if (filename!="") {
               filename=_file_case(filename);
               temp:[filename]=filename;
            }
         }
         index=name_match("def-alias-",1,MISC_TYPE);
         for (;;) {
            if (!index) break;
            filename=name_info(index);
            index=name_match("def-alias-",0,MISC_TYPE);
            path=strip_filename(filename,"N");
            if (path=="") {
               filename=_config_path():+filename;
            }
            if (filename!="") {
               filename=_file_case(filename);
               temp:[filename]=filename;
            }
         }
      }


      // Count number of elements in hash table.
      typeless i,filename;
      for (count=0,i._makeempty();;++count) {
         p=&temp._nextel(i);
         if (i._isempty()) break;
         aliasfilename= *p;
      }
      if (count==0) {
         aliasfilename=_ALIAS_FILE;
      } else if (count==1) { // We already have the filename
      }else{
         result=show('-modal _sellist_form',
                     nls('Select Alias File'),
                     SL_SELECTCLINE,
                     temp,
                     '',                  // buttons
                     '',                  // help item name
                     ''                   // font
                     );
         if (result=='') {
            return(1);
         }
         aliasfilename=result;
      }
      show("-modal _alias_editor_form",aliasfilename);
      return(0);
   }
   multi_line_flag=0;
   parse params with delete_option rest;
   if ( lowcase(delete_option)=='-d' ) {
      params=rest;
   } else {
      delete_option='';
   }
   parse params with name ' ' content;
   name=prompt(name,nls('Alias name'));
   if (delete_option!='') {
      return(_delete_alias(name));
   }
   #if 1   /* HERE - 9/19/1995 - Fixed so that aliases defined with the
            *                    alias() command would NOT get defined in
            *                    the extension specific alias file
            */
   aliasfilename=next_alias_file(alias_filename('1'),1);
   #else
   aliasfilename='';
   #endif
   find_status= find_alias2(name,old_view_id,
            alias_view_id,multi_line_flag,aliasfilename,alias_linenum,false);

   if (find_status && find_status!=FILE_NOT_FOUND_RC && find_status!=STRING_NOT_FOUND_RC) {
      return(find_status);
   }
   p_view_id=old_view_id;
   if ( content=='') {
      if ( find_status ) {  // IF no alias file exists or alias not found
         init='';
      } else {
         _delete_temp_view(alias_view_id);
         p_view_id=old_view_id;
         if ( multi_line_flag ) {
            return(edit(maybe_quote_filename(aliasfilename)' -#'alias_linenum));
         } else {
            init=get_alias(name,multi_line_info,'0');
         }
      }
      if ( get_string(content,nls('Alias value:')' ',';.alias',init) ) {
         return(1);
      }
      _macro_delete_line();
      _macro_call('alias',name' 'content);
      aliasfilename=next_alias_file(alias_filename('1'),1);
      // Here we could add a check to make sure aliasfilename is ''
      // but this is unusual
      find_status= find_alias2(name,old_view_id,
               alias_view_id,multi_line_flag,aliasfilename,alias_linenum,false);
      if (find_status==FILE_NOT_FOUND_RC || find_status==STRING_NOT_FOUND_RC) {
         multi_line_flag=0;
         status2=_edit_first_alias_file(alias_view_id);
         if (status2 && status2!=NEW_FILE_RC) {
            return(status2);
         }
      } else if ( find_status ) {
         return(find_status);
      }
   } else {
      if (find_status==FILE_NOT_FOUND_RC || find_status==STRING_NOT_FOUND_RC) {
         multi_line_flag=0;
         status2=_edit_first_alias_file(alias_view_id);
         if (status2 && status2!=NEW_FILE_RC) {
            return(status2);
         }
      }
   }


   p_view_id=alias_view_id;

   /* If alias did not already exist, load first alias file. */
   if ( find_status ) {
      /* could be new file, string not found, or error loading file. */
      bottom;insert_line(name " "content);
   } else {
      /* we are replacing a multi-line alias */
      if ( multi_line_flag ) {
         delete_multi_line_alias();
         up   /* do NOT want to insert after the first line of multi-line alias */
         insert_line(name " "content);
      } else {
         replace_line(name " "content);
      }
   }
   status=_save_file('+o');
   buf_name=p_buf_name;
   _delete_temp_view(alias_view_id);
   if (status) {
      PreserveFocusMessageBox(nls("Unable to save '%s'.  "get_message(status),buf_name));
      p_view_id=old_view_id;
      return(status);
   }
   p_view_id=old_view_id;
   return(0)

}

//   ignore_not_found=arg(9)
static _str find_alias2(name,
                        var orig_view_id,var alias_view_id,
                        var multi_line_flag,
                        var alias_fn,var alias_linenum
                        ,boolean ignore_not_found)
{
   alias_view_id=0;alias_linenum=0;
   orig_view_id=p_view_id;
   multi_line_flag=0;
   if (alias_fn=='') {
      filename=next_alias_file(alias_filename(),1);
   }else{
      filename=alias_fn;
   }

   if ( filename=='' ) {
      if (!ignore_not_found) {
         PreserveFocusMessageBox(nls('Warning: No alias files found: %s',alias_filename()));
      }
      p_view_id=orig_view_id;
      return(FILE_NOT_FOUND_RC);
   }
   for (;;) {
      status=_open_temp_view(filename,alias_view_id,junk);
      if (status) {
         if ( status==FILE_NOT_FOUND_RC ) {
             if (!ignore_not_found) {
                PreserveFocusMessageBox(nls("Warning: Alias file '%s' not found",filename));
             }
         } else {
            PreserveFocusMessageBox(nls("Error loading alias file '%s'",filename)'. 'get_message(status));
         }
         p_view_id=orig_view_id;
         return(STRING_NOT_FOUND_RC);
      }
      top();
      if ( verify(name,FILESEP:+FILESEP2,'M') ) {
         status=STRING_NOT_FOUND_RC;
      } else {
         status=search('^'name'( |$|\()','r@'def_alias_case);
      }
      if ( ! status ) {
         alias_fn=p_buf_name;alias_linenum=p_line;
         /* check to see if we are deleting/replacing a multi-line alias */
         get_line(old_alias_line);
         parse old_alias_line with temp old_content;
         multi_line_flag=pos(temp,'(') || next_multi_line_code(old_content);
         if ( ! multi_line_flag ) {
            /* there are no codes on the first line, now check for multiple lines */
            down();
            if ( ! rc ) {
               get_line(line);
               if ( substr(line,1,1):==' ' ) {
                  multi_line_flag=1;
               }
               up();
            }
         }
         return(0);
      }
      clear_message();
      _delete_temp_view(alias_view_id);
      if (alias_fn!='') {
         p_view_id=orig_view_id;
         return(STRING_NOT_FOUND_RC);
      }
      filename=next_alias_file('',0)
      if ( filename=='' ) {
         p_view_id=orig_view_id;
         return(STRING_NOT_FOUND_RC);
      }
   }
}
static _str _edit_first_alias_file(var alias_view_id)
{
   // Do not get extension specific alias
   parse alias_filename(arg(3)) with filename (PATHSEP) .;
   if ( filename=='') {
      return(1);
   }
   first_ch=substr(filename,1,1);
   if ( (first_ch=='+' || first_ch=='-') && lowcase(substr(filename,2,1))=='r') {
       parse filename with . filename;
   }
   if ( filename!='' ) {
      status=_open_temp_view(filename,alias_view_id,orig_view_id);
      if ( status) {
         if (status==FILE_NOT_FOUND_RC) {
            orig_view_id=_create_temp_view(alias_view_id);
            //insert_line("");
            p_buf_name=filename;
            return(NEW_FILE_RC);
         } else {
            PreserveFocusMessageBox(nls("Unable to open '%s'.  "get_message(status),filename));
            return(status);
         }
      }
      return(0);
   }
   return(1);
}
_str alias_match(name,find_first)
{
   if ( find_first ) {
      if ( find_first:==2 ) {
         alias_match2('','',2)
         return('');
      }
      filename=next_alias_file(alias_filename(),1)
      if ( filename=='' ) {
         status=load_files('+c +t 'filename);
         if ( status ) {
            stop();
         }
         _prev_view();
         messageNwait(nls('No alias files found: %s',alias_filename()))
         return('')
      }
   }
   for (;;) {
      /* filename does not have to be initialized unless find_first=1 */
      found_name=alias_match2(filename,name,find_first);
      if ( found_name!='' ) {
         /* messageNwait('filename='filename' found_name='found_name' findfirst='find_first) */
         return(found_name);
      }
      filename=next_alias_file(alias_filename(),0)
      if ( filename=='' ) {
         return('');
      }
      /* Remove the previous file. */
      alias_match2('','',2);
      find_first=1;
   }


}
static _str alias_match2(filename,name,find_first)
{
   name=translate(name,'_','-');
   if ( find_first ) {
      if ( find_first==2 ) {
         clear_message();
         _next_view();
         _delete_buffer();_quit_view();
         return('')
      }
      load_files('+c +d 'maybe_quote_filename(filename));
      if ( rc ) {
         if ( rc==NEW_FILE_RC ) {
            messageNwait(nls("Alias file '%s' not found. Hit a key",filename));
         } else {
            messageNwait("Error loading alias file '"filename"'. Hit a key");
            load_files('+c +t 'alias_filename());
            if ( rc ) {
               stop();
            }
         }
         _prev_view();
         return('');
      }
      if ( name=='' ) {
         search('^[~ ]','ri');
      } else {
         search('^'name,'ri');
      }
   } else {
      _next_view();
      repeat_search();
   }
   for (;;) {
      if ( rc ) {
         _prev_view();
         return('');
      }
      get_line(line);
      parse line with alias_name alias;
      parse alias_name with alias_name'(';
      alias_name=strip(alias_name);
      part=substr(alias_name,1,length(name))
      if ( name:==part ) {
         break
      }
      if ( !stricmp(name,part) && def_alias_case:!='e' ) {
         break
      }
      repeat_search();
   }
   _prev_view
   return(alias_name)

}
static void PreserveFocusMessageBox(text)
{
   focus_wid=_get_focus();
   if (arg(3)=='') {
      _message_box(text,arg(2));
   } else {
      _message_box(text,arg(2),arg(3));
   }
   if (focus_wid) {
      focus_wid._set_focus();
   }
}
