/*
$VerboseHistory: assocft.e$
*/

/*
12:54pm 9/3/1998

After some snooping, I found out that these are the items that NT 5.0
adds to the registry when it puts a new type in.  If you don't do all of
these, you don't seem to get the icons for the associated files.

Notes:
@ is the "Default Value" entry for the key

"efile" would really be "VisualSlickEdit", or some other appropriate name

-DWH

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.e]
@="efile"

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\efile]
@="Visual SlickEdit"
"EditFlags"=hex:00,00,00,00

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\efile\DefaultIcon]
@="E:\\vslick40\\win\\vs.exe,0"

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\efile\Shell]
@=""

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\efile\Shell\open]
"EditFlags"=hex:01,00,00,00

[HKEY_LOCAL_MACHINE\SOFTWARE\Classes\efile\Shell\open\command]
@="E:\\vslick40\\win\\vs.exe %1"

*/
#include "slick.sh"

#define WANT_BATCH_PROGRAM 1
#define FORM_NAME "tempfiletypes_forms"
_form tempfiletypes_forms {
   p_backcolor=0x80000005
   p_border_style=BDS_DIALOG_BOX
   p_caption='Associate File Types'
   p_clip_controls=FALSE
   p_forecolor=0x80000008
   p_height=5220
   p_width=6090
   p_x=8445
   p_y=75
   _label  {
      p_alignment=AL_LEFT
      p_auto_size=TRUE
      p_backcolor=0x80000005
      p_border_style=BDS_NONE
      p_caption='File Extensions:'
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=195
      p_tab_index=1
      p_width=1095
      p_word_wrap=FALSE
      p_x=150
      p_y=105
   }
   _list_box ctllist {
      p_auto_size=TRUE
      p_backcolor=0x80000005
      p_border_style=BDS_FIXED_SINGLE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=4740
      p_multi_select=MS_EXTENDED
      p_scroll_bars=SB_VERTICAL
      p_tab_index=2
      p_tab_stop=TRUE
      p_width=1440
      p_x=150
      p_y=375
      p_eventtab2=_ul2_listbox
   }
   _command_button ctlok {
      p_cancel=FALSE
      p_caption='OK'
      p_default=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=360
      p_tab_index=3
      p_tab_stop=TRUE
      p_width=1005
      p_x=1830
      p_y=345
   }
   _command_button command2 {
      p_cancel=TRUE
      p_caption='Cancel'
      p_default=FALSE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=360
      p_tab_index=4
      p_tab_stop=TRUE
      p_width=1005
      p_x=1830
      p_y=825
   }
   _command_button ctlselectall {
      p_cancel=FALSE
      p_caption='&Select All'
      p_default=FALSE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=360
      p_tab_index=5
      p_tab_stop=TRUE
      p_width=1005
      p_x=1830
      p_y=1305
   }
   _command_button ctladd {
      p_cancel=FALSE
      p_caption='&Add'
      p_default=FALSE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=360
      p_tab_index=6
      p_tab_stop=TRUE
      p_width=1005
      p_x=1830
      p_y=1785
   }
   _label  {
      p_alignment=AL_LEFT
      p_auto_size=FALSE
      p_backcolor=0x80000005
      p_border_style=BDS_SUNKEN
      p_caption="This dialog box sets up extensions for Windows Explorer and File Manager to run Visual SlickEdit when you double click on a specific file type.\r\rSelect one or more extensions in the File Extensions list box, and Click on the OK button to associate these file types with Visual SlickEdit.\r\rUse Ctrl+Click to select multiple extensions.\r\rWe recommend that you associate e (macro), sh (macro), vpj (project), slk (data), and vlx (color coding) files to Visual SlickEdit."
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=4755
      p_tab_index=9
      p_width=2790
      p_word_wrap=TRUE
      p_x=3150
      p_y=345
   }
}
#define VSFILE_TYPES "vpj slk vlx e sh"
#define COMMON_TYPES "vpj slk vlx for f cob cbl mod bas ada pl awk cmd bat"

defeventtab tempfiletypes_forms
void ctladd.lbutton_up()
{
   orig_wid=p_window_id;
   result = show('-modal _textbox_form',
                 'Add Extensions',      // Form caption
                 0,     //flags
                 '',    //use default textbox width
                 '',    //Help item.
                 '',    //Font (not yet supported)
                 '',    //Retrieve Name
                 'Extension(s):'
                 );

   if (result=='') return;
   p_window_id=orig_wid;
   for (;;) {
      parse _param1 with ext _param1;
      if (ext=="") break;
      if (substr(ext,1,1)==".") {
         ext=substr(ext,2);
      }
      ctllist._lbadd_item(ext);
      ctllist._lbselect_line(ext);
   }
   ctllist._lbsort();
   ctllist._remove_duplicates();
   ctllist.p_line=1;
}
ctlselectall.lbutton_up()
{
   ctllist._lbselect_all();
}

ctlok.on_create()
{
   absExeFilename=editor_name("p"):+strip_filename(editor_name("E"),'P');
   _registervs(absExeFilename);
   p_window_id=_control ctllist;
   index=name_match('def-setup-',1,MISC_TYPE);
   for (;;) {
     if ( ! index ) break;
     name=substr(name_name(index),11);
     if (lowcase(name)!='fundamental' && lowcase(name)!='process') {
      _lbadd_item(name);
     }
     index=name_match('def-setup-',0,MISC_TYPE);
   }
   list=COMMON_TYPES;
   for (;;) {
      parse list with extension list;
      if (extension=="") break;
      _lbadd_item(extension);
   }
   list=VSFILE_TYPES;
   for (;;) {
      parse list with extension list;
      if (extension=="") break;
      _lbtop();
      if (!_lbsearch(extension)) {
         _lbselect_line();
      }
   }

   _lbsort();
   _remove_duplicates();
   p_line=1;
}
ctlok.lbutton_up()
{
   if (_win32s()==1) {
      filename=_get_windows_directory()"win.ini";
   }
   p_window_id=_control ctllist;
   status=_lbfind_selected(1);
   for (;;) {
      if (status) break;
      ext=_lbget_text();
      if (_win32s()==1) {
         new_value=editor_name("E")" ^."ext;
         _ini_set_value(filename,"Extensions",ext,new_value);
      } else {
         _associatefiletypetovs(ext);
      }
      status=_lbfind_selected(0);
   }
   p_active_form._delete_window(1);
}
#if WANT_BATCH_PROGRAM
defmain()
{
   show("-modal "FORM_NAME);
   index=find_index(FORM_NAME,oi2type(OI_FORM));
   delete_name(index);
}
#endif
