/*
$VerboseHistory: briefutl.e$
*/
#include 'slick.sh'
#define S_ARG 'S'
_str s_match(name,find_first)
{
   name=f_match(name,find_first)
   for (;;) {
      if ( name=='' ) {
         return('')
      }
      if ( file_eq('.'get_extension(name),_macro_ext) ) {
         break
      }
      name=f_match(name,0)
   }
   return name

}
_command brief_delete() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      return(linewrap_delete_char())
   }
   if ( _select_type()!='' ) {
      _get_selinfo first_col,last_col,buf_id
      if ( buf_id==p_buf_id ) {
         return(delete_selection());
      }
   }
   linewrap_delete_char()

}
_command brief_paste() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_CLIPBOARD)
{
   mark=_duplicate_selection()
   if ( mark<0 ) {
      return(mark)
   }
   old_mark=_duplicate_selection('')
   _show_selection mark
   unmark_paste=def_deselect_paste;def_deselect_paste=0;
   last_index(find_index("brief_paste",COMMAND_TYPE));
   status=paste();
   def_deselect_paste=unmark_paste
   if ( ! status ) {
      if ( ! command_state() ) {
         if(!(_process_info('b') && p_line==p_Noflines) ) {
            if ( _select_type()=='LINE' || _select_type()=='BLOCK' ) {
               down
               if ( rc ) {
                  col=p_col
                  insert_line ''
                  p_col=col
               }
            }
            if ( _select_type()=='BLOCK' ) {
               _get_selinfo first_col,last_col,junk
               p_col=first_col
            }
         }
      }
   }
   if ( def_deselect_paste ) {
      _show_selection old_mark
      _free_selection mark
      if ( def_persistent_select=='D' ) {
         _deselect
      }
   } else {
      _free_selection old_mark
   }
   return(status)

}
_command brief_tab() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      maybe_list_matches('','','1')
      return(0)
   }
   if ( _select_type()!='' ) {
      _get_selinfo first_col,last_col,buf_id
      if ( buf_id==p_buf_id ) {
         indent_selection()
         return(0)
      }
   }
   if ( _insert_state() ) {
      move_text_tab()
   } else {
      init_command_op()
      ptab()
      retrieve_command_results()
   }

}
static _str homeend_count=0;
_command brief_home() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      return(begin_line())
   }
   index=last_index('','C')
   first=name_name(prev_index('','C'))!='brief-home'
   if (first || homeend_count>=3) {
      homeend_count=0;
   }
   ++homeend_count;
   _macro_delete_line()
   switch (homeend_count) {
   case 1:
      _macro_call('begin_line')
      begin_line();
      break;
   case 2:
      _macro_call('top_of_window')
      top_of_window();
      break;
   case 3:
      _macro_call('top_of_buffer')
      top_of_buffer();
      break;
   }
   last_index(index,'C')
}
_command brief_end() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      return(end_line())
   }
   index=last_index('','C')
   first=name_name(prev_index('','C'))!='brief-end'
   if (first || homeend_count>=3) {
      homeend_count=0;
   }
   ++homeend_count;
   _macro_delete_line()
   switch (homeend_count) {
   case 1:
      _macro_call('end_line')
      end_line();
      break;
   case 2:
      _macro_append('bottom_of_window();_end_line();');
      bottom_of_window();_end_line();
      break;
   case 3:
      _macro_call('bottom_of_buffer')
      bottom_of_buffer();
      break;
   }
   last_index(index,'C')
}
_command prompt_load() name_info(S_ARG',')
{
   _macro('m',_macro())
   load('<')

}
_command save_exit()
{
   status=save_all()
   if ( status ) {
      return(status)
   }
   return(safe_exit())

}
static _str deselect_or_switch(type,...)
{
   _cua_select=0
   if ( _select_type()=='' ) {
      return(0)
   }
   col=p_col
   _get_selinfo start_col,end_col,buf_id
   if ( buf_id!=p_buf_id ) {
      _deselect;return(0)
   }
   if ( _select_type()==type && (arg(2)=='' || _select_type('','I')==arg(2)) ) {
      _deselect;return(1)
   }
   _select_type("","T",type);
   return(0);
}
static _str _brief_mstyle()
{
   if ( pos('C',def_select_style,1,'I') ) {
      return('C':+def_advanced_select)
   } else {
      return('E':+def_advanced_select)
   }

}
_command brief_select_char() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( deselect_or_switch('CHAR','0') ) { return(0) }
   _select_char '',_brief_mstyle()'N'

}
_command brief_iselect_char() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( deselect_or_switch('CHAR','1') ) { return(0) }
   _select_char '',_brief_mstyle()'I'

}
_command brief_select_block() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( deselect_or_switch('BLOCK') ) { return(0) }
   _select_block '',_brief_mstyle()

}
_command brief_select_line() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( deselect_or_switch('LINE') ) { return(0) }
   _select_line '',_brief_mstyle()

}
_command right_side_of_window() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   old_scroll=_scroll_style()
   _scroll_style('S 0')
   orig_left_edge=p_left_edge;
   p_cursor_x=p_client_width-1
   while (p_left_edge!=orig_left_edge) {
      --p_col;
      set_scroll_pos orig_left_edge,p_cursor_y
   }
   _scroll_style(old_scroll)
}
_command left_side_of_window() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   p_cursor_x=0
}
// When quiting a file in BRIEF, the next file becomes active
_command void brief_quit() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (def_one_file!='') {
      orig_wid=p_window_id;
      next_buffer();
      next_wid=p_window_id;
      p_window_id=orig_wid;
      quit();
      if (p_window_id!=orig_wid && next_wid!=orig_wid) p_window_id=next_wid;
      return;
   }
   orig_buf_id=p_buf_id;
   next_buffer();
   next_buf_id=p_buf_id;
   p_buf_id=orig_buf_id;
   quit();
   if (p_buf_id!=orig_buf_id && next_buf_id!=orig_buf_id) p_buf_id=next_buf_id;
}
_command brief_save() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   if ( _select_type()!='' ) {
      _get_selinfo first_col,last_col,buf_id
      if ( buf_id==p_buf_id ) {
         return(gui_write_selection())
#if 0
         _macro_delete_line()
         status=0
         line=arg(1)
         if (line=='') {
            status=get_string(line,nls('Write mark:')' ','-.put')
            if ( status ) {
               return(COMMAND_CANCELLED_RC)
            }
         }
         _macro_call('put',line)
         status=put(line,PAUSE_COMMAND)
         if ( ! status ) {
            _deselect
         }
         return(status)
#endif
      }
   }
   if ( ! p_modify ) {
       message nls('File not modified.  Nothing saved.')
       return(1)
   }
   return(save())
}
_command void keyin_brace() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   keyin("{");
}
