/*
$VerboseHistory: cbrowser.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:55a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:44a
 * Comment:
 * Enhanced tagging
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:24p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"   

//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Tag file categories, there are two types of tag files, project tag
// files, and global tag files.
//
#define CB_project_tag_file "Project"
#define CB_global_tag_file  "Global"

//////////////////////////////////////////////////////////////////////////////
// Code categories, every global tag goes into one of these
// categories.  Tags that are not in the global scope go under
// their respective class (in classes, structures, packages, etc).
//
#define CB_packages    "Packages/Units"
#define CB_classes     "Classes"
#define CB_misc        "Miscellaneous"

struct CB_TAG_CATEGORY {
   typeless tag_types[];          // either int (VS_TAGTYPE_*) or 
                                  // a string (user defined type)
   int     sequence_number;       // sequence number, for sorting
   int     flag_mask;             // AND'd with tag's flags
   boolean mask_nzero;            // should result be 0 or !=0?
   boolean use_package_separator; // use package or class sep here?
   boolean level3_inheritance;    // enable inheritance tree at level 3
   boolean level4_inheritance;    // enable inheritance tree at level 4
   boolean is_container;          // are the items in this ctg containers?
   boolean remove_duplicates;     // remove duplicate captions under this category?
};

static struct CB_TAG_CATEGORY gh_cb_categories:[] = {
   "Programs" => {
      {VS_TAGTYPE_program},
      1, 0, false, true, true, false, true, false
   },
   "Libraries" => {
      {VS_TAGTYPE_library},
      2, 0, false, true, true, false, true, false
   },
   CB_packages => {
      {VS_TAGTYPE_package},
      3, 0, false, true, true, true, true, true
   },
   "Interfaces" => {
      {VS_TAGTYPE_interface},
      4, 0, false, false, true, true, true, false
   },
   CB_classes => {               
      {VS_TAGTYPE_class},
      5, 0, false, false, true, true, true, false
   },
   "Structures" => {
      {VS_TAGTYPE_struct},
      6, 0, false, false, true, true, true, false
   },
   "Unions" => {
      {VS_TAGTYPE_union},
      7, 0, false, false, false, false, true, false
   },
   "Enumerated Types" => {
      {VS_TAGTYPE_enum},
      8, 0, false, false, false, false, true, false
   },
   "Tasks" => {
      {VS_TAGTYPE_task},
      9, 0, false, false, false, false, true, false
   },
   "Global Functions" => {
      {0, VS_TAGTYPE_proc, VS_TAGTYPE_proto, VS_TAGTYPE_function},
      10, VS_TAGFLAG_static, false, false, false, false, false, true
   },
   "Static Functions" => {
      {0, VS_TAGTYPE_proc, VS_TAGTYPE_proto, VS_TAGTYPE_function},
      11, VS_TAGFLAG_static, true, false, false, false, false, true
   },
   "Global Variables" => {
      {VS_TAGTYPE_gvar},
      12, VS_TAGFLAG_static, false, false, false, false, false, false
   },
   "Static Variables" => {
      {VS_TAGTYPE_gvar},
      13, VS_TAGFLAG_static, true, false, false, false, false, false
   },
   "Type Definitions" => {
      {VS_TAGTYPE_typedef},
      14, 0, false, false, false, false, false, false
   },
   "Defines" => {
      {VS_TAGTYPE_define},
      15, 0, false, false, false, false, false, false
   },
   "Constants" => {
      {VS_TAGTYPE_constant},
      16, 0, false, false, false, false, false, false
   },
   "Properties" => {
      {VS_TAGTYPE_property},
      17, 0, false, false, false, false, false, false
   },
   "Database Objects" => {
      {VS_TAGTYPE_database},
      18, 0, false, false, false, false, true, false
   },
   "GUI Objects" => {
      {VS_TAGTYPE_form,VS_TAGTYPE_menu,VS_TAGTYPE_control},
      19, 0, false, false, false, false, true, false
   },
   "GUI Event Tables" => {
      {VS_TAGTYPE_eventtab},
      20, 0, false, false, false, false, true, false
   },
   CB_misc => {
      {-1},
      21, 0, false, false, false, false, false, false
   },
};


//////////////////////////////////////////////////////////////////////////////
// String appended to a category name to indicate that it is only a partial
// list of items.  Delimeter used between category name and "PARTIAL LIST".
#define CB_partial    "PARTIAL LIST"
#define CB_delimeter  "..."
#define CB_empty      "EMPTY"

//////////////////////////////////////////////////////////////////////////////
// Window id's for class browser related forms
//
static int gtbprops_wid;     // wid of _tbprops_form
static int gcbparents_wid;   // wid of _cbparents_form
static int gcboptions_wid;   // wid of _cboptions_form
static int gtbproject_wid;   // wid of _tbproject_form

//////////////////////////////////////////////////////////////////////////////
// Tab index of the class browser on the project toolbar.
//
#define CB_BROWSER_TAB_INDEX 2

//////////////////////////////////////////////////////////////////////////////
// Tab indexes of the tabs on the tag properties toolbar
//
#define CB_PROPERTIES_TAB_INDEX 0
#define CB_ARGUMENTS_TAB_INDEX  1
#define CB_REFERENCES_TAB_INDEX 2
#define CB_CALLSUSES_TAB_INDEX  3

//////////////////////////////////////////////////////////////////////////////
// Timer used for delaying updates after change-selected events,
// allowing you to quickly scroll through the items in the class browser.
// It is safer for this to global instead of static.
//
#define CB_TIMER_DELAY_MS 200
int gClassBrowserTimerId=-1; 

//////////////////////////////////////////////////////////////////////////////
// Fudge factor used when calculating text column widths
//
#define CB_TEXT_WIDTH_MARGIN 200

//////////////////////////////////////////////////////////////////////////////
// Temporary used for expand/collapse operations.  Prior to expanding
// an item, we iterate through the items in the list, deleting the leaves,
// and hashing the captions and tree indexes of the interior nodes into
// this table.  When inserting the new items into the tree, we first check
// if the target caption is in this table, and if so, simply delete it
// from the hash table instead of inserting a new copy into the tree.
// After everything has been inserted, we iterate through what remains in
// this structure and delete them from the tree.
//
//static int gh_captions_index_map:[][];

//////////////////////////////////////////////////////////////////////////////
// Temporary used when inserting inherited members
// Prevents us from doing the same parent class twice
//
static int gh_classes_visited:[];


//////////////////////////////////////////////////////////////////////////////
// Built-in limits for class browser
//
#define CB_MAX_REFERENCES        0x400     // 1024    -- max references to list
#define CB_MAX_LINE_NUMBER       0x100000  // 1048576 -- lines per file
#define CB_MAX_FILE_NUMBER       0x10000   // 65536   -- file ID
#define CB_MAX_INHERITANCE_DEPTH 0x20      // 32/CB   -- max depth of inheritance tree

#define CB_LOW_WATER_MARK          1000    // 1000    -- max items to refresh
#define CB_HIGH_WATER_MARK         2000    // 2000    -- max items to insert w/o prompting
#define CB_FLOOD_WATER_MARK        8000    // 8000    -- max items to insert w/o prompting twice
#define CB_NOAHS_WATER_MARK      100000    // 100000  -- max items to insert under a category

int def_cb_low_refresh    = CB_LOW_WATER_MARK;
int def_cb_high_refresh   = CB_HIGH_WATER_MARK;
int def_cb_flood_refresh  = CB_FLOOD_WATER_MARK;
int def_cb_max_references = CB_MAX_REFERENCES;

//////////////////////////////////////////////////////////////////////////////
// Bit combinations representing class browser options (see options dialog).
// A mask is composed for each tag inserted based on these bit combinations
// and then compared with the filtering options masks.
// If the options do not match up, the tag is filtered out.
//
#define CB_SHOW_class_data           0x00000001
#define CB_SHOW_instance_data        0x00000002
#define CB_SHOW_out_of_line          0x00000004
#define CB_SHOW_inline               0x00000008
#define CB_SHOW_static               0x00000010
#define CB_SHOW_non_virtual          0x00000020
#define CB_SHOW_virtual              0x00000040
#define CB_SHOW_abstract             0x00000080
#define CB_SHOW_operators            0x00000100
#define CB_SHOW_constructors         0x00000200
#define CB_SHOW_final_members        0x00000400
#define CB_SHOW_non_final_members    0x00000800
#define CB_SHOW_const_members        0x00001000
#define CB_SHOW_non_const_members    0x00002000
#define CB_SHOW_volatile_members     0x00004000
#define CB_SHOW_non_volatile_members 0x00008000
#define CB_SHOW_template_classes     0x00010000
#define CB_SHOW_non_template_classes 0x00020000
#define CB_SHOW_package_members      0x00040000
#define CB_SHOW_private_members      0x00080000
#define CB_SHOW_protected_members    0x00100000
#define CB_SHOW_public_members       0x00200000
#define CB_SHOW_inherited_members    0x00400000
#define CB_SHOW_class_members        0x00800000
#define CB_SHOW_data_members         0x01000000
#define CB_SHOW_other_members        0x02000000
#define CB_SHOW_non_abstract         0x04000000
#define CB_SHOW_non_special          0x08000000
#define CB_SHOW_transient_data       0x10000000
#define CB_SHOW_persistent_data      0x20000000
#define CB_SHOW_synchronized         0x40000000
#define CB_SHOW_non_synchronized     0x80000000
#define CB_QUALIFIERS                0xffffffff

#define CB_SHOW_native               0x00000001
#define CB_SHOW_non_native           0x00000002
#define CB_SHOW_extern               0x00000004
#define CB_SHOW_non_extern           0x00000008
#define CB_SHOW_macros               0x00000010
#define CB_SHOW_non_macros           0x00000020
#define CB_SHOW_anonymous            0x00000040
#define CB_SHOW_non_anonymous        0x00000080
#define CB_QUALIFIERS2               0x000000ff

//////////////////////////////////////////////////////////////////////////////
// Bit combinations representing properties display options for Uses tab
//
#define CBP_SHOW_procs    0x0001
#define CBP_SHOW_classes  0x0002
#define CBP_SHOW_vars     0x0004
#define CBP_SHOW_misc     0x0008

//////////////////////////////////////////////////////////////////////////////
// These globals are used only for comparing values when refreshing
// the class browser.  It allows us to compare the new settings with
// the old and avoid expensive refreshes if possible.
// 
static  int gi_sort_by_line;        // sort by line number instead of name
static _str gz_class_filter;        // regular expression for class filter
static _str gz_member_filter;       // regular expression for method filter

//////////////////////////////////////////////////////////////////////////////
// The name of a member/caption to be excluded from filtering so that
// restore_position can force the member to show up in the class browser.
// This is allowed only in restore_position.
//
static _str gz_exception_name;

//////////////////////////////////////////////////////////////////////////////
// Global flags indicating that we are in an un-interuptable refresh
// operation and if a refresh is needed for a dormant (hidden) class  
// browser.
//
static int gi_in_refresh=0;
static int gi_need_refresh=0;

//////////////////////////////////////////////////////////////////////////////
// Access levels for class members.  These constants are used to index into
// the array of pictures.  See gi_pic_access_type[][], below.
//
#define CB_access_public     0
#define CB_access_protected  1
#define CB_access_private    2
#define CB_access_package    3
#define CB_access_LAST       3

//////////////////////////////////////////////////////////////////////////////
// Picture types used for displaying different tag types.  Each tag maps
// on to one of these pictures.  The default picture is 'function', used
// for all un-identified tags.  These constants are used to index into
// the array of pictures.  See gi_pic_access_type[][], below.
//
// anything <= CB_TYPE_miscellaneous is a leaf
#define CB_type_function         0
#define CB_type_prototype        1
#define CB_type_data             2
#define CB_type_operator         3
#define CB_type_constructor      4
#define CB_type_destructor       5
#define CB_type_enumeration      6
#define CB_type_typedef          7
#define CB_type_define           8
#define CB_type_property         9
#define CB_type_constant        10
#define CB_type_label           11
#define CB_type_import          12
#define CB_type_friend          13
#define CB_type_index           14
#define CB_type_trigger         15
#define CB_type_control         16
#define CB_type_menu            17
#define CB_type_param           18
#define CB_type_proc            19
#define CB_type_procproto       20
#define CB_type_include         21
// 22--28 -- reserved for expansion
#define CB_type_miscellaneous   29
// anything >= CB_TYPE_struct is a container
#define CB_type_struct          30
#define CB_type_enum            31
#define CB_type_class           32
#define CB_type_template        33
#define CB_type_base_class      34
#define CB_type_package         35
#define CB_type_union           36
#define CB_type_database        37
#define CB_type_table           38
#define CB_type_form            39
#define CB_type_eventtab        40
#define CB_type_task            41
// 42--48 -- reserved for expansion
#define CB_type_misc            49
#define CB_type_LAST            49

//////////////////////////////////////////////////////////////////////////////
// Picture indexes used by class browser
//
static int gi_pic_proj_open;       // selected tag file (project)
static int gi_pic_proj_close;      // closed / not selected tag file
static int gi_pic_cat_open;        // selected tag category
static int gi_pic_cat_close;       // closed / not selected category

//////////////////////////////////////////////////////////////////////////////
// Two-dimensional array of picture indexes for different tag types
// and access levels.  The the correct way to index into this array
// is access major, type minor, eg.   gi_pic_access_type[i_access][i_type].
//
static int gi_pic_access_type[][];

//////////////////////////////////////////////////////////////////////////////
// Strings used in tag bitmap file names.  The naming convention is
// _clsXXXN.bmp, where XXX is the three letter code for this type
// (see gi_code_type), and N is the access level (see gi_code_access).
// 
#define CB_pic_class_prefix  '_cls'
#define CB_pic_bitmap        '.bmp'

struct CB_BITMAP_INFO {
   _str name;
   _str description;
   boolean global_only;
};

static CB_BITMAP_INFO gi_code_type[] = {
   {'fun','Function or class Method',false},        // CB_type_function         0   
   {'prt','Function or Method Prototype',false},    // CB_type_prototype        1
   {'dat','Member or local/global Variable',false}, // CB_type_data             2
   {'opr','Overloaded operator',false},             // CB_type_operator         3
   {'cns','Class Constructor',false},               // CB_type_constructor      4
   {'dst','Class Destructor',false},                // CB_type_destructor       5
   {'enm','Enumeration Constant',false},            // CB_type_enumeration      6
   {'typ','Type Definition',false},                 // CB_type_typedef          7
   {'def','Preprocessor Macro Definition',true},    // CB_type_define           8
   {'prp','Property',false},                        // CB_type_property         9
   {'con','Constant',false},                        // CB_type_constant        10
   {'lab','Label',true},                            // CB_type_label           11
   {'imp','Imports or Uses',true},                  // CB_type_import          12
   {'frn','Friend Relationship',true},              // CB_type_friend          13
   {'ndx','Database Index',true},                   // CB_type_index           14
   {'trg','Database Event Trigger',true},           // CB_type_trigger         15
   {'ctl','GUI Control or Widget',true},            // CB_type_control         16
   {'men','GUI Menu',true},                         // CB_type_menu            17
   {'prm','Function or Template Parameter',true},   // CB_type_param           18
   {'prc','Procedure or class Method',false},       // CB_type_proc            19
   {'ppt','Procedure or Method Prototype',false},   // CB_type_procproto       20
   {'inc','Includes or Depends on (with)',true},    // CB_type_include         21
   {'oth','',false},                                // reserved for expansion  22
   {'oth','',false},                                // reserved for expansion  23
   {'oth','',false},                                // reserved for expansion  24
   {'oth','',false},                                // reserved for expansion  25
   {'oth','',false},                                // reserved for expansion  26
   {'oth','',false},                                // reserved for expansion  27
   {'oth','',false},                                // reserved for expansion  28
   {'oth','Miscellaneous Item',false},              // CB_type_miscellaneous   29
   {'sts','Structure or Record',false},             // CB_type_struct          30
   {'ens','Enumerated Type',false},                 // CB_type_enum            31
   {'cls','Class',false},                           // CB_type_class           32
   {'tps','Template Class',false},                  // CB_type_template        33
   {'abs','Base Class',false},                      // CB_type_base_class      34
   {'pks','Package, Namespace or Unit',true},       // CB_type_package         35
   {'uns','Union or Variant',false},                // CB_type_union           36
   {'dbs','Database Schema',true},                  // CB_type_database        37
   {'tbl','Database Table or View',true},           // CB_type_table           38
   {'frm','GUI Form or Menu',true},                 // CB_type_form            39
   {'etb','GUI Event Table',true},                  // CB_type_eventtab        40
   {'tsk','Task or Thread',true},                   // CB_type_task            41
   {'mss','',false},                                // reserved for expansion  42
   {'mss','',false},                                // reserved for expansion  43
   {'mss','',false},                                // reserved for expansion  44
   {'mss','',false},                                // reserved for expansion  45
   {'mss','',false},                                // reserved for expansion  46
   {'mss','',false},                                // reserved for expansion  47
   {'mss','',false},                                // reserved for expansion  48
   {'mss','Miscellaneous Container',false},         // CB_type_misc            49
};

static CB_BITMAP_INFO gi_code_access[] = {
   {'0','Public or Global scope'}, // CB_access_public         0
   {'1','Protected Scope'},        // CB_access_protected      1
   {'2','Private scope'},          // CB_access_private        2
   {'3','Package scope'},          // CB_access_package        3
};


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Called when this module is loaded (before defload).  Used to
// initialize the timer variable and window IDs.
// 
definit()
{
   // IF editor is initalizing from invocation
   if (arg(1)!='L') {
      gClassBrowserTimerId=-1;
      gtbprops_wid=0;
      gcbparents_wid=0;
      gcboptions_wid=0;
      gtbproject_wid=0;
      gz_exception_name='';
      gz_class_filter='';
      gz_member_filter='';
      gi_in_refresh=0;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Called when this module is loaded (after definit).  Used to
// correctly initialize the window IDs (if those forms are available),
// and loads the array of pictures used for different tag types.
//
defload()         
{
   _pic_file_d=_update_picture(-1,'_filed.bmp');
   // try to find the related forms
   gtbprops_wid    = _find_formobj("_tbprops_form","n");
   gcbparents_wid  = _find_formobj("_cbparents_form","n");
   gcboptiosn_wid  = _find_formobj("_cboptions_form","n");
   gtbproject_wid  = _find_formobj("_tbproject_form","n");

   // project and category open/close pictures
   gi_pic_proj_open  = _pic_project;
   gi_pic_proj_close = _pic_fldclos;
   gi_pic_cat_open   = _pic_fldaop;
   gi_pic_cat_close  = _pic_fldclos;
   
   // pictures we have not yet loaded
   _str pics_not_loaded='';
   int result = 0;

   // loop through all access levels and tag picture types
   // and load the picture.  Substitute _pic_file for any
   // that fail to load.
   for (i=0; i<=CB_access_LAST; ++i) {
      zaccess = gi_code_access[i].name;
      zdesc   = gi_code_access[i].description;
      for (j=0; j<=CB_type_LAST; ++j) {
         if (i>0 && gi_code_type[j].global_only) {
            status = gi_pic_access_type[0][j];
         } else {
            ztype = gi_code_type[j].name;
            filename = CB_pic_class_prefix :+ ztype :+ zaccess :+ CB_pic_bitmap;
            status=_update_picture(-1,filename)
            if (status<0) {
               result = status;
               status = _pic_file;
               if (pics_not_loaded == '') {
                  pics_not_loaded = filename;
               } else {
                  pics_not_loaded = pics_not_loaded ', ' filename;
               }
            } else if (gi_code_type[j].description != '') {
               if (gi_code_type[j].global_only) {
                  descr = gi_code_type[j].description;
               } else {
                  descr = gi_code_type[j].description ', ' zdesc;
               }
               replace_name(status, filename, descr);  
            }
         }
         gi_pic_access_type[i][j] = status;
      }
   }

   // report any errors loading pictures.
   if (result) {
      _message_box(nls('Unable to load picture(s) "%s"',pics_not_loaded)'. 'get_message(result));
   }
}

//############################################################################
// function for selection bitmap given tag type and flags
// This function is not normally called for 'standard' tag types,
// icon selection for those is done in the tagsdb DLL, which delagates
// to this function if it cannot resolve the tag type.
//
int cb_select_icon(_str tag_type, int tag_flags)
{
   switch (tag_type) {
   case 'macro':
      return CB_type_define;
   case 'dd':
   case 'db':
   case 'dw':
      return CB_type_data;
   case 'equ':
      return CB_type_constant;
   default:
      break;
   }
   return CB_type_miscellaneous;
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// kill the existing class browser update timer
//
static void cb_kill_timer()
{
   //say("cb_kill_timer("gClassBrowserTimerId")");
   if (gClassBrowserTimerId != -1) {
      _kill_timer(gClassBrowserTimerId);
      gClassBrowserTimerId=-1;
   }
}

//////////////////////////////////////////////////////////////////////////////
// kill the existing class browser update timer
//
static void cb_start_timer(typeless timer_cb)
{
   if (gtbprops_wid || gcbparents_wid || _GetTagwinWID()) {
      gClassBrowserTimerId=_set_timer(CB_TIMER_DELAY_MS, timer_cb);
   }
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Event table for the _tbproject_form (which the class browser is in).
//
defeventtab _tbproject_form.ctl_class_tree_view;

//////////////////////////////////////////////////////////////////////////////
// Keyboard shortcuts for all class browser menu options
//
def 'A-g'=cb_goto_proc;
def 'A-d'=cb_goto_decl;
def 'A-l'=cb_sortby_line;
def 'A-t'=cb_sortby_name;
def 'A-o'=cb_options;
def 'A-f'=cb_find;
def 'A-i'=gui_make_tags;
def 'A-e'=cb_expand_children;
def 'A-c'=cb_collapse;
def 'A-s'=cb_crunch;
def 'A-h'=cb_parents;
def 'A-p'=cb_props;
def 'A-a'=cb_args;
def 'A-r'=cb_references;
def 'A-u'=cb_calltree;

//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Event table for the _tbproject_form (which the class browser is in).
//
defeventtab _tbproject_form

//////////////////////////////////////////////////////////////////////////////
// Add keyboard bindings to menu items
//
static void menu_add_bindings(int menu_handle, _str cmd, _str cmd2, _str args)
{
   bindings = _mdi.p_child.where_is(cmd,2);
   if (bindings=='' && cmd2!='') {
      bindings = _mdi.p_child.where_is(cmd2,2);
   }
   if (bindings != '') {
      _menu_get_state(menu_handle, cmd:+args, flags, 'M', caption);
      parse caption with caption "\t" .;
      _menu_set_state(menu_handle, cmd:+args, flags, 'M', caption "\t" bindings);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Hide the given item(s)
//
static void menu_hide_item(int menu_handle, _str cat)
{
   status=_menu_find(menu_handle,cat,mh,mpos,'C');
   if (!status) {
     _menu_delete(mh,mpos);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle right-button released event, in order to display pop-up menu
// for the class browser.  Also responsible for graying inactive items
// depending where we are in the class browser tree.
//
void ctl_class_tree_view.rbutton_up()
{
   // kill the refresh timer, prevents delays before the menu comes
   // while the refreshes are finishing up.
   cb_kill_timer();

   // get the menu form
   index=find_index("_cbrowse_menu",oi2type(OI_MENU))
   if (!index) {
      return;
   }
   menu_handle=p_active_form._menu_load(index,'P');

   // blow away parts of the menu, depending on where
   // it is being shown from
   if (_get_focus() == gtbproject_wid.ctl_class_tree_view) {
   } else if (p_active_form == gcbparents_wid) {
      menu_hide_item(menu_handle, "expand");
      menu_hide_item(menu_handle, "collapseothers");
      menu_hide_item(menu_handle, "collapseall");
      menu_hide_item(menu_handle, "parents");
      menu_hide_item(menu_handle, "options");
   } else if (p_active_form == gtbprops_wid) {
      _menu_delete(menu_handle, 3); // Sort by
      menu_hide_item(menu_handle, "expand");
      menu_hide_item(menu_handle, "collapseothers");
      menu_hide_item(menu_handle, "collapseall");
      menu_hide_item(menu_handle, "options");
   } else if (p_active_form == gcboptions_wid) {
      _menu_delete(menu_handle, 3); // Sort by
      menu_hide_item(menu_handle, "declaration");
      menu_hide_item(menu_handle, "definition");
      menu_hide_item(menu_handle, "expand");
      menu_hide_item(menu_handle, "collapseothers");
      menu_hide_item(menu_handle, "collapseall");
      menu_hide_item(menu_handle, "options");
   } else {
      // don't know where we are
      return;
   }

   // get the id of the project form
   _nocheck _control ctl_class_tree_view;
   _nocheck _control ctl_class_filter_label;
   _nocheck _control ctl_member_filter_label;
   int f = gtbproject_wid;
   if (!f) return;

   // get position in tree control
   i = f.ctl_class_tree_view._TreeCurIndex();
   depth = (i<0)? 0 : f.ctl_class_tree_view._TreeGetDepth(i);

   // If a tag is not selected, disable tag operations.
   if ((depth <= 2) || (i == TREE_ROOT_INDEX)) {
      _menu_set_state(menu_handle, "properties", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "arguments", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "references", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "calltree", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "parents", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "declaration", MF_GRAYED, 'C');
      _menu_set_state(menu_handle, "definition", MF_GRAYED, 'C');
   }

   // If at first level below categories, disable inheritance
   // unless we are under structs, classes, or interfaces.
   if (depth == 3) {
      p = f.ctl_class_tree_view._TreeGetParentIndex(i);
      caption = f.ctl_class_tree_view._TreeGetCaption(p);
      parse caption with caption CB_delimeter .;
      CB_TAG_CATEGORY ctg;
      ctg = gh_cb_categories:[caption];
      if (ctg._isempty() || !ctg.level3_inheritance) {
         _menu_set_state(menu_handle, "parents", MF_GRAYED, 'C');
      }
   }

   // If at a second level below categories, disable inheritance unless
   // we are under structs, classes, interfaces, packages, programs, or libraries.
   if (depth == 4) {
      p = f.ctl_class_tree_view._TreeGetParentIndex(i);
      g = f.ctl_class_tree_view._TreeGetParentIndex(p);
      caption = f.ctl_class_tree_view._TreeGetCaption(g);
      parse caption with caption CB_delimeter .;
      CB_TAG_CATEGORY ctg;
      ctg = gh_cb_categories:[caption];
      if (ctg._isempty() || !ctg.level4_inheritance) {
         _menu_set_state(menu_handle, "parents", MF_GRAYED, 'C');
      }
   }

   // Gray goto-proc (goto_decl) if the current item is not a function
   show_children=0;
   caption = '';
   if (i>=0) {
      f.ctl_class_tree_view._TreeGetInfo(i, show_children);
      caption = f.ctl_class_tree_view._TreeGetCaption(i);
   }
   if (show_children >= 0 || pos("(", caption)==0) {
      _menu_set_state(menu_handle, "declaration", MF_GRAYED, 'C');
   }

   // stuff the key shortcut into the memu item for cb_find
   menu_add_bindings(menu_handle, 'cb_goto_decl', '', '');
   menu_add_bindings(menu_handle, 'cb_goto_def', '', '');
   menu_add_bindings(menu_handle, 'cb_find', 'cf', ' -');
   menu_add_bindings(menu_handle, 'gui_make_tags', '', '');
   menu_add_bindings(menu_handle, 'cb_parents', '', '');
   menu_add_bindings(menu_handle, 'cb_crunch', '', '');
   menu_add_bindings(menu_handle, 'cb_props', '', '');
   menu_add_bindings(menu_handle, 'cb_args', '', '');
   menu_add_bindings(menu_handle, 'cb_references', '', '');
   menu_add_bindings(menu_handle, 'cb_calltree', '', '');
   menu_add_bindings(menu_handle, 'cb_options', '', '');

   // set check marks depending on state of gi_sort_by_line
   if (gi_sort_by_line) {
      _menu_set_state(menu_handle, "sortline", MF_CHECKED, 'C');
   } else {
      _menu_set_state(menu_handle, "sortname", MF_CHECKED, 'C');
   }

   // set check marks depending on presence/absence of filters
   if (f.ctl_class_filter_label.p_visible) {
      _menu_set_state(menu_handle,"class",MF_CHECKED,'C');
   }
   if (f.ctl_member_filter_label.p_visible) {
      _menu_set_state(menu_handle,"member",MF_CHECKED,'C');
   }

   // Show the menu.
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   _KillToolTipMessages();
   status=_menu_show(menu_handle,flags,x,y)
   _menu_destroy(menu_handle);
}

//////////////////////////////////////////////////////////////////////////////
// Toggle display of class filter
//
_command cb_filterby_menu() name_info(','VSARG2_CMDLINE)
{
   if (arg(1)=='') {
      return '';
   }

   _nocheck _control ctl_class_filter_label;
   _nocheck _control ctl_member_filter_label;
   int f = gtbproject_wid;
   if (!f) {
      return '';
   }

   // based on menu selection
   switch (arg(1)) {
   case 'class':
      f.ctl_class_filter_label.p_user = (f.ctl_class_filter_label.p_user)? 0:1;
      break;
   case 'member':
      f.ctl_member_filter_label.p_user = (f.ctl_member_filter_label.p_user)? 0:1;
      break;
   case 'options':
      return cb_options();
   default:
      return '';
   }

   f.checkShowHideControls();
   return cb_refresh();
}

//////////////////////////////////////////////////////////////////////////////
// Reposition the controls depending on whether they want the member
// and class filters visible or not.
//
// Expects p_window_id to be the form containing the class browser
// and all class browser controls.
//
static void checkShowHideControls()
{
   _nocheck _control ctl_class_filter_combo_box;
   _nocheck _control ctl_member_filter_combo_box;
   _nocheck _control ctl_class_filter_label;
   _nocheck _control ctl_member_filter_label;
   _nocheck _control ctl_class_tree_view;
   _nocheck _control ctl_filter_check_box;

   // vertical margin
   int border_height = ctl_filter_check_box.p_y;

   // grab bit flags
   int show_class_filter  = ctl_class_filter_label.p_user;
   int show_member_filter = ctl_member_filter_label.p_user;

   if (show_class_filter != ctl_class_filter_combo_box.p_visible ||
       show_member_filter != ctl_member_filter_combo_box.p_visible) {

      // hide/show class filter
      ctl_class_filter_combo_box.p_visible = (show_class_filter)? 1:0;
      ctl_class_filter_label.p_visible     = (show_class_filter)? 1:0;
      
      // compute initial y position for class tree view
      int label_height = ctl_class_filter_combo_box.p_height + border_height;
      int tree_view_y = ctl_class_filter_combo_box.p_y;
      if (show_class_filter) {
         tree_view_y += label_height;
      }

      // hide/show member filter 
      ctl_member_filter_combo_box.p_visible = (show_member_filter)? 1:0;
      ctl_member_filter_label.p_visible     = (show_member_filter)? 1:0;
      
      // position the member filter, and maybe adjust position of tree view
      ctl_member_filter_combo_box.p_y = tree_view_y;
      ctl_member_filter_label.p_y     = tree_view_y;
      if (show_member_filter) {
         tree_view_y += label_height;
      }

      // compute the height of the project tabs
      // Find tab height and max tabs width:
      int i, tallest = 0;
      for (i=0; i<_proj_toolbar_sstab.p_NofTabs; i++) {
         _str text = _proj_toolbar_sstab._getTabInfo(i);
         parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
         tabHeight = _dy2ly(SM_TWIP,y2 - y1);
         if (tabHeight > tallest) tallest = tabHeight;
      }

      // compute the height for the tree control
      sstabH = _dy2ly(SM_TWIP,p_client_height) - 2*_proj_toolbar_sstab.p_y;
      ctl_class_tree_view.p_height = sstabH - tree_view_y - border_height*4 - tallest;
      ctl_class_tree_view.p_y      = tree_view_y;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Save the state of the class tree.  This is a recursive function whose
// output is a string (open_cats) which represents the set of open
// non-leaf nodes in the tree.  The syntax of the output string is:
//
//    c_1{s}c_2{s}...c_n{s}
//
// where 'c_i' is the caption of the tree item (pre-tab) and 's' is any
// string of the same form.
//
// p_window_id must be the class browser tree control.
//
static void save_class_tree_view(int i, _str parent, _str &open_cats)
{
   // search for member
   int child = _TreeGetFirstChildIndex(i);
   while (child > 0) {
      _TreeGetInfo(child, show_children);
      if (show_children > 0) {
         _str caption = _TreeGetCaption(child);
         parse caption with caption "\t" .;
         parse caption with caption CB_delimeter .;
         open_cats = open_cats :+ caption '{';
         save_class_tree_view(child, caption, open_cats);
         open_cats = open_cats '}';
      }
      child = _TreeGetNextSiblingIndex(child);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Compare the caption at tree index 'i' with the given caption string.
// Handles special cases of tabs and PARTIAL LISTs for categories.
// p_window_id must be the class browser tree control.
//
static int caption_is_equal(int i, _str &label)
{
   parse _TreeGetCaption(i) with caption "\t" .;
   parse caption with caption CB_delimeter .;
   parse caption with caption '(' .;
   parse label with label_no_paren '(' .;
   return (caption :== label_no_paren)? 1:0;
}

//////////////////////////////////////////////////////////////////////////////
// Remove entries from open categories string until synchronized on
// a closing brace.  This function is nearly identical in structure
// to restore_class_tree_view(), except that it does not interact with
// the tree at all.
//
static void strip_restore_error(_str &open_cats)
{
   // loop until we hit the end of the list
   while (pos("}", open_cats) != 1) {
      parse open_cats with label '{' open_cats;
      if (label == '') {
         return;
      }
      strip_restore_error(open_cats);
   }

   // clean up (remove trailing brace)
   if (pos("}", open_cats) == 1) {
     open_cats = substr(open_cats, 2);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Restores the state of the class tree.  This is a recursive function
// whose input (open_cats) is of the form described above in
// save_class_tree_view.  It parses the input string and opens
// tree nodes with matching headlines, causing them to be expanded
// in accordance with the current filtering options.
// p_window_id must be the class browser tree control.
//
static void restore_class_tree_view(int i, _str &open_cats)
{
   //say("restore_class_tree_view: i="i" open_cats="open_cats);
   int child = _TreeGetFirstChildIndex(i);

   // loop until we hit the end of the list
   while (pos("}", open_cats) != 1) {

      // get the item label to search for
      parse open_cats with label '{' open_cats;
      if (label == '') {
         return;
      }
   
      // search each child node (including the current child)
      while (child > 0) {
         _TreeGetInfo(child, show_children);
         if (show_children==0 && caption_is_equal(child,label)) {
            //say("Found: "label" index="child);
            call_event(CHANGE_EXPANDED,child,p_window_id,ON_CHANGE,'w')
            _TreeSetInfo(child, 1);
            restore_class_tree_view(child, open_cats);
            child = _TreeGetNextSiblingIndex(child);
            break;
         }
         child = _TreeGetNextSiblingIndex(child);
      }

      if (child <= 0 && open_cats != '' && pos("}", open_cats) != 1) {
         strip_restore_error(open_cats);
         child = _TreeGetFirstChildIndex(i);
      }
   }

   // clean up (remove trailing brace)
   if (pos("}", open_cats) == 1) {
     open_cats = substr(open_cats, 2);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Restores the position of the currently selected item in the
// class browser tree view.  The input is the form window ID and
// a comma separated list of captions.  This function may also
// be used to set the position of the class browser.  This is how
// cb_find (Find Tag) works.
//
// This function recursively tries all tree paths that match until
// it finds one that matches.  On exit it will return either
// -1, indicating that the item was not found, or the tree index
// of the item.  It is the caller's responsibility to set the current
// index in the tree control after calling this function.
//
// p_window_id must be the class browser tree control.
//
static int restore_position(int index, _str path)
{
   // boundary case, return if this is successful
   if (path=='') {
      return index;
   }

   // grab the first item off of the path
   //say('entering with--'path);
   parse path with label ',' path;

   // get first child of tree node 'index'
   int child, found_at;
   found_at = -1;
   child = _TreeGetFirstChildIndex(index);
   while (child > 0) {
      if (caption_is_equal(child, label)) {
         found_at = child;
         _TreeGetInfo(child, show_children);
         if (show_children == 0 && path != '') {                    
            //say(label '=========' path);
            parse path with caption ',' .;
            parse caption with gz_exception_name '(' .;
            call_event(CHANGE_EXPANDED,child,p_window_id,ON_CHANGE,'w')
            gz_exception_name = '';
         }
         result = restore_position(child, path);
         if (result >= 0) {
            //say('expanding--'label);
            if (show_children == 0 && path != '') {
               _TreeSetInfo(child, 1);
            }
            return result;
         }
      }
      child = _TreeGetNextSiblingIndex(child);
   }

   // maybe we had a category that broke into sections?
   depth = _TreeGetDepth(index);
   if (depth == 2) {
      first_char = substr(label, 1, 1) ':';
      child = _TreeSearch(index, first_char, 'PI');
      if (child > 0) {
         found_at = child;
         path = label :+ ((path=='')? '' : ',') :+ path;
         _TreeGetInfo(child, show_children);
         call_event(CHANGE_EXPANDED,child,p_window_id,ON_CHANGE,'w')
         result = restore_position(child, path);
         if (result >= 0) {
            //say('letter expanding--'label);
            if (show_children == 0 && path != '') {
               _TreeSetInfo(child, 1);
            }
            return result;
         }
      }
   }


   // bail out if we don't find a matching caption
   return found_at;
}

//////////////////////////////////////////////////////////////////////////////
// Save the current position of the class browser as a comma-separated
// list of captions appropriate for use with restore_position (above).
// p_window_id must be the class browser tree control.
//
static void save_position(_str &curr_path)
{
   // save the current position
   curr_path = '';
   int child = _TreeCurIndex();
   while (child > 0) {  
      _str caption = _TreeGetCaption(child);
      parse caption with caption "\t" .;
      parse caption with caption CB_delimeter .;
      if (curr_path != '') {
         curr_path = caption ',' curr_path;
      } else {
         curr_path = caption;
      }
      child = _TreeGetParentIndex(child);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Refresh the class tree view, starting at the given 'index' and doing
// everything below.  This is a recursive function, calling itself to
// refresh non-leaf children.  The function assumes that the tree index
// passed in is a tree index of a non-leaf tree node.
// p_window_id must be the class browser tree control.
//
static void refresh_class_tree_view(int index)
{
   // expand/close this tree item
   call_event(CHANGE_EXPANDED,index,p_window_id,ON_CHANGE,'w')

   // recursively refresh our children
   int child  = _TreeGetFirstChildIndex(index);
   while (child > 0) {
      _TreeGetInfo(child, show_children);
      if (show_children==1) {
         refresh_class_tree_view(child);
      } else if (show_children==0) {
         _TreeDelete(child, 'c');
      }
      child = _TreeGetNextSiblingIndex(child);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Refresh the inheritance and tag properties dialogs if they are up.
// p_window_id must be the class browser tree control.
//
static void refresh_dialog_views()
{
   // get the details about the current selection
   int currIndex = _TreeCurIndex();
   if (currIndex <= 0) {
      return;
   }
   show_children = 0;
   _TreeGetInfo(currIndex, show_children);
   struct VS_TAG_BROWSE_INFO cm;
   get_user_tag_info(currIndex, cm, false);

   // refresh the properties toolbar
   int f = gtbprops_wid;
   if (f) {
      cb_refresh_property_view(cm);
   }

   // refresh the inheritance tree
   f = gcbparents_wid;
   if (f) {
      if (show_children < 0) {
         int parentIndex = _TreeGetParentIndex(currIndex);
         get_user_tag_info(parentIndex, cm, false);
      }
      f.refresh_inheritance_view(cm);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Recursive function used by _TagFileModified_cbrowser (below) that
// handles updating items that were inherited from classes in another
// tag file that was modified.
// p_window_id must be the class browser tree control.
//
static void refresh_inherited_tags(int index, int prj_key)
{
   int child = _TreeGetFirstChildIndex(index);
   while (child > 0) {
      v = _TreeGetUserInfo(child);
      if (v._varformat()==VF_LSTR && isinteger(v)) {
         if ((v intdiv (CB_MAX_LINE_NUMBER*CB_MAX_FILE_NUMBER)) == prj_key) {
            refresh_class_tree_view(index);
            return;
         }
      }                        
      _TreeGetInfo(child, show_children);
      if (show_children==1) {
         refresh_inherited_tags(child, prj_key);
      } else if (show_children==0) {
         _TreeDelete(child, 'c');
      }
      child = _TreeGetNextSiblingIndex(child);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Refresh display for given tag file name.  This function handles both
// updating everything under the tag file that was modified, as well as
// updating items in other tag files that were inherited by this item.
//
void _TagFileModified_cbrowser(_str tag_db_name)
{
   int f = gtbproject_wid;
   if (!f) {
      return;
   }
   _nocheck _control _proj_toolbar_sstab;
   _nocheck _control ctl_class_tree_view;

   // blow out of here if we are not the active tab
   if (f._proj_toolbar_sstab.p_ActiveTab != CB_BROWSER_TAB_INDEX) {
      gi_need_refresh=1;
      return;
   }

   // make the class browser tree control the current object
   orig_wid = p_window_id;
   p_window_id = f.ctl_class_tree_view;
   gi_in_refresh = 1;

   // search for project
   int prj_index  = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (prj_index > 0) {
      _str caption = _TreeGetCaption(prj_index);
      parse caption with . ':' prj_db_name;
      if (file_eq(strip(prj_db_name), tag_db_name)) {
         break;
      }
      prj_index = _TreeGetNextSiblingIndex(prj_index);
   }
   if (prj_index < 0) {
      prj_index = 0;
   }

   // refresh the class tree view under this project
   _TreeGetInfo(prj_index, show_children);
   if (show_children==1) {
      refresh_class_tree_view(prj_index);
   }

   // refresh the class tree view for inherited members from this tag file
   int prj_key = _TreeGetUserInfo(prj_index);
   int index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (index > 0) {
      if (index != prj_index) {
         int count=0;
         int child = _TreeGetFirstChildIndex(index);
         while (child > 0 && ++count<8) {
            _TreeGetInfo(child, show_children);
            if (show_children==1) {
               refresh_inherited_tags(child, prj_key);
            }
            child = _TreeGetNextSiblingIndex(child);
         }
      }
      index = _TreeGetNextSiblingIndex(index);
   }

   gi_in_refresh = 0;
   p_window_id = orig_wid;
   return;
}

//////////////////////////////////////////////////////////////////////////////
// Update the list of tag files in the class browser tree
// p_window_id must be the class browser tree control.
//
static void refresh_tagfiles()
{
   // populate restoration hash table
   int count = 1;
   _TreeBeginUpdate(TREE_ROOT_INDEX);

   // put in the project tags file names
   _str tag_files = project_tags_filename();
   _str filename=next_tag_file(tag_files,true)
   while (filename != '') {
      i=add_tag_file(filename, CB_project_tag_file, ++count);
      filename=next_tag_file(tag_files,false)
   }

   // now put in the global tags file names
   tag_files = global_tags_filename();
   filename=next_tag_file(tag_files,true)
   while (filename != '') {
      i=add_tag_file(filename, CB_global_tag_file, ++count);
      filename=next_tag_file(tag_files,false)
   }

   // now put in the extension specific tags file names
   int array[];
   for (ff=1;;) {
      index=name_match('def-tagfiles-',ff,MISC_TYPE);ff=0;
      if (!index) {
         break;
      }
      if (name_info(index)!='') {
         array[array._length()]=index;
      }
   }
   for (i=0;i<array._length();i++) {
      index=array[i];
      parse name_name(index) with '-' . '-' ext;
      setup_index=find_index('def-setup-'ext,MISC_TYPE);
      parse name_info(setup_index) with . 'MN=' mode_name ',';
      tag_files=AbsoluteList(_replace_envvars(name_info(index)));
      filename=next_tag_file(tag_files,true)
      while (filename != '') {
         add_tag_file(filename, '"'mode_name'"', ++count);
         filename=next_tag_file(tag_files,false)
      }
   }

   //cb_remove_stale_items(TREE_ROOT_INDEX);
   _TreeEndUpdate(TREE_ROOT_INDEX); 
   _TreeSortUserInfo(TREE_ROOT_INDEX, 'N');
}

//////////////////////////////////////////////////////////////////////////////
// Refresh list of tag databases.  It uses prepare_for_expand() to set up
// a hash table of all the current tag database captions.  Tries to insert
// the new ones, and deletes all the stale items afterward.
//
void _TagFileAddRemove_cbrowser(_str file_name, _str options)
{
   int f = gtbproject_wid;
   if (!f) return;
   _nocheck _control ctl_class_tree_view;
   _nocheck _control _proj_toolbar_sstab;

   // blow out of here if we are not the active tab
   if (f._proj_toolbar_sstab.p_ActiveTab != CB_BROWSER_TAB_INDEX) {
      gi_need_refresh=1;
      return;
   }

   // refresh tag files
   f.ctl_class_tree_view.refresh_tagfiles();
}

//////////////////////////////////////////////////////////////////////////////
// Callback for refreshing the class browser, as required by the background
// tagging.  Since we handle the AddRemove and Modified callbacks, we don't
// have to do anything for refresh, we are already totally up-to-date.
//
void _TagFileRefresh_cbrowser()
{
   int f = gtbproject_wid;
   if (!f) return;
   _nocheck _control ctl_class_tree_view;
   _nocheck _control _proj_toolbar_sstab;

   // refresh tag files
   f.ctl_class_tree_view.refresh_tagfiles();
   f.ctl_class_tree_view.refresh_dialog_views();
}

//////////////////////////////////////////////////////////////////////////////
// Force a refresh of the class browser.
//
_command cb_refresh() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      return '';
   }

   gi_in_refresh = 1;
   f.ctl_class_tree_view._col_width(0,0);
   f.ctl_class_tree_view.refresh_class_tree_view(TREE_ROOT_INDEX);
   f.ctl_class_tree_view.refresh_dialog_views();
   gi_need_refresh = 0;
   gi_in_refresh = 0;
}

//////////////////////////////////////////////////////////////////////////////
// shortcuts for sort by line and short by name
//
_command cb_sortby_line() name_info(','VSARG2_EDITORCTL)
{
   cb_sortby_menu('sortline');
}
_command cb_sortby_name() name_info(','VSARG2_EDITORCTL)
{
   cb_sortby_menu('sortname');
}
//////////////////////////////////////////////////////////////////////////////
// Change gi_sort_by_line and force a refresh of the class browser
//
_command cb_sortby_menu() name_info(','VSARG2_EDITORCTL)
{
   if (arg(1)=='') {
      return '';
   }

   int f = gtbproject_wid;
   if (!f) {
      return '';
   }

   // based on menu selection
   switch (arg(1)) {
   case 'sortline':
      gi_sort_by_line = 1;
      break;
   case 'sortname':
      gi_sort_by_line = 0;
      break;
   default:
      return '';
   }

   return cb_refresh();
}

//////////////////////////////////////////////////////////////////////////////
// Retrieve and translate the class filter and member filter regular
// expressions.  If the input expression (p_text) contains vertical
// bars, open parentheses, or left curly braces, then do not perform
// translation.  The following translations are performed:
//    -- convert all comma's, semicolons, and spaces to | (OR)
//    -- eliminate adjacent vertical bars
//    -- For brief regular expressions, add grouping
//    -- For brief regular expression, shift BOL/EOL symbols to begin/end
//
// p_window_id must be the combo box containing the regular expression.
//
static _str cb_get_filter()
{
   if (p_visible) {
      _str re = p_text;
      if (!pos('|',re) && !pos('(',re) && !pos('{',re)) {
         s = strip(re);
         s = translate(s,'|||',';, ');
         s = stranslate(s,'|','[|][|]#', 'R');
         if (pos('|',s) && (def_re_search&BRIEFRE_SEARCH)) {
            s = '\(' :+ stranslate(s, '\)|\(', '|') :+ '\)';
         }
         return s;
      }
      return re;
   }
   return '';
}

//////////////////////////////////////////////////////////////////////////////
// right click callback for filtering options image, simply
// displays the options dialog.
// 
void ctl_filter_check_box.rbutton_up()
{
   cb_options();
}

//////////////////////////////////////////////////////////////////////////////
// single-click callback for filtering options image button,
// pick up new value of options and apply changes (if any)
//
void ctl_filter_check_box.lbutton_up()
{
   if (p_value) {
      ctl_class_filter_combo_box.p_text  = '';
      ctl_member_filter_combo_box.p_text = '';
   }
   cb_refresh();
}

//////////////////////////////////////////////////////////////////////////////
// 'enter' event handler for both the class filter or member filter
// combo-box controls.  Retrieves both filters and updates the class
// browser if either one of them has changed.
//
void ctl_class_filter_combo_box.enter()
{
   _nocheck _control ctl_class_filter_combo_box;
   _nocheck _control ctl_member_filter_combo_box;
   _nocheck _control ctl_class_tree_view;

   // for dialog box retrieval
   _append_retrieve(ctl_class_filter_combo_box, ctl_class_filter_combo_box.p_text);
   _append_retrieve(ctl_member_filter_combo_box, ctl_member_filter_combo_box.p_text);
   _save_form_response();

   // get the current filters
   c_filter = ctl_class_filter_combo_box.cb_get_filter();
   m_filter = ctl_member_filter_combo_box.cb_get_filter();
   if (c_filter :== gz_class_filter && m_filter :== gz_member_filter) {
      return;
   } else {
      gz_class_filter  = c_filter;
      gz_member_filter = m_filter;
   }

   // update the class browser (refreshs everything)
   cb_refresh();
}

//////////////////////////////////////////////////////////////////////////////
// Add a tag file to the tree control, return the new index
// p_window_id must be the class browser tree control.
//
static int add_tag_file(_str file_name, _str file_type, int sequence_number)
{
   // open the tag database for business
   int status = tag_read_db(file_name);
   if ( status ) {
      return(status);
   }

   // get tag file description
   _str caption = file_type ": " file_name;
   _str descr = tag_get_db_comment();
   if (descr != '') {
      caption = caption ' (' descr ')'
   }

   int j = _TreeAddItem(TREE_ROOT_INDEX, caption, TREE_ADD_AS_CHILD, gi_pic_proj_close, gi_pic_proj_open, 0);
   _TreeSetUserInfo(j, sequence_number);
   return j;
}

//////////////////////////////////////////////////////////////////////////////
// on form creation, popuplate the tree widget, set initial focus
//
void ctl_class_tree_view.on_create()
{
   gtbproject_wid=p_active_form;

   ctl_class_filter_label.p_user  = _retrieve_value("_tbproject_form.ctl_class_filter_label.p_visible");
   ctl_member_filter_label.p_user = _retrieve_value("_tbproject_form.ctl_member_filter_label.p_visible");
   ctl_filter_check_box._retrieve_value();
   ctl_class_filter_combo_box._retrieve_value();
   ctl_member_filter_combo_box._retrieve_value();
   ctl_class_filter_combo_box.p_cb_list_box._retrieve_list();
   ctl_member_filter_combo_box.p_cb_list_box._retrieve_list();
   gz_class_filter  = ctl_class_filter_combo_box.cb_get_filter();
   gz_member_filter = ctl_member_filter_combo_box.cb_get_filter();
   ctl_class_tree_view.p_user = _retrieve_value("_tbproject_form.ctl_class_tree_view");
   if (ctl_class_tree_view.p_user == "") {
      ctl_class_tree_view.p_user = 0xffffffff;
   }
   ctl_filter_check_box.p_user = _retrieve_value("_tbproject_form.ctl_filter_check_box.p_user");
   if (ctl_filter_check_box.p_user == "") {
      ctl_filter_check_box.p_user = 0xffffffff;
   }
   gi_sort_by_line = _retrieve_value("_cbrowse_menu.cb_sort_by_line");

   _str open_cats, curr_path;
   open_cats = _retrieve_value("_tbproject_form.ctl_member_filter_label");
   curr_path = _retrieve_value("_tbproject_form.ctl_class_filter_label");

   // insert items for each tag file
   ctl_class_tree_view.refresh_tagfiles();

   gi_in_refresh = 1;
   if (def_restore_flags & RF_CBROWSER_TREE) {
      ctl_class_tree_view.restore_class_tree_view(TREE_ROOT_INDEX, open_cats);
   }
   index = ctl_class_tree_view.restore_position(TREE_ROOT_INDEX, curr_path);
   if (index > 0) {
      ctl_class_tree_view._TreeSetCurIndex(index);
   }
   gi_in_refresh = 0;

   checkShowHideControls();
}

//////////////////////////////////////////////////////////////////////////////
// Called by the on_change event for _tbproject_form._proj_toobar_sstab
//
void cbrowser_on_expose()
{
   int f = gtbproject_wid;
   if (!f) {
      return;
   }
   _nocheck _control _proj_toolbar_sstab;

   // blow out of here if we are not the active tab
   if (f._proj_toolbar_sstab.p_ActiveTab != CB_BROWSER_TAB_INDEX) {
      return;
   }

   if (gi_need_refresh) {
      cb_refresh();
   }
}

//////////////////////////////////////////////////////////////////////////////
// Called when the class browser is resized (resize event for _tbproject_form)
//
void cbrowser_on_resize(int avail_width, int avail_height)
{
   int f = gtbproject_wid;
   if (!f) return;

   // available width, height, and amount of border
   border_width   = f.ctl_class_tree_view.p_x;
   border_height  = f.ctl_filter_check_box.p_y;
   avail_width    -= border_width;
   avail_height   -= border_height;

   // count the number of label/combo-boxes visible
   labels_visible=0;
   if (f.ctl_class_filter_label.p_visible) {
      labels_visible++;
   }
   if (f.ctl_member_filter_label.p_visible) {
      labels_visible++;
   }

   // adjust x position and width of filters
   f.ctl_filter_check_box.p_width = avail_width - border_width;
   label_w1    = f.ctl_class_filter_label.p_width;
   label_w2    = f.ctl_member_filter_label.p_width;
   label_width = (label_w1>label_w2)? label_w1:label_w2;
   label_height   = border_height + f.ctl_class_filter_combo_box.p_height;
   filter_x = label_width + 2*border_width;
   filter_w = avail_width - filter_x;
   f.ctl_class_filter_combo_box.p_x = filter_x;
   f.ctl_class_filter_combo_box.p_width = filter_w;
   f.ctl_member_filter_combo_box.p_x = filter_x;
   f.ctl_member_filter_combo_box.p_width = filter_w;
   label_y = f.ctl_class_filter_combo_box.p_y + labels_visible*label_height;

   // adjust the size and position the class tree view
   f.ctl_class_tree_view.p_y = label_y;
   f.ctl_class_tree_view.p_width  = avail_width - border_width;
   f.ctl_class_tree_view.p_height = avail_height - labels_visible*label_height - border_height*4 - f.ctl_filter_check_box.p_height;

   // adjust y position of member filter
   label_y -= label_height;
   f.ctl_member_filter_combo_box.p_y = label_y;
   f.ctl_member_filter_label.p_y     = f.ctl_member_filter_combo_box.p_y +
            (f.ctl_member_filter_combo_box.p_height - f.ctl_member_filter_label.p_height)/2;
}


//////////////////////////////////////////////////////////////////////////////
// Called by on_destroy event for _tbproject_form
//
void cbrowser_on_destroy()
{
   // get the window ID of the form
   int f = gtbproject_wid;
   if (!f) return;

   // save all the currently open categories
   _str open_cats = '';
   _str curr_path = '';
   f.ctl_class_tree_view.save_class_tree_view(TREE_ROOT_INDEX, '', open_cats);
   f.ctl_class_tree_view.save_position(curr_path);

   // save options and current position
   _nocheck _control ctl_member_filter_label;
   _nocheck _control ctl_class_filter_label;
   _append_retrieve(0, f.ctl_member_filter_label.p_user, "_tbproject_form.ctl_member_filter_label.p_visible");
   _append_retrieve(0, f.ctl_class_filter_label.p_user,  "_tbproject_form.ctl_class_filter_label.p_visible");
   _append_retrieve(f.ctl_member_filter_combo_box, f.ctl_member_filter_combo_box.p_text, "_tbproject_form.ctl_member_filter_combo_box");
   _append_retrieve(f.ctl_class_filter_combo_box,  f.ctl_class_filter_combo_box.p_text,  "_tbproject_form.ctl_class_filter_combo_box");
   _append_retrieve(0, f.ctl_class_tree_view.p_user, "_tbproject_form.ctl_class_tree_view" );
   _append_retrieve(0, f.ctl_filter_check_box.p_user, "_tbproject_form.ctl_filter_check_box.p_user" );
   _append_retrieve(0, open_cats, "_tbproject_form.ctl_member_filter_label" );
   _append_retrieve(0, curr_path, "_tbproject_form.ctl_class_filter_label" );
   _append_retrieve(0, gi_sort_by_line, "_cbrowse_menu.cb_sort_by_line" );
   _append_retrieve(0, f.ctl_filter_check_box.p_value, "_tbproject_form.ctl_filter_check_box");

   // reset the cached window ID's
   gtbproject_wid  = 0;
   gcbparents_wid  = 0;
   gcboptions_wid  = 0;
   //gtbprops_wid    = 0;
}

//////////////////////////////////////////////////////////////////////////////
// Decompose the typeless user data into database ID, file_id, and line_no
//
int cb_get_db_file_line(typeless value, int &db_id, int &file_id, int &line_no)
{
   if ((value._varformat()==VF_INT || value._varformat()==VF_LSTR) &&
       !value._isempty() && isnumber(value)) {

      // simple little computations
      line_no = value % CB_MAX_LINE_NUMBER;
      value   = value intdiv CB_MAX_LINE_NUMBER;
      file_id = value % CB_MAX_FILE_NUMBER;
      db_id   = value intdiv CB_MAX_FILE_NUMBER;
      return 0;
   }
   // invalid user info
   db_id=file_id=line_no=0;
   return 1;
}

//////////////////////////////////////////////////////////////////////////////
// grab the supplementary information stored with each tag in the tree widget
// p_window_id must be the class browser tree control.
//
static int get_user_tag_info(int j, struct VS_TAG_BROWSE_INFO &cm, boolean no_db_access)
{
   // initialize the structure
   cm.tag_database   = "";
   cm.category       = "";
   cm.class_name     = "";
   cm.member_name    = "";
   cm.qualified_name = "";
   cm.type_name      = "";
   cm.file_name      = "";
   cm.line_no        = 0;
   cm.flags          = 0;
   cm.return_type    = "";
   cm.arguments      = "";
   
   // bail out if j <= 0
   if (j <= 0) {
      return 0;
   }

   // handle things differently depending on the current depth 
   int tree_depth = _TreeGetDepth(j);
   switch (tree_depth) {
   case 0:  // bail out if this is the tree root
      return 0;

   case 1:  // project/global tag file?
      caption = _TreeGetCaption(j);
      parse caption with . ':' file_name ' (' .;
      cm.tag_database = absolute(strip(file_name));
      return 0;

   case 2: // category?
      p = _TreeGetParentIndex(j);
      caption = _TreeGetCaption(p);
      parse caption with . ':' file_name ' (' .;
      cm.tag_database = absolute(strip(file_name));
      caption = _TreeGetCaption(j);
      parse caption with cm.category CB_delimeter .;
      return 0;

   case 3:
      // get the tag database name and category caption
      p = _TreeGetParentIndex(j);
      g = _TreeGetParentIndex(p);
      caption = _TreeGetCaption(g);
      parse caption with . ':' file_name ' (' .;
      cm.tag_database = absolute(strip(file_name));
      caption = _TreeGetCaption(p);
      parse caption with cm.category CB_delimeter .;
      if (_TreeGetUserInfo(j) == '') {
         return 0;
      }
      caption = _TreeGetCaption(j);
      parse caption with cm.member_name CB_delimeter .;
      break;

   default:
      // traverse up the tree and locate tag database and category name
      p = _TreeGetParentIndex(j);
      g = _TreeGetParentIndex(p);
      cat_index = j;
      prj_index = p;
      while (g > 0) {
         pkg_index = cat_index;
         cat_index = prj_index;
         prj_index = g;
         g = _TreeGetParentIndex(g);
      }

      // get the tag database name and category caption
      caption = _TreeGetCaption(prj_index);
      parse caption with . ': ' file_name ' (' .;
      cm.tag_database = absolute(strip(file_name));
      caption = _TreeGetCaption(cat_index);
      parse caption with cm.category CB_delimeter .;
      cm.member_name  = _TreeGetCaption(j);
      parse cm.member_name with cm.member_name "\t" cm.class_name "::" .;
      parse cm.member_name with cm.member_name CB_delimeter .;
      break;
   }

   // normalize member name
   if (pos('()(', cm.member_name)) {
      parse cm.member_name with cm.member_name '()(' cm.arguments ')' .;
      cm.member_name = cm.member_name '()';
   } else {
      parse cm.member_name with cm.member_name '(' cm.arguments ')' .;
   }
   if (pos('operator ', cm.member_name)==1) {
      cm.member_name = substr(cm.member_name, 10);
   }

   // get basic location info for this tag
   value       = _TreeGetUserInfo(j);
   cb_get_db_file_line(value, tag_file_id, file_id, cm.line_no);
   //say("file="file_id" line="cm.line_no" tagfile="tag_file_id" value="_TreeGetUserInfo(j));

   // find the tag file with the given sequence number (tag_file_id)
   if (tag_file_id > 0) {
      child = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      while (child > 0) {
         int sequence_number;
         sequence_number = _TreeGetUserInfo(child);
         if (sequence_number == tag_file_id) {
            caption = _TreeGetCaption(child);
            parse caption with . ':' file_name ' (' .;
            cm.tag_database = absolute(strip(file_name));
            break;
         }
         child = _TreeGetNextSiblingIndex(child);
      }
   }

   // get the class name and member name for the fully qualified class name
   _str separator;
   int target_depth;
   _TreeGetInfo(j, show_children);
   if (show_children>=0) {
      class_name = cm.class_name;
      member_name = cm.member_name;
      target_depth = 4;
   } else {
      p = _TreeGetParentIndex(j);
      pcaption = _TreeGetCaption(p);
      parse pcaption with member_name "\t" class_name "::" .;
      target_depth = 5;
   }

   // select the class separator and construct qualified name
   if (class_name != '') {
      separator = VS_TAGSEPARATOR_class;
      if (tree_depth == target_depth) {
         CB_TAG_CATEGORY ctg;
         ctg = gh_cb_categories:[cm.category];
         if (!ctg._isempty() && ctg.use_package_separator) {
            separator = VS_TAGSEPARATOR_package;
         }
      }
      cm.qualified_name = class_name :+ separator :+ member_name;
   } else {
      cm.qualified_name = member_name;
   }
   parse cm.qualified_name with cm.qualified_name '(' .;

   // bail out if we were asked not to touch the database
   if (no_db_access) {
      return 1;
   }

   // blow out of here if member_name == ''
   if (cm.member_name == '') {
      return 1;
   }

   // open the tag database for business
   status = tag_read_db(cm.tag_database);
   if ( status ) {
      return(status);
   }
   
   // convert the tag file id to a real name
   status = tag_get_file(file_id, file_name);
   if (status) {
      return status;
   }
   cm.file_name = file_name;

   // find the given tag in the file at the given line (case sensitive)
   status = tag_find_closest(cm.member_name, cm.file_name, cm.line_no, 1);
   if (!status) {
      tag_get_detail(VS_TAGDETAIL_type,      cm.type_name);
      tag_get_detail(VS_TAGDETAIL_flags,     cm.flags);
      tag_get_detail(VS_TAGDETAIL_return,    cm.return_type);
      tag_get_detail(VS_TAGDETAIL_arguments, cm.arguments);
   }

   return 1;
}

//////////////////////////////////////////////////////////////////////////////
// Find which tag file the given class belongs to, and normalize the
// class name (qualifies class name with package name) if (normalize!=0).
// Returns the tag file that the class was found in, or '' if not found.
//
static _str find_class_in_tag_file(_str class_name, _str &qualified_name,
                                   boolean normalize, typeless &tag_files)
{
   // first, try to find it in the current tag file
   _str orig_tag_file = tag_current_db();
   int status = tag_find_class(qualified_name, class_name, normalize);
   if (status==0) {
      return orig_tag_file;
   }

   // didn't find it in our tag file, search others    
   int i=0;
   _str filename=next_tag_filea(tag_files,i,false,true)
   while (filename != '') {
      if (! file_eq(filename, orig_tag_file)) {
         status = tag_find_class(qualified_name, class_name, normalize);
         if (status==0) {
            tag_read_db(orig_tag_file);
            return filename;
         }
      }
      filename=next_tag_filea(tag_files,i,false,true);   
   }

   // re-open the original tag file
   status = tag_read_db(orig_tag_file);  
   return '';
}

//////////////////////////////////////////////////////////////////////////////
// Customized function to get the parents of a class, fully qualified.
// This is currently our best approach to package name resolution.
// Utilizes find_class_in_tag_file() above to find the fully qualified
// class name and what tag file it belongs to.  This allows us to trace
// inheritance across multiple projects.
//
_str cb_get_normalized_inheritance(_str class_name,
                                   _str &in_tag_files,
                                   typeless &tag_files,
                                   boolean check_context=false)
{
   //say("cb_get_normalized_inheritance: class_name="class_name);
   boolean found_definition = false;
   if (check_context) {
      _str inner_name='';
      _str outer_name='';
      tag_split_class_name(class_name, inner_name, outer_name);

      // check locals
      int i = tag_find_local(inner_name, true, false, false, outer_name);
      while (i > 0) {
         //say("cb_get_normalized_inheritance: local");
         tag_get_detail2(VS_TAGDETAIL_local_type, i, type_name);
         if (tag_tree_type_is_class(type_name)) {
            found_definition = true;
            tag_get_detail2(VS_TAGDETAIL_local_parents, i, orig_parents);
            break;
         }
         i = tag_next_local(inner_name, true, false, false, outer_name);
      }

      // check context
      if (!found_definition) {
         i = tag_find_context(inner_name, true, false, false, outer_name);
         while (i > 0) {
            //say("cb_get_normalized_inheritance: context");
            tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
            if (tag_tree_type_is_class(type_name)) {
               found_definition = true;
               tag_get_detail2(VS_TAGDETAIL_context_parents, i, orig_parents);
               break;
            }
            i = tag_next_context(inner_name, true, false, false, outer_name);
         }
      }
   }

   // get the list of parents from the database
   if (!found_definition) {
      tag_get_inheritance(class_name, orig_parents);
   }

   // for each parent
   _str new_parents='';
   in_tag_files='';
   while (orig_parents != '') {
      parse orig_parents with parent ';' orig_parents;
      if (parent != '') {

         // attempt to normalize the class name
         //say("cb_get_normalized_inheritance: parent="parent);
         parent_tag_file = find_class_in_tag_file(parent, normalized, true, tag_files);
         if (parent_tag_file=='') {
            normalized = parent;
            parent_tag_file = tag_current_db();
         }

         // append to the new parent list
         if (new_parents == '') {
            new_parents  = normalized;
            in_tag_files = parent_tag_file;
         } else {
            new_parents  = new_parents ';' normalized;
            in_tag_files = in_tag_files ';' parent_tag_file;
         }
      }
   }

   return new_parents;
}

//////////////////////////////////////////////////////////////////////////////
// Return the filename name of the n'th tag file, and vice-versa
// p_window_id must be the class browser tree control.
//
//static _str get_tag_file_name(int i)
//{
//   int child = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
//   while (child > 0) {
//      int sequence_number = _TreeGetUserInfo(child);
//      if (sequence_number == i) {
//         _str caption = _TreeGetCaption(child);
//         parse caption with . ':' file_name ' (' .;
//         return absolute(strip(file_name));
//      }
//      child = _TreeGetNextSiblingIndex(child);
//   }
//   return '';
//}

//////////////////////////////////////////////////////////////////////////////
// Return the sequence number of the given tag file name.  If the given
// tag file is in the list twice, it will only return the first occurance.
// p_window_id must be the class browser tree control.
//
static int get_tag_file_number(_str &tag_file_name)
{
   int child = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (child > 0) {
      _str caption = _TreeGetCaption(child);
      parse caption with . ':' file_name ' (' .;
      file_name = absolute(strip(file_name));
      if (file_eq(file_name, tag_file_name)) {
         return _TreeGetUserInfo(child);
      }
      child = _TreeGetNextSiblingIndex(child);
   }
   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Add the members inherited from all our parent classes.
// Uses the global hash table (gh_classes_visited) to mark which
// classes we have already visited.  This is done to circumvent the
// unusual case of circular references, a potential result of
// incorrect package name resolution.  This function is recursive, but
// limited to CB_MAX_INHERITANCE_DEPTH levels of recursion, limiting
// the amount of recursion we are willing to traverse.
// p_window_id must be the class browser tree control.
//
static int add_class_inherited(_str class_name, int depth,
                               int &count, typeless &tag_files)
{
   if (depth >= CB_MAX_INHERITANCE_DEPTH) {
      return 0;
   }

   // check if we have visited this class already
   int been_there = gh_classes_visited:[class_name];
   if (been_there==1) {
      return 0;
   }
   gh_classes_visited:[class_name]=1;

   // get the fully qualified parents of this class
   _str orig_tag_file = tag_current_db();
   _str parents = cb_get_normalized_inheritance(class_name, tag_dbs, tag_files);

   // add each of them to the list also
   int result = 0;
   while (parents != '') {
      parse parents with p1 ';' parents;
      parse tag_dbs with t1 ';' tag_dbs
      status = tag_read_db(t1);
      if (status) {
         continue;
      }

      // add transitively inherited class members
      result = add_class_inherited(p1, depth+1, count, tag_files);

      // add the members inherited from the given class
      tag_file_id = get_tag_file_number(t1);
      tag_tree_add_members_of(p1, '', tag_file_id, count);
   }

   // return to the original tag file and return, successful
   tag_read_db(orig_tag_file);
   return result;
}

//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the class browser tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the properties view, inheritance view, and output window.
//
static void _ClassBrowserTimerCallback()
{
   // kill the timer
   cb_kill_timer();

   // if something is going on, get out of here
   if (test_event('RK') != '') {
      return;
   }

   // get the class browser form window id
   int f = gtbproject_wid;
   if (!f) {
      return;
   }
   _nocheck _control ctl_class_tree_view;

   // get the details about the current selection
   int currIndex = f.ctl_class_tree_view._TreeCurIndex();
   if (currIndex < 0) {
      return;
   }
   f.ctl_class_tree_view._TreeGetInfo(currIndex, show_children);
   int parentIndex = 0;
   if (currIndex > 0) {
      parentIndex = f.ctl_class_tree_view._TreeGetParentIndex(currIndex);
   }
   struct VS_TAG_BROWSE_INFO cm;
   f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);

   // grab the window ID of the class tree view
   int orig_wid=p_window_id;
   p_window_id=f.ctl_class_tree_view;

   // if something is going on, get out of here
   if (test_event('RK') != '') {
      return;
   }

   // refresh the property dialog if available
   f = gtbprops_wid;
   if (f) {
      orig_window_id = p_window_id;
      cb_refresh_property_view(cm);
      p_window_id = orig_window_id;
   }

   // find the output tagwin and update it
   refresh_output_tab(cm, 0);

   // refresh the inheritance dialog if available
   f = gcbparents_wid;
   if (f) {
      if (show_children < 0) {
         get_user_tag_info(parentIndex, cm, false);
      }
      f.refresh_inheritance_view(cm);
   }

   // restore the window ID
   p_window_id=orig_wid;
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click event (mapped to goto-proc), unless the tree depth
// is less than or equal to two, in which case we simply call expand/collapse
//
void ctl_class_tree_view.enter,lbutton_double_click()
{
   // IF this is an item we can go to like a class name
   i = _TreeCurIndex();
   d = (i<0)? 0:_TreeGetDepth(i);
   if (d > 2) {
      execute("cb_goto_proc");
   } else if (i>=0) {
      _TreeGetInfo(i,show_children);
      if (show_children < 0) {
         call_event(CHANGE_LEAF_ENTER,i,p_window_id,ON_CHANGE,'w')
      } else {
         call_event(show_children?CHANGE_COLLAPSED:CHANGE_EXPANDED,i,p_window_id,ON_CHANGE,'w')
         _TreeSetInfo(i,(int)!show_children);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Add the given category to the tree under its project index (j).
// If there are no global items appropriate for the category, do not
// add the category to the tree.  This function looks for any global with
// a type of either t1, t2, t3, or t4 where the mask evaluates to either
// zero or nzero, as requested.  Categories are inserted with a sequence
// number which they are sorted by.
// p_window_id must be the class browser tree control.
//
static void maybe_add_category(int j, _str category, CB_TAG_CATEGORY &ctg, int count)
{
   // miscellaneous is special
   if (category :== CB_misc) {
      // try to find the item
      int status=tag_find_global(-1, ctg.flag_mask, (ctg.mask_nzero? 1:0));
      while (!status) {
         tag_get_detail(VS_TAGDETAIL_flags, tag_flags);
         tag_get_detail(VS_TAGDETAIL_type,  type_name);
         cn = type_to_category(type_name, tag_flags, 0);
         if (cn :== CB_misc) {
            j = _TreeAddItem(j, category, TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 0);
            _TreeSetUserInfo(j, ctg.sequence_number);
            return;
         }
         status=tag_next_global(-1, ctg.flag_mask, (ctg.mask_nzero? 1:0));
      }
      return;
   }

   for (i=0; i<ctg.tag_types._length(); i++) {
      // get the tag type, has to be either a string or an int 
      t1 = ctg.tag_types[i];
      if (t1._varformat() == VF_LSTR) {
         if (!isinteger(t1)) {
            t1 = tag_find_type(tn, t1);
            if (t1 < 0) {
               continue;
            }
         }
      } else if (t1._varformat() != VF_INT) {
         continue;
      }

      // try to find the item
      status=tag_find_global(t1, ctg.flag_mask, (ctg.mask_nzero? 1:0));
      if (status==0) {
         j = _TreeAddItem(j, category, TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 0);
         _TreeSetUserInfo(j, ctg.sequence_number);
         return;
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// Add all members in the global scope with the given type (t1), matching
// the mask as either zero or nzero, as specified.  This function will not
// insert more that CB_NOAHS_WATER_MARK items under a single category.
// During a refresh, it will stop inserting items after CB_LOW_WATER_MARK
// items are inserted.  During a user expand/collapse, it will stop inserting
// items after CB_HIGH_WATER_MARK items are inserted and prompt the user
// If the user does not cancel, it will continue inserting until it reaches
// CB_FLOOD_WATER_MARK items and every subsequent CB_FLOOD_WATER_MARK items.
// p_window_id must be the class browser tree control.
//
static void add_members_in_category(int j, _str ctg_name, CB_TAG_CATEGORY &ctg, _str letter, int &count)
{
   // Miscellaneous category is a very special case
   if (ctg_name :== CB_misc) {
      status=tag_find_global(-1, ctg.flag_mask, (ctg.mask_nzero? 1:0));
      while (!status) {
         tag_get_info(tag_name, type_name, file_name, line_no, class_name, tag_flags);
         cn = type_to_category(type_name, tag_flags, 0);
         if (cn :== CB_misc) {
            int i_type, i_access;
            status = tag_tree_filter_member(0, type_name, ((class_name!='')? 1:0), tag_flags, i_access, i_type);
            if (status) {
               int ucm;
               tag_get_detail(VS_TAGDETAIL_file_id, file_id);
               ucm = (file_id * CB_MAX_LINE_NUMBER) + line_no;
               tag_get_detail(VS_TAGDETAIL_arguments, signature);
               caption = tag_tree_make_caption(tag_name, type_name, class_name, tag_flags, signature, true);
               pic_member = gi_pic_access_type[i_access][CB_type_miscellaneous];
               if (_TreeAddItem(j,caption,TREE_ADD_AS_CHILD,pic_member,pic_member,-1) < 0) {
                  break;
               }
               _TreeSetUserInfo(j, ucm);
            }
         }
         status=tag_next_global(-1, ctg.flag_mask, (ctg.mask_nzero? 1:0));
      }
      return;
   }

   for (i=0; i<ctg.tag_types._length(); i++) {
      // get the tag type, has to be either a string or an int
      t1 = ctg.tag_types[i];
      if (t1._varformat()==VF_LSTR) {
         if (!isinteger(t1)) {
            t1 = tag_find_type(tn,t1);
            if (t1 < 0) {
               continue;
            }
         }
      } else if (t1._varformat() != VF_INT) {
         continue;
      }

      // add all items with this type to the category
      int in_count = count;
      if (letter=='') {
         status = tag_tree_add_members_in_category(t1, ctg.flag_mask, (ctg.mask_nzero? 1:0), ctg_name, in_count);
         count = in_count;
         //say("count = "in_count);
         if (status < 0) {
            _TreeSetCaption(j, ctg_name CB_delimeter CB_partial);
         } else if (status > 0) {
            // indicates that category was divided
            return;
         }
      } else {
         status = tag_tree_add_members_in_section(letter, t1, ctg.flag_mask, (ctg.mask_nzero? 1:0), ctg_name, in_count);
         //say("count = "in_count);
         count = in_count;
         if (status < 0) {
            _TreeSetCaption(j, letter ': ' ctg_name CB_delimeter CB_partial);
         }
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// pop up a message box warning that a huge number of items are about
// to be inserted into the class browser tree, giving the user the
// oportunity to terminate the operation.
//
int cb_warn_overflow(int t, int j, _str ctg_name, int count)
{
   int orig_autotag_flags = def_autotag_flags2;
   def_autotag_flags2=0;
   status = _message_box(nls("Expanding a large number (%s) of items under '%s'.  Continue?", count, ctg_name), '', MB_YESNOCANCEL|MB_ICONQUESTION);
   def_autotag_flags2 = orig_autotag_flags;
   if (status!=IDYES) {
      count = CB_NOAHS_WATER_MARK;
      t._TreeSetCaption(j, ctg_name CB_delimeter CB_partial);
   }
   mou_hour_glass(1);
   return count;
}

//////////////////////////////////////////////////////////////////////////////
// pop up a message box warning that we were unable to load the
// given DLL.  This is used in the BSC code, through a call to _post_call
// when we are unable for some reason to load msbsc50.dll.
//
void cb_warn_no_bsc(_str dll_name) 
{
   int orig_autotag_flags = def_autotag_flags2;
   def_autotag_flags2=0;
   _message_box(nsl("Unable to load Visual C++ 5.0 Browser DLL: %s",dll_name));
   def_autotag_flags2 = orig_autotag_flags;
}

//////////////////////////////////////////////////////////////////////////////
// pop up a message box warning that a huge number of items are about
// to be inserted into the class browser tree, giving the user the
// oportunity to terminate the operation.
//
int cb_divide_category(int t, int j, int type_id, int mask, int nzero, _str ctg_name)
{
   CB_TAG_CATEGORY ctg;
   ctg = gh_cb_categories:[ctg_name];
   if (!ctg._isempty() && ctg.level3_inheritance) {
      return -1;
   }

   // if we plan to remove duplicates, just do it,
   // but don't create categories
   if (!ctg._isempty() && ctg.remove_duplicates) {
      t._TreeSortCaption(j,'U');
      int num_items = _TreeGetNumChildren(j);
      if (num_items < def_cb_low_refresh/2) {
         return num_items;
      }
   }

   // letters to add, include '$' and '_' if there are tags like that
   alphabet = "A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [Misc]";
   if (tag_find_prefix("$") == 0) {
      alphabet = '$ ' alphabet;
   }
   if (tag_find_prefix("_") == 0) {
      alphabet = '_ ' alphabet;
   }

   // add the letters of the alphabet and 'misc'
   t._TreeDelete(j, 'C');
   while (alphabet != '') {
      parse alphabet with letter alphabet;
      t._TreeAddItem(j, letter ': ' ctg_name, TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 0);
      t._TreeSetUserInfo(j, 0);
   }

   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Remove duplicate items under the given tree index (j).
// Assume that the items under 'f' have already been sorted by caption.
// p_window_id must be the class browser tree control.
//
//static void remove_duplicates_under(int f, int j)
//{
//   k = _TreeGetFirstChildIndex(j);
//   if (k > 0) {
//      kcap = _TreeGetCaption(k);
//      parse kcap with kcap CB_delimeter rest;
//      while (k > 0) {
//         m = _TreeGetNextSiblingIndex(k);
//         if (m > 0) {
//            mcap = _TreeGetCaption(m);
//            parse mcap with mcap CB_delimeter .;
//            if (kcap :== mcap) {
//               _TreeGetInfo(m, mshow);
//               if (mshow > 0) {
//                  _TreeDelete(k);
//               } else {
//                  _TreeDelete(m);
//                  m=k;
//               }
//            } else {
//               //messageNwait("retaining: "kcap);
//               kcap = mcap;
//            }
//         }
//         k=m;
//      }
//   }
//}

//////////////////////////////////////////////////////////////////////////////
// Possibly the most important function for the entire class browser.
// This function handles the on_change event for the class browser tree
// control.  What is done depends on the tree depth, current index, and
// the specific event, which includes the following:
//    CHANGE_EXPANDED:
//          0  -- refresh list of tag files
//          1  -- refresh set of categories for a tag file
//          2  -- refresh set of globals for a category
//          3+ -- refresh set of members in a class (container)
//    CHANGE_COLLAPSED:
//          0  -- should never happen
//          1  -- do nothing
//          2  -- trim "...PARTIAL LIST" off of categories
//          3+ -- do nothing
//    CHANGE_SELECTED:
//          3+ -- start timer for refreshing other views
//    CHANGE_LEAF_ENTER:
//          3+ -- goto definition for the selected item
//
void ctl_class_tree_view.on_change(int reason,int index)
{
   // context index for the selected item
   //say("ctl_class_tree_view.on_change: reason="reason" index="index);
   struct VS_TAG_BROWSE_INFO cm;
   int count;

   // grab our window ID, this shouldn't be necessary
   int f = gtbproject_wid;
   if (!f) return;

   // blow out of here if index is invalid
   if (index < 0) {
      return;
   }

   // scrolling through list, kill the existing timer and start a new one
   if (reason == CHANGE_SELECTED) {
      cb_kill_timer();
      cb_start_timer(_ClassBrowserTimerCallback);

   } else if (reason == CHANGE_EXPANDED) {

      // handled change_expanded event, show hour glass and prepare list
      mou_hour_glass(1);
      int orig_wid = p_window_id;
      p_window_id = f.ctl_class_tree_view;
      int d = _TreeGetDepth(index);

      // root level, list of tag files
      if (d == 0) {

         refresh_tagfiles();

      } else if (d == 1) {  // list of categories in a project

         // get tag details
         _TreeBeginUpdate(index, CB_delimeter);
         get_user_tag_info(index, cm, true);
      
         // open the tag database for business
         status = tag_read_db(cm.tag_database);
         if ( status ) {
            if ( status==NEW_FILE_RC || status==FILE_NOT_FOUND_RC) {
               _message_box(nls("Tag file '%s' not found.\n\nIf you have tag files which were created before version 3.0 you need to rebuild them.",cm.tag_database))
            } else {
               _message_box(nls("Error reading tag file '%s'",cm.tag_database)". "get_message(status));
            }
            return;
         }

         count=1;
         typeless ctg_name;
         CB_TAG_CATEGORY ctg;
         for (ctg_name._makeempty();;) {
            gh_cb_categories._nextel(ctg_name);
            if (ctg_name._isempty()) break;
            if (ctg_name._varformat() == VF_LSTR) {
               ctg = gh_cb_categories._el(ctg_name);
               maybe_add_category(index, ctg_name, ctg, ++count);
            }
         }

         //cb_remove_stale_items(index);
         _TreeEndUpdate(index); 
         _TreeSortUserInfo(index, 'N');

      } else if (d == 2 || (d == 3 && f.ctl_class_tree_view._TreeGetUserInfo(index) == '')) {
         // list of globals in a category

         _TreeBeginUpdate(index, CB_delimeter);
         full_caption = _TreeGetCaption(index);
         letter = '';
         if (d == 3) {
            parse full_caption with letter ':' .;
         }
         parse full_caption with caption CB_delimeter .;
         if (full_caption :!= caption) {
            _TreeSetCaption(index, caption);
         }

         // get filtration mask
         int show_mask1, show_mask2;
         if (f.ctl_filter_check_box.p_value) {
            show_mask1 = CB_QUALIFIERS;
            show_mask2 = CB_QUALIFIERS2;
         } else {
            show_mask1 = f.ctl_class_tree_view.p_user;
            show_mask2 = f.ctl_filter_check_box.p_user;
         }
         // get tag details
         get_user_tag_info(index, cm, true);
      
         // open the database for business
         status = tag_read_db(cm.tag_database);
         if ( status ) {
            return;
         }

         gz_class_filter  = f.ctl_class_filter_combo_box.cb_get_filter();
         gz_member_filter = f.ctl_member_filter_combo_box.cb_get_filter();

         count = 0;
         tag_tree_prepare_expand(f, index, p_window_id, gi_in_refresh, gz_class_filter, gz_member_filter, gz_exception_name, show_mask1, gi_pic_access_type, show_mask2);

         CB_TAG_CATEGORY ctg;
         ctg = gh_cb_categories:[cm.category];
         if (!ctg._isempty()) {
            add_members_in_category(index, cm.category, ctg, letter, count);
         }

         _TreeEndUpdate(index); 
         if (!ctg._isempty() && ctg.remove_duplicates) {
            _TreeSortCaption(index,'U');
            //remove_duplicates_under(gtbproject_wid, index);
         }
         _TreeSortCaption(index,'I','N');

      } else { // list of members of a class/container

         _TreeBeginUpdate(index, CB_delimeter);
         full_caption = _TreeGetCaption(index);
         parse full_caption with caption CB_delimeter .;
         if (full_caption :!= caption) {
            _TreeSetCaption(index, caption);
         }

         // get tag details
         get_user_tag_info(index, cm, false);
      
         // open the database for business
         status = tag_read_db(cm.tag_database);
         if ( status ) {
            return;
         }
         search_file_name = cm.file_name;

         // expanding a package
         if (d == 3 && cm.category :== CB_packages) {
            search_file_name = '';
         }

         // grab bit flags and filtering options
         int show_mask1, show_mask2;
         if (f.ctl_filter_check_box.p_value) {
            show_mask1 = CB_QUALIFIERS;
            show_mask2 = CB_QUALIFIERS2;
         } else {
            show_mask1 = f.ctl_class_tree_view.p_user;
            show_mask2 = f.ctl_filter_check_box.p_user;
         }
         gz_class_filter  = f.ctl_class_filter_combo_box.cb_get_filter();
         gz_member_filter = f.ctl_member_filter_combo_box.cb_get_filter();

         count=0;
         tag_tree_prepare_expand(f, index, p_window_id, gi_in_refresh, gz_class_filter, gz_member_filter, gz_exception_name, show_mask1, gi_pic_access_type, show_mask2);

         // get the inherited class members
         if (show_mask1 & CB_SHOW_inherited_members) {
            gh_classes_visited._makeempty();
            _str ext = _bufname2ext(cm.file_name);
            typeless tag_files = tags_filenamea(ext);
            k=add_class_inherited(cm.qualified_name, 0, count, tag_files);
            gh_classes_visited._makeempty();
         }

         // get the class methods
         if (show_mask1 & CB_SHOW_class_members) {
            // get user info indicating tag file name for our parent
            // this takes care of the case that we are inserting children
            // of a structure that was inherited from a different tag file
            tag_file_id = 0;
            v = _TreeGetUserInfo(index);
            if (v._varformat()==VF_LSTR && isinteger(v)) {
               tag_file_id = (v intdiv (CB_MAX_LINE_NUMBER*CB_MAX_FILE_NUMBER));
            }

            // insert all the tags for this class, applying filtering
            status = tag_tree_add_members_of(cm.qualified_name, search_file_name, tag_file_id, count);
            //say("tag_tree_add_members_of("cm.qualified_name","search_file_name")="status);
            if (status < 0) {
               caption = _TreeGetCaption(index);
               _TreeSetCaption(index, caption CB_delimeter CB_partial);
            }
         }

         // remove the unneeded items  
         //cb_remove_stale_items(index);
         _TreeEndUpdate(index); 
         if (gi_sort_by_line && search_file_name!='') {
            _TreeSortUserInfo(index,'NP', 'I');
         } else {
            _TreeSortCaption(index,'IP','N');
         }
      }

      // if after expanding, the item is still empty, then add ...EMPTY to the caption
      // otherwise remove ...EMPTY if present.
      if (d >= 2) {
         caption = _TreeGetCaption(index);
         child = _TreeGetFirstChildIndex(index);
         if (child <= 0) {
            if (!pos(CB_empty, caption)) {
               parse caption with caption "\t" rest;
               parse caption with caption CB_delimeter .
               caption = caption :+ CB_delimeter :+ CB_empty;
               if (rest != '') {
                  caption = caption :+ "\t" rest;
               }
               _TreeSetCaption(index, caption);
            }
         } else if (pos(CB_empty, caption)) {
            parse caption with caption "\t" rest
            parse caption with caption CB_delimeter .
            if (rest != '') {
               caption = caption :+ "\t" rest;
            }
            _TreeSetCaption(index, caption);
         }
      }

      p_window_id = orig_wid;
      mou_hour_glass(0);

      //_message_box("number of items = "_TreeGetNumChildren(index)); 

   } else if (reason == CHANGE_COLLAPSED) {

      mou_hour_glass(1);
      int orig_wid = p_window_id;
      p_window_id = f.ctl_class_tree_view;

      // remove the "PARTIAL LIST" from category captions on collapsation
      d = _TreeGetDepth(index);
      full_caption = _TreeGetCaption(index);
      parse full_caption with caption CB_delimeter .;
      if (full_caption :!= caption) {
         _TreeSetCaption(index, caption);
      }
      // remove all leaves under this node
      _TreeDelete(index, 'L');
      p_window_id = orig_wid;
      mou_hour_glass(0);

   } else if (reason == CHANGE_LEAF_ENTER) {
      // look up this item and then display in buffer
      f.ctl_class_tree_view.get_user_tag_info(index, cm, false);
      if (push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no)) {
         return;
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// set up for an expand operation (external entry point)
//
void cb_prepare_expand(int formWID, int treeWID, int index)
{
   tag_tree_prepare_expand(formWID, index, treeWID, 0, '', '', '', 0, gi_pic_access_type);
}

//////////////////////////////////////////////////////////////////////////////
// Update other views when viewer gets focus, important because
// inheritance view, call tree, and props can also update the output
// view, so if they return focus to the class browser, we need to
// restart the update timer.
//
void ctl_class_tree_view.on_got_focus()
{
   // kill the existing timer and start a new one
   cb_kill_timer();
   cb_start_timer(_ClassBrowserTimerCallback);
}

//////////////////////////////////////////////////////////////////////////////
// Handle spacebar press in class tree.  This is intended to goto the
// exact item at the current index.
//
void ctl_class_tree_view.' '()
{
   orig_window_id = p_window_id;
   k = ctl_class_tree_view._TreeCurIndex();
   struct VS_TAG_BROWSE_INFO cm;
   if (ctl_class_tree_view.get_user_tag_info(k, cm, false)) {
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
   }
   p_window_id = orig_window_id;
   ctl_class_tree_view._set_focus();
}

//////////////////////////////////////////////////////////////////////////////
// Push a bookmark and open the given file and position the cursor on the
// given line/column
//
static int push_pos_in_file(_str file_name, int line_no, int col_no)
{
   // no MDI children?
   int mark = -1;
   if (!_no_child_windows()) {
      // get a bookmark
      mark=_alloc_selection('b');  
      if ( mark<0 ) {
         return(mark);
      }
      _mdi.p_child._select_char(mark);
   }

   // try to open the file
   int status = edit(maybe_quote_filename(file_name),EDIT_DEFAULT_FLAGS);
   if (status) {
      if (mark >= 0) {
         _free_selection(mark);
      }
      return(status);
   }

   // junk to the line
   goto_line(line_no);
   goto_col(0);

   // push the bookmark
   if (mark >= 0) {
      _mdi.p_child.push_bookmark(mark);    
   }
   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Push a bookmark and delegate to goto_tag_in_file() to open the given
// file and position the cursor on the given proc/class/type as near to
// the given line number as possible.
//
int push_tag_in_file(_str proc_name, _str file_name, _str class_name, _str type_name, int line_no)
{
   // no MDI children?
   if (_no_child_windows()) {
      return goto_tag_in_file(proc_name, file_name, class_name, type_name, line_no);
   }

   // get a bookmark
   int mark=_alloc_selection('b');
   if ( mark<0 ) {
      return(mark)
   }
   _mdi.p_child._select_char(mark);

   // try to open the file
   int status=goto_tag_in_file(proc_name, file_name, class_name, type_name, line_no);
   if (status) {
      _free_selection(mark);
      return status;
   }
   
   // push the bookmark
   return(_mdi.p_child.push_bookmark(mark));
}

//////////////////////////////////////////////////////////////////////////////
// Using proc-search, open the given file_name, find the nearest matching
// tag with the given class name and type name as close as possible to
// the given line number.  If no such match is found, relax the search to
// just the given proc_name.  If that match is not found, alert the user
// that the tag was not found.
//
static int goto_tag_in_file(_str proc_name, _str file_name, _str class_name, _str type_name, int line_no)
{
   // Note that the <ext>_proc_search code in cparse and dparse always
   // goes to column one for non proc type identifiers.
   int closed_col=1;
   int closest_line_no = CB_MAX_LINE_NUMBER;

   // check if there is a load-tags function, if so, bail out
   _str ext=_bufname2ext(file_name);
   int i;
   int index=find_index('vs'ext'-load-tags',PROC_TYPE);
   if (index_callable(index)) {
      message nls('Can not locate source code for %s.',file_name);
      return(1);
   }

   // try to open the file
   int status = edit(maybe_quote_filename(file_name),EDIT_DEFAULT_FLAGS);
   if (status) {
      return status;
   }
   
   // find the proc-search function
   index=find_index(p_extension'-proc-search',PROC_TYPE)
   if (! index_callable(index) ) {
      // Be lazy and don't close edited buffer
      message(nls('Procedure %s not found',ext'-proc-search'));
      return(1);
   }

   // update the current context and locals for this file
   save_pos(p);
   _UpdateContext(true);
   _UpdateLocals(true,true);
   int context_id = tag_current_context();

   // see if it is found in locals
   boolean local_found = false;
   index=find_index(ext'-lvar-search',PROC_TYPE);
   if (context_id>0 && index_callable(index) ) {
      i = tag_find_local(proc_name, true, p_LangCaseSensitive);
      while (i > 0) {
         // get class and type for checking
         tag_get_detail2(VS_TAGDETAIL_local_class, i, i_class_name);
         tag_get_detail2(VS_TAGDETAIL_local_type,  i, i_type_name);
         if ((type_name =='' || type_name ==i_type_name) &&
             (class_name=='' || class_name==i_class_name)) {
            // get line number and seekpos
            tag_get_detail2(VS_TAGDETAIL_local_start_linenum, i, i_line_no);
            tag_get_detail2(VS_TAGDETAIL_local_start_seekpos, i, i_seekpos);

            p_line=i_line_no;
            _nrseek(i_seekpos);
            if (abs(p_line-line_no) < abs(closest_line_no-line_no)) {
               closest_line_no = p_line;
               closest_col=p_col;
            }
            if (p_line == line_no) {
               center_line();
               return(0);  // got it.
            }
         }
         i = tag_next_local(proc_name, true, p_LangCaseSensitive);
      }
   }

   // see if it is found in context
   i = tag_find_context(proc_name, true, p_LangCaseSensitive);
   while (i > 0) {
      // get class and type for checking
      tag_get_detail2(VS_TAGDETAIL_context_class, i, i_class_name);
      tag_get_detail2(VS_TAGDETAIL_context_type,  i, i_type_name);
      if ((type_name =='' || type_name ==i_type_name) &&
          (class_name=='' || class_name==i_class_name)) {
         // get line number and seekpos
         tag_get_detail2(VS_TAGDETAIL_context_start_linenum, i, i_line_no);
         tag_get_detail2(VS_TAGDETAIL_context_start_seekpos, i, i_seekpos);

         p_line=i_line_no;
         _nrseek(i_seekpos);
         if (abs(p_line-line_no) < abs(closest_line_no-line_no)) {
            closest_line_no = p_line;
            closest_col=p_col;
         }
         if (p_line == line_no) {
            center_line();
            return(0);  // got it.
         }
      }
      i = tag_next_context(proc_name, true, p_LangCaseSensitive);
   }

   if (closest_line_no == CB_MAX_LINE_NUMBER) {
      long_msg='.  'nls('You may want to rebuild the tag file.');
      _message_box(nls("Tag '%s' not found",proc_name)long_msg);
      restore_pos(p);
      return(1)
   }

   restore_pos(p);
   p_col=closest_col;
   goto_line(closest_line_no);
   return(0);
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// handlers for class browser options form
//
defeventtab _cboptions_form

//////////////////////////////////////////////////////////////////////////////
// Set p_value for the given check box (as current object) depending on
// the settings of the given big masks.
//
static void set_filter_check_box(int show_mask, int on_bit, int off_bit)
{
   if (show_mask & on_bit) {
      p_value = (show_mask & off_bit)? 2/*don't care*/ : 1/*on*/;
   } else {
      p_value = 0/*off*/;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Refresh the class browser options view.  Retrieve stored class browser
// options and set the controls in the class browser options dialog to
// correspond with current operating parameters.
//
static void refresh_filter_options(int show_mask1, int show_mask2)
{
   // bits in first SHOW mask
   ctl_show_static_data.set_filter_check_box(show_mask1, CB_SHOW_class_data, CB_SHOW_instance_data);
   ctl_show_data_members.set_filter_check_box(show_mask1, CB_SHOW_data_members, CB_SHOW_other_members);
   ctl_show_inline.set_filter_check_box(show_mask1, CB_SHOW_inline, CB_SHOW_out_of_line);
   ctl_show_static.set_filter_check_box(show_mask1, CB_SHOW_static, CB_SHOW_non_virtual);
   ctl_show_virtual.set_filter_check_box(show_mask1, CB_SHOW_virtual, CB_SHOW_non_virtual);
   ctl_show_abstract.set_filter_check_box(show_mask1, CB_SHOW_abstract, CB_SHOW_non_abstract);
   ctl_show_operators.set_filter_check_box(show_mask1, CB_SHOW_operators, CB_SHOW_non_special);
   ctl_show_constructors.set_filter_check_box(show_mask1, CB_SHOW_constructors, CB_SHOW_non_special);
   ctl_show_final_members.set_filter_check_box(show_mask1, CB_SHOW_final_members, CB_SHOW_non_final_members);
   ctl_show_const_members.set_filter_check_box(show_mask1, CB_SHOW_const_members, CB_SHOW_non_const_members);
   ctl_show_volatile_members.set_filter_check_box(show_mask1, CB_SHOW_volatile_members, CB_SHOW_non_volatile_members);
   ctl_show_transient_members.set_filter_check_box(show_mask1, CB_SHOW_transient_data, CB_SHOW_persistent_data);
   ctl_show_synchronized_members.set_filter_check_box(show_mask1, CB_SHOW_synchronized, CB_SHOW_non_synchronized);
   ctl_show_template_classes.set_filter_check_box(show_mask1, CB_SHOW_template_classes, CB_SHOW_non_template_classes);
   ctl_show_inherited_members.set_filter_check_box(show_mask1, CB_SHOW_inherited_members, CB_SHOW_class_members);

   // bits in second SHOW mask
   ctl_show_preprocessing.set_filter_check_box(show_mask2, CB_SHOW_macros, CB_SHOW_non_macros);
   ctl_show_native.set_filter_check_box(show_mask2, CB_SHOW_native, CB_SHOW_non_native);
   ctl_show_extern.set_filter_check_box(show_mask2, CB_SHOW_extern, CB_SHOW_non_extern);
   ctl_show_anonymous.set_filter_check_box(show_mask2, CB_SHOW_anonymous, CB_SHOW_non_anonymous);

   // set package, private, public, public members on/off
   ctl_show_package_members.p_value   = (show_mask1 & CB_SHOW_package_members)?   1:0;
   ctl_show_private_members.p_value   = (show_mask1 & CB_SHOW_private_members)?   1:0;
   ctl_show_public_members.p_value    = (show_mask1 & CB_SHOW_public_members)?    1:0;
   ctl_show_protected_members.p_value = (show_mask1 & CB_SHOW_protected_members)? 1:0;
}

//////////////////////////////////////////////////////////////////////////////
// Gets the filtering flags from the options dialog.
//    show_mask1 -- bit mask for show options (see CB_SHOW_*, above)
//    show_mask2 -- more show options
// p_window_id must be the options dialog form window ID.
//
static void get_filter_options(int &show_mask1, int &show_mask2)
{
   show_mask1 = show_mask2 = 0;

   if (ctl_show_static_data.p_value>=1) {          show_mask1 |= CB_SHOW_class_data;           }
   if (ctl_show_static_data.p_value!=1) {          show_mask1 |= CB_SHOW_instance_data;        }
   if (ctl_show_data_members.p_value>=1) {         show_mask1 |= CB_SHOW_data_members;         }
   if (ctl_show_data_members.p_value!=1) {         show_mask1 |= CB_SHOW_other_members;        }
   if (ctl_show_inline.p_value!=1) {               show_mask1 |= CB_SHOW_out_of_line;          }
   if (ctl_show_inline.p_value>=1) {               show_mask1 |= CB_SHOW_inline;               }
   if (ctl_show_static.p_value>=1) {               show_mask1 |= CB_SHOW_static;               }
   if (ctl_show_virtual.p_value>=1) {              show_mask1 |= CB_SHOW_virtual;              }
   if (ctl_show_abstract.p_value>=1) {             show_mask1 |= CB_SHOW_abstract;             }
   if (ctl_show_abstract.p_value!=1) {             show_mask1 |= CB_SHOW_non_abstract;         }
   if (ctl_show_operators.p_value>=1) {            show_mask1 |= CB_SHOW_operators;            }
   if (ctl_show_constructors.p_value>=1) {         show_mask1 |= CB_SHOW_constructors;         }
   if (ctl_show_final_members.p_value!=1) {        show_mask1 |= CB_SHOW_non_final_members;    }
   if (ctl_show_final_members.p_value>=1) {        show_mask1 |= CB_SHOW_final_members;        }
   if (ctl_show_const_members.p_value!=1) {        show_mask1 |= CB_SHOW_non_const_members;    }
   if (ctl_show_const_members.p_value>=1) {        show_mask1 |= CB_SHOW_const_members;        }
   if (ctl_show_volatile_members.p_value!=1) {     show_mask1 |= CB_SHOW_non_volatile_members; }
   if (ctl_show_volatile_members.p_value>=1) {     show_mask1 |= CB_SHOW_volatile_members;     }
   if (ctl_show_synchronized_members.p_value!=1) { show_mask1 |= CB_SHOW_non_synchronized;     }
   if (ctl_show_synchronized_members.p_value>=1) { show_mask1 |= CB_SHOW_synchronized;         }
   if (ctl_show_transient_members.p_value!=1) {    show_mask1 |= CB_SHOW_persistent_data;      }
   if (ctl_show_transient_members.p_value>=1) {    show_mask1 |= CB_SHOW_transient_data;       }
   if (ctl_show_template_classes.p_value!=1) {     show_mask1 |= CB_SHOW_non_template_classes; }
   if (ctl_show_template_classes.p_value>=1) {     show_mask1 |= CB_SHOW_template_classes;     }
   if (ctl_show_package_members.p_value) {         show_mask1 |= CB_SHOW_package_members;      }
   if (ctl_show_private_members.p_value) {         show_mask1 |= CB_SHOW_private_members;      }
   if (ctl_show_protected_members.p_value) {       show_mask1 |= CB_SHOW_protected_members;    }
   if (ctl_show_public_members.p_value) {          show_mask1 |= CB_SHOW_public_members;       }
   if (ctl_show_inherited_members.p_value>=1) {    show_mask1 |= CB_SHOW_inherited_members;    }
   if (ctl_show_inherited_members.p_value!=1) {    show_mask1 |= CB_SHOW_class_members;        }

   if (ctl_show_extern.p_value>=1) {               show_mask2 |= CB_SHOW_extern;               }
   if (ctl_show_extern.p_value!=1) {               show_mask2 |= CB_SHOW_non_extern;           }
   if (ctl_show_native.p_value>=1) {               show_mask2 |= CB_SHOW_native;               }
   if (ctl_show_native.p_value!=1) {               show_mask2 |= CB_SHOW_non_native;           }
   if (ctl_show_preprocessing.p_value>=1) {        show_mask2 |= CB_SHOW_macros;               }
   if (ctl_show_preprocessing.p_value!=1) {        show_mask2 |= CB_SHOW_non_macros;           }
   if (ctl_show_anonymous.p_value>=1) {            show_mask2 |= CB_SHOW_anonymous;            }
   if (ctl_show_anonymous.p_value!=1) {            show_mask2 |= CB_SHOW_non_anonymous;        }

   // Turn on non-virtual provided neither virtual-only or static-only are set
   if (ctl_show_static.p_value!=1 && ctl_show_virtual.p_value!=1) {
       show_mask1 |= CB_SHOW_non_virtual;
   }
   // Turn off virtual/static if the other is set
   if (ctl_show_static.p_value==1 && ctl_show_virtual.p_value==2) {
      show_mask1 &= ~CB_SHOW_virtual;
   }
   if (ctl_show_static.p_value==2 && ctl_show_virtual.p_value==1) {
      show_mask1 &= ~CB_SHOW_static;
   }

   // Turn on non-virtual provided neither virtual-only or static-only are set
   if (ctl_show_operators.p_value!=1 && ctl_show_constructors.p_value!=1) {
       show_mask1 |= CB_SHOW_non_special;
   }
   // Turn off operators/constructors if the other is set
   if (ctl_show_operators.p_value==1 && ctl_show_constructors.p_value==2) {
      show_mask1 &= ~CB_SHOW_constructors;
   }
   if (ctl_show_operators.p_value==2 && ctl_show_constructors.p_value==1) {
      show_mask1 &= ~CB_SHOW_operators;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Apply new option settings from the class browser options dialog.
// First step is to reset the global options (see above), then call
// refresh_class_tree_view() and/or checkShowHideControls() if necessary.
//
static void apply_new_options()
{
   int show_mask1, show_mask2;
   get_filter_options(show_mask1, show_mask2);
   int show_class_filter  = ctl_show_class_filter.p_value;
   int show_member_filter = ctl_show_member_filter.p_value;

   _nocheck _control ctl_class_tree_view;
   _nocheck _control ctl_filter_check_box;
   _nocheck _control ctl_class_filter_combo_box;
   _nocheck _control ctl_member_filter_combo_box;
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return;
   }

   if (show_class_filter != f.ctl_class_filter_label.p_visible || 
       show_member_filter != f.ctl_member_filter_label.p_visible) {

      f.ctl_class_filter_label.p_user  = ctl_show_class_filter.p_value;
      f.ctl_member_filter_label.p_user = ctl_show_member_filter.p_value;
      f.checkShowHideControls();
   }

   int orig_show_mask1 = f.ctl_class_tree_view.p_user;
   int orig_show_mask2 = f.ctl_filter_check_box.p_user;
   class_filter  = f.ctl_class_filter_combo_box.cb_get_filter();
   member_filter = f.ctl_member_filter_combo_box.cb_get_filter();
   if (class_filter  :!= gz_class_filter || 
       member_filter :!= gz_member_filter || 
       (show_mask1 & CB_QUALIFIERS)  != (orig_show_mask1 & CB_QUALIFIERS) || 
       (show_mask2 & CB_QUALIFIERS2) != (orig_show_mask2 & CB_QUALIFIERS2)) {

      f.ctl_class_tree_view.p_user  = show_mask1;
      f.ctl_filter_check_box.p_user = show_mask2;
      gz_class_filter  = class_filter;
      gz_member_filter = member_filter;
      cb_refresh();
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle user pressing class browser options "Apply" button
//
void ctl_apply_button.lbutton_up()
{
   apply_new_options();
}

//////////////////////////////////////////////////////////////////////////////
// Handle user pressing class browser options "OK" button, apply the
// options and dismiss the form.
//
void ctl_ok_button.lbutton_up()
{
   _save_form_response();
   apply_new_options();
   p_active_form._delete_window(0);
}

//////////////////////////////////////////////////////////////////////////////
// Special cases to insure that at least one of package, private, protected,
// or public is on.  If all but one is on, and you attempt to toggle that
// one off, turn on the next item.
//
void ctl_show_package_members.lbutton_up()
{
   if (ctl_show_package_members.p_value == 0 && ctl_show_public_members.p_value == 0 && ctl_show_protected_members.p_value == 0 && ctl_show_private_members.p_value == 0) {
      ctl_show_public_members.p_value = 1;
   }
}
void ctl_show_private_members.lbutton_up()
{
   if (ctl_show_package_members.p_value == 0 && ctl_show_public_members.p_value == 0 && ctl_show_protected_members.p_value == 0 && ctl_show_private_members.p_value == 0) {
      ctl_show_package_members.p_value = 1;
   }
}
void ctl_show_protected_members.lbutton_up()
{
   if (ctl_show_package_members.p_value == 0 && ctl_show_public_members.p_value == 0 && ctl_show_protected_members.p_value == 0 && ctl_show_private_members.p_value == 0) {
      ctl_show_private_members.p_value = 1;
   }
}
void ctl_show_public_members.lbutton_up()
{
   if (ctl_show_package_members.p_value == 0 && ctl_show_public_members.p_value == 0 && ctl_show_protected_members.p_value == 0 && ctl_show_private_members.p_value == 0) {
      ctl_show_protected_members.p_value = 1;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Class browser options form creation, restore the options and
// refresh the controls as per current settings.
//
void ctl_ok_button.on_create()
{
   gcboptions_wid = p_active_form;
   int f = gtbproject_wid;
   if (!f) {
      return;
   }
   _nocheck _control ctl_class_tree_view;
   _nocheck _control ctl_class_filter_combo_box;
   _nocheck _control ctl_member_filter_combo_box;
   _nocheck _control ctl_filter_check_box;

   int show_mask1 = f.ctl_class_tree_view.p_user;
   int show_mask2 = f.ctl_filter_check_box.p_user;
   refresh_filter_options(show_mask1, show_mask2);

   ctl_show_member_filter.p_value = (f.ctl_member_filter_combo_box.p_visible)? 1:0;
   ctl_show_class_filter.p_value  = (f.ctl_class_filter_combo_box.p_visible )? 1:0;
}

//////////////////////////////////////////////////////////////////////////////
// Handle destroy class browser options dialog.  Get rid of cached window ID.
//
void ctl_ok_button.on_destroy()
{
   gcboptions_wid = 0;
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// handlers for class inheritance properties dialog
//
defeventtab _cbparents_form

//////////////////////////////////////////////////////////////////////////////
// Handle right-mouse button on the inheritance tree dialog
//
void _cbparents_form.rbutton_up()
{
   int f = gtbproject_wid;
   if (!f) return;
   call_event(f.ctl_class_tree_view,RBUTTON_UP,'w')
}

//////////////////////////////////////////////////////////////////////////////
// handle horizontal resize bar
//
ctl_divider.lbutton_down()
{
   mou_mode(1)
   mou_release;mou_capture
   done=0;
   xpos=0;
   selected_wid=orig_wid=p_window_id;
   p_window_id=selected_wid.p_parent;

   _save_draw_setup(draw_setup);

   p_fill_style=PSFS_TRANSPARENT;
   p_draw_width=1;
   p_draw_style=PSDS_SOLID
                p_draw_mode=PSDM_XORPEN
                            color=_rgb(0x80,0x80,0x80);  /* Gray */

   morig_x=mou_last_x('M');morig_y=mou_last_y('M');

   morig_x=selected_wid.p_x+100//selected_wid.p_width;
           morig_y=selected_wid.p_y+selected_wid.p_height;
   rectangle_drawn=0;
   done=0;

   selected_wid._get_window(orig_x,orig_y,orig_width,orig_height);

   button_width = ctl_ok_button.p_width;
   border_width = ctl_inheritance_tree_view.p_x;
   member_width = ctl_member_tree_view.p_x + ctl_member_tree_view.p_width;
   divide_width = ctl_divider.p_width;
   orig_width=60//Hack

   x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
   orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
   smallest_width=_HANDLE_WIDTH*2;
   smallest_height=_HANDLE_HEIGHT*2;

   _lxy2lxy(SM_TWIP,p_scale_mode,smallest_width,smallest_height);
   for (;;) {
      event=get_event();
      switch (event) {
      case MOUSE_MOVE:
         new_y1=y1;new_y2=y2;
         new_x1=mou_last_x('M')
         if (new_x1 < (button_width+border_width)*2) {
            new_x1 = (button_width+border_width)*2;
         } else if (new_x1 > member_width-divide_width) {
            new_x1 = member_width-divide_width;
         }
         new_x2 = new_x1+60;

         if (rectangle_drawn) {
            if (x1==new_x1 && y1==new_y1 && x2==new_x2 && y2!=new_y2) {
               break;
            }
            /* Erase the rectangle. */
            _draw_rect(x1,y1,x2,y2,color,'e');
         }
         rectangle_drawn=1;
         x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
         _draw_rect(x1,y1,x2,y2,color,'e');
         break;
      case LBUTTON_UP:
         x_pos=mou_last_x('m');
         mou_mode(0);
         mou_release();
         if (rectangle_drawn) {
            /* Erase the rectangle. */
            _draw_rect(x1,y1,x2,y2,color,'e');
         }
         _restore_draw_setup(draw_setup);
         if (x_pos < (border_width+button_width)*2) {
            x_pos = (border_width+button_width)*2;
         } else if (x_pos > member_width-divide_width) {
            x_pos = member_width-divide_width;
         }
         if (x_pos >= (border_width+button_width)*2 && x_pos <= member_width-divide_width) {
            ctl_divider.p_x=x_pos;
            ctl_inheritance_tree_view.p_width=ctl_divider.p_x-border_width;
            ctl_member_tree_view.p_x=ctl_divider.p_x+divide_width;
            ctl_member_tree_view.p_width=_dx2lx(SM_TWIP,p_active_form.p_client_width)-ctl_member_tree_view.p_x;}
            ctl_help_button.p_x = ctl_divider.p_x - button_width;
            return(0);
         }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle resize event, distributing available space evenly between the
// inheritance tree side and the member list side.  Do not allow the size
// to go below the minimum required to show classes in the tree and show
// all three buttons.
// 
void _cbparents_form.on_resize()
{
   // width/height of OK, Cancel, Help buttons (all are the same)
   button_width  = ctl_ok_button.p_width;
   button_height = ctl_ok_button.p_height;

   // force size of dialog to remain reasonable
   if (p_width < button_width*4) {
      p_width = button_width*4;
   }
   if (p_height < button_height*5) {
      p_height = button_height*5;
   }

   // available space and border usage
   int avail_x, avail_y, border_x, border_y;
   avail_x  = _dx2lx(SM_TWIP,p_active_form.p_client_width);
   avail_y  = _dy2ly(SM_TWIP,p_active_form.p_client_height);
   border_x = ctl_inheritance_tree_view.p_x;
   border_y = ctl_inheritance_tree_view.p_y;

   // half the width of the dialog
   half_x        = ctl_divider.p_x;
   half_width    = ctl_divider.p_width;
   if (half_x < button_width*2 + border_x*2) {
      half_x = button_width*2 + border_x*2;
   }
   if (half_x > avail_x) {
      half_x = avail_x - ctl_divider.p_width;
      ctl_divider.p_x = half_x;
   }

   // size the tree controls
   ctl_inheritance_tree_view.p_width  = half_x - border_x;
   ctl_inheritance_tree_view.p_height = avail_y - border_y*3 - button_height;
   ctl_member_tree_view.p_x      = half_x + half_width;
   ctl_member_tree_view.p_height = avail_y - border_y*2;
   ctl_member_tree_view.p_width  = avail_x - half_x - border_x - half_width;

   // set the height of the divider
   ctl_divider.p_height = ctl_inheritance_tree_view.p_height;

   // move around the buttons
   button_y = avail_y - button_height - border_y;
   ctl_ok_button.p_y   = button_y;
   ctl_help_button.p_y = button_y;
   ctl_help_button.p_x = ctl_divider.p_x - button_width;
}

//////////////////////////////////////////////////////////////////////////////
// Get context information for the currently selected member in the class
// inheritance dialog.  Complete context is obtained by looking both at
// the currently selected member, and the currently selected class.
// Final details are obtained from the database.  If (class_only==1),
// then get the tag info for the currently selected class, not member.
// p_window_id must be the inheritance tree window ID.
//
static int get_inheritance_tag_info(struct VS_TAG_BROWSE_INFO &cm, int class_only, boolean no_db_access)
{
   cm.tag_database = "";
   cm.category     = "";
   cm.member_name  = "";
   cm.class_name   = "";
   cm.qualified_name = "";
   cm.file_name    = "";
   cm.line_no      = 0;
   cm.return_type  = "";
   cm.arguments    = "";
   cm.flags        = 0;
   cm.type_name    = "";

   // check current tree index
   k = ctl_inheritance_tree_view._TreeCurIndex();
   if (k<0) {
      return 0;
   }

   // get some more details
   ucm = ctl_inheritance_tree_view._TreeGetUserInfo(k);
   parse ucm with cm.tag_database ';' cm.class_name ';' cm.type_name ';' cm.file_name ';' line_no
   cm.line_no = line_no;

   // if they are requesting only information on the currently selected class
   if (class_only) {
      cm.qualified_name = cm.class_name;
      cm.member_name = cm.class_name;
      cm.class_name  = '';
      if (pos('/', cm.member_name)) {
         parse cm.member_name with cm.class_name '/' cm.member_name;
      }
      while (pos(':', cm.member_name)) {
         parse cm.member_name with class_end ':' cm.member_name;
         if (cm.class_name != '') {
            cm.class_name = cm.class_name ':' class_end;
         } else {
            cm.class_name = class_end;
         }
      }
   } else {
      // get basic location info for this tag
      j = ctl_member_tree_view._TreeCurIndex();
      if (j<=0) {
         return 0;
      }
      d = ctl_member_tree_view._TreeGetDepth(j);
      if (d<2) {
         return 0;
      }
      caption = ctl_member_tree_view._TreeGetCaption(j);
      if (pos('()(', caption)) {
         parse caption with caption '()(' .;
         caption = caption '()';
      } else {
         parse caption with caption '(' .;
      }
      cm.member_name = caption;
      if (pos('operator ', cm.member_name)==1) {
         cm.member_name = substr(cm.member_name, 10);
      }
      cm.line_no = ctl_member_tree_view._TreeGetUserInfo(j);
      cm.type_name = '';
   }

   // bail out if we were asked not to touch the database
   if (no_db_access) {
      return 1;
   }

   // open the tag database for business
   status = tag_read_db(cm.tag_database);
   if ( status ) {
      return(status);
   }

   // find the specific tag in the database
   status = tag_find_closest(cm.member_name, cm.file_name, cm.line_no, 1);
   if (!status) {
      tag_get_detail(VS_TAGDETAIL_type,      cm.type_name);
      tag_get_detail(VS_TAGDETAIL_flags,     cm.flags);
      tag_get_detail(VS_TAGDETAIL_return,    cm.return_type);
      tag_get_detail(VS_TAGDETAIL_arguments, cm.arguments);
   }

   // success
   return 1;
}

//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the inheritance tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the properties view, inheritance view, and output window.
//
static void _MemberListTimerCallback()
{
   // kill the timer
   cb_kill_timer();

   // bail out if there is no inheritance form
   int f = gcbparents_wid;
   if (!f) return;

   // update the property view, call tree view, and output tab
   struct VS_TAG_BROWSE_INFO cm;
   if (f.get_inheritance_tag_info(cm, 0, false)) {
      f = gtbprops_wid;
      if (f) {
         cb_refresh_property_view(cm);
      }

      // find the output tagwin and update it
      refresh_output_tab(cm, 0);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle on-change event for member list (a tree control) in inheritance
// tree dialog.  The only event handled is CHANGE_LEAF_ENTER, for which
// we utilize push_tag_in_file to push a bookmark and bring up the code in
// the editor.
//
void ctl_member_tree_view.on_change(int reason,int index)
{
   if (reason == CHANGE_LEAF_ENTER) {

      // get the current index and tag details
      k = index;
      struct VS_TAG_BROWSE_INFO cm;
      if (get_inheritance_tag_info(cm, 0, true)) {
         push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
      }
   } else if (reason == CHANGE_SELECTED) {
      if (_get_focus() == gcbparents_wid.ctl_member_tree_view) {

         // kill the existing timer and start a new one
         cb_kill_timer();
         cb_start_timer(_MemberListTimerCallback);
      }
   }
}


//////////////////////////////////////////////////////////////////////////////
// Update other views when viewer gets focus, important because
// inheritance view, call tree, and props can also update the output
// view, so if they return focus to the class browser, we need to
// restart the update timer.
//
void ctl_member_tree_view.on_got_focus()
{
   // kill the existing timer and start a new one
   cb_kill_timer();
   cb_start_timer(_MemberListTimerCallback);
}

//////////////////////////////////////////////////////////////////////////////
// If the spacebar is pressed when the focus is on the member list,
// bring the item up in the editor, but retain focus on the member list.
//
void ctl_member_tree_view.' '()
{
   orig_window_id = p_window_id;
   struct VS_TAG_BROWSE_INFO cm;
   if (get_inheritance_tag_info(cm, 0, true)) {
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
   }
   p_window_id = orig_window_id;
   ctl_member_tree_view._set_focus();
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click (meaning drill-down) on a member in a class.
// This method will attempt to locate the proc that corresponds to any
// prototype that is selected, and position us there.
//
void ctl_member_tree_view.enter,lbutton_double_click()
{
   k = ctl_member_tree_view._TreeCurIndex();
   d = (k<0)? 0:ctl_member_tree_view._TreeGetDepth(k);
   if (d > 1) {
      struct VS_TAG_BROWSE_INFO cm;
      if (get_inheritance_tag_info(cm, 0, true)) {
         if (cm.type_name :== 'proto') {
            _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
            if (tag_find_tag(cm.member_name, 'proc', cm.class_name, search_arguments)==0) {  
               tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
            } else if (tag_find_tag(cm.member_name, 'func', cm.class_name, search_arguments)==0) {
               tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
            } else if (tag_find_tag(cm.member_name, 'constr', cm.class_name, search_arguments)==0) {
               tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
            } else if (tag_find_tag(cm.member_name, 'destr', cm.class_name, search_arguments)==0) {
               tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
            }
         }
         push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
      }
   } else {
      _TreeGetInfo(k,show_children);
      if (show_children < 0) {
         call_event(CHANGE_LEAF_ENTER,k,p_window_id,ON_CHANGE,'w')
      } else {
         call_event(show_children?CHANGE_COLLAPSED:CHANGE_EXPANDED,k,p_window_id,ON_CHANGE,'w')
         _TreeSetInfo(k,(int)!show_children);
      }
   }
}


//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the inheritance tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the properties view, inheritance view, and output window.
//
static void _InheritanceTimerCallback()
{
   // kill the timer
   cb_kill_timer();

   // bail out if there is no inheritance form
   int f = gcbparents_wid;
   if (!f) return;

   // update the property view, call tree view, and output tab
   struct VS_TAG_BROWSE_INFO cm;
   if (f.get_inheritance_tag_info(cm, 1, false)) {

      // refresh the list of member functions
      mou_hour_glass(1);
      f.ctl_member_tree_view.add_members_of(cm.qualified_name, cm.tag_database, cm.file_name);
      mou_hour_glass(0);

      // refresh the properties view
      f = gtbprops_wid;
      if (f) {
         cb_refresh_property_view(cm);
      }

      // find the output tagwin and update it
      refresh_output_tab(cm, 0);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle on-change for inheritance tree, meaning that a diffenent class
// was selected, so we need to update the list of members.
//
void ctl_inheritance_tree_view.on_change(int reason,int index)
{
   struct VS_TAG_BROWSE_INFO cm;
   if (reason == CHANGE_LEAF_ENTER) {
      if (get_inheritance_tag_info(cm, 1, true)) {
         push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
      }
   } else if (reason == CHANGE_SELECTED) {

      if (_get_focus() == ctl_inheritance_tree_view) {

         // kill the existing timer and start a new one
         cb_kill_timer();
         cb_start_timer(_InheritanceTimerCallback);
      } else {
         if (get_inheritance_tag_info(cm, 1, true)) {
            mou_hour_glass(1);
            ctl_member_tree_view.add_members_of(cm.qualified_name, cm.tag_database, cm.file_name);
            mou_hour_glass(0);
         }
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Update other views when viewer gets focus, important because
// inheritance view, call tree, and props can also update the output
// view, so if they return focus to the class browser, we need to
// restart the update timer.
//
void ctl_inheritance_tree_view.on_got_focus()
{
   // kill the existing timer and start a new one
   cb_kill_timer();
   cb_start_timer(_InheritanceTimerCallback);
}

//////////////////////////////////////////////////////////////////////////////
// Handles double-clock/enter in inheritance tree view, pushing a bookmark
// and displaying the class in the editor for editing.
//
void ctl_inheritance_tree_view.enter,lbutton_double_click()
{
   struct VS_TAG_BROWSE_INFO cm;
   int j = ctl_inheritance_tree_view._TreeCurIndex();
   if (get_inheritance_tag_info(cm, 1, true)) {
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handles spacebar in inheritance tree view, pushing a bookmark
// and displaying the class in the editor for editing, but retaining
// focus in the inheritance tree browser.
//
void ctl_inheritance_tree_view.' '()
{
   struct VS_TAG_BROWSE_INFO cm;
   int j = ctl_inheritance_tree_view._TreeCurIndex();
   if (get_inheritance_tag_info(cm, 1, true)) {
      orig_window_id = p_window_id;
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
      p_window_id = orig_window_id;
      ctl_inheritance_tree_view._set_focus();
   }
}

//////////////////////////////////////////////////////////////////////////////
// Add the parents (classes that 'class_name' derives from) to the
// inheritance tree browser).  tag databases and file names are resolved
// allowing us to display parents that are in other tag files.
// This function is recursive, but limited to CB_MAX_INHERITANCE_DEPTH levels.
// p_window_id must be the inheritance tree control (left tree of window).
//
static int add_parents_of(int j, _str class_name,
                          _str tag_db_name, typeless &tag_files,
                          _str child_file_name, int child_line_no, int depth)
{
   if (depth >= CB_MAX_INHERITANCE_DEPTH) {
      return 0;
   }

   // what tag file is this class really in?
   _str tag_file = find_class_in_tag_file(class_name, normalized, 1, tag_files);
   if (tag_file != '') {
      tag_db_name = tag_file;
   }
   int status = tag_read_db(tag_db_name);
   if (status) {
      return 0;
   }

   // get are parent classes and the tag files they come from
   int result = 0;
   _str parents = cb_get_normalized_inheritance(class_name, tag_dbs, tag_files);

   // check template vs non-template
   int pic_class;
   if (parents == '') {
      pic_class = gi_pic_access_type[0][CB_type_base_class];
   } else {
      pic_class = gi_pic_access_type[0][CB_type_class];
   }

   // need to parse out our outer class name
   _str outername = '';
   _str membername=class_name;
   if (pos('(.*):(.*)', class_name, 1, 'U')) {
      outername  = substr(class_name, pos('S0'), pos('0'));
      membername = substr(class_name, pos('S1'), pos('1'));
   } else if (pos(VS_TAGSEPARATOR_package, class_name)) {
      parse class_name with outername VS_TAGSEPARATOR_package membername;
   }

   // try to look up file_name and type_name for class
   _str file_name  = '';
   status=tag_find_tag(membername, "class", outername);
   if (status==0) {
      tag_get_info(dm, type_name, file_name, line_no, dc, df);
   } else {
      status=tag_find_tag(membername, "struct", outername);
      if (status==0) {
         tag_get_info(dm, type_name, file_name, line_no, dc, df);
      } else {
         status=tag_find_tag(membername, "interface", outername);
         if (status==0) {
            tag_get_info(dm, type_name, file_name, line_no, dc, df);
         } else {
            type_name = "class"
            file_name = child_file_name;
            line_no   = child_line_no;
         }
      }
   }
   if (j<0) {
      file_name = child_file_name;
      line_no   = child_line_no;
   }

   // OK, we are now ready to insert
   if (j < 0) {
      k = TREE_ROOT_INDEX;
      _TreeSetCaption(TREE_ROOT_INDEX, class_name);
      _TreeSetInfo(TREE_ROOT_INDEX, 1, pic_class, pic_class);
   } else {
      k = _TreeAddItem(j, class_name, TREE_ADD_AS_CHILD, pic_class, pic_class, 1);
   }
   _str ucm = tag_db_name ';' class_name ';' type_name ';' file_name ';' line_no;
   _TreeSetUserInfo(k, ucm);

   // recursively process parent classes
   _str orig_tag_file = tag_current_db();
   while (parents != '') {
      parse parents with p1 ';' parents;
      parse tag_dbs with t1 ';' tag_dbs;
      result = add_parents_of(k, p1, t1, tag_files, file_name, line_no, depth+1);
   }

   tag_read_db(orig_tag_file);
   return k;
}


//////////////////////////////////////////////////////////////////////////////
// Add the members of the given class to the list of members in the
// inheritance tree view.  As apposed to the class tree view, members are
// not filtered here.  Members are dispersed into four categories, public,
// protected, private, and package depending on their access flags.
// They are then sorted by caption and (secondary) line number.
// p_window_id must be the member tree control (right tree of window).
//
static int add_members_of(_str class_name, _str tag_db_name, _str in_file_name)
{
   // uh-oh
   if (class_name == '') {
      return(-1);
   }

   // open the database for business
   int status = tag_read_db(tag_db_name);
   if ( status ) {
      return(status);
   }

   // re-use the public, protected, private, package categories
   int j_access[];
   int i_access = 0;
   int j = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (j>0) {
      j_access[i_access]=j;
      ++i_access;
      _TreeDelete(j,'c');
      j = _TreeGetNextSiblingIndex(j);
   }
   if (i_access != 4) {
      _TreeDelete(TREE_ROOT_INDEX, 'c');
      i_access = 0;
   }

   if (i_access == 0) {
      j_access[CB_access_public]    = _TreeAddItem(TREE_ROOT_INDEX, "PUBLIC",    TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 1);
      j_access[CB_access_protected] = _TreeAddItem(TREE_ROOT_INDEX, "PROTECTED", TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 1);
      j_access[CB_access_private]   = _TreeAddItem(TREE_ROOT_INDEX, "PRIVATE",   TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 1);
      j_access[CB_access_package]   = _TreeAddItem(TREE_ROOT_INDEX, "PACKAGE",   TREE_ADD_AS_CHILD, gi_pic_cat_close, gi_pic_cat_open, 1);
   }

   // insert all the members in class, must be in same file as class, no other filtering
   status = tag_find_in_class(class_name);
   while (!status) {
      tag_get_info(member_name, type_name, file_name, line_no, class_name, flags);
      tag_get_detail(VS_TAGDETAIL_arguments, signature);
      caption = tag_tree_make_caption(member_name, type_name, '', flags, signature, false);

      if ((flags & VS_TAGFLAG_inclass) == 0){
         status = tag_next_in_class();
         continue;
      }
      // kick out if this does not come from the given filename
      if (in_file_name != '' && !file_eq(file_name, in_file_name)) {
         status = tag_next_in_class();
         continue;
      }
   
      // function/data, access restrictions and type code for picture selection
      int i_type, i_access;
      tag_tree_filter_member(0, type_name, ((class_name!='')? 1:0), flags, i_access, i_type);
   
      // compute file/id / line number code
      int ucm = line_no;
   
      // get the appropriate bitmap
      pic_member = gi_pic_access_type[i_access][i_type];
      j = _TreeAddItem(j_access[i_access],caption,TREE_ADD_AS_CHILD,pic_member,pic_member,-1);
      _TreeSetUserInfo(j, ucm);
      status = tag_next_in_class();
   }

   // sort each of the access categories
   if (gi_sort_by_line) {
      _TreeSortUserInfo(j_access[CB_access_public   ],'N','I');
      _TreeSortUserInfo(j_access[CB_access_protected],'N','I');
      _TreeSortUserInfo(j_access[CB_access_private  ],'N','I');
      _TreeSortUserInfo(j_access[CB_access_package  ],'N','I');
   } else {
      _TreeSortCaption(j_access[CB_access_public   ],'I','N');
      _TreeSortCaption(j_access[CB_access_protected],'I','N');
      _TreeSortCaption(j_access[CB_access_private  ],'I','N');
      _TreeSortCaption(j_access[CB_access_package  ],'I','N');
   }

   // mark the empty categories as EMPTY
   j = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (j>0) {
      caption = _TreeGetCaption(j);
      parse caption with caption CB_delimeter .;
      child = _TreeGetFirstChildIndex(j);
      if (child <= 0) {
         caption = caption :+ CB_delimeter :+ CB_empty;
      }
      _TreeSetCaption(j, caption);
      j = _TreeGetNextSiblingIndex(j);
   }

   // go to the top of the tree
   _TreeTop();

   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Clear the inheritance view, removing all items in parents tree and
// member list.  p_window_id must be the inheritance tree window ID.
//
static void clear_inheritance_view(_str msg='')
{
   ctl_inheritance_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
   int index = ctl_member_tree_view._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (index > 0) {
      ctl_member_tree_view._TreeDelete(index, 'c');
      index = ctl_member_tree_view._TreeGetNextSiblingIndex(index);
   }
   ctl_inheritance_tree_view._TreeSetCaption(TREE_ROOT_INDEX, msg);
}

//////////////////////////////////////////////////////////////////////////////
// Refresh the inheritance tree view with the given tag specification
// obtained from get_user_tag_info().  If we can show that the class
// hasn't changed, then break out early.
// p_window_id must be the inheritance tree window ID.
//
static void refresh_inheritance_view(struct VS_TAG_BROWSE_INFO &cm)
{
   if (cm.qualified_name == '') {
      cm.qualified_name = cm.class_name;
   }

   if (cm.type_name :== 'enumc' || cm.type_name :== 'enum') {
      return;
   }

   // bail out if there is no class involved or if class name hasn't changed
   int currIndex = ctl_inheritance_tree_view._TreeCurIndex();
   if (currIndex > 0) {
      caption = ctl_inheritance_tree_view._TreeGetCaption(currIndex);
      ucm = ctl_inheritance_tree_view._TreeGetUserInfo(currIndex);
      parse ucm with tag_db_name ';' class_name ';' type_name ';' file_name ';' line_no;
      if (caption :== cm.qualified_name && file_eq(tag_db_name, cm.tag_database) && file_eq(file_name, cm.file_name) && type_name :== cm.type_name) {
         return;
      }
   } else {
      if (cm.qualified_name=='') {
         ctl_inheritance_tree_view._TreeSetCaption(TREE_ROOT_INDEX, "No class selected");
         ctl_inheritance_tree_view._TreeSetUserInfo(TREE_ROOT_INDEX, 0);
      }
   }

   // If a file is not selected, clear the tree
   if (cm.qualified_name == '') {
      clear_inheritance_view();
      return;
   }

   // check that we are positioned on something class-related
   int f = gtbproject_wid;
   if (!f) return;
   int item_depth;
   currIndex  = f.ctl_class_tree_view._TreeCurIndex();
   item_depth = f.ctl_class_tree_view._TreeGetDepth(currIndex);
   value      = f.ctl_class_tree_view._TreeGetUserInfo(currIndex);

   // If a class is not selected, clear the tree
   if (item_depth <= 2) {
      clear_inheritance_view();
      return;
   }
   
   CB_TAG_CATEGORY ctg;
   ctg = gh_cb_categories:[cm.category];
   if (item_depth == 3 && (ctg._isempty() || !ctg.level3_inheritance)) {
      clear_inheritance_view();
   }
   if (item_depth == 4 && (ctg._isempty() || !ctg.level4_inheritance)) {
      clear_inheritance_view();
   }

   // Delete everything in the tree, and insert the new parent hierarchy
   mou_hour_glass(1);
   ctl_inheritance_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
   //_str ext = refer_ext(_file_case(get_extension(cm.file_name)));
   _str ext = _bufname2ext(cm.file_name);
   typeless tag_files = tags_filenamea(ext);
   j = ctl_inheritance_tree_view.add_parents_of(-1, cm.qualified_name,
                                                cm.tag_database, tag_files,
                                                cm.file_name, cm.line_no, 0);
   
   // Initialize the member list for this class
   ctl_inheritance_tree_view._TreeSetCurIndex(j);
   call_event(CHANGE_SELECTED,j,ctl_inheritance_tree_view,ON_CHANGE,'w')
   //mou_hour_glass(0);
}

//////////////////////////////////////////////////////////////////////////////
// THIS is not used?
//
//void cb_refresh_inheritance_view(struct VS_TAG_BROWSE_INFO &cm)
//{
//   // bail out if there is no inheritance form
//   _nocheck _control ctl_inheritance_tree_view;
//   _nocheck _control ctl_member_tree_view;
//   int f = gcbparents_wid;
//   if (!f) return;
//
//   // bail out if type is a macro defininition
//   if (cm.type_name :== 'define') {
//      return;
//   }
//
//   // try to determine the qualified class name
//   if (cm.qualified_name == '') {
//      cm.qualified_name = cm.class_name;
//   }
//   if (tag_tree_type_is_class(cm.class_name)) {
//      cm.qualified_name = _JoinClassWithOuter(cm.class_name, cm.qualified_name, false);
//   }
//
//   // bail out if there is no class involved or if class name hasn't changed
//   int currIndex = f.ctl_inheritance_tree_view._TreeCurIndex();
//   if (currIndex > 0) {
//      caption = f.ctl_inheritance_tree_view._TreeGetCaption(currIndex);
//      ucm = f.ctl_inheritance_tree_view._TreeGetUserInfo(currIndex);
//      parse ucm with tag_db_name ';' class_name ';' type_name ';' file_name ';' line_no;
//      if (caption :== cm.qualified_name && file_eq(tag_db_name, cm.tag_database) && file_eq(file_name, cm.file_name) && type_name :== cm.type_name) {
//         return;
//      }
//   } else {
//      if (cm.qualified_name=='') {
//         f.clear_inheritance_view('No class selected');
//         return;
//      }
//   }
//
//   // Delete everything in the tree, and insert the new parent hierarchy
//   mou_hour_glass(1);
//   f.ctl_inheritance_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
//   _str ext = _bufname2ext(cm.file_name);
//   typeless tag_files = tags_filenamea(ext);
//   j = f.ctl_inheritance_tree_view.add_parents_of(-1, cm.qualified_name,
//                                                  cm.tag_database, tag_files,
//                                                  cm.file_name, cm.line_no, 0);
//   
//   // Initialize the member list for this class
//   f.ctl_inheritance_tree_view._TreeSetCurIndex(j);
//   f.call_event(CHANGE_SELECTED,j,f.ctl_inheritance_tree_view,ON_CHANGE,'w')
//   //mou_hour_glass(0);
//}

//////////////////////////////////////////////////////////////////////////////
// On form creation, get the argument (tag information), and refresh
// the view, cache the window id.
//
void ctl_ok_button.on_create()
{
   gcbparents_wid=p_active_form;
   if (arg() >= 1) {
      struct VS_TAG_BROWSE_INFO cm;
      cm = arg(1);
      refresh_inheritance_view(cm);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Blow away our cached window ID on form destroy
//
void ctl_ok_button.on_destroy()
{
   gcbparents_wid=0;
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Handlers for item properties dialog
//
defeventtab _tbprops_form

//////////////////////////////////////////////////////////////////////////////
// compute name / line number string for sorting, accessing references
//
static _str cb_create_reference_info(_str &file_name, int line_no, int tag_id)
{
   _str pad_line;
   if (line_no < 10) {
      pad_line = '000000';
   } else if (line_no < 100) {
      pad_line = '00000';
   } else if (line_no < 1000) {
      pad_line = '0000';
   } else if (line_no < 10000) {
      pad_line = '000';
   } else if (line_no < 100000) {
      pad_line = '00';
   } else if (line_no < 1000000) {
      pad_line = '0';
   } else {
      pad_line = '';
   }

   return file_name ';' pad_line :+ line_no ';' tag_id;
}

//////////////////////////////////////////////////////////////////////////////
// retrieve information from reference tree or call tree
// p_window_id must be the references or call (uses) tree control.
//
static int get_reference_tag_info(int j, struct VS_TAG_BROWSE_INFO &cm, int &inst_id)
{
   cm.tag_database = '';
   cm.category = '';
   cm.class_name = '';
   cm.member_name = '';
   cm.qualified_name = '';
   cm.type_name = '';
   cm.file_name = '';
   cm.line_no = 0;
   cm.flags = 0;
   cm.return_type = '';
   cm.arguments = '';

   if (j < 0) {
      return 0;
   }

   // open the tag database for business
   ref_database = refs_filename();
   if (ref_database == '') {
      return 0;
   }
   status = tag_read_db(ref_database);
   if ( status ) {
      return 0;
   }

   // get the file name and line number, tag database, and instance ID
   ucm = _TreeGetUserInfo(j);
   parse ucm with cm.file_name ';0*','U' line_no ';' iid;
   if (line_no == '') {
      line_no = 0;
   }
   cm.line_no = line_no;
   inst_id    = iid;

   // get details about the instance (tag)
   if (inst_id > 0) {
      tag_get_instance_info(inst_id, cm.member_name, cm.type_name, cm.flags, cm.class_name, cm.arguments, df, dl);
      //_message_box("got here 3, inst_id="inst_id" member_name="cm.member_name" file_name="cm.file_name" line_no="cm.line_no" args="cm.arguments);
   }

   // is the given file_name and line number valid?
   if (cm.file_name != '') {
      if (cm.line_no > 0 && path_search(cm.file_name) != '') {
         return 1;
      }
      cm.file_name = '';
   }

   // count the number of exact matches for this tag
   _str search_file_name  = cm.file_name;
   _str search_type_name  = cm.type_name;
   _str search_class_name = cm.class_name;
   _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
   _str ext = _bufname2ext(search_file_name);
   typeless tag_files=tags_filenamea(ext);
   int i=0;
   _str tag_filename=next_tag_filea(tag_files,i,false,true);
   while (tag_filename != '') {
      // search for exact match
      alt_type_name = search_type_name;
      //_message_box("member="cm.member_name" type="search_type_name" class="cm.class_name" args="cm.arguments" file="search_file_name);
      status = tag_find_tag(cm.member_name, search_type_name, search_class_name, search_arguments);
      if (status < 0) {
         if (search_type_name :== 'class') {
            alt_type_name = 'interface';
            status = tag_find_tag(cm.member_name, alt_type_name, search_class_name, search_arguments);
         } else if (search_type_name :== 'func') {
            alt_type_name = 'proto';
            status = tag_find_tag(cm.member_name, alt_type_name, search_class_name, search_arguments);
         } else if (search_type_name :== 'proc') {
            alt_type_name = 'procproto';
            status = tag_find_tag(cm.member_name, alt_type_name, search_class_name, search_arguments);
         }
      }
      while (status == 0) {
         // get basic information for this tag, check type and class
         tag_get_info(dm, cm.type_name, cm.file_name, cm.line_no, cname, cm.flags);
         if (cm.type_name :!= search_type_name && cm.type_name != alt_type_name) {
            break;
         }
         if (cm.class_name :!= search_class_name) {
            break;
         }
         // file name matches, then we've found our perfect match!!!
         if (search_file_name == '' || file_eq(search_file_name, cm.file_name)) {
            return 1;
         }
         // get next tag
         status = tag_next_equal(1 /*case sensitive*/);
      }

      // try the next tag file
      tag_filename=next_tag_filea(tag_files,i,false,true);
   }

   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Insert items called or used by the given tag (tag_id) into the given tree.
// Opens the given database.  Returns the number of items inserted.
// p_window_id must be the references tree control.
//
static int cb_add_refs(int i, struct VS_TAG_BROWSE_INFO cm)
{
   // map prototype to proc/func/constr/destr
   int status = tag_read_db(cm.tag_database);
   if ( status ) {
      return 0;
   }
   if (cm.type_name :== 'proto') {
      _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
      if (tag_find_tag(cm.member_name, 'proc', cm.class_name, search_arguments)==0) {
         tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
      } else if (tag_find_tag(cm.member_name, 'func', cm.class_name, search_arguments)==0) {
         tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
      } else if (tag_find_tag(cm.member_name, 'constr', cm.class_name, search_arguments)==0) {
         tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
      } else if (tag_find_tag(cm.member_name, 'destr', cm.class_name, search_arguments)==0) {
         tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
      }
   }
   int flag_mask = p_user;

   // open the tag database for business
   _str ref_database = refs_filename();
   if (ref_database == '') {
      return 0;
   }
   status = tag_read_db(ref_database);
   if ( status ) {
      return 0;
   }

   // match tag up with instance in refernces database
   //message("member="cm.member_name" type="cm.type_name" class="cm.class_name" arguments="cm.arguments);
   int inst_id = tag_match_instance(cm.member_name, cm.type_name, 0, cm.class_name, cm.arguments, cm.file_name, cm.line_no, 1);
   if (inst_id < 0) {
      return 0;
   }
   tag_get_instance_info(inst_id, member_name, type_name, flags, class_name, arguments, file_name, lno);
   //message("instance ID = "inst_id" member_name="member_name" type_name="type_name" class_name="class_name" arguments="arguments);

   // find references to this instance
   int count = 0;
   int longestWW_0 = 0;
   int longestWW_1 = 0;
   int context_id = tag_find_refer_to(inst_id, ref_type, file_name, line_no);
   //_message_box("context id="context_id);
   while (context_id >= -1 && count < def_cb_max_references) {

      // if something is going on, get out of here
      if (count % 20 == 0 && test_event('R') != '') {
         break;
      }
   
      // full path of file and and line number
      if (line_no != 0) {
         lcaption = file_name ': ' line_no;
      } else {
         lcaption = file_name;
      }

      // compute name / line number string for sorting
      int pic_ref;
      _str ucaption = cb_create_reference_info(file_name, line_no, context_id);

      // find the context and create caption and icon for it
      if (context_id > 0) {

         // get details about this tag (for creating caption)
         tag_get_instance_info(context_id, member_name, type_name, flags, class_name, arguments, file_name, lno);
         //_message_box("context_id="context_id" member_name="member_name" file_name="file_name" lno="lno);

         boolean show_it = false;
         if (tag_tree_type_is_func(type_name)) {
            if (flag_mask & CBP_SHOW_procs) {
               show_it = true;
            }
         } else if (tag_tree_type_is_class(type_name)) {
            if (flag_mask & CBP_SHOW_classes) {
               show_it = true;
            }
         } else if (pos("var", type_name) || pos("prop", type_name) || pos("const", type_name)) {
            if (flag_mask & CBP_SHOW_vars) {
               show_it = true;
            }
         } else {
            if (flag_mask & CBP_SHOW_misc) {
               show_it = true;
            }
         }
         if (!show_it) {
            context_id = tag_next_refer_to(inst_id, ref_type, file_name, line_no);
            continue;
         }

         // make caption for this instance
         fcaption = tag_tree_make_caption(member_name, type_name, class_name, flags, '', true);

         // function/data, access restrictions and type code for picture selection
         int i_type, i_access;
         tag_tree_filter_member(0, type_name, ((class_name!='')? 1:0), flags, i_access, i_type);
         pic_ref  = gi_pic_access_type[i_access][i_type];
      } else {
         // reference is outside of this tag file, just display filename, lno
         fcaption = strip_filename(file_name, 'P');
         pic_ref = _pic_file;
      }

      // find-tune column widths if necessary
      parse fcaption with rpart "\t" lpart;
      int ww_0 = _text_width(rpart);
      int ww_1 = _text_width(lpart);
      if (ww_0+CB_TEXT_WIDTH_MARGIN > longestWW_0) {
         longestWW_0 = ww_0+CB_TEXT_WIDTH_MARGIN;
      }
      if (ww_1+CB_TEXT_WIDTH_MARGIN > longestWW_1) {
         longestWW_1 = ww_1+CB_TEXT_WIDTH_MARGIN;
      }
      if (!pos("\t",fcaption)) {
         strappend(fcaption,"\t");
      }

      // insert the item and set the user info
      j = _TreeAddItem(TREE_ROOT_INDEX,fcaption "\t" lcaption,TREE_ADD_AS_CHILD,pic_ref,pic_ref,-1);
      if (j < 0) {
         break;
      }
      _TreeSetUserInfo(j, ucaption);
      ++count;

      // next, please
      context_id = tag_next_refer_to(inst_id, ref_type, file_name, line_no);
   }

   // set the column width
   _col_width(0, longestWW_0);
   _col_width(1, longestWW_1);

   // close the references database
   status = tag_close_db(ref_database,1);
   if ( status ) {
      return 0;
   }

   // return total number of items inserted
   return count;
}

//////////////////////////////////////////////////////////////////////////////
// Refresh the item properities with the given tag information
// Sets all the controls with the appropriate values, and puts the
// member name(type_name) in the caption for the dialog.
//
void cb_refresh_property_view(struct VS_TAG_BROWSE_INFO &cm)
{
   // bail out if we have no member name
   if (cm.member_name == '') {
      return;
   }

   // get the properties dialog window ID
   int f = gtbprops_wid;
   if (!f) {
      return;
   }

   _nocheck _control ctl_props_sstab;
   _nocheck _control ctl_proto_check_box;
   _nocheck _control ctl_const_check_box;
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_static_check_box;
   _nocheck _control ctl_virtual_check_box;
   _nocheck _control ctl_abstract_check_box;
   _nocheck _control ctl_access_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_extern_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_file_text_box;
   _nocheck _control ctl_name_text_box;
   _nocheck _control ctl_aname_text_box;
   _nocheck _control ctl_rname_text_box;
   _nocheck _control ctl_uname_text_box;
   _nocheck _control ctl_type_text_box;
   _nocheck _control ctl_args_list_box;
   _nocheck _control ctl_args_label;
   _nocheck _control ctl_type_label;
   _nocheck _control ctl_template_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_ref_tree_view;
   _nocheck _control ctl_call_tree_view;

   // make sure that cm is totally initialized
   if (cm.tag_database._isempty())   cm.tag_database = '';
   if (cm.category._isempty())       cm.category = '';
   if (cm.class_name._isempty())     cm.class_name = '';
   if (cm.member_name._isempty())    cm.member_name = '';
   if (cm.qualified_name._isempty()) cm.qualified_name = '';
   if (cm.type_name._isempty())      cm.type_name = '';
   if (cm.file_name._isempty())      cm.file_name = '';
   if (cm.return_type._isempty())    cm.return_type = '';
   if (cm.arguments._isempty())      cm.arguments = '';

   // construct string containing all tag information
   cm_string = f.ctl_props_sstab.p_ActiveTab :+ "\t" :+
      cm.tag_database   :+ "\t" :+
      cm.category       :+ "\t" :+
      cm.class_name     :+ "\t" :+
      cm.member_name    :+ "\t" :+
      cm.qualified_name :+ "\t" :+
      cm.type_name      :+ "\t" :+
      cm.file_name      :+ "\t" :+
      cm.line_no        :+ "\t" :+
      cm.flags          :+ "\t" :+
      cm.return_type    :+ "\t" :+
      cm.arguments;

   // blow out of here if tag has not changed
   ucm = f.ctl_name_text_box.p_user;
   if (!ucm._isempty() && ucm._varformat()==VF_LSTR && ucm:==cm_string) {
      return;
   }

   // save tag browse info
   f.ctl_name_text_box.p_user = cm_string;

   // strings for filling in the many text boxes
   _str item_name;
   _str file_name;
   _str caption;

   // construct the item caption
   item_name = tag_tree_make_caption(cm.member_name, cm.type_name, cm.class_name, cm.flags, '', false);

   // enable/disable declarations, depending if they are relevent or not
   if (cm.class_name != '' && cm.member_name != '' && cm.type_name :!= 'enumc' && cm.type_name :!= 'typedef' && cm.type_name :!= 'database' && cm.type_name :!='table' && cm.type_name :!= 'column' && cm.type_name :!= 'view' && cm.type_name :!= 'index') {
      f.ctl_const_check_box.p_enabled        = 1;
      f.ctl_static_check_box.p_enabled       = 1;
      f.ctl_final_check_box.p_enabled        = 1;
      f.ctl_access_check_box.p_enabled       = 1;
      f.ctl_volatile_check_box.p_enabled     = 1;
      f.ctl_synchronized_check_box.p_enabled = 1;
      f.ctl_transient_check_box.p_enabled    = 1;
   } else {
      f.ctl_const_check_box.p_enabled        = 0;
      f.ctl_static_check_box.p_enabled       = 0;
      f.ctl_final_check_box.p_enabled        = 0;
      f.ctl_volatile_check_box.p_enabled     = 0;
      f.ctl_access_check_box.p_enabled       = 0;
      f.ctl_synchronized_check_box.p_enabled = 0;
      f.ctl_transient_check_box.p_enabled    = 0;
   }

   // enable/disable other check-boxes, depending on type of tag
   switch (cm.type_name) {
   case 'proc':
   case 'proto':
   case 'func':
   case 'destr':
   case 'constr':
      f.ctl_inline_check_box.p_enabled   = 1;
      f.ctl_proto_check_box.p_enabled    = 1;
      f.ctl_volatile_check_box.p_enabled = 1;
      f.ctl_const_check_box.p_enabled    = 1;
      f.ctl_static_check_box.p_enabled   = 1;
      f.ctl_final_check_box.p_enabled    = 1;
      if (cm.class_name == '') {
         f.ctl_abstract_check_box.p_enabled = 0;
         f.ctl_virtual_check_box.p_enabled  = 0;
      } else {
         f.ctl_virtual_check_box.p_enabled  = 1;
         f.ctl_abstract_check_box.p_enabled = 1;
      }
      f.ctl_template_check_box.p_enabled     = 1;
      f.ctl_synchronized_check_box.p_enabled = 1;
      f.ctl_transient_check_box.p_enabled    = 0;
      f.ctl_extern_check_box.p_enabled   = 1;
      f.ctl_native_check_box.p_enabled   = 1;
      break;
   case 'var':
   case 'gvar':
   case 'lvar':
   case 'param':
   case 'prop':
      f.ctl_static_check_box.p_enabled   = 1;
      f.ctl_const_check_box.p_enabled    = 1;
      f.ctl_final_check_box.p_enabled    = 1;
      f.ctl_volatile_check_box.p_enabled = 1;
      f.ctl_inline_check_box.p_enabled   = 0;
      f.ctl_proto_check_box.p_enabled    = 0;
      f.ctl_abstract_check_box.p_enabled = 0;
      f.ctl_virtual_check_box.p_enabled  = 0;
      f.ctl_template_check_box.p_enabled = 0;
      f.ctl_synchronized_check_box.p_enabled = 1;
      f.ctl_transient_check_box.p_enabled = 1;
      f.ctl_extern_check_box.p_enabled   = 1;
      f.ctl_native_check_box.p_enabled   = 0;
      break;
   case 'class':
   case 'interface':
      f.ctl_inline_check_box.p_enabled   = 0;
      f.ctl_virtual_check_box.p_enabled  = 0;
      f.ctl_proto_check_box.p_enabled    = 0;
      f.ctl_abstract_check_box.p_enabled = 1;
      f.ctl_volatile_check_box.p_enabled = 0;
      f.ctl_template_check_box.p_enabled = 1;
      f.ctl_synchronized_check_box.p_enabled = 0;
      f.ctl_transient_check_box.p_enabled = 0;
      f.ctl_extern_check_box.p_enabled   = 0;
      f.ctl_native_check_box.p_enabled   = 0;
      break;
   default:
      f.ctl_inline_check_box.p_enabled   = 0;
      f.ctl_virtual_check_box.p_enabled  = 0;
      f.ctl_proto_check_box.p_enabled    = 0;
      f.ctl_abstract_check_box.p_enabled = 0;
      f.ctl_volatile_check_box.p_enabled = 0;
      f.ctl_template_check_box.p_enabled = 0;
      f.ctl_synchronized_check_box.p_enabled = 0;
      f.ctl_transient_check_box.p_enabled = 0;
      f.ctl_extern_check_box.p_enabled   = 0;
      f.ctl_native_check_box.p_enabled   = 0;
      break;
   }

   // append line number to file name
   file_name = cm.file_name ':' cm.line_no;

   // set the text controls, have to toggle p_ReadOnly to do this
   f.ctl_name_text_box.p_ReadOnly = 0;
   f.ctl_file_text_box.p_ReadOnly = 0;
   f.ctl_type_text_box.p_ReadOnly = 0;
   f.ctl_aname_text_box.p_ReadOnly = 0;
   f.ctl_rname_text_box.p_ReadOnly = 0;
   f.ctl_uname_text_box.p_ReadOnly = 0;
   f.ctl_name_text_box._begin_line();
   f.ctl_file_text_box._begin_line();
   f.ctl_type_text_box._begin_line();
   f.ctl_aname_text_box._begin_line();
   f.ctl_rname_text_box._begin_line();
   f.ctl_uname_text_box._begin_line();
   if (cm.member_name!='') {
      f.ctl_name_text_box.p_text = item_name;
      f.ctl_aname_text_box.p_text = item_name;
      f.ctl_rname_text_box.p_text = item_name;
      f.ctl_uname_text_box.p_text = item_name;
      f.ctl_file_text_box.p_text = file_name;
      if (cm.return_type!='') {
         f.ctl_type_text_box.p_text = cm.return_type;
      } else {
         switch (cm.type_name) {
         case 'enum':
         case 'struct':
         case 'class':
         case 'typedef':
         case 'union':
         case 'label':
         case 'interface':
         case 'constructor':
         case 'destructor':
            f.ctl_type_text_box.p_text = cm.type_name;
            break;
         default:
            f.ctl_type_text_box.p_text = '';
            break;
         }
      }
   } else {
      f.ctl_file_text_box.p_text = '';
      f.ctl_type_text_box.p_text = '';
      f.ctl_name_text_box.p_text = '';
      f.ctl_aname_text_box.p_text = '';
      f.ctl_rname_text_box.p_text = '';
      f.ctl_uname_text_box.p_text = '';
   }
   f.ctl_name_text_box.p_ReadOnly = 1;
   f.ctl_file_text_box.p_ReadOnly = 1;
   f.ctl_type_text_box.p_ReadOnly = 1;
   f.ctl_aname_text_box.p_ReadOnly = 1;
   f.ctl_rname_text_box.p_ReadOnly = 1;
   f.ctl_uname_text_box.p_ReadOnly = 1;

   // select the label for the Type/Return Type
   switch (cm.type_name) {
   case 'func':
   case 'proc':
   case 'proto':
   case 'constr':
   case 'destr':
      f.ctl_type_label.p_caption = "Return type:";
      break;
   case 'define':
   case 'constant':
   case 'enumc':
      f.ctl_type_label.p_caption = "Value:";
      break;
   default:
      f.ctl_type_label.p_caption = "Type:";
      break;
   }

   // set some of the simple check boxes, depending on flag values
   f.ctl_inline_check_box.p_value       = (cm.flags & VS_TAGFLAG_inline)?       1:0;
   f.ctl_final_check_box.p_value        = (cm.flags & VS_TAGFLAG_final)?        1:0;
   f.ctl_virtual_check_box.p_value      = (cm.flags & VS_TAGFLAG_virtual)?      1:0;
   f.ctl_const_check_box.p_value        = (cm.flags & VS_TAGFLAG_const)?        1:0;
   f.ctl_static_check_box.p_value       = (cm.flags & VS_TAGFLAG_static)?       1:0;
   f.ctl_abstract_check_box.p_value     = (cm.flags & VS_TAGFLAG_abstract)?     1:0;
   f.ctl_volatile_check_box.p_value     = (cm.flags & VS_TAGFLAG_volatile)?     1:0;
   f.ctl_template_check_box.p_value     = (cm.flags & VS_TAGFLAG_template)?     1:0;
   f.ctl_synchronized_check_box.p_value = (cm.flags & VS_TAGFLAG_synchronized)? 1:0;
   f.ctl_transient_check_box.p_value    = (cm.flags & VS_TAGFLAG_transient)?    1:0;
   f.ctl_extern_check_box.p_value       = (cm.flags & VS_TAGFLAG_extern)?       1:0;
   f.ctl_native_check_box.p_value       = (cm.flags & VS_TAGFLAG_native)?       1:0;

   // set captions for public, protected, private, or package
   if (cm.class_name != '' && cm.member_name != '' && cm.type_name :!= 'enumc' && cm.type_name :!= 'database' && cm.type_name :!= 'define' && cm.type_name :!= 'table' && cm.type_name :!= 'view' && cm.type_name :!= 'column' && cm.type_name :!= 'index') {
      f.ctl_access_check_box.p_value = 1;
      f.ctl_access_check_box.p_enabled = 1;
      switch (cm.flags & VS_TAGFLAG_access) {
      case VS_TAGFLAG_protected:
         f.ctl_access_check_box.p_caption = "Protected"
         break;
      case VS_TAGFLAG_private:
         f.ctl_access_check_box.p_caption = "Private"
         break;
      case VS_TAGFLAG_package:
         f.ctl_access_check_box.p_caption = "Package"
         break;
      default: // VS_TAGFLAG_public:
         f.ctl_access_check_box.p_caption = "Public"
         break;
      }
   } else {
      f.ctl_access_check_box.p_caption = "Public"
      f.ctl_access_check_box.p_value = 0;
      f.ctl_access_check_box.p_enabled = 0;
   }

   // check if there is an extension-specific function
   // for enable-disable of check-boxes
   ext = _bufname2ext(cm.file_name);
   DPindex = find_index('_'ext'_disable_props',PROC_TYPE);
   if (index_callable(DPindex)) {
      call_index(f,DPindex);
   }

   // parse signature and dump into list box
   f.ctl_args_list_box._lbclear();
   int apos;
   _str a = cb_next_arg(cm.arguments, apos, 1);
   while (a != '') {
      f.ctl_args_list_box._lbadd_item(a);
      a = cb_next_arg(cm.arguments, apos, 0);
   }
   f.ctl_args_list_box.p_redraw = true;

   // set value for "Prototype" check box
   f.ctl_proto_check_box.p_value = 0;
   if (cm.type_name :== "proto" || cm.type_name :== "procproto") {
      f.ctl_proto_check_box.p_value = 1;
   }

   // enable or disable the referencs / calls tabs, depending
   // on the presence or absense of a references database
   ref_database = refs_filename();
   enable_refs = (ref_database == '')? 0:1;
   //f.ctl_props_sstab._setEnabled(CB_CALLSUSES_TAB_INDEX,enable_refs);
   //f.ctl_props_sstab._setEnabled(CB_REFERENCES_TAB_INDEX,enable_refs);

   // populate the list of references
   f.ctl_ref_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');

   if (f.ctl_props_sstab.p_ActiveTab==CB_REFERENCES_TAB_INDEX) {

      int count;
      count = f.ctl_ref_tree_view.cb_add_refs(TREE_ROOT_INDEX, cm);

      if (count==0 && tag_tree_type_is_func(cm.type_name)) {
         if (tag_find_tag(cm.member_name, 'proto', cm.class_name, VS_TAGSEPARATOR_args:+cm.arguments)==0) {
            //tag_get_detail(VS_TAGDETAIL_tag_id, proto_tag_id);
            count = f.ctl_ref_tree_view.cb_add_refs(TREE_ROOT_INDEX, cm);
         }
      }
      if (count==0 && tag_tree_type_is_class(cm.type_name)) {
         if (tag_find_tag(cm.member_name, 'interface', cm.class_name)==0) {
            //tag_get_detail(VS_TAGDETAIL_tag_id, proto_tag_id);
            count = f.ctl_ref_tree_view.cb_add_refs(TREE_ROOT_INDEX, cm);
         }
      }

      // sort exactly the way we want things
      f.ctl_ref_tree_view._TreeSortUserInfo(TREE_ROOT_INDEX,'I');
      //f.ctl_ref_tree_view._TreeTop();
   }

   if (f.ctl_props_sstab.p_ActiveTab==CB_CALLSUSES_TAB_INDEX) {

      // refresh the call tree view
      //if (!tag_tree_type_is_func(cm.type_name) || cm.member_name == '') {
      if (cm.member_name == '') {
         f.ctl_call_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
         f.ctl_call_tree_view._TreeSetCaption(TREE_ROOT_INDEX, "No function selected");
         f.ctl_call_tree_view._TreeSetUserInfo(TREE_ROOT_INDEX, 0);
         return;
      }

      // construct the item caption
      item_name = tag_tree_make_caption(cm.member_name, cm.type_name, cm.class_name, cm.flags, cm.arguments, false);

      // open the tag database for business
      _str orig_database = tag_current_db();
      if (ref_database == '') {
         f.ctl_call_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
         return;
      }
      status = tag_read_db(ref_database);
      if ( status ) {
         f.ctl_call_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
         return;
      }

      // match tag up with instance in refernces database
      inst_id = tag_match_instance(cm.member_name, cm.type_name, 0, cm.class_name, cm.arguments, cm.file_name, cm.line_no, 1);
      //say("member_name="cm.member_name" class="cm.class_name" type="cm.type_name" args="cm.arguments" file="cm.file_name" inst_id="inst_id);

      // close the references database and
      // revert back to the original tag database
      status = tag_close_db(ref_database,1);
      //messageNwait("before tag_read_db()");
      s2=tag_read_db(orig_database);
      if ( status ) {
         f.ctl_call_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');
         return;
      }

      //// bail out if item hasn't changed
      //int currIndex;
      //currIndex = f.ctl_call_tree_view._TreeCurIndex();
      //if (currIndex > 0) {
      //   _message_box("got here with flying colors="currIndex);
      //   ucm = f.ctl_call_tree_view._TreeGetUserInfo(currIndex);
      //   _message_box(ucm);
      //   parse ucm with fn ';' ln ';' tag_id;
      //   if (tag_id == inst_id) {
      //      return;
      //   }
      //}

      // compute name / line number string for sorting
      ucm = cb_create_reference_info(cm.file_name, cm.line_no, inst_id);

      // clear out the call tree
      f.ctl_call_tree_view._TreeDelete(TREE_ROOT_INDEX, 'c');

      // set up root function
      f.ctl_call_tree_view._TreeSetUserInfo(TREE_ROOT_INDEX, ucm);

      // look up and insert the items called
      if (inst_id > 0) {
         f.ctl_call_tree_view.call_event(CHANGE_EXPANDED,TREE_ROOT_INDEX,f.ctl_call_tree_view,ON_CHANGE,'w')
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// extension-specific disabling of tag properties check-boxes
//
void _ada_disable_props(int f)
{
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_transient_check_box;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
}
void _asm_disable_props(int f)
{
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_virtual_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_abstract_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   _nocheck _control ctl_extern_check_box;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_virtual_check_box.p_enabled      = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_abstract_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
   f.ctl_extern_check_box.p_enabled       = 0;
}
void _bas_disable_props(int f)
{
   _nocheck _control ctl_static_check_box;
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   f.ctl_static_check_box.p_enabled       = 0;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
}
void _c_disable_props(int f)
{
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_transient_check_box;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
}
void _cob_disable_props(int f)
{
   _nocheck _control ctl_static_check_box;
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_virtual_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_const_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_abstract_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   _nocheck _control ctl_extern_check_box;
   f.ctl_static_check_box.p_enabled       = 0;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_virtual_check_box.p_enabled      = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_const_check_box.p_enabled        = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_abstract_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
   f.ctl_extern_check_box.p_enabled       = 0;
}
void _e_disable_props(int f)
{
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_virtual_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_abstract_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   _nocheck _control ctl_extern_check_box;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_virtual_check_box.p_enabled      = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_abstract_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
   f.ctl_extern_check_box.p_enabled       = 0;
}
void _java_disable_props(int f)
{
   _nocheck _control ctl_template_check_box;
   _nocheck _control ctl_extern_check_box;
   f.ctl_template_check_box.p_enabled     = 0;
   f.ctl_extern_check_box.p_enabled       = 0;
}
void _js_disable_props(int f)
{
   _nocheck _control ctl_template_check_box;
   f.ctl_template_check_box.p_enabled     = 0;
}
void _pas_disable_props(int f)
{
   _nocheck _control ctl_static_check_box;
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_volatile_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   f.ctl_static_check_box.p_enabled       = 0;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_volatile_check_box.p_enabled     = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
}
void _pl_disable_props(int f)
{
   _nocheck _control ctl_final_check_box;
   _nocheck _control ctl_inline_check_box;
   _nocheck _control ctl_virtual_check_box;
   _nocheck _control ctl_synchronized_check_box;
   _nocheck _control ctl_native_check_box;
   _nocheck _control ctl_transient_check_box;
   _nocheck _control ctl_template_check_box;
   f.ctl_final_check_box.p_enabled        = 0;
   f.ctl_inline_check_box.p_enabled       = 0;
   f.ctl_virtual_check_box.p_enabled      = 0;
   f.ctl_synchronized_check_box.p_enabled = 0;
   f.ctl_native_check_box.p_enabled       = 0;
   f.ctl_transient_check_box.p_enabled    = 0;
   f.ctl_template_check_box.p_enabled     = 0;
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click event (opens the file and positions us on the
// line indicated by the reference data), this may or may not be the
// right line to be positioned on.
//
void ctl_ref_tree_view.enter,lbutton_double_click()
{
   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (ctl_ref_tree_view.get_reference_tag_info(ctl_ref_tree_view._TreeCurIndex(), cm, inst_id)) {
      push_pos_in_file(cm.file_name, cm.line_no, 0);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click event (opens the file and positions us on the
// line indicated by the reference data), this may or may not be the
// right line to be positioned on.
//
void ctl_ref_tree_view.' '()
{
   // IF this is an item we can go to like a class name
   orig_window_id = p_window_id;

   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (ctl_ref_tree_view.get_reference_tag_info(ctl_ref_tree_view._TreeCurIndex(), cm, inst_id)) {
      push_pos_in_file(cm.file_name, cm.line_no, 0);
   }

   // restore original focus
   p_window_id = orig_window_id;
   ctl_ref_tree_view._set_focus();
}

//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the reference tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the properties view, inheritance view, and output window.
//
static void _RefListTimerCallback()
{
   // kill the timer
   cb_kill_timer();

   int f = gtbprops_wid;
   if (!f) {
      return;
   }
   _nocheck _control ctl_ref_tree_view;

   // get the current tree index
   int currIndex = f.ctl_ref_tree_view._TreeCurIndex();
   if (currIndex<=0) {
      return;
   }

   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (f.ctl_ref_tree_view.get_reference_tag_info(currIndex, cm, inst_id)) {
      refresh_output_tab(cm, 1);
   } else {
      caption = f.ctl_ref_tree_view._TreeGetCaption(currIndex);
      parse caption with caption "\t" .;
      messageNwait("Could not find tag: " caption);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle on-change event for member list (a tree control) in inheritance
// tree dialog.  The only event handled is CHANGE_LEAF_ENTER, for which
// we utilize push_tag_in_file to push a bookmark and bring up the code in
// the editor.
//
void ctl_ref_tree_view.on_change(int reason,int index)
{
   if (reason == CHANGE_LEAF_ENTER) {
      // get the context information, push book mark, and open file to line
      struct VS_TAG_BROWSE_INFO cm;
      if (ctl_ref_tree_view.get_reference_tag_info(index, cm, inst_id)) {
         push_pos_in_file(cm.file_name, cm.line_no, 0);
      } else {
         caption = _TreeGetCaption(index);
         parse caption with caption "\t" .;
         messageNwait("Could not find tag: " caption);
      }
   } else if (reason == CHANGE_SELECTED) {
      if (_get_focus() == gtbprops_wid.ctl_ref_tree_view) {

         // kill the existing timer and start a new one
         cb_kill_timer();
         cb_start_timer(_RefListTimerCallback);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Update other views when viewer gets focus, important because
// inheritance view, call tree, and props can also update the output
// view, so if they return focus to the class browser, we need to
// restart the update timer.
//
void ctl_ref_tree_view.on_got_focus()
{
   // kill the existing timer and start a new one
   cb_kill_timer();
   cb_start_timer(_RefListTimerCallback);
}

//////////////////////////////////////////////////////////////////////////////
// try to restore property view from previously stored information
//
static void maybe_restore_property_view(typeless ucm)
{
   struct VS_TAG_BROWSE_INFO cm;
   if (!ucm._isempty() && ucm._varformat() == VF_LSTR) {
      parse ucm with tb "\t" cm.tag_database "\t" cm.category "\t" cm.class_name "\t" cm.member_name "\t" cm.qualified_name "\t" cm.type_name "\t" cm.file_name "\t" ln "\t" fl "\t" cm.return_type "\t" cm.arguments;
      cm.line_no = (isinteger(ln))? (int)ln : 0;
      cm.flags   = (isinteger(fl))? (int)fl : 0;
      cb_refresh_property_view(cm);
   }
}

//////////////////////////////////////////////////////////////////////////////
// update the properties tab when they expose the refs or uses tabs
//
void ctl_props_sstab.on_change(int reason)
{
   if (reason == CHANGE_TABACTIVATED) {
      switch (p_ActiveTab) {
      case CB_PROPERTIES_TAB_INDEX:
      case CB_ARGUMENTS_TAB_INDEX:
         break;
      case CB_REFERENCES_TAB_INDEX:
      case CB_CALLSUSES_TAB_INDEX:
         maybe_restore_property_view(ctl_name_text_box.p_user);
         break;
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// On form creation, get argument, and pass to refresh, cache window ID.
//
void ctl_props_sstab.on_create()
{
   gtbprops_wid=p_active_form;

   // Init vars private to tab control:
   typeless ht:[];
   ht:["_formW"] = p_active_form.p_width;
   ht:["_formH"] = p_active_form.p_height;
   ht:["_output_sstabW"] = p_width;
   ht:["_output_sstabH"] = p_height;

   // Find tab height and max tabs width:
   int i;
   int tallest = 0;
   int totalWidth = 0;
   for (i=0; i<p_NofTabs; ++i) {
      _str text;
      text = _getTabInfo(i);
      parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
      tabHeight = _dy2ly(SM_TWIP,y2 - y1);
      if (tabHeight > tallest) tallest = tabHeight;
      totalWidth += maxW;
   }
   ht:["tabHeight"] = tallest;
   ht:["pictureOnlyW"] = _dx2lx(SM_TWIP,totalWidth) + _dx2lx(SM_TWIP,4);
   p_user = ht;

   // If active tab is specified as arg(2).  Otherwise, use the saved value.
   if (arg() >= 2) {
      p_ActiveTab = arg(2);
   } else {
      _retrieve_value();
   }

   ctl_ref_tree_view.p_user = _retrieve_value("_tbprops_form.ctl_ref_tree_view.p_user");
   if (ctl_ref_tree_view.p_user == "") {
      ctl_ref_tree_view.p_user = 0xffffffff;
   }
   ctl_call_tree_view.p_user = _retrieve_value("_tbprops_form.ctl_call_tree_view.p_user");
   if (ctl_call_tree_view.p_user == "") {
      ctl_call_tree_view.p_user = 0xffffffff;
   }

   // if we were passed a tag argument, display its properties
   struct VS_TAG_BROWSE_INFO cm;
   if (arg() >= 1) {
      cm = arg(1);
      cb_refresh_property_view(cm);
   } else {
      typeless ucm = _retrieve_value("_tbprops_form.ctl_name_text_box.p_user");
      maybe_restore_property_view(ucm);
   }
}

//////////////////////////////////////////////////////////////////////////////
// On destroy, blow away the cached window ID
//
void _tbprops_form.on_destroy()
{
   value = ctl_props_sstab.p_ActiveTab;
   _append_retrieve(ctl_props_sstab, value );
   _append_retrieve(0, ctl_ref_tree_view.p_user, "_tbprops_form.ctl_ref_tree_view.p_user");
   _append_retrieve(0, ctl_call_tree_view.p_user, "_tbprops_form.ctl_call_tree_view.p_user");
   _append_retrieve(0, ctl_name_text_box.p_user,  "_tbprops_form.ctl_name_text_box.p_user");
   gtbprops_wid=0;
   call_event(p_window_id,ON_DESTROY,'2');
}

//////////////////////////////////////////////////////////////////////////////
// For any check box on this form, make it behave as read-only by
// resetting it's value in the lbutton_up callback.
//
void ctl_static_check_box.lbutton_up()
{
   p_value = (p_value)? 0:1;
}

//////////////////////////////////////////////////////////////////////////////
// handle resize event
//
void _tbprops_form.on_resize()
{
   int forcedResize;
   forcedResize = 0;
   if (arg() > 0) forcedResize = arg(1);

   typeless lastW, lastH;
   typeless ht:[];
   ht = ctl_props_sstab.p_user;
   if (ht._indexin("formWH")) {
      _str text;
      text = ht:["formWH"];
      parse text with lastW lastH;
      if (!forcedResize && lastW == p_width && lastH == p_height) return;
   } else {
      ht:["formWH"] = p_width:+" ":+p_height;
      ctl_props_sstab.p_user = ht;
      return;
   }

   tabHeight = ht:["tabHeight"];
   sstabW = _dx2lx(SM_TWIP,p_client_width)  - 2 * ctl_props_sstab.p_x;
   sstabH = _dy2ly(SM_TWIP,p_client_height) - 2 * ctl_props_sstab.p_y;

   // border size
   int border_x, border_y;
   border_x = ctl_call_tree_view.p_x;
   border_y = ctl_name_text_box.p_y;

   // available space and border usage
   int avail_x, avail_y;
   avail_x  = _dx2lx(SM_TWIP,p_active_form.p_client_width);
   avail_y  = _dy2ly(SM_TWIP,p_active_form.p_client_height);

   // x-position and height of tag name text box
   name_x  = ctl_name_text_box.p_x;
   name_y  = ctl_name_text_box.p_height;

   // size the tree controls
   ctl_props_sstab.p_width  = avail_x;
   ctl_props_sstab.p_height = avail_y - ctl_props_sstab.p_y;

   /*
   // Toggle tab control to display tab with text and images or just images:
   if (sstabW < ht:["pictureOnlyW"]) {
      if (ctl_props_sstab.p_PictureOnly != TRUE) {
         ctl_props_sstab.p_PictureOnly = TRUE;
      }
   } else {
      if (ctl_props_sstab.p_PictureOnly != FALSE) {
         ctl_props_sstab.p_PictureOnly = FALSE;
      }
   }
   */

   // adjust the items inside the properties tab
   ctl_name_text_box.p_width = avail_x - name_x - border_x*2;
   ctl_file_text_box.p_width = avail_x - name_x - border_x*2;

   _control ctl_static_check_box;
   _control ctl_const_check_box;
   _control ctl_final_check_box; 
   _control ctl_proto_check_box;
   _control ctl_inline_check_box;
   _control ctl_volatile_check_box;
   _control ctl_access_check_box;
   _control ctl_abstract_check_box;
   _control ctl_virtual_check_box;
   _control ctl_transient_check_box;
   _control ctl_synchronized_check_box;
   _control ctl_template_check_box;
   _control ctl_native_check_box;
   _control ctl_extern_check_box;

   int check_box_order[];
   check_box_order._makeempty();
   check_box_order[ 0] = ctl_static_check_box;
   check_box_order[ 1] = ctl_const_check_box;
   check_box_order[ 2] = ctl_final_check_box; 
   check_box_order[ 3] = ctl_proto_check_box;
   check_box_order[ 4] = ctl_inline_check_box;
   check_box_order[ 5] = ctl_volatile_check_box;
   check_box_order[ 6] = ctl_access_check_box;
   check_box_order[ 7] = ctl_abstract_check_box;
   check_box_order[ 8] = ctl_virtual_check_box;
   check_box_order[ 9] = ctl_transient_check_box;
   check_box_order[10] = ctl_synchronized_check_box;
   check_box_order[11] = ctl_template_check_box;
   check_box_order[12] = ctl_native_check_box;
   check_box_order[13] = ctl_extern_check_box;

   // lay out the check boxes in the maximum number of columns that fit.
   int check_x = ctl_static_check_box.p_x;
   int check_y = ctl_static_check_box.p_y;
   int check_w = ctl_static_check_box.p_width;
   int check_h = ctl_static_check_box.p_y - ctl_file_text_box.p_y - border_y;
   int columns = (int) (avail_x / check_w);
   columns = (columns == 0)? 1 : columns;
   columns = (columns >= 7)? 7 : columns;
   for (i=0; i<check_box_order._length(); i++) {
      int r,c;
      check_box_order[i].p_x = check_x + check_w*(i % columns);
      check_box_order[i].p_y = check_y + check_h*(i intdiv columns);
   }

   // adjust the items inside the arguments tab
   ctl_aname_text_box.p_width = avail_x - name_x - border_x*2;
   ctl_type_text_box.p_width = avail_x - name_x - border_x*2;
   ctl_args_list_box.p_width  = avail_x - name_x - border_x*2;
   ctl_args_list_box.p_height = avail_y - name_y*2 - tabHeight - border_y*5;
   //ctl_api_button.p_y = ctl_args_list_box.p_y + ctl_args_list_box.p_height - ctl_api_button.p_height;

   // adjust the items inside the references tab
   ctl_rname_text_box.p_width = avail_x - name_x - border_x*2;
   ctl_ref_tree_view.p_width = avail_x - border_x*3;
   ctl_ref_tree_view.p_height = avail_y - name_y - tabHeight - border_y*4;

   // adjust the items inside the call tree tab
   ctl_uname_text_box.p_width = avail_x - name_x - border_x*2;
   ctl_call_tree_view.p_width  = avail_x - border_x*3;
   ctl_call_tree_view.p_height = avail_y - name_y - tabHeight - border_y*4;

   // Save form's new XYWH:
   ht:["formWH"] = p_width:+" ":+p_height;
   ctl_props_sstab.p_user = ht;
}

//////////////////////////////////////////////////////////////////////////////
// Handle right-button released event, in order to display pop-up menu
// for the tag properties references or call tree tabs.
// The current object must either be references or call tree.
//
void cb_refs_calls_show_menu()
{
   // kill the refresh timer, prevents delays before the menu comes
   // while the refreshes are finishing up.
   cb_kill_timer();

   // get the menu form
   index=find_index("_cbcalls_menu",oi2type(OI_MENU))
   if (!index) {
      return;
   }
   menu_handle=p_active_form._menu_load(index,'P');

   // Set check marks for menu, depending on current state
   int flags = p_user;
   if (flags & CBP_SHOW_procs) {
      _menu_set_state(menu_handle, "procs", MF_CHECKED, 'C');
   }
   if (flags & CBP_SHOW_classes) {
      _menu_set_state(menu_handle, "classes", MF_CHECKED, 'C');
   }
   if (flags & CBP_SHOW_vars) {
      _menu_set_state(menu_handle, "vars", MF_CHECKED, 'C');
   }
   if (flags & CBP_SHOW_misc) {
      _menu_set_state(menu_handle, "misc", MF_CHECKED, 'C');
   }

   // Show the menu.
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   _KillToolTipMessages();
   status=_menu_show(menu_handle,flags,x,y)
   _menu_destroy(menu_handle);
}

//////////////////////////////////////////////////////////////////////////////
// Handle right-mouse button on the tag references tree control
//
void ctl_ref_tree_view.rbutton_up()
{
   int f = gtbprops_wid;
   if (!f) return;
   f.ctl_ref_tree_view.cb_refs_calls_show_menu();
}

//////////////////////////////////////////////////////////////////////////////
// Handle right-mouse button on the tag references tree control
//
void ctl_call_tree_view.rbutton_up()
{
   int f = gtbprops_wid;
   if (!f) return;
   f.ctl_call_tree_view.cb_refs_calls_show_menu();
}

//////////////////////////////////////////////////////////////////////////////
// Menu callback for references or call tree.
// p_window_id must be the call tree control.
//
_command cb_show_refs_uses(_str type_name='') name_info(','EDITORCTL_ARG2)
{
   // be picky, this command only can be ran from tree control
   if (p_object!=OI_TREE_VIEW) {
      return '';
   }
   if (p_name!='ctl_call_tree_view' && p_name!='ctl_ref_tree_view') {
      return '';
   }

   // translate string argument to CBP_SHOW_* flag
   int flag = CBP_SHOW_misc;
   switch (type_name) {
   case 'procs':   flag = CBP_SHOW_procs;   break;
   case 'classes': flag = CBP_SHOW_classes; break;
   case 'vars':    flag = CBP_SHOW_vars;    break;
   case 'misc':    flag = CBP_SHOW_misc;    break;
   }

   // toggle the flag in the mask
   show_mask1 = p_user;
   show_mask1 = (show_mask1 ^ flag);
   p_user = show_mask1;

   // clear out the call tree
   _TreeDelete(TREE_ROOT_INDEX, 'c');

   // look up and insert the items called
   call_event(CHANGE_EXPANDED,TREE_ROOT_INDEX,p_window_id,ON_CHANGE,'w')
}

//////////////////////////////////////////////////////////////////////////////
//
//_str def_os2apiidx_filename;
//_str def_apiidx_filename;
//
//void ctl_api_button.lbutton_up()
//{
//   // get the current tag name
//   _str word;
//   word = ctl_name_text_box.p_text;
//   if (pos('::', word)) {
//      parse word  with cname '::' word '(';
//   } else {
//      parse word with word '(';
//   }
//
//   // show API help choices
//   if (machine()=='OS2386') {
//      status=show('-modal _help_index_form',def_os2apiidx_filename,word,'A');
//   } else {
//      status=show('-modal _help_index_form',def_apiidx_filename,word,'A');
//   }
//
//   // show API help for selected item
//   if (!status) {
//      filename=_param1;FunctionName=_param2;ClassName='';
//      if ( pos('::',FunctionName) ) {
//         parse FunctionName with ClassName'::'FunctionName;
//      }
//      status=ApiApprentice(filename,FunctionName,ClassName,APICall);
//   }
//}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click event (opens the file and positions us on the
// line indicated by the reference data), this may or may not be the
// right line to be positioned on.
//
void ctl_call_tree_view.enter,lbutton_double_click()
{
   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (ctl_call_tree_view.get_reference_tag_info(ctl_call_tree_view._TreeCurIndex(), cm, inst_id)) {
      push_pos_in_file(cm.file_name, cm.line_no, 0);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click event (opens the file and positions us on the
// line indicated by the reference data), this may or may not be the
// right line to be positioned on.
//
void ctl_call_tree_view.' '()
{
   // IF this is an item we can go to like a class name
   orig_window_id = p_window_id;

   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (ctl_ref_tree_view.get_reference_tag_info(ctl_ref_tree_view._TreeCurIndex(), cm, inst_id)) {
      push_pos_in_file(cm.file_name, cm.line_no, 0);
   }

   // restore original focus
   p_window_id = orig_window_id;
   ctl_ref_tree_view._set_focus();
}

//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the reference tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the properties view, inheritance view, and output window.
//
static void _CallTreeTimerCallback()
{
   // kill the timer
   cb_kill_timer();

   int f = gtbprops_wid;
   if (!f) {
      return;
   }
   _nocheck _control ctl_call_tree_view;

   // get the current tree index
   int currIndex = f.ctl_call_tree_view._TreeCurIndex();
   if (currIndex<=0) {
      return;
   }

   // get the context information, push book mark, and open file to line
   struct VS_TAG_BROWSE_INFO cm;
   if (f.ctl_call_tree_view.get_reference_tag_info(currIndex, cm, inst_id)) {
      // find the output tagwin and update it
      refresh_output_tab(cm, 1);
   } else {
      caption = f.ctl_call_tree_view._TreeGetCaption(currIndex);
      parse caption with caption "\t" .;
      messageNwait("Could not find tag: " caption);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Insert items called or used by the given tag (tag_id) into the given tree.
// Opens the given database.  Returns the number of items inserted.
// p_window_id must be the call tree control.
//
static int cb_add_uses(int i, struct VS_TAG_BROWSE_INFO &cm, int context_id)
{
   // compute best width to use for first tab
   int longestWW = 0;
   if (_TreeGetFirstChildIndex(TREE_ROOT_INDEX) > 0) {
      longestWW = _col_width(0);
   }

   // open the tag database for business
   _str ref_database = refs_filename();
   if (ref_database == '') {
      return 0;
   }
   int status = tag_read_db(ref_database);
   if ( status ) {
      return 0;
   }

   // get filtering flags for call tree
   int flag_mask = p_user;

   // find references to this instance
   inst_id = tag_find_refer_by(context_id, ref_type, file_name, line_no);
   //_message_box("context_id="context_id" member_name="cm.member_name" class_name="cm.class_name" arguments="cm.arguments);
   int count = 0;
   while (count < def_cb_max_references && inst_id >= -1) {

      // if something is going on, get out of here
      if (count % 20 == 0 && test_event('RK') != '') {
         break;
      }
   
      // full path of file and and line number
      if (line_no != 0) {
         lcaption = file_name ': ' line_no;
      } else {
         lcaption = file_name;
      }

      // compute name / line number string for sorting
      int pic_ref;
      _str ucaption = cb_create_reference_info(file_name, line_no, inst_id);

      // by default, insert as a leaf node
      show_children = -1;

      // find the context and create caption and icon for it
      if (inst_id > 0) {

         // get details about this tag (for creating caption)
         tag_get_instance_info(inst_id, member_name, type_name, flags, class_name, arguments, file_name, line_no);
         //_message_box("inst_id="inst_id" member_name="member_name" type_name="type_name" class_name="class_name" arguments="arguments" file_name="file_name" line_no="line_no);
      }

      if (inst_id > 0 && member_name != '') {
         // check if this item should be skipped
         boolean show_it = false;
         if (tag_tree_type_is_func(type_name)) {
            show_children = 0;
            if (flag_mask & CBP_SHOW_procs) {
               show_it = true;
            }
         } else if (tag_tree_type_is_class(type_name)) {
            show_children = 0;
            if (flag_mask & CBP_SHOW_classes) {
               show_it = true;
            }
         } else if (pos("var", type_name) || pos("prop", type_name) || pos("const", type_name)) {
            if (flag_mask & CBP_SHOW_vars) {
               show_it = true;
            }
         } else {
            if (flag_mask & CBP_SHOW_misc) {
               show_it = true;
            }
         }
         if (!show_it) {
            inst_id = tag_next_refer_by(context_id, ref_type, file_name, line_no);
            continue;
         }

         // create caption for this item
         fcaption = tag_tree_make_caption(member_name, type_name, class_name, flags, '', false);

         // function/data, access restrictions and type code for picture selection
         int i_type, i_access;
         tag_tree_filter_member(0, type_name, ((class_name!='')? 1:0), flags, i_access, i_type);

         // get the appropriate bitmap
         pic_ref = gi_pic_access_type[i_access][i_type];
      } else {
         // reference is outside of this tag file, just display filename, line_no
         fcaption = strip_filename(file_name, 'P');
         pic_ref = _pic_file;
      }

      // compute name / line number string for sorting
      ucaption = cb_create_reference_info(file_name, line_no, inst_id);

      // find-tune column widths if necessary
      int ww = _text_width(fcaption);
      if (ww+CB_TEXT_WIDTH_MARGIN > longestWW) {
         longestWW = ww+CB_TEXT_WIDTH_MARGIN;
      }

      // insert the item and set the user info
      j = _TreeAddItem(i,fcaption "\t" lcaption,TREE_ADD_AS_CHILD,pic_ref,pic_ref,show_children);
      if (j < 0) {
         break;
      }
      _TreeSetUserInfo(j, ucaption);
      ++count;

      // next, please
      inst_id = tag_next_refer_by(context_id, ref_type, file_name, line_no);
   }

   // set the column width
   _col_width(0, longestWW);

   // close the references database
   status = tag_close_db(ref_database,1);
   if ( status ) {
      return 0;
   }

   // return total number of items inserted
   return count;
}

//////////////////////////////////////////////////////////////////////////////
// Handle on-change event for member list (a tree control) in inheritance
// tree dialog.  The only event handled is CHANGE_LEAF_ENTER, for which
// we utilize push_tag_in_file to push a bookmark and bring up the code in
// the editor.
//
void ctl_call_tree_view.on_change(int reason,int currIndex)
{
   if (reason == CHANGE_LEAF_ENTER) {
      // get the context information, push book mark, and open file to line
      struct VS_TAG_BROWSE_INFO cm;
      if (ctl_call_tree_view.get_reference_tag_info(currIndex, cm, inst_id)) {
         push_pos_in_file(cm.file_name, cm.line_no, 0);
      } else {
         caption = _TreeGetCaption(currIndex);
         parse caption with caption "\t" .;
         messageNwait("Could not find tag: " caption);
      }
   } else if (reason == CHANGE_EXPANDED) {

      mou_hour_glass(1);
      struct VS_TAG_BROWSE_INFO cm;
      if (ctl_call_tree_view.get_reference_tag_info(currIndex, cm, inst_id)) {
         if (inst_id > 0) {

            if (currIndex == TREE_ROOT_INDEX) {
               ctl_call_tree_view._TreeDelete(currIndex, 'c');
            }

            // insert the items we reference into the call tree
            int count = ctl_call_tree_view.cb_add_uses(currIndex, cm, inst_id);

            // sort exactly the way we want things
            ctl_call_tree_view._TreeSortUserInfo(currIndex,'I');
         }
      }
      mou_hour_glass(0);
   } else if (reason == CHANGE_COLLAPSED) {
      ctl_call_tree_view._TreeDelete(currIndex,'c');
   } else if (reason == CHANGE_SELECTED) {
      if (_get_focus() == ctl_call_tree_view) {

         // kill the existing timer and start a new one
         cb_kill_timer();
         cb_start_timer(_CallTreeTimerCallback);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Update other views when viewer gets focus, important because
// inheritance view, call tree, and props can also update the output
// view, so if they return focus to the class browser, we need to
// restart the update timer.
//
void ctl_call_tree_view.on_got_focus()
{
   // kill the existing timer and start a new one
   cb_kill_timer();
   cb_start_timer(_CallTreeTimerCallback);
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Refresh the output symbols tab (peek-a-boo window)
//
static void refresh_output_tab(struct VS_TAG_BROWSE_INFO &cm, int just_go_there)
{
   // check if there is a load-tags function, if so, bail out
   _str ext=_bufname2ext(cm.file_name);
   int index=find_index('vs'ext'-load-tags',PROC_TYPE);
   if (index_callable(index)) {
      return;
   }

   // if the symbol window has "Prototypes" shut off, display the proc instead
   // if one is found.
   if (!(def_tagwin_flags & VS_TAGFILTER_PROTO)) {
      if (cm.type_name :== 'proto' || cm.type_name :== 'procproto') {
         _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
         if (tag_find_tag(cm.member_name, 'proc', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'func', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'constr', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'destr', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         }
      }
   }

   // find the output tagwin and update it
   _nocheck _control ctltagname;
   int f = _GetTagwinWID();
   if (f && (cm.member_name != '' || just_go_there)) {
      if (just_go_there) {
         f.ctltagname.p_user = cm.file_name "\t" cm.line_no "\tJUST_GO_THERE";
      } else {
         f.ctltagname.p_user = cm.file_name "\t" cm.line_no;
      }
      if (cm.type_name == '') {
         f.ctltagname.p_text = cm.member_name;
      } else if (cm.class_name == '') {
         f.ctltagname.p_text = cm.member_name '(' cm.type_name ')';
      } else {
         f.ctltagname.p_text = cm.member_name '(' cm.class_name ':' cm.type_name ')';
      }
   }
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// command control / menu entry points
//

//////////////////////////////////////////////////////////////////////////////
// Bring up class browser options form
//
_command cb_options() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   f.show("-xy _cboptions_form");
}

//////////////////////////////////////////////////////////////////////////////
// Bring up tag properties form and hand it the tag information for
// the current tag.
//
_command cb_props() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   int currIndex = f.ctl_class_tree_view._TreeCurIndex();
   struct VS_TAG_BROWSE_INFO cm;
   f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);
   if (!gtbprops_wid) {
      tbShow("_tbprops_form");
      cb_refresh_property_view(cm);
   }
   _nocheck _control ctl_props_sstab;
   if (gtbprops_wid) {
      gtbprops_wid.ctl_props_sstab.p_ActiveTab = CB_PROPERTIES_TAB_INDEX;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Bring up tag properties form and hand it the tag information for
// the current tag.
//
_command cb_args() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   int currIndex = f.ctl_class_tree_view._TreeCurIndex();
   struct VS_TAG_BROWSE_INFO cm;
   f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);
   if (!gtbprops_wid) {
      tbShow("_tbprops_form");
      cb_refresh_property_view(cm);
   }
   _nocheck _control ctl_props_sstab;
   if (gtbprops_wid) {
      gtbprops_wid.ctl_props_sstab.p_ActiveTab = CB_ARGUMENTS_TAB_INDEX;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Bring up tag properties form and hand it the tag information for
// the current tag.
//
_command cb_references() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   int currIndex = f.ctl_class_tree_view._TreeCurIndex();
   struct VS_TAG_BROWSE_INFO cm;
   f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);
   //f.show("-xy _tbprops_form", cm, 0);
   if (!gtbprops_wid) {
      tbShow("_tbprops_form");
      cb_refresh_property_view(cm);
   }
   _nocheck _control ctl_props_sstab;
   if (gtbprops_wid) {
      gtbprops_wid.ctl_props_sstab.p_ActiveTab = CB_REFERENCES_TAB_INDEX;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Bring up call tree form and hand it the tag information for
// the current tag.
//
_command cb_calltree() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   int currIndex = f.ctl_class_tree_view._TreeCurIndex();
   struct VS_TAG_BROWSE_INFO cm;
   f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);
   if (!gtbprops_wid) {
      tbShow("_tbprops_form");
      cb_refresh_property_view(cm);
   }
   _nocheck _control ctl_props_sstab;
   if (gtbprops_wid) {
      gtbprops_wid.ctl_props_sstab.p_ActiveTab = CB_CALLSUSES_TAB_INDEX;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Bring up class parents form and hand it the tag information for
// the current tag.
//
_command cb_parents() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   int currIndex   = f.ctl_class_tree_view._TreeCurIndex();
   int parentIndex = f.ctl_class_tree_view._TreeGetParentIndex(currIndex);
   f.ctl_class_tree_view._TreeGetInfo(currIndex, show_children);
   struct VS_TAG_BROWSE_INFO cm;
   if (show_children < 0) {
      f.ctl_class_tree_view.get_user_tag_info(parentIndex, cm, false);
   } else {
      f.ctl_class_tree_view.get_user_tag_info(currIndex, cm, false);
   }
   f.show("-xy _cbparents_form", cm);
}

//////////////////////////////////////////////////////////////////////////////
// Callback used by _sellist form when user makes choice of tag
//
static _str _taglist_callback(reason,var result,key)
{
   _nocheck _control _sellist;
   if (reason==SL_ONDEFAULT) {  // Enter key
      result=_sellist.p_line-1;
      return(1);
   }
   return("");
}

//////////////////////////////////////////////////////////////////////////////
// Returns the number of exact matches for the given tag name
// Returns either 0, 1, or 2, since it short cuts the search after
// it determines that there is more than one match.
//
static int number_of_exact_matches(_str proc_name, _str type_name,
                                   _str class_name, typeless &tag_files)
{
   // count the number of exact matches for this tag
   int i=0,count=0;
   _str tag_filename=next_tag_filea(tag_files,i,false,true);
   while (tag_filename != '') {
      status = tag_find_equal(proc_name);
      while (status==0) {
         tag_get_info(dm, tname, df, dl, cname, flg);
         if (type_name=='' || type_name :== tname) {
            if (class_name=='' || class_name :== cname) {
               ++count;
               if (count >= 2) {
                  return 2;
               }
            }
         }
         status = tag_next_equal();
      }
      tag_filename=next_tag_filea(tag_files,i,false,true);
   }

   return count;
}

//////////////////////////////////////////////////////////////////////////////
// Returns the number of prefix matches for the given tag name
// Returns either 0, 1, or 2, since it short cuts the search after
// it determines that there is more than one match.
//
static int number_of_prefix_matches(_str proc_name, typeless &tag_files)
{
   // count the number of exact matches for this tag
   int i=0,count=0;
   _str tag_filename=next_tag_filea(tag_files,i,false,true);
   while (tag_filename != '') {
      int status = tag_find_prefix(proc_name);
      if (status==0) {
         ++count;
         status = tag_next_prefix(proc_name);
         if (status==0) {
            ++count;
         }
      }
      if (count >= 2) {
         return 2;
      }
      tag_filename=next_tag_filea(tag_files,i,false,true);
   }

   return count;
}

//////////////////////////////////////////////////////////////////////////////
// Map tag types to code categories, see CB_*, top of file
// Since we support class nesting, this function only produces a
// best guess for the category.  For globals, however it produces
// exact results.
//
static _str type_to_category(_str type_name, int tag_flags, boolean containers_only)
{
   typeless ctg_name;
   CB_TAG_CATEGORY ctg;
   for (ctg_name._makeempty();;) {
      gh_cb_categories._nextel(ctg_name);
      if (ctg_name._isempty()) break;
      if (ctg_name._varformat() == VF_LSTR) {
         ctg = gh_cb_categories._el(ctg_name);

         // check presence/absence of tag flags
         boolean nzero;
         nzero = (tag_flags & ctg.flag_mask)? true:false;
         //if (nzero != ctg.mask_nzero) {
         //   continue;
         //}

         // check container criteria
         //if (containers_only == true || ctg.is_container == false) {
         //   continue;
         //}

         // OK, look for a matching type name
         for (i=0; i<ctg.tag_types._length(); i++) {
            // get the tag type, has to be either a string or an int
            t1 = ctg.tag_types[i];
            if (t1._varformat() == VF_LSTR) {
               if (!isinteger(t1)) {
                  t1 = tag_find_type(tn,t1);
                  if (t1 < 0) {
                     continue;
                  }
               }
            } else if (t1._varformat() != VF_INT) {
               continue;
            }

            // translate the type id to a type name
            _str tname;
            status=tag_get_type(t1, tname);
            if (status < 0) {
               continue;
            }

            // try to find the item
            if (tname :== type_name) {
               return ctg_name;
            }
         }
      }
   }

   return CB_misc;
}

//////////////////////////////////////////////////////////////////////////////
// Find a tag in the class browser.  This function takes as input a single
// tag argument (optional) and attempts to find a match in some tag database.
// If no argument is given, it attempts to find a tag at the current word.
// If there is no match for the current word, then we use the push tag
// bookmark dialog to dynamically find a tag using prefix matching completion.
// If there are no exact matches for the tag passed in, it will revert to
// the push bookmark dialog.  The result of these operations is a proc_name
// that we need to find.
//
// If the user gave specific information tag(class:type), we first check
// if there is a match for such a beast.  If not, we strip the class and type,
// and attempt to use the proc_name alone and continue.
// 
// Once we have a proc_name, we find all matches, and then pop up a selection
// list dialog for the user to select a tag (unless there are no matches,
// or exactly one match).  The user then selects the match of their choice.
// 
// At this point, we have a triplet of tag_name, type_name, and class_name.
// We then calcuate a caption path for finding the tag in the class
// browser and pass that on to restore_position().
// 
_command cf,cb_find() name_info(TAG_ARG','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   _macro_delete_line();

   _nocheck _control ctl_class_tree_view;
   _nocheck _control _proj_toolbar_sstab;

   // No argument, grab the current word at the cursor
   boolean ignore_tcase = (def_ignore_tcase)? true:false;
   int num_matches = 0;
   _str proc_name  = '';
   _str class_name = '';
   _str type_name  = '';
   _str ext = '';
   if (arg()==0 && _isEditorCtl() && !_no_child_windows()) {
      ext = p_extension;
      _str dummy_tag = '';
      num_matches = context_match_tags(dummy_tag);
      if (num_matches == 0) {
         //say("no_matches");
         proc_name=cur_word(start_col);
      } else {
         tag_get_match(1, dt, proc_name, type_name, df, dl, class_name, dflg, ds, dr);
         //say("tag_name="proc_name" type="type_name" cls="class_name);
         int i;
         for (i=2; i<num_matches; i++) {
            tag_get_match(i, dt, dn, match_type_name, df, dl, match_class_name, dflg, ds, dr);
            //say("tag_name="dn" type="match_type_name" cls="match_class_name);
            if (match_type_name != type_name && !(pos('pro',type_name) && pos('pro',match_type_name))) {
               type_name = '';
            }
            if (match_class_name != class_name) {
               class_name == '';
            }
         }
      }
      ignore_tcase=false;
   } else {
      // get argument passed by user
      tag_tree_decompose_tag(arg(1), proc_name, class_name, type_name, df);
      if (proc_name=='-') {
         proc_name='';
      }
   }
   
   // massage the tag name slightly
   proc_name = strip(proc_name);
   proc_name = translate(proc_name,'_','-');

   // count the number of exact matches for this tag
   // intelligently figure out if they gave class_name / type_name
   typeless tag_files = tags_filenamea(ext);
   int count = number_of_exact_matches(proc_name, type_name, class_name, tag_files);
   if (count == 0 && type_name != '') {
      if (class_name == '') {
         count = number_of_exact_matches(proc_name, '', type_name, tag_files);
         if (count) {
            class_name = type_name;
            type_name = '';
         }
      }
      if (count == 0) {
         count = number_of_exact_matches(proc_name, '', class_name, tag_files);
         if (count) {
            type_name = '';
         }
      }
   }
   if (count==0 && class_name != '') {
      count = number_of_exact_matches(proc_name, type_name, '', tag_files);
      if (count) {
         class_name='';
      }
   }
   if (count==0) {
      type_name='';
      class_name='';
      count = number_of_exact_matches(proc_name, '', '', tag_files);
   }

   // not exactly one exact match, then use push_tag dialog to select a tag
   if (count==0) {
      ignore_tcase = (def_ignore_tcase)? true:false;
      // no exact matches, try prefix matches
      count = number_of_prefix_matches(proc_name, tag_files);
      if (count==0 && arg() > 0) {
         // no prefix matches, revert to command line argument 
         proc_name = arg(1);
         proc_name = strip(proc_name);
         proc_name = translate(proc_name,'_','-');
      }
      for (;;) {
         new_proc_name = show('-modal -reinit _tagbookmark_form', proc_name,'Class Browser Find Tag');
         if (new_proc_name == '') {
            return(COMMAND_CANCELLED_RC)
         }
         proc_name = new_proc_name;
         break;
      }
   }

   // bail out if there aren't any tag files
   _str tag_files_list = tags_filename(false, ext);
   if (warn_if_no_tag_files(tag_files_list)) {
      return(2);
   }

   // initialize list of matching tags
   taglist._makeempty();
   IgnoreCase=false;

   // iterate through each tag file
   int i=0;
   _str tag_filename=next_tag_filea(tag_files,i,false,true);
   while (tag_filename != '') {

      /* Find prefix tag match for proc_name. */
      status = tag_find_equal(proc_name);
      while (! status) {

         tag_get_info(tag_name, tag_type, file_name, line_no, tag_class, tag_flags);

         if (type_name == '' || type_name :== tag_type) {
            if (class_name == '' || class_name :== tag_class) {
               //if (tag_class != '') {
               //   line_item = tag_name "(" tag_class ":" tag_type ")";
               //} else {
               //   line_item = tag_name "(" tag_type ")";
               //}
               //taglist[taglist._length()]=line_item;
               taglist[taglist._length()] = tag_tree_compose_tag(tag_name, tag_class, tag_type);
               if (ignore_tcase && !IgnoreCase && tag_case(file_name)=="i") {
                  IgnoreCase=true;
               }
            }
         }

         status = tag_next_equal();
      }

      tag_filename=next_tag_filea(tag_files,i,false,true)
   }

   // If we found any tags.
   tagname=proc_name;

   // If user wants strict language case sensitivity
   if (!ignore_tcase && !IgnoreCase) {
      for (i=0;i<taglist._length();++i) {
         if (tagname:!=substr(taglist[i],1,length(tagname))) {
            taglist._deleteel(i);
            --i;
         }
      }
   }

   // didn't find the tag?
   if (taglist._length()==0) {
      long_msg='.  'nls('You may want to rebuild the tag file.')
      _message_box(nls("Tag '%s' not found",proc_name)long_msg)
      return(1);
   }

   // sort the list and remove duplicates
   taglist._sort('I');
   cf_remove_duplicates(taglist);

   //messageNwait("prompt_user: len="taglist._length());
   if (taglist._length()>=2) {
      option='-reinit';
      if (_find_object('_sellist_form')) {
         option='-new';
      }
      tagname=show('_sellist_form -mdi -modal 'option,
                  nls('Select a Tag Name'),
                  SL_SELECTCLINE,
                  taglist,
                  '',
                  '',  // help item name
                  '',  // font
                  ''   // Call back function
                 );
   } else {
      tagname=taglist[0];
   }
   if (tagname=='') {  
      return(COMMAND_CANCELLED_RC);
   }

   // parse out the tag name, class, and type
   tag_tree_decompose_tag(tagname, proc_name, class_name, type_name, df);

   // found the tag, type, and class name, now find it in a database
   i=0;
   tag_filename=next_tag_filea(tag_files,i,false,true);
   while ( tag_filename!='' ) {

      // Find tag match for proc_name.
      found_it=0;
      status = tag_find_tag(proc_name, type_name, class_name);
      while (status==0) {
         tag_get_detail(VS_TAGDETAIL_name, tag);
         if (proc_name :== tag) {
            found_it=1;
            break;
         }
         status = tag_next_tag(proc_name, type_name, class_name);
      }
      if (found_it) {
         break;
      }

      // didn't find it, try the next file
      tag_filename=next_tag_filea(tag_files,i,false,true)
   }

   // this should NEVER happen
   if (status) {
      long_msg='.  'nls('You may want to rebuild the tag file.')
      _message_box(nls("Tag '%s' not found",tagname)long_msg)
      return(1);
   }

   // get the details on the tag we are looking for
   tag_database = tag_filename;
   tag_get_info(member_name, type_name, file_name, line_no, class_name, flags);

   // display the project form if it isn't already there
   if (!gtbproject_wid) {
      tbShow("_tbproject_form");
   }

   // find the class browser form
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }

   // determine tag category
   _str category;
   if (class_name == '') {
      category = type_to_category(type_name, tag_flags, false);
   } else {
      if (pos('/', class_name)) {
         parse class_name with top_name '/' .;
         category = CB_packages; // guess
      } else if (pos(':', class_name)) {
         parse class_name with top_name ':' .;
         category = CB_classes; // guess
      } else {
         top_name = class_name;
         category = CB_classes; // guess
      }

      status = tag_find_equal(top_name, 1/*case_sensitive*/);
      while (status == 0) {
         tag_get_info(tag, tn, fn, line, cn, flgs);
         if (file_eq(fn, file_name) && cn=='') {
            cat = type_to_category(tn, 0, true);
            if (cat != '') {
               category = cat;
               break;
            }
         }
         status = tag_next_equal(1/*case_sensitive*/);
      }
   }

   // construct the traversal path
   path = tag_tree_make_caption(member_name, type_name, '', flags, '', false);
   if (class_name != '') {
      class_name = translate(class_name, ',,', ':/');
      path = class_name ',' path;
   }

   // compute the tag filename path
   index = f.ctl_class_tree_view._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (index > 0) {
      tag_filename_path = f.ctl_class_tree_view._TreeGetCaption(index);
      parse tag_filename_path with tag_filename_path '(' .;
      parse tag_filename_path with . ': ' filename;
      if (file_eq(strip(filename),tag_filename)) {
         break;
      }
      index = f.ctl_class_tree_view._TreeGetNextSiblingIndex(index);
   }
   if (index <= 0) {
      return 1;
   }

   // put together final path and pass to restore_position
   path = tag_filename_path ',' category ',' path;

   //_message_box("Restoring: " path);
   index = f.ctl_class_tree_view.restore_position(TREE_ROOT_INDEX, path);
   if (index > 0) {
      f.ctl_class_tree_view._TreeSetCurIndex(index);
      f._proj_toolbar_sstab.p_ActiveTab = CB_BROWSER_TAB_INDEX;
      f.ctl_class_tree_view._set_focus();
      return 0;
   }
   return 1;
}

//////////////////////////////////////////////////////////////////////////////
// Remove duplicates from a list
//
static void cf_remove_duplicates(_str (&list)[])
{
   if (!list._length()) return;
   previous_line=list[0];
   for (i=1;i<list._length();++i) {
      if ( list[i]:==previous_line ) {
         list._deleteel(i);
         --i;
      } else {
         previous_line=list[i];
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Goto the declaration for the currently selected tag in the class browser
// Translates type_name (proc) to (proto).
//
_command cb_goto_decl() name_info(','VSARG2_EDITORCTL)
{
   _nocheck _control ctl_class_tree_view;

   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }

   struct VS_TAG_BROWSE_INFO cm;
   k = f.ctl_class_tree_view._TreeCurIndex();
   if (f.ctl_class_tree_view.get_user_tag_info(k, cm, false)) {
      if (cm.type_name != 'procproto' && cm.type_name != 'proto' && tag_tree_type_is_func(cm.type_name)) {
         _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
         if (tag_find_tag(cm.member_name, 'proto', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'procproto', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         }
      }
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Goto the definitino of the currently selected tag in the class browser
// Translates (proto) to proc, constr, destr, or function, until it
// finds a match.
//
_command cb_goto_proc() name_info(','VSARG2_EDITORCTL)
{
   _nocheck _control ctl_class_tree_view;

   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }

   struct VS_TAG_BROWSE_INFO cm;
   k = f.ctl_class_tree_view._TreeCurIndex();
   if (f.ctl_class_tree_view.get_user_tag_info(k, cm, false)) {
      if (cm.type_name :== 'proto' || cm.type_name :== 'procproto') {
         _str search_arguments  = VS_TAGSEPARATOR_args:+cm.arguments;
         if (tag_find_tag(cm.member_name, 'proc', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'func', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'constr', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         } else if (tag_find_tag(cm.member_name, 'destr', cm.class_name, search_arguments)==0) {
            tag_get_info(cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags);
         }
      }
      push_tag_in_file(cm.member_name, cm.file_name, cm.class_name, cm.type_name, cm.line_no);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Collapse all tree items except for the branch currently having focus
//
_command cb_collapse() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }

   _nocheck _control ctl_class_tree_view;

   mou_hour_glass(1);
   i = f.ctl_class_tree_view._TreeCurIndex();
   while (i > 0) {
      p = f.ctl_class_tree_view._TreeGetParentIndex(i);
      j = f.ctl_class_tree_view._TreeGetFirstChildIndex(p);
      while (j > 0) {
         if (j!=i) {
            f.ctl_class_tree_view._TreeGetInfo(j, show_children);
            if (show_children>=0) {
               f.ctl_class_tree_view._TreeDelete(j, 'c');
               if (show_children>0) {
                  f.ctl_class_tree_view._TreeSetInfo(j, 0);
               }
            }
         }
         j = f.ctl_class_tree_view._TreeGetNextSiblingIndex(j);
      }
      i=p;
   }
   mou_hour_glass(0);
}

//////////////////////////////////////////////////////////////////////////////
// Return the number of children under tree index 'i'
//
int cb_tree_count_children(int t, int index)
{
   int count=0;
   int child = t._TreeGetFirstChildIndex(index);
   while (child > 0) {
      ++count;
      child = t._TreeGetNextSiblingIndex(child);
   }
   return count;
}

//////////////////////////////////////////////////////////////////////////////
// Expand the current item and its children
//
_command cb_expand_children() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }
   _nocheck _control ctl_class_tree_view;

   gi_in_refresh=1;
   mou_hour_glass(1);
   f.ctl_class_tree_view.p_redraw = false;
   int i = f.ctl_class_tree_view._TreeCurIndex();
   if (i >= 0) {

      f.ctl_class_tree_view._TreeGetInfo(i, show_children);
      if (show_children==0) {
         call_event(CHANGE_EXPANDED,i,f.ctl_class_tree_view,ON_CHANGE,'w')
         f.ctl_class_tree_view._TreeSetInfo(i, 1);
      }

      int count = 0;
      int child = f.ctl_class_tree_view._TreeGetFirstChildIndex(i);
      while (child > 0) {
         f.ctl_class_tree_view._TreeGetInfo(child, show_children);
         if (show_children==0) {
            call_event(CHANGE_EXPANDED,child,f.ctl_class_tree_view,ON_CHANGE,'w')
            f.ctl_class_tree_view._TreeSetInfo(child, 1);
            incr = f.ctl_class_tree_view._TreeGetNumChildren(child)+1;
            count += incr;
            if (count % CB_FLOOD_WATER_MARK < incr) {
               _str caption = f.ctl_class_tree_view._TreeGetCaption(i);
               r = cb_warn_overflow(f.ctl_class_tree_view, i, caption, count);
               if (r >= CB_NOAHS_WATER_MARK) {
                  break;
               }
            }

         }
         child = f.ctl_class_tree_view._TreeGetNextSiblingIndex(child);
      }
   }
   f.ctl_class_tree_view.p_redraw = true;
   mou_hour_glass(0);
   gi_in_refresh=0;
}

//////////////////////////////////////////////////////////////////////////////
// Collapse all tree items except list of projects
//
_command cb_crunch() name_info(','VSARG2_EDITORCTL)
{
   int f = gtbproject_wid;
   if (!f) {
      messageNwait("_tbproject_form " nls("not found"));
      return('');
   }

   _nocheck _control ctl_class_tree_view;

   mou_hour_glass(1);
   int j = f.ctl_class_tree_view._TreeGetFirstChildIndex(0);
   while (j > 0) {
      f.ctl_class_tree_view._TreeGetInfo(j, show_children);
      if (show_children>=0) {
         f.ctl_class_tree_view._TreeDelete(j, 'c');
         if (show_children>0) {
            f.ctl_class_tree_view._TreeSetInfo(j, 0);
         }
      }
      j = f.ctl_class_tree_view._TreeGetNextSiblingIndex(j);
   }
   f.ctl_class_tree_view._col_width(0,0);
   mou_hour_glass(0);
}


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Skip over the contents of a C style string
//
static int skip_c_string(_str params,int j,_str ch)
{
   _str re='[\\\'ch']';
   for (;;) {
      j=pos(re,params,j,'r');
      if (!j) {
         // String not terminated.
         return(length(params)+1);
      }
      ch=substr(params,j,1);
      if (ch=='\') {  
         j+=2;               
         continue;
      }
      return(j+1);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Skip over nested parameter sets (parents, <>, [], etc)
//
static int skip_nested(_str params,int j,_str start_ch,_str end_ch)
{
   int nesting=1;
   _str re='[\'start_ch'\'end_ch']';
   for (;;) {
      j=pos(re,params,j,'r');
      //messageNwait('re='re' j='j' end_ch='end_ch);
      if (!j) {
         return(length(params)+1);
      }
      ch=substr(params,j,1);
      if (ch==start_ch) {
         ++nesting;
         ++j;
         continue;
      }
      --nesting;
      //messageNwait('nesting='nesting);
      ++j;
      if (nesting<=0) {
         //messageNwait('j='j);
         return(j);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Get the next argument from the given string, pass find_first==1
// to get the first argument.
//
#define NEXTARG_CHARS1  '[:;,<\[("'']'
static int gnext_arg_index;
_str cb_next_arg(_str params,int &arg_pos,int find_first)
{
   boolean ispascal=((pos(';',params) || pos(':',params)) && 
                     !pos(':[',params) && !pos('::',params))? 1:0;
   //say("ispascal="ispascal);

   if (find_first) {
      gnext_arg_index=1;
   }
   // skip leading spaces
   ch=substr(params,gnext_arg_index,1);
   while ((ch==' ' || ch=="\t") && gnext_arg_index <= length(params)) {
      gnext_arg_index++;
      ch=substr(params,gnext_arg_index,1);
   }
   // pull next argument off of list
   int j;
   j=gnext_arg_index;
outer_loop:
   for (;;) {
      //say('params='substr(params,1,80) ' index=' j);
      j=pos(NEXTARG_CHARS1,params,j,'r');
      if (!j) {
         j=length(params)+1;
         break;
      }
      ch=substr(params,j,1);
      switch (ch) {
      case ':':
         //if (!ispascal) {
            ++j;
         //}
         break;
      case ',':
         if (!ispascal) {
            break outer_loop;
         }
         ++j;
         break;
      case ';':
         break outer_loop;
      case '<':
         j=skip_nested(params,j+1,ch,'>');
         break;
      case '[':
         j=skip_nested(params,j+1,ch,']');
         break;
      case '(':
         j=skip_nested(params,j+1,ch,')');
         break;
      case '"':
      case "'":
         j=skip_c_string(params,j+1,ch);
         break;
      }
   }
   if (j<gnext_arg_index) {
      return('');
   }
   arg_pos = gnext_arg_index;
   result=substr(params,gnext_arg_index,j-gnext_arg_index);
   gnext_arg_index=j+1;
   return (strip(result));
}

