/*
$VerboseHistory: config.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:25a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:24a
 * Comment:
 * Added Explorer Style option to config dialog.
 * Removed keep dir support from config dialog.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

#define COMMON_FONT_PLACES ('Command-Line='CFG_CMDLINE:+\
                    ' Message-Line='CFG_MESSAGE:+\
                    ' Status-Text='CFG_STATUS:+\
                    ' Window-Text='CFG_WINDOW_TEXT:+\
                    ' Selection-List=sellist')
#if __UNIX__
  #define FONT_PLACES (COMMON_FONT_PLACES:+\
                    ' Menu='CFG_MENU:+\
                    ' Dialog='CFG_DIALOG:+\
                    ' Mdi-Child-Icon='CFG_MDICHILDICON:+\
                    ' Mdi-Child-Title='CFG_MDICHILDTITLE)
#else
  #define FONT_PLACES (COMMON_FONT_PLACES:+\
                    ' Menu='CFG_MENU)
#endif

#define COMMON_KEYS    ('Enter,':+\
                       'Backspace,':+\
                       'Delete,':+\
                       'Home,':+\
                       'Tab,':+\
                       'Backtab,')

#define CKENTER        ('Nosplit Insert Line,':+\
                       'Split Insert Line,':+\
                       'Maybe Split Insert Line')


      /*The '-' in the following constants are not displayed in the
        list boxes are not displayed and could be omitted, but I left
        them in to help reflect the actual names of the functions
      */
#define CKBACKSPACE 'Rubout,Linewrap-Rubout'

#define CKDELETE    'Delete-Char,Linewrap-Delete-Char'

#define CKHOME      'Begin-line,Begin-Line-Text-Toggle'

#define CKTAB       'Tab,Move-Text-Tab'

#define CKBACKTAB   'Backtab,Move-Text-Backtab'

#define MAXSPECIALCHARS 6
static _str _ignore_change=0;

_cua_textbox(cua)
{
   cb_index=find_index('_ul2_combobx',EVENTTAB_TYPE);
   tb_index=find_index('_ul2_textbox',EVENTTAB_TYPE);
   if (cua) {
      tb2=find_index('_ul2_textbox2',EVENTTAB_TYPE);
      if (cb_index) eventtab_inherit(cb_index,tb2);
      if (tb_index) eventtab_inherit(tb_index,tb2);
      //_cmdline.p_eventtab=tb2;
   } else {
      if (cb_index) eventtab_inherit(cb_index,0);
      if (tb_index) eventtab_inherit(tb_index,0);
      _cmdline.p_eventtab=0;
   }
}
defeventtab _rc_keys_form;
_ckok.lbutton_up()
{
   _macro('m',_macro('s'))

   def_cursorwrap = _cursorwrap.p_value!=0;
   _macro_append("def_cursorwrap="_cursorwrap.p_value";");

   def_updown_col = _updown_col.p_value;
   _macro_append("def_updown_col="_updown_col.p_value";");

   def_linewrap   = _linewrap.p_value!=0;
   _macro_append("def_linewrap="_linewrap.p_value";");

   def_jmp_on_tab = _jumpover_tabs.p_value!=0;
   _macro_append("def_jmp_on_tab="_jumpover_tabs.p_value";");

   def_pull       = _pullchars.p_value!=0;
   _macro_append("def_pull="_pullchars.p_value";");

   def_hack_tabs  = _hacktabs.p_value!=0;
   _macro_append("def_hack_tabs="_hacktabs.p_value";");

   def_modal_tab  = _modaltab.p_value;
   _macro_append("def_modal_tab="_modaltab.p_value";");

   def_cua_textbox  = _cuatb.p_value;
   _cua_textbox(def_cua_textbox);
   _macro_append("def_cua_textbox="def_cua_textbox";");
   _macro_call('_cua_textbox',def_cua_textbox);
   
   def_enter_indent= ctlenterindent.p_value!=0;
   _macro_append("def_enter_tab="_modaltab.p_value";");
   
   
   _config_modify|=CFGMODIFY_DEFVAR;
   p_active_form._delete_window(1);
}
_ckok.on_create()
{
   _macro('m',_macro('s'))
   list = COMMON_KEYS;

   for (;;) {
      parse list with key ',' list;
      if (key == '') {
         break;
      }
      key = translate(key, ' ', '-');
      _key_list._lbadd_item(key)
   }
   _key_list._lbsort()
   _key_list.top();
   _key_list._lbselect_line();

   _command_list.insert_command_list(_key_list.p_line);
   /*
   insert_command_list gets the proper list based on the line number
   in the _key_list list box.
   */

   /*Get Check-box values*/
   _cursorwrap.p_value    = (int)def_cursorwrap;
   _updown_col.p_value    = def_updown_col;
   _linewrap.p_value      = (int)def_linewrap;
   _jumpover_tabs.p_value = (int)def_jmp_on_tab;
   _pullchars.p_value     = (int)def_pull;
   _hacktabs.p_value      = (int)def_hack_tabs;
   _modaltab.p_value      = (int)def_modal_tab;
   ctlenterindent.p_value = (int)def_enter_indent;

   _cuatb.p_value      = (int)(def_cua_textbox!=0);
}


static insert_command_list(...)
{
   key = arg(1);
/*
   How it works:
      This function picks the list to insert from the current line
      number in the keys list box
*/
   switch (key) {
   case 1:
      list = CKBACKSPACE;break;
   case 2:
      list = CKBACKTAB;break
   case 3:
      list = CKDELETE;break;
   case 4:
      list = CKENTER;break;
   case 5:
      list = CKHOME;break;
   case 6:
      list = CKTAB;break;
   }
   for (;;) {
      parse list with entry ',' list;
      if (entry == '') {
         break;
      }
      entry = translate(entry, ' ', '-');
      _lbadd_item(entry);
   }
   _command_list.select_proper(_key_list.p_line);
}


/*This function matches the line number in one list box to an event.
  Probably not the best way to handle the problem*/
static select_proper(line_num)
{

   key = line_num;

   switch (key) {
   case 1:
     event  = BACKSPACE;break;
   case 2:
     event  = S_TAB;break
   case 3:
      event = DEL;break;
   case 4:
      event = ENTER;break;
   case 5:
      event = HOME;break;
   case 6:
      event = TAB;break;
   default:
      _message_box('Error');
      return('');
   }
   index = eventtab_index(_default_keys, _default_keys, event2index(event));
   name = translate(name_name(index), ' ', '-');//No '-' in list box

   /*name  of actual command for tab key command 'tab' is 'ctab'.*/
   if (name == 'ctab') {
      name = 'tab';
   }
   if (name == 'cbacktab') {
      name = 'backtab';
   }

   status = _command_list._lbsearch(name);
   if (!status) {
      _command_list._lbselect_line();
      _command_list.line_to_bottom();
   }else{
      _command_list.top();
      _command_list._lbselect_line();
   }
   return(event' 'name);
}

_key_list.on_change()
{
   _command_list._lbclear();
   _command_list.insert_command_list(_key_list.p_line);
}

_command_list.on_change(reason)
{
   set_new_command();
}

static void set_new_command()
{
   key_number = line2event(_key_list.p_line);
   command_name = translate(_command_list._lbget_text(), '-', ' ');
   /*
     Special case for tab command tab - list box says 'Tab', but
     real command is 'ctab'.  There are some other similar special cases
     handled here too.
   */
   if (command_name == 'Tab') {
      if (def_keys=="brief-keys" || def_keys=="emacs-keys"
          || def_keys=="gnuemacs-keys") {
         return;
      }
      command_name = 'ctab';
   }
   if (command_name == 'Backtab') {
      if (def_keys=="brief-keys") return;
      command_name = 'cbacktab';
   }

   index = find_index(lowcase(command_name), COMMAND_TYPE);
   set_eventtab_index(_default_keys, event2index(key_number), index);
   _config_modify|=CFGMODIFY_KEYS;
   _macro('m',_macro('s'))
   _macro_append("set_eventtab_index("_default_keys", "event2index(key_number)", "index");");
}

static line2event(key)
{
   switch (key) {
   case 1:
     event  = BACKSPACE;break;
   case 2:
     event  = S_TAB;break
   case 3:
      event = DEL;break;
   case 4:
      event = ENTER;break;
   case 5:
      event = HOME;break;
   case 6:
      event = TAB;break;
   default:
      _message_box('Error');
      return('');
   }
   return(event);
}

/*End redefine Common Keys Section*/

#if 0
/*List Configuration and Forms Button Section*/
defeventtab _listforms_form
_ok.lbutton_up()
{
   // Return booleans separated by space  "<usersys> <user>"
   result=_modifiedsys_forms.p_value' '_userforms.p_value;
   p_active_form._delete_window(result);//_listforms_form
}

#endif

#define CUA_STYLE 'CN D 1 .'
#define CUAADV_STYLE 'CN D 1 P'
#define SLICKEDITEXT_STYLE 'CI Y 0 P'


defeventtab _emulation_form

_ctlemu_ok.on_create()
{
   _ctlemu_cua_windows.p_user=0;
   _ctlemu_slickedit.p_user=0;
   _ctlemu_brief.p_user=0;
   _ctlemu_emacs.p_user=0;
   _ctlemu_vi.p_user=0;
   _ctlemu_gnu.p_user=0;
   switch (lowcase(def_keys)) {
   case '':
      _ctlemu_slickedit.p_value=1;
      break;
   case 'windows-keys':
      _ctlemu_cua_windows.p_value=1;
      break;
   case 'brief-keys':
      _ctlemu_brief.p_value=1;
      break;
   case 'emacs-keys':
      _ctlemu_emacs.p_value=1;
      break;
   /* 4/18/94 HERE - add check for vi emulation */
   case 'vi-keys':
      _ctlemu_vi.p_value=1;
      break;
   /* add check for Gnu EMACS emulation */
   case 'gnuemacs-keys':
      _ctlemu_gnu.p_value=1;
      break;
   }
}


void _ctlemu_ok.lbutton_up()
{
   set_emulation='';
   if (_ctlemu_cua_windows.p_value) {
      set_emulation='windows';
      new_keys="windows-keys";
   } else if (_ctlemu_slickedit.p_value) {
      set_emulation='slick';
      new_keys="";
   } else if (_ctlemu_brief.p_value) {
      set_emulation='brief';
      new_keys="brief-keys";
   } else if (_ctlemu_emacs.p_value) {
      set_emulation='emacs';
      new_keys="emacs-keys";
   } else if (_ctlemu_vi.p_value) {
      set_emulation='vi'
      new_keys="vi-keys";
   } else if (_ctlemu_gnu.p_value) {
      set_emulation='gnu';
      new_keys="gnuemacs-keys";
   }
   if (def_keys==new_keys) {
      p_active_form._delete_window(0);
      return;
   }
   macro='emulate';
   filename=slick_path_search(macro:+_macro_ext'x');
   if (filename=='') {
      filename=slick_path_search(macro:+_macro_ext);
   }
   if (filename=='') {
      _message_box("File '%s' not found",macro:+_macro_ext'x')
      return;
   }
   orig_wid=p_window_id;
   p_window_id=_mdi.p_child;
   _macro('m',0)
   _no_mdi_bind_all=1;
   macro=maybe_quote_filename(macro);
   status=shell(macro' 'set_emulation);
   _no_mdi_bind_all=0;
   _macro('m',_macro('s'))
   p_window_id=orig_wid;
   _macro_call('shell',macro' 'set_emulation);
   if (status) {
      _message_box(nls("Unable to set emulation.\n\nError probably caused by missing macro compiler or incorrect macro compiler version."));
      return;
   }
   p_active_form._delete_window(0);
}

//-----------------------------------------------------------
defeventtab _config_form
void ctlCompletionOnSpace.lbutton_up()
{
   if (p_value) {
      ctlSpaceInsertsSpace.p_value=0;
   }
}
void ctlSpaceInsertsSpace.lbutton_up()
{
   if (p_value) {
      ctlCompletionOnSpace.p_value=0;
      //ctlCompletionOnSpace.
   }
}
void ctlautolistmembers.lbutton_up()
{
   ctlAutoListMembersIdle.p_prev.p_enabled=ctlAutoListMembersIdle.p_enabled=(p_value)!=0;
}
void _extend.lbutton_up()
{
   _userdefined.p_value=1;
}
void _browsedir.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return;
   }
   p_window_id=wid.p_prev;
   p_text=result;
   end_line();
   _set_focus();
   return;
}
void _browsefile.lbutton_up()
{
   wid=p_window_id;
   result=_OpenDialog('-modal '_stdform('_open_form'),
                      'Choose File',        // Dialog Box Title
                      '',                   // Initial Wild Cards
                      "Help Files (*.idx)", // File Type List
                      OFN_FILEMUSTEXIST     // Flags
                      );
   if (result=='') {
      return;
   }
   p_window_id=wid.p_prev;
   if (p_text=="") {
      p_text = result;
   } else {
      p_text = p_text :+ ";" :+ result;
   }
   end_line();
   _set_focus();
   return;
}
void ctlConfigOK.lbutton_up()
{
   status=config_updateAll();
   if (status) return;
   p_active_form._delete_window();
}
void ctlConfigGeneral_sstab.on_create()
{
   // If active tab is specified as arg(2).  Otherwise, use the saved value.
   if (arg() >= 2) {
      int active;
      active = arg(2);
      p_ActiveTab = active;
   } else {
      _retrieve_value();
   }
   ctldispmembercomment.p_value=(def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS)?1:0;
   ctldispfunctioncomment.p_value=(def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS)?1:0;
   ctlautofunctionhelp.p_value=(def_codehelp_flags & VSCODEHELPFLAG_AUTO_FUNCTION_HELP)?1:0;
   ctlautofunctionhelp.p_value=(def_codehelp_flags & VSCODEHELPFLAG_AUTO_FUNCTION_HELP)?1:0;
   ctlautolistmembers.p_value=(def_codehelp_flags & VSCODEHELPFLAG_AUTO_LIST_MEMBERS)?1:0;

   ctlAutoListMembersIdle.p_text=def_codehelp_idle;
   ctlCompletionOnSpace.p_value=(def_codehelp_flags & VSCODEHELPFLAG_SPACE_COMPLETION)?1:0;
   ctlInsertOpenParen.p_value=(def_codehelp_flags & VSCODEHELPFLAG_INSERT_OPEN_PAREN)?1:0;
   ctlSpaceInsertsSpace.p_value=(def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)?1:0;

   ctlautolistmembers.call_event(ctlautolistmembers,lbutton_up);

   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ALT_MENU_HOTKEYS)) {
      _altmenu_hotkeys.p_enabled=0;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW)) {
      _one_file.p_enabled=0;
   }
   ctlSmartNextWindow.p_value=_default_option(VSOPTION_NEXTWINDOWSTYLE);
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      ctlSmartNextWindow.p_visible=false;
      _maximize_first.p_enabled=0;
      _one_file.p_enabled=0;
      _starton_first.p_enabled=0;
      _restore_process.p_enabled=0;
      _ctlexit_config_always.p_enabled=0;
      _ctlexit_config_prompt.p_enabled=0;
      _ctlexit_confirm.p_enabled=0;
      _confighor_sb.p_enabled=0;
      _configvert_sb.p_enabled=0;
   } else {
#if __UNIX__
      ctlSmartNextWindow.p_visible=0;
#else
      ctlSmartNextWindow.p_visible=1;
#endif
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_SAVERESTORE_EDIT_WINDOWS)) {
      _auto_restore.p_enabled=0;
      _restore_projects.p_enabled=0;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_SAVERESTORE_CWD)) {
      _restore_directory.p_enabled=0;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_ALLOW_DIALOG_ACCESS_TO_PROJECTS)) {
      _restore_projects.p_enabled=0;
   }
   config_initVirtMem();
   config_initMore();
   config_initSpecialChar();
   config_initExit();
   config_initSelStyle();
   config_initSearch();
   config_initGeneral();
}
void ctlConfigGeneral_sstab.on_destroy()
{
   value = p_ActiveTab;
   _append_retrieve( p_window_id, value );
}
static void config_initGeneral()
{
   typeless ht:[];

   _macro('m',_macro('s'))
   _no_mdi_bind_all=0;  // Just in case macro crashed. reset this var.
#if __UNIX__
   _confighide_mp.p_visible=0;
#endif
   wid=_form_parent();
   if (wid.p_view_id>=0) {
      wid=_mdi.p_child;
   }
   _one_file.p_user = wid;

   _cmdline_prompting.p_value = (int)(!def_gui);
   ht:["_cmdline_prompting.p_value"] = _cmdline_prompting.p_value;

   _altmenu_hotkeys.p_value= (int)(def_alt_menu!=0);
   ht:["_altmenu_hotkeys.p_value"] = _altmenu_hotkeys.p_value;

   /*Get Value For One File Per Window*/
   _one_file.p_value = (int)(def_one_file!="");
   ht:["_one_file.p_value"] = _one_file.p_value;

   _maximize_first.p_value = _default_option('f');
   ht:["_maximize_first.p_value"] = _maximize_first.p_value;

   /*Get Value For Alt Menu*/
   _configalt_menu.p_value = (int)(_default_option('A')!=0);
   ht:["_configalt_menu.p_value"] = _configalt_menu.p_value;
   /*note : !(!(xxx)) just changes a number xxx, which can be any
            non-zero into a 1.  This is not actually necessary
     End Get Value For Alt Menu*/

   _configfast_open.p_value = (int)(def_fast_open!=0);//Get fast open Value
   ht:["_configfast_open.p_value"] = _configfast_open.p_value;
   // Only NT 4.0 and Windows 95 support the Explorer open dialog
   if (substr(machine(),1,2)!='NT' || !ntSupportOpenDialog() /*||_win32s()*/) {
      _configfast_open.p_visible=false;
   }

   _configchange_dir.p_value = (int)(def_change_dir!=0);//Get fast open Value
   ht:["_configchange_dir.p_value"] = _configchange_dir.p_value;

   _configtof.p_value = _default_option('T');//Get TOF line value
   ht:["_configtof.p_value"] = _configtof.p_value;

   _confighide_mp.p_value = _default_option('P');
   ht:["_confighide_mp.p_value"] = _confighide_mp.p_value;
   /*Get default hide Mouse value*/

   _confighor_sb.p_value = _default_option('H')
   ht:["_confighor_sb.p_value"] = _confighor_sb.p_value;
   /*Default Display Horizontal Scroll Bar Value*/

   _configvert_sb.p_value = _default_option('V')
   ht:["_configvert_sb.p_value"] = _configvert_sb.p_value;
   /*Default Display Vertical Scroll Bar Value*/

   ctldrawbox.p_value = _default_option('U');
   ht:["ctldrawbox.p_value"] = ctldrawbox.p_value;
   ctldragdrop.p_value = (int)(def_dragdrop!=0);
   ht:["ctldragdrop.p_value"] = ctldragdrop.p_value;
   ctlsingleclick.p_value  = (int)(def_seldisp_single);
   ht:["ctlsingleclick.p_value"] = ctlsingleclick.p_value;

   _vline_col.p_text=_default_option('R');
   ht:["_vline_col.p_text"] = _vline_col.p_text;
   _str dummyText;
   dummyText = _default_option('L') / 1440;
   if (pos('.', dummyText)) {
      ctlWinLeftMargin.p_text = substr(dummyText, 1, 4);
   }else{
      ctlWinLeftMargin.p_text = substr(dummyText, 1, 3);
   }
   ht:["ctlWinLeftMargin.p_text"] = dummyText;

#if !__UNIX__
   _configwh_filename.p_text = (machine()=='OS2386')?def_who:def_wh;
   ht:["_configwh_filename.p_text"] = _configwh_filename.p_text;
#endif

   _configmax_clipboards.p_text = def_clipboards;
   ht:["_configmax_clipboards.p_text"] = _configmax_clipboards.p_text;

   // AutoRestore:
   _auto_restore.p_value = (int)(def_auto_restore!=0);
   ht:["_auto_restore.p_value"] = _auto_restore.p_value;
   _restore_clipboards.p_value = def_restore_flags & RF_CLIPBOARDS;
   _restore_directory.p_value = def_restore_flags & RF_CWD;
   _restore_process.p_value = def_restore_flags & RF_PROCESS;
   _restore_projects.p_value = def_restore_flags & RF_PROJECTFILES;
   ctlLineModify.p_value=(def_restore_flags & RF_LINEMODIFY);
   ctlSelDisp.p_value=(int)!(def_restore_flags & RF_NOSELDISP);
   ctlcbrowser.p_value=(def_restore_flags & RF_CBROWSER_TREE);
   ht:["def_restore_flags"] = def_restore_flags;
   _auto_restore.call_event(_auto_restore, LBUTTON_UP);

   _maximize_first.p_user = ht;
}
void _configbbm.lbutton_up()
{
   ctlbbhelp_delay.p_next.p_enabled=ctlbbhelp_delay.p_enabled=(_configbbm.p_value!=0);
}
static void config_initSearch()
{
   typeless ht:[];

   _macro('m',_macro('s'))
   if (def_persistent_select!='D') {
      _ctlso_leave_selected.p_enabled=0;
   }
   /*Get Search Options*/
   search_options = _default_option('S');
   ht:["search_options"] = search_options;
   _ctlso_match_case.p_value = (int)!(search_options & IGNORECASE_SEARCH);
   _ctlso_re.p_value         = search_options & (RE_SEARCH|UNIXRE_SEARCH|BRIEFRE_SEARCH);
   _ctlso_wrap.p_value       = search_options & WRAP_SEARCH;
   _ctlso_restore_cursor.p_value   = (int)(def_restore_cursor!=0);
   ht:["_ctlso_restore_cursor.p_value"] = _ctlso_restore_cursor.p_value;
   _ctlso_leave_selected.p_value   = (int)(def_leave_selected!=0);
   ht:["_ctlso_leave_selected.p_value"] = _ctlso_leave_selected.p_value;
   if ( def_re_search == RE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 1;
      _ctlso_resyntax_unix.p_value = 0;
      _ctlso_resyntax_brief.p_value = 0;
   } else if ( def_re_search == UNIXRE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 0;
      _ctlso_resyntax_unix.p_value = 1;
      _ctlso_resyntax_brief.p_value = 0;
   } else if ( def_re_search == BRIEFRE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 0;
      _ctlso_resyntax_unix.p_value = 0;
      _ctlso_resyntax_brief.p_value = 1;
   }
   ht:["def_re_search"] = def_re_search;

   if (def_mfsearch_init_flags&MFSEARCH_INIT_HISTORY) {
      _ctlso_init_retrieve.p_value=1;
   }else if (def_mfsearch_init_flags&MFSEARCH_INIT_CURWORD) {
      _ctlso_init_curword.p_value=1;
   }
   if (def_mfsearch_init_flags&MFSEARCH_INIT_SELECTION) {
      _ctlso_init_selection.p_value=1;
   }
   ht:["def_mfsearch_init_flags"] = def_mfsearch_init_flags;

   _ctlso_match_case.p_user = ht;
}
static void config_initSelStyle()
{
   /*

   cursor extend   Inclusive/non inclusive char
   C|E             I|N
cua
   Not allowed in brief emulation
   CN D 1 .

cua advanced
   CN D 1 P

product default
   CN D 1 P   Windows
   EI Y 0 P   slickedit
   CI N 1 P   BRIEF
   CN N 1 P   EMACS
   CN N 1 P   GNU EMACS

slick edit + cursor extends mark

When in windows emulation only enable
     cua and cua advanced.
*/
   typeless ht:[];

   _macro('m',_macro('s'))
   _cuaadv.p_user=CUAADV_STYLE;
   //_slickeditext.p_user=SLICKEDITEXT_STYLE;
   //_slickeditext.p_enabled=0;


   //_advpersistent.p_value=(def_advanced_select=='P')?1:0;
   def_persistent_select=upcase(def_persistent_select);
   ht:["def_persistent_select"] = def_persistent_select;

   _deselect_after_paste.p_value= (int)def_deselect_paste;
   ht:["_deselect_after_paste.p_value"] = _deselect_after_paste.p_value;
   def_select_style=upcase(def_select_style);
   ht:["def_select_style"] = def_select_style;
   _inclusive_char.p_value=pos('I',def_select_style);
   _extend.p_value=pos('C',def_select_style);
   ctldelsel.p_value=(int)(def_persistent_select=='D');
   ctlautodeselect.p_value=(int)(def_persistent_select!='Y')

   _shiftcursor.p_enabled=(/*def_keys=='vi-keys'|| */name_on_key(S_UP)=='cua-select');

   enabled=(def_keys=='' || def_keys=='windows-keys' || def_keys=='vi-keys' || def_keys=='gnuemacs-keys');
   _deselect_after_paste.p_enabled=enabled;
   _inclusive_char.p_enabled=enabled;
   _extend.p_enabled=enabled;
   ctldelsel.p_enabled=enabled;
   ctlautodeselect.p_enabled=enabled;

   switch(lowcase(def_keys)) {
   case 'windows-keys':
      _product_default.p_user='CN D 1 P'
      _product_default.p_enabled=0;
      break;
   case '':
      _product_default.p_user='EI Y 0 P'
      //_slickeditext.p_enabled=1;
      break;
   case 'brief-keys':
      _product_default.p_user='CI N 1 P'
      _product_default.p_caption='BRIEF Default';
      break;
   case 'emacs-keys':
      _product_default.p_user='CN N 1 P'
      _product_default.p_caption='Epsilon Default';
      break;
   case 'vi-keys':
      _product_default.p_user='CI Y 0 P'
      _product_default.p_caption='VI Default'
      break;
   case 'gnuemacs-keys':
      _product_default.p_user='CN N 1 P'
      _product_default.p_caption='GNU EMACS Default';
      break;
   }

   _shiftcursor.p_value= (int)(def_scursor_style==0);
   ht:["_shiftcursor.p_value"] = _shiftcursor.p_value;
   ctlmouseclipboard.p_value=(int)(def_autoclipboard!=0);
   ht:["ctlmouseclipboard.p_value"] = ctlmouseclipboard.p_value;

   _update_style();

   _userdefined.p_user = ht;
}
static void config_initExit()
{
   typeless ht:[];

   if (def_exit_flags&EXIT_CONFIG_ALWAYS) {
      _ctlexit_config_always.p_value=1;
   }else if (def_exit_flags&EXIT_CONFIG_PROMPT) {
      _ctlexit_config_prompt.p_value=1;
   }
   _ctlexit_confirm.p_value=def_exit_flags&EXIT_CONFIRM;
   ht:["def_exit_flags"] = def_exit_flags;

   _ctlexit_config_always.p_user = ht;
}
void _ctlSpecialCharC1.on_got_focus()
{
   if (data_not_valid() && p_text:!="") {
      _beep();
   }
}
void _ctlSpecialCharC1.on_lost_focus()
{
   _set_sel(1);
   if (data_not_valid() && p_text:!="") {
      _beep();
   }
}
void _ctlSpecialCharC1.on_change()
{
   if (_ignore_change) return;
   text=lowcase(p_text)
   if (text=='x' || text=='0x') {
      _ctlViewDec.p_user='h';
      _ctlViewHex.p_value=1;
   }
   new_char=''
   if (_ctlViewHex.p_value) {
      dec=hex2dec(p_text)
      if (dec!='') {
         new_char=_chr(dec);
      }
   } else {
      if (isinteger(p_text) && p_text<=255 && p_text>=0) {
         new_char=_chr((int)p_text);
      }
   }
   p_prev.p_ReadOnly=0;
   p_prev.p_text=new_char;
   p_prev.p_ReadOnly=1;
}
static int data_not_valid()
{
   old_format=_ctlViewDec.p_user;
   text=p_text;
   //message 'old_format='old_format
   switch (old_format) {
   case 'H':
      dec=hex2dec(text)
      if (dec=='') {
         return(1);
      }
      break;
   case 'A':
      if (length(text)!=1) {
         return(1);
      }
      break;
   default:
      if (!(isinteger(text) && text<=255 && text>=0)) {
         return(1);
      }
   }
   return(0);
}
void _ctlSpecialCharSpin.on_spin_up()
{
   int textwid, charwid;
   textwid = p_prev;
   charwid = textwid.p_prev;

   direction=arg(1);
   if(textwid.data_not_valid()) {
      _beep();
      return;
   }
   text=textwid.p_text;
   if (_ctlViewDec.p_value) {
      dec=text;
   } else if (_ctlViewHex.p_value) {
      dec=hex2dec(text)
   } else {
      dec=_asc(text)
   }
   if (direction!='') {
      if (dec>0) {
         charwid.p_text=_chr(--dec);
      }
   } else {
      if (dec<255) {
         charwid.p_text=_chr(++dec);
      }
   }
   if (_ctlViewDec.p_value) {
      text=dec;
   } else if (_ctlViewHex.p_value) {
      text=dec2hex(dec);
      text = substr(text,3);
      if (length(text) < 2) {
         text = "0x0" :+ text;
      } else {
         text = "0x" :+ text;
      }
   } else {
      text=_chr(dec)
   }
   textwid.set_command(text,1,length(text)+1);
}
void _ctlSpecialCharSpin.on_spin_down()
{
   call_event('-',p_window_id,ON_SPIN_UP,'');
}
static void configSpecialCharNumToggle(_str mode)
{
   int i;
   for (i=1; i<=MAXSPECIALCHARS; i++) {
      typeless val;
      _str ctlName;
      ctlName = "_ctlSpecialCharC" :+ i;
      int wid;
      wid = _find_control(ctlName);
      val = wid.p_text;
      if (mode == 'D') {
         if (_ctlViewDec.p_user == 'H') {
            wid.p_text = hex2dec(val);
         }
      } else if (_ctlViewDec.p_user == 'D') {
         _str text;
         text = dec2hex(val);
         text = substr(text,3);
         if (length(text) < 2) {
            text = "0x0" :+ text;
         } else {
            text = "0x" :+ text;
         }
         wid.p_text = text;
      }
   }
}
void _ctlViewDec.lbutton_up()
{  
   configSpecialCharNumToggle('D');
   _ctlViewDec.p_user = 'D';
}
void _ctlViewHex.lbutton_up()
{
   configSpecialCharNumToggle('H');
   _ctlViewDec.p_user = 'H';
}
static void config_initSpecialChar()
{
   typeless ht:[];

   _str text;
   text = _default_option('Q');
   ht:["specialChars"] = text;

   int i;
   for (i=1; i<=MAXSPECIALCHARS; i++) {
      int val;
      _str ctlName;
      val = _asc(substr(text, i, 1));
      ctlName = "_ctlSpecialCharC" :+ i;
      int wid;
      wid = _find_control(ctlName);
      wid._use_edit_font();
      wid.p_text = val;

      ctlName = "_ctlSpecialCharV" :+ i;
      wid = _find_control(ctlName);
      wid._use_edit_font();
      wid.p_ReadOnly=0;
      wid.p_text = _chr(val);
      wid.p_ReadOnly=1;
   }

   _ctlViewDec.p_user = 'D';
   _ctlViewDec.p_value = 1;

   _ctlViewHex.p_user = ht;
}
static void config_initMore()
{
   typeless ht:[];

   _macro('m',_macro('s'))
   //_vline_col.p_text=_default_option('R');
   //_display_datetime.p_value=_default_option('D');
   //_maximize_first.p_value = _default_option('f');
   _start_insert.p_value = _mdi.p_child._insert_state('','D');
   ht:["_start_insert.p_value"] = _start_insert.p_value;
   _throw_away.p_value     = (int)(def_exit_file_list!=0);
   ht:["_throw_away.p_value"] = _throw_away.p_value;
   _exit_process.p_value   = (int)(def_exit_process!=0);
   ht:["_exit_process.p_value"] = _exit_process.p_value;
   _starton_first.p_value  = (int)(def_start_on_first!=0);
   ht:["_starton_first.p_value"] = _starton_first.p_value;
   _savetop_bottom.p_value = (int)(def_top_bottom_style!=0);
   ht:["_savetop_bottom.p_value"] = _savetop_bottom.p_value;

   //_fast_check.p_value     = (int)(def_pmatch_style==0);
   //ht:["_fast_check.p_value"] = _fast_check.p_value;
   _reflow_next.p_value    = (int)(def_reflow_next!=0);
   ht:["_reflow_next.p_value"] = _reflow_next.p_value;
   _km_delay.p_text        = get_event('D');//returns KM Delay value
   ht:["_km_delay.p_text"] = _km_delay.p_text;
#if 0
   _tag_proto.p_value      = (int)(def_ctags_flags&2);
   ht:["_tag_proto.p_value"]  = _tag_proto.p_value;
   _ignore_tcase.p_value   = (int)(def_ignore_tcase);
   ht:["_ignore_tcase.p_value"] = _ignore_tcase.p_value;
#endif
   _configskeys.p_value = (int)(upcase(def_keydisp)=='C');
   ht:["_configskeys.p_value"] = _configskeys.p_value;

   ctlEraseLineInProcessBuf.p_value = _default_option('I');
   ht:["ctlEraseLineInProcessBuf.p_value"] = ctlEraseLineInProcessBuf.p_value;

   ctlProtectReadonly.p_value = (int)(_default_option('Z')==true);
   ht:["ctlProtectReadonly.p_value"] = ctlProtectReadonly.p_value;

   /*Get Insert Style*/
   if (strip(upcase(def_line_insert)) == 'B') {
      _before.p_value = 1;
   }else{
      _after.p_value = 1;
   }
   ht:["def_line_insert"] = def_line_insert;
   /*End Get Insert Style*/

   /*Get Scroll Style*/
   parse _scroll_style() with style num;
   if (strip(upcase(style)) == 'S') {
      _smooth.p_value = 1;
   }else{
      _center.p_value = 1;
   }
   ht:["scroll_style"] = _scroll_style();
   /*End Get Scroll Style*/

   _scroll.p_text = num;
   ht:["_scroll.p_text"] = _scroll.p_text;

   /*Get Paren Match Style*/
   switch (def_pmatch_style2) {
   case 0:
      _cursor.p_value = 1;break;
   case 1:
      _highlight.p_value = 1;break;
   case '':
      _none.p_value = 1;break;
   /*End Get Paren Match Style*/
   }
   ht:["def_pmatch_style2"] = def_pmatch_style2;

   /*Get Next Word Style*/
   if (upcase(def_next_word_style) == 'E') {
      _configend.p_value = 1;
   }else{
      _configbegin.p_value = 1;
   }
   /*End Get Next Word Style*/
   ht:["def_next_word_style"] = def_next_word_style;

   /*Default button bar messages*/
   _configbbm.p_value = (int)(_default_option(VSOPTION_SHOWTOOLTIPS)!=0);
   ht:["_configbbm.p_value"] = _configbbm.p_value;
   ctlbbhelp_delay.p_next.p_enabled=ctlbbhelp_delay.p_enabled=(_configbbm.p_value!=0);
   ctlbbhelp_delay.p_text=_default_option(VSOPTION_TOOLTIPDELAY);
   ht:["ctlbbhelp_delay.p_text"] = ctlbbhelp_delay.p_text;

   _start_insert.p_user = ht;
}
static void config_initVirtMem()
{
   typeless ht:[];
   _ctlvmem_spill_fp.p_text = _spill_file_path();//Get spill file path
   ht:["_ctlvmem_spill_fp.p_text"] = _ctlvmem_spill_fp.p_text;
   parse _cache_size() with buffer state .;
   _ctlvmem_buffer_cache.p_text = buffer;
   _ctlvmem_state_cache.p_text = state;
   ht:["_ctlvmem_buffer_cache.p_text"] = _ctlvmem_buffer_cache.p_text;
   ht:["_ctlvmem_state_cache.p_text"] = _ctlvmem_state_cache.p_text;

   _ctlvmem_tagging_cache.p_text=def_tag_cache_size;
   ht:["_ctlvmem_tagging_cache.p_text"] = _ctlvmem_tagging_cache.p_text;

   _ctlvmem_spill_fp.p_user = ht;
}
static int config_updateGeneral(int & do_menu_bind)
{
   typeless ht:[];
   ht = _maximize_first.p_user;

   _macro('m',_macro('s'))
   if(_altmenu_hotkeys.p_value != ht:["_altmenu_hotkeys.p_value"]){
      //guisetup relies on def_alt_menu being up to date.
      //altsetup release on def_gui being up to date.
      do_menu_bind=1;
      macro='altsetup';
      filename=slick_path_search(macro:+_macro_ext'x');
      if (filename=='') {
         filename=slick_path_search(macro:+_macro_ext);
      }
      if (filename=='') {
         _message_box("File '%s' not found",macro:+_macro_ext'x')
         return(FILE_NOT_FOUND_RC);
      }
      _macro('m',0)
      _no_mdi_bind_all=1;
      macro=maybe_quote_filename(macro);
      status=shell(macro' 'number2yesno(_altmenu_hotkeys.p_value));
      _no_mdi_bind_all=0;
      _macro('m',_macro('s'))
      _macro_call('shell',macro' 'number2yesno(_altmenu_hotkeys.p_value));
      if (status) {
         _message_box(nls("Unable to set alt menu hotkeys.\n\nError probably caused by missing macro compiler or incorrect macro compiler version."));
         return(1);
      }
   }

   if(_cmdline_prompting.p_value != ht:["_cmdline_prompting.p_value"]){
      do_menu_bind=1;
      macro='guisetup';
      filename=slick_path_search(macro:+_macro_ext'x');
      if (filename=='') {
         filename=slick_path_search(macro:+_macro_ext);
      }
      if (filename=='') {
         _message_box("File '%s' not found",macro:+_macro_ext'x')
         return(FILE_NOT_FOUND_RC);
      }
      _macro('m',0)
      _no_mdi_bind_all=1;
      macro=maybe_quote_filename(macro);
      status=shell(macro' 'number2yesno(!_cmdline_prompting.p_value));
      _no_mdi_bind_all=0;
      _macro('m',_macro('s'))
      _macro_call('shell',macro' 'number2yesno(!_cmdline_prompting.p_value));
      if (status) {
         _message_box(nls("Unable to set cmdline prompt option.\n\nError probably caused by missing macro compiler or incorrect macro compiler version."));
         return(1);
      }
   }

   _macro('m',_macro('s'))

   /*Set Value For One File Per Window*/
   if (_one_file.p_value) {
      def_one_file = '+w';
      if (_one_file.p_value != ht:["_one_file.p_value"]) {
         _macro_append("def_one_file='+w';")
      }
   }else{
      def_one_file = '';
      if (_one_file.p_value != ht:["_one_file.p_value"]) {
         _macro_append("def_one_file='';");
      }
   }

   /*Set Value For Alt-Menu*/
   if (_configalt_menu.p_value) {
      alt_menu('y');
      if (_configalt_menu.p_value != ht:["_configalt_menu.p_value"]) {
         _macro_call('alt_menu', 'y');
      }
   }else{
      alt_menu('n');
      if (_configalt_menu.p_value != ht:["_configalt_menu.p_value"]) {
         _macro_call('alt_menu', 'n');
      }
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_AUTO_FUNCTION_HELP)?1:0;
   if (old_value!=ctlautofunctionhelp.p_value) {
      if (ctlautofunctionhelp.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_AUTO_FUNCTION_HELP;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_AUTO_FUNCTION_HELP;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_AUTO_FUNCTION_HELP;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_AUTO_FUNCTION_HELP;");
      }
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS)?1:0;
   if (old_value!=ctldispmembercomment.p_value) {
      if (ctldispmembercomment.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS;");
      }
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS)?1:0;
   if (old_value!=ctldispfunctioncomment.p_value) {
      if (ctldispfunctioncomment.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS;");
      }
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_AUTO_LIST_MEMBERS)?1:0;
   if (old_value!=ctlautolistmembers.p_value) {
      if (ctlautolistmembers.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_AUTO_LIST_MEMBERS;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_AUTO_LIST_MEMBERS;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_AUTO_LIST_MEMBERS;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_AUTO_LIST_MEMBERS;");
      }
   }
   if (ctlAutoListMembersIdle.p_text!=def_codehelp_idle) {
      if (!isinteger(ctlAutoListMembersIdle.p_text)) {
         ctlAutoListMembersIdle.p_text=0;
      }
      def_codehelp_idle=(int)ctlAutoListMembersIdle.p_text;
      _macro_append("def_codehelp_idle="def_codehelp_idle";");
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_SPACE_COMPLETION)?1:0;
   if (old_value!=ctlCompletionOnSpace.p_value) {
      if (ctlCompletionOnSpace.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_SPACE_COMPLETION;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_SPACE_COMPLETION;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_SPACE_COMPLETION;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_SPACE_COMPLETION;");
      }
   }
   old_value=(def_codehelp_flags & VSCODEHELPFLAG_INSERT_OPEN_PAREN)?1:0;
   if (old_value!=ctlInsertOpenParen.p_value) {
      if (ctlInsertOpenParen.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_INSERT_OPEN_PAREN;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_INSERT_OPEN_PAREN;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_INSERT_OPEN_PAREN;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_INSERT_OPEN_PAREN;");
      }
   }

   old_value=(def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)?1:0;
   if (old_value!=ctlSpaceInsertsSpace.p_value) {
      if (ctlSpaceInsertsSpace.p_value) {
         def_codehelp_flags|=VSCODEHELPFLAG_SPACE_INSERTS_SPACE;
         _macro_append("def_codehelp_flags|=VSCODEHELPFLAG_SPACE_INSERTS_SPACE;");
      } else {
         def_codehelp_flags&=~VSCODEHELPFLAG_SPACE_INSERTS_SPACE;
         _macro_append("def_codehelp_flags&=~VSCODEHELPFLAG_SPACE_INSERTS_SPACE;");
      }
   }

   def_fast_open = (_configfast_open.p_value!=0);//Set Fast open Value
   if (_configfast_open.p_value != ht:["_configfast_open.p_value"]) {
      _macro_append("def_fast_open="_configfast_open.p_value";");
   }

   _default_option('f',_maximize_first.p_value);
   if (_maximize_first.p_value != ht:["_maximize_first.p_value"]) {
      _macro_call('_default_option','f',_maximize_first.p_value);
   }
   def_change_dir = (_configchange_dir.p_value)?OFN_CHANGEDIR:0;//Set Change Dir Value
   if (_configchange_dir.p_value != ht:["_configchange_dir.p_value"]) {
      _macro_append("def_change_dir="def_change_dir";");
   }

   /*Set Value For Top-Line*/
   if (_configtof.p_value) {
      display_top('y');
      if (_configtof.p_value != ht:["_configtof.p_value"]) {
         _macro_call('display_top','y');
      }
   }else{
      display_top('n');
      if (_configtof.p_value != ht:["_configtof.p_value"]) {
         _macro_call('display_top','y');
      }
   }

   /*set Default Delay File Lists Value*/
   //def_delay_filelist = (_configdelay_file_lists.p_value!=0);
   //_macro_append('def_delay_filelist = '_configdelay_file_lists.p_value';');
   if (_default_option('u')!=ctldrawbox.p_value) {
      _default_option('u',ctldrawbox.p_value);
      if (ctldrawbox.p_value != ht:["ctldrawbox.p_value"]) {
         _macro_call('_default_option',"u",_default_option('u'));
      }
   }

   if (ctldragdrop.p_value != ht:["ctldragdrop.p_value"]) {
      def_dragdrop = (ctldragdrop.p_value!=0);
      _macro_append("def_dragdrop="def_dragdrop";");
   }

   /*set default hide Mouse value*/
   if (_confighide_mp.p_value) {
      hide_mouse('y');
      if (_confighide_mp.p_value != ht:["_confighide_mp.p_value"]) {
         _macro_append("hide_mouse('y');");
      }
   }else{
      hide_mouse('n');
      if (_confighide_mp.p_value != ht:["_confighide_mp.p_value"]) {
         _macro_append("hide_mouse('n');");
      }
   }

   /*Set default display horizontal scroll bar value*/
   if (_confighor_sb.p_value) {
      if (!_default_option('H')) {
         display_hscroll('y');
      }
      if (_confighor_sb.p_value != ht:["_confighor_sb.p_value"]) {
         _macro_append("display_hscroll('y');");
      }
   }else{
      if (_default_option('H')) {
         display_hscroll('n');
      }
      if (_confighor_sb.p_value != ht:["_confighor_sb.p_value"]) {
         _macro_append("display_hscroll('n');");
      }
   }

   /*Set default display vertical scroll bar value*/
   if (_configvert_sb.p_value) {
      if (!_default_option('V')) {
         display_vscroll('y');
      }
      if (_configvert_sb.p_value != ht:["_configvert_sb.p_value"]) {
         _macro_append("display_vscroll('y');");
      }
   }else{
      if (_default_option('V')) {
         display_vscroll('n');
      }
      if (_configvert_sb.p_value != ht:["_configvert_sb.p_value"]) {
         _macro_append("display_vscroll('n');");
      }
   }

   /*Set Max # Clipoards*/
   if (_configmax_clipboards.p_text != '') {
      def_clipboards = (int)_configmax_clipboards.p_text;
      if (_configmax_clipboards.p_text != ht:["_configmax_clipboards.p_text"]) {
         _macro_append("def_clipboards="_configmax_clipboards.p_text';');
      }
   }else{
      def_clipboards = 0;
      if (_configmax_clipboards.p_text != ht:["_configmax_clipboards.p_text"]) {
         _macro_append("def_clipboards=0;");
      }
   }

#if !__UNIX__
   if (machine()=='OS2386') {
      def_who=_configwh_filename.p_text;
   } else {
      def_wh=_configwh_filename.p_text;
   }
   if (_configwh_filename.p_text != ht:["_configwh_filename.p_text"]) {
      _macro_append("def_wh="_quote(def_wh)';');
   }
#endif

   if (!isinteger(_vline_col.p_text)) {
      _message_box('Invalid Vertical Line Column Position');
      return(1);
   }
   _default_option('R',_vline_col.p_text);
   if (_vline_col.p_text != ht:["_vline_col.p_text"]) {
      _macro_call('_default_option','R',_vline_col.p_text);
   }

   if (ctlWinLeftMargin.p_text != ht:["ctlWinLeftMargin.p_text"]) {
      typeless dummyVal;
      dummyVal = (double)ctlWinLeftMargin.p_text * (double)1440;
      int dp;
      dp = pos('.', dummyVal);//look for . in number
      if (dp) {
      //there is a .
         dummyVal+= .5;
         dp = pos('.', dummyVal);//look for . in number
         if (dp) {
         //there is a .
            dummyVal = substr(dummyVal, 1, dp-1);
         }
      }
      _default_option('L',dummyVal);
      _macro_call('_default_option','L',dummyVal);
   }

   /*Set Auto restore Variables*/
   def_auto_restore = _auto_restore.p_value;
   if (_auto_restore.p_value != ht:["_auto_restore.p_value"]) {
      _macro_append("def_auto_restore="_auto_restore.p_value";");
   }
   def_restore_flags = 0;
   if (_restore_clipboards.p_value) {
      def_restore_flags |= RF_CLIPBOARDS;
   }
   if (_restore_directory.p_value) {
      def_restore_flags |= RF_CWD;
   }
   if (_restore_process.p_value) {
      def_restore_flags |= RF_PROCESS;
   }
   if (_restore_projects.p_value) {
      def_restore_flags |= RF_PROJECTFILES;
   }
   if (ctlLineModify.p_value) {
      def_restore_flags |= RF_LINEMODIFY;
   }
   if (!ctlSelDisp.p_value) {
      def_restore_flags |= RF_NOSELDISP;
   }
   if (ctlcbrowser.p_value) {
      def_restore_flags |= RF_CBROWSER_TREE;
   }
   if (def_restore_flags != ht:["def_restore_flags"]) {
      _macro_append("def_restore_flags="dec2hex(def_restore_flags)";");
   }

   if (ctlsingleclick.p_value != ht:["ctlsingleclick.p_value"]) {
      def_seldisp_single=(ctlsingleclick.p_value!=0);
      _macro_append("def_seldisp_single="def_seldisp_single";");
   }

   _config_modify|=CFGMODIFY_DEFVAR|CFGMODIFY_OPTION;
   return(0);
}
static int config_updateMore(int & do_menu_bind)
{
   typeless ht:[];
   ht = _start_insert.p_user;

   _macro('m',_macro('s'))
   if (ctlbbhelp_delay.p_enabled && !isinteger(ctlbbhelp_delay.p_text)) {
      _message_box('Invalid popup help delay value');
      ctlbbhelp_delay._set_focus();
      return(1);
   }

   new_keydisp= (_configskeys.p_value)?'C':'L';
   if (new_keydisp!=def_keydisp) {
      def_keydisp=new_keydisp;
      _macro_append('def_keydisp='_quote(def_keydisp)';');
      _macro_call('menu_mdi_bind_all');
      do_menu_bind=1;
   }

   _default_option(VSOPTION_SHOWTOOLTIPS,_configbbm.p_value);
   if (_configbbm.p_value != ht:["_configbbm.p_value"]) {
      _macro_append('_default_option(VSOPTION_SHOWTOOLTIPS,'_configbbm.p_value');');
   }
   if (ctlbbhelp_delay.p_enabled) {
      _default_option(VSOPTION_TOOLTIPDELAY,(int)ctlbbhelp_delay.p_text);
      if (ctlbbhelp_delay.p_text != ht:["ctlbbhelp_delay.p_text"]) {
         _macro_append('_default_option(VSOPTION_TOOLTIPDELAY,'ctlbbhelp_delay.p_text');');
      }
   }

   _mdi.p_child._insert_state(_start_insert.p_value, 'D');
   if (_start_insert.p_value != ht:["_start_insert.p_value"]) {
      _macro_append("_insert_state("_start_insert.p_value", 'D');");
   }

   def_exit_file_list= (_throw_away.p_value!=0);
   if (_throw_away.p_value != ht:["_throw_away.p_value"]) {
      _macro_append("def_exit_file_list="_throw_away.p_value";");
   }

   def_exit_process=_exit_process.p_value;
   if (_exit_process.p_value != ht:["_exit_process.p_value"]) {
      _macro_append("def_exit_process="_exit_process.p_value";");
   }

   def_start_on_first= (_starton_first.p_value!=0);
   if (_starton_first.p_value != ht:["_starton_first.p_value"]) {
      _macro_append("def_start_on_first="_starton_first.p_value";");
   }

   def_top_bottom_style= _savetop_bottom.p_value;
   if (_savetop_bottom.p_value != ht:["_savetop_bottom.p_value"]) {
      _macro_append("def_top_bottom_style="_savetop_bottom.p_value";");
   }

   //def_pmatch_style= !(_fast_check.p_value);
   //if (_fast_check.p_value != ht:["_fast_check.p_value"]) {
   //   _macro_append("def_pmatch_style="!(_fast_check.p_value)";");
   //}

   def_reflow_next= (_reflow_next.p_value!=0);
   if (_reflow_next.p_value != ht:["_reflow_next.p_value"]) {
      _macro_append("def_reflow_next="_reflow_next.p_value";");
   }

   _default_option('I', ctlEraseLineInProcessBuf.p_value);
   if (ctlEraseLineInProcessBuf.p_value != ht:["ctlEraseLineInProcessBuf.p_value"]) {
      _macro_call("_default_option", "I", ctlEraseLineInProcessBuf.p_value);
   }

   if (ctlProtectReadonly.p_value != ht:["ctlProtectReadonly.p_value"]) {
      val = (ctlProtectReadonly.p_value!=0);
      _default_option('Z',val);
      _macro_call("_default_option", "Z", val);
   }
   if (_default_option(VSOPTION_NEXTWINDOWSTYLE)!=ctlSmartNextWindow.p_value) {
      _default_option(VSOPTION_NEXTWINDOWSTYLE,ctlSmartNextWindow.p_value);
      _macro_append("_default_option(VSOPTION_NEXTWINDOWSTYLE,":+ctlSmartNextWindow.p_value:+");");
   }

#if 0
   if (_tag_proto.p_value) {
      def_ctags_flags|=2;
      if (_tag_proto.p_value != ht:["_tag_proto.p_value"]) {
         _macro_append("def_ctags_flags|=2;");
      }
   } else {
      def_ctags_flags&=~2;
      if (_tag_proto.p_value != ht:["_tag_proto.p_value"]) {
         _macro_append("def_ctags_flags&=~2;");
      }
   }
   def_ignore_tcase= (_ignore_tcase.p_value!=0);
   if (_ignore_tcase.p_value != ht:["_ignore_tcase.p_value"]) {
      _macro_append("def_ignore_tcase="_ignore_tcase.p_value";");
   }
#endif
   def_keydisp=_configskeys.p_value?'C':'L';
   if (_configskeys.p_value != ht:["_configskeys.p_value"]) {
      _macro_append("def_keydisp="_configskeys.p_value?'C':'L'";");
   }

   /*Set keymessage delay amount*/
   if (!isinteger(_km_delay.p_text)) {
      _message_box('Invalid Key Message Delay Amount');
      return(1);
   }
   keymsg_delay(_km_delay.p_text);
   if (_km_delay.p_text != ht:["_km_delay.p_text"]) {
      _macro_append("keymsg_delay("_km_delay.p_text");");
   }

   /*Set insert line*/
   if (_before.p_value == 1) {
      def_line_insert = 'B';
      if (def_line_insert != ht:["def_line_insert"]) {
         _macro_append("def_line_insert='B';");
      }
   }else{
      def_line_insert = 'A';
      if (def_line_insert != ht:["def_line_insert"]) {
         _macro_append("def_line_insert='A';");
      }
   }

   /*Set Scroll Style*/
   ss = '';
   if (_smooth.p_value) {
      ss = 'S';
   }else{
      ss = 'C';
   }

   if (_scroll.p_text != '') {
      if (!isinteger(_scroll.p_text)) {
         _message_box('Invalid Scroll Amount');
         return(1);
      }else{
         ss = ss' '_scroll.p_text;
      }
   }else{
      ss = ss' 0';
   }
   scroll_style(ss);
   if (ss != ht:["scroll_style"]) {
      _macro_append("scroll_style('"ss"');");
   }

   /*Paren Match Style*/
   if (_highlight.p_value) {
      def_pmatch_style2 = 1;
   }else if(_cursor.p_value){
      def_pmatch_style2 = 0;
   }else{
      def_pmatch_style2 = ''
   }
   if (def_pmatch_style2 != ht:["def_pmatch_style2"]) {
      _macro_append("def_p_match="def_pmatch_style2";");
   }

   /*Set Next Word Style*/
   if (_configbegin.p_value) {
      def_next_word_style = 'B';
      if (def_next_word_style != ht:["def_next_word_style"]) {
         _macro_append("def_next_word_style='B';");
      }
   }else{
      def_next_word_style = 'E';
      if (def_next_word_style != ht:["def_next_word_style"]) {
         _macro_append("def_next_word_style='E';");
      }
   }

   _config_modify|=CFGMODIFY_DEFVAR|CFGMODIFY_OPTION;
   return(0);
}
static int config_updateSearch()
{
   typeless ht:[];
   ht = _ctlso_match_case.p_user;

   _macro('m',_macro('s'))
   /*Set Search Options*/
   search_options = 0;
   if ( _ctlso_resyntax_slick.p_value ) {
      def_re_search=RE_SEARCH;
   } else if ( _ctlso_resyntax_unix.p_value ) {
      def_re_search=UNIXRE_SEARCH;
   } else if ( _ctlso_resyntax_brief.p_value ) {
      def_re_search=BRIEFRE_SEARCH;
   }
   if (def_re_search != ht:["def_re_search"]) {
      _macro_append("def_re_search="def_re_search";");
   }

   if (!_ctlso_match_case.p_value) {
      search_options |= IGNORECASE_SEARCH;
   }
   if (_ctlso_re.p_value) {
      search_options |= def_re_search;
   }
   if (_ctlso_wrap.p_value) {
      search_options |= WRAP_SEARCH;
   }
   _default_option('S', search_options);
   if (search_options != ht:["search_options"]) {
      _macro_call('_default_option','S', search_options);
   }

   def_restore_cursor = _ctlso_restore_cursor.p_value!=0;
   if (_ctlso_restore_cursor.p_value != ht:["_ctlso_restore_cursor.p_value"]) {
      _macro_append("def_restore_cursor=":+(_ctlso_restore_cursor.p_value!=0):+";");
   }
   def_leave_selected = _ctlso_leave_selected.p_value;
   if (_ctlso_leave_selected.p_value != ht:["_ctlso_leave_selected.p_value"]) {
      _macro_append("def_leave_selected="def_leave_selected";");
   }

   def_mfsearch_init_flags=0;
   if (_ctlso_init_retrieve.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_HISTORY;
   } else if (_ctlso_init_curword.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_CURWORD;
   }
   if (_ctlso_init_selection.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_SELECTION;
   }
   if (def_mfsearch_init_flags != ht:["def_mfsearch_init_flags"]) {
      _macro_append("def_mfsearch_init_flags="def_mfsearch_init_flags";");
   }

   _config_modify|=CFGMODIFY_DEFVAR|CFGMODIFY_OPTION;
   return(0);
}
void ctldelsel.lbutton_up()
{
   if (ctldelsel.p_value) {
      ctlautodeselect.p_value=1;
   }
}
void ctlautodeselect.lbutton_up()
{
   if (!ctlautodeselect.p_value) {
      ctldelsel.p_value=0;
   }
}
void _cuaadv.lbutton_up()
{
   parse p_user with select_style persistent deselect advselect .

   _extend.p_value= (int)(substr(select_style,1,1)=='C');
   _inclusive_char.p_value= (int)(substr(select_style,2,1)=='I');

   switch (persistent) {
   case 'D':
      ctldelsel.p_value=1;
      ctlautodeselect.p_value=1;
      break;
   case 'Y':
   case 'N':
      ctldelsel.p_value=0;
      ctlautodeselect.p_value=(int)(persistent=='N');
      break;
   }

   _deselect_after_paste.p_value=deselect;
}
static _str _get_style()
{
   result='';
   result=((_extend.p_value)?'C':'E');
   result=result:+((_inclusive_char.p_value)?'I':'N');

   result=result:+' ';
   if (ctldelsel.p_value) {
      result=result:+'D';
   } else {
      if (ctlautodeselect.p_value) {
         result=result:+'N';
      } else {
         result=result:+'Y';
      }
   }

   result=result:+' ';
   result=result:+_deselect_after_paste.p_value;

   result=result:+' ';
   result=result:+'P';
   return(result);
}
static void _update_style()
{
   style=_get_style();
   if (style==CUAADV_STYLE && _cuaadv.p_enabled){
      _cuaadv.p_value=1;
   } else if (style==_product_default.p_user){
      _product_default.p_value=1;
   } else {
      _userdefined.p_value=1;
   }
}
static int config_updateSelStyle()
{
   typeless ht:[];
   ht = _userdefined.p_user;

   _macro('m',_macro('s'))

   def_advanced_select='P';
   //_macro_append('def_advanced_select='_quote(def_advanced_select)';');

   if(ctldelsel.p_value) {
      def_persistent_select='D';
   } else {
      if (ctlautodeselect.p_value) {
         def_persistent_select='N';
      } else {
         def_persistent_select='Y';
      }
   }
   if (def_persistent_select != ht:["def_persistent_select"]) {
     _macro_append('def_persistent_select='_quote(def_persistent_select)';');
   }

   def_deselect_paste= _deselect_after_paste.p_value!=0;
   if (_deselect_after_paste.p_value != ht:["_deselect_after_paste.p_value"]) {
      _macro_append('def_deselect_paste='def_deselect_paste';');
   }

   def_select_style=upcase(def_select_style);

   style1=_extend.p_value?'C':'E';
   style2=_inclusive_char.p_value?'I':'N';
   def_select_style=style1:+style2;

   if (def_select_style != ht:["def_select_style"]) {
      _macro_append('def_select_style='_quote(def_select_style)';');
   }

   def_scursor_style= !_shiftcursor.p_value;
   if (_shiftcursor.p_value != ht:["_shiftcursor.p_value"]) {
      _macro_append('def_scursor_style='def_scursor_style';');
   }

   def_autoclipboard=ctlmouseclipboard.p_value!=0;
   if (ctlmouseclipboard.p_value != ht:["ctlmouseclipboard.p_value"]) {
      _macro_append('def_autoclipboard='def_autoclipboard';');
   }

   _config_modify|=CFGMODIFY_DEFVAR;
   return(0);
}
static int config_updateExit()
{
   typeless ht:[];
   ht = _ctlexit_config_always.p_user;

   _macro('m',_macro('s'))
   def_exit_flags=0;
   if (_ctlexit_config_always.p_value) {
      def_exit_flags|=EXIT_CONFIG_ALWAYS;
   }else if (_ctlexit_config_prompt.p_value) {
      def_exit_flags|=EXIT_CONFIG_PROMPT;
   }
   if (_ctlexit_confirm.p_value) {
      def_exit_flags|=EXIT_CONFIRM;
   }
   if (def_exit_flags != ht:["def_exit_flags"]) {
      _macro_append('def_exit_flags='def_exit_flags';');
   }
   _config_modify|=CFGMODIFY_DEFVAR;
   return(0);
}
static int config_updateSpecialChar()
{
   typeless ht:[];
   ht = _ctlViewHex.p_user;

   _macro('m',_macro('s'))
   _str text;
   text = "";
   int i;
   boolean badInput=false;
   for (i=1; i<=MAXSPECIALCHARS; i++) {
      _str ctlName;
      ctlName = "_ctlSpecialCharV" :+ i;
      int wid;
      wid = _find_control(ctlName);
      badInput=badInput || length(wid.p_text)!=1;
      text = text :+ wid.p_text;
   }
   if (!badInput) {
      _default_option('Q',text);
      if (text != ht:["specialChars"]) {
         _macro_call("_default_option","Q",text);
      }
   }

   _config_modify|=CFGMODIFY_OPTION;
   return(0);
}
static int config_updateVirtMem()
{
   typeless ht:[];
   ht = _ctlvmem_spill_fp.p_user;
   int modified;
   modified = 0;

   _macro('m',_macro('s'))
   if (_ctlvmem_spill_fp.p_text != ht:["_ctlvmem_spill_fp.p_text"]) {
      _spill_file_path(_ctlvmem_spill_fp.p_text);//Set Spill file path
      _macro_call('_spill_file_path',_ctlvmem_spill_fp.p_text);
      modified = 1;
   }
   if (!isinteger(_ctlvmem_buffer_cache.p_text)) {
      _message_box('Invalid Buffer Cache');
      return(1);
   }
   if (!isinteger(_ctlvmem_state_cache.p_text)) {
      _message_box('Invalid State Cache');
      return(1);
   }
   if ((_ctlvmem_buffer_cache.p_text != ht:["_ctlvmem_buffer_cache.p_text"]) ||
       (_ctlvmem_state_cache.p_text != ht:["_ctlvmem_state_cache.p_text"])) {
      cache_size(_ctlvmem_buffer_cache.p_text' '_ctlvmem_state_cache.p_text);
      _macro_call('cache_size',_ctlvmem_buffer_cache.p_text' '_ctlvmem_state_cache.p_text)
      modified = 1;
   }
   if (!isinteger(_ctlvmem_tagging_cache.p_text)) {
      _message_box('Invalid Tagging Cache Size');
      return(1);
   }
   if (_ctlvmem_tagging_cache.p_text<512) {
      _message_box('Tagging Cache Size too small');
      return(1);
   }
   if (_ctlvmem_tagging_cache.p_text != ht:["_ctlvmem_tagging_cache.p_text"]) {
      def_tag_cache_size=(int)_ctlvmem_tagging_cache.p_text;
      _macro_append('def_tag_cache_size',_ctlvmem_tagging_cache.p_text';');
      modified = 1;
   }
   if (modified) {
      _message_box(nls("The cache options will not take effect until you restart Visual SlickEdit."));
   }
   return(0);
}
static int config_updateAll()
{
   int do_menu_bind;
   _config_modify|=CFGMODIFY_DEFVAR|CFGMODIFY_OPTION;
   do_menu_bind=0;
   if (config_updateGeneral(do_menu_bind)) return(1);
   if (config_updateMore(do_menu_bind)) return(1);
   if (do_menu_bind) {
      menu_mdi_bind_all();
   }
   if (config_updateSearch()) return(1);
   if (config_updateSelStyle()) return(1);
   if (config_updateExit()) return(1);
   if (config_updateSpecialChar()) return(1);
   if (config_updateVirtMem()) return(1);

   return(0);
}
