/*
$VerboseHistory: html.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:28a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:28a
 * Comment:
 * Added support for new HTML color coding
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"


//---------------------------------------------------------------------
// Code for Unix ...
#define AUTOSTART_TIMEOUT 20

#define BIAUTO 0
#define BINNAVIGATOR 1
#define BIIEXPLORER 2
#define BIWEBEXPLORER 3
#define BIMOSAIC 4
#define BIOTHER 5

#define OSIWIN 0
#define OSIOS2 1
#define OSIRESERVED 2
#define OSIUNIX OSIWIN

struct HTML_INFO_STRUCT {
   int browser[];
   _str exePath[];
   _str app[];
   _str topic[];
   _str item[];
   int useDDE[];
};
// Browser index:
//    0 -- Automatic
//    1 -- Netscape Navigator
//    2 -- Internet Explorer (Windows 95/3.1/NT only)
//    3 -- Web Explorer (OS/2 only)
//    4 -- Mosaic (Unix only)
//    5 -- Other
HTML_INFO_STRUCT def_html_info = {
   { BIAUTO, BIWEBEXPLORER, BIOTHER },
   { "","","","","","","" },
   { "","","","","","","" },
   { "","","","","","","" },
   { "","","","","","","" },
   { 0, 0, 0, 0, 0, 0, 0 }
};
// Other browsers:
//    0 -- Windows 95/3.1/NT
//    1 -- OS/2
//    2 -- Reserved
HTML_INFO_STRUCT def_html_other_info = {
   { BIAUTO, BIWEBEXPLORER, BIOTHER },
   { "","","" },
   { "","","" },
   { "","","" },
   { "","","" },
   { 0, 0, 0 }
};
static HTML_INFO_STRUCT info_copy;
static HTML_INFO_STRUCT info_othercopy;
static int ignore_textbox_change = 0;
static int info_modified = 0;
static int osi = OSIWIN;
static int unixRunning = 0;

static typeless cs_ori_position;
static _str standAloneTagList[] = {
   "BR", "WBR", "IMG", "HR", "META", "LI", "SPACER", "LINK",
   "INPUT", "BASEFONT", "DT", "DD", "FRAME",
   "ISINDEX", "BASE", "PLAINTEXT", "KEYGEN"
};
static _str tagAllowedInPTag[] = {
   "B", "BIG", "BLINK", "CITE", "CODE", "EM", "FONT", "I",
   "KBD", "S", "SMALL", "STRIKE", "STRONG", "SUB", "SUP",
   "TT", "U", "VAR", "A", "IMG", "SPACER", "SPAN"
};


static void adjust_filespec(_str &vslickpathfilename)
{
#if !__UNIX__
   comspec=get_env("COMSPEC")" /c";
   if (file_eq(substr(vslickpathfilename,1,length(comspec)),comspec)) {
      vslickpathfilename=strip(substr(vslickpathfilename,length(comspec)+1));
      if (machine()!="OS2386") {
          if (file_match("-p "vslickpathfilename".bat",1)!="") {
             vslickpathfilename=vslickpathfilename".bat";
             return;
          }
      }
      if (file_match("-p "vslickpathfilename".cmd",1)!="") {
         vslickpathfilename=vslickpathfilename".cmd";
         return;
      }
   }
#endif
}
static _str whichpath( filename )
{
   if (filename=="") { return( "" ); }
   // We want this one to act like user typed command on command line
   // except we don't look for internal editor commands.
   vslickpathfilename=slick_path_search(filename,"M");
   // We want this one to act like user is at shell prompt.
   pathfilename=path_search(filename,"","P");
   adjust_filespec(vslickpathfilename);
   adjust_filespec(pathfilename);
   //sticky_message("VSLICKPATH found <"vslickpathfilename">   PATH found <"pathfilename">");
   return( pathfilename );
}
static void _init_osi()
{
   // All other OS'es use index 0.  This include all UNIX platforms.
   osi=OSIWIN;
   unixRunning = 0;
   mname = machine();
   if ( mname == "OS2386" ) {
      osi=OSIOS2;
      return;
   } else if ( _win32s() || mname == "NT386" || mname == "NTMIPS" ||
            mname == "NTALPHA" || mname == "NTPPC" ) {
      osi=OSIWIN;
   } else {
      // Unix and Windows/NT share the same index to def_html_info struct.
      // We can do this because these OS'es don't share state file.
      osi=OSIUNIX;
      unixRunning = 1;
      // Change the initial values:
      if ( def_html_info.browser[osi] == BIAUTO ) {
         def_html_info.browser[osi] = BINNAVIGATOR;
      }
   }
}


// Desc:  View the file.  Start Netscape if necessary.
// Retn:  0 for OK, 1 for error.
static int nsViewDoc( filename, type )
{
   // Create a temporary view so that the DDE can freely
   // modify the buffer without affecting others.
   old_view_id = _create_temp_view( view_id );
   rc = nsViewDoc1( filename, type );
   _delete_temp_view( view_id );
   return( rc );
}
// Desc:  View the file.  Start Netscape if necessary.
// Retn:  0 for OK, 1 for error.
static int nsViewDoc1( filename, type )
{
   // Build DDE request or shell command:
   if ( buildRequest( filename, execmd, useDDE, app, topic, item, type ) ) {
      return( 1 );
   }
   if ( useDDE ) {
      //messageNwait( "PREVENT CRASH...  app="app" item="item" topic="topic );
      
      // Try to activate the browser and get the frame/window ID:
      _str browserID;
      old_view_id = _create_temp_view(view_id);
      status=_dderequest("L",app,"0xFFFFFFFF,0x0","WWW_Activate");
      if (!status) {
         get_line(line);
         line = _asc(substr(line, 1, 1));
         eval_exp(browserID,line,16);
      }
      _delete_temp_view(view_id);

      if (status) {
         // Browser not running, try to start browser:
         if ( shell( execmd, 'AN' ) ) {
            msg = "Can't start browser with \n'"execmd"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
            _message_box(msg);
            return( 1 );
         }
         timeout=AUTOSTART_TIMEOUT;
         if (timeout>60) timeout=59;
         parse _time("M") with . ":" . ":" start_ss;
         for (;;) {
            delay(50);
            old_view_id = _create_temp_view(view_id);
            status=_dderequest("L",app,"0xFFFFFFFF,0x0","WWW_Activate");
            if (!status) {
               get_line(line);
               line = _asc(substr(line, 1, 1));
               eval_exp(browserID,line,16);
            }
            _delete_temp_view( view_id );
            if (!status) break;
            parse _time("M") with . ":" . ":" ss;
            if (ss<start_ss) ss=ss+60;
            if (ss-start_ss>timeout) {
               //messageNwait( "Timed out" );
               //messageNwait( "ss="ss" start_ss="start_ss" timeout="timeout );
               break;
            }
         }
         if (status) {
            _message_box("Timed-out trying to start browser.\n\nPlease try again.");
            return( 1 );
         }
      }

      // Now that we have a window ID for the activated
      // browser, try to find its frame parent, if there is one.
      old_view_id = _create_temp_view(view_id);
      status=_dderequest("L",app,browserID:+",0x0","WWW_GetFrameParent");
      if (!status) {
         // Activate the parent frame:
         get_line(line);
         line = _asc(substr(line, 1, 1));
         eval_exp(browserID,line,16);
         status=_dderequest("L",app,browserID:+",0x0","WWW_Activate");
      }
      _delete_temp_view(view_id);

      // Send the page over:
      old_view_id = _create_temp_view(view_id);
      status=_dderequest("L",app,item,topic);
      _delete_temp_view( view_id );
   } else {
      // No DDE...  Use the actual command to start the browser AND
      // pass the buffer name:
      if ( unixRunning ) {
         execmd = execmd" >& /dev/null";
         ec = shell( execmd );
         if ( ec ) {
            // Failed starting browser with default command.
            // Try another format 'browerExe %F'.
            buildRequest( "", execmd, useDDE, app, topic, item, type );
            execmd = execmd" "filename;
            ec = shell( execmd, "A" );
         }
      } else { ec = shell( execmd, 'AN' ); }
      if ( ec ) {
         msg = "Can't view file with \n'"execmd"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
         _message_box( msg );
         return( 1 );
      }
   }
   return( 0 );
}


defeventtab _html_form
_html_form.'ESC'()
{
   p_active_form._delete_window( 0 );
}
_useDDE_tb.lbutton_up()
{
   if ( p_value == 1 ) {
      s = true;
   } else {
      s = false;
   }
   toggleUseDDE( s );
   bi = info_copy.browser[osi];
   if ( bi == BIOTHER ) {
      info_othercopy.useDDE[osi] = _useDDE_tb.p_value;
   } else {
      info_copy.useDDE[bi] = p_value;
   }
   info_modified = 1;
}
_browse1.lbutton_up()
{
   wid=p_window_id;
   result=_OpenDialog('-modal '_stdform('_open_form'),
                      '',                   // Dialog Box Title
                      '',                   // Initial Wild Cards
                      def_file_types,       // File Type List
                      OFN_FILEMUSTEXIST     // Flags
                      );
   if (result=='') {
      return('');
   }
   p_window_id=wid.p_prev;
   p_text=result;
   end_line();
   _set_focus();
   return('');
}
_program_tx.on_change()
{
   if ( !ignore_textbox_change ) {
      fillHTMLInfo();
   }
}
_app_tx.on_change()
{
   if ( !ignore_textbox_change ) {
      fillHTMLInfo();
   }
}
_default.lbutton_up()
{
   if ( _auto_rb.p_value ) {
      fillAuto( 1 );
   } else if ( _ns_rb.p_value ) {
      fillNS( 1 );
   } else if ( _ie_rb.p_value ) {
      fillIE( 1 );
   } else if ( _we_rb.p_value ) {
      fillWE( 1 );
   } else if ( _mo_rb.p_value ) {
      fillMO( 1 );
   }
}
_auto_rb.lbutton_up()
{
   setBrowser( BIAUTO );
   fillAuto( 0 );
   setState( 0, 0, 0, 0 );
}
_ns_rb.lbutton_up()
{
   bi = BINNAVIGATOR;
   setBrowser( bi );
   setState( 1, info_copy.useDDE[bi], 1, 1 );
   fillNS( 0 );
}
_ie_rb.lbutton_up()
{
   bi = BIIEXPLORER;
   setBrowser( bi );
   setState( 1, info_copy.useDDE[bi], 1, 1 );
   fillIE( 0 );
}
_we_rb.lbutton_up()
{
   bi = BIWEBEXPLORER;
   setBrowser( bi );
   setState( 1, 0, 0, 0 );
   fillWE( 0 );
}
_mo_rb.lbutton_up()
{
   bi = BIMOSAIC;
   setBrowser( bi );
   setState( 1, 0, 0, 1 );
   fillMO( 0 );
}
_other_rb.lbutton_up()
{
   setBrowser( BIOTHER );
   if ( unixRunning ) { setState( 1, 0, 0, 0 ); }
   else { setState( 1, info_othercopy.useDDE[osi], 1, 0 ); }
   fillOther( 0 );
}
_ok.on_create()
{
   _init_osi();
   // Update the controls:
   info_modified = 0;
   info_copy = def_html_info;
   info_othercopy = def_html_other_info;
   fillWithHTMLInfo();

   // Disable OS specific controls:
   if ( unixRunning ) {
      _auto_rb.p_enabled = false;
      _ns_rb.p_enabled = true;
      _ie_rb.p_enabled = false;
      _we_rb.p_enabled = false;
      _mo_rb.p_enabled = true;
      _other_rb.p_enabled = true;
   } else if ( osi == OSIOS2 ) {
      _auto_rb.p_enabled = false;
      _ns_rb.p_enabled = false;
      _ie_rb.p_enabled = false;
      _we_rb.p_enabled = true;
      _mo_rb.p_enabled = false;
      _other_rb.p_enabled = true;
   } else if ( osi == OSIWIN ) {
      _we_rb.p_enabled = false;
      _mo_rb.p_enabled = false;
   }
}
_ok.lbutton_up()
{
   if ( info_modified ) {
      //messageNwait( "Form info modified." );
      def_html_info = info_copy;
      def_html_other_info = info_othercopy;
      _config_modify |= CFGMODIFY_DEFVAR;
   }
   p_active_form._delete_window( 1 );
}
_cancel.lbutton_up()
{
   p_active_form._delete_window( 0 );
}
static void setBrowser( b )
{
   if ( b == BIAUTO ) {
      _ns_rb.p_value = 0;
      _ie_rb.p_value = 0;
      _we_rb.p_value = 0;
      _mo_rb.p_value = 0;
      _other_rb.p_value = 0;
   } else if ( b == BINNAVIGATOR ) {
      _auto_rb.p_value = 0;
      _ie_rb.p_value = 0;
      _we_rb.p_value = 0;
      _mo_rb.p_value = 0;
      _other_rb.p_value = 0;
   } else if ( b == BIIEXPLORER ) {
      _auto_rb.p_value = 0;
      _ns_rb.p_value = 0;
      _we_rb.p_value = 0;
      _mo_rb.p_value = 0;
      _other_rb.p_value = 0;
   } else if ( b == BIWEBEXPLORER ) {
      _auto_rb.p_value = 0;
      _ns_rb.p_value = 0;
      _ie_rb.p_value = 0;
      _mo_rb.p_value = 0;
      _other_rb.p_value = 0;
   } else if ( b == BIMOSAIC ) {
      _auto_rb.p_value = 0;
      _ns_rb.p_value = 0;
      _ie_rb.p_value = 0;
      _we_rb.p_value = 0;
      _other_rb.p_value = 0;
   } else if ( b == BIOTHER ) {
      _auto_rb.p_value = 0;
      _ns_rb.p_value = 0;
      _ie_rb.p_value = 0;
      _we_rb.p_value = 0;
      _mo_rb.p_value = 0;
   }
   info_copy.browser[osi] = b;
   info_modified = 1;
}
static void setState( prog, dde, ddetoggle, allowdefaults )
{
   if ( prog ) s = true;
   else s = false;
   _program_la.p_enabled = s;
   _program_tx.p_enabled = s;
   _browse1.p_enabled = s;

   if ( dde ) s = true;
   else s = false;
   _dde_fr.p_enabled = s;
   _app_la.p_enabled = s;
   _app_tx.p_enabled = s;
   _topic_la.p_enabled = s;
   _topic_tx.p_enabled = s;
   _item_la.p_enabled = s;
   _item_tx.p_enabled = s;

   if ( ddetoggle ) _useDDE_tb.p_enabled = true;
   else _useDDE_tb.p_enabled = false;

   if ( allowdefaults ) _default.p_enabled = true;
   else _default.p_enabled = false;
}
static void fillNS( queryNew )
{
   type = 'f';
   bi = BINNAVIGATOR;
   if ( queryNew || info_copy.exePath[bi] == "" ) {
      // Update from current info:
      ignore_textbox_change = 1;
      getNS( execmd, useDDE, app, topic, item, type );
      _program_tx.p_text = execmd;
      _app_tx.p_text = app;
      _topic_tx.p_text = topic;
      _item_tx.p_text = item;
      _useDDE_tb.p_value = useDDE;
      ignore_textbox_change = 0;
      if ( info_copy.exePath[bi] != "" ) fillHTMLInfo();
   } else {
      // Update from saved data:
      fillDefInfo( bi );
   }
   updateUseDDE();
}
static void fillIE( queryNew )
{
   type = 'f';
   bi = BIIEXPLORER;
   if ( queryNew || info_copy.exePath[bi] == "" ) {
      ignore_textbox_change = 1;
      getIE( execmd, useDDE, app, topic, item, type );
      _program_tx.p_text = execmd;
      _app_tx.p_text = app;
      _topic_tx.p_text = topic;
      _item_tx.p_text = item;
      _useDDE_tb.p_value = useDDE;
      ignore_textbox_change = 0;
      if ( info_copy.exePath[bi] != "" ) fillHTMLInfo();
   } else {
      fillDefInfo( bi );
   }
   updateUseDDE();
}
static void fillWE( queryNew )
{
   bi = BIWEBEXPLORER;
   if ( queryNew || info_copy.exePath[bi] == "" ) {
      ignore_textbox_change = 1;
      getWE( execmd, useDDE, app, topic, item );
      _program_tx.p_text = execmd;
      _app_tx.p_text = app;
      _topic_tx.p_text = topic;
      _item_tx.p_text = item;
      _useDDE_tb.p_value = useDDE;
      ignore_textbox_change = 0;
      if ( info_copy.exePath[bi] != "" ) fillHTMLInfo();
   } else {
      fillDefInfo( bi );
   }
   updateUseDDE();
}
static void fillMO( queryNew )
{
   bi = BIMOSAIC;
   if ( queryNew || info_copy.exePath[bi] == "" ) {
      ignore_textbox_change = 1;
      getMO( execmd, useDDE, app, topic, item );
      _program_tx.p_text = execmd;
      _app_tx.p_text = app;
      _topic_tx.p_text = topic;
      _item_tx.p_text = item;
      _useDDE_tb.p_value = useDDE;
      ignore_textbox_change = 0;
      if ( info_copy.exePath[bi] != "" ) fillHTMLInfo();
   } else {
      fillDefInfo( bi );
   }
   updateUseDDE();
}
static void fillAuto( queryNew )
{
   type = 'f';
   getAuto( execmd, useDDE, app, topic, item, type );
   ignore_textbox_change = 1;
   _program_tx.p_text = execmd;
   _app_tx.p_text = app;
   _topic_tx.p_text = topic;
   _item_tx.p_text = item;
   _useDDE_tb.p_value = useDDE;
   ignore_textbox_change = 0;
   fillHTMLInfo();
   updateUseDDE();
}
static void fillOther( queryNew )
{
   bi = BIOTHER;
   if ( queryNew || info_othercopy.exePath[osi] == ""  ) {
      ignore_textbox_change = 1;
      getOther( execmd, useDDE, app, topic, item );
      _program_tx.p_text = execmd;
      _app_tx.p_text = app;
      _topic_tx.p_text = topic;
      _item_tx.p_text = item;
      _useDDE_tb.p_value = useDDE;
      ignore_textbox_change = 0;
      fillHTMLInfo();
   } else {
      fillDefInfo( bi );
   }
   updateUseDDE();
}
// Desc:  Update the internal data structure with the new browser info.
static void fillHTMLInfo()
{
   //messageNwait( "fillHTMLInfo h1" );
   bi = info_copy.browser[osi];
   if ( bi == BIOTHER ) {
      info_othercopy.exePath[osi] = _program_tx.p_text;
      info_othercopy.app[osi] = _app_tx.p_text;
      info_othercopy.topic[osi] = _topic_tx.p_text;
      info_othercopy.item[osi] = _item_tx.p_text;
      info_othercopy.useDDE[osi] = _useDDE_tb.p_value;
   } else {
      info_copy.exePath[bi] = _program_tx.p_text;
      info_copy.app[bi] = _app_tx.p_text;
      info_copy.topic[bi] = _topic_tx.p_text;
      info_copy.item[bi] = _item_tx.p_text;
      info_copy.useDDE[bi] = _useDDE_tb.p_value;
   }
   info_modified = 1;
}
// Desc:  Update the controls with internal data.
static void fillWithHTMLInfo()
{
   bi = info_copy.browser[osi];
   if ( bi == BIAUTO ) {
      _auto_rb.p_value = 1;
      setBrowser( bi );
      setState( 0, 0, 0, 0 );
      fillAuto( 0 );
   } else if ( bi == BINNAVIGATOR ) {
      _ns_rb.p_value = 1;
      setBrowser( bi );
      if ( unixRunning ) { setState( 1, 0, 0, 1 ); }
      else { setState( 1, info_copy.useDDE[bi], 1, 1 ); }
      fillNS( 0 );
   } else if ( bi == BIIEXPLORER ) {
      _ie_rb.p_value = 1;
      setBrowser( bi );
      setState( 1, info_copy.useDDE[bi], 1, 1 );
      fillIE( 0 );
   } else if ( bi == BIWEBEXPLORER ) {
      _we_rb.p_value = 1;
      setBrowser( bi );
      setState( 1, 0, 0, 0 );
      fillWE( 0 );
   } else if ( bi == BIMOSAIC ) {
      _mo_rb.p_value = 1;
      setBrowser( bi );
      setState( 1, 0, 0, 1 );
      fillMO( 0 );
   } else {
      _other_rb.p_value = 1;
      setBrowser( BIOTHER );
      if ( unixRunning ) { setState( 1, 0, 0, 0 ); }
      else { setState( 1, info_copy.useDDE[osi], 1, 0 ); }
      fillOther( 0 );
   }
}
// Desc:  Update the controls with the saved values.
static void fillDefInfo( bi )
{
   ignore_textbox_change = 1;
   if ( bi == BIOTHER ) {
      _program_tx.p_text = info_othercopy.exePath[osi];
      _app_tx.p_text = info_othercopy.app[osi];
      _topic_tx.p_text = info_othercopy.topic[osi];
      _item_tx.p_text = info_othercopy.item[osi];
      _useDDE_tb.p_value = info_othercopy.useDDE[osi];
   } else {
      _program_tx.p_text = info_copy.exePath[bi];
      _app_tx.p_text = info_copy.app[bi];
      _topic_tx.p_text = info_copy.topic[bi];
      _item_tx.p_text = info_copy.item[bi];
      _useDDE_tb.p_value = info_copy.useDDE[bi];
   }
   ignore_textbox_change = 0;
}
// Desc: Build the DDE request or shell command based on current browser info.
// Retn: 0 for OK, 1 for error.
static int buildRequest( filename, var execmd, var useDDE,
         var app, var topic, var item, type )
{
   // If nothing is setup, try query for the data.
   // Otherwise, use existing data.
   bi = def_html_info.browser[osi];
   if ( bi == BIOTHER ) execmd = def_html_other_info.exePath[osi];
   else execmd = def_html_info.exePath[bi];
   if ( execmd == "" ) {
      getDefaultBrowserInfo( bi, execmd, useDDE, app, topic, temp1, type );
   } else {
      if ( bi == BIOTHER ) {
         app = def_html_other_info.app[osi];
         topic = def_html_other_info.topic[osi];
         useDDE = def_html_other_info.useDDE[osi];
         temp1 = def_html_other_info.item[osi];
      } else {
         app = def_html_info.app[bi];
         topic = def_html_info.topic[bi];
         useDDE = def_html_info.useDDE[bi];
         temp1 = def_html_info.item[bi];
      }
   }
   if ( execmd == "" ) {
      _message_box( "No browser available.\nPlease use Web Browser Setup dialog to specify a browser." );
      return( 1 );
   }

   // SPECIAL CASE...
   // If filename is not specified, just build the exe command and don't
   // worry about whether or not DDE is used.
   if ( filename == "" ) {
      temp1 = execmd;
      if ( parseBrowserStartCommand( temp1, execmd ) ) {
         msg = "Can't start browser with \n'"temp1"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
         _message_box( msg );
         return( 1 );
      }
      return( 0 );
   }

   // Build:
   // 1.  DDE request and the command to start the browser, or
   // 2.  Command to start the browser and display the file.

   // DDE request and browser start command:
   if ( useDDE ) {
      // Build actual file embedded file name:
      if ( parseDDEItemParts( temp1, p1, p2 ) ) {
         _message_box( "DDE item is missing a %F.\nPlease use Web Browser Setup dialog to correct the DDE item." );
         return( 1 );
      }
      item = p1 filename p2;

      // Build browser start command:
      temp1 = execmd;
      if ( parseBrowserStartCommand( temp1, execmd ) ) {
         msg = "Can't start browser with \n'"temp1"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
         _message_box( msg );
         return( 1 );
      }
      return( 0 );
   }

   // Browser start and view file, all in one command:
   temp1 = execmd;
   if ( parseBrowserAndFileStartCommand( temp1, filename, execmd ) ) {
      msg = "Can't start browser with \n'"temp1"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
      _message_box( msg );
      return( 1 );
   }
   return( 0 );
}
// Desc:  Parse the DDE item string into two parts (separated by %F, %f, %1).
// Retn:  0 for OK, 1 or error.
static int parseDDEItemParts( item, var p1, var p2 )
{
   parse item with p1 "%F" p2;
   if ( p1 != item ) return( 0 );
   parse item with p1 "%f" p2;
   if ( p1 != item ) return( 0 );
   parse item with p1 "%1" p2;
   if ( p1 != item ) return( 0 );
   p1 = item;
   p2 = "";
   return( 1 );
}
// Desc:  Extract and verify the exe path.
//     Remove any parameter specifiers: %F, %f, %1.
//     The extracted exe command may be quoted if it contains embedded spaces.
// Retn:  0 for OK, 1 for error.
static int parseBrowserStartCommand( cmd, var execmd )
{
   //messageNwait("cmd="cmd);
   endw = "";
   temp = cmd;
   execmd = cmd;
   qtemp = maybe_quote_filename(temp);
   for (;;) {
      //messageNwait( "b4 qtemp="qtemp );
      fn = file_match("-p "qtemp, 1 );
      if ( fn != "" ) {
         execmd = qtemp" "endw;
         //messageNwait( "a1 cmd="execmd );
         return( 0 );
      }
      fullpath = whichpath( qtemp );
      if ( (fullpath != "") && (fullpath == qtemp) ) {
         execmd = qtemp" "endw;
         //messageNwait( "a3 cmd="execmd );
         return( 0 );
      }
      w = strip_last_word( temp );
      //messageNwait( "w="w );
      if ( temp == "" ) {
         //messageNwait( "a2 cmd="execmd );
         return( 1 );
      }
      // Throw away any parameter specifiers:
      if ( !pos( "%F", w ) && !pos( "%f", w ) && !pos( "%1", w ) &&
               !pos( "-remote", w ) ) {
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      //messageNwait( "endw="endw );
      qtemp = maybe_quote_filename(temp);
   }
}
// Desc:  Verify the exe path.
//     The filename specifier (%F, %f, %1) is replaced by the name of
//     the current buffer.
//
//     The extracted exe command may be quoted if it contains embedded spaces.
//     The buffer name is always quoted.
// Retn:  0 for OK, 1 for error.
static int parseBrowserAndFileStartCommand( cmd, filename, var execmd )
{
   //messageNwait("cmd="cmd);
   endw = "";
   temp = cmd;
   execmd = cmd;
   qtemp = maybe_quote_filename(temp);
   for (;;) {
      //messageNwait( "b4 qtemp="qtemp );
      fn = file_match("-p "qtemp, 1 );
      if ( fn != "" ) {
         execmd = qtemp" "endw;
         //messageNwait( "a1 cmd="execmd );
         return( 0 );
      }
      fullpath = whichpath( qtemp );
      if ( (fullpath != "") && (fullpath == qtemp) ) {
         execmd = qtemp" "endw;
         //messageNwait( "a3 cmd="execmd );
         return( 0 );
      }
      w = strip_last_word( temp );
      //messageNwait( "w="w );
      if ( temp == "" ) {
         //messageNwait( "a2 cmd="execmd );
         return( 1 );
      }
      // Replace name specifier with the buffer name:
      addfile = 0;
      if ( pos( "%F", w ) ) {
         parse w with p1 "%F" p2;
         addfile = 1;
      } else if ( pos( "%f", w )  ) {
         parse w with p1 "%f" p2;
         addfile = 1;
      } else if ( pos( "%1", w ) ) {
         parse w with p1 "%1" p2;
         addfile = 1;
      } else {
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      if ( addfile ) {
         p1 = stranslate( p1,'','"');
         p2 = stranslate( p2,'','"');
         w = p1 filename p2;
         w = maybe_quote_filename( w );
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      //messageNwait( "endw="endw );
      qtemp = maybe_quote_filename(temp);
   }
}
// Desc:  Get the default values for the different browsers.
static void getDefaultBrowserInfo( bi, var execmd, var useDDE, var app,
         var topic, var item, type )
{
   if ( bi == BIAUTO ) {
      getAuto( execmd, useDDE, app, topic, item, type );
   } else if ( bi == BINNAVIGATOR ) {
      getNS( execmd, useDDE, app, topic, item, type );
   } else if ( bi == BIIEXPLORER ) {
      getIE( execmd, useDDE, app, topic, item, type );
   } else if ( bi == BIWEBEXPLORER ) {
      getWE( execmd, useDDE, app, topic, item);
   } else if ( bi == BIMOSAIC ) {
      getMO( execmd, useDDE, app, topic, item );
   } else {
      getOther( execmd, useDDE, app, topic, item );
   }
}
static void getNS( var execmd, var useDDE, var app, var topic, var item, _str type)
{
   if (type == '') {
      type='f';
   }
   if ( unixRunning ) {
      execmd = "netscape -remote 'openURL(%F)'";
      app = "";
      topic = "";
      item = "";
      useDDE = 0;
   } else {
      value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\NetscapeMarkup\\shell\\open\\command","");
      execmd = value;
      app = "NETSCAPE";
      topic = "WWW_OpenURL";
      if (type == 'p') {
         item = '"http://%F",,0xFFFFFFFF,0x3,,,';
      } else{
         item = '"file:///%F",,0xFFFFFFFF,0x3,,,';
      }
      useDDE = 1;
   }
}
static void getIE( var execmd, var useDDE, var app, var topic, var item, _str type )
{
   value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\htmlfile\\shell\\open\\command","");
   execmd = value;
   app = "IExplore";
   topic = "WWW_OpenURL";
   
   if (type :== 'p') {
      item = '"http://%F",,0xFFFFFFFF,0x3,,,';
   } else{
      item = '"file:%F",,0xFFFFFFFF,0x3,,,,';
   }
   useDDE = 1;
}
static void getWE( var execmd, var useDDE, var app, var topic, var item)
{
   execmd = "explorer.exe %F";
   app = "";
   topic = "";
   item = "";
   useDDE = 0;
}
static void getMO( var execmd, var useDDE, var app, var topic, var item)
{
   execmd = "xmosaic";
   app = "";
   topic = "";
   item = "";
   useDDE = 0;
}
// Desc:  Look up the Registry for browser information.
static void getAuto( var execmd, var useDDE, var app, var topic, var item, _str type )
{
   regComp =_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\.htm","");
   if ( regComp == "NetscapeMarkup" ) {
      getNS( execmd, useDDE, app, topic, item, type );
   } else if ( regComp == "htmlfile" ) {
      getIE( execmd, useDDE, app, topic, item, type );
   } else {
      execmd = "";
      app = "";
      topic = "";
      item = "";
      useDDE = 0;
   }
}
static void getOther( var execmd, var useDDE, var app, var topic, var item)
{
   execmd = "";
   app = "";
   topic = "";
   item = "";
   useDDE = 0;
}
static void toggleUseDDE( s )
{
   _dde_fr.p_enabled = s;
   _app_la.p_enabled = s;
   _app_tx.p_enabled = s;
   _topic_la.p_enabled = s;
   _topic_tx.p_enabled = s;
   _item_la.p_enabled = s;
   _item_tx.p_enabled = s;
}
static void updateUseDDE()
{
   if ( _useDDE_tb.p_value ) toggleUseDDE( true );
   else toggleUseDDE( false );
}
static void quotecmd( var execmd )
{
   //messageNwait( "b4 cmd="execmd );
   //p = pos( '"', execmd );
   //if ( p == 1 ) return;

   endw = "";
   temp = execmd;
   qtemp = maybe_quote_filename(temp);
   for (;;) {
      //messageNwait( "b4 qtemp="qtemp );
      fn = file_match("-p "qtemp, 1 );
      if ( fn != "" ) {
         execmd = qtemp" "endw;
         //messageNwait( "a1 cmd="execmd );
         return;
      }
      w = strip_last_word( temp );
      if ( temp == "" ) {
         //messageNwait( "a2 cmd="execmd );
         return;
      }
      if ( w != "%1" && w != "\"%1\"" && w != "%F" ) {
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      qtemp = maybe_quote_filename(temp);
   }
}
// Desc:  Activate the browser and bring it to foreground.
// Retn:  0 for OK, < 0 for error.
static int activateBrowser(app)
{
   //messageNwait( "PREVENT CRASH... b4 _dderequest WWW_Activate app="app );
   item = "0xFFFFFFFF,0x0";
   topic = "WWW_Activate";
   old_view_id = p_view_id;
   status=_dderequest("L",app,item,topic);
   p_view_id = old_view_id;
   //messageNwait( "after _dderequest status="status );
   return( status );
}
// Desc:  Start browser.
// Retn:  0 for OK, 1 for can't start browser.
static int startBrowser()
{  
   type='f';
   // Build the start browser command:
   if ( buildRequest( "", execmd, useDDE, app, topic, item, type ) ) {
      return( 1 );
   }

   // Try activating existing browser:
   bi = def_html_info.browser[osi];
   if ( useDDE ) {
      status = activateBrowser(app);
      if ( !status ) return( 0 );
   }

   // Start browser:
   quotecmd( execmd );
   if ( shell( execmd, 'A' ) ) {
      msg = "Can't start browser with \n'"execmd"'.\n\nPlease use Web Browser Setup dialog to correct your path.";
      _message_box(msg);
      return( 1 );
   }
   return( 0 );
}


// Desc:  Preview the HTML file.
_command int html_preview()  name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _init_osi();
   // Make sure buffer is an HTML markup file:
   ext = p_extension;
   if ( !file_eq(ext,"html") ) {
      old_view_id = _create_temp_view( view_id );
      status = startBrowser();
      _delete_temp_view( view_id );
      if ( status ) return( 1 )
      return( 0 );
   }
   filename = p_buf_name;

   // If buffer has been modified, verify save with the user:
   if ( p_modify ) {
      if ( save() ) return( 1 );
   }

   // View the document:
   mou_set_pointer( MP_HOUR_GLASS );
   old_view_id = _create_temp_view( view_id );
   type= 'f';
   if ( nsViewDoc( filename, type ) ) {
      _message_box( "Can't preview file." );
   }
   _delete_temp_view( view_id );
   mou_set_pointer( MP_DEFAULT );
   return( 0 );
}


#if 0
_command tan_t1()  name_info(','VSARG2_EDITORCTL)
{
   value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\NetscapeMarkup\\shell\\open\\command","");
   message( value );
   return( '' );
}
_command tan_t2()  name_info(','VSARG2_EDITORCTL)
{
   value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\.html","");
   regPath = "SOFTWARE\\Classes\\"value"\\shell\\open\\command"
   exePath =_ntRegQueryValue(HKEY_LOCAL_MACHINE,regPath,"");
   messageNwait( "auto: "exePath );

   value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\htmlfile\\shell\\open\\command","");
   messageNwait( "IExplorer: "value );

   value=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\NetscapeMarkup\\shell\\open\\command","");
   messageNwait( "NS: "value );


   return( '' );
}
#endif


//---------------------------------------------------------------------
// Desc:  Check to see if tag is a standalone tag, having no matching
//     start and end component.
// Retn:  1 for yes, 0 for no.
static int isStandAloneTag( _str tag )
{
   for ( i = 0; i < standAloneTagList._length(); i++ ) {
      if ( tag == standAloneTagList[i] ) {
         return( 1 );
      }
   }
   return( 0 );
}
// Desc:  Skip over the comment tag.  This skips over anything until -->
// Retn:  0 for OK, <0 for error.
static int skipOverCommentTag()
{
   // Move cursor to start char:
   oPos = _seek();
   status = _nrseek( oPos + 1 );
   if ( status == "" ) {
      status = _nrseek( oPos );
      return( -1 );
   }
     
   // Loop until found the matching end char:
   level = 0;
   status = search( "-->", "@" );
   if ( status ) {
      _nrseek( oPos );
      return( -1 );
   }
   seek_pos = _nrseek();
   _nrseek( seek_pos + 3 );
   return( 0 );
}
// Desc:  Skip over the tag.  Support embedded tags.
// Retn:  0 for OK, <0 for error.
static int skipOverTag()
{
   /*
   // Special case for comment tag:
   start = get_text( 4 );
   if ( start == "<!--" ) {
      return( skipOverCommentTag() );
   }
   */

   // Move cursor to start char:
   oPos = _nrseek();
   status = _nrseek( oPos + 1 );
   if ( status == "" ) {
      status = _nrseek( oPos );
      return( -1 );
   }
     
   // Loop until found the matching end char:
   level = 0;
   //status = search( "[<>]", "r@CK" );
   status = search( "[<>]", "r@XCS" );
   for (;;) {
      if ( status ) {
         _nrseek( oPos );
         return( -1 );
      }
      ch = get_text();
      if ( ch == ">" ) {
         if ( !level ) {
            seek_pos = _nrseek();
            _nrseek( seek_pos + 1 );
            return( 0 );
         }
         level--;
      }
      if ( ch == "<" ) {
         level++;
      }
      status = repeat_search();
   }
   return( -1 );
}
// Desc:  Extract the tag from the word at cursor.
// Retn:  tag, or "" if tag not found.
static _str getTag( int noMove, var startTag )
{
   startTag = 1;
   seek_pos = _nrseek();
   oPos = seek_pos;
   startPos = seek_pos + 1;
   //status = search( ">", "@CK" );
   status = search(">", "@XCS");
   if ( status ) {
      _nrseek( oPos );
      return( "" );
   }
   seek_pos = _nrseek();
   tag = get_text( seek_pos - startPos, startPos );
   tag = strip( tag, "L" );
   p = pos(":b", tag, 1, "r" );
   if ( p ) {
      tag =  substr( tag, 1, p-1);
   }
   tag = upcase( tag );
   if ( noMove ) {
      status = _nrseek( oPos );
   } else {
      status = _nrseek( seek_pos + 1 );
   }
   if ( substr(tag,1,1) == "/" ) {
      tag = substr( tag, 2 );
      startTag = 0;
   } else if ( substr(tag,1,3) == "!--" ) {
      tag = "!--";
   }
   return( tag );
}
// Desc:  Skip to the beginning of the next tag.
// Retn:  0 for OK, <0 for error.
static int skipToNextTag()
{
   oPos = _nrseek();
   //status = search( "<", "@CK" );
   status = search( "<", "@XCS" );
   if ( status ) {
      _nrseek( oPos );
      return( -1 );
   }
   return( 0 );
}
// Desc:  Skip to the beginning of the previous tag.
// Retn:  0 for OK, <0 for error.
static int skipToPrevTag()
{
   level = 0;
   oPos = _nrseek();
   status = _nrseek( oPos - 1 ); 
   if ( status == "" ) {
      status = _nrseek( oPos );
      return( -1 );
   }
   //status = search( "[<>]", "-r@CK" );
   status = search( "[<>]", "-r@XCS" );
   for (;;) {
      if ( status ) {
         _nrseek( oPos );
         return( -1 );
      }
      ch = get_text();
      if ( ch == ">" ) {
         level++;
      } else {
         level--;
         if ( !level ) { return( 0 ); }
      }
      status = repeat_search();
   }
   return( -1 );
}

// Desc:  Find the matching tag that after this one.
//     The cursor is placed at the start of the matching tag.
// Retn:  0 for match found, <0 for not found.
static int matchTagForward( _str ktag, int cursorAtEndTag )
{
   int status;
   int level;

   //messageNwait("h0 ktag="ktag);
   level = 0;
   skipOverTag();
   for (;;) {
      _str search_str;
      search_str = "<:b@(":+ktag:+"|/":+ktag:+")";
      //messageNwait("search_str="search_str);
      //status = search(search_str, "ri@CK");
      status = search(search_str, "ri@XCS");
      if (status) return(-1);
      _str ch;
      int startTag;
      ch = getTag(1, startTag);
      if (!startTag) {  // Found ending tag
         if (!level) {
            //status = search("<", "-r@CK");  // position the text cursor at the start of the tag
            status = search("<", "-r@XCS");  // position the text cursor at the start of the tag
            return(0);
         }
         //status = search(">", "r@CK");  // skip to the end of the tag
         status = search(">", "r@XCS");  // skip to the end of the tag
         if (status) return(-1);
         level--;
      } else {  // Nested tag
         level++;
         //status = search(">", "r@CK");  // skip to the end of the tag
         status = search(">", "r@XCS");  // skip to the end of the tag
         if (status) return(-1);
      }
   }
   return(-1);
}

static int matchTagBackward( _str ktag )
{
   int status;
   int level;

   // Skip to the end of the previous tag (so that this tag won't be counted twice):
   //status = search(">", "-r@CK");
   status = search(">", "-r@XCS");
   if (status) return(-1);

   level = 0;
   for (;;) {
      _str search_str;
      search_str = "<:b@(":+ktag:+"|/":+ktag:+")";
      //status = search(search_str, "-ri@CK");
      status = search(search_str, "-ri@XCS");
      if (status) return(-1);
      _str ch;
      int startTag;
      ch = getTag(1, startTag);
      if (!startTag) {  // Found ending tag.  Nested tag for reverse search
         level++;
         //status = search(">", "-r@CK");  // skip to the end of the previous tag
         status = search(">", "-r@XCS");  // skip to the end of the previous tag
         if (status) return(-1);
      } else { 
         if (!level) {
            return(0);  // found matching tag and cursor also already at the beginning of the tag
         }
         //status = search(">", "-r@CK");  // skip to the end of the previous tag
         status = search(">", "-r@XCS");  // skip to the end of the previous tag
         if (status) return(-1);
         level--;
      }
   }
   return(-1);
}
// Desc:  Go to the matching tag.  If this is the end tag, go to the start tag,
//     and vice versa.
// Retn:  0 for match found, -1 for not found, -2 for standalone tag (no matching
//        start/end pair).
static int matchTag( int cursorAtEndTag, var direction )
{
   int startTag;
   tag = getTag( 1, startTag );
   if ( tag == "" ) { return( -1 ); }
   if ( tag == "!--" ) { return( -3 ); }
   if ( isStandAloneTag(tag) ) { return( -2 ); }
   if ( startTag ) {
      status = matchTagForward( tag, cursorAtEndTag );
      direction = "F";
   } else {
      status = matchTagBackward( tag );
      direction = "B";
   }
   return( status );
}
// Desc:  Find the start of the comment tag from the end of the tag.
//     Skip over everything until <!--
// Retn:  0 for OK, <0 for error.
static int findStartCommentTag()
{
   oPos = _nrseek();
   status = search( "<!--", "-@" );
   if ( status ) {
      _nrseek( oPos );
      return( -1 );
   }
   return( 0 );
}

// Desc:  Find the start of a tag.  If already on a tag, do nothing.
// Retn:  0 for OK, <0 for error.
static int findStartTag()
{
   // Look forward for end tag:
   oPos = _nrseek();
   //status = search( "[<>]", "r@CK" );
   status = search( "[<>]", "r@XCS" );
   if ( status ) {
      _nrseek( oPos );
      return( -1 );
   }
   ch = get_text();
   if ( ch == ">" ) {
      seek_pos = _nrseek();
      status = _nrseek( seek_pos - 1 );
      if ( status == "" ) {
         _nrseek( oPos );
         return( -1 );
      }
      if ( get_text() == "-" ) {
         status = _nrseek( seek_pos - 2 );
         if ( status == "" ) {
            _nrseek( oPos );
            return( -1 );
         }
         if ( get_text() == "-" ) {
            return( findStartCommentTag() );
         }
      }
   } else {
      _nrseek( oPos );
   }

   // Look backward for start tag:
   taglevel = 0;
   level = 0;
   for (;;) {
      //status = search( "[<>]", "-r@CK" );
      status = search( "[<>]", "-r@XCS" );
      if ( status ) {
         _nrseek( oPos );
         return( -1 );
      }
      ch = get_text();
      if ( ch == ">" ) {
         seek_pos = _nrseek();
         status = _nrseek( seek_pos - 2 );
         if ( status == "" ) {
            _nrseek( oPos );
            return( -1 );
         }
         start = get_text( 3 );
         if ( start == "-->" ) {
            status = findStartCommentTag();
         } else {
            seek( seek_pos );
            level++;
         }
      } else if ( ch == "<" ) {
         // Found start of some sort of nested tag <tag ... <...>   >
         if ( !level ) { return( 0 ); }
         level--;
         // Skip over standalone tag:
         tag = getTag( 1, startTag );
         //messageNwait( "h1 tag="tag" startTag="startTag );
         if ( tag == "!--" ) { return( 0 ); }
         if ( !isStandAloneTag(tag) ) {
            if ( startTag ) {
               if ( !taglevel ) {
                  return( 0 );
               }
               taglevel--;
            } else {
               taglevel++;
            }
         }
      }
      // Have to manually go back one and restart search because getTag()
      // also uses search() and that messes up the repeat_search().
      seek_pos = _nrseek();
      status = _nrseek( seek_pos - 1 );
      if ( status == "" ) {
         _nrseek( oPos );
         return( -1 );
      }
   }
   return( -1 );
}

// Desc:  Check to see if the specified tag is considered to be
//        part of the P tag.
// Retn:  1 for yes, 0 for no.
static int isTagAllowedInPtag(_str tag)
{
   for (i=0; i<tagAllowedInPTag._length(); i++) {
      if (tag == tagAllowedInPTag[i]) {
         return(1);
      }
   }
   return(0);
}

// Desc:  Find a "reasonable" end for the <P> tag.
//        A reasonable end is another tag that terminates a P tag.
// Retn:  0 for OK, -1 for error
static int scanForEndPara()
{
   int startLine;
   startLine = p_line;

   int status, startOfTag, savepos;
   _str tag;
   while (1) {
      status = skipToNextTag();
      if (status) {
         return(-1);
      }
      savepos = _nrseek();
      tag = getTag(0, startOfTag);
      if (tag == "") {
         return(-1);
      }
      if (!isTagAllowedInPtag(tag)) {
         _nrseek(savepos);
         status = search("\n", "-r@XCS");
         _nrseek(_nrseek()-1);
         return(0);
      }
   }
   return(0);
}


//---------------------------------------------------------------------
// Desc:  Match the tag component.
//
//        <FONT FACE="ITC Officina Sans Bold" POINT-SIZE=9>Hello</FONT>
//        ^                                                     ^
// Retn:  0 for OK, -1 for error.
_command int htool_matchtag()  name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   ext = p_extension;
   if ( !file_eq(ext,"html") ) {
      message( "Matching HTML tag pair only works with HTML files." );
      return( -1 );
   }

   // Remember the position:
   save_pos( cs_ori_position );
   oPos = _nrseek(); 

   findStartTag();
   oLine = p_line; oCol = p_col;

   // Find the matching tag:
   status = matchTag( 0, direction );
   if ( status ) {
      restore_pos( cs_ori_position );
      _nrseek( oPos );
      message( "Matching HTML tag pair not found!" );
   }
   return( 0 );
}

// Desc:  Select the tag component.
//
//        <FONT FACE="ITC Officina Sans Bold" POINT-SIZE=9>Hello</FONT>
//        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
_command int htool_selectcomp()  name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _str ext;
   ext = p_extension;
   if ( !file_eq(ext,"html") ) {
      message( "Selecting HTML tag component only works with HTML files." );
      return( -1 );
   }

   // Remember the position:
   save_pos( cs_ori_position );
   oPos = _nrseek();

   findStartTag();
   oLine = p_line; oCol = p_col;
   skipOverTag();

   // Tag found, select the text between the start tag and the end tag: 
   temp_line = p_line; temp_col = p_col;
   deselect();
   persistent=(def_persistent_select=='Y')?'P':'';
   mstyle='EN'persistent;

   // Restore the original position before starting selection:
   // This prevents the 'jumping' of the view.
   restore_pos( cs_ori_position );

   // Select text:
   if ( temp_line != oLine ) {
      // Selected text spans multiple lines, do line selection:
      p_line = oLine; p_col = oCol;
      _select_line('',mstyle);
      p_line = temp_line; p_col = temp_col;
      _select_line('',mstyle);
   } else {
      // Selected text spans a single line, do character selection:
      p_line = oLine; p_col = oCol;
      _select_char('',mstyle);
      p_line = temp_line; p_col = temp_col;
      _select_char('',mstyle);
   }
   return( 0 );
}

// Desc:  Find the start and ending lines for the current tag.
// Retn:  0 for found, -1 for not found or error.
int htool_selecttag2(int & startLine, int & startCol, int & endLine, int & endCol)
{
   int startTagPos,oPos;

   oPos = _nrseek();
   findStartTag();
   startTagPos = _nrseek();
   oLine = p_line; oCol = p_col;

   // Find the matching tag:
   int status;
   status = matchTag( 1, direction );
   if (status == -1) {  // match not found
      // Special case for P tag:
      // We treat the P tag special because it may and may not have
      // its matching /P.
      int startOfTag;
      _str tag;
      _nrseek(startTagPos);
      tag = getTag(0, startOfTag);

      // When we find a <P> without matching </P>,
      // scan for the next blank line or next <P> tag.
      if (tag == "P") {
         status = scanForEndPara();
         if (status) {
            _nrseek( oPos );
            return( -1 );
         }
      } else {
         _nrseek( oPos );
         return( -1 );
      }
   } else if (status == -2) {  // found stand alone tag
      startLine = oLine; startCol = oCol;
      //status = search(">", "r@CK");  // skip to the end of the tag
      status = search(">", "r@XCS");  // skip to the end of the tag
      if (status) return(-1);
      seek_pos = _nrseek();
      if (_nrseek(seek_pos + 1) == "") return(-1);
   } else {
      if ( direction == "B" ) {
         temp_line = oLine; temp_col = oCol;
         oLine = p_line; oCol = p_col;
         p_line = temp_line; p_col = temp_col;
      }
      //status = search(">", "r@CK");  // skip to the end of the tag
      status = search(">", "r@XCS");  // skip to the end of the tag
      if (status) return(-1);
      seek_pos = _nrseek();
      if (_nrseek(seek_pos + 1) == "") return(-1);
   }

   // Tag found, select the text between the start tag and the end tag: 
   temp_line = p_line; temp_col = p_col;

   // Select text:
   startLine = oLine; startCol = oCol;
   endLine = temp_line; endCol = temp_col;
   if ( temp_line == oLine ) {
      if (endCol > 1) endCol--;
   }
   return( 0 );
}

// Desc:  Expand the selected HTML component to include the outer tag.
// Retn:  0 for OK, -1 for can not further expand.
int htool_expandsel(int & startLine, int & startCol, int & endLine, int & endCol)
{
   // Skip to the next tag:
   if (skipToNextTag() < 0) {
      return(-1);
   }

   int countPtag;
   countPtag = 0;

   // Find the next ending tag that does not have a matching starting tag:
   // If found, this is the ending of the tag that encloses the currently
   // selected tag.
   while (1) {
      // Found the ending of a tag:
      int startTag;
      _str tag;
      tag = getTag(1, startTag);

      // Special case for P and /P tags:
      if (tag == "P") {
         // Count the nesting level.  If we find an extra /P, this means
         // that we are inside a P and /P pair:
         if (startTag) {
            countPtag++;
         } else {
            countPtag--;
         }
         if (countPtag < 0) {  // inside a P /P pair
            break;
         }

         // Skip over the P tag:
         int seek_pos;
         seek_pos = _nrseek();
         if (_nrseek(seek_pos + 1) == "") return(-1);
         if (skipToNextTag() < 0) return(-1);
         continue;
      }

      // If found an end tag (/XXX), we found the next nesting level:
      if (!startTag) break;

      // Skip over stand-alone tags:
      if (isStandAloneTag(tag)) {
         int seek_pos;
         seek_pos = _nrseek();
         if (_nrseek(seek_pos + 1) == "") return(-1);
         if (skipToNextTag() < 0) return(-1);
         continue;
      }

      // This is the start of a tag, jump to its matching end:
      // Find the matching end tag:
      _str direction;
      status = matchTag( 0, direction );
      if (status == -1) return(-1);  // matching ending tag is not found! Give up.

      // Found stand-alone tag or found the matching ending tag, just skip over it:
      int seek_pos;
      seek_pos = _nrseek();
      if (_nrseek(seek_pos + 1) == "") return(-1);
      if (skipToNextTag() < 0) return(-1);
   }

   // Select this new tag:
   return(htool_selecttag2(startLine, startCol, endLine, endCol));
}

_command int goto_microedge() name_info(','HELP_ARG2|NCW_ARG2|ICON_ARG2|EDITORCTL_ARG2)
{
   _init_osi();
   site = 'www.slickedit.com';

   // View the document:
   mou_set_pointer( MP_HOUR_GLASS );
   old_view_id = _create_temp_view( view_id );
   type = 'p';
   if ( nsViewDoc( site, type ) ) {
      _message_box( "Can't Open Site." );
   }
   _delete_temp_view( view_id );
   mou_set_pointer( MP_DEFAULT );
   return( 0 );
}


_command int online_registration() name_info(',')
{
   _init_osi();
   site = 'www.slickedit.com/register.htm';

   // View the document:
   mou_set_pointer( MP_HOUR_GLASS );
   old_view_id = _create_temp_view( view_id );
   type = 'p';
   if ( nsViewDoc( site, type ) ) {
      _message_box( "Can't Open Site." );
   }
   _delete_temp_view( view_id );
   mou_set_pointer( MP_DEFAULT );
   return( 0 );
}

