/*
  To install this macro, perform use
  the Load module dialog box ("Macro", "Load Module...").
  
  Built-in aliases
   
    IF THEN
    ENDIF;
    LOOP
    END LOOP;
    FOR  IN  LOOP
    END LOOP;
    WHILE  LOOP
    END LOOP;
    BEGIN
    END;
    WHEN  THEN
    ELSIF  THEN
    END
    EXCEPTION
    ELSE
    RETURN
    
    DECLARE
    BEGIN
    END;
  

*/
#include 'slick.sh'

#define EXTENSION 'plsql'
#define MODE_NAME 'PL/SQL'
#define VLXLEXERNAME  'PL/SQL'
#define IDENTIFIER_CHARS  '@A-Za-z0-9_$#'

boolean def_plsql_smartpaste=1;
boolean def_plsql_autocase;

static int gWordEndOffset=-1;
static _str gWord;

defload()
{
   setup_info='MN='MODE_NAME',TABS=+3,MA=1 74 1,':+
               'KEYTAB='EXTENSION'-keys,WW=1,IWT=0,ST=0,IN=2,WC='IDENTIFIER_CHARS',LN='VLXLEXERNAME',CF=1,';
   compile_info='';
   // The first two number are syntax_indent amount and expand on/off
   // the restore of 
   syntax_info='3 1 ':+   // <Syntax indent amount>  <expansion on/off>
               '1 1 0';   // <min abbrev> <word_case> <begin/end style>
   be_info='';
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info);
   set_eventtab_index(kt_index,event2index(ENTER),find_index('plsql-enter',COMMAND_TYPE));
   set_eventtab_index(kt_index,event2index(' '),find_index('plsql-space',COMMAND_TYPE));
   index=find_index('def-setup-sql',MISC_TYPE);
   if (index && substr(name_info(index),1,1)!='@') {
      delete_name(index);
      insert_name('def-setup-sql',MISC_TYPE,'@plsql');
   } else if(!index) {
      insert_name('def-setup-sql',MISC_TYPE,'@plsql');
   }
}
boolean def_plsql_autocase=1;
//0 = lowcase
//1 = UPPER CASE
//2 = Capitalize Word
static _str word_case(_str s)
{
   parse name_info(p_index) with . . . scase .;
   if (scase== -1) {
      return(s);
   } else if ( scase==0 ) {
      return(lowcase(s)) /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s))    /* Upper case language key words. */
   }
   s=lowcase(s);

   // Uppercase the first letter of each word
   for (i=1;;) {
      i=pos('(^|:b)\c['p_word_chars']',s,i,'r');
      if (!i) {
         break;
      }
      s=substr(s,1,i-1):+upcase(substr(s,i,1)):+
         substr(s,i+1);
      i=i+1;
   }
   return(s);
}

defeventtab plsql_keys
//def ' '=sql_space
//def ENTER=sql_enter*/
def ';'=plsql_semi

_command plsql_mode()  name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('plsql');
}
_command plsql_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         plsql_expand_enter(p_SyntaxIndent,expand) ) {
      call_root_key(ENTER);
   } else if (_argument=='') {
      _undo('S');
   }

}
_command void plsql_semi() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   // check if the word at the cursor is end
   cfg=_clex_find(0,'g');
   get_line(line);
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || lowcase(line)!='end') {
      keyin(';');
      return;
   }
   save_pos(orig_pos);
   up();_end_line();
   col=_plsql_find_block_col(block_info,true,true);
   restore_pos(orig_pos);
   if (col) {
      replace_line(indent_string(col-1)strip(line)';');_end_line();
   } else {
      keyin(';');
   }
}

_command plsql_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ');
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      plsql_expand_space(p_SyntaxIndent) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
            save_pos(orig_pos);
            left();left();
            cfg=_clex_find(0,'g');
            if (cfg==CFG_KEYWORD && def_plsql_autocase) {
               cw=cur_word(word_pcol);
               p_col=_text_colc(word_pcol,'I');
               _delete_text(length(cw));
               _insert_text(word_case(cw));
            }
            restore_pos(orig_pos);
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}

   static _str space_words[]={
      'if','loop','for','while','begin','when','end','return','exception','else','elsif','declare'
   };



/*
    Returns true if nothing is done
*/
static boolean plsql_expand_enter(syntax_indent)
{
#if 0
   save_pos(p);
   orig_linenum=p_line;
   orig_col=p_col;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }

   // Skip comments to get some real code
   status=_clex_skip_blanks("-");
   if (status) {
      return(1);
   }
   word=cur_word(junk);
   if (lowcase(word)=='then') {
      first_non_blank();col=p_col;
      restore_pos(p);
      col+=syntax_indent;
      // IF user configured ENTER to indent with real spaces
      if( def_enter_indent ) {
         insert_line(indent_string(col-1));
      } else {
         insert_line('');
      }
      p_col=col;
      return(0);   // Indicate that we are done with enter key processing
   }
   restore_pos(p);

   return(1)
   // sample code below in case we get fancy.
#endif
   save_pos(p);
   orig_linenum=p_line;
   orig_col=p_col;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }
   get_line(line);
   if ((lowcase(line)=='exception')  && p_col==_text_colc()+1) {
      col=_plsql_find_block_col(block_info,true,true);
      if (col) {
         replace_line(indent_string(col-1)word_case(strip(line)));_end_line();
         save_pos(p);
      }

   } else if (lowcase(line)=='else' && p_col==_text_colc()+1) {
      col=_plsql_find_block_col(block_info,true,true);
      if (col && lowcase(block_info)!='if') {
         col+=syntax_indent;
      }
      if (col) {
         replace_line(indent_string(col-1)word_case(strip(line)));_end_line();
         save_pos(p);
      }

   } else if (lowcase(line)=='begin' && p_col==_text_colc()+1) {
      col=_plsql_find_begin_block_col(true);
      if (col>0) {
         replace_line(indent_string(col-1)word_case(strip(line)));_end_line();
         save_pos(p);
      }
   } else if (lowcase(line)=='declare' && p_col==_text_colc()+1) {
      col=_plsql_find_declare_block_col();
      if (col>0) {
         replace_line(indent_string(col-1)word_case(strip(line)));_end_line();
         save_pos(p);
      }
   }

   begin_col=plsql_begin_stat_col(false /* No RestorePos */,
                              false /* Don't skip first begin statement marker */,
                              false /* Don't return first non-blank */,
                              1  /* Return 0 if no code before cursor. */,
                              '',
                              1
                              );
   if (!begin_col /*|| (p_line>orig_linenum)*/) {
      restore_pos(p);
      return(1);
   }
   restore_pos(p);
   col=_plsql_indent_col(0);
   indent_on_enter('',col);
   return(0)
}
/*
    Returns true if nothing is done.
*/
static boolean plsql_expand_space(syntax_indent)
{
   status=0
   get_line orig_line
   line=strip(orig_line,'T')
   orig_word=strip(line);
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   if_special_case=0;
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename)
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') return(1);

   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   orig_word=word;
   word=lowcase(word);
   if ( word=='if' ) {
      replace_line(word_case(line:+'  then'));
      insert_line(indent_string(width)word_case('end if;'));
      up();_end_line();p_col-=5;
   } else if (word=='while') {
      replace_line(word_case(line:+'  loop'));
      insert_line(indent_string(width)word_case('end loop;'));
      up();_end_line();p_col-=5;
   } else if (word=='for') {
      replace_line(word_case(line:+'  in  loop'));
      insert_line(indent_string(width)word_case('end loop;'));
      up();_end_line();p_col-=9;
   } else if (word=='loop') {
      replace_line(word_case(line));
      insert_line(indent_string(width)word_case('end loop;'));
      up();_end_line();++p_col;
   } else if (word=='begin') {
      save_pos(p2);
      first_non_blank();
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      col=_plsql_find_begin_block_col(false);
      restore_pos(p2);
      if (col<=0) {
         replace_line(word_case(line));
         insert_line(indent_string(width)word_case('end;'));
         up();_end_line();++p_col;
      } else {
         restore_pos(p2);
         replace_line(indent_string(col-1)word_case('begin'));
         insert_line(indent_string(col-1)word_case('end;'));
         up();_end_line();++p_col;
      }
   } else if (word=='declare') {
      save_pos(p2);
      col=_plsql_find_declare_block_col();
      restore_pos(p2);
      if (col<0) {
         replace_line(word_case(line));
         insert_line(indent_string(width)word_case('begin'));
         insert_line(indent_string(width)word_case('end;'));
         up(2);_end_line();++p_col;
      } else {
         restore_pos(p2);
         replace_line(indent_string(col-1)word_case('declare'));
         insert_line(indent_string(col-1)word_case('begin'));
         insert_line(indent_string(col-1)word_case('end;'));
         up(2);_end_line();++p_col;
      }
   } else if (word=='when') {
      col=_plsql_find_block_col(block_info,true,true);
      if (col) {
         replace_line(indent_string(col-1+syntax_indent)word_case(orig_word'  then'));
         _end_line();p_col-=5;
      } else {
         replace_line(line:+word_case('  then'));
         _end_line();p_col-=5;
      }
   } else if (word=='elsif') {
      col=_plsql_find_block_col(block_info,true,true);
      if (col) {
         replace_line(indent_string(col-1)word_case(orig_word'  then'));
         _end_line();p_col-=5;
      } else {
         replace_line(word_case(line));
         _end_line();++p_col;
      }
   } else if (word=='end' || word=='exception') {
      save_pos(p2);
      if (word=='end') {
         up();_end_line();
      }
      col=_plsql_find_block_col(block_info,true,true);
      restore_pos(p2);
      if (col) {
         replace_line(indent_string(col-1)word_case(orig_word));
         _end_line();++p_col;
      } else {
         replace_line(word_case(line));
         _end_line();++p_col;
      }
   } else if (word=='return') {
      replace_line(word_case(line));
      _end_line();++p_col;
   } else if (word=='else') {
      save_pos(p2);
      if (word=='end') {
         up();_end_line();
      }
      col=_plsql_find_block_col(block_info,true,true);
      restore_pos(p2);
      if (col && lowcase(block_info)!='if') {
         col+=syntax_indent;
      }
      if (col) {
         replace_line(indent_string(col-1)word_case(orig_word));
         _end_line();++p_col;
      } else {
         replace_line(word_case(line));
         _end_line();++p_col;
      }
   } else {
     status=1
   }
   return status

}
static boolean _isProtoType()
{
   save_pos(orig_pos);
   save_search(p1,p2,p3,p4);
   status=search(';|is|as','@hrixcs');
   for (;;) {
      if (status) {
         restore_search(p1,p2,p3,p4);
         restore_pos(orig_pos);
         return(status);
      }
      if (match_length()==1) {
         cw=';';
         break;
      }
      cw=upcase(cur_word(junk));
      if(cw=='IS' || cw=='AS') {
         break;
      }
      status=repeat_search();
   }
   restore_search(p1,p2,p3,p4);
   restore_pos(orig_pos);
   return(cw==';');
}
/*

CREATE [OR REPLACE] PACKAGE name {IS|AS}
[BEGIN]
END
CREATE [OR REPLACE] PROCEDURE  name [(args)] {IS|AS}
CREATE [OR REPLACE] FUNCTION  name [(args)] RETURN type {IS|AS}
CREATE [OR REPLACE] TRIGGER name {BEFORE|AFTER} event ON table
 [FOR EACH ROW [WHEN trigger_condition]]
DECLARE 
BEGIN
END

CREATE OR REPLACE PACKAGE mypackage AS
  FUNCTION a(x IN CHAR) RETURN VARCHAR2;
  PROCEDURE p(a IN CHAR);
END mypackage;  

CREATE [OR REPLACE] TRIGGER mypackage
  AFTER INSERT OR DELETE OR UPDATE ON students 
  [FOR EACH ROW [WHEN trigger condition]]
DECLARE
BEGIN
END [mypackage];  
<<label>>

*/

_str plsql_proc_search(_str &proc_name,int find_first)
{
   if ( find_first ) {
      variable_re='(['p_word_chars']#)';
      re='(procedure|function|trigger)[ \t]+{#0'variable_re'}';
         //_mdi.p_child.insert_line(re);
      status=search(re,'hri@xcs');
   } else {
      status=repeat_search();
   }
   save_pos(orig_pos);
   for (;;) {
      if ( status ) {
         restore_pos(orig_pos);
         break;
      }
      name=get_text(match_length('0'),match_length('S0'));
      // Check if this is a prototype or procedure definition
      if (_isProtoType()) {
         type='proto)';
      } else {
         type='func)';
      }
      parse name with classname'.'name;
      if (name=='') {
         name=classname;
         classname='('
      } else {
         classname='(':+classname':';
      }
      name=name:+classname:+type;
      if (proc_name:=='') {
         proc_name=name;
         return(0);
      } 
      if (proc_name==name) {
         return(0);
      }
      status=repeat_search();
   }
   return(status)
}

/*
    This functions make show_procs smarter by showing user
    all parameters and attributes of the function definition
    but not the code.
*/
void plsql_find_lastprocparam()
{
   save_pos(p);
   startpos=_nrseek();
   status=search("is|as|begin|declare","hrwixcs");
   if (status) {
      restore_pos(p);
      return;
   }
   orig_col=p_col;
   first_non_blank();
   if (p_col==orig_col) {
      up();_end_line();
   }
}

#if 0
/*

CREATE [OR REPLACE] PACKAGE name {IS|AS}
[BEGIN]
END
CREATE [OR REPLACE] PROCEDURE  name [(args)] {IS|AS}
CREATE [OR REPLACE] FUNCTION  name [(args)] RETURN type {IS|AS}
CREATE [OR REPLACE] TRIGGER name {BEFORE|AFTER} event ON table
 [FOR EACH ROW [WHEN trigger_condition]]
DECLARE 
BEGIN
END

CREATE OR REPLACE PACKAGE mypackage AS
  FUNCTION a(x IN CHAR) RETURN VARCHAR2;
  PROCEDURE p(a IN CHAR);
END mypackage;  

CREATE [OR REPLACE] TRIGGER mypackage
  AFTER INSERT OR DELETE OR UPDATE ON students 
  [FOR EACH ROW [WHEN trigger condition]]
DECLARE
BEGIN
END [mypackage];  
<<label>>

*/

static _str gStackEndBelongsTo[];
static _str gPackageName;
_str _proc_search(var proc_name,find_first)
{
   if ( find_first ) {
      variable_re='([A-Za-z]['WORD_CHARS']@)';
      gPackageName='';
      gStackEndBelongsTo._makeempty();
      re='(procedure|function|package|trigger)[ \t]+{#1(body[ \t]+|)}{#0'variable_re'}':+
         '|':+
         'end({#0};|[ \t]+{#0'variable_re'})':+
         '|':+
         'declare([~'WORD_CHARS']|$){#0}':+
         '|':+
         '<<{#0'variable_re'}>>';
         //_mdi.p_child.insert_line(re);
      status=search(re,'hri@xcs');
   } else {
      status=repeat_search();
   }
   save_pos(orig_pos);
   for (;;) {
      if ( status ) {
         restore_pos(orig_pos);
         break;
      }
      // Make sure we have a complete word match just in case
      // there is a new keyword like subend
      ch=get_text(2);
      if (ch!='<<') {
         if (p_col!=1) {
            left();
            if (get_text()!='') {
               right();
               status=repeat_search();
               continue;
            }
            right();
         }
         if (_clex_find(0,'g'):!=CFG_KEYWORD) {
            status=repeat_search();
            continue;
         }
      } else {
         cfg=_clex_find(0,'g');
         if (cfg:==CFG_COMMENT || cfg==CFG_STRING) {
            status=repeat_search();
            continue;
         }
      }
      ch=lowcase(ch);
      name=get_text(match_length('0'),match_length('S0'));
      if (ch=='en') { // end keyword case
         if (name=='loop' || name=='if') {
             status=repeat_search();
             continue;
         }
         i=gStackEndBelongsTo._length()-1;
         if (i>=0) {
            EndBelongsTo=gStackEndBelongsTo[i];
            gStackEndBelongsTo._deleteel(i);
            if (EndBelongsTo=='package' || EndBelongsTo=='trigger') {
               gPackageName='';
            }
         }
         status=repeat_search();
         continue;
      }
      switch (ch) {
      case 'pr':
      case 'fu':
         save_pos(p);
         save_search(a,b,c,d);
         status=search(';|((^|[~'WORD_CHARS'])begin($|[~'WORD_CHARS']))','hrie@xcs');
         if (status) {
            restore_search(a,b,c,d);
            _end_line();
            status=repeat_search();
            continue;
         }
         type='proto';
         if (get_text():!=';') {
            type=(ch:=='fu')?'func':'proc';
            gStackEndBelongsTo[gStackEndBelongsTo._length()]='procedure';
         }
         restore_pos(p);
         restore_search(a,b,c,d);
         name=name'('gPackageName:+type')';
         break;
      case 'tr':
         gStackEndBelongsTo[gStackEndBelongsTo._length()]='trigger';
         status=repeat_search();
         name=name'('gPackageName:+'trigger)';
         continue;
      case 'pa':
         body=get_text(match_length('1'),match_length('S1'));
         if (body:!='') {
            status=repeat_search();
            continue;
         }
         gPackageName=name':';
         gStackEndBelongsTo[gStackEndBelongsTo._length()]='package';
         name=name'(package)';
         break;
      case 'de':
         i=gStackEndBelongsTo._length()-1;
         if (i>=0) {
            EndBelongsTo=gStackEndBelongsTo[i];
            if (EndBelongsTo:=='trigger') {
               status=repeat_search();
               continue;
            }
         }
         gStackEndBelongsTo[gStackEndBelongsTo._length()]='declare';
         status=repeat_search();
         continue;
      case '<<':
         name=name'('gPackageName:+'label)';
         break;
      }
      if ( proc_name:=='' ) {
         proc_name=name;
         break;
      }
      if ( proc_name:==name ) {
         break;
      }
      status=repeat_search();
   }
   return(status)
}

/*
    This functions make show_procs smarter by showing user
    all parameters and attributes of the function definition
    but not the code.
*/
void _find_lastprocparam()
{
   save_pos(p);
   startpos=_nrseek();
   status=search("begin","hwixcs");
   if (status) {
      restore_pos(p);
      return;
   }
   orig_col=p_col;
   first_non_blank();
   if (p_col==orig_col) {
      up();
   }
}
#endif
/*
    If DECLARE is inside a block, then 
    DECLARE belongs to itself. Otherwise,
    DECLARE may belong to a trigger.
    
   RETURN
      >0   Column position to place DECLARE keyword
      0    Error/Column position unknown
      -1   Indent to previous statement.
    
*/
int _plsql_find_declare_block_col()
{

   save_pos(orig_pos);

   status=search('begin|trigger|end','h@-riwxcs');
   if (status) {
      restore_pos(orig_pos);
      return(0);
   }
   cw=lowcase(cur_word(junk));
   if (cw!='trigger') {
      // This declare does not belong to anything
      restore_pos(orig_pos);
      return(-1);
   }
   first_non_blank();
   col=p_col;
   restore_pos(orig_pos);
   return(col);
}

/*

   RETURN
      >0   Column position to place BEGIN keyword
      0    Error/Column position unknown
      -1   Indent to previous statement.
*/
int _plsql_find_begin_block_col(boolean skipFirstBegin)
{
   save_pos(orig_pos);

   for (;;) {
      status=search('begin|declare|function|procedure|package|trigger|end','h@-riwxcs');
      if (status) {
         restore_pos(orig_pos);
         return(0);
      }
      cw=lowcase(cur_word(junk));
      //messageNwait('cw='cw' 'skipFirstBegin);
      if (cw=='function' || cw=='procedure') {
         // Check if this is a prototype
         if (_isProtoType()) {
            if (p_col==1) {
               up();_end_line();
            } else {
               left();
            }
            continue;
         }
      }
      if (cw=='begin') {
         if (skipFirstBegin) {
            skipFirstBegin=false;
            if (p_col==1) {
               up();_end_line();
            } else {
               left();
            }
            continue;
         } else {
            // This begin does not belong to anything
            restore_pos(orig_pos);
            return(-1);
         }
      }
      if (cw!='end') {
         first_non_blank();
         col=p_col;
         restore_pos(orig_pos);
         return(col);
      }
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      col=_plsql_find_block_col(block_info,false,false);
      if (!col) {
         restore_pos(orig_pos);
         return(0);
      }
      /*
          We are sitting on a begin for
          a function, procedure or trigger.
          It can't be a declare because you
          can't have a declare inside a declare.
          It can't be a package because you
          can't have a package inside a package.
      */
      status=search('function|procedure|trigger','h@-riwxcs');
      if (status) {
         restore_pos(orig_pos);
         return(0);
      }
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
   }
}

/*

  
  Block constructs
    IF EXPRESSION THEN
    ELSIF expression THEN
    ELSE
    
    END IF;
    
    [<<block_name>>]
    DECLARE
       declarations_statements
    BEGIN
    EXCEPTION
    END block_name;
    
    CREATE [OR REPLACE] TRIGGER mypackage
      AFTER INSERT OR DELETE OR UPDATE ON students 
      [FOR EACH ROW [WHEN trigger condition]]
    DECLARE
    BEGIN
    EXCEPTION
    END [mypackage];  
    
    [CREATE [OR REPLACE]] TRIGGER name {BEFORE|AFTER} event ON table
     [FOR EACH ROW [WHEN trigger_condition]]
    DECLARE 
    BEGIN
    END;
    
    [CREATE [OR REPLACE]] PACKAGE mypackage AS
      FUNCTION a(x IN CHAR) RETURN VARCHAR2;
      PROCEDURE p(a IN CHAR);
    END mypackage;  
    
    
    LOOP
    END LOOP;
    
    FOR expression IN [REVERSE] low_bound..high_bound LOOP
    END LOOP;
    
    WHILE expression LOOP
    END LOOP;
    
    
    
*/
int _plsql_find_block_col(_str &block_info/* currently just block word */,boolean restoreCursor,boolean returnFirstNonBlank)
{
   save_pos(orig_pos);
   int nesting;
   nesting=1;
   status=search('begin|end|package|if|loop','h@-wirxcs');
   //status=search('xxx','@-wirxcs');
   for (;;) {
      if (status) {
         restore_pos(orig_pos);
         return(0);
      }
      word=lowcase(get_text(match_length(),match_length('S')));
      //messageNwait(word);
      switch (word) {
      case 'begin':
         --nesting;
         break;
      case 'if':
         save_pos(orig_p2);
         if (p_col==1) {up();_end_line();} else {left();}
         save_search(p1,p2,p3,p4);
         _clex_skip_blanks('-');
         restore_search(p1,p2,p3,p4);
         if (lowcase(cur_word(junk))=='end') {
            p_col-=2;
            ++nesting;
            break;
         } 
         restore_pos(orig_p2);
         --nesting;
         break;
      case 'package':
         // See if this is 
         /*    
            [CREATE [OR REPLACE]] PACKAGE mypackage AS
            ...
            END
            
               OR 
               
            [CREATE [OR REPLACE]] PACKAGE BODY mypackage AS
            [BEGIN]
            ...
            END
            
            Since packages can't be nested inside
            packages, we are done.
         */
         nesting=0;
         break;
#if 0
         save_pos(orig_p2);
         save_search(p1,p2,p3,p4);
         p_col+=7;
         _clex_skip_blanks();
         if (lowcase(cur_word(junk))=='body') {
            restore_search(p1,p2,p3,p4);
            break;
         }
         restore_pos(orig_pos);
         if (p_col==1) {up();_end_line();} else {left();}
         _clex_skip_blanks('-');
         if (lowcase(cur_word(junk))=='replace') {
            p_col-=6;
            if (p_col==1) {up();_end_line();} else {left();}
            _clex_skip_blanks('-');
            if (lowcase(cur_word(junk))=='or') {
               p_col-=1;
               if (p_col==1) {up();_end_line();} else {left();}
               _clex_skip_blanks('-');
            }
         }
         word=cur_word(junk);
         if (lowcase(word)=='create') {
            p_col-=5;
            --nesting;
         } else {
            restore_pos(orig_p2);
         }
         restore_search(p1,p2,p3,p4);
         break;
#endif
      case 'loop':
         /*
           LOOP
           END LOOP;
           
           FOR expression IN [REVERSE] low_bound..high_bound LOOP
           END LOOP;
           
           WHILE expression LOOP
           END LOOP;
         */
         save_pos(orig_p2);
         if (p_col==1) {up();_end_line();} else {left();}
         save_search(p1,p2,p3,p4);
         _clex_skip_blanks('-');
         restore_search(p1,p2,p3,p4);
         if (lowcase(cur_word(junk))=='end') {
            p_col-=2;
            ++nesting;
            break;
         } 
         ++p_col;
         begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                         false /* Don't skip first begin statement marker */,
                                         false /* Don't return first non-blank */
                                         );
         restore_search(p1,p2,p3,p4);
         //messageNwait('begin_stat_col='begin_stat_col);
         --nesting;
         /*if (lowcase(cur_word(junk))=='loop') {
            restore_pos(orig_p2);
         } */

         break;
      case 'end':
         ++nesting;
         break;
      
      }
      //messageNwait('word='word' nesting='nesting);
      if (nesting<=0) {
         block_info=cur_word(junk);
         if (returnFirstNonBlank) {
            first_non_blank();
         }
         col=p_col;
         if (restoreCursor) {
            restore_pos(orig_pos);
         }
         return(col);
      }
      status=repeat_search();
   }
}

/*

  
  Block constructs
    LOOP
    END LOOP;
    
    IF EXPRESSION THEN
    ELSIF expression THEN
    ELSE
    
    END IF;
    
    [<<block_name>>]
    DECLARE
       declarations_statements
    BEGIN
    EXCEPTION
    END block_name;
    
    CREATE [OR REPLACE] TRIGGER mypackage
      AFTER INSERT OR DELETE OR UPDATE ON students 
      [FOR EACH ROW [WHEN trigger condition]]
    DECLARE
    BEGIN
    EXCEPTION
    END [mypackage];  
    
    CREATE [OR REPLACE] TRIGGER name {BEFORE|AFTER} event ON table
     [FOR EACH ROW [WHEN trigger_condition]]
    DECLARE 
    BEGIN
    END;
    
    CREATE OR REPLACE PACKAGE mypackage AS
      FUNCTION a(x IN CHAR) RETURN VARCHAR2;
      PROCEDURE p(a IN CHAR);
    END mypackage;  
    
    
    FOR expression IN [REVERSE] low_bound..high_bound LOOP
    END LOOP;
    
    WHILE expression LOOP
    END LOOP;
    
    
    
*/
/*

   Return beginning of statement column.  0 if not found.
   
*/
static int plsql_begin_stat_col(boolean RestorePos,boolean SkipFirstHit,boolean ReturnFirstNonBlank,...)
{

   orig_linenum=p_line;orig_col=p_col;
   FailIfNoPrecedingText=(arg(4)!="");
   AlreadyRecursed=(arg(5)!="");
   FailWithMinus1_IfNoTextAfterCursor=(arg(6)!="");
   //ReturnCurColIfCursorBetweenOpenBraceAndEOF=1;
   save_pos(p);
   status=search('[;]|is|as|declare|then|loop|else|begin|elsif|exception','h-RI@xcs');
   nesting=0;
   hit_top=false;
   for (;;) {
      if (status) {
         top();
         hit_top=true;
      } else {
         word=lowcase(get_text(match_length(),match_length('S')));
         if (word!=';' && word!=lowcase(cur_word(junk))) {
            SkipFirstHit=0;
            status=repeat_search();
            continue;
         }
         /*switch (get_text()) {
         case '(':
            FailIfNoPrecedingText=false;
            if (nesting>0) {
               --nesting;
            }
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         case ')':
            FailIfNoPrecedingText=false;
            ++nesting;
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         */
         if (SkipFirstHit || nesting) {
            FailIfNoPrecedingText=false;
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         if (word=='is' || word=='as') {
            // Check if this belongs to a create definition
            save_pos(p2);
            if (p_col==1) {up();_end_line();} else {--p_col;}
            save_search(a1,a2,a3,a4);
            begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                            false /* Don't skip first begin statement marker */,
                                            false /* Don't return first non-blank */
                                            );
            restore_search(a1,a2,a3,a4);
            if (begin_stat_col && 
                (lowcase(cur_word(junk))=='create' ||
                lowcase(cur_word(junk))=='package' ||
                lowcase(cur_word(junk))=='function' ||
                lowcase(cur_word(junk))=='procedure')
                ) {
               restore_pos(p2);
            } else {
               restore_pos(p2);
               status=repeat_search();
               continue;
            }
         }
         p_col+=match_length();
      }
      status=_clex_skip_blanks();
      if (status) {
         restore_pos(p);
         /*
             Would could have an open brace followed by blanks and eof.
         */
         if (!hit_top) {
            if (!FailWithMinus1_IfNoTextAfterCursor) {
               return(p_col);
            }
            return(-1);
         }
         return(0);
      }
      /*
          We could have the following:

            class name:public name2 {

          recurse to look for "case" keyword

      */
      if (ReturnFirstNonBlank) {
         first_non_blank();
      }
      col=p_col;
      if (hit_top && FailIfNoPrecedingText && (p_line>orig_linenum || (p_line==orig_linenum)&& p_col>orig_col)) {
         return(0);
      }
      if (RestorePos) {
         restore_pos(p);
      }
      return(col);
   }
}
static int NoSyntaxIndentCase(int non_blank_col,int orig_linenum,int orig_col,typeless p,int syntax_indent)
{
   //_message_box("This case not handled yet");
   // Smart paste should set the non_blank_col
   if (non_blank_col) {
      //messageNwait("fall through case 1");
      restore_pos(p);
      return(non_blank_col);
   }
   restore_pos(p);
   begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker */,
                                   true  /* return first non-blank */
                                   );

   if (begin_stat_col && (p_line<orig_linenum ||
                          (p_line==orig_linenum && p_col<=orig_col)
                         )
      ) {
#if 0
      /*
          We could have code at the top of a file like the following:

             int myproc(int i)<ENTER>

             int myvar=<ENTER>
             class foo :<ENTER>
                public name2

      */
      //messageNwait("fall through case 2");
      restore_pos(p);
      return(begin_stat_col);
#endif
      /*
         Check if partial statement ends with close paren.  This
         could be a function declaration.

         Another to handle this is to to indent any way and then
         move the open brace to the correct colmun position when
         the users types it.
      */
      save_pos(p2);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanks("-");
      ch=get_text();
      if (ch:==")") {
         restore_pos(p);
         return(begin_stat_col);
      }
      restore_pos(p2);
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()      
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         restore_pos(p);
         return(col);
      }
      nextline_indent=syntax_indent;
      restore_pos(p);
      return(col+nextline_indent);
   }
   restore_pos(p);
   get_line(line);line=expand_tabs(line);
   if (line=="") {
      restore_pos(p);
      return(p_col);
   }
   //messageNwait("fall through case 3");
   first_non_blank();
   col=p_col;
   restore_pos(p);
   return(col);
}
static int HandlePartialStatement(int statdelim_linenum,
                                  int sameline_indent,
                                  int nextline_indent,
                                  int orig_linenum,int orig_col)
{
   orig_ch=get_text();
   save_pos(orig_pos);
   //linenum=p_line;col=p_col;

   /*
       Note that here we don't return first non-blank to handle the
       following case:
       
       for (;
            ;<ENTER>) {
            
       However, this does effect the following unusual case
           if (i<j) {abc;<ENTER>def;
           <end up here which is not correct>
           
       We won't worry about this case because it is unusual.
   */
   begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker. */,
                                   false /* Don't return first non-blank */,
                                   '',
                                   '',
                                   1   // Fail if no text after cursor
                                   );
   if (begin_stat_col>0 && (p_line<orig_linenum || (p_line==orig_linenum && p_col<orig_col))
        /* && (linenum!=p_line || col!=p_col) */
      ) {
      // Now get the first non-blank column.
      begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                      false /* Don't skip first begin statement marker. */,
                                      true /* Return first non-blank */
                                      );
      /*
         Check if partial statement ends with close paren.  This
         could be a function declaration.

         Another to handle this is to to indent any way and then
         move the open brace to the correct colmun position when
         the users types it.
      */
      save_pos(p);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanks("-");
      ch=get_text();
      if (ch:==")") {
         return(begin_stat_col);
      }
      restore_pos(p);
      /*
         IF semicolon is on same line as extra characters

         Example
            {b=<ENTER>
      */
      if (p_line==statdelim_linenum) {
         return(begin_stat_col+sameline_indent);
      }
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()      
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         return(col);
      }
      return(col+nextline_indent);
   }
   return(0);
}
/*
   This code is just here incase we get fancy
*/
int _plsql_indent_col(int non_blank_col)
{
   orig_col=p_col;
   orig_linenum=p_line;
   save_pos(p);
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   syntax_indent=p_SyntaxIndent;
   // IF user does not want syntax indenting
   if ( syntax_indent<=0) {
      // Find non-blank-col
      return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,0));
   }
   //style1=be_style & STYLE1_FLAG;
   //style2=be_style & STYLE2_FLAG;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }

   nesting=0;OpenParenCol=0;
   if (p_col==1) {
      up();_end_line();
   } else {
      left();
   }

   status=search('[;()]|trigger|function|procedure|package|create|declare|is|as|then|loop|else|begin|elsif|exception','h-RI@xcs');
   for (;;) {
      if (status) {
         if (nesting<0) {
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
         return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,syntax_indent));
      }

      ch=get_text();
      switch (ch) {
      case '(':
         if (!nesting && !OpenParenCol) {
            typeless p3;
            save_pos(p3);
            save_search(ss1,ss2,ss3,ss4);
            col=p_col;
            ++p_col;
            status=_clex_skip_blanks();
            if (!status && (p_line<orig_linenum || 
                            (p_line==orig_linenum && p_col<=orig_col)
                           )) {
               col=p_col-1;
            }
            restore_search(ss1,ss2,ss3,ss4);
            OpenParenCol=col;
            restore_pos(p3);
         }
         --nesting;
         status=repeat_search();
         continue;
      case ')':
         ++nesting;
         status=repeat_search();
         continue;
      default:
         if (nesting<0) {
            //messageNwait("nesting case");
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
      }
      if (nesting ) {
         status=repeat_search();
         continue;
      }
      word=get_text(match_length(),match_length('S'));
      if (word!=';' && word!=cur_word(junk)) {
         status=repeat_search();
         continue;
      }
      word=lowcase(word);

      //messageNwait("c_indent_col2: ch="ch);
      switch (word) {
      case ';':
         //messageNwait("case ;");
         save_pos(p2);
         statdelim_linenum=p_line;
         begin_stat_col=plsql_begin_stat_col(false /* RestorePos */,
                                    true /* skip first begin statement marker */,
                                    true /* return first non-blank */
                                    );
         restore_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p);
         return(begin_stat_col);
      case 'then':

         statdelim_linenum=p_line;
         save_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         //p_col+=length(word);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);

         left();   // Don't worry about then in column 1.
         _clex_skip_blanks('-');
         search('IF|WHEN','h-@rwixcs');
         first_non_blank();
         /*  IF expression THEN
         
         */
         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);

      case 'loop':
         //messageNwait('loop');
         statdelim_linenum=p_line;
         save_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         //p_col+=length(word);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);
         /*
           LOOP
           END LOOP;
           
           FOR expression IN [REVERSE] low_bound..high_bound LOOP
           END LOOP;
           
           WHILE expression LOOP
           END LOOP;
         */
         save_pos(orig_p2);
         if (p_col==1) {up();_end_line();} else {left();}
         /*save_search(p1,p2,p3,p4);
         _clex_skip_blanks('-');
         restore_search(p1,p2,p3,p4);
         if (lowcase(cur_word(junk)=='end')) {
            p_col-=2;
            break;
         } */
         begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                         false /* Don't skip first begin statement marker */,
                                         false /* Don't return first non-blank */
                                         );
         //restore_search(p1,p2,p3,p4);
         //messageNwait('begin_stat_col='begin_stat_col);
         /*if (lowcase(cur_word(junk))=='loop') {
            restore_pos(orig_p2);
         } */
         restore_pos(p);
         return(begin_stat_col+syntax_indent);

         break;
      /*
         For the words below, we indent based on the first
         non-blank.
      */
      case 'else':
      case 'elsif':
      case 'begin':
      case 'exception':
         statdelim_linenum=p_line;
         save_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         //p_col+=length(word);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);

         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);
      case 'declare':
      case 'create':
      case 'package':
      case 'function':
      case 'procedure':
      case 'trigger':
         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);
      case 'is':
      case 'as':
         // Check if this belongs to a create definition
         save_pos(p2);
         if (p_col==1) {up();_end_line();} else {--p_col;}
         save_search(a1,a2,a3,a4);
         begin_stat_col=plsql_begin_stat_col(false /* No RestorePos */,
                                         false /* Don't skip first begin statement marker */,
                                         false /* Don't return first non-blank */
                                         );
         restore_search(a1,a2,a3,a4);
         if (begin_stat_col && lowcase(cur_word(junk))=='create') {
            restore_pos(p2);

            statdelim_linenum=p_line;
            // Now check if there are any characters between the
            // beginning of the previous statement and the original
            // cursor position
            //p_col+=length(word);
            col=HandlePartialStatement(statdelim_linenum,
                                       syntax_indent,syntax_indent,
                                       orig_linenum,orig_col);
            if (col) {
               restore_pos(p);
               return(col);
            }

            col=begin_stat_col+syntax_indent;
            restore_pos(p);
            return(col);

         } else {
            restore_pos(p2);
            break;
         }
         
      default:
         _message_box('unknown word='word);
      }
      status=repeat_search();
   }

}
int plsql_smartpaste(boolean char_cbtype,int first_col)
{
   comment_col='';
   //If pasted stuff starts with comment and indent is different than code,
   // do nothing.
   get_line first_line
   i=verify(first_line,' '\t);
   if ( i ) p_col=text_col(first_line,i,'I');
   if ( first_line!='' && _clex_find(0,'g')==CFG_COMMENT) {
      comment_col=p_col;
   }

   comment_col=p_col;
   // Look for first piece of code not in a comment
   status=_clex_skip_blanks('m');
   // IF (no code found AND pasting comment) OR
   //   (code found AND pasting comment AND code col different than comment indent)
   if ((status && comment_col!='') || (!status && comment_col!='' && p_col!=comment_col)) {
      return(0);
   }

   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   syntax_indent=p_SyntaxIndent;
   word=lowcase(cur_word(junk));
   ignore_column1=false;
   if (!status && (word=='end' || word=='elsif' || word=='exception')) {
      save_pos(p2);
      up();_end_line();
      enter_col=_plsql_find_block_col(block_info,true,true);
      restore_pos(p2);
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
   } else if (!status && (word=='else')) {
      //messageNwait('it was an else');
      save_pos(p2);
      up();_end_line();
      enter_col=_plsql_find_block_col(block_info,true,true);
      restore_pos(p2);
      if (enter_col && lowcase(block_info)!='if') {
         enter_col+=syntax_indent;
      }
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
   } else if (!status && (word=='begin')) {
      //messageNwait('it was an else');
      save_pos(p2);
      up();_end_line();
      enter_col=_plsql_find_begin_block_col(false);
      restore_pos(p2);
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
      if (enter_col==-1) {
         _end_line();
         enter_col=plsql_enter_col();
         status=0;
      }
   } else if (!status && (word=='declare')) {
      //messageNwait('it was an else');
      save_pos(p2);
      up();_end_line();
      enter_col=_plsql_find_declare_block_col();
      restore_pos(p2);
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
      if (enter_col==-1) {
         _end_line();
         enter_col=plsql_enter_col();
         status=0;
      }
   } else {
      ignore_column1=true;
      _begin_select;get_line first_line;up();
      _end_line();
      save_pos(p2);
      orig_linenum=p_line;orig_col=p_col;
      // Check if we are pasting into the middle of an SQL or start task statement
      begin_col=plsql_begin_stat_col(false /* No RestorePos */,
                                 false /* Don't skip first begin statement marker */,
                                 false /* Don't return first non-blank */,
                                 1  /* Return 0 if no code before cursor. */,
                                 '',
                                 1
                                 );
      sql_col=0;
      if (begin_col) {
         word2=lowcase(cur_word(junk));
         if (word2!='if' && word2!='while' && word2!='for') {
            statdelim_linenum=p_line;
            sql_col=HandlePartialStatement(statdelim_linenum,
                                       syntax_indent,syntax_indent,
                                       orig_linenum,orig_col);
            // Don't try to past in the middle of a sequal statement.
            if (sql_col) {
               return(0);
            }
         }
      }

      restore_pos(p2);
      enter_col=plsql_enter_col();
      status=0;
   }
   //IF no code found/want to give up OR ... OR want to give up 
   if (status || (enter_col==1 && ignore_column1) || enter_col=='' ||
      (substr(first_line,1,1)!='' && (!char_cbtype ||first_col<=1))) {
      return(0);
   }
   return(enter_col);
}

static _str plsql_enter_col()
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      plsql_enter_col2(enter_col) ) {
      return('');
   }
   return(enter_col);
}


static boolean plsql_enter_col2(int &enter_col)
{
   enter_col=_plsql_indent_col(0);
   return(0);
}
defeventtab plsql_keys
def  'a'-'z','0'-'9','$','_','#'= plsql_maybe_case_word
def  'BACKSPACE'= plsql_maybe_case_backspace
//def ' '=sql_space
//def ENTER=sql_enter*/

static void _maybe_case_word(boolean autocase)
{
   event=event2name(last_event());
   if (command_state()) {
      keyin(event);
      return;
   } else {
      if (p_line==0) {
         return;
      }
   }
   cfg=_clex_find(0,'g');
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || !autocase) {
      keyin(event);
      return;
   }
   keyin(event);
   left();
   cfg=_clex_find(0,'g');
   right();

   if (cfg==CFG_KEYWORD) {
      save_pos(p);
      left();

      NewWord=cur_word(word_pcol);
      if (length(gWord)<length(NewWord) && lowcase(gWord):==lowcase(substr(NewWord,1,length(gWord)))) {
         gWord=gWord:+substr(NewWord,length(gWord)+1);
      } else {
         gWord=NewWord;
      }

      right();
      p_col=_text_colc(word_pcol,'I');
      _delete_text(length(gWord));
      _insert_text(word_case(gWord));
      gWordEndOffset=(int)point('s');
      restore_pos(p);
   } else if (gWordEndOffset+1==point('s')) {
      prev_cmd=name_name(prev_index('','C'));
      if (pos('maybe-case-word',prev_cmd)==0 && 
          pos('maybe-case-backspace',prev_cmd)==0) {
         return;
      }
      // Put the original word back
      p_col-=length(gWord)+1;
      _delete_text(length(gWord)+1);
      _insert_text(gWord:+event);
      gWordEndOffset= -1;gWord="";
   } else {
      gWordEndOffset= -1;gWord="";
   }
}
//Returns 0 if the letter wasn't upcased, otherwise 1
_command void plsql_maybe_case_word() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   _maybe_case_word(def_plsql_autocase);
}
static void _maybe_case_backspace(boolean autocase)
{
   event=event2name(last_event());
   if (command_state()) {
      call_root_key(BACKSPACE);
      return;
   } 
   if (p_line==0) {
      return;
   }
   prev_cmd=name_name(prev_index('','C'));
   i=last_index('','C');
   call_root_key(BACKSPACE);
   last_index(i,'C');
   if (p_col==1) {
      return;
   }
   cfg=_clex_find(0,'g');
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || !autocase) {
      return;
   }
   left();cfg=_clex_find(0,'g');right();
   if (cfg==CFG_KEYWORD) {
      save_pos(p);

      NewWord=cur_word(word_pcol);
      if (length(NewWord)<length(gWord) && lowcase(NewWord):==lowcase(substr(gWord,1,length(NewWord)))) {
         gWord=substr(gWord,1,length(NewWord));
      } else {
         gWord=NewWord;
      }

      p_col=_text_colc(word_pcol,'I');
      _delete_text(length(gWord));
      _insert_text(word_case(gWord));
      gWordEndOffset=(int)point('s');
      restore_pos(p);
   } else if (gWordEndOffset-1==point('s') && length(gWord)>1) {
      if (pos('maybe-case-word',prev_cmd)==0 && 
          pos('maybe-case-backspace',prev_cmd)==0) {
         return;
      }
      // Put the original word back
      p_col-=length(gWord)-1;
      _delete_text(length(gWord)-1);
      _insert_text(substr(gWord,1,length(gWord)-1));
   } else {
      gWordEndOffset= -1;gWord="";
   }
}

_command void plsql_maybe_case_backspace() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _maybe_case_backspace(def_plsql_autocase);
}

defeventtab _plsql_extform

void _lowcase.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void _upcase.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void _capitalize.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void ctlnone.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
_ok.on_create()
{
   parse p_active_form.p_name with '_' ext '_extform';
   index = find_index('def-options-'ext, MISC_TYPE);
   if (!index) {
      return('');
   }
   info = name_info(index);
   parse info with rem1 rem2 minexpkwdlen scase .;
   _minimum.p_text=minexpkwdlen;
   //messageNwait('before comments comment:'comment' ic:'indentcase);
    index=find_index('def_'ext'_smartpaste',VAR_TYPE);
   _smartp.p_value=_get_var(index);
   _minimum.p_text = minexpkwdlen;
   switch (scase) {
   case -1:ctlnone.p_value = 1;break;
   case 0:_lower.p_value = 1;break;
   case 1:_upper.p_value = 1;break;
   case 2:_capitalize.p_value = 1;break;
   }
   acindex=find_index('def_'ext'_autocase',VAR_TYPE);
   ctlautocase.p_value=(int)_get_var(acindex);
}
_ok.lbutton_up()
{
   parse p_active_form.p_name with '_' ext '_extform';
   index = find_index('def-options-'ext, MISC_TYPE);
   info = name_info(index);
   parse info with p1 p2 p3 . rest;

   if (_lower.p_value) {//THESE CONTROLS
      kw_case= 0;
   }else if(_upper.p_value) {
      kw_case= 1;
   } else if (_capitalize.p_value) {
      kw_case= 2;
   }else{
      kw_case= -1;
   }

   spindex=find_index('def_'ext'_smartpaste',VAR_TYPE);
   if (_smartp.p_value&&_smartp.p_enabled) {
      _set_var(spindex,1);
   }else{
      _set_var(spindex,0);
   }

   info = p1' 'p2' '_minimum.p_text' 'kw_case' 'rest;
   acindex=find_index('def_'ext'_autocase',VAR_TYPE);
   _set_var(acindex,(ctlautocase.p_value!=0));
   _setext(ext, 'options', info);

   p_active_form._delete_window(0);
}

/* Desc: Find the matching begin/end.
   
   Supported combinations:
      begin -- end XXXX
      loop -- end XXXX
      package -- end XXXX
   
   Example:
      procedure calc1 is
      begin                 <-------+
         for month in 1..12         |                
         loop             <-------+ |  
            calc2(month);         | |   
            calc2(month);         | |   
         end loop;        <-------+ |
      end;                  <-------+
      
      
      while inrange(currentrow) loop  <--------+
         begin                      <------+   |
            asdfasdkflka;                  |   |
         exception                         |   |
            when nodatafound then          |   |
               withinthreshold := 1;       |   |
         end;                       <------+   |
      end loop;                       <--------+
*/
int _plsql_find_matching_word()
{
   //say("_plsql_find_matching_word");
   typeless ori_position;
   save_pos(ori_position);

   // Get current word at cursor:
   _str word;
   word = getCurrentWord();
   if (word == "") {
      restore_pos(ori_position);
      message(nls('Not on begin/end or word pair'));
      return(1);
   }
   word = lowcase(word);

   // Only some words have matching words. Find the actual word
   // to match and the expected word to match.
   /* Ex:
         begin
            helloThere;
         end calc2;
             ^^^^^
             
         In this example, the caret is over "calc2". The actual
         word to match is "end" and the expected word to match
         is "begin".
   */
   int status;
   _str matchingWord;
   _str direction;
   status = correspondingMatchingWord(word, matchingWord, direction);
   if (status) {
      restore_pos(ori_position);
      message(nls('Not on begin/end or word pair'));
      return(1);
   }

   // Find the matching word:
   status = matchWord(word);
   if (!status) {
      restore_pos(ori_position);
      message(nls('Matching word not found'));
      return(1);
   }
   return(0);
}

// Desc: Return the expected matching word for specified word.
// Retn: 0 has expected matching, 1 no expected matching word
static int correspondingMatchingWord(_str & word, _str & matchingWord
                                     ,_str & direction)
{
   if (word == "begin") {
      matchingWord = "end";
      direction = "";
   } else if (word == "end") {
      /*
      // Ignore special "end" that does not map to a block.
      //    "end if"
      _str nextWord;
      nextWord = getNextWord();
      nextWord = lowcase(nextWord);
      if (nextWord == "if") {
         return(1);
      }
      */
      matchingWord = "begin|loop|package|if";
      direction = "-";
   } else if (word == "loop") {
      // Look at the previous word to determine if this is the
      // start or the end of a loop block.
      _str prevWord;
      if (matchPreviousWord("end",1)) {  // ending of loop
         word = "end"
         matchingWord = "begin|loop";
         direction = "-";
      } else {                           // starting of loop
         matchingWord = "end";
         direction = "";
      }
   } else if (word == "package") {
      matchingWord = "end";
      direction = "";
   } else if (word == "if") {
      if (matchPreviousWord("end",1)) {  // part of "end if"
         word = "end"
         matchingWord = "if";
         direction = "-";
      } else {
         matchingWord = "end";
         direction = "";
      }
   } else {
      // Look at the previous word to determine if this is the
      // start or the end of a loop block.
      /* Ex:
            begin
               open site;
               fetch site into siteinfo;
               close site;
            end proc1;
                ^^^^^
      */
      _str prevWord;
      if (matchPreviousWord("end",1)) {
         /*
         // Ignore special "end" that does not map to a block.
         //    "end if"
         _str nextWord;
         nextWord = getNextWord();
         nextWord = lowcase(nextWord);
         if (nextWord == "if") {
            return(1);
         }
         */
         word = "end"
         matchingWord = "begin|loop|package|if";
         direction = "-";
      } else {
         return(1);
      }
   }
   return(0);
}

// Desc: Match the word
// Retn: 1 for word matched, 0 not
static int matchWord(_str word)
{
   // Match word forward:
   int level;
   level = 0;
   int status;
   if (word == "begin" || word == "loop" || word == "package" || word == "if") {
      // Special case for "package":
      // If "package" is immediately followed by "body", there can be
      // a "body" for the package. If we see this "body", we need to skip
      // over it.
      int mayhavebegin;
      mayhavebegin = 0;
      if (word == "package") {
         _str nextword;
         nextword = lowcase(getNextWord());
         if (nextword == "body") {
            mayhavebegin = 1;
         }
      }

      while (1) {
         // Skip over the current word:
         status = search(" |[~A-Za-z0-9_]|$", "r@XCS");
         if (status) {
            return(0);
         }

         // Search for next block key word:
         //messageNwait("h1");
         status = search("begin|loop|end|package|if|function|procedure", "rw@iCK");
         //messageNwait("h2");
         if (status) {
            return(0);
         }

         // For proc headers (function and procedure), skip over proto.
         // If not proto, find the matching "begin" and skip to the matching
         // "end".
         _str ch;
         ch = lowcase(get_text(8));
         if (ch == "function" || ch == "procedur") {
            if (isProcFuncProto()) continue;
            skipOverProcFunc();
            continue;
         }

         // Check new block keyword. If keyword indicates a new
         // block, increase the nesting level. Otherwise, decrease
         // the nesting level. If current nesting level is 0, we've
         // found the matching word.
         current = getCurrentWord();
         current = lowcase(current);
         if (current == "begin") {
            if (mayhavebegin && !level) {
               // Do nothing...
               mayhavebegin = 0;
            } else  {
               level++;
            }
         } else if (current == "loop") {
            // Look at the previous word to determine if this is the
            // start or the end of a loop block.
            if (!matchPreviousWord("end",0)) {
               // Found start of new loop block.
               level++;
            }
         } else if (current == "package") {
            level++;
         } else if (current == "if") {
            if (matchPreviousWord("end",0)) {
               continue;
            }
            level++;
         } else { // "end" case
            /*
            // Ignore special "end" that does not map to a block.
            //    "end if"
            _str nextWord;
            nextWord = getNextWord();
            nextWord = lowcase(nextWord);
            if (nextWord == "if") {
               continue;
            }
            */
            if (!level) {
               return(1);
            }
            level--;
         }
      }
   }

   // Match word backward:
   while (1) {
      // Skip backward over the current word:
      status = search(" |[~A-Za-z0-9_]|$", "-r@XCS");
      if (status) {
         //messageNwait("exit h1");
         return(0);
      }

      // Search for next block key word:
      status = search("begin|loop|end|package|if", "-rw@iXCS");
      if (status) {
         //messageNwait("exit h2");
         return(0);
      }
      //messageNwait("h1 level="level);

      // Check new block keyword. If keyword indicates a new
      // block, increase the nesting level. Otherwise, decrease
      // the nesting level. If current nesting level is 0, we've
      // found the matching word.
      current = getCurrentWord();
      current = lowcase(current);
      if (current == "begin" || current == "package") {
         if (!level) {
            return(1);
         }
         level--;
      } else if (current == "if") {
         // Ignore special "if" that is part of "end if".
         if (matchPreviousWord("end",1)) {
            level++;
         } else {
            if (!level) {
               return(1);
            }
            level--;
         }
      } else if (current == "loop") {
         // Look at the previous word to determine if this is the
         // start or the end of a loop block.
         if (matchPreviousWord("end",1)) {
            // Found end of new loop block.
            level++;
         } else {
            // Found start of loop block.
            if (!level) {
               return(1);
            }
            level--;
         }
      } else { // "end" case
         /*
         // Ignore special "end" that does not map to a block.
         //    "end if"
         _str nextWord;
         nextWord = getNextWord();
         nextWord = lowcase(nextWord);
         if (nextWord == "if") {
            continue;
         }
         */
         level++;
      }
   }
   return(0);
}

// Desc: Get the current word at the cursor.
// Retn: word or ""
static _str getCurrentWord()
{
   // Get current word at cursor:
   int startCol;
   status = search(" |[~A-Za-z0-9_]|$", "r@XCS");
   if (status) {
      return("");
   }
   //say("p_line="p_line" p_col="p_col);
   int endSeek;
   endSeek = _nrseek();
   _nrseek(endSeek - 1);
   status = search(" |[~A-Za-z0-9_]|^", "-r@XCS");
   if (status) {
      return("");
   }
   ch = get_text();
   if (!isalnum(ch) && ch != "_") {
      _nrseek(_nrseek() + 1);
   }
   int startSeek;
   startSeek = _nrseek();
   _str word;
   word = get_text(endSeek - startSeek);
   return(word);
}

// Desc: Get the next word. The caret is not moved.
// Retn: next word, "" for none.
static _str getNextWord()
{
   int oldseekpos;
   oldseekpos = _nrseek();

   int status;
   status = search(" |[~A-Za-z0-9_]", "r@XCS");
   if (status) {
      _nrseek(oldseekpos);
      return("");
   }
   ch = get_text();
   if (ch != " " && !isalnum(ch)) {
      _nrseek(oldseekpos);
      return(ch);
   }
   status = search(":a", "r@XCS");
   if (status) {
      _nrseek(oldseekpos);
      return("");
   }
   _str current;
   current = getCurrentWord();
   _nrseek(oldseekpos);
   return(current);
}

// Desc: Match the previous word with the specified key.
// Ex:
//    end if;               ==> previous word is "end"
//    end loop;             ==> previous word is "end"
//    end someLabelHere;    ==> previous word is "end"
//
//    end; if               ==> previous word is ";"
//
// Retn: 1 for previous word matched, 0 not
static int matchPreviousWord(_str key, int moveCaret)
{
   int oldseekpos;
   oldseekpos = _nrseek();

   // Make sure caret is over a word:
   _str ch;
   ch = get_text();
   if (!isalnum(ch) && ch != "_") {
      _nrseek(oldseekpos);
      return(0);
   }

   // Locate the white space preceeding this word:
   int status;
   status = search("[~A-Za-z0-9_]","-r@iXCS");
   if (status) {
      _nrseek(oldseekpos);
      return(0);
   }
   // Skip over the white spaces preceeding this word:
   status = search("[~ \t]","-r@iXCS");
   if (status) {
      _nrseek(oldseekpos);
      return(0);
   }

   // Make sure that we are at the end of a word:
   ch = get_text();
   if (!isalnum(ch) && ch != "_") {
      _nrseek(oldseekpos);
      return(0);
   }

   // Get the word for the comparison:
   _str word;
   word = getCurrentWord();
   word = lowcase(word);
   //say("matchPreviousWord word="word);
   if (word == key) {
      if (!moveCaret) _nrseek(oldseekpos);
      return(1);
   }

   _nrseek(oldseekpos);
   return(0);
}

// Desc: Check to see if the procedure/function statement is a prototype.
// Retn: 1 for proto, 0 not
static int isProcFuncProto()
{
   int oldseekpos;
   oldseekpos = _nrseek();
   while (1) {
      int status;
      status = search("as|is|begin|end|;","r@iXCS");  // can't use 'w' in RE because ';'
      if (status) {
         _nrseek(oldseekpos);
         return(0);
      }
      if (get_text() == ";") {
         // Found ';' before any of the block start keywords.
         return(1);
      }
      status = _clex_find(KEYWORD_CLEXFLAG, "G");
      if (status != CFG_KEYWORD) {
         _nrseek(_nrseek() + 1);
         continue;
      }
   
      // Not a proto... Restore original position.
      _nrseek(oldseekpos);
      return(0);
   }
   _nrseek(oldseekpos);
   return(0);
}

// Desc: Skip over function.
static void skipOverProcFunc()
{
   int oldseekpos;
   oldseekpos = _nrseek();

   // Locate the "begin":
   int status;
   status = search("begin","rw@iCK");
   if (status) {
      _nrseek(oldseekpos);
      return;
   }

   // Recurse back to matchWord() to skip over begin/end pair:
   status = matchWord("begin");
   if (!status) {
      _nrseek(oldseekpos);
      return;
   }

   // Skip over the optional "end" label:
   skipToSemicolon();
}


// Desc:  Go to next semicolon.
// Retn:  0 for OK, 1 for error.
static typeless skipToSemicolon()
{
   int oldseekpos;
   oldseekpos = _nrseek();

   while (1) {
      int status;
      status = search("[(;]","r@iXCS");
      if (status) {
         _nrseek(oldseekpos);
         return(1);
      }
      _str ch;
      ch = get_text();
      if (ch == "(") {
         _find_matching_paren(def_pmatch_max_diff);
         continue;
      }

      // Found ';'...
      return(0);
   }
   return(0);
}
