/*
$VerboseHistory: tagform.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:17a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:16a
 * Comment:
 * Change message box to display question mark icon.
 * Added support for Explorer style open dialog.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:27p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

#if __UNIX__
   #define  C_WILDCARDS   "*.c;*.cxx;*.cpp;*.h;*.hpp"
   #define  JAR_WILDCARDS "*.class;*.jar;*.zip"
#else
   #define  C_WILDCARDS   "*.c;*.cxx;*.cpp;*.h;*.hpp;*.inl"
   #define  JAR_WILDCARDS "*.class;*.jar;*.zip"
#endif
#define EXTRA_FILE_FILTERS  "ZIP Files (*.zip),JAR Files (*.jar),Java Class Files (*.class)"

defeventtab _tag_form
void ctlAutoTag.lbutton_up()
{
   status=shell('autotag');
   if (status!=COMMAND_CANCELLED_RC) {
      // Delete all items in the tree
      tree1._TreeDelete(TREE_ROOT_INDEX,'c');
      ctldone.call_event(ctldone,ON_CREATE);
   }
}

#define TAG_FOLDER_INDEXES ctlfiles.p_user
//This is the indexes of the two folders in the format:
//ProjectFolderIndex' 'GlobalFolderIndex
#define SKIP_ON_CHANGE tree1.p_user
//SKIP_ON_CHANGE is used if we move a tree item up or down and really don't need
//the on change event.
#define TreeIsEmpty(a) (a._TreeGetFirstChildIndex(TREE_ROOT_INDEX)<0)
#define FOLDER_DEPTH 1
#define FILE_DEPTH   2


//############################################################################
//////////////////////////////////////////////////////////////////////////////
// Load the filenames from the given tag file into the list control.
//    -- tag_filename  -- name of file to create
// The current object must be a list box control, tree control,
// editor control, or combo box control.
// Returns the number of files inserted >=0, or error code <0.
//
static int LoadFileNameList(_str tag_filename)
{
   // open the database for business
   int status = tag_read_db(tag_filename);
   if (status) {
      return status;
   }

   // get the files from the database
   tag_get_detail(VS_TAGDETAIL_num_files, num_files);
   status=tag_find_file(filename);
   while (!status) {
      switch (p_object) {
      case OI_COMBO_BOX:
         p_cb_list_box._lbadd_item(filename);
         break;
      case OI_TREE_VIEW:
         _TreeAddItem(TREE_ROOT_INDEX, filename, TREE_ADD_AS_CHILD,
                      _pic_file, _pic_file, -1);
         break;
      case OI_FORM:
         insert_line(filename);
         break;
      case OI_LIST_BOX:
         _lbadd_item(filename);
         break;
      }
      if (p_line % 100 == 0) {
         message(nls('Added %s/%s filenames to list',p_line,num_files));
      }
      status=tag_next_file(filename);
   }

   // maybe print final progress message and then sort the list
   if (num_files > 100) {
      message(nls('Sorting %s/%s filenames in list',num_files,num_files));
   }
   switch (p_object) {
   case OI_COMBO_BOX:
      p_cb_list_box._lbsort('-f');
      p_cb_list_box._lbtop();
      break;
   case OI_TREE_VIEW:
      _TreeSortCaption(TREE_ROOT_INDEX,'F');
      _TreeTop();
      break;
   case OI_FORM:
      //don't sort in this case, to save time for large lists
      //sort_buffer('-f');
      top();up();
      break;
   case OI_LIST_BOX:
      _lbsort('-f');
      _lbtop();
      break;
   }

   // clear the messages and return the number of files inserted
   clear_message();
   return num_files;
}

//////////////////////////////////////////////////////////////////////////////
// Retag files listed in the current view.  The view is normally created
// using _create_temp_view.
//    tag_filename    -- name of tag file to retag.
//    extension       -- 
//    rebuild_all     -- rebuild all tags, not just files that are out of date
//    retag_refs      -- retag reference files (false implies source files)
// Reports (via message box) if there were problems writing the tag file,
// or if there were any files not tagged successfully.
// Returns 0 on success or <0 on error.
//
static int RetagFilesInView(_str tag_filename, //_str extension='',
                            boolean rebuild_all=false, 
                            boolean retag_refs=false,
                            boolean doRemove=false,
                            boolean RemoveWithoutPrompting=false,
                            boolean RemoveFromProject=false,
                            boolean quiet=false
                            )
{
   _str filename, tagging_message;
   int temp_view_id, filelist_view_id;
   int num_files = p_Noflines;
   int not_tagged_count = 0;
   _str not_tagged_list = '';
   boolean not_tagged_more = false;
   top(); up();
   get_view_id(orig_view_id);
   boolean UpdateProjectFilesSection=false;
   if (RemoveFromProject) {
      status=_ini_get_section(_project_name,"FILES",project_files_view_id);
      if (status) {
         _create_temp_view(projects_files_view_id);
      }
   }
   activate_view(orig_view_id);
   while (!down()) {
      get_line(filename);
      filename=strip(filename/*,'L'*/);
      if (filename=='') continue;
      int current_line = p_line;
      message('Tagging 'p_line'/'num_files': 'filename);
      if (retag_refs) {
         RetagReferencesFile(filename);
         continue;
      }
      // open view of file, try for a buffer first
      
      temp_view_id=0;
      _str fdate="";
      parse buf_match(filename,1,'vhx') with buf_id .;
      if (buf_id!="") {
         fdate=_BufDate(buf_id);
      } else {
         if (!rebuild_all && doRemove) {
            fdate=_file_date(filename,'b');
         } else {
            fdate=1;
         }
      }
	
      boolean doRemove2=false;
      // file opened cleanly, so retag file and quit view
      if (fdate:!="") {
         boolean doRetag=false;
         // check date on disk, if same as last tagged, skip file
         if (!rebuild_all) {
            _str disk_date=fdate;
            _str tagged_date;
            int date_status=tag_get_date(filename,tagged_date);
            if (!doRemove && !date_status) {
               fdate=tagged_date;
            }
            if (date_status || fdate!=tagged_date) {
               doRetag=true;
            } else {
               //say("avoiding retag of: "filename);
            }
         } else {
            //say("forced tagging of: "filename);
            doRetag=true;
         }
         if (doRetag) {
            boolean inmem=true;
            int status=_open_temp_view(filename,temp_view_id,filelist_view_id,'+b');
            if (status) {
               inmem=false;

               status=_open_temp_view(filename,temp_view_id,filelist_view_id);
               if (!status) select_edit_mode();
            }
            if (status) {
               doRemove2=true;
            } else {
               RetagCurrentFile();
               // close the temporary view
               if (inmem) {
                  p_buf_flags&=~HIDE_BUFFER;
                  _quit_view();
                  p_view_id=filelist_view_id;
               }else{
                  p_view_id=filelist_view_id;
                  _delete_temp_view(temp_view_id);
               }
            }
         }
      } else {
         doRemove2=true;
      }
      if (doRemove2) {
         ext=_bufname2ext(filename);
         index=find_index(ext'-proc-search',PROC_TYPE);
         if (index) {  // Don't worry about index_callable
            not_tagged_count++;
            if (not_tagged_list == '') {
               not_tagged_list = filename;
            } else if (length(not_tagged_list) < 1000) {
               strappend(not_tagged_list, ', 'filename);
            } else {
               not_tagged_more = true;
            }
            p_view_id=orig_view_id;
            // if the source file was not found, remove all tags associated with it
            if (doRemove) {
               boolean removeFile=false;
               if (RemoveWithoutPrompting) {
                  removeFile=true;
               } else {
                  if (!quiet) {
                     if (RemoveFromProject) {
                        msg = nls("%s\nno longer exists.\n\nRemove file from project?",filename);
                        answer= show("-modal _yesToAll_form", msg, "Remove File From Project");
                     } else {
                        msg = nls("%s\nno longer exists.\n\nRemove file from tag file?",filename);
                        answer= show("-modal _yesToAll_form", msg, "Remove File From Tag File");
                     }
                  }
                  tag_open_db(tag_filename);
                  if (answer == "CANCEL") {
                     break;
                  } else if (answer == "YES") {
                     removeFile=true;
                  } else if (answer == "YESTOALL") {
                     removeFile=true;
                     RemoveWithoutPrompting= true;
                  }
               }
               if (removeFile) {
                  tag_remove_from_file(filename,1);
                  if (RemoveFromProject) {
                     get_view_id(orig_view_id);
                     activate_view(project_files_view_id);
                     top();
                     status=search('^'_escape_re_chars(filename)'$','@r'_fpos_case);
                     if (!status) {
                        _delete_line();
                        UpdateProjectFilesSection=true;
                     }
                     activate_view(orig_view_id);
                  }
               } else {
                  tag_remove_from_file(filename);
               }
            } else {
               tag_remove_from_file(filename);
            }
         }
      }
   }
   if (UpdateProjectFilesSection) {
      get_view_id(orig_view_id);
      _ini_put_section(_project_name,"FILES",project_files_view_id);
      activate_view(orig_view_id);
   }

   // report if any files not found or tagged
   if (!quiet && not_tagged_count > 0) {
      if (not_tagged_more) {
         strappend(not_tagged_list, ', ...');
      }
      _message_box(nls("%s files were not tagged:\n\n%s",
                       not_tagged_count,not_tagged_list));
   }

   // that's all folks
   return 0;
}

//////////////////////////////////////////////////////////////////////////////
// Opens or creates a tag database, depending on if the given database
// existed before.
//    tag_filename  -- the tag file to open or create
//    force_create  -- force the database to be recreated, not just opened
//    database_type -- type of database to create
// Returns the status of the operation.  The file is left open for
// read-write after this function is called.  This function also works
// if 'tag_filename' does not exist.
// 
int _OpenOrCreateTagFile(_str tag_filename, boolean force_create=false,
                               int database_type=VS_DBTYPE_tags)
{
   // try to open the database for read/write
   int status=tag_open_db(tag_filename);
   if (status==FILE_NOT_FOUND_RC || force_create) {
      // need to re-create database, preserve database description
      _str descr = '';
      if (!status) {
         descr = tag_get_db_comment();
      }
      tag_close_db(tag_filename);
      delete_file(tag_filename);
      // create the new database and set description
      int cstatus=tag_create_db(tag_filename,database_type);
      if (cstatus) {
         _message_box(nls("Could not create tags database %s.\n%s",tag_filename,get_message(cstatus)));
         return cstatus;
      }
      tag_set_db_comment(descr);
      tag_close_db(tag_filename, 1);
      // inform the world about the new database
      if (status==FILE_NOT_FOUND_RC) {
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      }
      return tag_open_db(tag_filename);
   } else if (status) {
      // trouble
      _message_box(nls("Could not open tag file %s.\n%s",tag_filename,get_message(status)));
      return(status);
   }
   // success!
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
// Retag all the files in the given file list view for the given tag file
//    tag_filename  -- name of tag file to open or create
//    orig_view_id  -- view to revert back to after finished tagging files
//    list_view_id  -- view containing list of source files to tag
//    rebuild_all   -- rebuild all files or just recently modified files?
//    retag_refs    -- is this a references database?
// Returns 0 on success, <0 on error.
//
static int RetagFilesInTagFile2(_str tag_filename,
                               int orig_view_id, 
                               int list_view_id,
                               boolean rebuild_all,
                               boolean retag_refs,
                               boolean doRemove=false,
                               boolean RemoveWithoutPrompting=false,
                               boolean RemoveFromProject=false,
                               boolean quiet=false)
{
   // If rebuilding the entire database, force a tag_create_db to occur
   // otherwise, just open the file for write, create it if it doesn't exist
   int database_type = (retag_refs)? VS_DBTYPE_references : VS_DBTYPE_tags;
   int status = _OpenOrCreateTagFile(tag_filename,rebuild_all,database_type);
   if (status) {
      return(status);
   }

   // Retag all the files in the view
   activate_view(list_view_id);
   status = RetagFilesInView(tag_filename, rebuild_all, retag_refs,doRemove,RemoveWithoutPrompting,RemoveFromProject,quiet);

   // blow away the file list temp view
   p_view_id = orig_view_id;
   _delete_temp_view(list_view_id);

   // close the database and check that it was clean
   status = tag_close_db(tag_filename, 1/*leave it open for read*/);
   if (!quiet && status) {
      _message_box(nls("Error closing tags database %s.\n%s",tag_filename,get_message(status)));
   }
   _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tag_filename);
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);

   // report if any files not found or tagged
   // we are done
   clear_message();
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
// This function converts a 2.0 format tag file to the new tag database
// format (3.0 and beyond).  It does so by first parsing through the file
// and collecting the filenames and paths in the file, putting those
// into a temporary view, then creating a new tag file, and feeding
// the list of files to RetagFilesInView(), above.
//    -- OldTagFilename  -- the original tag filename (something.slk)
//    -- NewTagFilename  -- the new tag filename (something.vtg)
// Returns <0 on error, 0 on success.
//
int RebuildOldTagFile(_str OldTagFilename,_str NewTagFilename,boolean quiet=false)
{
   // check if the new tag file exists already.
   NewTagFilename=absolute(NewTagFilename);
   int status=tag_read_db(NewTagFilename);
   if (!status) {
      //Just assume that this one is ok....
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      return(0);
   }

   // open the old tag file
   int temp_view_id, orig_view_id;
   status=_open_temp_view(OldTagFilename,temp_view_id,orig_view_id,'+l');
   if (status) {
      if (status==NEW_FILE_RC) {
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }
      return(status);
   }

   // keep track of where focus was
   int orig_focus_wid=0;
   if (_no_child_windows()) {
      orig_focus_wid=_cmdline;
   }
   if (!quiet) {
      // warn about converting the file
      _message_box("About to convert old tag file "OldTagFilename".\nThis may take a minute.");
   }
   if (orig_focus_wid==_cmdline) {
      _cmdline.p_visible=0;
   }

   // create the new tag database
   mou_hour_glass(1);
   delete_file(NewTagFilename);    
   status=tag_create_db(NewTagFilename);
   if (status) {
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      if (orig_focus_wid==_cmdline) {
         _cmdline.p_visible=1;
      }
      if (!quiet) {
         _message_box(nls("Could not create tags database %s.\n%s",NewTagFilename,get_message(status)));
      }
      mou_hour_glass(0);
      return(status);
   }

   // create the path table
   _str PathTable[];
   PathTable._makeempty();
   p_line=0;
   while (!down()) {
      get_line(line);
      if (pos('%',line)) break;
      PathTable[p_line]=line;
   }
   up();

   // parse through the file and create the list of filenames
   int NoExistList:[];
   NoExistList._makeempty();
   CorruptTagFile=false;
   while (!down()) {
      get_line(line);
      parse line with ./*TagName*/ PathIndex'%'filename;
      // IF this is just a corrupt tag file
      if (!isinteger(PathIndex)) {
         CorruptTagFile=true;
         break;
      }
      _str WholeFilename=PathTable[PathIndex]:+filename;
      _str date='';
      status=tag_get_date(WholeFilename,date);
      if (status) {
         //If we do not get a status, we tagged the file already.
         if (!(NoExistList._indexin(WholeFilename))) {
            status=_open_temp_view(WholeFilename,source_view_id,junk_view_id,'+b');
            if (status) {
               status=_open_temp_view(WholeFilename,source_view_id,junk_view_id);
               if (!status) select_edit_mode();
            }
            //status=_open_temp_view(WholeFilename,source_view_id,junk_view_id);
            if (!status) {
               message('Tagging 'WholeFilename);
               RetagCurrentFile();
               p_view_id=temp_view_id;
               _delete_temp_view(source_view_id);
            }else{
               // just to add the filename to the list
               tag_set_date(WholeFilename);
               NoExistList:[WholeFilename]=1;
            }
         }
      }
   }

   // close the old tag file and the new tag file
   _delete_temp_view(temp_view_id)
   p_view_id=orig_view_id;
   status=tag_close_db(NewTagFilename,1);
   _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);

   if (CorruptTagFile) {
      if (!quiet) {
         _message_box(nls("Tag file %s is corrupt.  You will have to recreate this tag file",OldTagFilename));
      }
   } else {
      // create a new view for the list of not-tagged files
      orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=temp_view_id;
      for (i._makeempty();;) {
         NoExistList._nextel(i);
         if (i._isempty()) break;
         insert_line(' 'i);
      }
      ShowDialog=p_Noflines
      p_view_id=orig_view_id;

      // warn the user about files that were not tagged
      if (ShowDialog) {
         if (!quiet) {
            result=p_active_form.show('-modal _sellist_form',
                             'The following files could not be found',
                             SL_VIEWID, // flags
                             temp_view_id);
         }
      }else{
         _delete_temp_view(temp_view_id);
      }
   }

   // that's all folks.
   clear_message();
   mou_hour_glass(0);
   if (orig_focus_wid==_cmdline) {
      _cmdline.p_visible=1;
   }
   return(status);
}

//////////////////////////////////////////////////////////////////////////////
// Check if 'Path' is a relative path or absolute path
//
static boolean IsRelative(_str Path)
{
   return(!file_eq(Path,absolute(Path)));
}

//////////////////////////////////////////////////////////////////////////////
// Insert the given list of tag files into the tag form tree at 'index'
//
static void AddTagFiles(int index,_str TagFileList)
{
   int flags=TREE_ADD_AS_CHILD;
   _str AddedList='';
   for (;;) {
      _str CurTagFilename=next_tag_file2(TagFileList,false/*no check*/,false/*no open*/);
      if (CurTagFilename=='') break;
      _str CurTagDescription='';
      if (!pos(' 'CurTagFilename' ',AddedList,'',_fpos_case)) {
         //10:14am 9/19/1997
         //This absolute is really important.  Without it, the file will not
         //get closed properly if the tag file is relative!!!!!
         status=tag_read_db(absolute(CurTagFilename));
         if (status==BT_INCORRECT_MAGIC_RC || status==ERROR_READING_FILE_RC) {
            //Invalid magic number...We assume that it is an old tag file
            NewTagFilename=strip_filename(CurTagFilename,'E'):+TAG_FILE_EXT;
            status=RebuildOldTagFile(CurTagFilename,NewTagFilename);
            if (status) {
               _message_box(nls("Could not rebuild old tags database %s.\n%s",CurTagFilename,get_message(status)));
               continue;
            }
            CurTagFilename=NewTagFilename;
         }else if (status==FILE_NOT_FOUND_RC) {
            ext=get_extension(CurTagFilename);
            if (!file_eq('.'ext,TAG_FILE_EXT)) {
               return;
            }
         }else if (status) {
            return;
         }else{
            // get tag file description
            CurTagDescription = tag_get_db_comment();
            //10:14am 9/19/1997
            //This absolute is really important.  Without it, the file will not
            //get closed properly if the tag file is relative!!!!!
            tag_close_db(absolute(CurTagFilename),1);
         }
         CurTagFilename=strip(CurTagFilename,'B','"');
         if (IsRelative(CurTagFilename)) {
            //This is to convert things like './tags.slk'
            CurTagFilename=strip_filename(absolute(CurTagFilename),'P');
            CurTagFilename=CurTagFilename:+RelativeFilenameSuffix(CurTagFilename);
            allcaption = (CurTagDescription=='')? CurTagFilename:CurTagFilename' ('CurTagDescription')';
            index=tree1._TreeAddItem(index,   //Relative Index
                                     allcaption,    //Caption
                                     flags, //Flags
                                     _pic_file,         //Collapsed Bitmap Index
                                     _pic_file,         //Expanded Bitmap Index
                                     -1);               //Initial State
            _TreeSetUserInfo(index,'R');
         }else{
            allcaption = (CurTagDescription=='')? CurTagFilename:CurTagFilename' ('CurTagDescription')';
            index=tree1._TreeAddItem(index,   //Relative Index
                                     allcaption,    //Caption
                                     flags, //Flags
                                     _pic_file,         //Collapsed Bitmap Index
                                     _pic_file,         //Expanded Bitmap Index
                                     -1);               //Initial State
         }
         flags=0;
         tree1._TreeSetInfo(_TreeGetParentIndex(index),1);
         AddedList=AddedList' 'CurTagFilename' ';
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Add references file names to the tag form tree at 'index'
//
static void AddRefFiles(int index,_str TagFileList)
{
   int flags=TREE_ADD_AS_CHILD;
   _str AddedList='';
   for (;;) {
      _str CurTagFilename=next_tag_file2(TagFileList,false/*no check*/,false/*no open*/);
      if (CurTagFilename=='') break;
      CurTagDescription='';
      if (!pos(' 'CurTagFilename' ',AddedList,'',_fpos_case)) {
         //10:14am 9/19/1997
         //This absolute is really important.  Without it, the file will not
         //get closed properly if the tag file is relative!!!!!
         status=tag_read_db(absolute(CurTagFilename));
         if (status) {
            return;
         } else {
            // get tag file description
            CurTagDescription = tag_get_db_comment();
            //10:14am 9/19/1997
            //This absolute is really important.  Without it, the file will not
            //get closed properly if the tag file is relative!!!!!
            tag_close_db(absolute(CurTagFilename));
         }
         CurTagFilename=strip(CurTagFilename,'B','"');
         allcaption = (CurTagDescription=='')? CurTagFilename:CurTagFilename' ('CurTagDescription')';
         index=tree1._TreeAddItem(index,   //Relative Index
                                  allcaption,    //Caption
                                  flags, //Flags
                                  _pic_file,         //Collapsed Bitmap Index
                                  _pic_file,         //Expanded Bitmap Index
                                  -1);               //Initial State
         flags=0;
         tree1._TreeSetInfo(_TreeGetParentIndex(index),1);
         AddedList=AddedList' 'CurTagFilename' ';
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// initialize the tag file management form
//
ctldone.on_create()
{
   if (_win32s()==1 || machine()=='OS2386') {
      ctlAutoTag.p_visible=0;
   }
   _xlat_old_vslicktags();
   ProjectTagfilesIndex=tree1._TreeAddItem(TREE_ROOT_INDEX,    //Relative Index
                                           'Project Tag Files',//Caption
                                           TREE_ADD_AS_CHILD,  //Flags
                                           _pic_fldclos,       //Collapsed Bitmap Index
                                           _pic_fldopen,       //Expanded Bitmap Index
                                           -1);                //Initial State
   ReferencesFilesIndex=tree1._TreeAddItem(TREE_ROOT_INDEX,    //Relative Index
                                           'References File',//Caption
                                           TREE_ADD_AS_CHILD,  //Flags
                                           _pic_fldclos,       //Collapsed Bitmap Index
                                           _pic_fldopen,       //Expanded Bitmap Index
                                           -1);                //Initial State
   TAG_FOLDER_INDEXES=ProjectTagfilesIndex' 'ReferencesFilesIndex;

   wid=_form_parent();
   CurModeName='';
   if (wid && wid._isEditorCtl()) {
      CurModeName=wid.p_mode_name;
   }
   int array[];
   for (ff=1;;) {
      index=name_match('def-tagfiles-',ff,MISC_TYPE);ff=0;
      array[array._length()]=index;
      if (!index) {
         break;
      }
   }
   /*
      Insert captions for extensions specific tag files.
   */
   for (i=0;i<array._length();++i) {
      index=array[i];
      if (!index) {
         mode_name=CurModeName;
         if (mode_name!='') {
            ext=_modename2ext(mode_name,junk);
            if (!index_callable(find_index(ext'-proc-search',PROC_TYPE))) {
               mode_name='';
            }
         }
      } else {
         parse name_name(index) with '-' . '-' ext;
         setup_index=find_index('def-setup-'ext,MISC_TYPE);
         parse name_info(setup_index) with junk'MN='mode_name',';
      }
      FilesIndex= -1;
      if (mode_name!='') {
         FilesIndex=tree1._TreeAddItem(TREE_ROOT_INDEX,    //Relative Index
                                       '"'mode_name'" Tag Files',//Caption
                                        TREE_ADD_AS_CHILD,  //Flags
                                        _pic_fldclos,       //Collapsed Bitmap Index
                                        _pic_fldopen,       //Expanded Bitmap Index
                                       -1);                //Initial State
         TAG_FOLDER_INDEXES=TAG_FOLDER_INDEXES' 'FilesIndex;
         if (_modename_eq(mode_name,CurModeName)) {
            CurModeName='';
         }
      }
      if (!index) {
         break;
      }
      if (FilesIndex>=0) {
         tree1.AddTagFiles(FilesIndex,_replace_envvars(name_info(index)));
      }
   }

   TagFileList=refs_filename();
   tree1.AddRefFiles(ReferencesFilesIndex,TagFileList);
   TagFileList=project_tags_filename(true/*relative paths*/);
   tree1.AddTagFiles(ProjectTagfilesIndex,TagFileList);

   ProjectTagsFilename=_GetProjectTagsFilename();
   index=tree1._TreeGetFirstChildIndex(ProjectTagfilesIndex);
   if (index<0) {
      //We want to always display a project filename
      index=tree1._TreeAddItem(ProjectTagfilesIndex,   //Relative Index
                               ProjectTagsFilename,    //Caption
                               TREE_ADD_AS_CHILD, //Flags
                               _pic_file,         //Collapsed Bitmap Index
                               _pic_file,         //Expanded Bitmap Index
                               -1);               //Initial State
   }
   SetTagFiles();
   index=tree1._TreeCurIndex();
   if (index>=0) {
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   }
   //_TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
   //_TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
}

//////////////////////////////////////////////////////////////////////////////
// Get the file name of the tag file in the tree at 'index'
//
static _str GetRealTagFilenameFromTree(int index)
{
   _str TagFilename=_TreeGetCaption(index);
   parse TagFilename with TagFilename ' (' rest ')';
   if (_TreeGetUserInfo(index)=='R') {
      TagFilename=StripRelativeIndicator(TagFilename);
      TagFilename=absolute(TagFilename);
   }
   return(TagFilename);
}

//////////////////////////////////////////////////////////////////////////////
// Handle change events for the tag file tree
//
tree1.on_change(reason,index)
{
   if (SKIP_ON_CHANGE==1) return('');
   switch (reason) {
   case CHANGE_SELECTED:
      parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
      depth=tree1._TreeGetDepth(index);
      list1._lbclear();
      if (depth==FILE_DEPTH) {
         parentIndex = tree1._TreeGetParentIndex(index);
         TagFilename=GetRealTagFilenameFromTree(index);
         mou_hour_glass(1);
         list1.LoadFileNameList(TagFilename);
         mou_hour_glass(0);

         if (parentIndex == ReferencesFilesIndex) {
            if ('.':+lowcase(get_extension(TagFilename)) :== BSC_FILE_EXT) {
               ctldone.p_enabled=ctlremove_tag_file.p_enabled=ctloptions.p_enabled=1;
               ctlnew_tag_file.p_enabled=ctltree.p_enabled=ctlfiles.p_enabled=ctlremove_files.p_enabled=0;
               ctlrebuild_tag_file.p_enabled=ctlretag_files.p_enabled=ctldown.p_enabled=ctlup.p_enabled=0;
            } else {
               ctldone.p_enabled=ctlremove_tag_file.p_enabled=ctloptions.p_enabled=1;
               ctlnew_tag_file.p_enabled=0;
               ctltree.p_enabled=ctlfiles.p_enabled=ctlremove_files.p_enabled=1;
               ctlrebuild_tag_file.p_enabled=ctlretag_files.p_enabled=1;
               ctldown.p_enabled=ctlup.p_enabled=0;
            }
         } else {
         ctlnew_tag_file.p_enabled=ctldone.p_enabled=ctltree.p_enabled=ctlremove_tag_file.p_enabled=ctlremove_files.p_enabled=ctlfiles.p_enabled=1;
         ctlrebuild_tag_file.p_enabled=ctlretag_files.p_enabled=ctloptions.p_enabled=ctldown.p_enabled=ctlup.p_enabled=1;
         }
      }else{
         parentIndex=index;
         ctlnew_tag_file.p_enabled=1;
         ctltree.p_enabled=ctlremove_tag_file.p_enabled=ctlremove_files.p_enabled=ctlfiles.p_enabled=0;
         ctlrebuild_tag_file.p_enabled=ctlretag_files.p_enabled=ctldown.p_enabled=ctlup.p_enabled=0;
      }
      if (parentIndex==ReferencesFilesIndex) {
         if (tree1._TreeGetFirstChildIndex(parentIndex) > 0) {
            ctlnew_tag_file.p_enabled=0;
         }
      }
      break;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle double-click events for the source file list
//
list1.lbutton_double_click,enter()
{
   _str filename=_lbget_text();
   if (filename != '') {
      _str ext=_bufname2ext(filename);
      int index=find_index('vs'ext'-load-tags',PROC_TYPE);
      if (!index_callable(index)) {
         _mdi.p_child.edit(maybe_quote_filename(filename));
      } else {
         message nls('Can not locate source code for %s.',filename);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Get then name of the 'primary' project tags file
//
_str _GetProjectTagsFilename()
{
   if (_project_name=='') return('');
   _str project_filename=_project_name;
   _str project_tag_files=strip_filename(project_filename,'E'):+TAG_FILE_EXT;
   return(project_tag_files);
}

//////////////////////////////////////////////////////////////////////////////
// Is a tag file currently selected in the tag form tree?
//
static boolean FileIsSelected()
{
   int index=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(index);
   return(depth==FILE_DEPTH);
}

//////////////////////////////////////////////////////////////////////////////
// Add tags from the given list of files to the given tag file
//
int tag_add_filelist(_str TagFilename,_str filelist)
{
   // create a temporary view
   int list_view_id;
   _str orig_view_id = _create_temp_view(list_view_id);
   if (orig_view_id == '') {
      return(COMMAND_CANCELLED_RC);
   }

   // add files from the given file list to the tag file
   _str wildcard, filename;
   for (;;) {
      wildcard=parse_file(filelist);
      wildcard=strip(wildcard,'B','"');
      if (wildcard=='') break;
      int ff=1;
      for (;;) {
         filename=file_match(' -p 'maybe_quote_filename(wildcard),ff);ff=0;
         if (filename=='') {
            break;
         }
         insert_line(filename);
      }
   }

   // get the project tags file name, and add files to project if needed
   _str project_filename=_project_name;
   _str project_tag_files=_GetProjectTagsFilename();
   if (file_eq(TagFilename,project_tag_files)) {
      AddFileListToProjectFiles(project_filename,'',list_view_id);
   }

   // Tag the files in the temporary view and close out the view
   p_view_id = list_view_id;
   top(); up();
   RetagFilesInTagFile2(TagFilename,(int)orig_view_id,list_view_id,false,false);
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
//  Handle 'add files' button press or menu selection
//
void ctlfiles.lbutton_up()
{
   if (!FileIsSelected()) return;
   //TagFilename=tree1._TreeGetCaption(tree1._TreeCurIndex());
   _str TagFilename=tree1.GetRealTagFilenameFromTree(tree1._TreeCurIndex());
   _str TagDir=strip_filename(TagFilename,'N');
   _str olddir=getcwd();
   chdir(TagDir,1);

   // get modename, wildcards, and whether this is a references database
   _str mode_name, wildcards;
   boolean retag_refs = GetWildcardsForTagFile(mode_name, wildcards);
   _str result;
   if (retag_refs) {
      file_types=
      result=_OpenDialog("-modal "_stdform("_open_form"), 
                         'Add Source Files',// title
                         "*.class",// Initial wildcards
                         "All Files ("ALLFILES_RE"),"EXTRA_FILE_FILTERS,
                         OFN_NOCHANGEDIR|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT,
                         "", // Default extension
                         ""/*wildcards*/, // Initial filename
                         "");// Initial directory
   } else {
      // get modename, wildcards, and whether this is a references database
      filtercards=wildcards;
      if (filtercards=="") {
         _str filtercards = _last_wildcards;
         if (filtercards == '') {
            filtercards = C_WILDCARDS;
         }
      }
      result=_OpenDialog("-modal "_stdform("_open_form"), 
                         'Add Source Files',// title
                         filtercards,// Initial wildcards
                         EXTRA_FILE_FILTERS','def_file_types,
                         OFN_NOCHANGEDIR|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT|OFN_SET_LAST_WILDCARDS,
                         "", // Default extension
                         ""/*wildcards*/, // Initial filename
                         "");// Initial directory
   }
   chdir(olddir,1);
   if (result=='') return;

   _str orig_view_id=_create_temp_view(filelist_view_id);
   p_view_id=filelist_view_id;
   _str file_spec_list = result;
   while (file_spec_list != '') {
      _str file_spec = parse_file(file_spec_list);
      insert_file_list(file_spec' -v +p -d');
   }
   p_line=0;

   // Add files to the current project file
   message('Visual SlickEdit is building tags for new files');
   _str project_filename=_project_name;
   _str project_tag_files=_GetProjectTagsFilename();
   if (file_eq(TagFilename,project_tag_files)) {
      AddFileListToProjectFiles(project_filename,'',filelist_view_id);
   }

   // delegate to general purpose function for retagging files
   RetagFilesInTagFile2(TagFilename, (int)orig_view_id, filelist_view_id, false, retag_refs);

   // update the list of files, that's all
   int index=tree1._TreeCurIndex();
   if (index>=0) {
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   }
   mou_hour_glass(0);
   clear_message();
}

//////////////////////////////////////////////////////////////////////////////
// Add the given list of files to the project file
//
static int AddFileListToProjectFiles(_str project_filename,_str filelist,int list_view_id)
{
   status=_ini_get_section(project_filename,"FILES",temp_view_id);
   if (status==STRING_NOT_FOUND_RC) {
      _create_temp_view(temp_view_id);
      status=0;
   }
   if (status) {
      _message_box(nls("Could not add these files to project file %s.\n%s",project_filename,get_message(status)));
      return(status);
   }else{
      //filelist=result;
      orig_view_id=p_view_id;
      p_view_id=temp_view_id;
      if (list_view_id) {
         activate_view(list_view_id);
         top();up();
      }
      for (;;) {
         if (list_view_id) {
            activate_view(list_view_id);
            if(down()) break;
            get_line(filename);
            filename=strip(filename);
            activate_view(temp_view_id);
         } else {
            filename=parse_file(filelist);
         }
         filename=strip(filename,'B','"');
         if (filename=='') break;
         p_line=0;
         status=search('^'_escape_re_chars(filename)'$','r@'_fpos_case);
         if (status) {
            insert_line(filename);
         }
      }
      activate_view(temp_view_id);
      sort_buffer('-f');
      p_view_id=orig_view_id;
      status=_ini_put_section(project_filename,"FILES",temp_view_id);  
      if (status) {
         _message_box(nls("Could not remove add files to project file %s.\n%s",project_filename,get_message(status)));
         mou_hour_glass(0);
         return(status);
      }
      toolbarUpdateFilterList(_project_name);
      //_delete_temp_view(temp_view_id);
   }
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
// Retag the files int the current 'primary' project tag file
//
void _project_update_files_retag(boolean rebuild_all=false,
                                 boolean doRemove=false,
                                 boolean RemoveWithoutPrompting=false,
                                 boolean quiet=false)
{
   //say("_project_update_files_retag");

   // Create a temporary view containing the files in the project
   if (_project_name=='') {
      return;
   }
   message("Getting source files in current project");
   mou_hour_glass(1);
   _str project_tag_file = _GetProjectTagsFilename();
   int orig_view_id=p_view_id;
   int status=GetProjectFiles(_project_name, temp_view_id);
   if (status) {
      mou_hour_glass(0);
      return;
   }

   // check if there are no or very few tag files,
   // special case of removing all files optimization
   p_view_id = temp_view_id;
   if (p_Noflines <= 1) {
      reuild_all = true;
   }

   // open, or create from scratch the tag file
   status = _OpenOrCreateTagFile(project_tag_file, false);
   if (status) {
      mou_hour_glass(0);
      return;
   }

   // iterate through the files in the database and remove files not
   // found in the project file
   if (!rebuild_all) {
      save_search(p1,p2,p3,p4);
      p_view_id=temp_view_id;
      sort_buffer('-f');
      status = tag_find_file(filename);
      while (!status) {
         status=search('^'_escape_re_chars(filename)'$','@r'_fpos_case);
         if (status) {
            top();
            status=repeat_search('@r');
         }
         if (status) {
            // file is not in the project
            message('Removing 'filename' from 'project_tag_file);
            tag_remove_from_file(filename, 1);
         }
         status = tag_next_file(filename);
      }
      tag_close_db(project_tag_file,1);
      restore_search(p1,p2,p3,p4);
   }

   // Tag/retag all the files in the project
   p_view_id=temp_view_id;
   p_line=0;
   RetagFilesInTagFile2(project_tag_file, orig_view_id, temp_view_id, rebuild_all, false,doRemove,RemoveWithoutPrompting,true,quiet);

   // that's all folks
   clear_message();
   mou_hour_glass(0);
}

//////////////////////////////////////////////////////////////////////////////
// Handle pressing of 'rebuild tag file' button.  Prompt to ask if
// only modified files should be retagged, or all files.
//
int ctlrebuild_tag_file.lbutton_up()
{
   // is a tag file selected?
   int index=tree1._TreeCurIndex();
   if (tree1._TreeGetDepth(index)!=FILE_DEPTH) return(0);

   // get tag file name
   _str TagFilename=tree1.GetRealTagFilenameFromTree(index);

   // Is this a references file?
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   boolean retag_refs = (tree1._TreeGetParentIndex(index) == ReferencesFilesIndex)? true:false;

   // rebuild the database from scratch if it is out of date
   boolean rebuild_all = false;
   status = tag_read_db(TagFilename);
   boolean RemoveWithoutPrompting=false;
   if (status || tag_current_version()<VS_TAG_LATEST_VERSION) {
      rebuild_all = true;
      RemoveWithoutPrompting=true;
   }
   if (retag_refs) {
      // If they select to retag all files, not just modified, force a rebuild
      if (!rebuild_all) {
         result=_message_box("Retag modified files only?\nRetagging all files can take significantly longer.",'',MB_YESNOCANCEL|MB_ICONQUESTION);
         if (result==IDCANCEL) {
            return(COMMAND_CANCELLED_RC);
         }
         rebuild_all = (result==IDNO)? true:false;
      }
   } else {
      // If they select to retag all files, not just modified, force a rebuild
      if (!rebuild_all) {
         result=show('-modal _rebuild_tag_file_form');
         if (result=="") {
            return(COMMAND_CANCELLED_RC);
         }
         rebuild_all= !_param1;
         RemoveWithoutPrompting= _param2;
      }
   }

   // if the current tag file is the primrary project file, 
   // use techniques to stay in sync with project file
   _str ProjectTagFilename=_GetProjectTagsFilename();
   if (file_eq(TagFilename,ProjectTagFilename)) {
      _project_update_files_retag(rebuild_all,true,RemoveWithoutPrompting);
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
      return(0);
   }

   // ready to do some serious tagging, first get files from database
   mou_hour_glass(1);
   RetagFilesInTagFile(TagFilename, rebuild_all, retag_refs,true,RemoveWithoutPrompting);
   
   // final cleanup and we are done
   clear_message();
   tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   mou_hour_glass(0);
   return(0);
}
int RetagFilesInTagFile(_str tag_filename,
                        boolean rebuild_all,
                        boolean retag_refs,
                        boolean doRemove=false,
                        boolean RemoveWithoutPrompting=false,
                        boolean RemoveFromProject=false,
                        boolean quiet=false
                        )
{

   //say('RetagFilesInTagFile');
   int list_view_id;
   _str orig_view_id = _create_temp_view(list_view_id);
   if (orig_view_id == '') {
      return (COMMAND_CANCELLED_RC);
   }

   // delegate to general purpose load-filename function above
   mou_hour_glass(0);
   LoadFileNameList(tag_filename);

   // rebuild the database
   status=RetagFilesInTagFile2(tag_filename,(int)orig_view_id, list_view_id, rebuild_all, retag_refs,doRemove,RemoveWithoutPrompting,RemoveFromProject,quiet);
   return(status);
}

//////////////////////////////////////////////////////////////////////////////
// Handle pressing of 'retag source files' button.
//
int ctlretag_files.lbutton_up()
{
   // find the selected tag file
   int index=tree1._TreeCurIndex();
   if (tree1._TreeGetDepth(index)!=FILE_DEPTH) return(0);
   _str TagFilename=tree1.GetRealTagFilenameFromTree(index);
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   boolean retag_refs = (tree1._TreeGetParentIndex(index) == ReferencesFilesIndex)? true:false;

   // nothing to do if there are no files to tag
   if (list1.p_Noflines <= 0) {
      _message_box("No files to retag");
      return(0);
   }

   // no files selected, ask if they want to retag everything
   if (list1.p_Nofselected == 0) {
      status=_message_box("No files selected, do you want to retag all files",'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (status!=IDYES) {
         return(COMMAND_CANCELLED_RC);
      }
      list1._lbselect_all();
   }

   // create a temporary view to hold names of files to be retagged
   mou_hour_glass(1);
   int list1_wid = list1.p_window_id;
   _str orig_view_id = _create_temp_view(list_view_id);
   if (orig_view_id == '') {
      return (COMMAND_CANCELLED_RC);
   }

   // transfer selected files to the temporary view
   status=list1_wid._lbfind_selected(true);
   while (!status) {
      insert_line(strip(list1_wid._lbget_text()));
      status = list1_wid._lbfind_selected(false);
   }

   // Retag all files that were inserted into the file list
   top(); up();
   RetagFilesInTagFile2(TagFilename, (int)orig_view_id, list_view_id, true, retag_refs);

   // blow away the file list temp view
   clear_message();
   mou_hour_glass(0);
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
// Get the wildcards for the given tag file
// The current object is the tag files form.
// Returns true if the current tag file is a references database.
//
static boolean GetWildcardsForTagFile(_str &mode_name, _str &wildcards)
{
   // Check if tree is selected, and chdir to directory containing tag file
   int index=tree1._TreeCurIndex();
   if (tree1._TreeGetDepth(index)==FILE_DEPTH) {
      index = tree1._TreeGetParentIndex(index);
   }
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;

   // set up wildcards for Java, class, jar files
   if (index==ReferencesFilesIndex) {
      wildcards = JAR_WILDCARDS;
      mode_name = 'JAR'; // not really used as a mode name
      return true;
   } 
   
   // get the mode name of the selected extension specific tag file
   wildcards = C_WILDCARDS;
   mode_name='';
   while (extFilesIndexList != '') {
      parse extFilesIndexList with temp_index extFilesIndexList;
      if (temp_index!='' && index==temp_index) {
         // convert mode name to set of wildcards for extension
         parse tree1._TreeGetCaption(temp_index) with '"'mode_name'"';
         wildcards = _modename2wildcards(mode_name);
         break;
      }
   }
   // Adjust the wild cards so the Add Files dialog gets initialized
   // properly.
   list=wildcards;
   for (;;) {
      parse list with wildcard';' list;
      if (wildcard=="") {
         break;
      }
      // Check if this set of wildcards is in our def_file_types
      i=pos('[(;]'_escape_re_chars(wildcard)'[);]',def_file_types,1,'r'_fpos_case);
      if (i) {
         // Set wildcards to this one.
         paren_i=lastpos('(',def_file_types,i);
         if (paren_i) {
            parse substr(def_file_types,paren_i) with '('wildcards')';
         }
         break;
      }

   }



   // retagging source files
   return false;
}

//////////////////////////////////////////////////////////////////////////////
// Handle 'Add tree' button
//
void ctltree.lbutton_up()
{
   // Check if tree is selected, and chdir to directory containing tag file
   int index=tree1._TreeCurIndex();
   if (tree1._TreeGetDepth(index)!=FILE_DEPTH) return;
   _str TagFilename=tree1.GetRealTagFilenameFromTree(index);

   // get modename, wildcards, and whether this is a references database
   _str mode_name, wildcards;
   boolean retag_refs = GetWildcardsForTagFile(mode_name, wildcards);

   // show the change directory form to select base to add tag files below
   _str TagDir=strip_filename(TagFilename,'N');
   _str olddir=getcwd();
   chdir(TagDir,1);
   orig_def_file_types=def_file_types;
   if (retag_refs) {
      def_file_types="All Files ("ALLFILES_RE"),"EXTRA_FILE_FILTERS;
      wildcards="*.class";
   } else {
      def_file_types=EXTRA_FILE_FILTERS','def_file_types;
   }
   _str result=show('-modal _addtree_form',
                    'Add Tree',
                    wildcards,(mode_name==''));
   def_file_types=orig_def_file_types;
   chdir(olddir,1);
   if (result=='') {
      clear_message();
      return;
   }

   // find the files in the tree, insert into temporary view
   mou_hour_glass(1);
   message('Visual SlickEdit is finding all files in tree');
   _str recursive=(_param2)?'+t':'-t';
   int formwid=p_active_form;
   _str orig_view_id=_create_temp_view(filelist_view_id);
   p_view_id=filelist_view_id;
   for (i=0;i<_param1._length();++i) {
      insert_file_list(_param1[i]' 'recursive' -v +p -d');
   }
   _param1._makeempty();
   p_line=0;

   // Add files to the current project file
   message('Visual SlickEdit is building tags for new files');
   _str project_filename=_project_name;
   _str project_tag_files=_GetProjectTagsFilename();
   if (file_eq(TagFilename,project_tag_files)) {
      AddFileListToProjectFiles(project_filename,'',filelist_view_id);
   }

   // delagate to the general purpose retagging proc
   p_view_id=filelist_view_id;
   p_line=0;
   status = RetagFilesInTagFile2(TagFilename, (int)orig_view_id, filelist_view_id,
                                false, retag_refs);
   activate_view((int)orig_view_id);
   // update the list of files, that's all
   index=tree1._TreeCurIndex();
   if (index>=0) {
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   }
   mou_hour_glass(0);
   clear_message();
}

//////////////////////////////////////////////////////////////////////////////
// handle resizing form, moving vertical divider between tag files
// on the left and source files on the left.
//
_divider.lbutton_down()
{
   mou_mode(1)
   mou_release;mou_capture
   done=0;
   xpos=0;
   selected_wid=orig_wid=p_window_id;
   p_window_id=selected_wid.p_parent;

   _save_draw_setup(draw_setup);

   p_fill_style=PSFS_TRANSPARENT;
   p_draw_width=1;
   p_draw_style=PSDS_SOLID
                p_draw_mode=PSDM_XORPEN
                            color=_rgb(0x80,0x80,0x80);  /* Gray */

   morig_x=mou_last_x('M');morig_y=mou_last_y('M');

   morig_x=selected_wid.p_x+100//selected_wid.p_width;
           morig_y=selected_wid.p_y+selected_wid.p_height;
   rectangle_drawn=0;
   done=0;

   selected_wid._get_window(orig_x,orig_y,orig_width,orig_height);

   orig_width=60//Hack

              x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
   orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
   smallest_width=_HANDLE_WIDTH*2;
   smallest_height=_HANDLE_HEIGHT*2;

   _lxy2lxy(SM_TWIP,p_scale_mode,smallest_width,smallest_height);
   for (;;) {
      event=get_event();
      switch (event) {
      case MOUSE_MOVE:
         new_x1=x1;new_y1=y1;new_x2=x2;new_y2=y2;
         new_x1=mou_last_x('M')
                new_x2=new_x1+60;
         if (new_y2-new_y1<smallest_height) {
            new_y1=y1;new_y2=y2;
         }
         if (rectangle_drawn) {

            if (x1==new_x1 && y1==new_y1 && x2==new_x2 &&y2==new_y2) {
               break;
            }
            /* Erase the rectangle. */
            _draw_rect(x1,y1,x2,y2,color,'e');
         }
         rectangle_drawn=1;
         x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
         _draw_rect(x1,y1,x2,y2,color,'e');
         break;
      case LBUTTON_UP:
         x_pos=mou_last_x('m');
         mou_mode(0);
         mou_release();
         if (rectangle_drawn) {
            /* Erase the rectangle. */
            _draw_rect(x1,y1,x2,y2,color,'e');
         }
         _restore_draw_setup(draw_setup);
         if (x_pos>=tree1.p_x&&x_pos<=list1.p_x+list1.p_width) {
            _divider.p_x=x_pos;
            list1.p_x=_divider.p_x+_divider.p_width;
            tree1.p_width=_divider.p_x-tree1.p_x;
            list1.p_width=_dx2lx(SM_TWIP,p_active_form.p_client_width)-list1.p_x;
         }
         return(0);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle form resizing
//
_tag_form.on_resize()
{
   list1.p_x=_divider.p_x+_divider.p_width;
   list1.p_width=_dx2lx(SM_TWIP,p_active_form.p_client_width)-list1.p_x;

   ctlnew_tag_file.p_visible=ctldone.p_visible=ctltree.p_visible=ctlremove_tag_file.p_visible=ctlremove_files.p_visible=ctlfiles.p_visible=0;
   ctlrebuild_tag_file.p_visible=ctlretag_files.p_visible=ctloptions.p_visible=ctldown.p_visible=ctlup.p_visible=ctlAutoTag.p_visible=0;

   ctlfiles.p_y=_dy2ly(SM_TWIP,p_active_form.p_client_height)-((ctlfiles.p_height+75) + (ctlup.p_height+75));
   ctloptions.p_y=ctldone.p_y=ctltree.p_y=ctlremove_tag_file.p_y=ctlremove_files.p_y=ctlfiles.p_y;
   ctlnew_tag_file.p_y=ctlrebuild_tag_file.p_y=ctlretag_files.p_y=ctldown.p_y=ctlup.p_y=ctlAutoTag.p_y=ctlfiles.p_y+ctlfiles.p_height+75;
   tree1.p_height=list1.p_height=_divider.p_height=(ctlfiles.p_y-100)-tree1.p_y;

   ctlnew_tag_file.p_visible=ctldone.p_visible=ctltree.p_visible=ctlremove_tag_file.p_visible=ctlremove_files.p_visible=ctlfiles.p_visible=1;
   ctlrebuild_tag_file.p_visible=ctlretag_files.p_visible=ctloptions.p_visible=ctldown.p_visible=ctlup.p_visible=ctlAutoTag.p_visible=1;
}

//////////////////////////////////////////////////////////////////////////////
// Strip off the text indicating that a tag file is relative
//
static _str StripRelativeIndicator(_str filename)
{
   lp=lastpos(' (',filename);
   if (lp&&lp>1) {
      filename=substr(filename,1,lp-1);
   }
   return(filename);
}

//////////////////////////////////////////////////////////////////////////////
// get the list of tag files under the given folder
//
static _str GetFolderFileList(int ParentIndex,_str OmitList='')
{
   index=tree1._TreeGetFirstChildIndex(ParentIndex);
   str='';
   for (;;) {
      if (index<0) break;
      filename=tree1._TreeGetCaption(index);
      parse filename with filename ' (' rest ')';
      if (tree1._TreeGetUserInfo(index)=='R') {
         filename=StripRelativeIndicator(filename);
      }
      if (str=='') {
         str=filename;
      }else{
         str=str:+PATHSEP:+filename;
      }
      index=tree1._TreeGetNextSiblingIndex(index);
   }
   //We don't want to put anything in if it is just the project tags filename
   if (file_eq(str,_GetProjectTagsFilename())) str='';
   return(str);
}

//////////////////////////////////////////////////////////////////////////////
// Store the tag file lists in their respective places for global, project,
// extension specific, and project references tag files.
//
static void SetTagFiles(int index=-1)
{
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   if (index<0) {
      SetProjectTags();
      SetReferencesFile();
      for (;;) {
         parse extFilesIndexList with temp_index extFilesIndexList;
         if (temp_index=='') {
            break;
         }
         SetExtensionTagFiles(temp_index);
      }
   } else if(index==ProjectTagfilesIndex){
      SetProjectTags();
   } else if (index==ReferencesFilesIndex) {
      SetReferencesFile();
   } else {
      SetExtensionTagFiles(index);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Store the list of extension specific tag files for the given folder
//
static void SetExtensionTagFiles(int index)
{
   _str list=GetFolderFileList(index);
   parse tree1._TreeGetCaption(index) with '"'mode_name'"';
   _str ext=_modename2ext(mode_name,junk);
   list=_encode_vsroot(list,true,false);
   if (_set_listvar('def-tagfiles-'ext,list)) {
      _config_modify|=CFGMODIFY_DEFDATA;
   }
}

//////////////////////////////////////////////////////////////////////////////
// Store the project tag files list
//
static int SetProjectTags()
{
   if (_project_name=='') return(0);
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   list=GetFolderFileList(ProjectTagfilesIndex);
   status=_ini_set_value(_project_name,"COMPILER",'tagfiles',list);
   if (status) {
      _message_box(nls("Could not set project tag file list\n%s",get_message(status)));
   }
   return(status);
}

//////////////////////////////////////////////////////////////////////////////
// Store the references tag files list
//
static int SetReferencesFile()
{
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   list=GetFolderFileList(ReferencesFilesIndex);
   if (_project_name=='') {
      return(0);
   }
      //_ConfigEnvVar(_SLICKREFS,list);
   //} else {
      status=_ini_set_value(_project_name,"COMPILER",'reffile',list);
      if (status) {
         _message_box(nls("Could not set project references file\n%s",get_message(status)));
      }
      return(status);
   //}
}

//////////////////////////////////////////////////////////////////////////////
// Handle the 'remove tag file' button press.
//
ctlremove_tag_file.lbutton_up()
{
   // check that a tag file is selected
   int index=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(index);
   if (depth!=FILE_DEPTH) return(0);
   int FolderIndex=tree1._TreeGetParentIndex(index);
   _str TagFilename=tree1.GetRealTagFilenameFromTree(index);

   // prompt before removing the file
   int result=_message_box(nls("Do you wish to remove the file %s from your tag file list?",TagFilename),'',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result==IDYES) {
      // Yes this must be tag_close_db and not tag_close_db2
      tag_close_db(TagFilename);
   } else {
      return('');
   }

   // prompt if it should be deleted from the file system
   result=_message_box(nls("Do you wish to permanently delete the file %s?",TagFilename),'',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result==IDYES) {
      status=delete_file(TagFilename);
      if (status && status!=FILE_NOT_FOUND_RC) {
         _message_box(nls("Could not delete file %s",TagFilename));
      }
   }

   // remove the file from the tree and update the file list
   tree1._TreeDelete(index);
   index=tree1._TreeCurIndex();
   if (index>=0) {
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   }

   // remove from project
   project_filename=_project_get_filename();
   status=_ini_get_value(project_filename,"COMPILER",'tagfiles',tagfiles,'');
   if (!status) {
      str=''
      for (;;) {
         filename=next_tag_file2(tagfiles,false);
         if (filename=='') break;
         if (!file_eq(filename,TagFilename)) {
            if (str=='') {
               str=filename;
            }else{
               str=str:+PATHSEP:+filename;
            }
         }
      }
      status=_ini_set_value(_project_get_filename(),"COMPILER",'tagfiles',str);
      if (status) {
         _message_box(nls("Could not remove tag file %s from project file\n%s",TagFilename,get_message(status)));
      }
   }

   // That's all folks.
   SetTagFiles(FolderIndex);
   _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,TagFilename,'D');
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
}

//////////////////////////////////////////////////////////////////////////////
// Remove selected files from the list for tags files
//
int tag_remove_filelist(_str TagFilename,_str FileList)
{
   mou_hour_glass(1);
   status=tag_open_db(TagFilename);
   if (status) {
      _message_box(nls("Unable to open tag file %s",TagFilename));

      // Could get tag file not found here
      // Lets continue any way

      //mou_hour_glass(0);
      //return(status);
   }
   if (!status) {
      list=FileList;
      for (;;) {
         dqfilename=parse_file(list);
         if (dqfilename=='') {
            break;
         }
         filename=strip(dqfilename,'B','"');
         message('Removing 'filename' from 'TagFilename);
         status = tag_remove_from_file(filename,1);
      }
      _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,TagFilename);
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      tag_close_db('',1);
   }
   //tag_flush_db();
   _str project_tag_files=_GetProjectTagsFilename();
   _str project_filename=_project_get_filename();
   if (file_eq(project_tag_files,TagFilename)) {
      //11:44am 8/18/1997
      //Dan Changed for makefile support
      status=_ini_get_section(project_filename,"FILES",temp_view_id);
      // If this file was not already removed from the project (NO PROJECT FILES)
      if (status!=STRING_NOT_FOUND_RC) {
         if (status) {
            _message_box(nls("Could not remove these files from project file %s.\n%s",project_filename,get_message(status)));
            mou_hour_glass(0);
            return(status);
         }
         orig_view_id=p_view_id;
         p_view_id=temp_view_id;
         for (;;) {
            filename=parse_file(FileList);
            filename=strip(filename,'B','"');
            if (filename=='') break;
            p_line=0;
            status=search('^'_escape_re_chars(filename)'$','@r'_fpos_case);
            if (!status) {
               _delete_line();
            }
         }
         p_view_id=orig_view_id;
         status=_ini_put_section(project_filename,"FILES",temp_view_id);
         if (status) {
            _message_box(nls("Could not remove these files from project file %s.\n%s",project_filename,get_message(status)));
            mou_hour_glass(0);
            return(status);
         }
         toolbarUpdateFilterList(_project_name);
      }
   }
   clear_message();
   mou_hour_glass(0);
   return(0);
}

//////////////////////////////////////////////////////////////////////////////
// Remove selected files from the current tag file
//
void ctlremove_files.lbutton_up()
{
   // get the current tag filename from the tree
   int index=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(index);
   if (depth!=FILE_DEPTH) return;
   _str TagFilename=tree1.GetRealTagFilenameFromTree(tree1._TreeCurIndex());
   if (!list1.p_Nofselected) return;
   if ('.':+lowcase(get_extension(TagFilename)) :== BSC_FILE_EXT) {
      _beep();
      return;
   }

   // make sure they didn't press button by accident
   result=_message_box(nls("Are you sure you wish to remove all selected files from %s?",TagFilename),
                       '',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result!=IDYES) return;

   // open the tag database for read-write
   status=tag_open_db(TagFilename);
   if (status) {
      // Could get tag file not found here, warn, but don't return yet
      _message_box(nls("Unable to open tag file %s",TagFilename));
      return;
   }

   // Remove the selected files from the tag file
   mou_hour_glass(1);
   int list1_wid = list1.p_window_id;
   status=list1_wid._lbfind_selected(true);
   while (!status) {
      filename=strip(list1_wid._lbget_text());
      message('Removing 'filename' from 'TagFilename);
      tag_remove_from_file(filename, 1);
      status=list1_wid._lbfind_selected(false);
   }

   // close the database and fire off refresh events
   tag_close_db(TagFilename,1);

   // Maybe remove files from project file
   _str project_tag_files=_GetProjectTagsFilename();
   _str project_filename=_project_get_filename();
   if (file_eq(project_tag_files,TagFilename)) {
      //11:44am 8/18/1997
      //Dan Changed for makefile support
      status=_ini_get_section(project_filename,"FILES",temp_view_id);
      // IF these files we already removed from the project (NO PROJECT FILES)
      if (status!=STRING_NOT_FOUND_RC) {
         if (status) {
            _message_box(nls("Could not remove files from project file %s.\n%s",project_filename,get_message(status)));
         } else {
            orig_view_id=p_view_id;
            p_view_id=temp_view_id;
            status=list1_wid._lbfind_selected(true);
            while (!status) {
               filename=strip(list1_wid._lbget_text());
               p_line=0;
               status=search('^'_escape_re_chars(filename)'$','@r'_fpos_case);
               if (!status) {
                  _delete_line();
               }
               status=list1_wid._lbfind_selected(false);
            }
            p_view_id=orig_view_id;
            status=_ini_put_section(project_filename,"FILES",temp_view_id);
            if (status) {
               _message_box(nls("Could not remove files from project file %s.\n%s",project_filename,get_message(status)));
            }
            toolbarUpdateFilterList(_project_name);
         }
      }
   }

   _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,TagFilename);
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   index=tree1._TreeCurIndex();     
   if (index>=0) {
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
   }
   clear_message();
   mou_hour_glass(0);
   return;
}

//////////////////////////////////////////////////////////////////////////////
// Clean-up when form is destroyed
//
ctldone.on_destroy()
{
   //Refresh the background tag window if it is there
   wid=_find_formobj('_tag_window_form','N');
   if (wid) {
       _nocheck _control ctltagname;
      wid.ctltagname.call_event(wid.ctltagname,ON_CHANGE);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Returns tree index if it exists, otherwise returns -1
//    Item        -- caption of item to search for
//    ParentIndex -- index to search under
//    Options     -- -F means match Item using _fpos_case
//
static int ItemInTree(_str Item,int ParentIndex,_str Options='')
{
   int index=tree1._TreeGetFirstChildIndex(ParentIndex);
   _str str='';
   boolean FileOption=false;
   for (;;) {
      CurOp=parse_file(Options);
      if (CurOp=='') break;
      if (upcase(CurOp)=='-F') {
         FileOption=true;
      }
   }
   for (;;) {
      if (index<0) break;
      CurItem=tree1._TreeGetCaption(index);
      parse CurItem with CurItem ' (' rest ')';
      if (FileOption) {
         if (file_eq(Item,CurItem)) return(index);
      }else{
         if (Item==CurItem) return(index);
      }
      index=tree1._TreeGetNextSiblingIndex(index);
   }
   return(-1);
}

//////////////////////////////////////////////////////////////////////////////
// Create a new tag file
//
#define REBUILD_OLD_WITH_EXISTING_NEW_NAME 0
void ctlnew_tag_file.lbutton_up()
{
   int origindex=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(origindex);
   int FolderIndex;
   if (depth==FILE_DEPTH) {
      FolderIndex=tree1._TreeGetParentIndex(origindex);
   }else{
      FolderIndex=origindex;
   }
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   _str categoryLetter;
   if (FolderIndex==ProjectTagfilesIndex) {
      categoryLetter='P';
   } else if (FolderIndex==ReferencesFilesIndex) {
      categoryLetter='R';
   } else {
      categoryLetter='E';
   }
   _str mode_name='';
   for (list=extFilesIndexList;;) {
      parse list with temp_index list;
      if (temp_index=='') {
         break;
      }
      if (mode_name=='') {
         parse tree1._TreeGetCaption(temp_index) with '"'mode_name'"';
      }
      if (FolderIndex==temp_index) {
         parse tree1._TreeGetCaption(temp_index) with '"'mode_name'"';
         break;
      }
   }
   if (mode_name=='') {
      mode_name='C';
   }
   int enableRefs = 0;
   if (ReferencesFilesIndex > 0) {
      enableRefs = (tree1._TreeGetFirstChildIndex(ReferencesFilesIndex) > 0)? 0:1;
   }
   _str result=show('-modal _add_tag_file_form',categoryLetter,mode_name,enableRefs);
   if (result=='') {
      return;
   }
   switch (result) {
   case 'P':    // Project
      FolderIndex=origindex=ProjectTagfilesIndex;
      depth=FOLDER_DEPTH;
      break;
   case 'R':  // Reference tag files
      FolderIndex=origindex=ReferencesFilesIndex;
      depth=FOLDER_DEPTH;
      break;
   default:   // Extension specific tag files
      for (list=extFilesIndexList;;) {
         parse list with temp_index list;
         if (temp_index=='') {
            // Insert new category
            FilesIndex=tree1._TreeAddItem(TREE_ROOT_INDEX,    //Relative Index
                                          '"'_param1'" Tag Files',//Caption
                                           TREE_ADD_AS_CHILD,  //Flags
                                           _pic_fldclos,       //Collapsed Bitmap Index
                                           _pic_fldopen,       //Expanded Bitmap Index
                                          -1);                //Initial State
            TAG_FOLDER_INDEXES=TAG_FOLDER_INDEXES' 'FilesIndex;
            FolderIndex=origindex=FilesIndex;
            depth=FOLDER_DEPTH;
            //tree1.AddTagFiles(FilesIndex,_param1(index));
            break;
         }
         parse tree1._TreeGetCaption(temp_index) with '"'mode_name'"';
         if (_modename_eq(mode_name,_param1)) {
            FolderIndex=origindex=temp_index;
            depth=FOLDER_DEPTH;
            break;
         }
      }
   }

   int tag_file_type;
   for (;;) {
      orig_wid=p_window_id;
      if (FolderIndex==ReferencesFilesIndex) {
         tag_file_type=VS_DBTYPE_references;
         tag_file_ext=get_extension(REF_FILE_EXT);
         result=_OpenDialog('-modal '_stdform("_open_form"),
                        'Add References Database',// title
                        "",// Initial wildcards
                        "Reference Files (*"REF_FILE_EXT";*"BSC_FILE_EXT")",
                        //"Tag Files (tags.slk;*"TAG_FILE_EXT")",
                        0,
                        tag_file_ext, // Default extension
                        "*"REF_FILE_EXT";*"BSC_FILE_EXT, // Initial filename
                        "");// Initial directory
      } else {
         tag_file_type = VS_DBTYPE_tags;
         tag_file_ext=get_extension(TAG_FILE_EXT);
         result=_OpenDialog(
                     '-modal '_stdform("_open_form"),
                     'Add Tags Database',// title
                     "",// Initial wildcards
                     "Tag File ("SLICK_TAGS_DB"),All Tag Files (tags.slk;*"TAG_FILE_EXT")",
                     //"Tag Files (tags.slk;*"TAG_FILE_EXT")",
                     0,
                     tag_file_ext, // Default extension
                     /*
                        The logic here is that typically all user
                        created tag files have the name "tags.vtg".
                        This prevents the user from having a
                        tag file conflict with a project tag file
                        which has the same extension.
                     */
                     SLICK_TAGS_DB, /*"*"TAG_FILE_EXT */ // Initial filename
                     "");// Initial directory
      }
      if (result=='') break;
      _str ext=get_extension(result);
      _str expected_ext = TAG_FILE_EXT;
      _str alternate_ext = '.slk';
      _str file_type = 'tag';
      if (FolderIndex==ReferencesFilesIndex) {
         expected_ext  = REF_FILE_EXT;
         alternate_ext = BSC_FILE_EXT;
         file_type = 'references'
      }
      if (!file_eq('.'ext,expected_ext) && !file_eq('.'ext,alternate_ext)) {
         _message_box(nls("For your protection, %s files must have a '%s' extension.",file_type,expected_ext));
      }else{
         break;
      }
   }
#if 0
   result=show("-modal _open_form", 
               'Open',// title
               "",// Initial wildcards
               "Tag Files (tags.slk;*"TAG_FILE_EXT")",
               0,
               TAG_FILE_EXT, // Default extension
               "", // Initial filename
               "");// Initial directory
#endif
   if (result!='') {
      if (file_eq(get_extension(result),TAG_FILE_EXT)) {
         _message_box(nls("For your protection, only the %s extension may be used"TAG_FILE_EXT));
         return;
      }
      TagFilename=result;
      TagFilename=strip(TagFilename,'B','"');
      index=ItemInTree(TagFilename,FolderIndex,'-F');
      if (index<0) {
         if (file_match(TagFilename' -p',1)!='') {
            //File exists already
            if (file_eq(get_extension(TagFilename),'slk')) {
               //The user added an old tag file
               NewTagFilename=strip_filename(TagFilename,'E'):+TAG_FILE_EXT;
               if (file_match(NewTagFilename' -p',1)!='') {
                  //A new tag file by this name exists already.
                  result=_message_box(nls("%s is an old Visual SlickEdit tag file.\nWould you like to add the new Visual SlickEdit tag file %s instead?",TagFilename,NewTagFilename),'',MB_YESNOCANCEL|MB_ICONQUESTION);
                  if (result==IDCANCEL||result==IDNO) return;
#if REBUILD_OLD_WITH_EXISTING_NEW_NAME
                  //11:10am 7/11/1997
                  //These sections of code were for a complex case that I 
                  //decided not to allow 
                  if (result==IDYES) {
                     //Just add the new style tag file, do not convert the old one.
                     convert=0;
                     TagFilename=NewTagFilename;
                  }
#else
                  if (result==IDYES) {
                     TagFilename=NewTagFilename;
                  }
#endif
               }
               status=RebuildOldTagFile(TagFilename,NewTagFilename);
               if (status) {
                  _message_box(nls("Could not rebuild old tag file %s.\n%s",TagFilename,get_message(status)));
                  return;
               }
               TagFilename=NewTagFilename;
            }else{
               //tag_create_db(TagFilename);
               tag_close_db(TagFilename,1);
            }
         }else{
            tag_create_db(TagFilename, tag_file_type);
            tag_close_db(TagFilename,1);
         }
         int flags=0;
         if (depth==FOLDER_DEPTH) {
            //There are no children
            flags=TREE_ADD_AS_CHILD;
         }
         index=tree1._TreeAddItem(origindex,//Relative Index
                                  TagFilename,          //Caption
                                  flags,                //Flags
                                  _pic_file,         //Collapsed Bitmap Index
                                  _pic_file,         //Expanded Bitmap Index
                                  -1);                  //Initial State
         parentindex=tree1._TreeGetParentIndex(index);
         tree1._TreeSetInfo(parentindex,1);
      }else{
         _message_box(nls("%s already exists",TagFilename));
      }
      if (index>=0) {
         tree1._TreeSetCurIndex(index);
      }
   }
   SetTagFiles(FolderIndex);
   _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,TagFilename,'A');
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
}

//////////////////////////////////////////////////////////////////////////////
// translate 'DEL' key to pressing remove tag file button
//
tree1.del()
{
   ctlremove_tag_file.call_event(ctlremove_tag_file,LBUTTON_UP);
}

//////////////////////////////////////////////////////////////////////////////
// translate 'DEL' key to pressing remove source file button
//
list1.del()
{
   ctlremove_files.call_event(ctlremove_files,LBUTTON_UP);
}

//////////////////////////////////////////////////////////////////////////////
// Calculate suffix for relative file name
//
static _str RelativeFilenameSuffix(_str rfilename)
{
   return(' (Relative - 'getcwd()')');
}

//////////////////////////////////////////////////////////////////////////////
// Make the currently selected tag file relative
//
static void MakeCurTagfileRelative()
{
   int wid=p_window_id;
   p_window_id=tree1;
   int index=_TreeCurIndex();
   _str ProjectTagFilename=_GetProjectTagsFilename();
   _str OrigFilename=_TreeGetCaption(index);
   parse OrigFilename with OrigFilename ' (' rest ')';
   int ParentIndex=_TreeGetParentIndex(index);
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   if (file_eq(OrigFilename,ProjectTagFilename) &&
       ParentIndex==ProjectTagfilesIndex) {
      _message_box("You cannot make the project tagfile relative.");
      return;
   }
   _str rfilename=strip_filename(OrigFilename,'P');
   _str filename=rfilename:+RelativeFilenameSuffix(rfilename);
   _str CurTagDescription = tag_get_db_comment();
   _str allcaption = (CurTagDescription=='')? filename:filename' ('CurTagDescription')';
   _TreeSetCaption(index,allcaption);
   _TreeSetUserInfo(index,'R');
   call_event(CHANGE_SELECTED,index,p_window_id,ON_CHANGE,'W');
   p_window_id=wid;
}

//////////////////////////////////////////////////////////////////////////////
// Make the currently selected tag file absolute rather than relative
// 
static MakeCurTagfileAbsolute()
{
   int wid=p_window_id;
   p_window_id=tree1;
   int index=_TreeCurIndex();
   _str filename=_TreeGetCaption(index);
   parse filename with filename ' (' rest ')';
   _str rfilename=StripRelativeIndicator(filename);
   filename=absolute(rfilename);
   _str CurTagDescription = tag_get_db_comment();
   _str allcaption = (CurTagDescription=='')? filename:filename' ('CurTagDescription')';
   _TreeSetCaption(index,allcaption);
   _TreeSetUserInfo(index,'');
   call_event(CHANGE_SELECTED,index,p_window_id,ON_CHANGE,'W');
   p_window_id=wid;
}

//////////////////////////////////////////////////////////////////////////////
// Update the tag form when the project file is opened or closed
//
static void ProjectUpdate()
{
   formwid=_find_object('_tag_form','N');
   if (formwid) {
      wid=p_window_id;
      p_window_id=formwid.tree1;
      tree1._TreeDelete(TREE_ROOT_INDEX,'C');
      ctldone.call_event(ctldone,ON_CREATE);
      p_window_id=wid;
   }
}
_prjclose_tagform()
{
   ProjectUpdate();
}
_prjopen_tagform()
{
   ProjectUpdate();
}

//////////////////////////////////////////////////////////////////////////////
// Used by _textbox_form while editing the tag file description
//
int CheckDescriptionLengthLT96(_str descr)
{
   return (length(descr) < 96)? 0:1;
}
// Prompt user for and add comment to current tag file
static void AddCommentToCurTagfile()
{
   int index = _TreeCurIndex();
   if (index > 0) {
      int depth = _TreeGetDepth(index);
      if (depth==FILE_DEPTH) {
         _str TagFilename=GetRealTagFilenameFromTree(index);
         int status=tag_read_db(TagFilename);
         if (status) {
            _message_box(nls("Unable to open tag file %s",TagFilename));
            return;
         }
         _str descr = tag_get_db_comment();
         status = show('-modal _textbox_form',
               'Enter Description for Current Tag File',
               0,//Flags,
               '',//Tb width
               '',//help item
               '',//reserved
               AddCommentToCurTagfile,//retrieve name
               '-e CheckDescriptionLengthLT96 Description:'descr);
         if (status=='') {
            return;
         }
         status=tag_open_db(TagFilename);
         if (status) {
            _message_box(nls("Unable to open tag file %s",TagFilename));
            return;
         }
         tag_set_db_comment(_param1);
         allcaption = (_param1=='')? TagFilename:TagFilename' ('_param1')';
         _TreeSetCaption(index,allcaption);
         tag_close_db(TagFilename,1);
         _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,TagFilename);
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Handle right click menu events for the tag form
//
_command TagTreeRunMenu() name_info(','VSARG2_CMDLINE)
{
   if (arg(1)=='') {
      return('');
   }
   switch (lowcase(arg(1))) {
   case 'addfiles':
      ctlfiles.call_event(ctlfiles,LBUTTON_UP);
      break;
   case 'addtree':
      ctltree.call_event(ctltree,LBUTTON_UP);
      break;
   case 'addtagfile':
      ctlnew_tag_file.call_event(ctlnew_tag_file,LBUTTON_UP);
      break;
   case 'deltagfile':
      ctlremove_tag_file.call_event(ctlremove_tag_file,LBUTTON_UP);
      break;
   case 'selectall':
      list1._lbselect_all();
      break;
   case 'delfiles':
      ctlremove_files.call_event(ctlremove_files,LBUTTON_UP);
      break;
   case 'addcomment':
      AddCommentToCurTagfile();
      break;
   case 'makeabs':
      MakeCurTagfileAbsolute();
      break;
   case 'makerel':
      MakeCurTagfileRelative();
      break;
   case 'moveup':
      ctlup.call_event(ctlup,LBUTTON_UP);
      break;
   case 'movedown':
      ctldown.call_event(ctldown,LBUTTON_UP);
      break;
   case 'retagfiles':
      ctlretag_files.call_event(ctlretag_files,LBUTTON_UP);
      break;
   case 'rebuildtagfile':
      ctlrebuild_tag_file.call_event(ctlrebuild_tag_file,LBUTTON_UP);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Display right button menu for tag file tree (left hand side of dialog)
//
tree1.rbutton_up()
{
   tree1.call_event(tree1,LBUTTON_DOWN);
   int index=find_index("_tag_tree_menu",oi2type(OI_MENU));
   int menu_handle=p_active_form._menu_load(index,'P');
   index=tree1._TreeCurIndex();
   parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
   if (_TreeGetDepth(index)!=FILE_DEPTH) {
      _menu_set_state(menu_handle,"treeitem",MF_GRAYED,'C');
      _menu_set_state(menu_handle,"deltagfile",MF_GRAYED,'C');
      _menu_set_state(menu_handle,"addcomment",MF_GRAYED,'C');
      _menu_set_state(menu_handle,"isabsolute",MF_GRAYED,'C');
      _menu_set_state(menu_handle,"isrelative",MF_GRAYED,'C');
      if (index==ReferencesFilesIndex && _TreeGetFirstChildIndex(index)>0) {
         _menu_set_state(menu_handle,"addtagfile",MF_GRAYED,'C');
      }
   }else{
      _str filename=_TreeGetCaption(index);
      parse filename with filename ' (' rest ')';
      int parentIndex=_TreeGetParentIndex(index);
      if (parentIndex==ReferencesFilesIndex) {
         _menu_set_state(menu_handle,"addtagfile",MF_GRAYED,'C');
         _menu_set_state(menu_handle,"isabsolute",MF_GRAYED,'C');
         _menu_set_state(menu_handle,"isrelative",MF_GRAYED,'C');
         if ('.':+lowcase(get_extension(filename)) :== BSC_FILE_EXT) {
            _menu_set_state(menu_handle,"treeitem",MF_GRAYED,'C');
            _menu_set_state(menu_handle,"addcomment",MF_GRAYED,'C');
         }
      }
      if (IsRelative(filename)) {
         _menu_set_state(menu_handle,"isabsolute",MF_GRAYED,'C');
      }else{
         _menu_set_state(menu_handle,"isrelative",MF_GRAYED,'C');
      }
   }
   mou_get_xy(x,y);
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
}

//////////////////////////////////////////////////////////////////////////////
// Display right button menu for source file list (right hand side of dialog)
//
list1.rbutton_up()
{
   if (p_scroll_left_edge>=0) {
      parse _scroll_page() with line_pos down_count;
      goto_point(line_pos);
      down(down_count);
      set_scroll_pos(p_scroll_left_edge,0);
      p_scroll_left_edge=-1;
   }
   
   x=p_cursor_x=mou_last_x();p_cursor_y=y=mou_last_y();
   if (!_lbisline_selected()) {
      _lbdeselect_all();
      _lbselect_line();
   }
   index=find_index("_tag_list_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');
   index=tree1._TreeCurIndex();
   if (tree1._TreeGetDepth(index)!=FILE_DEPTH) {
      _menu_set_state(menu_handle,"treeitem",MF_GRAYED,'C');
   }
   if (!list1.p_Noflines) {
      _menu_set_state(menu_handle,"listitem",MF_GRAYED,'C');
   }
   _map_xy(list1,0,x,y);
   refresh();
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
}

//////////////////////////////////////////////////////////////////////////////
// Move the tag file at the given index up.  This is done to allow the
// user to adjust the ordering in which tag files are searched.
//
static boolean MoveFileUp(int FileIndex)
{
   p_window_id=tree1;
   ParentIndex=_TreeGetParentIndex(FileIndex);
   index=TopFileIndex=_TreeGetFirstChildIndex(ParentIndex);
   for (;;) {
      BottomIndex=index;
      index=_TreeGetNextSiblingIndex(index);
      if (index<0) break;
   }
   if (TopFileIndex==BottomIndex) {
      return(false);
   }
   flags=TREE_ADD_BEFORE;
   rindex=LSibIndex=_TreeGetPrevSiblingIndex(FileIndex);
   if (TopFileIndex==LSibIndex) {
      //flags|=TREE_ADD_BEFORE;
   }else if (LSibIndex<0) {
      rindex=BottomIndex;
      flags&=~TREE_ADD_BEFORE;
   }
   FileCaption=_TreeGetCaption(FileIndex);
   parse FileCaption with FileCaption ' (' rest ')';
   SKIP_ON_CHANGE=1;
   _TreeDelete(FileIndex);
   NewIndex=_TreeAddItem(rindex,
                         FileCaption,
                         flags,
                         _pic_file,
                         _pic_file,
                         -1);
   _TreeSetCurIndex(NewIndex);
   SKIP_ON_CHANGE=0;
   return(true);
}

//////////////////////////////////////////////////////////////////////////////
// Move the tag file at the given index down.  This is done in order
// to allow the user to adjust the ordering in which tag files are searched.
//
static boolean MoveFileDown(int FileIndex)
{
   p_window_id=tree1;
   ParentIndex=_TreeGetParentIndex(FileIndex);
   index=TopFileIndex=_TreeGetFirstChildIndex(ParentIndex);
   for (;;) {
      BottomIndex=index;
      index=_TreeGetNextSiblingIndex(index);
      if (index<0) break;
   }
   if (TopFileIndex==BottomIndex) {
      return(false);
   }
   flags=0;
   rindex=RSibIndex=_TreeGetNextSiblingIndex(FileIndex);
   if (RSibIndex<0) {
      rindex=TopFileIndex;
      flags|=TREE_ADD_BEFORE;
   }
   FileCaption=_TreeGetCaption(FileIndex);
   parse FileCaption with FileCaption ' (' rest ')';
   SKIP_ON_CHANGE=1;
   _TreeDelete(FileIndex);
   NewIndex=_TreeAddItem(rindex,
                         FileCaption,
                         flags,
                         _pic_file,
                         _pic_file,
                         -1);
   _TreeSetCurIndex(NewIndex);
   SKIP_ON_CHANGE=0;
   return(true);
}

//////////////////////////////////////////////////////////////////////////////
// Handle 'Up' and 'Down' buttons
//
ctlup.lbutton_up()
{
   int index=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(index);
   if (depth==FILE_DEPTH) {
      boolean moved=MoveFileUp(index);
      if (moved) {
         int FolderIndex=tree1._TreeGetParentIndex(index);
         SetTagFiles(FolderIndex);
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      }
   }
}
ctldown.lbutton_up()
{
   int index=tree1._TreeCurIndex();
   int depth=tree1._TreeGetDepth(index);
   if (depth==FILE_DEPTH) {
      boolean moved=MoveFileDown(index);
      if (moved) {
         int FolderIndex=tree1._TreeGetParentIndex(index);
         SetTagFiles(FolderIndex);
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////
// Display auto tagging options form
//
ctloptions.lbutton_up()
{
   show('-modal _autotag_options_form');
}

//////////////////////////////////////////////////////////////////////////////
// Update the relative tag files in order to handle
// a change of working directory
//
static void UpdateRelativeTagfiles(int index)
{
   index=_TreeGetFirstChildIndex(index);
   for (;;) {
      if (index<0) break;
      _str info=_TreeGetUserInfo(index);
      if (info=='R') {
         _str CurTagFilename=StripRelativeIndicator(_TreeGetCaption(index));
         parse CurTagFilename with CurTagFilename ' (' . ')';
         CurTagFilename=StripRelativeIndicator(CurTagFilename);
         CurTagFilename=CurTagFilename:+RelativeFilenameSuffix(CurTagFilename);
         _str orig_filename = tag_current_db();
         tag_read_db(CurTagFilename);
         CurTagDescription = tag_get_db_comment();
         tag_read_db(orig_filename);
         _str allcaption = (CurTagDescription=='')? CurTagFilename:CurTagFilename' ('CurTagDescription')';
         _TreeSetCaption(index,allcaption);
         tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
      }
      index=_TreeGetNextSiblingIndex(index);
   }
}

//////////////////////////////////////////////////////////////////////////////
// Callback for change of directory
// 
void _cd_update_relative_files()
{
   int formwid=_find_object('_tag_form','N');
   if (formwid) {
      int wid=p_window_id;
      p_window_id=formwid.tree1;
      parse TAG_FOLDER_INDEXES with ProjectTagfilesIndex ReferencesFilesIndex extFilesIndexList;
      UpdateRelativeTagfiles(ProjectTagfilesIndex);
      for (;;) {
         parse extFilesIndexList with temp_index extFilesIndexList;
         if (temp_index=="") {
            break;
         }
         UpdateRelativeTagfiles(temp_index);
      }
      p_window_id=wid;
   }
   if (tags_filename(false)!=tags_filename(true)) {
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
// bring up autotagging options form
//
defeventtab _autotag_options_form
void ctlpreprocessing.lbutton_up()
{
   show('-modal _c_ppedit_form');
}
void ctlbackground.lbutton_up()
{
   if (p_value && 
       (!isinteger(ctlBufferRetag.p_text) 
        ||!(int)ctlBufferRetag.p_text)) {
      ctlBufferRetag.p_text=TAG_DEFAULT_BUFFER_RETAG_INTERVAL intdiv 1000;
   }
   ctlbackground.p_next.p_enabled=ctlBufferRetag.p_enabled= p_value!=0;
}

#define QQToNum(a,b) (a==''?b:a)

ctlok.on_create()
{
   ctlon_save.p_value=def_autotag_flags2&AUTOTAG_ON_SAVE;
   ctlbackground.p_value=def_autotag_flags2&AUTOTAG_BUFFERS;
   ctlbackground_files.p_value=def_autotag_flags2&AUTOTAG_FILES;
   ctlbackground_files_project.p_value=def_autotag_flags2&AUTOTAG_FILES_PROJECT_ONLY;
   parse def_bgtag_options with Interval MaxConsider MaxRetag;
   ctlbackground_files.call_event(ctlbackground_files,LBUTTON_UP);
   ctlminutes.p_text=QQToNum(Interval/60,10);
   ctlmax_consider.p_text=QQToNum(MaxConsider,10);
   ctlmax_retag.p_text=QQToNum(MaxRetag,3);
   ctlBufferRetag.p_text=def_buffer_retag intdiv 1000;
   ctlbackground.p_next.p_enabled=ctlBufferRetag.p_enabled= ctlbackground.p_value!=0;

   if (def_ignore_tcase) {
      ctlignore_case.p_value=1;
   }
}

static void disable_all_controls(...)
{
   val=arg(1);
   if (val=='') val=0;
   widlist=arg(2);
   //p_enabled=val;
   wid=p_window_id;
   while (p_child) {
      p_window_id=p_child;
      firstwid=p_window_id;
      for (;;) {
         p_window_id=p_next;
         if (!pos(' 'p_window_id' ',' 'widlist' ')) p_enabled=val;
         if (p_window_id==firstwid) break;
      }
   }
   p_window_id=wid;
}

#define DEFAULT_TIMEOUT 10
#define DEFAULT_TAGGED_FILES 3
#define DEFAULT_CONSIDERED_FILES 10

ctlbackground_files.lbutton_up()
{
   p_parent.disable_all_controls(p_value,p_window_id);
   if (p_value && 
       (!isinteger(ctlminutes.p_text) ||!(int)ctlminutes.p_text)) {
      ctlminutes.p_text=DEFAULT_TIMEOUT;
   }
   p_enabled=1;
}

void ctlok.lbutton_up()
{
   flags=AUTOTAG_SYMBOLS;
   if (ctlbackground_files.p_value) {
      flags|=AUTOTAG_FILES;
   }
   if (!isinteger(ctlminutes.p_text)) {
      if (ctlbackground_files.p_value) {
         ctlminutes._text_box_error('Idle time must be an integer');
         return;
      }
      ctlminutes.p_text=DEFAULT_TIMEOUT;
   }    
   Interval=((int)ctlminutes.p_text)*60;

   if (!isinteger(ctlmax_retag.p_text)) {
      if (ctlbackground_files.p_value) {
         ctlmax_retag._text_box_error('Maximum number of files to tag must be an integer');
         return;
      }
      ctlmax_retag.p_text=DEFAULT_TAGGED_FILES;
   }  
   MaxRetag=(int)ctlmax_retag.p_text;

   if (!isinteger(ctlmax_consider.p_text)) {
      if (ctlbackground_files.p_value) {
         ctlmax_consider._text_box_error('Maximum number of files to consider must be an integer');
         return;
      }
      ctlmax_consider.p_text=DEFAULT_CONSIDERED_FILES;
   }  

   MaxConsider=(int)ctlmax_consider.p_text;
   def_bgtag_options=Interval' 'MaxConsider' 'MaxRetag;

   if (!isinteger(ctlBufferRetag.p_text)) {
      if (ctlbackground.p_value) {
         ctlBufferRetag._text_box_error('Idle time must be an integer');
         return;
      }
      ctlBufferRetag.p_text=TAG_DEFAULT_BUFFER_RETAG_INTERVAL intdiv 1000;
   }  
   def_buffer_retag= (int)ctlBufferRetag.p_text*1000;
   if (ctlon_save.p_value) {
      flags|=AUTOTAG_ON_SAVE;
   }
   if (ctlbackground.p_value) {
      flags|=AUTOTAG_BUFFERS;
   }
   if (ctlbackground_files_project.p_value) {
      flags|=AUTOTAG_FILES_PROJECT_ONLY;
   }
   def_autotag_flags2=flags;
   def_ignore_tcase=ctlignore_case.p_value!=0;


   _macro('m',_macro('s'))
   _macro_append("def_autotag_flags2="def_autotag_flags2";");
   _macro_append("def_ignore_tcase="ctlignore_case.p_value";");
   _macro_append("def_bgtag_options="def_bgtag_options";");
   _macro_append("def_buffer_retag="def_buffer_retag";");
   _config_modify|=CFGMODIFY_DEFVAR;

   _BGReTagFiles(1);
   //Reload the list of tag files...
   //This is to in case the Background file/Only project file stuff changes..

   p_active_form._delete_window(0);
}

//############################################################################
//////////////////////////////////////////////////////////////////////////////
// add tag files form for selecting type of tag file to add
//
defeventtab _add_tag_file_form
void ctlextension.lbutton_up()
{
   ctlcombo.p_enabled=ctlextension.p_value!=0;
}
void ctlok.on_create(_str categoryLetter='E',_str defaultModeName="C",boolean enableAddReferenceFile=true)
{
   categoryLetter=upcase(categoryLetter);
   list_wid=ctlcombo.p_cb_list_box;
   if (_project_name=='') {
      ctlreference.p_enabled=ctlproject.p_enabled=0;
      if (categoryLetter=='P' || categoryLetter=='R') {
         categoryLetter='E'
      }
   }
   if (!enableAddReferenceFile) {
      ctlreference.p_enabled=false;
      if (categoryLetter=='R') {
         categoryLetter='E'
      }
   }
   if (categoryLetter=='P') {
      ctlproject.p_value=1;
   } else if (categoryLetter=='R') {
      ctlreference.p_value=1;
   } else {
      ctlextension.p_value=1;
   }

   for (ff=1;;) {
      index=name_match('def-setup-',ff,MISC_TYPE);ff=0;
      if (!index) {
         break;
      }
      if ( substr(name_info(index),1,1)=='@' ) {
         continue;
      }
      parse name_name(index) with '-' .'-' ext;
      if (index_callable(find_index(ext'-proc-search',PROC_TYPE))) {
         parse name_info(index) with junk'MN='mode_name',';
         list_wid._lbadd_item(mode_name);
      }
   }
   status=list_wid._lbsearch(defaultModeName,'i');
   if (status) {
      list_wid._lbtop();
   }
   ctlcombo.p_text=list_wid._lbget_text();
}
void ctlok.lbutton_up()
{
   _param1='';
   if (ctlproject.p_value) {
      result='P';
   } else if (ctlreference.p_value) {
      result='R';
   } else {
      result='E';
      _param1=ctlcombo.p_text;
   }
   p_active_form._delete_window(result);
}
defeventtab _rebuild_tag_file_form
void ctlok.lbutton_up()
{
   _param1=ctlRetagModified.p_value;
   _param2=ctlRemoveWithoutPrompting.p_value;
   p_active_form._delete_window(1);
}
