/*
 * MyKeys.e  :  A keymap to redefine EPM's keyboard easily
 *              04/1995 by herbert
 * The functions executed by a keystrike are called via procs
 * defined in a patched stdkeys.e file or defined anyway :-)
 * This of course means that my version of stdkeys.e is needed.
 */

/*
 * Now here we go:
 */

--- All 'special' keys:

def up = call do_up()
def down = call do_down()
def left = call do_left()
def right = call do_right()
def pgup = call do_pgup()
def pgdn = call do_pgdn()
def home = call do_home()
def end = call do_end()
def ins = call toggle_insert()
def del = call do_del()
def space = call do_space()
def backspace = call smart_backspace()
def esc = 'commandline'
def tab = call do_tab()
def s_up = call mark_up()
def s_down = call mark_down()
def s_left = call mark_left()
def s_right = call mark_right()
def s_pgup = call mark_pgup()
def s_pgdn = call mark_pgdn()
def s_home = call mark_to_bol()
def s_end = call mark_to_eol()
def s_ins = call do_ins()
def s_del = 'cut'
def s_space = call do_space()
def s_backspace = call do_backspace()
def s_tab = call back_tab()
def c_up = call scroll_up()       --- Does not work in EPM's current
def c_down = call scroll_down()   --- version :-( maybe it will sometime
def c_left = call left_word()
def c_right = call right_word()
def c_pgup = call go_to_bof()
def c_pgdn = call go_to_eof()
def c_home = call beg_screen()
def c_end = call end_screen()
def c_ins = 'copy2clip'
def c_del = call delete_right_word()
def c_space = call do_space()
def c_backspace = call delete_line()
def c_tab = keyin \7
def a_backspace = 'undodlg'

--- The function keys (I left out all those used by PM):

def f1 = 'help'
def f2 = call pcenter_mark()
def f3 = 'quit'
def f4 = 'fontlist'
def f5 = call center_line_vert()
def f6 = 
def f7 = call command_line()
def f8 = 'dolines'
def f9 = 'shell'
def f11 = 
def f12 = 'draw' 1
def a_f1 = 'help' --- starts the help browser with info about keybindings
def a_f2 = call upcase_word()
def a_f3 = call locase_word()
def a_f11 = 
def a_f12 = 'draw' 2
def s_f1 =  
def s_f2 = call adjust_block_()
def s_f3 = call reformat_paragraph()
def s_f4 = call dup_line()
def s_f5 = 
   universal cur_keyset --- Commands for EPM debug information
   universal cur_line
   universal cur_col
   Sayerror 'Swapped to debug mode, enter command...'
   cur_keyset = .keyset --- Name of the current keyset
   cur_line = .line
   cur_col = .col
   keys debug_keys
def s_f6 = call record_key_string()
def s_f7 = call put_recorded_keystring()
def s_f8 = call new_keyset()
def s_f9 = 
def s_f11 =
def s_f12 = 'draw' 5
def c_f1 = 'kwhelp'
def c_f2 = call puppercase()
def c_f3 = call plowercase()
def c_f11 =
def c_f12 = 'draw' 6 --- another already defined command!

--- All the other keys:

def a_1 = 
def a_2 =
def a_3 =
def a_4 =
def a_5 =
def a_6 = 
def a_7 =
def a_8 =
def a_9 =
def a_0 =
def a_a =
def a_b = call left_word(); call delete_right_word()
def a_c = 
def a_d = 
def a_e = call add_file()
def a_f = call get_file_at_cursor()
def a_g = 
def a_h = 
def a_i =
def a_j = 
def a_k = call mark_block_()
def a_l = call mark_line_()
def a_m = 
def a_n = call next_file_()
def a_o = 'rename'
def a_p = call previous_file_()
def a_q = 'quit'
def a_r = 
def a_s = call splitlines()
def a_t = 'poptagsdlg'
def a_u = call unmark_block()
def a_v =
def a_w = call pmark_word()
def a_x =
def a_y = 
def a_z =
def a_minus = call circle_it()
def c_1 =
def c_2 =
def c_3 =
def c_4 =
def c_5 =
def c_6 =
def c_7 =
def c_8 =
def c_9 =
def c_0 =
def c_a =
def c_b = compile if WANT_BRACKET_MATCHING
          'match_bracket'
          compile endif
def c_c = call change_next()
def c_d = 
def c_e = 'fold 0'
def c_f = 'fold'
def c_g = 'ring_more'
def c_h = 
def c_i = 'commandline'
def c_j = 'commandline'
def c_l = call find_next()
def c_m = 
def c_n = 
def c_o = 'opendlg'
def c_p = 'findtag'
def c_r = call change_next()
def c_s = 'findtag *'
def c_t = call delete_right_word()
def c_u = undo
def c_v =
def c_w = call scroll_up()
def c_x =
def c_y = call delete_line()
def c_z = call scroll_down()

--- Plain Key definitions:
---  * Add closing brackets for most bracket types
def ')' = keyin ')'
          this_col = .col
          .col = .col - 1
          call passist()
          call passist()
          .col = this_col
def ']' = keyin ']'
          this_col = .col
          .col = .col - 1
          call passist()
          call passist()
          .col = this_col
def '}' = keyin '}'
          this_col = .col
          .col = .col - 1
          call passist()
          call passist()
          .col = this_col

--- Prefix Key bindings: 
--- * like WordStar: Ctrl K, Ctrl Q
--- * no need for Ctrl O postfixes: there's no windowing stuff!
--- * if more than those prefix key bindings are desire, just stick
---   to the way shown below

def c_k =
   universal cur_keyset
   cur_keyset = .keyset --- Name of the current keyset
   sayerror 'Ctrl-K...'
   keys ctrl_k_postfix

def c_q =
   universal cur_keyset
   cur_keyset = .keyset --- Name of the current keyset
   sayerror 'Ctrl-Q...'
   keys ctrl_q_postfix


--- Each twokey combination needs its own keyset for the handling of
--- the second keystroke.

--- All the second keys for Ctrl K ...

defkeys ctrl_k_postfix base clear
    def 'a', 'A' =
       universal cur_keyset
       sayerror 'Select all...'
       'select_all'
       keys edit_keys
       .keyset = cur_keyset
    def 'b', 'B' =
       universal cur_keyset
       sayerror 'Begin Block...'
       call mark_single_char()
       keys edit_keys
       .keyset = cur_keyset
    def 'c', 'C' =
       universal cur_keyset
       sayerror 'Copy Block...'
       'dupmark C'
       keys edit_keys
       .keyset = cur_keyset
    def 'q', 'd', 'Q', 'D' =
       universal cur_keyset
       sayerror 'Quit File...'
       'quit'
       keys edit_keys
       .keyset = cur_keyset
    def 'e', 'E' =
       universal cur_keyset
       sayerror 'Add File...'
       call add_file()
       keys edit_keys
       .keyset = cur_keyset
    def 'f', 'F' =
       universal cur_keyset
       sayerror 'Fill Block...'
       call fill_marked_area()
       keys edit_keys
       .keyset = cur_keyset
    def 'h', 'H' =
       universal cur_keyset
       sayerror 'Unmark Block...'
       call unmark_block()
       keys edit_keys
       .keyset = cur_keyset
    def 'i', 'I' =
       universal cur_keyset
       sayerror 'Indent Block...'
       call move_right()
       keys edit_keys
       .keyset = cur_keyset
    def 'k', 'K' =
       universal cur_keyset
       sayerror 'End Block...'
       call mark_single_char()
       keys edit_keys
       .keyset = cur_keyset
    def 'l', 'L' =
       universal cur_keyset
       sayerror 'List Files...'
       'ring_more'
       keys edit_keys
       .keyset = cur_keyset
    def 'm', 'v', 'M', 'V' =
       universal cur_keyset
       sayerror 'Move Block...'
       'dupmark M'
       keys edit_keys
       .keyset = cur_keyset
    def 'n', 'N' =
       universal cur_keyset
       sayerror 'Overlay Block...'
       'dupmark O'
       keys edit_keys
       .keyset = cur_keyset
    def 'o', 'O' =
       universal cur_keyset
       sayerror 'Save As...'
       'saveas_dlg'
       keys edit_keys
       .keyset = cur_keyset
    def 'p', 'P' =
       universal cur_keyset
       sayerror 'Push Position...'
       'pushpos'
       keys edit_keys
       .keyset = cur_keyset
    def 'r', 'R' =
       universal cur_keyset
       sayerror 'Read block...'
       'opendlg get'
       keys edit_keys
       .keyset = cur_keyset
    def 's', 'S' =
       universal cur_keyset
       sayerror 'Save File...'
       call save_file()
       keys edit_keys
       .keyset = cur_keyset
    def 't', 'T' =
       universal cur_keyset
       sayerror 'Mark Word...'
       call pmark_word()
       keys edit_keys
       .keyset = cur_keyset
    def 'u', 'U' =
       universal cur_keyset
       sayerror 'Unindent Block...'
       call move_left()
       keys edit_keys
       .keyset = cur_keyset
    def 'w', 'W' =
       universal cur_keyset
       sayerror 'sorry, no idea how to write blocks to files'
       keys edit_keys
       .keyset = cur_keyset
    def 'x', 'X' =
       universal cur_keyset
       sayerror 'Save and Quit File...'
       call save_and_quit_file()
       keys edit_keys
       .keyset = cur_keyset
    def 'y', 'Y' =
       universal cur_keyset
       sayerror 'Delete Block...'
       call delete_block()
       keys edit_keys
       .keyset = cur_keyset
    def del =
       universal cur_keyset
       sayerror 'Delete to end of line...'
       erase_end_line
       keys edit_keys
       .keyset = cur_keyset
    def '0' =
       universal cur_keyset
       sayerror 'Enter Bookmark'
       'setmark'
       keys edit_keys
       .keyset = cur_keyset
    def '1' =
       universal cur_keyset
       sayerror 'Set Bookmark 1'
       'setmark 1'
       keys edit_keys
       .keyset = cur_keyset
    def '2' =
       universal cur_keyset
       sayerror 'Set Bookmark 2'
       'setmark 2'
       keys edit_keys
       .keyset = cur_keyset
    def '3' =
       universal cur_keyset
       sayerror 'Set Bookmark 3'
       'setmark 3'
       keys edit_keys
       .keyset = cur_keyset
    def '4' =
       universal cur_keyset
       sayerror 'Set Bookmark 4'
       'setmark 4'
       keys edit_keys
       .keyset = cur_keyset
    def '5' =
       universal cur_keyset
       sayerror 'Set Bookmark 5'
       'setmark 5'
       keys edit_keys
       .keyset = cur_keyset
    def '6' =
       universal cur_keyset
       sayerror 'Set Bookmark 6'
       'setmark 6'
       keys edit_keys
       .keyset = cur_keyset
    def '7' =
       universal cur_keyset
       sayerror 'Set Bookmark 7'
       'setmark 7'
       keys edit_keys
       .keyset = cur_keyset
    def '8' =
       universal cur_keyset
       sayerror 'Set Bookmark 8'
       'setmark 8'
       keys edit_keys
       .keyset = cur_keyset
    def '9' =
       universal cur_keyset
       sayerror 'Set Bookmark 9'
       'setmark 9'
       keys edit_keys
       .keyset = cur_keyset
    def esc = 
       universal cur_keyset
       sayerror 'cancel!'
       keys edit_keys
       .keyset = cur_keyset
    def otherkeys =
       universal cur_keyset
       sayerror 'key not accessed!'
       keys edit_keys
       .keyset = cur_keyset

--- All the second keys for Ctrl Q ...

defkeys ctrl_q_postfix base clear
    def 'f', 'a', 'F', 'A' =
       universal cur_keyset
       sayerror 'Search...'
       'searchdlg'
       keys edit_keys
       .keyset = cur_keyset
    def 'b', 'B' =
       universal cur_keyset
       sayerror 'Go to Begin of Block...'
       call pbegin_mark()
       keys edit_keys
       .keyset = cur_keyset
    def 'k', 'K' =
       universal cur_keyset
       sayerror 'Go to End of Block...'
       call end_of_mark()
       keys edit_keys
       .keyset = cur_keyset
    def 'l', 'L' =
       universal cur_keyset
       sayerror 'Undo...'
       'undo'
       keys edit_keys
       .keyset = cur_keyset
    def 'n', 'N' =
       universal cur_keyset
       sayerror 'Go to next Bookmark...'
       'nextbookmark'
       keys edit_keys
       .keyset = cur_keyset
    def 'p', 'P' =
       universal cur_keyset
       sayerror 'Pop Position...'
       'poppos'
       keys edit_keys
       .keyset = cur_keyset
    def 'v', 'V' =
       universal cur_keyset
       sayerror 'Go to previous Bookmark...'
       'nextbookmark P'
       keys edit_keys
       .keyset = cur_keyset
    def '0' =
       universal cur_keyset
       sayerror 'List Bookmarks...'
       'listmark'
       keys edit_keys
       .keyset = cur_keyset
    def '1' =
       universal cur_keyset
       sayerror 'Bookmark 1'
       'gomark 1'
       keys edit_keys
       .keyset = cur_keyset
    def '2' =
       universal cur_keyset
       sayerror 'Bookmark 2'
       'gomark 2'
       keys edit_keys
       .keyset = cur_keyset
    def '3' =
       universal cur_keyset
       sayerror 'Bookmark 3'
       'gomark 3'
       keys edit_keys
       .keyset = cur_keyset
    def '4' =
       universal cur_keyset
       sayerror 'Bookmark 4'
       'gomark 4'
       keys edit_keys
       .keyset = cur_keyset
    def '5' =
       universal cur_keyset
       sayerror 'Bookmark 5'
       'gomark 5'
       keys edit_keys
       .keyset = cur_keyset
    def '6' =
       universal cur_keyset
       sayerror 'Bookmark 6'
       'gomark 6'
       keys edit_keys
       .keyset = cur_keyset
    def '7' =
       universal cur_keyset
       sayerror 'Bookmark 7'
       'gomark 7'
       keys edit_keys
       .keyset = cur_keyset
    def '8' =
       universal cur_keyset
       sayerror 'Bookmark 8'
       'gomark 8'
       keys edit_keys
       .keyset = cur_keyset
    def '9' =
       universal cur_keyset
       sayerror 'Bookmark 9'
       'gomark 9'
       keys edit_keys
       .keyset = cur_keyset
    def esc = 
       universal cur_keyset
       sayerror 'cancel!'
       keys edit_keys
       .keyset = cur_keyset
    def otherkeys =
       universal cur_keyset
       sayerror 'key not accessed!'
       keys edit_keys
       .keyset = cur_keyset


--- All the second keys for Debug-Keyset...

defkeys debug_keys base clear
    def 'k', 'K' =
       universal cur_keyset
       universal cur_line
       universal cur_col
       winmessagebox( 'The current keyset:', cur_keyset, MB_OK + MB_INFORMATION + MB_MOVEABLE)
       keys edit_keys
       .keyset = cur_keyset
       .line = cur_line
       .col = cur_col
    def 's', 'S' =
       universal cur_keyset
       universal cur_line
       universal cur_col
       winmessagebox( 'My_Stack_cmds:', my_STACK_CMDS, MB_OK + MB_INFORMATION + MB_MOVEABLE)
       keys edit_keys
       .keyset = cur_keyset
       .line = cur_line
       .col = cur_col
    def 'e', 'E' =
       universal load_ext
       universal cur_keyset
       universal cur_line
       universal cur_col
       winmessagebox( 'The current load_ext:', load_ext, MB_OK + MB_INFORMATION + MB_MOVEABLE)
       keys edit_keys
       .keyset = cur_keyset
       .line = cur_line
       .col = cur_col
    def esc =
       universal cur_keyset
       universal cur_line
       universal cur_col
       sayerror 'cancel!'
       keys edit_keys
       .keyset = cur_keyset
       .line = cur_line
       .col = cur_col
    def otherkeys =
       universal cur_keyset
       universal cur_line
       universal cur_col
       sayerror 'key not accessed!'
       keys edit_keys
       .keyset = cur_keyset
       .line = cur_line
       .col = cur_col




--- Still unused stuff:

/*
overlay_marked_area()
keyin .filename
joinlines()
reflow_marked_area()
show_draw_chars()
reflow_marked_area()
mark_word_somehow_else()
beg_word()
end_word()
escape_key()
scroll_left()
scroll_right()
'findtag'
'findtag *'
'tagsfile'
'maketags *'
'nextview'
*/                    



